///////////////////////////////////////////////////////////////////////////////
//                      LOG 
//
// 2021-11-09
///////////////////////////////////////////////////////////////////////////////

#include "JLIB.H"
#include "DRIVER.H"
#include "MAIN.H"
#include "MONITOR.H"
#include "RFCommunication.h"
#include "LOG.H"


#define MAX_LOG_QTY             256


typedef struct _LOGSTRUCT
    {
    JTIME JTime;
    BYTE Content;
    BYTE DevNo;
    BYTE Prm1;
    BYTE Prm2;
    } LOGSTRUCT;


static LOGSTRUCT LogMemory[MAX_LOG_QTY];    //2048Byte
static int LogPutPos;


//-----------------------------------------------------------------------------
//      α ߰
//-----------------------------------------------------------------------------
VOID WINAPI LOG_Add(UINT Content, UINT DevNo, UINT Prm1, UINT Prm2)
    {
    LOGSTRUCT *L;

    if (LogPutPos>=MAX_LOG_QTY)
        {
        MoveMem(LogMemory, LogMemory+1, sizeof(LogMemory)-sizeof(LOGSTRUCT));
        LogPutPos=MAX_LOG_QTY-1;
        }
    L=LogMemory+LogPutPos;
    L->JTime=GetTodayToSecond();
    L->Content=Content;
    L->DevNo=DevNo;
    L->Prm1=Prm1;
    L->Prm2=Prm2;
    LogPutPos++;
    }



//-----------------------------------------------------------------------------
//      ǥ Ŷ̸ 
//-----------------------------------------------------------------------------
LOCAL(VOID) GetPacketTypeName(LPSTR Buff, UINT Prm1, UINT Prm2)
    {
    if (Prm1==PT_ROUTEDATA)
        {
        lstrcpy(Buff, "PT_ROUTEDATA (PT_");
        RFC_PacketTypeToText(GetStrLast(Buff), Prm2);
        AddCha(Buff, ')');
        }
    else{
        lstrcpy(Buff, "PT_");
        RFC_PacketTypeToText(GetStrLast(Buff), Prm1);
        wsprintf(GetStrLast(Buff), " P2=%d", Prm2);
        }
    }




//-----------------------------------------------------------------------------
//      α  ڿ
//-----------------------------------------------------------------------------
LOCAL(VOID) GetLogContentStr(int LogContent, LPSTR Buff, int BuffSize)
    {
    LPCSTR lp=NULL;

    switch (LogContent)
        {
        case LOG_POWERON: lp="Power On"; break;
        case LOG_POWEROFF: lp="Power Off"; break;
        case LOG_SENDPACKET: lp="Send RF"; break;
        case LOG_RECVPACKET: lp="Recv RF"; break;
        case LOG_RFMRECOVERY: lp="RFM Recoveryed"; break;
        case LOG_SETFIRESTATE: lp="SetFireState"; break;
        case LOG_SENDTIME: lp="SendTime"; break;
        case LOG_RECVTIME1: lp="RecvTime1"; break;
        case LOG_RECVTIME2: lp="RecvTime2"; break;
        }

    if (lp) lstrcpyn(Buff, lp, BuffSize);
    else    wsprintf(Buff, "Log#%d", LogContent);
    }




//-----------------------------------------------------------------------------
//      α ߰
//-----------------------------------------------------------------------------
LOCAL(VOID) LOG_Print(VOID)
    {
    int I;
    LOGSTRUCT *L;
    SYSTEMTIME ST;
    CHAR Buff[80];

    for (I=0; I<MAX_LOG_QTY; I++)
        {
        L=LogMemory+I;
        if (L->JTime==0) break;

        UnpackTotalSecond(&ST, L->JTime);
        MakeYMDHMS(Buff, &ST); AddCha(Buff, ' ');
        GetLogContentStr(L->Content, GetStrLast(Buff), 20); AddCha(Buff, ' ');
        if (L->Content==LOG_SENDPACKET || L->Content==LOG_RECVPACKET)
            {
            wsprintf(GetStrLast(Buff), "D=%d ", L->DevNo);
            GetPacketTypeName(GetStrLast(Buff), L->Prm1, L->Prm2);
            }
        else wsprintf(GetStrLast(Buff), "D=%d P1=%d P2=%d", L->DevNo, L->Prm1, L->Prm2);
        lstrcat(Buff, CrLfStr);
        Printf(Buff);
        }
    }




//-----------------------------------------------------------------------------
//      LOG 
//-----------------------------------------------------------------------------
int WINAPI Mon_Log(int PortNo, LPCSTR MonCmd, LPCSTR lpArg, LPCSTR CmdLine)
    {
    int  Rslt=MONRSLT_EXIT;

    if (lpArg[0]=='?') goto ProcExit;
    LOG_Print();

    ProcExit:
    return Rslt;
    }


