﻿
#define USE2NTC                 1   //0으로 하면 복합형에서 NTC가 1개인 코드로 컴파일함
#define NAMDONGPOWERPLANT       0   //남동발전 숙소용 볼케이노
#define NAMDONGCALLPOINT        0   //남동발전 무선 발신기/경종
#define ANIMALTEMPCONTROL       0   //축사가축최온관리기능, Ir온도카메라 사용
#define SENDIRTEMPIMAGE         0   //연기감지시 IR이미지 전송여부 (호주 데모)
#define CHECKCARRIER            0
#define COMMRANGETEST           0   //RFM 통달거리 테스트를 위해 깨어날 때마다 테스트화재를 발생시킴
#define VOCSENSOR               0   //데모용, Volatile Organic Compounds

#define KOREADEMO               0   //한국어 '화재발생', UAE자동복귀형, 연기감지기
#define SETUPCHANNELNO          0   //2018-03-08 26->0으로 변경
                                    //2018-07-04 0->26으로 변경 (호서텔렛때문)
                                    //2019-08-06 26->0으로 변경 (26번은 소방용으로 사용되기 때문, 호서텔렛 제외)
#define TELNOBUFFSIZE           16


typedef struct _SAVED_DATA
    {
    BYTE StartSign;         //'J' 이 설정이 저장된 Data의 시작을 알림
    BYTE DeviceNo;          //0~255 0이 수신기
    BYTE ChannelNo;         //26~32
    BYTE RFPower;           //0:3mW, 1:10mW, 2:25mW, 3:200mW
    DWORD GroupNo;
    BYTE RepeaterMode;
    BYTE CheckSum;
    }__attribute__((packed)) SAVED_DATA;


extern CONST CHAR InternalStr[];
extern SAVED_DATA SavedData;
extern BYTE MyReceiver;     //내가 보낸 메세지를 받아서 처리할 중계기
extern BYTE BoardID;        //이전보드에서 사용하던 ID
extern BYTE VolcanoBoardID; //볼케이노 PCB 종류 구분
extern BYTE DetectorType;   //센서종류
#define SMOKE_DETECTOR          0   //연기감지기
#define FIXED_HEAT_DETECTOR     1   //정온식
#define ROR_HEAT_DETECTOR       2   //차동식 ROR = Rate-Of-Rise
#define SMOKE_HEAT_DETECTOR     3   //열연기 복합형
#define FLAME_DETECTOR          4   //창성 불꽃감지기를 무선으로 송출할 때
#define CALLPOINT_DETECTOR      5   //수동콜포인트 (일본말로 발신기)
#define SMOKE_HEAT_CO_DETECTOR  6   //광전식+정온식+CO (과제용)


//BoardID 정의 (볼케이노 외 보드에서 사용)
#define MOGWA_BOARD     0   //모과형보드 (상시전원과 배터리전용 겸용)
#define GSENSOR_BOARD   1   //절개지 붕괴 감지 보드
#define ONLYBATTERY     2   //오직 배터리만 동작하는 모드
#define ACPOWERMODE     3   //상시전원+보조전원
#define RS485_BOARD     4   //상시전원만 (예전보드)
#define SPIRFM_BOARD    5   //SPI 규격 AUTOMAN 모듈 장착한 보드

//ID3 ID2 ID1
//  0   0   0  모과형보드, 회로엔 ID3==0로 연결되어 있지만 처리하지 않음
//  0   0   1  절개지붕괴감지보드, 회로엔 ID3==0로 연결되어 있지만 처리하지 않음
//  x   1   0  오직 배터리만 동작하는 모드
//  x   1   1  485RX핀==1이면 예전 상시전원 485보드
//             485RX핀==0이면 상시전원+보조전원보드(연결되지 않은 핀이기 때문)

//VolcanoBoardID--------------PI_BOARD_ID3(PA7)--PI_BOARD_ID2(PB3)------PI_BOARD_ID1(PB4)
#define VKBOARD_KOR     0   //PI_BOARD_ID3=0, PI_BOARD_ID2=0, KFI       0:Smoke/1:Heat
#define VKBOARD_UAE     1   //PI_BOARD_ID3=0, PI_BOARD_ID2=1, UAE       0:Smoke/1:Heat
#define VKBOARD_THAI    2   //PI_BOARD_ID3=1, PI_BOARD_ID2=0, Thailand  0:Smoke/1:Heat
#define VKBOARD_Ext     3   //PI_BOARD_ID3=1, PI_BOARD_ID2=1, Analog ID확장  PA7을 Analog입력으로 전환하여 Vdd기준 16등분하여 ID로 사용
#define VKBOARD_UAEALONE   4    //0.0V 0x000 UAE 단독형 연기감지기 (Analog 입력을 GND에 연결)
                                //0.3V 0x180 UAE 단독형 열감지기
#define VKBOARD_PIR        5    //0.5V 0x280 호주 화장실 쓰러짐 감지기능 포함 연기감지기
                                //0.7V 0x380 호주 화장실 쓰러짐 감지기능 포함 열감지기
#define VKBOARD_ELECLEAK   6    //0.9V 0x480 서진테크놀러지 누전경보기
                                //1.1V 0x580 KFI 열연기 복합형, VolcanoBoardID는 VKBOARD_KOR 사용

#define VKBOARD_KOR_NEW    8    //1.9V 0x980 KFI 차동식, VolcanoTempType=1(차동식)로 하고 VolcanoBoardID는 VKBOARD_KOR 사용


//STM32L073 아날로그 보드 ID
//  0.0V 0x000 0Ohm  UAE 단독형 연기감지기
//  0.3V 0x180 1.0K  UAE 단독형 열감지기
//  0.5V 0x280 1.82K 호주 화장실 쓰러짐 감지기능 포함 연기감지기
//  0.7V 0x380 2.8K  호주 화장실 쓰러짐 감지기능 포함 열감지기

//-------PA7--------|--------PA5--------- 2020-07-15 Analog 보드ID추가 (PA5) ... 기존에 PA5를 사용한적이 없으므로 내부 풀업하여 입력포트로 읽었을 때 1이면 Analog 보드ID2로 사용
//  0.9V 0x480 3.9K |........0V.......... 서진테크놀러지 누전경보기
//  1.1V 0x580 5.23K|........0V.......... KFI 열연기 복합형
//  1.3V 0x680 6.8K | 0.0V 0x000 0Ohm ... 창성 가스감지기(농도)
//  1.3V 0x680 6.8K | 0.3V 0x180 1.0K ... 창성 누액감지기 송신기
//  1.3V 0x680 6.8K | 0.5V 0x280 1.82K... 누액감지기 수신기
//  1.5V 0x780 9.1K (8.8K)... Reserved
//  1.7V 0x880 11K  |........0V.......... 2021-02-25 KFI 정온식감지기, 정밀RTC 추가
//  1.9V 0x980 15K  |........0V.......... 2020-10-29 KFI 차동식감지기, 정밀RTC 추가, ID는 VKBOARD_KOR 사용, VolcanoTempType의 값을 1로 설정함



//저항값계산 0x580*10K/(0x0FFF-0x580)   = 5.23K
//ADC출력값  5.23K*0x0FFF / (10K+5.23K) = 0x57E
//전압계산   3.3V * 0x580 / 0x0FFF      = 1.1V



struct _RF_PACKET;
typedef struct _RF_PACKET RF_PACKET;

int  WINAPI GetAntenna(VOID);
VOID WINAPI SetAntenna(int Mode);
VOID WINAPI GoSleepMode(VOID);
int  WINAPI GetBatteryStatus(VOID);

VOID WINAPI RxLedOn(VOID);
VOID WINAPI TxLedControl(int Mode);
//Mode
#define TXLED_OFF   0
#define TXLED_WINK  1   //빠르게 깜빡거림
#define TXLED_FLASH 2   //1회 번쩍임

VOID WINAPI SelectAntenna(int Mode);
//Mode
#define INTERNALANTENNA 0
#define EXTERNALANTENNA 1

VOID WINAPI SetRegHigh(VOID);
VOID WINAPI AuxIoControl(LPBYTE RetData, LPCBYTE SetData);
int  WINAPI SetSecurity(LPBYTE RetData, LPCBYTE SetData, int Len);
VOID WINAPI SensorSetting(int *lpSetData1, int *lpSetData2);
VOID WINAPI SetSendInterval(int Second);
VOID WINAPI GetSensorTempAlarm(int *lpSensorFlag, int *lpLowTemp, int *lpHighTemp);
VOID WINAPI SetSensorTempAlarm(int SensorFlag, int LowTemp, int HighTemp);
VOID WINAPI GetSensorCOAlarm(int *lpSensorFlag, int *lpHighAlarm);
VOID WINAPI SetSensorCOAlarm(int SensorFlag, int HighAlarm);
LPSTR WINAPI MakeSecAckStr(LPSTR Buff, LPCBYTE Data, int Len);
LPSTR WINAPI MakeAutoSecStr(LPSTR Buff, DWORD Dw);
BOOL WINAPI SetBreakdown(BOOL En);
BOOL WINAPI SetFirePreDetect(BOOL En);
BOOL WINAPI SetSmokeSupplement(BOOL En);
BOOL WINAPI SetManualSecurity(BOOL En);
DWORD WINAPI SetAutoSecurity(BOOL En, int StartTime, int EndTime);
DWORD WINAPI SetWakeupInterval(DWORD Sec);
int   WINAPI SetFireDetectPolicy(int Policy);
BOOL  WINAPI SensorTempAlarmRF(int *lpSensorFlag, int *lpLowTemp, int *lpHighTemp);
VOID WINAPI PrintMainVar(VOID);
VOID WINAPI SetExtSensorValue(LPCSTR SenKind, LPCSTR Prm);
DWORD WINAPI GetEncrypCode(VOID);
LPCBYTE WINAPI GetAesEncrypCode(VOID);
VOID WINAPI SetPowerOffWaitTime(int Sec);
int  WINAPI GetDiagState(VOID);
//GetDiagState()의 리턴값
#define DIAGSTAT_FIRE_MSK       0x0003
#define DIAGSTAT_BATT_MSK       0x0070  //보조전원 상태

#define DIAGSTAT_FIRE_BIT       0   //(2)
#define DIAGSTAT_BATT_BIT       4   //(3)


VOID WINAPI SetFireState(BOOL State);
VOID WINAPI RingBell(int OnOff);
#define BELL_OFF        0
#define BELL_ON         1
#define BELL_SHORTON    2

int  WINAPI SetExchangeHeatFg(int Mode);
int  WINAPI SetDemoMode(int Mode);
int  WINAPI GetSensorDetectLevel(VOID);
int  WINAPI GetDetectConstTemp(VOID);
int  WINAPI GetDetectTempDiff(VOID);

VOID WINAPI RFMMISO_SetInput(VOID);
VOID WINAPI RFMMISO_SetSPI(VOID);
VOID WINAPI ReadTempHumi(int *lpTemp, int *lpHumi);
VOID WINAPI PlaySound(LPCBYTE Data);
VOID WINAPI SaveInternalData(VOID);
VOID WINAPI SetOftenCheckFg(BOOL Fg);
VOID WINAPI SetNeedReplyStateFg(VOID);
int  WINAPI MeasureVdd(int AdcCal);
VOID WINAPI PostAlivePacket(VOID);
VOID WINAPI SendSyncTime(int Sec);
int  WINAPI GetNoReplyAlarm(VOID);
VOID WINAPI SetNoReplyAlarm(int NewValue);
BOOL WINAPI IsSpiRfmBoard(VOID);
BOOL WINAPI IsUseHighPrecisionRtc(VOID);
BOOL WINAPI IsUseLowResistNtc(VOID);
BOOL WINAPI IsSendTimeITP(VOID);
BOOL WINAPI IsRecvCollectAckTime(VOID);
LPVOID WINAPI GetIniSavePtr(VOID);      //할당된 플래시 주소를 리턴
int  WINAPI GetDeviceRegOrder(VOID);

//#define MEMOWNER_JLIB         1
#define MEMOWNER_WCDMA          50
#define MEMOWNER_JOS            60
#define MEMOWNER_ROLA           70
#define MEMOWNER_INIDATA        80
#define MEMOWNER_MAIN           100




