
#include "JLIB.H"
#include "DRIVER.H"
#ifdef USE_JOS
#include "JOS.H"
#endif
#include "MONITOR.H"
#if INIFILE_EN
#include "INIDATA.H"
#endif

#define CR      13


int  DebugCnt;
BYTE MON_ECHO_ENABLE;   //ٸ ġ  ͹̳η ҷ Echo 
BYTE SysDebugFg;
BYTE HostConnected;     // ȣƮ  
BYTE ExistDebugInput;   //ſ Է½ȣ ִ
BYTE MonUseComPort;
#ifdef THREADTEST
JOS_EVENT *TestSem1, *TestSem2, *TestSem3, *TestSem4;
#endif



#if INIFILE_EN
#ifdef SECURE_CODE
static CONST CHAR PswStr[]="Psw";
static CONST CHAR SoltStr[]="Color";
#endif
       CONST CHAR DebugExpireStr[]="DebugExpire";
#endif


#ifdef SECURE_CODE
#include "SHA256.H"
static BYTE MonitorLogin;
#define LOGIN_NEED          0
#define LOGIN_NEWPSW        1
#define LOGIN_CONFIRMPSW    2
#define LOGIN_CHANGEPSW     3
#define LOGIN_OK            4
#define PSWSOLTENCCODE      0xD7F9AB5C
#endif




//-----------------------------------------------------------------------------
//      øƮ ޸𸮸 մϴ
//-----------------------------------------------------------------------------
VOID WINAPI DumpMem(LPCVOID lpMem, UINT ViewSize)
    {
    int  I;
    WORD Ofs=0;
    BYTE Byt;
    CHAR  Buff[64], Strs[20];

    while (ViewSize>0)
        {
        Strs[0]=0;
        Jsprintf(Buff, "%04X  ", Ofs);
        for (I=0; I<16 && ViewSize>0; I++)
            {
            Byt=*((BYTE*)lpMem+Ofs); Ofs++;
            Jsprintf(GetStrLast(Buff), " %02X", Byt);
            AddCha(Strs, Byt>' ' && Byt<0x80 ? Byt:' ');
            ViewSize--;
            }
        while (lstrlen(Buff)<56) AddCha(Buff, ' ');
        Printf(Buff);
        Printf("%s"CRLF, Strs); //Strsȿ '%' ϴ Ĺڿ   
        }
    }



//-----------------------------------------------------------------------------
//      Data ڸ 
//-----------------------------------------------------------------------------
LOCAL(int) GetDataSizeChar(int Mode)
    {
    CHAR Cha=' ';

    switch (Mode)
        {
        case 0: Cha='B'; break;
        case 1: Cha='W'; break;
        case 2: Cha='D';
        }
    return Cha;
    }


//-----------------------------------------------------------------------------
//      Data  
//-----------------------------------------------------------------------------
LOCAL(LPCSTR) GetDataSize(LPCSTR MonCmd, LPBYTE lpMode)
    {
    int Len=0;

    switch (UpCaseCha(MonCmd[0]))
        {
        case 'B': Len++; *lpMode=0; break;
        case 'W': Len++; *lpMode=1; break;
        case 'D': Len++; *lpMode=2;
        }
    return SkipSpace(MonCmd+Len);
    }



//-----------------------------------------------------------------------------
//              Port Input Cmd Monitor
//-----------------------------------------------------------------------------
LOCAL(int) Mon_Input(int PortNo, LPCSTR MonCmd, LPCSTR lpArg, LPCSTR CmdLine)
    {
    int I, Rslt=MONRSLT_SYNTAXERR;
    UINT Addr;
    static BYTE InputMode;

    if (lpArg[0]=='?')
        {
        Printf("I[B|W|D] Addr"CRLF);
        Rslt=MONRSLT_EXIT;
        goto ProcExit;
        }
    lpArg=GetDataSize(lpArg, &InputMode);
    //if ((Addr=IsSFR(lpArg))!=0) lpArg=NextWord(lpArg);
    //else{
        Addr=AtoH(lpArg, &I); if (I==0) goto ProcExit;
        lpArg=SkipSpace(lpArg+I);
        //}
    if (lpArg[0]!=0) goto ProcExit;
    switch (InputMode)
        {
        case 0: Printf("%02X=InB(%X)"CRLF, *(BYTE*)Addr, Addr); break;
        case 1: Printf("%04X=InW(%X)"CRLF, *(WORD*)Addr, Addr); break;
        case 2: Printf("%08X=InD(%X)"CRLF, *(DWORD*)Addr, Addr); //break;
        }
    Rslt=MONRSLT_OK;

    ProcExit:
    return Rslt;
    }



//-----------------------------------------------------------------------------
//      SFR or Memory Output Cmd Monitor
//-----------------------------------------------------------------------------
LOCAL(int) Mon_Output(int PortNo, LPCSTR MonCmd, LPCSTR lpArg, LPCSTR CmdLine)
    {
    int I, Rslt=MONRSLT_SYNTAXERR;
    volatile UINT Addr;
    UINT Data, S1=0, S2;
    static BYTE OutputMode;

    if (lpArg[0]=='?')
        {
        Printf("O[B|W|D] Addr Data [L Repeat]"CRLF);
        Rslt=MONRSLT_EXIT;
        goto ProcExit;
        }

    lpArg=GetDataSize(lpArg, &OutputMode);
    //if ((Addr=IsSFR(lpArg))!=0) lpArg=NextWord(lpArg);
    //else{
        Addr=AtoH(lpArg, &I); if (I==0) goto ProcExit;
        lpArg=SkipSpace(lpArg+I);
        //}
    if (lpArg[0]==0) goto ProcExit;
    Data=AtoH(lpArg, &I); lpArg=SkipSpace(lpArg+I);
    if (lpArg[0]==0)
        {
        switch (OutputMode)
            {
            case 0: *(BYTE*)Addr=Data;  S1=*(BYTE*)Addr; break;
            case 1: *(WORD*)Addr=Data;  S1=*(WORD*)Addr; break;
            case 2: *(DWORD*)Addr=Data; S1=*(DWORD*)Addr; //break;
            }
        Printf("Out%c %08X,%02X [%02X]"CRLF, GetDataSizeChar(OutputMode), Addr, Data, S1);
        }
    else if (UpCaseCha(lpArg[0])=='L')
        {
        S2=AtoH(SkipSpace(lpArg+1), NULL);
        for (S1=0; S1<S2; S1++)
            switch (OutputMode)
                {
                case 0: *(BYTE*)Addr=Data; break;
                case 1: *(WORD*)Addr=Data; break;
                case 2: *(DWORD*)Addr=Data; //break;
                }
        Printf("Out%c %08X,%02X Rep:%02X"CRLF, GetDataSizeChar(OutputMode), Addr, Data, S2);
        }
    else goto ProcExit;

    Rslt=MONRSLT_OK;

    ProcExit:
    return Rslt;
    }



//-----------------------------------------------------------------------------
//      ̸ ؼ
//-----------------------------------------------------------------------------
LOCAL(int) AnalysisPinName(LPCSTR lpArg, int *NextLoc)
    {
    UINT PinNo, Port;

    if (UpCaseCha(lpArg[0])=='P')
        {
        Port=UpCaseCha(lpArg[1])-'A';
        PinNo=AtoI(lpArg+2, NextLoc);
        *NextLoc+=2;
        PinNo+=Port<<4;
        if (PinNo>=I2CPORT) *NextLoc=0;
        }
    else{
        PinNo=AtoI(lpArg, NextLoc);
        }
    return PinNo;
    }



//-----------------------------------------------------------------------------
//          GPIO ɼ
//-----------------------------------------------------------------------------
int WINAPI Mon_SetGpio(int PortNo, LPCSTR MonCmd, LPCSTR lpArg, LPCSTR CmdLine)
    {
    int I, PinNo, Rslt=MONRSLT_SYNTAXERR;

    if (lpArg[0]=='?')
        {
        Printf("GPIO PinName INPU/INPD/INNP/OUTPPL/OUTPPH/OUTODL/OUTODH/OUTODHPU/OUTODHPD"CRLF);
        Rslt=MONRSLT_EXIT;
        goto ProcExit;
        }

    PinNo=AnalysisPinName(lpArg, &I); if (I==0) goto ProcExit;
    lpArg=SkipSpace(lpArg+I);

    if (lpArg[0]==0) goto ProcExit;

    Rslt=MONRSLT_OK;
    if      (lstrcmpi(lpArg, "INNP")==0) InitPort(PinNo, GPIO_MODE_INPUT, GPIO_NOPULL, 0);
    else if (lstrcmpi(lpArg, "INPU")==0) InitPort(PinNo, GPIO_MODE_INPUT, GPIO_PULLUP, 0);
    else if (lstrcmpi(lpArg, "INPD")==0) InitPort(PinNo, GPIO_MODE_INPUT, GPIO_PULLDOWN, 0);
    else if (lstrcmpi(lpArg, "OUTPPL")==0)    InitPort(PinNo, GPIO_MODE_OUTPUT_PP, GPIO_NOPULL, 0);
    else if (lstrcmpi(lpArg, "OUTPPH")==0)   {InitPort(PinNo, GPIO_MODE_OUTPUT_PP, GPIO_NOPULL, 0); PortOut(PinNo, HIGH);}
    else if (lstrcmpi(lpArg, "OUTODL")==0)    InitPort(PinNo, GPIO_MODE_OUTPUT_OD, GPIO_NOPULL, 0);
    else if (lstrcmpi(lpArg, "OUTODH")==0)   {InitPort(PinNo, GPIO_MODE_OUTPUT_OD, GPIO_NOPULL, 0); PortOut(PinNo, HIGH);}
    else if (lstrcmpi(lpArg, "OUTODHPU")==0) {InitPort(PinNo, GPIO_MODE_OUTPUT_OD, GPIO_PULLUP, 0); PortOut(PinNo, HIGH);}
    else if (lstrcmpi(lpArg, "OUTODHPD")==0) {InitPort(PinNo, GPIO_MODE_OUTPUT_OD, GPIO_PULLDOWN, 0); PortOut(PinNo, HIGH);}
    else Rslt=MONRSLT_SYNTAXERR;

    ProcExit:
    return Rslt;
    }




//-----------------------------------------------------------------------------
//      Port Out
//-----------------------------------------------------------------------------
LOCAL(int) Mon_PortOut(int PortNo, LPCSTR MonCmd, LPCSTR lpArg, LPCSTR CmdLine)
    {
    int I, PinNo, Data, Rslt=MONRSLT_SYNTAXERR;

    if (lpArg[0]=='?')
        {
        Printf("PO PinNo 0|1|2|3 (2:Not, 3:GetState)"CRLF);
        Rslt=MONRSLT_EXIT;
        goto ProcExit;
        }

    PinNo=AnalysisPinName(lpArg, &I); if (I==0) goto ProcExit;
    lpArg=SkipSpace(lpArg+I);

    if (lpArg[0]==0) goto ProcExit;
    Data=AtoI(lpArg, &I);

    if (Data!=3)
        {
        PortOut(PinNo, Data);
        Rslt=MONRSLT_OK;
        }
    else{
        Printf("GetState=%d"CRLF, PortOut(PinNo, Data));
        Rslt=MONRSLT_EXIT;
        }

    ProcExit:
    return Rslt;
    }



//-----------------------------------------------------------------------------
//      Port In
//-----------------------------------------------------------------------------
LOCAL(int) Mon_PortIn(int PortNo, LPCSTR MonCmd, LPCSTR lpArg, LPCSTR CmdLine)
    {
    int I, PinNo, Rslt=MONRSLT_SYNTAXERR;

    if (lpArg[0]=='?')
        {
        Printf("PI PinNo"CRLF);
        Rslt=MONRSLT_EXIT;
        goto ProcExit;
        }

    PinNo=AnalysisPinName(lpArg, &I); if (I==0) goto ProcExit;
    Printf("%d"CRLF, PortIn(PinNo));
    Rslt=MONRSLT_EXIT;          //'OK' 

    ProcExit:
    return Rslt;
    }



//-----------------------------------------------------------------------------
//      RS232
//-----------------------------------------------------------------------------
#define LET_CR      0
#define LET_LF      1
#define LET_CRLF    2
#define OUTLET_ASITIS   0
#define OUTLET_ADDLF    1
LOCAL(int) Mon_Rs232(int SrcPortNo, LPCSTR MonCmd, LPCSTR lpArg, LPCSTR CmdLine)
    {
    int  I, J, Rslt=MONRSLT_SYNTAXERR, DestPort, Baudrate, LET=LET_CRLF, OLET=OUTLET_ASITIS, Idle;
    CHAR Opt[8];

    MonUseComPort=1;
    if (lpArg[0]=='?')
        {
        Printf("COMn [Baudrate] [NOLF/LF/ADDLF] ... Serial Output"CRLF);
        Rslt=MONRSLT_EXIT;
        goto ProcExit;
        }

    DestPort=AtoI(lpArg, &J); lpArg=SkipSpace(lpArg+J);
    if (J==0 || DestPort<1 || DestPort>8) goto ProcExit;
    DestPort--;

    Baudrate=AtoI(lpArg, &J);
    if (J>0)
        {
        if (Baudrate==0) goto ProcExit;
        UART_SetBaudrate(DestPort, Baudrate);
        }

    lpArg=SkipSpace(lpArg+J);
    while (lpArg[0]!=0)
        {
        lpArg=ScanWord(lpArg, Opt, sizeof(Opt));
        if (lstrcmpi(Opt, "NOLF")==0) LET=LET_CR;
        else if (lstrcmpi(Opt, "LF")==0) LET=LET_LF;
        else if (lstrcmpi(Opt, "ADDLF")==0) OLET=OUTLET_ADDLF;
        else goto ProcExit;
        }

    Printf("COM%d Baudrate=%u" CRLF, DestPort+1, UART_GetBaudrate(DestPort));
    Printf("Line End = %s" CRLF, GetToken("CR\0LF\0CRLF", LET));
    Printf("Press [ESC] to exit..."CRLF);

    UART_OutRTS(DestPort, 0);
    UART_OutDTR(DestPort, 0);

    for (;;)
        {
        Idle=0;
        UART_DisplayError();
        if ((I=UART_RxByteIT(DestPort))>=0)
            {
            UART_TxByteIT(SrcPortNo, I);
            if (I==13 && OLET==OUTLET_ADDLF) UART_TxByteIT(SrcPortNo, 10);
            }
        else Idle++;

        if ((I=UART_RxByteIT(SrcPortNo))>=0)
            {
            if (I==0x1B) {Printf(CrLfStr); Rslt=MONRSLT_OK; break;}
            else if (I==13)  //EnterŰ
                {
                if      (LET==LET_CR) UART_TxByteIT(DestPort, 13);
                else if (LET==LET_LF) UART_TxByteIT(DestPort, 10);
                else {UART_TxByteIT(DestPort, 13); UART_TxByteIT(DestPort, 10);}
                }
            else UART_TxByteIT(DestPort, I);
            }
        else Idle++;

        #ifdef USE_JOS
        if (Idle==2) Sleep(1);
        #endif
        }

    Printf("Exit COM%d Test..."CRLF, DestPort+1);

    ProcExit:
    MonUseComPort=0;
    return Rslt;
    }



//-----------------------------------------------------------------------------
//      CTS б
//-----------------------------------------------------------------------------
LOCAL(int) Mon_DispCtsStatus(int PortNo, LPCSTR MonCmd, LPCSTR lpArg, LPCSTR CmdLine)
    {
    int J, Rslt=MONRSLT_SYNTAXERR, ComPort;

    if (lpArg[0]=='?')
        {
        Printf("CTSn ... Display CTS Status"CRLF);
        Rslt=MONRSLT_EXIT;
        goto ProcExit;
        }

    ComPort=AtoI(lpArg, &J); lpArg=SkipSpace(lpArg+J);
    if (J==0 || ComPort<1 || ComPort>8) goto ProcExit;
    ComPort--;

    Printf("CTS=%d RTS=%d DSR=%d DTR=%d Baud=%u"CRLF,
           UART_InCTS(ComPort)!=0,
           UART_OutRTS(ComPort, PO_GETSTATE)!=0,
           UART_InDSR(ComPort)!=0,
           UART_OutDTR(ComPort, PO_GETSTATE)!=0, UART_GetBaudrate(ComPort));
    //UART_DispReg(ComPort);

    Rslt=MONRSLT_EXIT;

    ProcExit:
    return Rslt;
    }



//-----------------------------------------------------------------------------
//      
//-----------------------------------------------------------------------------
LOCAL(int) Mon_Boot(int PortNo, LPCSTR MonCmd, LPCSTR lpArg, LPCSTR CmdLine)
    {
    if (lpArg[0]!='?') SystemReset("User Booting"CRLF);
    return MONRSLT_EXIT;
    }



//-----------------------------------------------------------------------------
//      Goto
//-----------------------------------------------------------------------------
LOCAL(int) Mon_Goto(int PortNo, LPCSTR MonCmd, LPCSTR lpArg, LPCSTR CmdLine)
    {
    int  J, Rslt=MONRSLT_SYNTAXERR;
    UINT Addr=~0;
    ft   Pgm;
    JOS_CRITICAL_VAR;

    if (lpArg[0]=='?')
        {
        Printf("GO [Hex Addr] ... Jump Exec"CRLF);
        Rslt=MONRSLT_EXIT;
        goto ProcExit;
        }

    if (lpArg[0]!=0)
        {
        Addr=AtoH(lpArg, &J);
        if (J==0) goto ProcExit;
        }
    else Addr=*(DWORD*)(FLASH_BASE+4);

    Pgm=(ft)Addr;
    JOS_ENTER_CRITICAL();
    Pgm();
    JOS_EXIT_CRITICAL();    //CpuSR Ƚٴ  

    ProcExit:
    return Rslt;
    }



//-----------------------------------------------------------------------------
//      ECho On/Off
//-----------------------------------------------------------------------------
LOCAL(int) Mon_EchoOnOff(int PortNo, LPCSTR MonCmd, LPCSTR lpArg, LPCSTR CmdLine)
    {
    int Rslt=MONRSLT_SYNTAXERR;

    if (lpArg[0]=='?')
        {
        Printf("ECHO ON/OFF ... Echo On/Off"CRLF);
        Rslt=MONRSLT_EXIT;
        goto ProcExit;
        }

    if (lstrcmpi(lpArg, "ON")==0)
        {
        EchoEnableFg=1;
        Rslt=MONRSLT_OK;
        goto ProcExit;
        }

    if (lstrcmpi(lpArg, "OFF")==0)
        {
        EchoEnableFg=0;
        Rslt=MONRSLT_OK;
        goto ProcExit;
        }

    ProcExit:
    return Rslt;
    }



//-----------------------------------------------------------------------------
//      main()Լ ߿  ÷ ǥ
//-----------------------------------------------------------------------------
extern UINT Stack_Mem[1];
extern UINT __initial_sp[1];
LOCAL(VOID) DispBootStack(VOID)
    {
    int   Free=0;
    UINT *lp;

    lp=Stack_Mem;
    while (*lp++==0) Free++;
    Printf("Boot Stack: %X-%X (Use=%u, Free=%u)"CRLF, Stack_Mem, __initial_sp, (__initial_sp-Stack_Mem-Free)*sizeof(UINT), Free*sizeof(UINT));
    }



#ifdef JOS_VERSION
//-----------------------------------------------------------------------------
//      Task ǥ
//-----------------------------------------------------------------------------
LOCAL(int) Mon_TaskInfo(int PortNo, LPCSTR MonCmd, LPCSTR lpArg, LPCSTR CmdLine)
    {
    int Prio, FreeBytes, Rslt=MONRSLT_SYNTAXERR;

    if (lpArg[0]=='?')
        {
        Printf("S ... View Task List"CRLF);
        Rslt=MONRSLT_EXIT;
        goto ProcExit;
        }

    if (lpArg[0]!=0) goto ProcExit;

    for (Prio=0; Prio<=PRIO_IDLETASK; Prio++)
        {
        #if JOS_VERSION==101
        JOS_TCB TCB;

        if (JOSTaskQuery(Prio, &TCB)==JOS_ERR_NONE)
            Printf("Prio=%2d %-8s%3d%% Use=%5d Free=%5d SP=%08X PC=%08X xPSR=%08X"CRLF,
                         Prio, TCB.TcbTaskName, TCB.TcbCpuUsage,
                         TCB.TcbStkSize-TCB.TcbStkFree, TCB.TcbStkFree,
                         TCB.TcbStkPtr, TCB.TcbStkPtr[14], TCB.TcbStkPtr[15]);
        #else
        JOS_STK_DATA SD;

        if (JOSTaskStkChk(Prio, &SD)==JOS_ERR_NONE)
            {
            JOS_TCB TCB;
            JOSTaskQuery(Prio, &TCB);
            Printf("Prio=%2d %-8s%3d%% Use=%5d Free=%5d SP=%08X PC=%08X xPSR=%08X"CRLF,
                         Prio, TCB.lpExt==NULL ? NullStr:TCB.lpExt, TCB.CpuUsage,
                         SD.StackUsed, SD.StackFree,
                         TCB.StackPtr, TCB.StackPtr[10], TCB.StackPtr[11]);
            }
        #endif
        }
    //Printf(COM1, "CPU=%02d%% HeapFree=%,lXh DebugCnt=%d UI=%d%% VMFree=%,06lX"CRLF, JOSCpuUsage, GetLargestBlock(), DebugCnt,
    //       GetFreeSystemResources(GFSR_GDIRESOURCES), AllocVMem(-1));
    FreeBytes=GetMemFree(NULL, &Rslt, NULL);
    if (Rslt==MA_BROKENMCB) Printf("Broken Main Memory"CRLF);
    else if (Rslt!=0) Printf("Main Memory Error"CRLF);
    else Printf("MainMemFree=%Xh"CRLF, FreeBytes);

    #ifdef LCD_VRAM_START
    FreeBytes=GetVMemFree(NULL, &Rslt, NULL);
    if (Rslt==MA_BROKENMCB) Printf("Broken Video Memory"CRLF);
    else if (Rslt!=0) Printf("Video Memory Error"CRLF);
    else Printf("VideoMemFree=%Xh"CRLF, FreeBytes);
    #endif

    DispBootStack();

    Printf("CPU=%02d%% TickCnt=%d DebugCnt=%d"CRLF, JOSCpuUsage, GetTickCount(), DebugCnt);

    Rslt=MONRSLT_OK;

    ProcExit:
    return Rslt;
    }
#endif



#if INIFILE_EN
//-----------------------------------------------------------------------------
//      GetPrivateProfileString() Լ ׽Ʈ
//      INI SecName VarName [Value] ... Value ָ о
//-----------------------------------------------------------------------------
LOCAL(int) Mon_IniData(int PortNo, LPCSTR MonCmd, LPCSTR lpArg, LPCSTR CmdLine)
    {
    int Rslt=MONRSLT_SYNTAXERR;
    CHAR SectionName[20], EntryName[20], Buff[80];

    if (lpArg[0]=='?')
        {
        PrintfII(PortNo, "INI ... View all Ini Data"CRLF);
        PrintfII(PortNo, "INI CLEAR ... All Clear Ini Data"CRLF);
        PrintfII(PortNo, "INI FLUSH ... Save to Flash"CRLF);
        PrintfII(PortNo, "INI SecName VarName [Value] ... Set Ini Data, No Value is Read"CRLF);
        Rslt=MONRSLT_EXIT;
        goto ProcExit;
        }

    if (lpArg[0]==0)
        {
        PrintAllIniData(PortNo, IniFileName);
        Rslt=MONRSLT_OK;
        goto ProcExit;
        }

    if (lstrcmpi(lpArg, "CLEAR")==0)
        {
        EraseAllIniData();
        Rslt=MONRSLT_OK;
        goto ProcExit;
        }

    if (lstrcmpi(lpArg, "FLUSH")==0)
        {
        FlushIniFile();
        Rslt=MONRSLT_OK;
        goto ProcExit;
        }

    lpArg=ScanWord(lpArg, SectionName, sizeof(SectionName));
    lpArg=ScanWord(lpArg, EntryName, sizeof(EntryName));
    if (EntryName[0]==0) goto ProcExit;
    if (lpArg[0]!=0)
        {
        #ifdef SECURE_CODE
        if (lstrcmp(SectionName, ConfigStr)==0 && (lstrcmp(EntryName, PswStr)==0 || lstrcmp(EntryName, SoltStr)==0)) goto ProcExit;
        #endif
        WriteIniStr(SectionName, EntryName, lstrcmp(lpArg, "\"\"")!=0 ? lpArg:NullStr);
        Rslt=MONRSLT_OK;
        }
    else{
        GetIniStr(SectionName, EntryName, Buff, sizeof(Buff));
        PrintfII(PortNo, "Value='%s'"CRLF, Buff);
        Rslt=MONRSLT_EXIT;
        }

    ProcExit:
    return Rslt;
    }
#endif



//-----------------------------------------------------------------------------
//      ޸ 
//-----------------------------------------------------------------------------
LOCAL(int) Mon_DumpMem(int PortNo, LPCSTR MonCmd, LPCSTR lpArg, LPCSTR CmdLine)
    {
    int   I, Len, Rslt=MONRSLT_SYNTAXERR;
    UINT  Addr, Data;
    LPCSTR lp;
    CHAR  Buff[80];
    static BYTE DumpMode;
    static UINT DumpAdd=SRAM_BASE;

    if (lpArg[0]=='?')
        {
        Printf("D[B|W|D] Addr [L len]"CRLF);
        Rslt=MONRSLT_EXIT;
        goto ProcExit;
        }

    lp=GetDataSize(lpArg, &DumpMode);
    Addr=DumpAdd; Len=0x80;
    if (lp[0]!=0)
        {
        Addr=AtoH(lp, &I); lp=SkipSpace(lp+I);
        if (UpCaseCha(lp[0])=='L') Len=AtoH(SkipSpace(lp+1), NULL);
        else if (lp[0]!=0) goto ProcExit;
        }

    for (I=0; I<Len;)
        {
        if ((I & 0xF)==0) {Printf("%08X ", Addr); Buff[0]=0;}
        switch (DumpMode)
            {
            case 0:
                Data=*(LPBYTE)Addr; Addr++; I++;
                Printf(" %02X", Data);
                AddCha(Buff, CatchAscii(Data));
                break;

            case 1:
                Data=*(WORD*)Addr; Addr+=2; I+=2;
                Printf(" %04X", Data);
                AddCha(Buff, CatchAscii(LoByte(Data)));
                AddCha(Buff, CatchAscii(HiByte(Data)));
                break;

            case 2:
                Data=*(DWORD*)Addr; Addr+=4; I+=4;
                Printf(" %08X", Data);
                AddCha(Buff, CatchAscii(LongByte0(Data)));
                AddCha(Buff, CatchAscii(LongByte1(Data)));
                AddCha(Buff, CatchAscii(LongByte2(Data)));
                AddCha(Buff, CatchAscii(LongByte3(Data)));
            }
        if ((I & 0xF)==0) Printf("  %s"CRLF, Buff);
        }
    if ((I & 0xF)!=0) Printf("  %s"CRLF, Buff);

    DumpAdd=Addr;
    Rslt=MONRSLT_EXIT;

    ProcExit:
    return Rslt;
    }



#ifdef HAL_RTC_MODULE_ENABLED
//-----------------------------------------------------------------------------
//      ðǥ/
//-----------------------------------------------------------------------------
LOCAL(int) Mon_Time(int PortNo, LPCSTR MonCmd, LPCSTR lpArg, LPCSTR CmdLine)
    {
    int I, Rslt=MONRSLT_SYNTAXERR;
    SYSTEMTIME ST;
    CHAR Buff[32];

    if (lpArg[0]=='?')
        {
        PrintfII(PortNo, "TIME [Hour Minute Second [Year Month Day]] ... Display RTC Time"CRLF);
        Rslt=MONRSLT_EXIT;
        goto ProcExit;
        }

    GetLocalTime(&ST);
    if (lpArg[0]==0)
        {
        //GetCdmaLocalTime((HANDLE)hDrvUsbModem, &ST);
        MakeYMDHMS(Buff, &ST);
        PrintfII(PortNo, "%s"CRLF, Buff);
        Rslt=MONRSLT_EXIT;
        }
    else{
        I=-1; lpArg=ScanInt(lpArg, &I); if (I<0 || I>23) goto ProcExit;
        ST.wHour=I;
        I=-1; lpArg=ScanInt(lpArg, &I); if (I<0 || I>59) goto ProcExit;
        ST.wMinute=I;
        I=-1; lpArg=ScanInt(lpArg, &I); if (I<0 || I>59) goto ProcExit;
        ST.wSecond=I;

        if (lpArg[0]!=0)
            {
            I=0; lpArg=ScanInt(lpArg, &I); if (I<2021 || I>2136) goto ProcExit;
            ST.wYear=I;
            I=0; lpArg=ScanInt(lpArg, &I); if (I<1 || I>12) goto ProcExit;
            ST.wMonth=I;
            I=0; lpArg=ScanInt(lpArg, &I); if (I<1 || I>31) goto ProcExit;
            ST.wDay=I;
            }
        SetLocalTime(&ST);
        Rslt=MONRSLT_OK;
        }

    ProcExit:
    return Rslt;
    }
#endif //HAL_RTC_MODULE_ENABLED



//-----------------------------------------------------------------------------
//      ޸  ǥ
//-----------------------------------------------------------------------------
int WINAPI Mon_DispMemBlock(int PortNo, LPCSTR MonCmd, LPCSTR lpArg, LPCSTR CmdLine)
    {
    int Rslt;

    if (lpArg[0]=='?')
        {
        Printf("MEM ... Display Allocated Mem Blocks"CRLF);
        Rslt=MONRSLT_EXIT;
        goto ProcExit;
        }

    #ifdef LCD_VRAM_START
    Printf("---Main Memory---"CRLF);
    #endif
    DispMemBlock(TRUE);

    #ifdef LCD_VRAM_START
    Printf("---Video Memory---"CRLF);
    DispVMemBlock(TRUE);
    #endif

    DispBootStack();
    Rslt=MONRSLT_OK;

    ProcExit:
    return Rslt;
    }




//-----------------------------------------------------------------------------
//      ý  ޼ ǥÿ
//-----------------------------------------------------------------------------
LOCAL(int) Mon_SysDebug(int PortNo, LPCSTR MonCmd, LPCSTR lpArg, LPCSTR CmdLine)
    {
    int I, J, Rslt=MONRSLT_SYNTAXERR;

    if (lpArg[0]=='?')
        {
        Printf("SYSDEBUG 0/1 ... System Debug"CRLF);
        Rslt=MONRSLT_EXIT;
        goto ProcExit;
        }

    J=AtoI(lpArg, &I); if (I==0) goto ProcExit;
    SysDebugFg=(BYTE)J;
    Rslt=MONRSLT_OK;

    ProcExit:
    return Rslt;
    }



#if INIFILE_EN && defined(HAL_RTC_MODULE_ENABLED)
//-----------------------------------------------------------------------------
//      Ÿ  ð Ȱȭ մϴ
//-----------------------------------------------------------------------------
LOCAL(int) Mon_DebugOn(int PortNo, LPCSTR MonCmd, LPCSTR lpArg, LPCSTR CmdLine)
    {
    int I, Minute, Rslt=MONRSLT_SYNTAXERR;
    SYSTEMTIME ST;

    if (lpArg[0]=='?')
        {
        Printf("DEBUGON Minute ... Enable debugging for a specified Minute"CRLF);
        Rslt=MONRSLT_EXIT;
        goto ProcExit;
        }

    Minute=AtoI(lpArg, &I); if (I==0) goto ProcExit;

    GetLocalTime(&ST);
    WriteIniInt(ConfigStr, DebugExpireStr, PackTotalSecond(&ST)+Minute*60);
    Rslt=MONRSLT_OK;

    ProcExit:
    return Rslt;
    }
#endif




#ifdef SECURE_CODE
//-----------------------------------------------------------------------------
//      ý  ޼ ǥÿ
//-----------------------------------------------------------------------------
LOCAL(VOID) SetPassword(LPCSTR Psw)
    {
    DWORD Solt, EncSolt;
    CHAR Buff[SHA256_VALUELEN+SHA256_VALUELEN/2];
    BYTE PswHash[SHA256_VALUELEN];
    CHAR SaltPsw[64];

    #ifdef SECURE_DEBUG
    Printf("Input Password: %s"CRLF, Psw);
    #endif
    Solt=GetTickCount() ^ 0x7DAF59BC; EncSolt=Solt^PSWSOLTENCCODE;
    EncodeBase64((LPCSTR)&EncSolt, 4, SaltPsw, 0, FALSE);
    lstrcatn(SaltPsw, Psw, sizeof(SaltPsw));
    #ifdef SECURE_DEBUG
    Printf("Salted Password: %s"CRLF, SaltPsw);
    #endif
    SHA256_Proc((LPCBYTE)SaltPsw, lstrlen(SaltPsw), PswHash);
    #ifdef SECURE_DEBUG
    Printf("---SHA256 Password Hash---"CRLF); DumpMem(PswHash, SHA256_VALUELEN);
    #endif
    EncodeBase64((LPCSTR)PswHash, SHA256_VALUELEN, Buff, -1, FALSE);
    WriteIniStr(ConfigStr, PswStr, Buff);
    WriteIniInt(ConfigStr, SoltStr, Solt);
    FlushIniFile();
    }



//-----------------------------------------------------------------------------
//      ȣ  Ǵ
//-----------------------------------------------------------------------------
LOCAL(BOOL) CheckValidPsw(LPCSTR Psw)
    {
    int Cha, Len, Special, Upper, Lower;
    static CONST CHAR SpecChars[]="!\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~";

    Len=Special=Upper=Lower=0;
    while ((Cha=*(LPCBYTE)Psw++)!=0)
        {
        Len++;
        if (Cha>='A' && Cha<='Z') Upper++;
        else if (Cha>='a' && Cha<='z') Lower++;
        else if (SearchCha(SpecChars, Cha)>=0) Special++;
        }
    return Len>=9 && Special>0 && Upper>0 && Lower>0;
    }



//-----------------------------------------------------------------------------
//      ȣȮ
//-----------------------------------------------------------------------------
LOCAL(VOID) CheckPassword(LPCSTR Psw)
    {
    DWORD Solt;
    CHAR Buff[SHA256_VALUELEN+SHA256_VALUELEN/2];
    BYTE PswHash[SHA256_VALUELEN];
    CHAR SaltPsw[64];

    GetIniStr(ConfigStr, PswStr, Buff, sizeof(Buff));
    Solt=GetIniInt(ConfigStr, SoltStr, GetTickCount()) ^ PSWSOLTENCCODE;
    FlushIniFile();

    if (Buff[0]==0)
        {
        if (lstrcmp(Psw, "0000")==0)
            {
            NewPsw:
            Printf("New Password :"CRLF);
            MonitorLogin=LOGIN_NEWPSW;
            }
        }
    else{
        DecodeBase64(Buff, (LPSTR)PswHash, -1);
        CopyMem(Buff, PswHash, SHA256_VALUELEN);

        EncodeBase64((LPCSTR)&Solt, 4, SaltPsw, 0, FALSE);      //8ڸڰ 
        lstrcatn(SaltPsw, Psw, sizeof(SaltPsw));
        SHA256_Proc((LPCBYTE)SaltPsw, lstrlen(SaltPsw), PswHash);
        if (CompareMem(Buff, PswHash, SHA256_VALUELEN)==0)
            {
            if (MonitorLogin==LOGIN_CHANGEPSW) goto NewPsw;
            Printf("Welcome..."CRLF);
            MonitorLogin=LOGIN_OK;
            }
        }
    }




//-----------------------------------------------------------------------------
//      ȣ ó
//-----------------------------------------------------------------------------
LOCAL(VOID) PasswordProc(LPCSTR Psw)
    {
    static CHAR InputPswBuff[16];

    switch (MonitorLogin)
        {
        case LOGIN_NEED:
        case LOGIN_CHANGEPSW:
            CheckPassword(Psw);
            break;

        case LOGIN_NEWPSW:
            if (CheckValidPsw(Psw)==FALSE)
                {
                Printf("Must be at least 9 char long, Contain upper, lower case letters, special char."CRLF);   //ȣ 9 ̻̾ ϰ 빮ڿ ҹڿ Ưڰ ԵǾ մϴ.
                break;
                }
            Printf("Confirm Password :"CRLF);
            lstrcpyn(InputPswBuff, Psw, sizeof(InputPswBuff));
            MonitorLogin=LOGIN_CONFIRMPSW;
            break;

        case LOGIN_CONFIRMPSW:
            if (lstrcmp(InputPswBuff, Psw)!=0)
                {
                Printf("No Same Password"CRLF);
                break;
                }
            SetPassword(Psw);
            MonitorLogin=LOGIN_OK;
            Printf("Welcome..."CRLF);
        }
    }



LOCAL(int) Mon_Psw(int PortNo, LPCSTR MonCmd, LPCSTR lpArg, LPCSTR CmdLine)
    {
    int  Rslt=MONRSLT_SYNTAXERR;

    if (lpArg[0]=='?')
        {
        Printf("PSW ... Set Password"CRLF);
        Rslt=MONRSLT_EXIT;
        goto ProcExit;
        }

    if (lpArg[0]!=0) goto ProcExit;
    Printf("Current Password :"CRLF);
    MonitorLogin=LOGIN_CHANGEPSW;
    Rslt=MONRSLT_EXIT;

    ProcExit:
    return Rslt;
    }
#endif //SECURE_CODE



typedef struct _MONCMDLIST
    {
    CHAR Cmd[12];
    MON_FUNC Func;
    } MONCMDLIST;


#undef NOW_IN_HEADER
#include "MON_CFG.H"



//-----------------------------------------------------------------------------
//               ó
//-----------------------------------------------------------------------------
VOID WINAPI MonitorRoutinue(int PortNo, LPCSTR MonCmd)
    {
    int I,J;
    CONST MONCMDLIST *MC;

    if (EchoEnableFg) PrintfII(PortNo, CrLfStr);
    MonCmd=SkipSpace(MonCmd);

    if (EchoEnableFg==0)
        {
        if (CompMemStr(MonCmd, "[    0.")==0 ||
            CompMemStr(MonCmd, "U-Boot ")==0) HostConnected=1;
        if (CompMemStrI(MonCmd, "HOSTCMD")!=0) goto ProcExit;
        MonCmd=SkipSpace(MonCmd+7);     //+7: Len("HOSTCMD")
        }

    if (MonCmd[0]==0) goto ProcExit;

    #ifdef SECURE_CODE
    if (MonitorLogin!=LOGIN_OK) {PasswordProc(MonCmd); goto ProcExit;}
    #endif

    if (MonCmd[0]=='?')
        {
        for (I=0; I<countof(MonCmdList); I++)
            {
            MC=MonCmdList+I;
            MC->Func(PortNo, MC->Cmd, "?", MonCmd);
            }
        goto PrintOk;
        }

    for (I=0; I<countof(MonCmdList); I++)
        {
        MC=MonCmdList+I;
        if (CompMemStrI(MonCmd, MC->Cmd)==0) break;
        }
    if (I>=countof(MonCmdList)) {PrintfII(PortNo, "SENSOR: Unknown command"CRLF); goto ProcExit;}

    J=MC->Func(PortNo, MC->Cmd, SkipSpace(lstrlen(MC->Cmd)+MonCmd), MonCmd);
    if (J==MONRSLT_SYNTAXERR) PrintfII(PortNo, "SENSOR: Syntax error"CRLF);
    else if (J==MONRSLT_OK) {PrintOk: PrintfII(PortNo, "SENSOR: Ok"CRLF);}

    ProcExit:;
    }



//-----------------------------------------------------------------------------
//      Serial ó Proc
//-----------------------------------------------------------------------------
VOID WINAPI MonitorProc(VOID)       //Main() ð  ȣϴ 
    {
    int Cha;
    static CHAR OneLineBuff[MONITOR1LINEMAX];
    static CHAR Bkup1LineBuff[MONITOR1LINEMAX];

    UART_DisplayError();
    for (;;)
        {
        if ((Cha=GetChar())<0) break;
        ExistDebugInput=1;

        switch (Cha)
            {
            //case CTRL_R: SystemReset("Pushed ^R");
            case ESC:
                //ResetSystem(RESETREASON_SOFEWARE);
                if (OneLineBuff[0]!=0)
                    {
                    if (EchoEnableFg) Printf(" (Canceled)"CRLF);
                    OneLineBuff[0]=0;
                    }
                break;

            case LF: break;

            case CR:
                if (OneLineBuff[0]!=0) lstrcpy(Bkup1LineBuff, OneLineBuff);
                Cha=FALSE;
                #if MONITORCALLBACKEN
                Cha=MonitorCallback(OneLineBuff);
                #endif
                if (Cha==FALSE) MonitorRoutinue(GetDebugPort(), OneLineBuff);
                OneLineBuff[0]=0;
                break;

            case BKSPC:
                if (OneLineBuff[0]!=0)
                    {
                    OneLineBuff[lstrlen(OneLineBuff)-1]=0;
                    if (EchoEnableFg) Printf("\b \b");  //Echo
                    }
                break;

            case CTRL_E:        //^E
                lstrcatn(OneLineBuff, Bkup1LineBuff, sizeof(OneLineBuff));
                if (EchoEnableFg) Printf(Bkup1LineBuff);
                break;

            #ifdef THREADTEST
            case '1': if (OneLineBuff[0]==0) {JOSSemPost(TestSem1); break;}
            case '2': if (OneLineBuff[0]==0) {JOSSemPost(TestSem2); break;}
            case '3': if (OneLineBuff[0]==0) {JOSSemPost(TestSem3); break;}
            case '4': if (OneLineBuff[0]==0) {JOSSemPost(TestSem4); break;}
            #endif
            default:
                if (lstrlen(OneLineBuff)<(int)sizeof(OneLineBuff)-1)
                    {
                    if (Cha<' ') // || Cha>0x7E)    //Cha>0x7E ̰  ѱ ŵ
                        {
                        if (EchoEnableFg) Printf("(%X)", Cha);
                        }
                    else{
                        AddCha(OneLineBuff, Cha);
                        #ifdef SECURE_CODE
                        if (EchoEnableFg) Printf("%c", MonitorLogin==LOGIN_OK ? Cha:'*');   //Echo
                        #else
                        if (EchoEnableFg) Printf("%c", Cha);    //Echo
                        #endif
                        }
                    }
            }
        }
    }




#ifdef THREADMONITOR
//-----------------------------------------------------------------------------
//      Monitor Task
//-----------------------------------------------------------------------------
static VOID CALLBACK MonitorTask(LPVOID lpArg)
    {
    for (;;)
        {
        MonitorProc();
        Sleep(1);
        }
    }



//-----------------------------------------------------------------------------
//      JOS Task Test
//-----------------------------------------------------------------------------
#ifdef THREADTEST
typedef struct _TaskArgStruc
    {
    JOS_EVENT *TestSem;
    LPCSTR TaskName;
    }TaskArgStruc;


VOID CALLBACK TestTask(LPVOID lpData)
    {
    int I;
    LPCSTR TaskName;

    TaskName=((TaskArgStruc*)lpData)->TaskName;
    Printf("%s Start"CRLF, TaskName);

    for (;;)
        {
        JOSSemPend(((TaskArgStruc*)lpData)->TestSem, 0);

        for (I=0; I<100; I++)
            {
            Printf("%s Runnning %d..."CRLF, TaskName, I);
            JOSTimeDly(JOS_TICKS_PER_SEC/10);
            }
        }
    }
#endif



typedef VOID(*lwip_thread_fn)(LPVOID arg);
#ifdef USE_FREERTOS
HANDLE sys_thread_new(lwip_thread_fn thread, LPVOID arg, int stacksize, int prio, LPVOID name);
#endif



//-----------------------------------------------------------------------------
//      츮 ǥ Ÿũ 
//-----------------------------------------------------------------------------
VOID WINAPI CreateMonitorTask(VOID)
    {
    #ifdef THREADTEST
    static TaskArgStruc TArg1, TArg2, TArg3, TArg4;

    TestSem1=JOSSemCreate(0);
    TestSem2=JOSSemCreate(0);
    TestSem3=JOSSemCreate(0);
    TestSem4=JOSSemCreate(0);

    TArg1.TestSem=TestSem1;
    TArg1.TaskName="P1";
    JOSTaskCreateExt(TestTask, &TArg1, TEST_TASK_STK_SIZE, PRIO_TEST1TASK, "Test1");

    TArg2.TestSem=TestSem2;
    TArg2.TaskName="P2";
    JOSTaskCreateExt(TestTask, &TArg2, TEST_TASK_STK_SIZE, PRIO_TEST2TASK, "Test2");

    TArg3.TestSem=TestSem3;
    TArg3.TaskName="P3";
    JOSTaskCreateExt(TestTask, &TArg3, TEST_TASK_STK_SIZE, PRIO_TEST3TASK, "Test3");

    TArg4.TestSem=TestSem4;
    TArg4.TaskName="P4";
    JOSTaskCreateExt(TestTask, &TArg4, TEST_TASK_STK_SIZE, PRIO_TEST4TASK, "Test4");
    #endif //THREADTEST

    #ifdef USE_FREERTOS
    sys_thread_new(MonitorTask, NULL, BASE_TASK_STK_SIZE, 0, "Debug");
    #else
    CreateThread("Debug", BASE_TASK_STK_SIZE, MonitorTask, NULL, PRIO_RS232MON);
    #endif
    }
#endif



//-----------------------------------------------------------------------------
//       ƾ ȣ
//-----------------------------------------------------------------------------
VOID WINAPI CallMonFunc(int PortNo, MON_FUNC MonFunc, LPCSTR CmdLine)
    {
    CHAR  Name[12];
    LPCSTR lp;

    lp=ScanWord(CmdLine, Name, sizeof(Name));
    MonFunc(PortNo, Name, lp, CmdLine);
    }




