///////////////////////////////////////////////////////////////////////////////
//          STM32  PWM  ̺
//
//  IOPINMAP.H    ǵǾ ־ 
//
//  #define BUZZER_TIMER    TIM4
//  #define BUZZER_TMR_CHANNEL  TIM_CHANNEL_3
//  #define BUZZER_TMR_CLK_EN   __HAL_RCC_TIM4_CLK_ENABLE
//  #define BUZZER_INIT_PORT()  InitPort(PO_BUZZER, GPIO_MODE_AF_PP, GPIO_PULLUP, GPIO_AF2_TIM4)
///////////////////////////////////////////////////////////////////////////////

#include "JLIB.H"
#include "DRIVER.H"


#define A6      0
#define A6Shp   1
#define B6      2
#define C7      3
#define C7Shp   4
#define D7      5
#define D7Shp   6
#define E7      7
#define F7      8
#define F7Shp   9
#define G7      10
#define G7Shp   11
#define A7      12
#define A7Shp   13
#define B7      14
#define C8      15
#define C8Shp   16
#define D8      17
#define D8Shp   18
#define E8      19
#define F8      20
#define F8Shp   21
#define G8      22
#define G8Shp   23
#define A8      24
#define A8Shp   25
#define B8      26
#define PLAY_REST       252             //10ms 
#define PLAY_POS        253
#define PLAY_REPEAT     254
#define PLAY_END        255


static BYTE    PlayTimeCnt;
static LPCBYTE ToPlayDataPtr;

#define REPEATPOSTBLQTY 2
static LPCBYTE RepeatPosTbl[REPEATPOSTBLQTY];


static CONST WORD OC_Friquency[]=
    {//C--C#---D----D#---E----F----F#---G----G#---A----A#---B---
                                                 1760,1865,1976,
    2093,2217,2349,2489,2637,2794,2960,3136,3322,3520,3729,3951,    //C7~B7
    4186,4435,4699,4978,5274,5588,5920,6272,6645,7040,7459,7902     //C8~B8
    };


#include "MelodyData.c"

static LPTIM_HandleTypeDef TimerInst;



//-----------------------------------------------------------------------------
//      PWM ޽ 
//-----------------------------------------------------------------------------
#define PWMCLOCK    16000000
LOCAL(VOID) SetPulseOut(int Freq)
    {
    UINT Period;

    Period=(PWMCLOCK+(Freq>>1))/Freq;
    LPTIM_PWM_Start(&TimerInst, Period, Period>>1);
    }



//-----------------------------------------------------------------------------
//        Timer Proc (10ms  ȣ)
//-----------------------------------------------------------------------------
VOID WINAPI PlayBeepProc(VOID)
    {
    BYTE Sound;

    if (PlayTimeCnt!=0 && --PlayTimeCnt==0)
        {
        GetSndData:
        Sound=*ToPlayDataPtr++;
        PlayTimeCnt=*ToPlayDataPtr++;
        if (Sound==PLAY_POS)
            {
            RepeatPosTbl[PlayTimeCnt]=ToPlayDataPtr;
            goto GetSndData;
            }
        else if (Sound==PLAY_REPEAT)
            {
            ToPlayDataPtr=RepeatPosTbl[PlayTimeCnt];
            goto GetSndData;
            }
        else if (Sound==PLAY_END || Sound==PLAY_REST)
            {
            if (Sound==PLAY_END) PlayTimeCnt=0;
            LPTIM1_PWM_Stop(&TimerInst);
            }
        else SetPulseOut(OC_Friquency[Sound]);
        }
    }



//-----------------------------------------------------------------------------
//       
//-----------------------------------------------------------------------------
VOID WINAPI PlayBeep(LPCBYTE Data)
    {
    ToPlayDataPtr=Data;
    PlayTimeCnt=1;      //
    }



//-----------------------------------------------------------------------------
//       ˷
//-----------------------------------------------------------------------------
BOOL WINAPI IsPlayingBeep(VOID)
    {
    return PlayTimeCnt;
    }



//-----------------------------------------------------------------------------
//      Buzzer ʱȭ
//-----------------------------------------------------------------------------
VOID WINAPI InitBuzzerTimer(VOID)
    {
    RCC_PeriphCLKInitTypeDef PCLKI;

    __HAL_RCC_LPTIM1_CLK_ENABLE();
    __HAL_RCC_LPTIM1_FORCE_RESET();
    __HAL_RCC_LPTIM1_RELEASE_RESET();

    ZeroMem(&PCLKI, sizeof(RCC_PeriphCLKInitTypeDef));
    PCLKI.PeriphClockSelection=RCC_PERIPHCLK_LPTIM1;
    PCLKI.LptimClockSelection=RCC_LPTIM1CLKSOURCE_HSI;
    HAL_RCCEx_PeriphCLKConfig(&PCLKI);

    TimerInst.Instance=LPTIM1;
    TimerInst.Init.Clock.Source=LPTIM_CLOCKSOURCE_APBCLOCK_LPOSC;
    TimerInst.Init.Clock.Prescaler=LPTIM_PRESCALER_DIV1;
    TimerInst.Init.Trigger.Source=LPTIM_TRIGSOURCE_SOFTWARE;
    TimerInst.Init.OutputPolarity=LPTIM_OUTPUTPOLARITY_HIGH;
    TimerInst.Init.UpdateMode=LPTIM_UPDATE_IMMEDIATE;
    TimerInst.Init.CounterSource=LPTIM_COUNTERSOURCE_INTERNAL;
    LPTIM_Init(&TimerInst);
    }




//-----------------------------------------------------------------------------
//      𸣽 ȣ 
//-----------------------------------------------------------------------------
#define MORSEBUFFSIZE   80
LPCBYTE WINAPI MakeMorseData(LPCSTR Str, int Tone)
    {
    int I,J, Cnt, Data;
    static BYTE MorseBuff[MORSEBUFFSIZE];
    static CONST BYTE MorseData[]=
        {
        5,0x1F,     //'0'
        5,0x1E,     //'1'
        5,0x1C,     //'2'
        5,0x18,     //'3'
        5,0x10,     //'4'
        5,0x00,     //'5'
        5,0x01,     //'6'
        5,0x03,     //'7'
        5,0x07,     //'8'
        5,0x0F,     //'9'

        2,0x02,     //'A'
        4,0x01,     //'B'
        4,0x05,     //'C'
        3,0x01,     //'D'
        1,0x00,     //'E'
        4,0x04,     //'F'
        3,0x03,     //'G'
        4,0x00,     //'H'
        2,0x00,     //'I'
        4,0x0E,     //'J'
        3,0x05,     //'K'
        4,0x02,     //'L'
        2,0x03,     //'M'
        2,0x01,     //'N'
        3,0x07,     //'O'
        4,0x06,     //'P'
        4,0x0B,     //'Q'
        3,0x02,     //'R'
        3,0x00,     //'S'
        1,0x01,     //'T'
        3,0x04,     //'U'
        4,0x08,     //'V'
        3,0x06,     //'W'
        4,0x09,     //'X'
        4,0x0D,     //'Y'
        4,0x03,     //'Z'
        };

    J=0;
    while ((I=*Str++)!=0)
        {
        if (I>='0' && I<='9') I-='0';
        else if (I>='A' && I<='Z') I=I-'A'+10;
        else continue;

        Cnt=MorseData[(I<<1)+0];
        Data=MorseData[(I<<1)+1];

        for (I=0; I<Cnt; I++,Data>>=1)
            {
            if (J>=MORSEBUFFSIZE-3) goto DataEnd;
            MorseBuff[J++]=Tone;
            MorseBuff[J++]=(Data & 1) ? 36:12;
            if (J>=MORSEBUFFSIZE-3) goto DataEnd;
            MorseBuff[J++]=PLAY_REST;
            MorseBuff[J++]=12;
            }
        if (J>=MORSEBUFFSIZE-3) goto DataEnd;
        MorseBuff[J++]=PLAY_REST;
        MorseBuff[J++]=36;
        }

    DataEnd:
    MorseBuff[J]=PLAY_END;
    //DumpMem(MorseBuff, J+1);
    return MorseBuff;
    }


VOID WINAPI PlayMorseBuzzer(LPCSTR Str)
    {
    PlayBeep(MakeMorseData(Str, C7));
    }



