﻿
#define MASTERRECEIVER          0       //수신기 디바이스 번호
#define BROADCASTDEVICENO       0xFF    //모든 디바이스가 받는 디바이스 번호
#define TIMESENDWAITTIME        100     //시간패킷 전송지연시간
#define MAXPACKETSIZE           80      //최대 패킷 크기, 2020-11-25 40->80 RF 설정패킷이 40을 초과함

#define MAXBLOCKBINBYTES        108     //SPI-RF모듈 1회 전송 최대 Byte수, 109:송신OK,수신NO, 108:모두OK


typedef struct _RF_PACKET
    {
    DWORD GroupNo;      //그룹번호
    WORD  PublishNo;    //발행번호
    BYTE Receiver;      //수신대상 디바이스번호, 0번이 수신기임
    BYTE Sender;        //송신자 Group안의 디바이스 번호

    BYTE PacketType;    //아래 정의 참조
    BYTE DataLen;
    BYTE Data[1];
    //BYTE CheckSum;
    } PACKED RF_PACKET;


//RF_PACKET.Type
//#define PT_CLEARROUTER        0x80    //라우팅 테이블 보지 않음 2017-08-18 이후 삭제함
#define PT_ADDROUTER            0x81    //라우팅 테이블 보지 않음
#define PT_TIME                 0x82    //시간 설정 수신기만 보냄
#define PT_ALIVE                0x83    //기기 확인을 위한 명령, PT_ACK로 응답함 (송수신기 테스트에 사용)
#define PT_ROUTEDATA            0x84    //라우터가 재전송하는 송신기 데이터
#define PT_CONTROL              0x85    //수신기가 전송하는 제어 패킷
#define PT_CTLACK               0x86    //PT_CONTROL의 응답
#define PT_SECACK               0x87    //PT_SECURITY의 응답
#define PT_STARTSETTING         0x88    //RF 설정모드로 진입
#define PT_SETTING              0x89    //센서모듈 설정, 센서 ENable/Disable, 화재센서 동작방식 설정
#define PT_SETACK               0x8A    //센서모듈 설정 응답
#define PT_TEMPALARM            0x8B    //온도 알람 설정
#define PT_TEMPACK              0x8C    //온도 알람 설정 응답
#define PT_O2CONC               0x8D    //산소농도(Concentration) 주기적 전송, ppm단위 값임
#define PT_TILTALARM            0x8E    //G센서 기울어짐 알람
#define PT_COIRTEMP             0x8F    //CO농도센서1개, IR온도센서1~3
#define PT_SETINTERVAL          0x90    //센서값 전송 간격 설정 (육군정비창에서 사용)
#define PT_SETINTVLACK          0x91    //센서값 전송 간격 설정 ACK
#define PT_SYNCSIREN            0x92    //수신기만 보냄, 화재사이렌 연계동작
#define PT_COALARM              0x93    //CO 알람 설정
#define PT_COALARMACK           0x94    //CO 알람 설정 응답
#define PT_HIGHCO               0x95    //설정 CO보다 올라감
#define PT_COIRTEMPIMP          0x96    //CO농도센서1개, IR온도센서1~3, 이벤트 후의 값이라 중요해서 재시도 하는 패킷임
#define PT_SCAN                 0x97    //수신기에서 센서 통신점검
#define PT_STATE                0x98    //통신 점검에 대한 응답
#define PT_RESET                0x99    //화재상태클리어(화재복구)
#define PT_SCANALL              0x9A    //수신기가 모든 디바이스 통신 점검
#define PT_RESETALL             0x9B    //수신기가 모든 디바이스 화재 복구
#define PT_STATEALL             0x9C    //모든 디바이스 통신 점검에 대한 응답
#define PT_BELL                 0x9D    //경종 울려라
#define PT_BELLALL              0x9E    //모든 경종 울려라
#define PT_BATTSTATE            0x9F    //통신점검의 응답 중 모든 감지기의 Low배터리 정보
#define PT_FIRESTATE            0xA0    //통신점검의 응답 중 모든 감지기의 화재상태 정보
#define PT_BELLSTOP             0xA1    //울리고 있는 벨 일시 정지
#define PT_BELLRSTR             0xA2    //일시정지된 벨 다시 울려라
#define PT_STATESM              0xA3    //ResetAll의 응답
#define PT_SCANALLSM            0xA4    //PT_SCANALL 와 처리는 같고 처리 결과를 PT_STATESM 하나만 리턴함
#define PT_SCANALLR             0xA5    //중계기에 저장된 감기기 상태를 보내라
#define PT_SCANALLP             0xA6    //수신기가 모든 디바이스 통신 점검하고 결과는 보관만 해라 (부팅시 내부적으로 사용)
#define PT_BLOCK                0xA7    //블럭전송
#define PT_STATERA              0xA8    //화재 복구의 응답
#define PT_FIRESTATX            0xA9    //모아둔 화재 신호
#define PT_AUTOREGIST           0xAA    //자동 등록
#define PT_PIRDETECT            0xAB    //PIR 감지
#define PT_PIRSOS               0xAC    //화장실에서 쓰러짐 감지
#define PT_WHOISAROUND          0xAD    //주변에 누가 있니?
#define PT_IAMHERE              0xAE    //나 여기 있다
#define PT_MYNEIGHBORIS         0xAF    //내 이웃은...
#define PT_ELECALARM            0xB0    //전기 관련 알람 (누전, 과전류, 정전)
#define PT_ELECINFO             0xB1    //누전감지기 전기정보
//#define PT_DETALIVE           0xB2    //감지기가 통신점검을 대신하여 보내는 패킷
//#define PT_DALIVEACK          0xB3    //감지기가 통신점검을 대신하여 보내는 패킷의 응답
#define PT_FAULT                0xB4    //감지기 결함 (불꽃감지기에서 처음 사용)
#define PT_SBELL                0xB5    //경종 짧게 울려라
#define PT_SBELLALL             0xB6    //모든 경종 짧게 울려라
#define PT_EXTINGUISH           0xB7    //자체 화재 진압 완료 / 화재감지 상황종료 / 오탐 화재 였음 (익스팅궈쉬)
#define PT_COLLECTACK           0xB8    //모둠 ACK, 패킷크기를 줄이기 위해 추가함
#define PT_SMOKEFIRE            0xB9    //모든 디바이스 응답 중 연기로 인한 화재상태
#define PT_HEATFIRE             0xBA    //모든 디바이스 응답 중 과열로 인한 화재상태
#define PT_COLLECTACKT          0xBB    //모둠 ACK, 패킷크기를 줄이기 위해 추가함 (with RTC 동기 필요) (KFI시험 때 장시간 꺼졌던 중계기를 켠 후 감지기를 화재발생 시켰을 때 이 후 통신점검이 동작하도록 하기 위해 중계기가 RTC동기화를 위해 감지기에게 시간을 요청하는 패킷임)
#define PT_DERG                 0xBC    //Dynamic Escape Route Guidance, 탈출경로지시기가 복구를 위해 1분마다 보냄
#define PT_EVENT                0xBD    //이벤트 전달

#define PT_ACK                  'A'     //수신기가 보냄
#define PT_SWITCH               'W'     //테스트 스위치
#define PT_DOOR                 'D'     //문열림 감지
#define PT_FIRE                 'F'     //화재감지
#define PT_TEMP                 'T'     //중요한 온도값, ACK받음
#define PT_GAS                  'G'     //가스 누출 감지
#define PT_CO2                  'C'     //CO2감지
#define PT_NH3                  'N'     //암모니아 센서
#define PT_HEAT                 'H'     //과열감지
#define PT_SMOKE                'S'     //연기감지
//#define PT_REQUEST            'R'     //수신기가 센서 정보 요청 (현재 사용안하며, 수신기가 주기적으로 발송함) 2018-01-02 삭제
#define PT_SENSOR               'P'     //센서 정보 응답
#define PT_TRESPASS             'I'     //동체감지(침입감지), Invasion
#define PT_CRYFIRE              'Y'     //불이야 외침 (음성인식에서 사용)
#define PT_CRYHELP              'E'     //도와줘 외침 (음성인식에서 사용)
#define PT_HIGHTEMP             'h'     //설정온도보다 올라감
#define PT_LOWTEMP              'l'     //설정온도보다 떨어짐
#define PT_BREAKDOWN            'B'     //정전알림
#define PT_EXCEEDPOWER          'X'     //전력 사용량 초과
#define PT_BATTERY              'b'     //배터리 전압을 0~200사이 값으로 전송함 (2.0V->0, 3.3V->200)
#define PT_FIREPREDETECT        'f'     //화재징후 감지
#define PT_ELECTRICLEAK         'e'     //누전 감지
#define PT_SECURITY             's'     //방범설정
#define PT_LANDSLIDE            'd'     //산사태 감지
#define PT_OXYGEN               'o'     //산소량, %값으로 전송하는 명령으로 설계했으나 ppm을 바뀌어 사용하지 않게 됨
#define PT_FLAME                'm'     //불꽃 감지
#define PT_MANFIRE              'M'     //수동화재신고

//PT_SWITCH/PT_SMOKE/PT_HEAT... 등의 패킷의 Data
#define SEN_RELEASE             0   //"Released"
#define SEN_DETECT              1   //"Detected"
#define SEN_DISCONNECTED        2   //"Disconnected", 발신기 단선
#define SEN_DETECTRESEND        3   //"DetectResend", 감지된 화재신호를 1분마다 재전송할 때
//#define SEN_REDETECT          4   //"Redetect", 복구 후 바로 다시감지 (패킷을 1개로 줄이기 위함)
#define SEN_UNDEFINED           255 //"Undefined"



//RF_PACKET.PacketAttr
#define PA_NORMAL               0
//#define PA_NEEDACK            0x01    //ACK가 필요한 패킷임, 나중에 쓸 것임
#define PA_WAKEUP               0x02    //송신전에 깨워라
#define PA_NEWRELAY             0x80
#define PA_OLDRELAY             0xFF


//중계기가 감지기로 ACK에 보내는 명령
#define OC_SETALIVEPERIOD       1
#define OC_SETTIME              2       //2000-01-01 기준으로 한 초단위 시각 전송
//#define OC_SCANACK            3
//#define OC_SETONLYTIME        4       //00:00:00 기준으로 한 ms단위 시각 전송
#define OC_GATHEREDACK          5       //모둠ACK
#define OC_RESET                PT_RESET


typedef struct _POST_RF_HEADER
    {
    WORD SendDelay;     //단위는 10ms
    BYTE LBTDelta;      //LBT시간에 차등을 주기위한 값
    BYTE Dummy;
    } POST_RF_HEADER;

typedef struct _POST_RF_PACKET
    {
    POST_RF_HEADER H;
    RF_PACKET P;
    } POST_RF_PACKET;


//센서 값을 전달할 때 Data[0]의 비트정의
#define SBIT_ANALOG             0x0001
#define SBIT_WINDDIR            0x0002
#define SBIT_WINDSPEED          0x0004
#define SBIT_TEMPERATURE        0x0008
#define SBIT_HUMIDITY           0x0010
#define SBIT_CO2                0x0020
#define SBIT_INSBODYTEMP        0x0040  //가축체온순간온도
#define SBIT_AVGBODYTEMP        0x0080  //가축체온평균온도

//PT_ELECALARM/PT_ELECINFO 데이터 파라메터
#define SBIT_VOLTAGEALARM       0x0001
#define SBIT_OVERCURRENT        0x0002
#define SBIT_OVERIGR            0x0004
#define SBIT_OVERIGO            0x0008
#define SBIT_OVERTEMP           0x0010
#define SBIT_BREAKDOWN          0x0020


VOID WINAPI PostSwitchPacket(BOOL SyncedTimeFg);
VOID WINAPI PostExtinguishFirePacket(int Reserved);
VOID WINAPI PostManFirePacket(BOOL OnOff);
VOID WINAPI PostFaultPacket(int Fault);
#define FAULT_HEATSENSOR    1
#define FAULT_SMOKESENSOR   2
VOID WINAPI PostFireCryPacket(VOID);
VOID WINAPI PostHelpCryPacket(VOID);
VOID WINAPI PostDoorPacket(BOOL OnOff);
VOID WINAPI PostTrespassPacket(BOOL OnOff);
VOID WINAPI PostFirePacket(int FireType, BOOL OnOff);
VOID WINAPI PostGasPacket(BOOL OnOff);
VOID WINAPI PostHighTempPacket(VOID);
VOID WINAPI PostLowTempPacket(VOID);
VOID WINAPI PostHighCOPacket(VOID);
VOID WINAPI PostBreakDownPacket(BOOL OnOff);
VOID WINAPI PostFirePredetectPacket(BOOL OnOff);
VOID WINAPI PostElectricLeakPacket(BOOL OnOff);
VOID WINAPI PostLandslidePacket(int DangerLevel);
VOID WINAPI PostOxygenDensityPacket(int Psnt);
VOID WINAPI PostTemperaturePacket(int Value);
VOID WINAPI PostO2ConcentrationPacket(int Value);
VOID WINAPI PostTiltAlarmPacket(int Deflection);
VOID WINAPI PostBattPacket(int BattStat, BOOL SyncedTimeFg);
VOID WINAPI PostFireDetectPacket(int PacketType);
VOID WINAPI PostRetryFirePacket(int PacketType);

typedef VOID (WINAPI *ftRFSendRecvCB)(int CBReason, CONST RF_PACKET *P);

#define RFCB_SENDOK     0
#define RFCB_RECVACK    1
#define RFCB_NOREPLY    2
#define RFCB_NOACK      3
#define RFCB_PKTRECV    4
#define RFCB_SYNCSIREN  5   //연동알람을 켜거나 끌 필요가 있을 때

int  WINAPI GetPacketLenII(CONST RF_PACKET *P);
VOID WINAPI PostCopyPacket(CONST RF_PACKET *OrgP, int SendDelay);
VOID WINAPI PostDiagCommAckPacket(UINT State);

BOOL WINAPI RFC_IsFirePacket(int PT);
VOID WINAPI RFC_PrintVar(VOID);
VOID WINAPI RFC_DestroySendQ(VOID);
BOOL WINAPI RFC_IsSettingMode(VOID);
VOID WINAPI RFC_SendTime(int AfterTime);
BOOL WINAPI RFC_IsPowerOnReady(VOID);
BOOL WINAPI RFC_IsSendIdle(VOID);
VOID WINAPI RFC_SetSendAnalogInterval(int Sec);
int  WINAPI RFC_GetSendAnalogInterval(VOID);
VOID WINAPI RFC_PowerOff(VOID);
BOOL WINAPI RFC_PacketTypeToText(LPSTR Buff, int PacketType);
VOID WINAPI RFC_SendSensorValue(VOID);
BOOL WINAPI RFC_SendFireRightNow(VOID);
VOID WINAPI RFC_SendQuickSensorValue(VOID);
VOID WINAPI RFC_EnterSetupMode(VOID);
VOID WINAPI RFC_ExitSetupMode(VOID);
VOID CALLBACK RFC_ManagerTask(LPVOID lpData);
VOID WINAPI RFC_Init(ftRFSendRecvCB CB);



