///////////////////////////////////////////////////////////////////////////////
//       µ RTC
///////////////////////////////////////////////////////////////////////////////

#include "JLIB.H"
#include "DRIVER.H"

#define RV3032_DEVICEADD            0xA2

#define RV3032REG_100thSeconds      0x00    //б
#define RV3032REG_Seconds           0x01
#define RV3032REG_Minutes           0x02
#define RV3032REG_Hours             0x03
#define RV3032REG_Weekday           0x04
#define RV3032REG_Date              0x05
#define RV3032REG_Month             0x06
#define RV3032REG_Year              0x07
#define RV3032REG_MinutesAlarm      0x08
#define RV3032REG_HoursAlarm        0x09
#define RV3032REG_DateAlarm         0x0A
#define RV3032REG_TimerValue0       0x0B
#define RV3032REG_TimerValue1       0x0C
#define RV3032REG_Status            0x0D
#define RV3032REG_AF                0x08    //˶ ġϸ 1ε, Ʈ Clear 
#define RV3032REG_TemperatureLSBs   0x0E
#define RV3032REG_EepBusy           0x04
#define RV3032REG_UserRam           0x40    //~4F
#define RTCUSER_Synchronized        0
#define RTC_SynchronizedSign        0x5A

#define RV3032REG_Control1          0x10
#define RV3032REG_TE                0x08
#define RV3032REG_EERD              0x04    //1̸ Flash  Relash Ȱ
#define RV3032REG_TDMASK            0x03    //TD=00(4096Hz) TD=01(64Hz) TD=10(1Hz) TD=11(1/60Hz)
//#define RV3032REG_TD4096Hz        0       //RV3032_EnableTimerInt() ڷ   RV3032.H  
//#define RV3032REG_TD64Hz          1
//#define RV3032REG_TD1Second       2
//#define RV3032REG_TD1Minute       3
#define RV3032REG_Control2          0x11
#define RV3032REG_CLKIE             0x40
#define RV3032REG_UIE               0x20    //ʳ  ٲ INT 'L' ض
#define RV3032REG_TIE               0x10
#define RV3032REG_AIE               0x08    //˶ ġϸ INT 'L' ض (AF Clear  )
#define RV3032REG_EIE               0x04    //EVI Էɿ ȣ   INT 'L' ض
#define RV3032REG_STOP              0x01    //RTC ض,  Ϸ 1/100 īͰ 0̵

#define RV3032REG_EepAddress        0x3D
#define RV3032REG_EepData           0x3E
#define RV3032REG_EepCommand        0x3F

#define RV3032REG_EEPROM_PMU        0xC0    //EEPROM Power Management Unit (PMU)
#define RV3032REG_PMU_TCMOff        0x00    //Trickle Charger Mode(TCM)
#define RV3032REG_PMU_TCM1_75V      0x01
#define RV3032REG_PMU_TCM3V         0x02
#define RV3032REG_PMU_TCM4_4V       0x03
#define RV3032REG_PMU_TCR1KOhm      0x00    //Trickle Charger Series Resistance(TCR)
#define RV3032REG_PMU_TCR2KOhm      0x04
#define RV3032REG_PMU_TCR7KOhm      0x08
#define RV3032REG_PMU_TCR11KOhm     0x0C
#define RV3032REG_PMU_BSM_Disable   0x00    //Backup Switchover Mode (BSM) - 00: Switchover Disabled. Default value on delivery
#define RV3032REG_PMU_BSM_DSM       0x10    //Enables the Direct Switching Mode (DSM)
#define RV3032REG_PMU_BSM_LSM       0x20    //Enables the Level Switching Mode (LSM)
#define RV3032REG_PMU_NCLKE         0x40    //0:CLKOUT is directly enabled, 1:CLKOUT pin is LOW, if not enabled by the interrupt driven clock output

#define EEPCMD_WRITEBYTE            0x21
#define EEPCMD_READBYTE             0x22

#define RV3032REG_OUR_PMU_VALUE     (RV3032REG_PMU_NCLKE|RV3032REG_PMU_BSM_LSM|RV3032REG_PMU_TCR1KOhm|RV3032REG_PMU_TCM4_4V)



//-----------------------------------------------------------------------------
//      RTC  
//-----------------------------------------------------------------------------
LOCAL(BOOL) RV3032_Write(int RegAddr, LPCBYTE Buff, int WriteBytes)
    {
    BOOL Rslt;

    if ((Rslt=I2C_MemWrite(RV3032_I2CPORT, RV3032_DEVICEADD, RegAddr, I2C_MEMADD_SIZE_8BIT, Buff, WriteBytes, 50))==FALSE)
        Printf("SENSOR: RV3032 Write Error"CRLF);
    return Rslt;
    }



//-----------------------------------------------------------------------------
//      RTC  б
//-----------------------------------------------------------------------------
LOCAL(BOOL) RV3032_Read(int RegAddr, LPBYTE Buff, int ReadBytes)
    {
    BOOL Rslt;

    if ((Rslt=I2C_MemRead(RV3032_I2CPORT, RV3032_DEVICEADD, RegAddr, I2C_MEMADD_SIZE_8BIT, Buff, ReadBytes, 50))==FALSE)
        Printf("SENSOR: RV3032 Read Error"CRLF);
    return Rslt;
    }




//-----------------------------------------------------------------------------
//      RTC ͸ 
//-----------------------------------------------------------------------------
LOCAL(int) RV3032_ReadReg(int Reg)
    {
    int  Rslt=-1;
    BYTE Data[4];

    if (RV3032_Read(Reg, Data, 1)!=FALSE) Rslt=Data[0];
    return Rslt;
    }



//-----------------------------------------------------------------------------
//      RTC Ϳ 
//-----------------------------------------------------------------------------
LOCAL(BOOL) RV3032_WriteReg(int Reg, int Data)
    {
    BOOL Rslt=FALSE;
    BYTE Buff[4];

    Buff[0]=(BYTE)Reg;
    Buff[1]=(BYTE)Data;
    if ((Rslt=I2C_MasterTx(RV3032_I2CPORT, RV3032_DEVICEADD, Buff, 2, 50))==FALSE)
        Printf("SENSOR: RV3032 Write Error"CRLF);
    return Rslt;
    }




//-----------------------------------------------------------------------------
//       ð 
//-----------------------------------------------------------------------------
BOOL WINAPI RV3032_GetTime(SYSTEMTIME *ST)
    {
    BOOL Rslt=FALSE;
    BYTE Buff[8];

    ZeroMem(Buff, sizeof(Buff));
    if (I2C_Lock())
        {
        Rslt=RV3032_Read(RV3032REG_100thSeconds, Buff, sizeof(Buff));
        I2C_Unlock();
        }
    ST->wMilliseconds=Bcd2Bin(Buff[0])*10;
    ST->wSecond=Bcd2Bin(Buff[1]);
    ST->wMinute=Bcd2Bin(Buff[2]);
    ST->wHour=  Bcd2Bin(Buff[3]);
    ST->wDayOfWeek=Buff[4];
    ST->wDay=   Bcd2Bin(Buff[5]);
    ST->wMonth= Bcd2Bin(Buff[6]);
    ST->wYear=  Bcd2Bin(Buff[7])+2000;
    return Rslt;
    }




//-----------------------------------------------------------------------------
//       ð  (RV3032 1/100sec ڸ б ̰, Sec   0 )
//-----------------------------------------------------------------------------
BOOL WINAPI RV3032_SetTime(CONST SYSTEMTIME *ST)
    {
    BOOL Rslt=FALSE;
    BYTE Buff[8];

    Buff[0]=Bin2Bcd(ST->wSecond);   //RV3032REG_Seconds
    Buff[1]=Bin2Bcd(ST->wMinute);   //RV3032REG_Minutes
    Buff[2]=Bin2Bcd(ST->wHour);     //RV3032REG_Hours
    Buff[3]=GetWeek(ST->wYear, ST->wMonth, ST->wDay);   //RV3032REG_Weekday
    Buff[4]=Bin2Bcd(ST->wDay);      //RV3032REG_Date
    Buff[5]=Bin2Bcd(ST->wMonth);    //RV3032REG_Month
    Buff[6]=Bin2Bcd(ST->wYear-2000);//RV3032REG_Year
    if (I2C_Lock())
        {
        Rslt=RV3032_Write(RV3032REG_Seconds, Buff, 7);
        RV3032_WriteReg(RV3032REG_UserRam+RTCUSER_Synchronized, RTC_SynchronizedSign);  //ð   ǥ
        I2C_Unlock();
        }
    return Rslt;
    }



//-----------------------------------------------------------------------------
//       µ  (ÿµ x10  )
//        999.9  ( 9999)
//-----------------------------------------------------------------------------
int WINAPI RV3032_GetTemp(VOID)
    {
    int Rslt=FALSE, Temp=9999;
    BYTE Buff[4];

    if (I2C_Lock())
        {
        Rslt=RV3032_Read(RV3032REG_TemperatureLSBs, Buff, 2);
        I2C_Unlock();
        }

    if (Rslt)
        {
        Temp=PeekW(Buff)>>4;
        if (Temp>0x7FF) Temp-=0x1000;   //12Bit Signed 32Ʈ Signed 
        Temp=(Temp*10+8)>>4;            //µ 10  
        }
    return Temp;
    }



//-----------------------------------------------------------------------------
//      ־ ð() ڷ ˶ 
//-----------------------------------------------------------------------------
BOOL WINAPI RV3032_SetAlarm(CONST SYSTEMTIME *ST)
    {
    BOOL Rslt=FALSE;
    BYTE Buff[4];

    Buff[0]=(ST->wMinute<60) ? Bin2Bcd(ST->wMinute):0x80;   //0x80: Disable
    Buff[1]=(ST->wHour<60) ? Bin2Bcd(ST->wHour):0x80;
    Buff[2]=(ST->wDay>0) ? Bin2Bcd(ST->wDay):0x80;
    if (I2C_Lock())
        {
        Buff[3]=0;
        RV3032_Write(RV3032REG_Status, Buff+3, 1);          //AF÷׸  ˶ ġ  Int 'L' 

        Rslt=RV3032_Write(RV3032REG_MinutesAlarm, Buff, 3);
        I2C_Unlock();
        }

    #if 0
    {
    BYTE TestBuff[32];
    RV3032_Read(0, TestBuff, sizeof(TestBuff));
    DumpMem(TestBuff, sizeof(TestBuff));
    }
    #endif

    return Rslt;
    }



//-----------------------------------------------------------------------------
//      ־ ð() ڷ ˶ 
//-----------------------------------------------------------------------------
BOOL WINAPI RV3032_SetAlarmAfterSecond(int AfterSec)
    {
    SYSTEMTIME ST;

    RV3032_GetTime(&ST);
    UnpackTotalSecond(&ST, PackTotalSecond(&ST)+AfterSec+60);
    return RV3032_SetAlarm(&ST);
    }



//-----------------------------------------------------------------------------
//      ˶ ġϸ ͷƮ ɰ
//-----------------------------------------------------------------------------
VOID WINAPI RV3032_EnableAlarmInt(VOID)
    {
    int Ctrl;

    if (I2C_Lock())
        {
        if ((Ctrl=RV3032_ReadReg(RV3032REG_Control2))>=0)
            RV3032_WriteReg(RV3032REG_Control2, Ctrl|RV3032REG_AIE);
        I2C_Unlock();
        }
    }




//-----------------------------------------------------------------------------
//      Ÿ̸Ӹ  (Count==0̸ Ÿ̸Ӹ )
//-----------------------------------------------------------------------------
VOID WINAPI RV3032_StartTimer(int Count)
    {
    int  Ctrl;
    BYTE Buff[4];

    if (I2C_Lock())
        {
        if ((Ctrl=RV3032_ReadReg(RV3032REG_Control1))>=0)
            {
            if (Count) Ctrl|=RV3032REG_TE;
            else       Ctrl&=~RV3032REG_TE;
            RV3032_WriteReg(RV3032REG_Control1, Ctrl);
            }

        if (Count)
            {
            PokeW(Buff, Count);
            RV3032_Write(RV3032REG_TimerValue0, Buff, 2);
            }

        I2C_Unlock();
        }
    }




//-----------------------------------------------------------------------------
//      Ÿ̸Ӱ 0̵Ǹ ͷƮ ɰ
//-----------------------------------------------------------------------------
BOOL WINAPI RV3032_EnableTimerInt(int Period)
    {
    int  Rslt=0, Ctrl;

    if (I2C_Lock())
        {
        if ((Ctrl=RV3032_ReadReg(RV3032REG_Control1))>=0)
            {
            Ctrl&=~RV3032REG_TDMASK;
            Ctrl|=Period;
            if (RV3032_WriteReg(RV3032REG_Control1, Ctrl)) Rslt++;
            }

        if ((Ctrl=RV3032_ReadReg(RV3032REG_Control2))>=0)
            {
            if (RV3032_WriteReg(RV3032REG_Control2, Ctrl|RV3032REG_TIE)) Rslt++;
            }
        I2C_Unlock();
        }
    return Rslt==2;
    }




//-----------------------------------------------------------------------------
//      RV3032 Ǿ ִ üũ
//-----------------------------------------------------------------------------
BOOL WINAPI RV3032_CheckChip(VOID)
    {
    int  I, Rslt=FALSE;

    for (I=0; I<3; I++)
        {
        if (RV3032_ReadReg(0)>=0) {Rslt++; break;}
        }
    return Rslt;
    }



//-----------------------------------------------------------------------------
//         (StartAdd:0~, ϰ -1̸  )
//-----------------------------------------------------------------------------
int WINAPI RV3032_ReadUserByte(UINT StartAdd)
    {
    int Rslt=-1;

    if (I2C_Lock())
        {
        Rslt=RV3032_ReadReg(StartAdd+RV3032REG_UserRam);
        I2C_Unlock();
        }
    return Rslt;
    }




//-----------------------------------------------------------------------------
//         (StartAdd:0~15)
//-----------------------------------------------------------------------------
BOOL WINAPI RV3032_WriteUserByte(UINT StartAdd, UINT Data)
    {
    BOOL Rslt=FALSE;

    if (I2C_Lock())
        {
        Rslt=RV3032_WriteReg(StartAdd+RV3032REG_UserRam, Data);
        I2C_Unlock();
        }
    return Rslt;
    }



//-----------------------------------------------------------------------------
//      RTC ð ȿ Ȯ
//-----------------------------------------------------------------------------
BOOL WINAPI RV3032_IsSynchronized(VOID)
    {
    int Rslt=FALSE;

    if (I2C_Lock())
        {
        if (RV3032_ReadReg(RV3032REG_UserRam+RTCUSER_Synchronized)==RTC_SynchronizedSign) Rslt++;
        I2C_Unlock();
        }
    return Rslt;
    }




//-----------------------------------------------------------------------------
//      EEPROM Busy̸ ٸ (Timerout̸ FALSE)
//-----------------------------------------------------------------------------
LOCAL(BOOL) RV3032_WaitEepBusy(UINT Timeout)
    {
    int  Rslt=FALSE, T;
    UINT Tick;

    Tick=GetTickCount();
    for (;;)
        {
        T=RV3032_ReadReg(RV3032REG_TemperatureLSBs);
        if (T>=0 && (T & RV3032REG_EepBusy)==0) {Rslt++; break;}
        if (GetTickCount()-Tick>=Timeout) break;
        }
    return Rslt;
    }



//-----------------------------------------------------------------------------
//       ϵ 
//-----------------------------------------------------------------------------
BOOL WINAPI RV3032_SetBackupPowerEeprom(VOID)
    {
    int Rslt=FALSE, Ctrl;

    if (I2C_Lock())
        {
        if ((Ctrl=RV3032_ReadReg(RV3032REG_Control1))>=0)
            {
            RV3032_WriteReg(RV3032REG_Control1, Ctrl|RV3032REG_EERD);
            RV3032_WaitEepBusy(10);

            RV3032_WriteReg(RV3032REG_EepAddress, RV3032REG_EEPROM_PMU);
            RV3032_WriteReg(RV3032REG_EepData, RV3032REG_OUR_PMU_VALUE);
            RV3032_WriteReg(RV3032REG_EepCommand, EEPCMD_WRITEBYTE);
            Rslt=RV3032_WaitEepBusy(100);   //10ms

            RV3032_WriteReg(RV3032REG_Control1, Ctrl&~RV3032REG_EERD);
            }
        I2C_Unlock();
        }
    return Rslt;
    }



//-----------------------------------------------------------------------------
//       Ŀ   Ȯ
//-----------------------------------------------------------------------------
BOOL WINAPI RV3032_CheckBackupPowerSetting(VOID)
    {
    int  Rslt=FALSE, Ctrl;

    if (I2C_Lock())
        {
        if ((Ctrl=RV3032_ReadReg(RV3032REG_Control1))>=0)
            {
            RV3032_WriteReg(RV3032REG_Control1, Ctrl|RV3032REG_EERD);
            RV3032_WaitEepBusy(10);

            RV3032_WriteReg(RV3032REG_EepAddress, RV3032REG_EEPROM_PMU);
            RV3032_WriteReg(RV3032REG_EepData, 0);
            RV3032_WriteReg(RV3032REG_EepCommand, EEPCMD_READBYTE);
            RV3032_WaitEepBusy(10);     //1ms

            if (RV3032_ReadReg(RV3032REG_EepData)==RV3032REG_OUR_PMU_VALUE) Rslt++;

            RV3032_WriteReg(RV3032REG_Control1, Ctrl&~RV3032REG_EERD);
            }
        I2C_Unlock();
        }
    return Rslt;
    }


