///////////////////////////////////////////////////////////////////////////////
//              SHT20 ½ 
//              SHT31-DIS ½ 
//              SHT40 ½ , 2021-12-02 ߰
///////////////////////////////////////////////////////////////////////////////

#include "JLIB.H"
#include "DRIVER.H"
#include "JOS.H"
#include "SHT20.H"


#define SHT20_DEVICEADD     0x80
#define SHT31_DEVICEADD     0x88 //0x88(ADDR=0), 8A(ADDR=1)
#define SHT40_DEVICEADD     0x88

static BYTE InstalledSht20;
static BYTE InstalledSht31;
static BYTE InstalledSht40;



//-----------------------------------------------------------------------------
//      CRC8  (Polynomial=0x31(x^8+x^5+x^4+1))
//      CalcCrc8({0xBE,0xEF}, 0xFF) = 0x92
//-----------------------------------------------------------------------------
LOCAL(int) CalcCrc8(LPCBYTE Data, int DataBytes)
    {
    int I,J, Crc=0xFF;

    for (I=0; I<DataBytes; I++)
        {
        Crc^=Data[I];
        for (J=0; J<8; J++)
            {
            Crc<<=1;
            if (Crc & 0x100) Crc^=0x31;
            }
        }
    return Crc & 0xFF;
    }




//-----------------------------------------------------------------------------
//      ½ б
//
//Temp 0x73E0 -> 32.687
//HM   0x58f2 -> 37.426
//-----------------------------------------------------------------------------
LOCAL(int) SHT20_Read(int Cmd, BOOL *lpRslt)
    {
    int  Rslt=0, Value=0;
    BYTE Buff[4];

    if (I2C_Lock()==FALSE) goto Exit;

    Buff[0]=Cmd;        //Temp NoHold Master
    if (I2C_MasterTx(IIC1, SHT20_DEVICEADD, Buff, 1, 50)==FALSE) goto ProcExit;

    Sleep(Cmd==0xF3 ? 70:30);

    if (I2C_MasterRx(IIC1, SHT20_DEVICEADD, Buff, 2, 50)==FALSE) goto ProcExit;

    #if 0
    //̷ ϸ    
    for (I=0; I<10; I++)
        {
        if (I2C_MasterRx(IIC1, SHT20_DEVICEADD, Buff, 2, 50)!=FALSE) break;
        }
    if (I>=10) goto ProcExit;
    #endif

    Value=PeekBIW(Buff)>>2; //Status Bit Clear
    //Value=((Cmd==0xF3) ? 0x73E0:0x58f2)>>2;
    //Printf("SENSOR: SHT20 %02X%02X %02X (%d)"CRLF, Buff[0], Buff[1], Buff[2], Value);

    //Printf("SENSOR: SHT20 %d, %X"CRLF, Cmd, Value);
    //1  ̷  ߻ϰ InitI2C() ȣϸ ذǴ    װ 
    //SENSOR: SHT20 0, 3CC0
    //SENSOR: SHT20 1, 3D40
    //SENSOR: SHT20 T=117.82
    //SENSOR: SHT20 H=113.62

    if (Cmd==0xF3)
        Value=((Value*17384)>>14)-4719;         //T = -46.85 + 175.72 * ST / 2^14
    else
        Value=((Value*12500)>>14)-600;          //RH = -6    + 125   * SRH / 2^14

    Rslt=TRUE;

    ProcExit:
    I2C_Unlock();

    Exit:
    *lpRslt=Rslt;
    return Value;
    }



//-----------------------------------------------------------------------------
//      SHT20 
//-----------------------------------------------------------------------------
LOCAL(BOOL) SHT20_Reset(VOID)
    {
    BOOL Rslt=FALSE;
    BYTE Buff[4];

    if (I2C_Lock())
        {
        Buff[0]=0xFE;   //Soft Reset
        Rslt=I2C_MasterTx(IIC1, SHT20_DEVICEADD, Buff, 1, 50);
        I2C_Unlock();
        }
    return Rslt;
    }



//-----------------------------------------------------------------------------
//      ½ б
//-----------------------------------------------------------------------------
LOCAL(BOOL) SHT31_Read(int *lpTemp, int *lpHumi)
    {
    int  Value, Rslt=FALSE;
    BYTE Buff[8];
    DWORD Time;

    if (I2C_Lock()==FALSE) goto Exit;

    Buff[0]=0x24;   //No Clock Stretching Mode
    Buff[1]=0x0B;   //Medium Repeatability
    if (I2C_MasterTx(IIC1, SHT31_DEVICEADD, Buff, 2, 50)==FALSE) goto ProcExit;

    HAL_Delay(10);  //5ms 

    Time=GetTickCount();
    for (;;)
        {
        if (I2C_MasterRx(IIC1, SHT31_DEVICEADD, Buff, 6, 50)!=FALSE) break;
        if (GetTickCount()-Time>=100) goto ProcExit;
        }

    if (CalcCrc8(Buff+0, 2)==Buff[2])
        {
        Value=PeekBIW(Buff+0);
        *lpTemp=(Value*16530>>16) -4320 +90;        //Ŵ Value*17500/65535 - 4500
        }
    else Printf("SENSOR: SHT31 Temp Crc Error"CRLF);

    if (CalcCrc8(Buff+3, 2)==Buff[5])
        {
        Value=PeekBIW(Buff+3);
        *lpHumi=(Value*5000>>16) + 2400;            //޴ Value*10000/65535
        }
    else Printf("SENSOR: SHT31 Humi Crc Error"CRLF);

    Rslt++;

    ProcExit:
    I2C_Unlock();

    Exit:
    return Rslt;
    }




//-----------------------------------------------------------------------------
//      SHT31 
//-----------------------------------------------------------------------------
LOCAL(BOOL) SHT31_Reset(VOID)
    {
    BOOL Rslt=FALSE;
    BYTE Buff[4];

    if (I2C_Lock())
        {
        Buff[0]=0x30;   //Soft Reset
        Buff[1]=0xA2;
        Rslt=I2C_MasterTx(IIC1, SHT31_DEVICEADD, Buff, 2, 50);
        I2C_Unlock();
        }
    return Rslt;
    }




//-----------------------------------------------------------------------------
//      ½ б
//-----------------------------------------------------------------------------
LOCAL(BOOL) SHT40_Read(int *lpTemp, int *lpHumi)
    {
    int  Value, Rslt=FALSE;
    BYTE Buff[8];
    DWORD Time;

    if (I2C_Lock()==FALSE) goto Exit;

    Buff[0]=0xFD;
    if (I2C_MasterTx(IIC1, SHT40_DEVICEADD, Buff, 1, 50)==FALSE) goto ProcExit;

    HAL_Delay(10);

    Time=GetTickCount();
    for (;;)
        {
        if (I2C_MasterRx(IIC1, SHT40_DEVICEADD, Buff, 6, 50)!=FALSE) break;
        if (GetTickCount()-Time>=100) goto ProcExit;
        }

    if (CalcCrc8(Buff+0, 2)==Buff[2])
        {
        Value=PeekBIW(Buff+0);
        *lpTemp=(Value*17500>>16) - 4500;       //Ŵ Value*17500/65535 - 4500
        }
    else Printf("SENSOR: SHT40 Temp Crc Error"CRLF);

    if (CalcCrc8(Buff+3, 2)==Buff[5])
        {
        Value=PeekBIW(Buff+3);
        *lpHumi=(Value*12500>>16) - 600;        //޴ Value*12500/65535 - 600
        }
    else Printf("SENSOR: SHT40 Humi Crc Error"CRLF);

    Rslt++;

    ProcExit:
    I2C_Unlock();

    Exit:
    return Rslt;
    }




//-----------------------------------------------------------------------------
//      SHT40 
//-----------------------------------------------------------------------------
LOCAL(BOOL) SHT40_Reset(VOID)
    {
    BOOL Rslt=FALSE;
    BYTE Buff[4];

    if (I2C_Lock())
        {
        Buff[0]=0x94;   //Soft Reset
        Rslt=I2C_MasterTx(IIC1, SHT40_DEVICEADD, Buff, 1, 50);
        I2C_Unlock();
        }
    return Rslt;
    }




//-----------------------------------------------------------------------------
//      SHT20/SHT31/SHT40 б
//-----------------------------------------------------------------------------
BOOL WINAPI SHT_Read(int *lpTemp, int *lpHumi)
    {
    BOOL Rslt=FALSE, Rslt20T, Rslt20H;

    *lpTemp=*lpHumi=0;
    if (InstalledSht20)
        {
        *lpTemp=SHT20_Read(0xF3, &Rslt20T);
        if (*lpTemp>11700 || Rslt20T==FALSE)
            {
            InitI2C(IIC1, 0);
            *lpTemp=SHT20_Read(0xF3, &Rslt20T);
            }
        *lpHumi=SHT20_Read(0xF5, &Rslt20H);
        Rslt=Rslt20T && Rslt20H;
        }
    else if (InstalledSht31) Rslt=SHT31_Read(lpTemp, lpHumi);
    else if (InstalledSht40) Rslt=SHT40_Read(lpTemp, lpHumi);
    return Rslt;
    }




//-----------------------------------------------------------------------------
//      SHT20/SHT31/SHT40 ʱȭ
//-----------------------------------------------------------------------------
BOOL WINAPI SHT_Init(VOID)
    {
    int I, Rslt=TRUE;

    for (I=0; I<3; I++)
        {
        if (SHT20_Reset()!=FALSE) {Printf("SENSOR: Found SHT20"CRLF); InstalledSht20=1; goto ProcExit;}
        }
    if (I>=3) Printf("SENSOR: Not found SHT20"CRLF);

    for (I=0; I<3; I++)
        {
        if (SHT31_Reset()!=FALSE) {Printf("SENSOR: Found SHT31"CRLF); InstalledSht31=1; goto ProcExit;}
        }
    if (I>=3) Printf("SENSOR: Not found SHT31"CRLF);

    for (I=0; I<3; I++)
        {
        if (SHT40_Reset()!=FALSE) {Printf("SENSOR: Found SHT40"CRLF); InstalledSht40=1; goto ProcExit;}
        }
    if (I>=3) Printf("SENSOR: Not found SHT40"CRLF);
    Rslt=FALSE;

    ProcExit:
    return Rslt;
    }


