


#ifndef __STM32L0xx_H
#define __STM32L0xx_H

#ifdef __cplusplus
extern"C"
{
#endif


#if !defined (STM32L0)
#define STM32L0
#endif


#if !defined (STM32L011xx) && !defined (STM32L021xx) && \
    !defined(STM32L031xx) && !defined(STM32L041xx) && \
    !defined(STM32L051xx) && !defined(STM32L052xx) && !defined(STM32L053xx) && \
    !defined(STM32L061xx) && !defined(STM32L062xx) && !defined(STM32L063xx) && \
    !defined(STM32L071xx) && !defined(STM32L072xx) && !defined(STM32L073xx) && \
    !defined(STM32L081xx) && !defined(STM32L082xx) && !defined(STM32L083xx)\
    /* #define STM32L011xx */
#endif

#if !defined  (USE_HAL_DRIVER)
#endif

#define __STM32L0xx_CMSIS_VERSION_MAIN   (0x01)
#define __STM32L0xx_CMSIS_VERSION_SUB1   (0x07)
#define __STM32L0xx_CMSIS_VERSION_SUB2   (0x02)
#define __STM32L0xx_CMSIS_VERSION_RC     (0x00)
#define __STM32L0xx_CMSIS_VERSION        ((__STM32L0xx_CMSIS_VERSION_MAIN     << 24)\
    |(__STM32L0xx_CMSIS_VERSION_SUB1<<16)\
    |(__STM32L0xx_CMSIS_VERSION_SUB2<<8)\
    |(__STM32L0xx_CMSIS_VERSION_RC))


#if defined(STM32L011xx)
#include "stm32l011xx.h"
#elif defined(STM32L021xx)
#include "stm32l021xx.h"
#elif defined(STM32L031xx)
#include "stm32l031xx.h"
#elif defined(STM32L041xx)
#include "stm32l041xx.h"
#elif defined(STM32L051xx)
#include "stm32l051xx.h"
#elif defined(STM32L052xx)
#include "stm32l052xx.h"
#elif defined(STM32L053xx)
#include "stm32l053xx.h"
#elif defined(STM32L062xx)
#include "stm32l062xx.h"
#elif defined(STM32L063xx)
#include "stm32l063xx.h"
#elif defined(STM32L061xx)
#include "stm32l061xx.h"
#elif defined(STM32L071xx)
#include "stm32l071xx.h"
#elif defined(STM32L072xx)
#include "stm32l072xx.h"
#elif defined(STM32L073xx)
#include "stm32l073xx.h"
#elif defined(STM32L082xx)
#include "stm32l082xx.h"
#elif defined(STM32L083xx)
#include "stm32l083xx.h"
#elif defined(STM32L081xx)
#include "stm32l081xx.h"
#else
#error "Please select first the target STM32L0xx device used in your application (in stm32l0xx.h file)"
#endif


typedef enum
    {
    RESET=0,
        SET=!RESET
    }
FlagStatus, ITStatus;

typedef enum
    {
    DISABLE=0,
        ENABLE=!DISABLE
    }
FunctionalState;
#define IS_FUNCTIONAL_STATE(STATE) (((STATE) == DISABLE) || ((STATE) == ENABLE))

typedef enum
    {
    ERROR=0,
        SUCCESS=!ERROR
    }
ErrorStatus;



#define SET_BIT(REG, BIT)     ((REG) |= (BIT))

#define CLEAR_BIT(REG, BIT)   ((REG) &= ~(BIT))

#define READ_BIT(REG, BIT)    ((REG) & (BIT))

#define CLEAR_REG(REG)        ((REG) = (0x0))

#define WRITE_REG(REG, VAL)   ((REG) = (VAL))

#define READ_REG(REG)         ((REG))

#define MODIFY_REG(REG, CLEARMASK, SETMASK)  WRITE_REG((REG), (((READ_REG(REG)) & (~(CLEARMASK))) | (SETMASK)))


#if defined (USE_HAL_DRIVER)
#include "stm32l0xx_hal.h"
#endif

#ifdef __cplusplus
}
#endif

#endif



