
#include "stm32l0xx_hal.h"


#ifdef HAL_MODULE_ENABLED




#define __STM32L0xx_HAL_VERSION_MAIN   (0x01U)
#define __STM32L0xx_HAL_VERSION_SUB1   (0x0AU)
#define __STM32L0xx_HAL_VERSION_SUB2   (0x00U)
#define __STM32L0xx_HAL_VERSION_RC     (0x00U)
#define __STM32L0xx_HAL_VERSION         ((__STM32L0xx_HAL_VERSION_MAIN << 24U)\
    |(__STM32L0xx_HAL_VERSION_SUB1<<16U)\
    |(__STM32L0xx_HAL_VERSION_SUB2<<8U)\
    |(__STM32L0xx_HAL_VERSION_RC))

#define IDCODE_DEVID_MASK    ((uint32_t)0x00000FFFU)



__IO uint32_t uwTick;



HAL_StatusTypeDef HAL_Init(void)
    {
    HAL_StatusTypeDef status=HAL_OK;

    #if (BUFFER_CACHE_DISABLE != 0)
    __HAL_FLASH_BUFFER_CACHE_DISABLE();
    #endif

    #if (PREREAD_ENABLE != 0)
    __HAL_FLASH_PREREAD_BUFFER_ENABLE();
    #endif

    #if (PREFETCH_ENABLE != 0)
    __HAL_FLASH_PREFETCH_BUFFER_ENABLE();
    #endif

    if (HAL_InitTick(TICK_INT_PRIORITY)!=HAL_OK)
        {
        status=HAL_ERROR;
        }
    else
        {
        HAL_MspInit();
        }

    return status;
    }



HAL_StatusTypeDef HAL_DeInit(void)
    {
    __HAL_RCC_APB1_FORCE_RESET();
    __HAL_RCC_APB1_RELEASE_RESET();

    __HAL_RCC_APB2_FORCE_RESET();
    __HAL_RCC_APB2_RELEASE_RESET();

    __HAL_RCC_AHB_FORCE_RESET();
    __HAL_RCC_AHB_RELEASE_RESET();

    __HAL_RCC_IOP_FORCE_RESET();
    __HAL_RCC_IOP_RELEASE_RESET();

    HAL_MspDeInit();

    return HAL_OK;
    }



__weak void HAL_MspInit(void)
    {
    }



__weak void HAL_MspDeInit(void)
    {
    }



__weak HAL_StatusTypeDef HAL_InitTick(uint32_t TickPriority)
    {
    HAL_StatusTypeDef status=HAL_OK;

    if (HAL_SYSTICK_Config(SystemCoreClock/1000UL)!=0U)
        {
        status=HAL_ERROR;
        }
    else
        {
        HAL_NVIC_SetPriority(SysTick_IRQn, TickPriority, 0);
        }

    return status;
    }





__weak void HAL_IncTick(void)
    {
    uwTick++;
    }



__weak uint32_t HAL_GetTick(void)
    {
    return uwTick;
    }



__weak void HAL_Delay(uint32_t Delay)
    {
    uint32_t tickstart=HAL_GetTick();
    uint32_t wait=Delay;

    if (wait<HAL_MAX_DELAY)
        {
        wait++;
        }

    while ((HAL_GetTick()-tickstart)<wait)
        {
        }
    }



__weak void HAL_SuspendTick(void)
    {
    SysTick->CTRL&=~SysTick_CTRL_TICKINT_Msk;
    }



__weak void HAL_ResumeTick(void)
    {
    SysTick->CTRL|=SysTick_CTRL_TICKINT_Msk;
    }



uint32_t HAL_GetHalVersion(void)
    {
    return __STM32L0xx_HAL_VERSION;
    }



uint32_t HAL_GetREVID(void)
    {
    return((DBGMCU->IDCODE)>>16U);
    }



uint32_t HAL_GetDEVID(void)
    {
    return((DBGMCU->IDCODE)&IDCODE_DEVID_MASK);
    }



uint32_t HAL_GetUIDw0(void)
    {
    return(READ_REG(*((uint32_t*) UID_BASE)));
    }



uint32_t HAL_GetUIDw1(void)
    {
    return(READ_REG(*((uint32_t*)(UID_BASE+4U))));
    }



uint32_t HAL_GetUIDw2(void)
    {
    return(READ_REG(*((uint32_t*)(UID_BASE+8U))));
    }





void HAL_DBGMCU_EnableDBGSleepMode(void)
    {
    SET_BIT(DBGMCU->CR, DBGMCU_CR_DBG_SLEEP);
    }



void HAL_DBGMCU_DisableDBGSleepMode(void)
    {
    CLEAR_BIT(DBGMCU->CR, DBGMCU_CR_DBG_SLEEP);
    }



void HAL_DBGMCU_EnableDBGStopMode(void)
    {
    SET_BIT(DBGMCU->CR, DBGMCU_CR_DBG_STOP);
    }



void HAL_DBGMCU_DisableDBGStopMode(void)
    {
    CLEAR_BIT(DBGMCU->CR, DBGMCU_CR_DBG_STOP);
    }



void HAL_DBGMCU_EnableDBGStandbyMode(void)
    {
    SET_BIT(DBGMCU->CR, DBGMCU_CR_DBG_STANDBY);
    }



void HAL_DBGMCU_DisableDBGStandbyMode(void)
    {
    CLEAR_BIT(DBGMCU->CR, DBGMCU_CR_DBG_STANDBY);
    }



void HAL_DBGMCU_DBG_EnableLowPowerConfig(uint32_t Periph)
    {
    assert_param(IS_DBGMCU_PERIPH(Periph));

    DBGMCU->CR|=Periph;
    }


void HAL_DBGMCU_DBG_DisableLowPowerConfig(uint32_t Periph)
    {
    assert_param(IS_DBGMCU_PERIPH(Periph));
        {
        DBGMCU->CR&=~Periph;
        }
    }





uint32_t HAL_SYSCFG_GetBootMode(void)
    {
    return(SYSCFG->CFGR1&SYSCFG_CFGR1_BOOT_MODE);
    }



void HAL_SYSCFG_VREFINT_OutputSelect(uint32_t SYSCFG_Vrefint_OUTPUT)
    {
    assert_param(IS_SYSCFG_VREFINT_OUT_SELECT(SYSCFG_Vrefint_OUTPUT));

    SYSCFG->CFGR3&=~(SYSCFG_CFGR3_VREF_OUT);
    SYSCFG->CFGR3|=(uint32_t)(SYSCFG_Vrefint_OUTPUT);
    }



void HAL_SYSCFG_Enable_Lock_VREFINT(void)
    {
    SET_BIT(SYSCFG->CFGR3, SYSCFG_CFGR3_REF_LOCK);
    }



void HAL_SYSCFG_Disable_Lock_VREFINT(void)
    {
    CLEAR_BIT(SYSCFG->CFGR3, SYSCFG_CFGR3_REF_LOCK);
    }





#endif

