

#include "stm32l0xx.h"

#if !defined  (HSE_VALUE)
#define HSE_VALUE    8000000
#endif

#if !defined  (MSI_VALUE)
#define MSI_VALUE    2097152
#endif

#if !defined  (HSI_VALUE)
#define HSI_VALUE    16000000
#endif


uint32_t SystemCoreClock=2097152;
const uint8_t AHBPrescTable[16]={0, 0, 0, 0, 0, 0, 0, 0, 1, 2, 3, 4, 6, 7, 8, 9};
const uint8_t APBPrescTable[8]={0, 0, 0, 0, 1, 2, 3, 4};
const uint8_t PLLMulTable[9]={3, 4, 6, 8, 12, 16, 24, 32, 48};


void SystemInit(void)
    {
    RCC->CR|=0x00000100;
    RCC->CFGR&=0x88FF400C;
    RCC->CR&=0xFEF6FFF6;
    RCC->CRRCR&=0xFFFFFFFE;
    RCC->CR&=0xFFFBFFFF;
    RCC->CFGR&=0xFF02FFFF;
    RCC->CIER=0x00000000;

    #ifdef VECT_TAB_SRAM
    SCB->VTOR=SRAM_BASE;
    #else
    SCB->VTOR=FLASH_BASE;
    #endif
    }




