
#ifndef __STM32L0xx_HAL_CONF_H
#define __STM32L0xx_HAL_CONF_H

#ifdef __cplusplus
extern"C"
{
#endif


#define HAL_MODULE_ENABLED
#define HAL_ADC_MODULE_ENABLED
// #define HAL_COMP_MODULE_ENABLED
// #define HAL_CRC_MODULE_ENABLED
// #define HAL_CRYP_MODULE_ENABLED
#define HAL_DAC_MODULE_ENABLED
#define HAL_DMA_MODULE_ENABLED
// #define HAL_FIREWALL_MODULE_ENABLED
#define HAL_FLASH_MODULE_ENABLED
#define HAL_GPIO_MODULE_ENABLED
#define HAL_I2C_MODULE_ENABLED
// #define HAL_I2S_MODULE_ENABLED
#define HAL_IWDG_MODULE_ENABLED
// #define HAL_LCD_MODULE_ENABLED
#define HAL_LPTIM_MODULE_ENABLED
#define HAL_PWR_MODULE_ENABLED
#define HAL_RCC_MODULE_ENABLED
// #define HAL_RNG_MODULE_ENABLED
#define HAL_RTC_MODULE_ENABLED
#define HAL_SPI_MODULE_ENABLED
#define HAL_TIM_MODULE_ENABLED
// #define HAL_TSC_MODULE_ENABLED
#define HAL_UART_MODULE_ENABLED
// #define HAL_USART_MODULE_ENABLED
// #define HAL_IRDA_MODULE_ENABLED
// #define HAL_SMARTCARD_MODULE_ENABLED
// #define HAL_SMBUS_MODULE_ENABLED
// #define HAL_WWDG_MODULE_ENABLED
#define HAL_CORTEX_MODULE_ENABLED
// #define HAL_PCD_MODULE_ENABLED



#if !defined  (HSE_VALUE)
#define HSE_VALUE                   8000000
#endif

#if !defined  (HSE_STARTUP_TIMEOUT)
#define HSE_STARTUP_TIMEOUT         100
#endif

#if !defined  (MSI_VALUE)
#define MSI_VALUE                   2097152
#endif

#if !defined  (HSI_VALUE)
#define HSI_VALUE                   16000000
#endif

#if !defined  (HSI48_VALUE)
#define HSI48_VALUE                 48000000
#endif

#if !defined  (LSI_VALUE)
#define LSI_VALUE                   37000
#endif /* LSI_VALUE */
#if !defined  (LSE_VALUE)
#define LSE_VALUE                   32768
#endif

#if !defined  (LSE_STARTUP_TIMEOUT)
#define LSE_STARTUP_TIMEOUT         5000
#endif



#define  VDD_VALUE                  3300
#define  TICK_INT_PRIORITY          ((1<<__NVIC_PRIO_BITS)-1)
#define  USE_RTOS                   0
#define  PREFETCH_ENABLE            1
#define  PREREAD_ENABLE             0
#define  BUFFER_CACHE_DISABLE       0



#define USE_SPI_CRC                 1


#ifdef HAL_RCC_MODULE_ENABLED
#include "stm32l0xx_hal_rcc.h"
#endif

#ifdef HAL_GPIO_MODULE_ENABLED
#include "stm32l0xx_hal_gpio.h"
#endif

#ifdef HAL_DMA_MODULE_ENABLED
#include "stm32l0xx_hal_dma.h"
#endif

#ifdef HAL_CORTEX_MODULE_ENABLED
#include "stm32l0xx_hal_cortex.h"
#endif

#ifdef HAL_ADC_MODULE_ENABLED
#include "stm32l0xx_hal_adc.h"
#endif

#ifdef HAL_COMP_MODULE_ENABLED
#include "stm32l0xx_hal_comp.h"
#endif

#ifdef HAL_CRC_MODULE_ENABLED
#include "stm32l0xx_hal_crc.h"
#endif

#ifdef HAL_CRYP_MODULE_ENABLED
#include "stm32l0xx_hal_cryp.h"
#endif

#ifdef HAL_DAC_MODULE_ENABLED
#include "stm32l0xx_hal_dac.h"
#endif

#ifdef HAL_FIREWALL_MODULE_ENABLED
#include "stm32l0xx_hal_firewall.h"
#endif

#ifdef HAL_FLASH_MODULE_ENABLED
#include "stm32l0xx_hal_flash.h"
#endif

#ifdef HAL_I2C_MODULE_ENABLED
#include "stm32l0xx_hal_i2c.h"
#endif

#ifdef HAL_I2S_MODULE_ENABLED
#include "stm32l0xx_hal_i2s.h"
#endif

#ifdef HAL_IWDG_MODULE_ENABLED
#include "stm32l0xx_hal_iwdg.h"
#endif

#ifdef HAL_LCD_MODULE_ENABLED
#include "stm32l0xx_hal_lcd.h"
#endif

#ifdef HAL_LPTIM_MODULE_ENABLED
#include "stm32l0xx_hal_lptim.h"
#endif

#ifdef HAL_PWR_MODULE_ENABLED
#include "stm32l0xx_hal_pwr.h"
#endif

#ifdef HAL_RNG_MODULE_ENABLED
#include "stm32l0xx_hal_rng.h"
#endif

#ifdef HAL_RTC_MODULE_ENABLED
#include "stm32l0xx_hal_rtc.h"
#endif

#ifdef HAL_SPI_MODULE_ENABLED
#include "stm32l0xx_hal_spi.h"
#endif

#ifdef HAL_TIM_MODULE_ENABLED
#include "stm32l0xx_hal_tim.h"
#endif

#ifdef HAL_TSC_MODULE_ENABLED
#include "stm32l0xx_hal_tsc.h"
#endif

#ifdef HAL_UART_MODULE_ENABLED
#include "stm32l0xx_hal_uart.h"
#endif

#ifdef HAL_USART_MODULE_ENABLED
#include "stm32l0xx_hal_usart.h"
#endif

#ifdef HAL_IRDA_MODULE_ENABLED
#include "stm32l0xx_hal_irda.h"
#endif

#ifdef HAL_SMARTCARD_MODULE_ENABLED
#include "stm32l0xx_hal_smartcard.h"
#endif

#ifdef HAL_SMBUS_MODULE_ENABLED
#include "stm32l0xx_hal_smbus.h"
#endif

#ifdef HAL_WWDG_MODULE_ENABLED
#include "stm32l0xx_hal_wwdg.h"
#endif

#ifdef HAL_PCD_MODULE_ENABLED
#include "stm32l0xx_hal_pcd.h"
#endif

#ifdef  USE_FULL_ASSERT
#define assert_param(expr) ((expr) ? (void)0U : assert_failed((uint8_t *)__FILE__, __LINE__))
void assert_failed(uint8_t*file, uint32_t line);
#else
#define assert_param(expr) ((void)0U)
#endif

#ifdef __cplusplus
}
#endif

#endif //__STM32L0xx_HAL_CONF_H

