;//////////////////////////////////////////////////////////////////////////////
;       Cortex-M0    Ϳ ϴ  ϰ  
;
;[ȵǴ¸]
;       ldr     SP,[R0]
;       push    {R4-R11}
;
;[Ǵ¸]
;       push    {R7,LR}
;       pop     {R7,PC}
;       msr     XPSR,R2
;       msr     APSR,R2
;       mrs     R0,APSR         ;__get_APSR() ... cmsis_armcc.h  inline  
;       mrs     R0,XPSR         ;__get_xPSR()           "
;       mrs     R0,PSP          ;__get_PSP()            "
;       mrs     R0,MSP          ;__get_MSP()            "
;       mrs     R0,CONTROL      ;__get_CONTROL()        "  0̸ MSP, 1̸ PSP, ͼǸ忡 ׻ MSP
;       mrs     R0,PRIMASK      ;__get_PRIMASK()  ͷƮ ̳̺ ũ  (0 ̳̺)
;//////////////////////////////////////////////////////////////////////////////



;------------------------------------------------------------------------------
;               ũ
;------------------------------------------------------------------------------
                macro
        call    $Label
                bl      $Label
                mend

                macro
        jmp     $Label
                b       $Label
                mend

                macro
        shl     $DestReg, $ShiftCnt
                lsls    $DestReg,$DestReg,#$ShiftCnt
                mend

                macro
        jb      $Label
                bcc     $Label
                mend

                macro
        je      $Label
                beq     $Label
                mend

                macro
        jz      $Label
                beq     $Label
                mend

                macro
        jne     $Label
                bne     $Label
                mend

                macro
        jnz     $Label
                bne     $Label
                mend

                macro
        jns     $Label
                bpl     $Label
                mend

                macro
        MovM    $Dest, $Via, $Src
                mov     $Via,$Src
                mov     $Dest,$Via
                mend

                macro
        MovRH   $Dest, $Via, $Src
                movs    $Via,$Src
                mov     $Dest,$Via
                mend

                macro
        CmpRH   $Src, $Via, $Cmp
                mov     $Via,$Src
                cmps    $Via,$Cmp
                mend

                macro
        neg32   $DestReg
                negs    $DestReg,$DestReg
                mend

                ;R7   
                macro
        neg64   $HighReg,$LowReg
                movs    R7,#0
                rsbs    $LowReg,$LowReg,#0      ;$LowReg=0-$LowReg
                sbcs    R7,$HighReg             ;$HighReg=0-$HighReg-Cy
                mov     $HighReg,R7
                mend

                macro
        inc     $DestReg
                adds    $DestReg,#1
                mend

                macro
        dec     $DestReg
                subs    $DestReg,#1
                mend

                ;R7   
                macro
        xori    $DestReg,$Const
                movs    R7,#$Const
                eors    $DestReg,R7
                mend

                ;R7   
                macro
        sbci    $DestReg,$Const
                movs    R7,#$Const
                sbcs    $DestReg,R7
                mend

                macro
        or      $DestReg,$OpReg
                orrs    $DestReg,$OpReg
                mend

                macro
        shr     $DestReg,$ShiftCnt
                lsrs    $DestReg,$DestReg,#$ShiftCnt
                mend

                macro
        Mul16   $DestReg,$SrcReg        ; 32Ʈ ,   32Ʈ ǹǷ 16Ʈ*16Ʈ 
                muls    $DestReg,$SrcReg,$DestReg
                mend


                macro
        WeakFunc $FncName
                export  $FncName [WEAK]
$FncName
                mend
;------------------------------------------------------------------------------
;               ũ 
;------------------------------------------------------------------------------




;//////////////////////////////////////////////////////////////////////////////
;//               ҽ 
;//////////////////////////////////////////////////////////////////////////////


Stack_Size      equ     0x800

                AREA    STACK, NOINIT, READWRITE, ALIGN=3
Stack_Mem       SPACE   Stack_Size
__initial_sp



Heap_Size       equ     0x20

                AREA    HEAP, NOINIT, READWRITE, ALIGN=3
__heap_base
Heap_Mem        SPACE   Heap_Size
__heap_limit

                PRESERVE8
                THUMB


                import  NMI_Handler_C
                import  HardFault_Handler_C
                import  SVC_Handler_C
                import  PendSV_Handler_C
                import  SysTick_Handler_C
                import  UndefinedIntHandler_C
                import  __main
                import  SystemInit


; Vector Table Mapped to Address 0 at Reset
                AREA    RESET, DATA, READONLY
                EXPORT  __Vectors
                EXPORT  __Vectors_End
                EXPORT  __Vectors_Size

__Vectors       DCD     __initial_sp              ; Top of Stack
                DCD     Reset_Handler             ; Reset Handler
                DCD     NMI_Handler               ; NMI Handler
                DCD     HardFault_Handler         ; Hard Fault Handler
                DCD     0                         ; Reserved
                DCD     0                         ; Reserved
                DCD     0                         ; Reserved
                DCD     0                         ; Reserved
                DCD     0                         ; Reserved
                DCD     0                         ; Reserved
                DCD     0                         ; Reserved
                DCD     SVC_Handler               ; SVCall Handler
                DCD     0                         ; Reserved
                DCD     0                         ; Reserved
                DCD     PendSV_Handler            ; PendSV Handler
                DCD     SysTick_Handler           ; SysTick Handler

                ; External Interrupts
                DCD     WWDG_IRQHandler                ; Window Watchdog
                DCD     PVD_IRQHandler                 ; PVD through EXTI Line detect
                DCD     RTC_IRQHandler                 ; RTC through EXTI Line
                DCD     FLASH_IRQHandler               ; FLASH
                DCD     RCC_CRS_IRQHandler             ; RCC and CRS
                DCD     EXTI0_1_IRQHandler             ; EXTI Line 0 and 1
                DCD     EXTI2_3_IRQHandler             ; EXTI Line 2 and 3
                DCD     EXTI4_15_IRQHandler            ; EXTI Line 4 to 15
                DCD     TSC_IRQHandler                 ; TSC
                DCD     DMA1_Channel1_IRQHandler       ; DMA1 Channel 1
                DCD     DMA1_Channel2_3_IRQHandler     ; DMA1 Channel 2 and Channel 3
                DCD     DMA1_Channel4_5_6_7_IRQHandler ; DMA1 Channel 4, Channel 5, Channel 6 and Channel 7
                DCD     ADC1_COMP_IRQHandler           ; ADC1, COMP1 and COMP2
                DCD     LPTIM1_IRQHandler              ; LPTIM1
                DCD     USART4_5_IRQHandler            ; USART4 and USART5
                DCD     TIM2_IRQHandler                ; TIM2
                DCD     TIM3_IRQHandler                ; TIM3
                DCD     TIM6_DAC_IRQHandler            ; TIM6 and DAC
                DCD     TIM7_IRQHandler                ; TIM7
                DCD     0                              ; Reserved
                DCD     TIM21_IRQHandler               ; TIM21
                DCD     I2C3_IRQHandler                ; I2C3
                DCD     TIM22_IRQHandler               ; TIM22
                DCD     I2C1_IRQHandler                ; I2C1
                DCD     I2C2_IRQHandler                ; I2C2
                DCD     SPI1_IRQHandler                ; SPI1
                DCD     SPI2_IRQHandler                ; SPI2
                DCD     USART1_IRQHandler              ; USART1
                DCD     USART2_IRQHandler              ; USART2
                DCD     AES_RNG_LPUART1_IRQHandler     ; RNG and LPUART1
                DCD     LCD_IRQHandler                 ; LCD
                DCD     USB_IRQHandler                 ; USB

__Vectors_End

__Vectors_Size  EQU  __Vectors_End - __Vectors

                AREA    |.text|, CODE, READONLY

; Reset handler routine
Reset_Handler    proc
                 export  Reset_Handler                 [WEAK]
                 ldr     R0, =SystemInit
                 blx     R0
                 ldr     R0, =__main
                 bx      R0
                 endp
                 align




;------------------------------------------------------------------------------
;               Ÿ ͼ ڵ鷯
;------------------------------------------------------------------------------
NMI_Handler     proc
                push    {R4-R7}
                mov     R0,SP
                ldr     R1,=NMI_Handler_C
                bx      R1
                endp
                align


HardFault_Handler proc
                push    {R4-R7}
                mov     R0,SP
                ldr     R1,=HardFault_Handler_C
                bx      R1
                endp
                align


SVC_Handler     proc
                push    {R4-R7}
                mov     R0,SP
                ldr     R1,=SVC_Handler_C
                bx      R1
                endp
                align


PendSV_Handler  proc
                export  PendSV_Handler [WEAK]
                push    {R4-R7}
                mov     R0,SP
                ldr     R1,=PendSV_Handler_C
                bx      R1
                endp
                align


SysTick_Handler proc
                export  SysTick_Handler [WEAK]      ;1ms Ÿ̸, DRIVER.C ȿ C 
                push    {R4-R7}
                mov     R0,SP
                ldr     R1,=SysTick_Handler_C
                bx      R1
                endp
                align




;------------------------------------------------------------------------------
;       ڵ鷯 غ  ó
;------------------------------------------------------------------------------
Default_Handler proc
                WeakFunc WWDG_IRQHandler
                WeakFunc PVD_IRQHandler
                WeakFunc RTC_IRQHandler
                WeakFunc FLASH_IRQHandler
                WeakFunc RCC_CRS_IRQHandler
                WeakFunc EXTI0_1_IRQHandler
                WeakFunc EXTI2_3_IRQHandler
                WeakFunc EXTI4_15_IRQHandler
                WeakFunc TSC_IRQHandler
                WeakFunc DMA1_Channel1_IRQHandler
                WeakFunc DMA1_Channel2_3_IRQHandler
                WeakFunc DMA1_Channel4_5_6_7_IRQHandler
                WeakFunc ADC1_COMP_IRQHandler
                WeakFunc LPTIM1_IRQHandler
                WeakFunc USART4_5_IRQHandler
                WeakFunc TIM2_IRQHandler
                WeakFunc TIM3_IRQHandler
                WeakFunc TIM6_DAC_IRQHandler
                WeakFunc TIM7_IRQHandler
                WeakFunc TIM21_IRQHandler
                WeakFunc TIM22_IRQHandler
                WeakFunc I2C1_IRQHandler
                WeakFunc I2C2_IRQHandler
                WeakFunc I2C3_IRQHandler
                WeakFunc SPI1_IRQHandler
                WeakFunc SPI2_IRQHandler
                WeakFunc USART1_IRQHandler
                WeakFunc USART2_IRQHandler
                WeakFunc AES_RNG_LPUART1_IRQHandler
                WeakFunc LCD_IRQHandler
                WeakFunc USB_IRQHandler

                push    {R4-R7}
                mov     R0,SP
                ldr     R1,=UndefinedIntHandler_C
                bx      R1

                endp
                align




;------------------------------------------------------------------------------
;       User Stack and Heap initialization
;------------------------------------------------------------------------------
                if      :DEF:__MICROLIB

                export  Stack_Mem
                export  __initial_sp
                export  __heap_base
                export  __heap_limit

                else

                import  __use_two_region_memory
                export  __user_initial_stackheap

__user_initial_stackheap

                ldr     R0,=Heap_Mem
                ldr     R1,=(Stack_Mem + Stack_Size)
                ldr     R2,=(Heap_Mem +  Heap_Size)
                ldr     R3,=Stack_Mem
                bx      LR
                endif
                align



;------------------------------------------------------------------------------
;      int WINAPI MulDiv(int Multiplicand, int Multiplier, int Divisor);
;------------------------------------------------------------------------------
                export  MulDiv
MulDiv          proc
                push    {R4-R7,LR}

                ;smull   R0,R1,R1,R0    ;R1|R0=R1*R0   Cortex-M0 

                movs    R7,#1
                movs    R6,#0           ; ȣ
                or      R0,R0
                jns     MulDiv100
                neg32   R0
                mov     R6,R7           ;R6=1
MulDiv100
                or      R1,R1
                jns     MulDiv150
                neg32   R1
                eors    R6,R7

MulDiv150
                uxth    R3,R0           ;R3=R0&0xFFFF
                lsrs    R4,R0,#16       ;R4=R0>>16

                uxth    R5,R1           ;R5=R1&0xFFFF
                lsrs    R7,R1,#16       ;R7=R1>>16

                mov     R0,R3
                Mul16   R0,R5           ;R0<-Low16Ʈ 

                mov     R1,R4
                Mul16   R1,R7           ;R1<-High16Ʈ 

                Mul16   R3,R7
                lsrs    R7,R3,#16
                shl     R3,16
                adds    R0,R3
                adcs    R1,R7

                Mul16   R4,R5
                lsrs    R5,R4,#16
                shl     R4,16
                adds    R0,R4
                adcs    R1,R5

                or      R2,R2
                jns     MulDiv200
                neg32   R2
                xori    R6,1            ;R7
MulDiv200
                movs    R3,#64          ;BitCount
                movs    R5,#0           ;, ߿  
MulDiv400
                adds    R0,R0           ;CF<-R0<-0
                adcs    R1,R1           ;CF<-R1<-CF
                adcs    R5,R5

                cmp     R5,R2
                jb      MulDiv600
                subs    R5,R2
                inc     R0
MulDiv600
                dec     R3
                jnz     MulDiv400

                ;ݿøó
                shr     R2,1            ;/2
                cmp     R5,R2
                jb      MulDiv700
                inc     R0
MulDiv700
                or      R6,R6
                jz      MulDivQt
                neg32   R0
MulDivQt
                pop     {R4-R7,PC}
                endp
                align





;------------------------------------------------------------------------------
;      UINT WINAPI UDivMod(UINT Dividend, UINT Divisor, UINT *lpRemain);
;                               R0             R1             R2
;------------------------------------------------------------------------------
                export  UDivMod
UDivMod         proc
                push    {R4,LR}

                movs    R3,#32          ;BitCount
                movs    R4,#0           ;, ߿  
UDivMod100
                adds    R0,R0           ;CF<-R0<-0
                adcs    R4,R4

                cmp     R4,R1
                jb      UDivMod200
                subs    R4,R1
                inc     R0
UDivMod200
                dec     R3
                jnz     UDivMod100

                str     R4,[R2]
                pop     {R4,PC}
                endp
                align



;------------------------------------------------------------------------------
;      UINT64 WINAPI UDivMod64(UINT64 Dividend, UINT Divisor, UINT *lpRemain);
;                                     R1|R0          R2             R3
;------------------------------------------------------------------------------
                export  UDivMod64
UDivMod64       proc
                push    {R4-R5,LR}

                movs    R4,#64          ;BitCount
                movs    R5,#0           ;, ߿  
UDivMod64_10
                adds    R0,R0           ;CF<-R0<-0
                adcs    R1,R1           ;CF<-R1<-CF
                adcs    R5,R5

                cmp     R5,R2
                jb      UDivMod64_20
                subs    R5,R2
                inc     R0
UDivMod64_20
                dec     R4
                jnz     UDivMod64_10

                str     R5,[R3]
                pop     {R4-R5,PC}
                endp
                align




                end




