/* XDCtools Header files */
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <stddef.h>
#include <xdc/std.h>

/* BIOS Header files */
#include <ti/sysbios/BIOS.h>
#include <ti/sysbios/knl/Task.h>


/* Drivers */
#include <ti/drivers/PIN.h>
#include <ti/drivers/pin/PINCC26XX.h>
#include <ti/drivers/GPIO.h>
#include <ti/drivers/Timer.h>
#include <ti/drivers/timer/GPTimerCC26XX.h>


#include <ti/devices/DeviceFamily.h>
#include DeviceFamily_constructPath(driverlib/rf_prop_mailbox.h)

/* Board Header files */
#include "Board.h"

/* Application Header files */
#include "RFQueue.h"
#include "smartrf_settings/smartrf_settings.h"

/* Pin driver handle */
static PIN_Handle ledPinHandle;
static PIN_State ledPinState;

/*
 * Application LED pin configuration table:
 * - All LEDs board LEDs are off.
 */

PIN_Config pinTable[] =
{
 Board_PIN_1 | PIN_GPIO_OUTPUT_EN | PIN_GPIO_LOW | PIN_PUSHPULL | PIN_DRVSTR_MAX,
 Board_PIN_4 | PIN_GPIO_OUTPUT_EN | PIN_GPIO_HIGH | PIN_PUSHPULL | PIN_DRVSTR_MAX,

// Board_PIN_LED0 | PIN_GPIO_OUTPUT_EN | PIN_GPIO_LOW | PIN_PUSHPULL | PIN_DRVSTR_MAX,
// Board_PIN_LED1 | PIN_GPIO_OUTPUT_EN | PIN_GPIO_HIGH | PIN_PUSHPULL | PIN_DRVSTR_MAX,
 PIN_TERMINATE
};

/***** Defines *****/
#define TIMER_TASK_STACK_SIZE 1024
#define TIMER_TASK_PRIORITY   1

/***** Prototypes *****/
static void timerTaskFunction(UArg arg0, UArg arg1);

/***** Variable declarations *****/
static Task_Params timerTaskParams;
Task_Struct timerTask;    /* not static so you can see in ROV */
static uint8_t timerTaskStack[TIMER_TASK_STACK_SIZE];

GPTimerCC26XX_Handle hTimer = NULL;
static PIN_Handle pinHandle;

/***** Function definitions *****/


void TimerTask_init(PIN_Handle ledPinHandle)
{
    pinHandle = ledPinHandle;
    Task_Params_init(&timerTaskParams);
    timerTaskParams.stackSize = TIMER_TASK_STACK_SIZE;
    timerTaskParams.priority = TIMER_TASK_PRIORITY;
    timerTaskParams.stack = &timerTaskStack;
    timerTaskParams.arg0 = (UInt)1000000;
    Task_construct(&timerTask, timerTaskFunction, &timerTaskParams, NULL);
}

// Timercallback2 is continuous running timer of 10 msec

void timerCallback(GPTimerCC26XX_Handle handle, GPTimerCC26XX_IntMask interruptMask)
{
    PIN_setOutputValue(pinHandle, Board_PIN_4, !PIN_getOutputValue(Board_PIN_4));
    PIN_setOutputValue(pinHandle, Board_PIN_1, !PIN_getOutputValue(Board_PIN_1));

  //  PIN_setOutputValue(pinHandle, Board_PIN_LED0, !PIN_getOutputValue(Board_PIN_LED0));
  //  PIN_setOutputValue(pinHandle, Board_PIN_LED1, !PIN_getOutputValue(Board_PIN_LED1));
}

static void timerTaskFunction(UArg arg0, UArg arg1)
{
    ledPinHandle = PIN_open(&ledPinState, pinTable);
    GPTimerCC26XX_Params params;
    GPIO_init();
    GPTimerCC26XX_Params_init(&params);
    params.width          = GPT_CONFIG_32BIT;
    params.mode           = GPT_MODE_PERIODIC_UP;              //GPT_MODE_ONESHOT_UPGPT_MODE_PERIODIC_UP
    params.debugStallMode = GPTimerCC26XX_DEBUG_STALL_OFF;


    GPTimerCC26XX_Handle hTimer;
    hTimer = GPTimerCC26XX_open(CC1350_LAUNCHXL_433_GPTIMER0A, &params);
    GPTimerCC26XX_Value loadVal =  47999999;       //47999999=1sec 19199999=400 5999999=125ms 95999999=2sec 9599999=200 msec 95999=2msec 239999=5msec 479999=10msec 383999=8msec 239999=5msec 191999=4msec
    GPTimerCC26XX_setLoadValue(hTimer, loadVal);
    GPTimerCC26XX_registerInterrupt(hTimer, timerCallback, GPT_INT_TIMEOUT);
    GPTimerCC26XX_start(hTimer);
}

/*
 * ======== main ========
*/
int main(void)
{
    /* Call driver init functions. */
    Board_initGeneral();

    /* Open LED pins */
    ledPinHandle = PIN_open(&ledPinState, pinTable);
    TimerTask_init(ledPinHandle);

    /* Start BIOS */
    BIOS_start();

    return (0);
}



