/*
 *  ======== empty.c ========
 */

/* For usleep() */
#include <unistd.h>
#include <stdint.h>
#include <stddef.h>

/* Driver Header files */
#include <ti/drivers/GPIO.h>

/* Driver configuration */
#include "ti_drivers_config.h"

#include <ti/devices/DeviceFamily.h>
#include DeviceFamily_constructPath(driverlib/aon_rtc.h)
#include DeviceFamily_constructPath(driverlib/aon_event.h)

#define RTC_1_MS_VALUE          (0x40)
#define WAKEUP_INTERVAL_VALUE   (200 * RTC_1_MS_VALUE) // 200 ms

/*
 *  ======== myHookCH1 ========
 */
void myHookCH1(void)
{
    // Recharge RTC wakeup after RTC_100_MS_VALUE
    AONRTCCompareValueSet(AON_RTC_CH1, AONRTCCompareValueGet(AON_RTC_CH1) + WAKEUP_INTERVAL_VALUE);
    GPIO_toggle(CONFIG_GPIO_LED_0);
}

/*
 *  ======== mainThread ========
 */
void *mainThread(void *arg0)
{
    /* Call driver init functions */
    GPIO_init();

    /* Configure the LED pin */
    GPIO_setConfig(CONFIG_GPIO_LED_0, GPIO_CFG_OUT_STD | GPIO_CFG_OUT_LOW);

    /* Turn on user LED */
    GPIO_write(CONFIG_GPIO_LED_0, CONFIG_GPIO_LED_ON);

    AONRTCEventClear(AON_RTC_CH1);
    // Charge RTC wakeup period WAKEUP_INTERVAL_VALUE
    AONRTCCompareValueSet(AON_RTC_CH1, AONRTCCompareValueGet(AON_RTC_CH1) + WAKEUP_INTERVAL_VALUE);
    AONRTCCombinedEventConfig(AON_RTC_CH0 | AON_RTC_CH1);
    AONEventMcuWakeUpSet(AON_EVENT_MCU_WU1, AON_EVENT_RTC_CH1);
    AONRTCChannelEnable(AON_RTC_CH1);

    while (1) {
        // loop forever
        sleep(1);
    }
}
