/**
  **************************************************************************************************
  * @project    Keypad
  * @file       Debug.с
  * @date       12.2016
  * @prefix     DBG_
  * @modify     Suslov Petr 
  * @brief      Debug print function
  **************************************************************************************************
**/
#pragma once

//Includes
#include "main.h"
#include <stdint.h>

//Definitions
#if defined DeviceFamily_CC13X0 || defined DeviceFamily_CC13X2
    #define DEBUG_STR_LENGTH    256
#else
    #define DEBUG_STR_LENGTH    64
#endif

//API
char*   ssprintf( const char *sfmt, ... );

#if USE_DEBUG

void UART_Init();
void UART_PutBuff( char* buffer, uint16_t len );
void UART_PutString( const char* str );

  #if (defined USE_UART_TEST_MODE) && ((defined DeviceFamily_CC13X2) || (defined DeviceFamily_CC13X0))
    #include <xdc/runtime/System.h>
    #define DBG_printf(args ...)    {System_printf(##args);System_flush();}
    #define DBGF(...)               {System_printf(ssprintf(__VA_ARGS__));System_flush();}
  #else
    void    DBG_printf( const char* fmt, ... );
    #ifdef UART_Ex
      #define DBG(X)      {UARTx_PutString(UART_Ex_DEBUG, X);}
      #define DBGF(...)   {UARTx_PutString(UART_Ex_DEBUG, ssprintf(__VA_ARGS__));}
    #else
      #define DBG(X)      {UART_PutString(X);}
      #define DBGF(...)   {UART_PutString(ssprintf(__VA_ARGS__));}
    #endif
  #endif

  void DBGH( char* title, void* buf, uint32_t buf_len );
#else

  //MACRO
  #define DBG_PIN_INIT        {}
  #define DBG_PIN_ON          {}
  #define DBG_PIN_OFF         {}

  //API
  #define DBG_printf(...)     do{}while(0)
  #define DBGH(...)           do{}while(0)
  #define DBG(...)            do{}while(0)
  #define DBGF(...)           do{}while(0)

#endif /* USE_DEBUG */
