/**
 *  @file       RFU40.h
 *
 *  @brief      Header file for ADC test
 *
 *  @author Marek Klimeš, <klimes@metra-su.cz>

 *  @bug
 */


#ifndef __RFU40_H
#define __RFU40_H


// ADC0 measurement
#define MEAS_VBAT_PERIOD  300000   ///< =3 sec., period for voltage measurement in system_tick()

#define MEAS_VBAT_COUNT 4           ///< Number of sample count

#define ADCBUFFERSIZE (MEAS_VBAT_COUNT) ///< ADC buffer size

/***** Defines *****/
#define MEAS_VBAT_TASK_STACK_SIZE 1024
#define MEAS_VBAT_TASK_PRIORITY   1




/** @brief Task for voltage measurement.
 *
 *  The task is configured statically in the cfg file.
 */
void measVbatTaskFcn(void);


/** @brief Clock callback function for voltage measurement period
 *
 *  This clock callback function is registered statically in the cfg file.
 */
void clockMeasVbatFcn(void);

/** @brief Callback function for full ADC buffer
 *
 */
void adcBufFullCallback(ADCBuf_Handle adcHandle, ADCBuf_Conversion *conversionStruct,
    void *completedADCBuffer, uint32_t completedChannel);


#endif /* __RFU40_H */
