## Example Summary

Sample application to read Temperature from the TMP116 sensor.

## Peripherals Exercised

* `Board_I2C0` - I2C used to communicate with TMP116 Sensor

## Resources & Jumper Settings

>Please refer to the development board's specific __Settings and Resources__
section in the Getting Started Guide. For convenience, a short summary is also
shown below.

| Development board | Notes                                                  |
| ----------------- | ------
| CC1310_LAUNCHXL   | This example uses BOOSTXL-SENSORS boosterpack 				  |
| CC1350_LAUNCHXL   | This example uses BOOSTXL-SENSORS boosterpack                   |                             
| CC3220SF_LAUNCHXL | This example uses BOOSTXL-SENSORS boosterpack                   |
| MSP-EXP432P401R   | This example uses BOOSTXL-SENSORS boosterpack                   |
| CC2640R2_LAUNCHXL | This example uses BOOSTXL-SENSORS boosterpack                   |


> Fields left blank have no specific settings for this example.

## Example Usage

* Connect the BOOSTXL-BASSSENSORS to the LaunchPad before powering the hardware.

* Connect to the valid COM port of the LaunchPad.

* Run the example.

* The example collects the samples for Temperature from TMP116 driver and displays it on Serial Console as show below.

```
Starting the i2ctmp116 sensor example...

I2C Initialized!

Temperature High Limit set: 30 (C)

Temperature Low Limit set: 20 (C)

Taking Preliminary Readings...

Temperature: 26.4522 (C)

Temperature: 26.3254 (C)

Temperature: 25.0124 (C)
```

## Application Design Details

This application uses 2 thread:

`mainThread` - performs the following actions:

1. Opens and initializes an I2C Driver.

2. Create Semaphore.

3. Create tmp116AlertTask.

2. Initialize the TMP116 sensor and set readout template.

3. Periodically read the Temperature reading from the TMP116 sensor

`tmp116AlertTask` - performs the following actions:

1. Pend on Semaphore.

2. Check what type of threshold was the MCU alerted for.