/*
 * sys_intf.h
 *
 *  Created on: 23 mars 2017
 *      Author: fperget
 */

#ifndef SYS_INTF_H_
#define SYS_INTF_H_

#include <stdint.h>

#define OPTOSONDE_SYS_INTF_MAGIC_BYTE 0xD5

#define OPTOSONDE_ADDR 0x68


typedef enum {
    optosonde_reason_periodic,
    optosonde_reason_button,
    optosonde_reason_activation,
    optosonde_reason_deactivation,
    optosonde_reason_sensorfail,
    optosonde_reason__max__,
    optosonde_reason_reset = 0xFD,
    optosonde_reason_startup = 0xFE,
	optosonde_reason_watchdog = 0xFF,
} optosonde_reason_t;

typedef struct {
	uint8_t     magic_byte;
    uint8_t     len;
    uint8_t     version;
	uint8_t     reason;
    uint32_t    gw_fw_version;
    uint32_t    node_fw_version;
    uint8_t     node_addr[8];
    int16_t     temp_deg;
    uint16_t    bat_mv;
	int8_t      rssi;
} __attribute__((__packed__))  optosonde_sys_intf_t;


#endif /* SYS_INTF_H_ */
