/// \addtogroup module_scif_driver_setup
//@{
#include "scif.h"
#include "scif_framework.h"
#ifdef DEVICE_FAMILY
    #define DEVICE_FAMILY_PATH(x) <ti/devices/DEVICE_FAMILY/x>
#else
    #define DEVICE_FAMILY_PATH(x) <x>
#endif
#include DEVICE_FAMILY_PATH(inc/hw_types.h)
#include DEVICE_FAMILY_PATH(inc/hw_memmap.h)
#include DEVICE_FAMILY_PATH(inc/hw_aon_event.h)
#include DEVICE_FAMILY_PATH(inc/hw_aon_rtc.h)
#include DEVICE_FAMILY_PATH(inc/hw_aon_wuc.h)
#include DEVICE_FAMILY_PATH(inc/hw_aux_sce.h)
#include DEVICE_FAMILY_PATH(inc/hw_aux_smph.h)
#include DEVICE_FAMILY_PATH(inc/hw_aux_evctl.h)
#include DEVICE_FAMILY_PATH(inc/hw_aux_aiodio.h)
#include DEVICE_FAMILY_PATH(inc/hw_aux_timer.h)
#include DEVICE_FAMILY_PATH(inc/hw_aux_wuc.h)
#include DEVICE_FAMILY_PATH(inc/hw_event.h)
#include DEVICE_FAMILY_PATH(inc/hw_ints.h)
#include DEVICE_FAMILY_PATH(inc/hw_ioc.h)
#include <string.h>
#if defined(__IAR_SYSTEMS_ICC__)
    #include <intrinsics.h>
#endif


// OSAL function prototypes
uint32_t scifOsalEnterCriticalSection(void);
void scifOsalLeaveCriticalSection(uint32_t key);




/// Firmware image to be uploaded to the AUX RAM
static const uint16_t pAuxRamImage[] = {
    /*0x0000*/ 0x1408, 0x040C, 0x1408, 0x042C, 0x1408, 0x0447, 0x1408, 0x044D, 0x4436, 0x2437, 0xAEFE, 0xADB7, 0x6442, 0x7000, 0x7C6B, 0x6871, 
    /*0x0020*/ 0x0068, 0x1425, 0x6872, 0x0069, 0x1425, 0x6873, 0x006A, 0x1425, 0x786B, 0xF801, 0xFA01, 0xBEF2, 0x786F, 0x6871, 0xFD0E, 0x6873, 
    /*0x0040*/ 0xED92, 0xFD06, 0x7C6F, 0x642D, 0x0450, 0x786B, 0x8F1F, 0xED8F, 0xEC01, 0xBE01, 0xADB7, 0x8DB7, 0x6630, 0x6542, 0x0000, 0x186F, 
    /*0x0060*/ 0x9D88, 0x9C01, 0xB60D, 0x1067, 0xAF19, 0xAA00, 0xB609, 0xA8FF, 0xAF39, 0xBE06, 0x0C6B, 0x8869, 0x8F08, 0xFD47, 0x9DB7, 0x086B, 
    /*0x0080*/ 0x8801, 0x8A01, 0xBEEC, 0x262F, 0xAEFE, 0x4630, 0x0450, 0x5527, 0x6642, 0x0000, 0x0C6B, 0x140B, 0x0450, 0x6742, 0x03FF, 0x0C6D, 
    /*0x00A0*/ 0x786C, 0x686D, 0xED37, 0xB605, 0x0000, 0x0C6C, 0x7C70, 0x652D, 0x0C6D, 0x786D, 0x686E, 0xFD0E, 0xF801, 0xE92B, 0xFD0E, 0xBE01, 
    /*0x00C0*/ 0x6436, 0xBDB7, 0x241A, 0xA6FE, 0xADB7, 0x641A, 0xADB7, 0x0000, 0x0089, 0x008A, 0x0183, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000, 
    /*0x00E0*/ 0x0000, 0x0000, 0x0000, 0x0000, 0x00EE, 0x00EF, 0x0077, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
    /*0x0100*/ 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xADB7, 0x5085, 0xD231, 0x0031, 0x8249, 0x1031, 0x2011, 
    /*0x0120*/ 0x1462, 0xDB4A, 0xFD47, 0xDB4A, 0x1465, 0x7005, 0x1584, 0x7005, 0x1591, 0x6428, 0x7076, 0x600A, 0x1599, 0x7005, 0x159F, 0x705D, 
    /*0x0140*/ 0x6003, 0x1599, 0x7001, 0x1462, 0xFB4D, 0x8609, 0x7101, 0x6431, 0x2531, 0xA6FE, 0xFB00, 0x7078, 0xFB4C, 0x7003, 0xFB4C, 0xFD47, 
    /*0x0160*/ 0xFB4C, 0x1465, 0x6403, 0x501F, 0xDB2C, 0xFDB1, 0xD902, 0x6876, 0xE805, 0xDF2E, 0x500F, 0x6876, 0xDF2E, 0x6500, 0x4500, 0x15AC, 
    /*0x0180*/ 0x1462, 0x70FF, 0xFB52, 0xFD47, 0xFB52, 0x1465, 0x1462, 0x8B4A, 0xFD47, 0x8B4A, 0x1465, 0x7005, 0x1584, 0x7005, 0x1591, 0x6428, 
    /*0x01A0*/ 0x7076, 0x600A, 0x1599, 0x7005, 0x159F, 0x705D, 0x6003, 0x1599, 0x7001, 0x1462, 0xFB4D, 0x8609, 0x7101, 0x6431, 0x2531, 0xA6FE, 
    /*0x01C0*/ 0xFB00, 0x7078, 0xFB4C, 0x7003, 0xFB4C, 0xFD47, 0xFB4C, 0x1465, 0x6403, 0x001F, 0x8B2C, 0xFDB1, 0x8902, 0x5876, 0xD806, 0x8F2D, 
    /*0x01E0*/ 0x0008, 0x5876, 0xD801, 0x8F2D, 0x6500, 0x4500, 0x15AC, 0x1462, 0x70FF, 0xFB52, 0xFD47, 0xFB52, 0x1465, 0x1462, 0x9B4A, 0xFD47, 
    /*0x0200*/ 0x9B4A, 0x1465, 0x7005, 0x1584, 0x7005, 0x1591, 0x6428, 0x7076, 0x600A, 0x1599, 0x7005, 0x159F, 0x705D, 0x6003, 0x1599, 0x7001, 
    /*0x0220*/ 0x1462, 0xFB4D, 0x8609, 0x7101, 0x6431, 0x2531, 0xA6FE, 0xFB00, 0x7078, 0xFB4C, 0x7003, 0xFB4C, 0xFD47, 0xFB4C, 0x1465, 0x6403, 
    /*0x0240*/ 0x001F, 0x8B2C, 0xFDB1, 0x8902, 0x1876, 0x9807, 0x8F29, 0x0003, 0x1876, 0x9802, 0x8F29, 0x6500, 0x4500, 0x15AC, 0x1462, 0x70FF, 
    /*0x0260*/ 0xFB52, 0xFD47, 0xFB52, 0x1465, 0x1462, 0xAB4A, 0xFD47, 0xAB4A, 0x1465, 0x7005, 0x1584, 0x7005, 0x1591, 0x6428, 0x7076, 0x600A, 
    /*0x0280*/ 0x1599, 0x7005, 0x159F, 0x705D, 0x6003, 0x1599, 0x7001, 0x1462, 0xFB4D, 0x8609, 0x7101, 0x6431, 0x2531, 0xA6FE, 0xFB00, 0x7078, 
    /*0x02A0*/ 0xFB4C, 0x7003, 0xFB4C, 0xFD47, 0xFB4C, 0x1465, 0x6403, 0x001F, 0x8B2C, 0xFDB1, 0x8902, 0x1876, 0x9808, 0x8F29, 0x0001, 0x1876, 
    /*0x02C0*/ 0x9803, 0x8F29, 0x6500, 0x4500, 0x15AC, 0x1462, 0x70FF, 0xFB52, 0xFD47, 0xFB52, 0x1465, 0x0004, 0x1876, 0x9804, 0x8F29, 0x0874, 
    /*0x02E0*/ 0x8812, 0x8601, 0x8A12, 0xAE02, 0x88DC, 0x8401, 0x2001, 0x1875, 0x8D29, 0xBE02, 0xADA0, 0x8E00, 0x186C, 0x9D0A, 0x1C6C, 0x0C74, 
    /*0x0300*/ 0x8DA9, 0x0C76, 0xADB7, 0xADB7, 0xF007, 0x1462, 0x86FF, 0x63F0, 0xEB50, 0x8680, 0x6000, 0xED8F, 0xEB48, 0xFD47, 0xEB48, 0x1465, 
    /*0x0320*/ 0xADB7, 0xED47, 0xEDAB, 0xE814, 0xF007, 0x5001, 0xDD87, 0xDF26, 0xADB7, 0xFB0C, 0xEDA4, 0xEB09, 0x640B, 0xCDB1, 0xADB7, 0xF007, 
    /*0x0340*/ 0x1462, 0x86FF, 0x63F8, 0xEB51, 0x8680, 0x6000, 0xED8F, 0xEB49, 0xFD47, 0xEB49, 0x1465, 0xADB7, 0x1462, 0x7079, 0xFB55, 0x71FB, 
    /*0x0360*/ 0xFB54, 0xFD47, 0xFB54, 0x1465, 0x4431, 0x4400, 0xADB7
};


/// Look-up table that converts from AUX I/O index to MCU IOCFG offset
static const uint8_t pAuxIoIndexToMcuIocfgOffsetLut[] = {
    0, 0, 0, 36, 32, 28, 24, 20, 8, 4, 0, 0, 0, 0, 0, 0
};


/** \brief Look-up table of data structure information for each task
  *
  * There is one entry per data structure (\c cfg, \c input, \c output and \c state) per task:
  * - [31:20] Data structure size (number of 16-bit words)
  * - [19:12] Buffer count (when 2+, first data structure is preceded by buffering control variables)
  * - [11:0] Address of the first data structure
  */
static const uint32_t pScifTaskDataStructInfoLut[] = {
//  cfg         input       output      state       
    0x00000000, 0x00000000, 0x009020EE, 0x00000000  // ADCmeas
};




// No task-specific initialization functions




// No task-specific uninitialization functions




/** \brief Initilializes task resource hardware dependencies
  *
  * This function is called by the internal driver initialization function, \ref scifInit().
  */
static void scifTaskResourceInit(void) {
    scifInitIo(5, AUXIOMODE_ANALOG, -1, 0);
} // scifTaskResourceInit




/** \brief Uninitilializes task resource hardware dependencies
  *
  * This function is called by the internal driver uninitialization function, \ref scifUninit().
  */
static void scifTaskResourceUninit(void) {
    scifUninitIo(5, -1);
} // scifTaskResourceUninit




/** \brief Re-initializes I/O pins used by the specified tasks
  *
  * It is possible to stop a Sensor Controller task and let the System CPU borrow and operate its I/O
  * pins. For example, the Sensor Controller can operate an SPI interface in one application state while
  * the System CPU with SSI operates the SPI interface in another application state.
  *
  * This function must be called before \ref scifExecuteTasksOnceNbl() or \ref scifStartTasksNbl() if
  * I/O pins belonging to Sensor Controller tasks have been borrowed System CPU peripherals.
  *
  * \param[in]      bvTaskIds
  *     Bit-vector of task IDs for the task I/Os to be re-initialized
  */
void scifReinitTaskIo(uint32_t bvTaskIds) {
    if (bvTaskIds & (1 << SCIF_ADCMEAS_TASK_ID)) {
        scifReinitIo(5, -1);
    }
} // scifReinitTaskIo




/// Driver setup data, to be used in the call to \ref scifInit()
const SCIF_DATA_T scifDriverSetup = {
    (volatile SCIF_INT_DATA_T*) 0x400E00D6,
    (volatile SCIF_TASK_CTRL_T*) 0x400E00DE,
    (volatile uint16_t*) 0x400E00CE,
    0x0000,
    sizeof(pAuxRamImage),
    pAuxRamImage,
    pScifTaskDataStructInfoLut,
    pAuxIoIndexToMcuIocfgOffsetLut,
    scifTaskResourceInit,
    scifTaskResourceUninit
};




// No task-specific API available


//@}


// Generated by WSBLADE-PC at 2017-10-20 16:48:57.075
