
 /*
 *  ======== ti_easylink_oad_config.h ========
 *  Configured OAD module definitions
 *
 *  DO NOT EDIT - This file is generated for the CC1352R1_LAUNCHXL
 *  by the SysConfig tool.
 */

#ifndef OAD_CONFIG_H_
#define OAD_CONFIG_H_
//*****************************************************************************
//
// If building with a C++ compiler, make all of the definitions in this header
// have a C binding.
//
//*****************************************************************************
#ifdef __cplusplus
extern "C"
{
#endif

#define STACK_LIBRARY // Image is an App & EasyLink stack combined

#define OADClient_MAX_RETRIES    4   // Max number of retries for timed out
                                     // packets to be used by client and server

#define OADClient_BLOCK_REQ_POLL_DELAY    80   // Block response poll delay
#define OAD_BLOCK_SIZE                    64

/* OADClient_BLOCK_REQ_RATE Guidance:
 * Minimum block request rate = Tbr
 * Time to fetch block from external flash = Tbf
 * Time to transmit block = Tbtx
 * Time for client to write block to external flash = Tbwr
 * Block size (bytes) = N
 *
 * Tbr = Tbf + Tbtx + Tbwr
 *
 * Tbtx:
 *    - 2-GFSK: ((8*N)+88) * (1/PHY_Rate)
 *
 *    - SLR: ((2*DSSS) * ((16*N*DSSS) + (28* DSSS) + ((M+1) * 64))) * (1/PHY_Rate)
 *        - Spreading = DSS = 2 by default from SmartRF Studio
 *        - M = 2
 *
 * Tbf = ((8*N) * (1/SPI_Rate)) + (N*Tfr) + Tc
 *      - Tfr = Flash byte read time(hardware specific)
 *      - Tc = Time for code overhead (e.g. CRC checking, DMA transfers from SPI, etc)
 *
 * Tbwr = ((8*N) * (1/SPI_Rate)) + (N*Tfw) + Tc
 *      - Tfw = Flash byte write time (hardware specific)
 *      - Tc = Time for code overhead (e.g. CRC checking, DMA transfers to SPI, etc)
 */
#define OADClient_BLOCK_REQ_RATE          160  // Block request rate


#ifdef __cplusplus
}
#endif

#endif //OAD_CONFIG_H_
