﻿#ifndef __DRIVER_H__
#define __DRIVER_H__

#include "STM32F0XX_Hal.h"
#include "IOPINMAP.H"

#ifdef __cplusplus
extern "C" {
#endif



VOID WINAPI FatalError(int Err);
//FatalError()의 인자
#define FERR_SYSCLKCFG  0
#define FERR_EXCEPTION  1
#define FERR_MEMORY     2


VOID WINAPI Delay_us(int T);
VOID WINAPI Delay1ms(UINT ms);
VOID WINAPI InitSystemClock(VOID);
VOID WINAPI TIM6_InitTick(int Freq);
VOID WINAPI TIM_Disable(TIM_TypeDef *TIMx);
VOID WINAPI TIM_Stop(TIM_TypeDef *TIMx);
VOID WINAPI TIM_Release(TIM_TypeDef *TIMx);
VOID WINAPI TIM_SetPrescalerFreq(TIM_TypeDef *TIMx, UINT Freq);
VOID WINAPI TIM_SetDivisor(TIM_TypeDef *TIMx, UINT Divisor);
VOID WINAPI TIM_UpCounterSetup(TIM_TypeDef *TIMx, UINT Freq, UINT Divisor);


enum{
    COM1=0,
    COM2,
    #ifndef STM32F042x6
    COM3,
    COM4,
    COM5,
    COM6,
    COM7,
    COM8,
    #endif
    USART_QTY
    };

VOID WINAPI InitUart(int ComNo, DWORD BaudRate, int Parity, int DataLen, int StopBit, int HwFlowCtl, BOOL AutoBaud);
                    //InitUart(COM2, 115200, UART_PARITY_NONE, UART_WORDLENGTH_8B, UART_STOPBITS_1, UART_HWCONTROL_NONE);


#define GPIO_SPEED_FREQ_VERY_HIGH   GPIO_SPEED_FREQ_HIGH        //L0시리즈에는 있지만 F0에 없음
VOID WINAPI GPIO_DeInit(int PinNo);
VOID WINAPI InitPort(int PinNo, int PinMode, int PullUpDown, int AltFnc);
VOID WINAPI InitPortEx(int PinNo, int PinMode, int PullUpDown, int AltFnc, int Speed);
VOID WINAPI InitPortOutputPP(int PinNo);
VOID WINAPI InitPortOutputOD(int PinNo);
VOID WINAPI InitPortInput(int PinNo, int PullUpDown);



#define LOW             0
#define HIGH            1
#define OFF             0
#define ON              1
#define ENABLE          1
#define DISABLE         0
#define LA_OFF          1
#define LA_ON           0
#define ACTIVE          1
#define DEACTIVE        0
#define LA_ACTIVE       0
#define LA_DEACTIVE     1
#define PO_NOT          2       //반전
#define PO_GETSTATE     3       //현재 상태를 리턴

BOOL  WINAPI PortOut(int PinNo, int PinData);
BOOL  WINAPI PortIn(int PinNo);
DWORD WINAPI PortAIn(VOID);
DWORD WINAPI PortBIn(VOID);
VOID  WINAPI PortAByteOut(int Data);
VOID  WINAPI PortBByteOut(int Data);
VOID  WINAPI PortBHighByteOut(int Data);

//PinNo
#define PA0     0
#define PA1     1
#define PA2     2
#define PA3     3
#define PA4     4
#define PA5     5
#define PA6     6
#define PA7     7
#define PA8     8
#define PA9     9
#define PA10    10
#define PA11    11
#define PA12    12
#define PA13    13
#define PA14    14
#define PA15    15

#define PB0     16
#define PB1     17
#define PB2     18
#define PB3     19
#define PB4     20
#define PB5     21
#define PB6     22
#define PB7     23
#define PB8     24
#define PB9     25
#define PB10    26
#define PB11    27
#define PB12    28
#define PB13    29
#define PB14    30
#define PB15    31

#define PC0     32
#define PC1     33
#define PC2     34
#define PC3     35
#define PC4     36
#define PC5     37
#define PC6     38
#define PC7     39
#define PC8     40
#define PC9     41
#define PC10    42
#define PC11    43
#define PC12    44
#define PC13    45
#define PC14    46
#define PC15    47

#define PD0     48
#define PD1     49
#define PD2     50
#define PD3     51
#define PD4     52
#define PD5     53
#define PD6     54
#define PD7     55
#define PD8     56
#define PD9     57
#define PD10    58
#define PD11    59
#define PD12    60
#define PD13    61
#define PD14    62
#define PD15    63

#define PE0     64
#define PE1     65
#define PE2     66
#define PE3     67
#define PE4     68
#define PE5     69
#define PE6     70
#define PE7     71
#define PE8     72
#define PE9     73
#define PE10    74
#define PE11    75
#define PE12    76
#define PE13    77
#define PE14    78
#define PE15    79

#define PF0     80
#define PF1     81
#define PF2     82
#define PF3     83
#define PF4     84
#define PF5     85
#define PF6     86
#define PF7     87
#define PF8     88
#define PF9     89
#define PF10    90
#define PF11    91
#define PF12    92
#define PF13    93
#define PF14    94
#define PF15    95

#define I2CPORT 96

VOID  WINAPI UART_SetBaudrate(int Port, DWORD NewBaud);
DWORD WINAPI UART_GetBaudrate(int Port);
BOOL  WINAPI UART_IsAutoBaudrate(int Port);
VOID  WINAPI UART_ClearAutoBaudrate(int Port);
VOID  WINAPI UART_SetAutoBaudrate(int Port, BOOL En, UINT Mode);
//UART_SetAutoBaudrate() Mode정의
#define AUTOBAUDRATE_ONSTARTBIT    0
#define AUTOBAUDRATE_ONFALLINGEDGE USART_CR2_ABRMODE_0
#define AUTOBAUDRATE_ON0X7FFRAME   USART_CR2_ABRMODE_1
#define AUTOBAUDRATE_ON0X55FRAME   USART_CR2_ABRMODE
VOID WINAPI UART_DisableRx(int Port);
VOID WINAPI UART_EnableRx(int Port);

int  WINAPI UART_RxByte(int Port);
int  WINAPI UART_RxByteIT(int Port);
int  WINAPI UART_RxByteRT(int Port, UINT TimeOut);
int  WINAPI UART_ReceiveCntIT(int Port);
VOID WINAPI UART_WaitAllSendIT(int ComPort, DWORD TimeOut);

VOID WINAPI UART_DisplayError(VOID);
int  WINAPI UART_InCTS(int Port);
int  WINAPI UART_OutRTS(int Port, BOOL EnableFg);
int  WINAPI UART_InDSR(int Port);
int  WINAPI UART_OutDTR(int Port, BOOL EnableFg);
BOOL WINAPI UART_TxByte(int Port, int Ch);
BOOL WINAPI UART_TxByteIT(int Port, int Ch);
VOID WINAPI UART_DispReg(int Port);
VOID WINAPI UART_SetHwFlow(int PortNo, BOOL En);
VOID WINAPI UART_TxStr(int Port, LPCSTR Str);
VOID WINAPI UART_TxBinIT(int Port, LPCBYTE Data, int SendBytes);
VOID WINAPI UART_TxBin(int Port, LPCBYTE Data, int SendBytes);
VOID WINAPI UART_TxStrIT(int Port, LPCSTR Str);
VOID WINAPI UART_TxChrIT(int Port, int Cha);
VOID Printf(LPCSTR DispStr, ...);
VOID LowPrintf(LPCSTR DispStr, ...);
VOID PrintfII(int Port, LPCSTR DispStr, ...);
BOOL WINAPI UART_485BinOut(int ComPort, LPCBYTE Data, int ToSendBytes, BOOL FirstDelayFg, int RetryQty, int DEPin);
BOOL WINAPI UART_485StrOut(int ComPort, LPCSTR Str, int DEPin);

int  WINAPI GetChar(VOID);
int  WINAPI GetDebugPort(VOID);
VOID WINAPI SetDebugPort(int PortNo);


#define GetTickCount    HAL_GetTick

#define HAL_LOCK(h, IsBusy)\
    do  {\
        IsBusy=0;\
        if ((h)->Lock==HAL_LOCKED) IsBusy=1;\
        else (h)->Lock=HAL_LOCKED;\
        } while (0)

#define HAL_UNLOCK(h)  (h)->Lock=HAL_UNLOCKED


#define IIC1    0
#define IIC2    1

VOID WINAPI InitI2C(int I2C_Ch, DWORD Timing);
BOOL WINAPI I2C_Lock(VOID);
VOID WINAPI I2C_Unlock(VOID);
BOOL WINAPI I2C_ReadByte(int I2C_Ch, int DevAddr, UINT MemAddr, LPVOID Data, int ReadSize);
BOOL WINAPI I2C_WriteByte(int I2C_Ch, int DevAddr, UINT MemAddr, LPCVOID Data, int DataSize);
BOOL WINAPI I2C_MasterTx(int I2C_Ch, int DevAddr, LPCBYTE lpData, int Size, int Timeout);
BOOL WINAPI I2C_MasterRx(int I2C_Ch, int DevAddr, LPBYTE lpData, int Size, int Timeout);
BOOL WINAPI I2C_MemRead(int I2C_Ch, UINT DevAddr, UINT MemAddr, UINT MemAddSize, LPBYTE lpData, UINT Size, DWORD Timeout);
BOOL WINAPI I2C_MemWrite(int I2C_Ch, UINT DevAddr, UINT MemAddr, UINT MemAddSize, LPCBYTE lpData, UINT Size, DWORD Timeout);
VOID WINAPI I2C_ErrorRecover(int I2C_Ch);
VOID WINAPI I2C_ConfigAnalogFilter(int I2C_Ch, UINT AnalogFilter);
VOID WINAPI I2C_ConfigDigitalFilter(int I2C_Ch, UINT DigitalFilter);
BOOL WINAPI I2C_IsDeviceReady(int I2C_Ch, UINT DevAddress, UINT Trials, UINT Timeout);


BOOL WINAPI SPI_TransmitReceive8(int SPI_Ch, LPCBYTE TxData, int TxSize, LPBYTE RxData, int RxSize, int RecvSkip, UINT Timeout);
BOOL WINAPI SPI_Receive8(int SPI_Ch, LPBYTE RxBuff, UINT Size, UINT Timeout);
BOOL WINAPI SPI_Transmit8(int SPI_Ch, LPCBYTE TxBuff, UINT Size, UINT Timeout);
#define SPI_CH1 0
#define SPI_CH2 1
VOID WINAPI SPI_InitMaster(int SPI_Ch, int BaudPrescaler);



#ifdef HAL_TIM_MODULE_ENABLED
VOID WINAPI TIM_PWM_Init(TIM_HandleTypeDef *hTmr);
VOID WINAPI TIM_PWM_ConfigChannel(TIM_HandleTypeDef *hTmr, TIM_OC_InitTypeDef *OCCfg, int Channel);
VOID WINAPI TIM_PWM_Duty(TIM_HandleTypeDef *hTmr, int Channel, int Permil);
VOID WINAPI TIM_PWM_SetOutPolarity(TIM_HandleTypeDef *hTmr, int Channel, int OCPolarity);
VOID WINAPI TIM_PWM_Start(TIM_HandleTypeDef *hTmr, int Channel);
VOID WINAPI TIM_PWM_Stop(TIM_HandleTypeDef *hTmr, int Channel);
#endif //HAL_TIM_MODULE_ENABLED

#ifndef FLASH_SIZE
#define FLASH_SIZE   (FLASH_BANK1_END+1-FLASH_BASE)
#endif

BOOL WINAPI FLASH_Program(UINT StartAddr, LPCVOID WriteBuff, int WriteBytes);
BOOL WINAPI FLASH_Unlock(VOID);
VOID WINAPI FLASH_Lock(VOID);
BOOL WINAPI FLASH_WriteIniData(UINT StartAddr, LPCVOID WriteData, int WriteBytes);
LPVOID WINAPI AllocFlash(UINT Size);


VOID WINAPI InitADC(VOID);
DWORD WINAPI ADC_GetValue(int Channel);


#define ADCAVERAGEQTY   20
typedef struct _ADCAVERAGE
    {
    int Cnt;
    short Data[ADCAVERAGEQTY];
    } ADCAVERAGE;

int WINAPI ADC_GetAverage(int ChNo, ADCAVERAGE *AA);


VOID WINAPI InitRTC(int RtcClock);
//RtcClock 정의
#define RTC_CLOCK_LSI   0   //내부 RC발진
#define RTC_CLOCK_LSE   1   //외부 32768Hz 크리스탈

typedef BOOL (*GETTIMEFT)(SYSTEMTIME *ST);
typedef BOOL (*SETTIMEFT)(CONST SYSTEMTIME *ST);
VOID WINAPI SetExtRtcFP(GETTIMEFT GetTimeFP, SETTIMEFT SetTimeFP);

VOID WINAPI GetLocalTime(SYSTEMTIME *ST);
BOOL WINAPI SetLocalTime(CONST SYSTEMTIME *ST);
JTIME WINAPI GetTodayToSecond(VOID);
VOID WINAPI RTC_SetAlarmTime(SYSTEMTIME *ST, BOOL EnableIT);
VOID WINAPI RTC_Calibration(VOID);

VOID WINAPI RTC_SetDeviation(int Deviation, int Period);
VOID WINAPI RTC_GetDeviation(int *lpDeviation, int *lpPeriod);
VOID WINAPI RTC_CalcDeviation(JTIME NewTime_Sec, UINT NewTime_ms);


VOID WINAPI PWR_EnterStopMode(int Regulator, int StopEntry);
VOID WINAPI DAC_SetValue(UINT Channel, UINT Alignment, UINT Data);
VOID WINAPI InitDAC(UINT Channel);


//-----------------------------------------------------------------------------
//          랜덤숫자
//-----------------------------------------------------------------------------
VOID WINAPI TM_RNG_Init(VOID);
UINT WINAPI TM_RNG_Get(VOID);



///////////////////////////////////////////////////////////////////////////////
//                              WatchDog
///////////////////////////////////////////////////////////////////////////////
VOID WINAPI IWDG_Refresh(VOID);
BOOL WINAPI IWDG_Init(int Prescaler, int Reload, int Window);
VOID WINAPI SystemReset(LPCSTR BootReason);


VOID WINAPI InitDriver(VOID);           //main()에서 맨 처름 호출할 것


#ifdef __cplusplus
}
#endif

#endif //__DRIVER_H__
