//----------------------------------------------------------------------------
//  One Way Audio Code
//
//  M J Burns
//  Texas Instruments, Rochester Design Center
//  December 2008
//                
//  For use with 'CC1150 Tx Rev D' and 'CC1101 Rx Rev B' cards
//
//----------------------------------------------------------------------------

#include "include.h"
#include "string.h"
#include "math.h"

// Test Pin Assignnments

// Receiver (CC1101 Rx Rev B)

// Status
// JP102 pin 1 (P1_3):  Buffer error  
// JP102 pin 2 (P4_7):  Buffer B available
// JP102 pin 3 (P4_6):  Buffer A available
// JP102 pin 4:         CC1101 SCLK
// JP102 pin 5:         CC1101 SO
// JP102 pin 6:         CC1101 SI
// JP102 pin 7:         GND
// JP102 pin 8:         CC1101 GDO0
// JP102 pin 9:         GND
// JP102 pin 10:        CC1101 CSN
// JP102 pin 11:        GND
// JP102 pin 12:        CC1101 GDO2

// JTAG Connector
// JP200 pin 1 (P1_7):  Timeout error/lost packet
// JP200 pin 3 (P1_6):  RX active
// JP200 pin 5 (P1_5):  Unpack RX Data
// JP200 pin 7 (P1_4):  CRC error

// Monitor (CC1150 Tx Rev D)

// Status
// JP102 pin 1:     GND
// JP102 pin 2:     CC1150 GDO0
// JP102 pin 3:     GND
// JP102 pin 4:     P2_5
// JP102 pin 5:     GND         
// JP102 pin 6:     P4_3
// JP102 pin 7:     P4_5
// JP102 pin 8:     P4_4
// JP102 pin 9:     P4_7
// JP102 pin 10:    P4_6
// JP102 pin 11:    GND
// JP102 pin 12:    P2_3
 
// JTAG Connector
// JP200 pin 1 (P1_7):  PLL Calibrate
// JP200 pin 3 (P1_6):  
// JP200 pin 5 (P1_5):  
// JP200 pin 7 (P1_4):  Using A (low) / Using B (high)  
 
void MSPInit(void) {

// Initilizes the MSP430 Ports, Timers, ADC, and USARTs
 
#ifdef MONITOR

// Monitor Settings     Pertains to CC1150 Tx Rev D

// P1_0  I/O  DO        Blue LED (Heartbeat)
// P1_1  I/O  DO	Red LED (Unassigned)
// P1_2  I/O  DI	PB1 (Locate)
// P1_3  I/O  DI	PB2 (Cancel Locate)
// P1_4  I/O  D0	JP200 (JTAG) pin 7
// P1_5  I/O  D0	JP200 (JTAG) pin 6
// P1_6  I/O  D0	JP200 (JTAG) pin 5
// P1_7  I/O  D0	JP200 (JTAG) pin 4

  P1SEL = 0x00; 
  P1DIR = 0xF3;
  P1OUT = 0x00;

// P2_0  I/O  DO	CC1150 CSN
// P2_1  I/O  DI	CC1150 GDO0
// P2_2  PMF  A		Microphone
// P2_3  I/O  DO	Test/Debug - JP102 pin 12
// P2_4  ---  A		Vref+
// P2.5  I/O  DO        Test/Debug - JP102 Pin 4
// P2_6  PMF  A         XTAL In
// P2_7  PMF  A         XTAL Out  
  

  P2SEL = 0xC4;
  P2DIR = 0x29;
  P2OUT = 0x01;	        // CSN is low true: Set high (false)

// P3_0  I/O  DI        LCD SYNC
// P3_1  PMF  DO	CC1150 SI
// P3_2  PMF  DI	CC1150 SO
// P3_3  PMF  DO	CC1150 SCLK   
// P3_4  PMF  DO	LCD TXD
// P3_5  PMF  DI	LCD RXD
// P3_6  I/O  DO	VGA_GAIN 0
// P3_7  I/O  DO	VGA_GAIN 1


  P3SEL = 0x3E;
  P3DIR = 0xC0;
  P3OUT = 0x00;
   
// P4_0  I/O  DO	Orange LED
// P4_1  I/O  DO	Yellow LED
// P4_2  I/O  DO	Blue LED
// P4_3  I/O  DO	Test/Debug - JP102 pin 6
// P4_4  I/O  DO	Test/Debug - JP102 pin 8
// P4_5  I/O  DO	Test/Debug - JP102 pin 7 (Skip a Packet)
// P4_6  I/O  DO	Test/Debug - JP102 pin 10 (TX On)
// P4_7  I/O  DO	Test/Debug - JP102 pin 9 (High while channel index equals 0)

  P4SEL = 0x00;
  P4DIR = 0xFF;
  P4OUT = 0x00;       

#else

// Receiver Settings

// P1_0  I/O  DO        Blue LED (Heartbeat)
// P1_1  I/O  DO	Red LED (Low Battery)
// P1_2  PMF  DO	PWM Out (TA1)
// P1_3  I/O  DO	JP102 pin 1
// P1_4  I/O  DO        JP200 (JTAG) pin 7
// P1_5  I/O  DO	JP200 (JTAG) pin 5
// P1_6  I/O  DO	JP200 (JTAG) pin 3
// P1_7  I/O  DO	JP200 (JTAG) pin 1 

  P1SEL = 0x04;             
  P1DIR = 0xFF;
  P1OUT = 0x00;
  
// P2_0  I/O  DO	CC1100 CSN
// P2_1  I/O  DI	CC1100 GDO0
// P2_2  PMF  A		Battery Monitor
// P2_3  I/O  DI	PB1 (Volume Up)
// P2_4  I/O  DI	PB2 (Volume Down)
// P2.5  I/O  DI        Unused
// P2_6  PMF  A         XTAL In
// P2_7  PMF  A         XTAL Out    

  P2SEL = 0xC4;
  P2DIR = 0x21;
  P2OUT = 0x01;         // CSN is low true: Set high (false)	

// P3_0  I/O  DI	LCD SYNC
// P3_1  PMF  DO	CC1100 SIMO
// P3_2  PMF  DI	CC1100 SOMI
// P3_3  PMF  DO	CC1100 SCLK   
// P3_4  PMF  DO	LCD TXD
// P3_5  PMF  DI	LCD RXD
// P3_6  I/O  DO	SPEAKER_GAIN 0
// P3_7  I/O  DO	SPEAKER_GAIN 1

  P3SEL = 0x3E;
  P3DIR = 0xDA;
  P3OUT = 0x00;
  
// P4_0  I/O  DO	Level D1
// P4_1  I/O  DO	Level D2
// P4_2  I/O  DO	Level D3
// P4_3  I/O  DO	Level D4
// P4_4  I/O  DO	Level D5
// P4_5  I/O  DO	Orange LED
// P4_6  I/O  DO	JP102 pin 3
// P4_7  I/O  DO	JP102 pin 2

  P4SEL = 0x00;
  P4DIR = 0xFF;
  P4OUT = 0x00;

#endif
   
// Timer A Configuration
  
  TACTL = TASSEL_2 | MC_0;    // Timer_A clock source; select SMCLK
                              // Timer_A Mode; Stop
  TACCR0 = 1024;              // 1024 tics = 62.5 usec (16 KHz) when SMCLK = 16.384 MHz
  TACCTL0 = CCIE;             // Enable CCR0 Interrupt
  TACTL |= MC_1;              // Timer_A Mode: Up to CCR0
  
#ifdef RECEIVER               // Additional Code to set up Timer_A for PWM output on TA1
  
  TACCTL1 = OUTMOD_7;         // Set OUTMODE1 to 7; use Compare Mode (CAP = 0)
 
// Timer B Configuration

  TBCTL = TBSSEL_2 | MC_0 | TBCLR | ID0;    // Timer_B clock source - select SMCLK/2; Stop the Timer
  TBCCR0 = 36864;                           // Count for 36864 tics = 4500 usec
    
#endif

// ADC10 Configuration 
  
  ADC10CTL0 = 0;               // Disable ADC10
 
  ADC10CTL0 = SREF_1 | ADC10SHT_2 | REFOUT | REF2_5V | REFON | ADC10ON;     
                               
                               // Reference: VR+ = VREF+ and VR- = AVSS
                               // ADC Sample and Hold Time: 16 clocks
                               // ADC10SR: 200 ksps
                               // REF: 2.5 Volts; Reference: On
                               // ADC10: On
   
  ADC10CTL1 = INCH_2 | ADC10DIV_1 | ADC10SSEL_3 | CONSEQ_0;
                               // ADC Input Channel: 2
                               // Sample and Hold Source: ADC10SC bit
                               // ADC10 data format: Straight Binary
                               // ADC10 clock divider = /2 (4.096 MHz)
                               // ADC10 clock source = SMCLK (8.192 MHz)
                               // Conversion Sequence Mode = single-channel, single-conversion
  
  ADC10AE0 = 0x04;             // Enable Analog input on Port P2.2 (AE2)
  
  ADC10CTL0 |= ENC;            // Enable Conversion

// UCA0 initilization
// UCA connects to the optional LCD display via UART at 115384 BAUD
// UCA0 Settings:
//   UART Mode
//   8 data bits, Odd Parity, 1 Stop bit
//   Clock Source: SMCLK: 16.384 MHz (Receiver), 8.192 MHz (Monitor)
//   Bit Rate Divider (BR0, BR1): 70 (Bit Rate = 115384 bps)
//   No Modulation
      
  UCA0CTL1 = UCSWRST;           // Hold UCA0 Reset
  
  UCA0CTL0 = UCPEN; 
  UCA0CTL1 |= UCSSEL_2;
#ifdef MONITOR 
  UCA0BR0 = 70;       // SMCLK = 8.192 MHz
#else
  UCA0BR0 = 140;      // SMCLK = 16.384 MHz
#endif  
  UCA0BR1 = 0;
  UCA0MCTL = 0;
    
  UCA0CTL1 &= ~UCSWRST;         // Enable USCI  
  
return;
}

  
 