//----------------------------------------------------------------------------
//  Description:  This file contains definitions specific to the specific MSP430
//  chosen for this implementation.  MSP430 has multiple interfaces capable
//  of interfacing to the SPI port; each of these is defined in this file.
//
//  The source labels for the definitions (i.e., "P3SEL") can be found in
//  msp430xxxx.h.
//
//  MSP430/CC1100-2500 Interface Code Library v1.0
//
//  M Burns
//  Texas Instruments, Inc.
//  March 2007
//----------------------------------------------------------------------------

#include "msp430x22x2.h"                    // Adjust this according to the
                                            // MSP430 device being used.

// SPI port definitions                     // Adjust the values for the chosen
#define TI_CC_SPI_PxSEL  P3SEL              // interfaces, according to the pin
#define TI_CC_SPI_PxDIR  P3DIR              // assignments indicated in the
#define TI_CC_SPI_PxIN   P3IN               // chosen MSP430 device datasheet.
#define TI_CC_SPI_PxOUT  P3OUT
#define TI_CC_SPI_SIMO   0x02               // P3.1
#define TI_CC_SPI_SOMI   0x04               // P3.2
#define TI_CC_SPI_SCLK   0x08               // P3.3

