//----------------------------------------------------------------------------
//  One Way Audio Code
//
//  M J Burns
//  Texas Instruments, Rochester Design Center
//  December 2008
//                
// For use with 'CC1150 Tx Rev D' and 'CC1101 Rx Rev B' cards
//
//----------------------------------------------------------------------------

// LCD Driver and support subroutines

#include "include.h"
#include "string.h"
#include "math.h"

char lcdtxt[26];
char txtstr[6];
char lcdline3[8];
unsigned short lcdbufrbusy;
unsigned short lcdbufrindx;
unsigned short lcdlen;
unsigned short thousands, hundreds, tens;

int writeLCD(void)

{
  if (lcdbufrbusy > 0)            // if buffer is already in use
    return(1);                    // return
  
  lcdbufrbusy = 1;                // set buffer in use flag
  lcdlen = strlen(lcdtxt); 
#ifdef ENRS232
  lcdtxt[lcdlen] = 0x0A;          // add 'Carriage Return'
  lcdtxt[lcdlen+1] = 0x0D;        // and 'Line Feed'
  lcdlen += 2;                    // and increase the length
#else
  lcdtxt[lcdlen] = 0;             // add termination character
  lcdlen++;                       // and increase the length
#endif
  lcdbufrindx = 0;                // Reset buffer index
  IE2 |= UCA0TXIE;                // Enable USCI_A0 TX interrupt
  
  return(0);
}

void short2ascii(char sign, unsigned int value) {

  txtstr[0] = sign;
  
// Since the MSP430 offers no floating point support, we must do the decimal to ascii conversion the hard way
// Note: This subroutine will handle values up to a maximum of 9999!!

// First, calculate the number of 100s        
  
  hundreds = 0;
  while (value >= 100) {
    value -= 100;
    hundreds++;
  }
  if (hundreds == 0)
    txtstr[1] = ' ';
  else
    txtstr[1] = hundreds + 0x30;
  
// Now calculate the number of 10s
 
  tens = 0;
  while (value >= 10) {
    value -= 10;
    tens++;
  }
  if ((tens == 0) && (hundreds == 0))
    txtstr[2] = ' ';
  else
    txtstr[2] = tens + 0x30;

// display units
 
  txtstr[3] = value + 0x30;
  
  return;
}

#ifdef RECEIVER       // This subroutine is only used in the RECEIVER code
void int2ascii(unsigned int value) {

  txtstr[0] = ' ';
  
// Since the MSP430 offers no floating point support, we must do the decimal to ascii conversion the hard way
// Note: This subroutine will handle values up to a maximum of 9999!!
  
// First, calculate the number of 100s        
  
  thousands = 0;
  while (value >= 1000) {
    value -= 1000;
    thousands++;
  }
  if (thousands == 0)
    txtstr[1] = ' ';
  else
    txtstr[1] = thousands + 0x30;

// Now calculate the number of 100s       
  
  hundreds = 0;
  while (value >= 100) {
    value -= 100;
    hundreds++;
  }
  if (hundreds == 0)
    txtstr[2] = ' ';
  else
    txtstr[2] = hundreds + 0x30;  
  
// and the number of 10s
 
  tens = 0;
  while (value >= 10) {
    value -= 10;
    tens++;
  }
  if ((tens == 0) && (hundreds == 0))
    txtstr[3] = ' ';
  else
    txtstr[3] = tens + 0x30;

// finally, units
 
  txtstr[4] = value + 0x30;
  
  return;
}
#endif


