//----------------------------------------------------------------------------
//  Description:  This file contains definitions specific to the hardware board.
//  Specifically, the definitions include hardware connections with the
//  CCxxxx connector port, LEDs, and switches.
//
//  MSP430/CC1100-2500 Interface Code Library v1.0
//
//  M Burns
//  Texas Instruments, Inc.
//  March 2007
//----------------------------------------------------------------------------

#include "TI_CC_msp430.h"

// The following defines identify the cards function, MONITOR (transmits Audio samples) or RECEIVER
// Commenting 'Monitor' forces RECEIVER to be defined

//#define MONITOR
#ifndef MONITOR
#define RECEIVER
#endif

#define TI_CC_GDO0_PxOUT        P2OUT     // GDO0
#define TI_CC_GDO0_PxIN         P2IN
#define TI_CC_GDO0_PxDIR        P2DIR
#define TI_CC_GDO0_PxIE         P2IE
#define TI_CC_GDO0_PxIES        P2IES
#define TI_CC_GDO0_PxIFG        P2IFG
#define TI_CC_GDO0_PIN          0x02      // P2.1

#define TI_CC_CSn_PxOUT         P2OUT     // CSN
#define TI_CC_CSn_PxDIR         P2DIR
#define TI_CC_CSn_PIN           0x01      // P2.0

#define ADCSAMPLES 36         // # of ADC samples per Packet
#define ADCTXBUFRLEN 45       // ADC TX Buffer Length (ADCSAMPLES * 1.25)
#define PACKETLEN  47         // TX/RX Packet Length 

#define AGCSAMPLES 16         // number of samples used to determine vpmax (Monitor)
#define VPMAX 450             // Vpeak maximum in ADC codes
                              // If this vlaue is exceeded, the VGA gain will be reduced
#define VPMIN 180             // Vpeak minimum in ADC codes
                              // If this vlaue is not exceeded, the VGA gain will be increased
#define BVLOWLIMIT 0x2E5      // Battery Voltage Lower Limit (3.600 Volts)

// Note: The CC1100/CC1150 is connected to 'UCB0' via pins P3.1 (SI), P3.2 (SO), and P3.3 (SCLK)

// Uncomment the following line to place the transmitter in continous mode
// This can be used to measure xmitter power
// This option is only valid in MONITOR mode

//#define CONTINOUS

// Select one (and only one) of the following data rates

// Sets the data rate to 150 kbps, FEC disabled, GFSK
#define BAUD150GFSK

// Sets the data rate to 300 kbps, FEC enabled (4 preamble bytes), MSK
//#define BAUD300FECSENS
//#define BAUD300FEC

// AGC_FREEZE options - register AGCCTRL0 bits 3 - 2
//
// 0 "Normal Operation. Always adjust gain when required"
// 1 "The gain is frozen when a sync word has been found"
// 2 "Manually freeze the analog gain setting and continue to adjust the digital gain"

#define AGCFREEZE 1 

// Uncomment the following line if you wish to ignore CRC errors. Otherwise, the buffer will be marked as 'unavailable'
// and audio will be muted for the duration of the packet (4.5 msec)
  
//#define IGNORECRC

// Frequency Hopping settings

#define TOTAL_NUM_CHANNELS 25   // Number of channels in frequency hopping table
#define MAX_LOST_PACKETS 10     // Number of consecutively lost packets after which 'Searching For Beacon' mode is entered

// LED and Push Button Assignments
//
// Monitor:
// 
// PB1: Locate
// PB2: Cancel Locate
// Red LED: Locate Active
// Orange LED: Packet Send in Progress
// Yellow LED: Unassigned
// Blue LED: Unassigned
//
// Receiver:
// 
// PB1: Increase Volume
// PB2: Decrease Volume 
// Red LED: Low Battery
// Orange LED: Packet Lost
//

#ifdef MONITOR

// Port 4
#define LED_ORANGE 0x01   
#define LED_YELLOW 0x02
#define LED_BLUE 0x04

// Port 1
#define PB1 0x04
#define PB2 0x08       

#else // Receiver

// Port 4
#define LED_ORANGE 0x20

// Port 2
#define PB1 0x08
#define PB2 0x10
#define LED_YELLOW 0x20

#endif

// Common to both Monitor and Receiver

// Port 1
#define LED_HEARTBEAT 0x01
#define LED_RED 0x02

// Timer B usec equivalents
//
// Timer B is fed from SMCLK (8.192 MHz), so each tic is 122.07 nanosecs

#define USEC190   1556    // 1556*.12207 = 189.94 usec
#define USEC210   1720    // 1720*.12207 = 209.96 usec
#define USEC750   6144    // 6144*.12207 = 750.00 usec
#define USEC800   6554    // 6554*.12207 = 800.05 usec
#define USEC900   7373    // 7373*.12207 = 900.02 usec
#define USEC1000  8192    // 8192*.12207 = 1000.0 usec

// Receiver timeout specifications

#ifdef BAUD150GFSK
#define USECGDO0 22528    // 22528*.12207 = 2750.0 usec 
#endif

#ifdef BAUD300FEC
#define USECGDO0 22528    // 22528*.12207 = 2750.0 usec 
#endif

#ifdef BAUD300FECSENS
#define USECGDO0 22528    // 22528*.12207 = 2750.0 usec 
#endif
