#include "d6t-8l.h"

static volatile uint8_t slaveAddress;
static volatile uint8_t interface;
static I2C_Handle i2c;
static I2C_Params i2cParams;
extern void toggleLight();
uint8_t rxBuffer[N_READ];
uint8_t txBuffer[4];
uint8_t txBufferSetup[4];
float ptat;
float pix_data[N_PIXEL+1] = {0};

float threshold_temp = 2.0;
//static Display_Handle display;


int16_t itemp = 0;


//static void i2cErrorHandler(I2C_Transaction *transaction,
//Display_Handle display);

static int i2cErrorHandler(I2C_Transaction *transaction);

uint8_t calc_crc(uint8_t data) {
    int index;
    uint8_t temp;
    for (index = 0; index < 8; index++) {
        temp = data;
        data <<= 1;
        if (temp & 0x80) {data ^= 0x07;}
    }
    return data;
}

/** <!-- D6T_checkPEC {{{ 1--> D6T PEC(Packet Error Check) calculation.
 * calculate the data sequence,
 * from an I2C Read client address (8bit) to thermal data end.
 */
bool D6T_checkPEC(uint8_t buf[], int n) {
    int i;
    uint8_t crc = calc_crc((D6T_ADDR << 1) | 1);  // I2C Read address (8bit)
    //Display_printf(display, 0, 0, "CRC before: 0x%x", crc);
    for (i = 0; i < n; i++) {
        crc = calc_crc(buf[i] ^ crc);
        //Display_printf(display, 0, 0, "CRC %d: 0x%x", i, crc);
    }
    //Display_printf(display, 0, 0, "CRC after: 0x%x", crc);
    //Display_printf(display, 0, 0, "buf[n]: 0x%x", buf[n]);
    bool ret = crc != buf[n];
    /*if (ret) {
        Display_printf(display, 0, 0, "PEC check failed\n");
        Display_printf(display, 0, 0, "%d", crc);
        Display_printf(display, 0, 0, "(cal) vs ");
        Display_printf(display, 0, 0, "%d", buf[n]);
        Display_printf(display, 0, 0, "(get)");
    }*/
    return ret;
}

/** <!-- conv8us_s16_le {{{1 --> convert a 16bit data from the byte stream.
 */
int16_t conv8us_s16_le(uint8_t* buf, int n) {
    uint16_t ret;
    ret = (uint16_t)buf[n];
    //Display_printf(display, 0, 0, "ret before: %d", ret);
    ret += ((uint16_t)buf[n + 1]) << 8;
    //Display_printf(display, 0, 0, "ret after (before convert negative): %d", ret);
    return (int16_t)ret;   // and convert negative.
}


/*
 *  ======== mainThread ========
 */



int initD6t8l()
{
// TODO: que las funciones devuelvan un int que defina si ha habido error o acierto
// TODO: configurar los GPIO para que coincidan con los de zigbee
// TODO: display error en init?

    /* Call driver init functions */

    GPIO_init();
    I2C_init();

    /* Configure the LED and if applicable, the TMP_EN pin */
    //GPIO_setConfig(CONFIG_GPIO_LED_0, GPIO_CFG_OUT_STD | GPIO_CFG_OUT_LOW);
#ifdef CONFIG_GPIO_TMP_EN
    GPIO_setConfig(CONFIG_GPIO_TMP_EN, GPIO_CFG_OUT_STD | GPIO_CFG_OUT_HIGH);
    /* Allow the sensor to power on */
    //sleep(1);
#endif

    /* Open the UART display for output */
  //  display = Display_open(Display_Type_UART, NULL);
   // if (display == NULL) {
    //    while (1);
   // }

    /* Turn on user LED */
    //GPIO_write(CONFIG_GPIO_LED_0, CONFIG_GPIO_LED_ON);
   // Display_printf(display, 0, 0, "Starting the d6t-8l example\n");

    /* Create I2C for usage */
    I2C_Params_init(&i2cParams);
    /* clockFrequency: the value (in Hertz) of desired communication clock.
     * Accepted values are 100000 (standard mode) and 400000 (fast mode).
     * Some processors also support 10000 (low speed mode), 1000000 (fast mode plus) and 3400000 (high speed mode).
     * */
    i2cParams.bitRate = I2C_100kHz;
    i2c = I2C_open(CONFIG_I2C_TMP, &i2cParams);
    if (i2c == NULL) {
        return ERROR_I2C_INIT;
    }

    return I2C_INIT_OK;

}

int i2cSetup() {

    /* Common I2C transaction setup */
    I2C_Transaction i2cTransaction;
    i2cTransaction.writeBuf   = txBufferSetup;
    i2cTransaction.writeCount = 4;
    i2cTransaction.readBuf    = NULL;
    i2cTransaction.readCount  = 0;
    i2cTransaction.slaveAddress = D6T_ADDR;

    /* D6T register */
    txBufferSetup[0] = 0x02;
    txBufferSetup[1] = 0x00;
    txBufferSetup[2] = 0x01;
    txBufferSetup[3] = 0xEE;

    if (I2C_transfer(i2c, &i2cTransaction)) {
        slaveAddress = D6T_ADDR;
    } else {
        i2cErrorHandler(&i2cTransaction);
        return ERROR_I2C_SETUP;
    }

    txBufferSetup[0] = 0x05;
    txBufferSetup[1] = 0x90;
    txBufferSetup[2] = 0x3A;
    txBufferSetup[3] = 0xB8;

    if (I2C_transfer(i2c, &i2cTransaction)) {
        slaveAddress = D6T_ADDR;
    } else {
        i2cErrorHandler(&i2cTransaction);
        return ERROR_I2C_SETUP;
    }

    txBufferSetup[0] = 0x03;
    txBufferSetup[1] = 0x00;
    txBufferSetup[2] = 0x03;
    txBufferSetup[3] = 0x8B;

    if (I2C_transfer(i2c, &i2cTransaction)) {
        slaveAddress = D6T_ADDR;
    } else {
        i2cErrorHandler(&i2cTransaction);
        return ERROR_I2C_SETUP;
    }

    txBufferSetup[0] = 0x03;
    txBufferSetup[1] = 0x00;
    txBufferSetup[2] = 0x07;
    txBufferSetup[3] = 0x97;

    if (I2C_transfer(i2c, &i2cTransaction)) {
        slaveAddress = D6T_ADDR;
    } else {
        i2cErrorHandler(&i2cTransaction);
        return ERROR_I2C_SETUP;
    }

    txBufferSetup[0] = 0x02;
    txBufferSetup[1] = 0x00;
    txBufferSetup[2] = 0x00;
    txBufferSetup[3] = 0xE9;

    if (I2C_transfer(i2c, &i2cTransaction)) {
        slaveAddress = D6T_ADDR;
    } else {
        i2cErrorHandler(&i2cTransaction);
        return ERROR_I2C_SETUP;
    }
    return 5;
    //sleep(0.5); // 1 sec
}



double readSensor() {

    /* Common I2C transaction setup */
    I2C_Transaction i2cTransaction2;
    i2cTransaction2.writeBuf   = txBuffer;
    i2cTransaction2.writeCount = 1;
    i2cTransaction2.readBuf    = NULL;
    i2cTransaction2.readCount  = 0;
    i2cTransaction2.slaveAddress = D6T_ADDR;

    /* D6T register */
    txBuffer[0] = D6T_CMD;

    if (I2C_transfer(i2c, &i2cTransaction2)) {
        slaveAddress = D6T_ADDR;
    } else {
        i2cErrorHandler(&i2cTransaction2);
    }

    //sleep(1); // 1 sec

    /*
     * Get slave address.
     */

    if (I2C_transfer(i2c, &i2cTransaction2)) {
        slaveAddress = D6T_ADDR;
    } else {
        i2cErrorHandler(&i2cTransaction2);
    }

    /* If we never assigned a slave address */
    if (slaveAddress == 0) {
        //Display_printf(display, 0, 0, "Failed to detect a sensor!");
        I2C_close(i2c);
        return ERROR_I2C_READ;
        //while (1);

    }

    /* Take samples and print them out onto the console */
    /* Common I2C transaction setup */
    I2C_Transaction i2cTransaction3;
    i2cTransaction3.writeBuf   = NULL;
    i2cTransaction3.writeCount = 0;
    i2cTransaction3.readBuf    = rxBuffer;
    i2cTransaction3.readCount  = N_READ;
    i2cTransaction3.slaveAddress = D6T_ADDR;


    if (!I2C_transfer(i2c, &i2cTransaction3)) {
        i2cErrorHandler(&i2cTransaction3);
        return ERROR_I2C_READ;
    }

    //Output results
    ptat = (double) conv8us_s16_le(rxBuffer, 0) / 10.0;

    int i, j;
    // loop temperature pixels of each thermopiles measurements
    for (i = 0, j = 0; i < N_PIXEL; i++, j += 2) {
        itemp = conv8us_s16_le(rxBuffer, j);
        pix_data[i] = itemp / 10.0;

    }
    //sleep(1);


    //I2C_close(i2c);
    return pix_data[0]; // ???
}
int checkOccupancy() {
    readSensor();
    for (int i=0; i<N_PIXEL; i++) {
        if (pix_data[i] - ptat > threshold_temp) {
            toggleLight();
            return 1;
        }
    }
    return 0;
}
static int i2cErrorHandler(I2C_Transaction *transaction)
{
    return transaction->status;
}


