#include <stdint.h>
#include <stddef.h>
#include <unistd.h>

/* Driver Header files */
#include <ti/drivers/GPIO.h>
#include <ti/drivers/I2C.h>
#include <ti/drivers/i2c/I2CCC26XX.h>
#include <ti/display/Display.h>

#include "cui.h"

/* Driver configuration */
#include "ti_drivers_config.h"

#define TASKSTACKSIZE       640


/* defines */
#define D6T_ADDR 0x0A  // for I2C 7bit address -> 0x0A = 10 en decimal
#define D6T_CMD 0x4C  // for D6T-44L-06/06H, D6T-8L-09/09H, for D6T-1A-01/02 -> 0x4C = 76 en decimal
#define D6T_ALIAS "D6T-8L"

/* rx data */
#define N_ROW 8
#define N_PIXEL 8
#define N_READ ((N_PIXEL + 1) * 2 + 1)

#define I2C_INIT_OK        0
#define I2C_SETUP_OK       0

#define ERROR_I2C_INIT      -1
#define ERROR_I2C_SETUP     -2
#define ERROR_I2C_READ      -3

