void outputDevState(zstack_DevState devState)
{
  	switch (devState)
	{
	case zstack_DevState_NWK_DISC:
		System_printf("savedState=DevState_NWK_DISC\r\n\0");
		break;
	case zstack_DevState_DEV_END_DEVICE:
		System_printf("savedState=DevState_DEV_END_DEVICE\r\n\0");
		break;
	case zstack_DevState_NWK_BACKOFF:
		System_printf("savedState=DevState_NWK_BACKOFF\r\n\0");
		break;
	default :
		System_printf("savedState=%d\r\n\0",savedState);
		break; 
	}
}

/******************************************************************************
* @fn      Sensor_process
*
* @brief   Application task processing start.
*
* @param   none
*
* @return  void
*/
static void Sensor_process(void)
{
  /* Forever loop */
  if(Util_isClockActive(&dataTransmitClkStruct) == true)
  {
    Util_stopClock(&dataTransmitClkStruct);
  }
  Clock_setTimeout( dataTransmitClkHandle,
                   (TEMPERATURE_SEND_DATA * TIMER_MS_ADJUSTMENT) );
  Util_startClock(&dataTransmitClkStruct);  
  //Init start counter is zero
  DataTransmit.SequenceNumber = 0;
  
  unsigned short ausLog[6];
  unsigned short PwrState;

	 
  for(;;)
  {
    WatchdogIntClear();  
    
    ICall_ServiceEnum stackid;
    ICall_EntityID dest;
    zstackmsg_genericReq_t *pMsg;
	
	zstack_sysNwkInfoReadRsp_t * pzDevInfo;
  	zstack_DevState dDevState;
	int ICallerrNo;
	ICallerrNo = 99;
	System_printf("ICall_wait start\r\n\0");
    /* Wait for response message */
	ICallerrNo = ICall_wait(ICALL_TIMEOUT_FOREVER);
	System_printf("In ICALL_WAIT\r\n\0");
    if(ICallerrNo == ICALL_ERRNO_SUCCESS)
    {
	  System_printf("In ICALL_WAIT\r\n\0");
	  pzDevInfo = zclport_getDeviceInfo(ztsEntity);
	  dDevState = pzDevInfo->devState;
	  outputDevState(dDevState);
      /* Retrieve the response message */
      if(ICall_fetchServiceMsg(&stackid, &dest, (void **)&pMsg)
         == ICALL_ERRNO_SUCCESS)
      {
        if( (stackid == ICALL_SERVICE_CLASS_ZSTACK) &&
           (dest == ztsEntity) )
        {
          if(pMsg)
          {
			
            TempSensor_processZStackMsgs(pMsg);
            
            // Free any separately allocated memory
            Zstackapi_freeIndMsg(pMsg);
          }
        }
        
        if(pMsg)
        {
          ICall_freeMsg(pMsg);
        }
      }
      if(events & TEMPSENSOR_DATASEND_EVENT)      
      {
		/* 10b^C}Jn */
		if(Util_isClockActive(&dataTransmitClkStruct) == true)
		{
		  Util_stopClock(&dataTransmitClkStruct);
		}
		Clock_setTimeout( dataTransmitClkHandle,
						 (TEMPERATURE_SEND_DATA * TIMER_MS_ADJUSTMENT) );
		Util_startClock(&dataTransmitClkStruct);  
		/* add Yuya Murata ver 2.2.9.5*/
		if(savedState == zstack_DevState_DEV_END_DEVICE){
			/* xZTf[^擾Ԃ̃^C}ݒ */
			if(Util_isClockActive(&dataSendingClkStruct) == true)
			{
			  Util_stopClock(&dataSendingClkStruct);
			}
			Clock_setTimeout( dataSendingClkHandle,
							 (TIME_DATA_SENDING * TIMER_MS_ADJUSTMENT) );
			Util_startClock(&dataSendingClkStruct); 
			
			//I2s_terminate(); //Delete No use sound sensor by W.Fukazawa 20211111
			Sensor_sendData(); 			
			
		}
			
		events &= ~TEMPSENSOR_DATASEND_EVENT;
      }
      
#ifdef ZCL_EZMODE
      if(events & TEMPSENSOR_EZMODE_NEXTSTATE_EVT)
      {
        // going on to next state
        zcl_EZModeAction(EZMODE_ACTION_PROCESS, NULL);
        events &= ~TEMPSENSOR_EZMODE_NEXTSTATE_EVT;
      }
      
      if(events & TEMPSENSOR_EZMODE_TIMEOUT_EVT)
      {
        // EZ-Mode timed out
        zcl_EZModeAction(EZMODE_ACTION_TIMED_OUT, NULL);
        events &= ~TEMPSENSOR_EZMODE_TIMEOUT_EVT;
      }
#endif // ZLC_EZMODE
    }
    
  }

}
/*********************************************************************/
/* @fn      Sensor_sendData
*
* @brief   Called to send current sensor information to the coordinator
*
* @param   none
*
* @return  noneRO
*/
/*********************************************************************/
static void Sensor_sendData(void)
{
  /*DataTransmit.node1= 0x0002; //Set node id higher bytes
  DataTransmit.node2= 0x0034; //Set node id lower bytes*/
  uint32_t nodeid1,nodeid2;
  uint32_t nodeid;
  
  nodeid1 = (uint32_t)(HWREG(CCFG_BASE + CCFG_O_IEEE_MAC_0));
  nodeid2 = (uint32_t)(HWREG(CCFG_BASE + CCFG_O_IEEE_MAC_1));
  nodeid = (uint32_t)(((nodeid1&0x00FF)<<16) || (nodeid2&0x00FF));
  DataTransmit.DataType = 0x0003;	// fixed data
  DataTransmit.SerialNumber = (int32_t)nodeid1;
								  
 //debug
 //DataTransmit.node1 = 2;
 //DataTransmit.node2 = 38;

  DataTransmit.firmware_version=20002;  //30101 Set firmware verison v3.01.01
 
  Copy_SensorParams();
	
  

#ifdef ZCL_REPORT
  zclReportCmd_t *pReportCmd;
  System_printf("pReportCmd malloc\r\n\0");
  // Build and send a ZCL temperature reading to the matched device
  pReportCmd = ICall_malloc( sizeof(zclReportCmd_t) + sizeof(zclReport_t) );
  
  if(pReportCmd != NULL)
  {
  	System_printf("pReportCmd malloc success\r\n\0");
    afAddrType_t dstAddr;
    
    // Fill in the destination address
    dstAddr.addrMode = (afAddrMode_t)ztsDstAddr.addrMode;
    dstAddr.addr.shortAddr = ztsDstAddr.addr.shortAddr;
    dstAddr.endPoint = ztsDstAddr.endpoint;
    dstAddr.panId = ztsDstAddr.panID;
    
    // Fill in the single attribute information for the temperature reading
    pReportCmd->numAttr = 1;
    pReportCmd->attrList[0].attrID = ATTRID_MS_TEMPERATURE_MEASURED_VALUE;
    pReportCmd->attrList[0].dataType = ZCL_DATATYPE_STRUCT;
    //pReportCmd->attrList[0].dataType = ZCL_DATATYPE_ARRAY;
    pReportCmd->attrList[0].attrData = (void *)&DataTransmit;
    //pReportCmd->attrList[0].attrData = (void *)&ucSensorPayload[0];
    
    // Call ZCL function to send the report
    retVal = zcl_SendReportCmd(TEMPSENSOR_EP, &dstAddr,
                      ZCL_CLUSTER_ID_MS_TEMPERATURE_MEASUREMENT,
                      pReportCmd,
                      ZCL_FRAME_SERVER_CLIENT_DIR,
                      true,
                      ztsTransID++);
    
    System_printf("SendReportCmd ret=%x\r\n\0", retVal);
    //printing status of zcl_SendReportCmd over UART for debugging
    
    ICall_free(pReportCmd);
  }
  else
  {
	System_printf("pReportCmd Addr = NULL\r\n\0");
  }
  
#endif  // ZCL_REPORT
}

