/**************************************************************************************************
  Filename:       zcl_se.h
  Revised:        $Date: 2015-01-21 15:48:10 -0800 (Wed, 21 Jan 2015) $
  Revision:       $Revision: 41948 $

  Description:    This file contains the ZCL SE (Smart Energy) definitions.


  Copyright (c) 2019, Texas Instruments Incorporated
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:

  *  Redistributions of source code must retain the above copyright
      notice, this list of conditions and the following disclaimer.

  *  Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.

  *  Neither the name of Texas Instruments Incorporated nor the names of
      its contributors may be used to endorse or promote products derived
      from this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
  THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
  PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
  OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
  EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**************************************************************************************************/
#ifndef ZCL_SE_H
#define ZCL_SE_H

#ifdef __cplusplus
extern "C"
{
#endif


/**************************************************************************************************
 * INCLUDES
 */

#include "hal_types.h"
#include "zcl.h"
#include "ti_zstack_config.h"


/**************************************************************************************************
 * CONSTANTS
 */

//=================================================================================================
// Smart Energy Profile
//=================================================================================================
// SE Profile ID
#define ZCL_SE_PROFILE_ID                    0x0109

// SE Device IDs
#define ZCL_SE_DEVICEID_RANGE_EXTENDER       0x0008
#define ZCL_SE_DEVICEID_ESI                  0x0500
#define ZCL_SE_DEVICEID_METERING             0x0501
#define ZCL_SE_DEVICEID_IHD                  0x0502
#define ZCL_SE_DEVICEID_PCT                  0x0503
#define ZCL_SE_DEVICEID_LOAD_CTRL            0x0504
#define ZCL_SE_DEVICEID_SMART_APPLIANCE      0x0505
#define ZCL_SE_DEVICEID_PREPAYMENT_TERMINAL  0x0506
#define ZCL_SE_DEVICEID_PHYSICAL             0x0507

//=================================================================================================
// DRLC Commands(ZCL_CLUSTER_ID_SE_DRLC)
//=================================================================================================
// Server-to-Client
#define COMMAND_SE_DRLC_LOAD_CTRL_EVT              0x00
#define COMMAND_SE_DRLC_CANCEL_LOAD_CTRL_EVT       0x01
#define COMMAND_SE_DRLC_CANCEL_ALL_LOAD_CTRL_EVTS  0x02

// Client-to-Server
#define COMMAND_SE_DRLC_REPORT_EVT_STATUS          0x00
#define COMMAND_SE_DRLC_GET_SCHEDULED_EVTS         0x01

//=================================================================================================
// Metering Commands(ZCL_CLUSTER_ID_SE_METERING)
//=================================================================================================
// Server-to-Client
#define COMMAND_SE_METERING_GET_PROFILE_RSP             0x00
#define COMMAND_SE_METERING_REQ_MIRROR                  0x01
#define COMMAND_SE_METERING_REMOVE_MIRROR               0x02
#define COMMAND_SE_METERING_REQ_FAST_POLL_MODE_RSP      0x03
#define COMMAND_SE_METERING_SCHEDULE_SNAPSHOT_RSP       0x04
#define COMMAND_SE_METERING_TAKE_SNAPSHOT_RSP           0x05
#define COMMAND_SE_METERING_PUBLISH_SNAPSHOT            0x06
#define COMMAND_SE_METERING_GET_SAMPLED_DATA_RSP        0x07
#define COMMAND_SE_METERING_CFG_MIRROR                  0x08
#define COMMAND_SE_METERING_CFG_NOTIF_SCHEME            0x09
#define COMMAND_SE_METERING_CFG_NOTIF_FLAG              0x0A
#define COMMAND_SE_METERING_GET_NOTIF_MSG               0x0B
#define COMMAND_SE_METERING_SUPPLY_STATUS_RSP           0x0C
#define COMMAND_SE_METERING_START_SAMPLING_RSP          0x0D

// Client-to-Server
#define COMMAND_SE_METERING_GET_PROFILE                 0x00
#define COMMAND_SE_METERING_REQ_MIRROR_RSP              0x01
#define COMMAND_SE_METERING_MIRROR_REMOVED              0x02
#define COMMAND_SE_METERING_REQ_FAST_POLL_MODE          0x03
#define COMMAND_SE_METERING_SCHEDULE_SNAPSHOT           0x04
#define COMMAND_SE_METERING_TAKE_SNAPSHOT               0x05
#define COMMAND_SE_METERING_GET_SNAPSHOT                0x06
#define COMMAND_SE_METERING_START_SAMPLING              0x07
#define COMMAND_SE_METERING_GET_SAMPLED_DATA            0x08
#define COMMAND_SE_METERING_MIRROR_REPORT_ATTR_RSP      0x09
#define COMMAND_SE_METERING_RESET_LOAD_LIMIT_CNTR       0x0A
#define COMMAND_SE_METERING_CHANGE_SUPPLY               0x0B
#define COMMAND_SE_METERING_LOCAL_CHANGE_SUPPLY         0x0C
#define COMMAND_SE_METERING_SET_SUPPLY_STATUS           0x0D
#define COMMAND_SE_METERING_SET_UNCTRLD_FLOW_THRESHOLD  0x0E

//=================================================================================================
// Price Commands(ZCL_CLUSTER_ID_SE_PRICE)
//=================================================================================================
// Server-to-Client
#define COMMAND_SE_PRICE_PUBLISH_PRICE                0x00
#define COMMAND_SE_PRICE_PUBLISH_BLOCK_PERIOD         0x01
#define COMMAND_SE_PRICE_PUBLISH_CONVERSION_FACTOR    0x02
#define COMMAND_SE_PRICE_PUBLISH_CALORIFIC_VALUE      0x03
#define COMMAND_SE_PRICE_PUBLISH_TARIFF_INFO          0x04
#define COMMAND_SE_PRICE_PUBLISH_PRICE_MATRIX         0x05
#define COMMAND_SE_PRICE_PUBLISH_BLOCK_THRESHOLD      0x06
#define COMMAND_SE_PRICE_PUBLISH_CO2_VALUE            0x07
#define COMMAND_SE_PRICE_PUBLISH_TIER_LABELS          0x08
#define COMMAND_SE_PRICE_PUBLISH_BILL_PERIOD          0x09
#define COMMAND_SE_PRICE_PUBLISH_CONSOLIDATED_BILL    0x0A
#define COMMAND_SE_PRICE_PUBLISH_CPP_EVT              0x0B
#define COMMAND_SE_PRICE_PUBLISH_CREDIT_PAYMENT       0x0C
#define COMMAND_SE_PRICE_PUBLISH_CURRENCY_CONVERSION  0x0D
#define COMMAND_SE_PRICE_CANCEL_TARIFF                0x0E

// Client-to-Server
#define COMMAND_SE_PRICE_GET_CURR_PRICE               0x00
#define COMMAND_SE_PRICE_GET_SCHEDULED_PRICE          0x01
#define COMMAND_SE_PRICE_PRICE_ACK                    0x02
#define COMMAND_SE_PRICE_GET_BLOCK_PERIOD             0x03
#define COMMAND_SE_PRICE_GET_CONVERSION_FACTOR        0x04
#define COMMAND_SE_PRICE_GET_CALORIFIC_VALUE          0x05
#define COMMAND_SE_PRICE_GET_TARIFF_INFO              0x06
#define COMMAND_SE_PRICE_GET_PRICE_MATRIX             0x07
#define COMMAND_SE_PRICE_GET_BLOCK_THRESHOLDS         0x08
#define COMMAND_SE_PRICE_GET_CO2_VALUE                0x09
#define COMMAND_SE_PRICE_GET_TIER_LABELS              0x0A
#define COMMAND_SE_PRICE_GET_BILL_PERIOD              0x0B
#define COMMAND_SE_PRICE_GET_CONSOLIDATED_BILL        0x0C
#define COMMAND_SE_PRICE_CPP_EVT_RSP                  0x0D
#define COMMAND_SE_PRICE_GET_CREDIT_PAYMENT           0x0E
#define COMMAND_SE_PRICE_GET_CURRENCY_CONVERSION      0x0F
#define COMMAND_SE_PRICE_GET_TARIFF_CANCELLATION      0x10

//=================================================================================================
// Messaging Commands(ZCL_CLUSTER_ID_SE_MESSAGING)
//=================================================================================================
// Server-to-Client
#define COMMAND_SE_MESSAGING_DISPLAY_MSG            0x00
#define COMMAND_SE_MESSAGING_CANCEL_MSG             0x01
#define COMMAND_SE_MESSAGING_DISPLAY_PROTECTED_MSG  0x02
#define COMMAND_SE_MESSAGING_CANCEL_ALL_MSGS        0x03

// Client-to-Server
#define COMMAND_SE_MESSAGING_GET_LAST_MSG           0x00
#define COMMAND_SE_MESSAGING_MSG_CFM                0x01
#define COMMAND_SE_MESSAGING_GET_MSG_CANCELLATION   0x02

//=================================================================================================
// Tunneling Commands(ZCL_CLUSTER_ID_SE_TUNNELING)
//=================================================================================================
// Server-to-Client
#define COMMAND_SE_TUNNELING_REQ_TUNNEL_RSP             0x00
#define COMMAND_SE_TUNNELING_SERVER_TRANSFER_DATA       0x01
#define COMMAND_SE_TUNNELING_SERVER_TRANSFER_DATA_ERR   0x02
#define COMMAND_SE_TUNNELING_SERVER_ACK_TRANSFER_DATA   0x03
#define COMMAND_SE_TUNNELING_SERVER_READY_DATA          0x04
#define COMMAND_SE_TUNNELING_SUPP_TUNNEL_PROTOCOLS_RSP  0x05
#define COMMAND_SE_TUNNELING_TUNNEL_CLOSURE_NOTIF       0x06

// Client-to-Server
#define COMMAND_SE_TUNNELING_REQ_TUNNEL                 0x00
#define COMMAND_SE_TUNNELING_CLOSE_TUNNEL               0x01
#define COMMAND_SE_TUNNELING_CLIENT_TRANSFER_DATA       0x02
#define COMMAND_SE_TUNNELING_CLIENT_TRANSFER_DATA_ERR   0x03
#define COMMAND_SE_TUNNELING_CLIENT_ACK_TRANSFER_DATA   0x04
#define COMMAND_SE_TUNNELING_CLIENT_READY_DATA          0x05
#define COMMAND_SE_TUNNELING_GET_SUPP_TUNNEL_PROTOCOLS  0x06

//=================================================================================================
// Prepayment Commands(ZCL_CLUSTER_ID_SE_PREPAYMENT)
//=================================================================================================
// Server-to-Client
#define COMMAND_SE_PREPAYMENT_PUBLISH_PREPAY_SNAPSHOT    0x01
#define COMMAND_SE_PREPAYMENT_CHANGE_PAYMENT_MODE_RSP    0x02
#define COMMAND_SE_PREPAYMENT_CONSUMER_TOP_UP_RSP        0x03
#define COMMAND_SE_PREPAYMENT_PUBLISH_TOP_UP_LOG         0x05
#define COMMAND_SE_PREPAYMENT_PUBLISH_DEBT_LOG           0x06

// Client-to-Server
#define COMMAND_SE_PREPAYMENT_SEL_AVAIL_EMRGNCY_CREDIT   0x00
#define COMMAND_SE_PREPAYMENT_CHANGE_DEBT                0x02
#define COMMAND_SE_PREPAYMENT_EMRGNCY_CREDIT_SETUP       0x03
#define COMMAND_SE_PREPAYMENT_CONSUMER_TOP_UP            0x04
#define COMMAND_SE_PREPAYMENT_CREDIT_ADJ                 0x05
#define COMMAND_SE_PREPAYMENT_CHANGE_PAYMENT_MODE        0x06
#define COMMAND_SE_PREPAYMENT_GET_PREPAY_SNAPSHOT        0x07
#define COMMAND_SE_PREPAYMENT_GET_TOP_UP_LOG             0x08
#define COMMAND_SE_PREPAYMENT_SET_LOW_CREDIT_WARN_LEVEL  0x09
#define COMMAND_SE_PREPAYMENT_GET_DEBT_REPAY_LOG         0x0A
#define COMMAND_SE_PREPAYMENT_SET_MAX_CREDIT_LIMIT       0x0B
#define COMMAND_SE_PREPAYMENT_SET_OVERALL_DEBT_CAP       0x0C

//=================================================================================================
// Calendar Commands(ZCL_CLUSTER_ID_SE_CALENDAR)
//=================================================================================================
// Server-to-Client
#define COMMAND_SE_CALENDAR_PUBLISH_CALENDAR           0x00
#define COMMAND_SE_CALENDAR_PUBLISH_DAY_PROFILE        0x01
#define COMMAND_SE_CALENDAR_PUBLISH_WEEK_PROFILE       0x02
#define COMMAND_SE_CALENDAR_PUBLISH_SEASONS            0x03
#define COMMAND_SE_CALENDAR_PUBLISH_SPECIAL_DAYS       0x04
#define COMMAND_SE_CALENDAR_CANCEL_CALENDAR            0x05

// Client-to-Server
#define COMMAND_SE_CALENDAR_GET_CALENDAR               0x00
#define COMMAND_SE_CALENDAR_GET_DAY_PROFILES           0x01
#define COMMAND_SE_CALENDAR_GET_WEEK_PROFILES          0x02
#define COMMAND_SE_CALENDAR_GET_SEASONS                0x03
#define COMMAND_SE_CALENDAR_GET_SPECIAL_DAYS           0x04
#define COMMAND_SE_CALENDAR_GET_CALENDAR_CANCELLATION  0x05

//=================================================================================================
// DeviceMgmt Commands(ZCL_CLUSTER_ID_SE_DEVICE_MGMT)
//=================================================================================================
// Server-to-Client
#define COMMAND_SE_DEVICE_MGMT_PUBLISH_CHANGE_OF_TENANCY   0x00
#define COMMAND_SE_DEVICE_MGMT_PUBLISH_CHANGE_OF_SUPPLIER  0x01
#define COMMAND_SE_DEVICE_MGMT_REQ_NEW_PW_RSP              0x02
#define COMMAND_SE_DEVICE_MGMT_UPDATE_SITE_ID              0x03
#define COMMAND_SE_DEVICE_MGMT_SET_EVT_CFG                 0x04
#define COMMAND_SE_DEVICE_MGMT_GET_EVT_CFG                 0x05
#define COMMAND_SE_DEVICE_MGMT_UPDATE_CIN                  0x06

// Client-to-Server
#define COMMAND_SE_DEVICE_MGMT_GET_CHANGE_OF_TENANCY       0x00
#define COMMAND_SE_DEVICE_MGMT_GET_CHANGE_OF_SUPPLIER      0x01
#define COMMAND_SE_DEVICE_MGMT_REQ_NEW_PW                  0x02
#define COMMAND_SE_DEVICE_MGMT_GET_SITE_ID                 0x03
#define COMMAND_SE_DEVICE_MGMT_REPORT_EVT_CFG              0x04
#define COMMAND_SE_DEVICE_MGMT_GET_CIN                     0x05

//=================================================================================================
// Events Commands(ZCL_CLUSTER_ID_SE_EVENTS)
//=================================================================================================
// Server-to-Client
#define COMMAND_SE_EVENTS_PUBLISH_EVT        0x00
#define COMMAND_SE_EVENTS_PUBLISH_EVT_LOG    0x01
#define COMMAND_SE_EVENTS_CLEAR_EVT_LOG_RSP  0x02

// Client-to-Server
#define COMMAND_SE_EVENTS_GET_EVT_LOG        0x00
#define COMMAND_SE_EVENTS_CLEAR_EVT_LOG      0x01

//=================================================================================================
// EnergyMgmt Commands(ZCL_CLUSTER_ID_SE_ENERGY_MGMT)
//=================================================================================================
// Server-to-Client
#define COMMAND_SE_ENERGY_MGMT_REPORT_EVT_STATUS  0x00

// Client-to-Server
#define COMMAND_SE_ENERGY_MGMT_MANAGE_EVT         0x00

//=================================================================================================
// MDUPairing Commands(ZCL_CLUSTER_ID_SE_MDU_PAIRING)
//=================================================================================================
// Server-to-Client
#define COMMAND_SE_MDU_PAIRING_PAIRING_RSP  0x00

// Client-to-Server
#define COMMAND_SE_MDU_PAIRING_PAIRING_REQ  0x00

//=================================================================================================
// DRLC Attributes(ZCL_CLUSTER_ID_SE_DRLC)
//=================================================================================================
//==== Demand Response Client Cluster Attributes Set ====
#define ATTRID_SE_DRLC_UTILITY_DEFINED_GROUP 0x0000
#define ATTRID_SE_DRLC_START_RAND_MINUTES    0x0001
#define ATTRID_SE_DRLC_STOP_RAND_MINUTES     0x0002
#define ATTRID_SE_DRLC_DEVICE_CLASS_VALUE    0x0003 // see ZCL_SE_DRLC_DEV_CLASS

//=================================================================================================
// Metering Attributes(ZCL_CLUSTER_ID_SE_METERING)
//=================================================================================================
//==== Reading Information Attribute Set ====
#define ATTRID_SE_METERING_CURR_SUMM_DLVD                 0x0000
#define ATTRID_SE_METERING_CURR_SUMM_RCVD                 0x0001
#define ATTRID_SE_METERING_CURR_MAX_DMD_DLVD              0x0002
#define ATTRID_SE_METERING_CURR_MAX_DMD_RCVD              0x0003
#define ATTRID_SE_METERING_DFT_SUMM                       0x0004
#define ATTRID_SE_METERING_DAILY_FREEZE_TIME              0x0005
#define ATTRID_SE_METERING_PWR_FACTOR                     0x0006
#define ATTRID_SE_METERING_READING_SNAPSHOT_TIME          0x0007
#define ATTRID_SE_METERING_CURR_MAX_DMD_DLVD_TIME         0x0008
#define ATTRID_SE_METERING_CURR_MAX_DMD_RCVD_TIME         0x0009
#define ATTRID_SE_METERING_DEFAULT_UPDATE_PERIOD          0x000A
#define ATTRID_SE_METERING_FAST_POLL_UPDATE_PERIOD        0x000B
#define ATTRID_SE_METERING_CURR_BLOCK_PERIOD_CONSUMP_DLVD 0x000C
#define ATTRID_SE_METERING_DAILY_CONSUMP_TARGET           0x000D
#define ATTRID_SE_METERING_CURR_BLOCK                     0x000E
          // see ZCL_SE_METERING_BLOCK_ENUM
#define ATTRID_SE_METERING_PROFILE_INTERVAL_PERIOD        0x000F
          // see ZCL_SE_METERING_PROFILE_INTERVAL
#define ATTRID_SE_METERING_INTERVAL_REPORTING_PERIOD      0x0010
#define ATTRID_SE_METERING_PRESET_READING_TIME            0x0011
#define ATTRID_SE_METERING_VOLUME_PER_REPORT              0x0012
#define ATTRID_SE_METERING_FLOW_RESTRICTION               0x0013
#define ATTRID_SE_METERING_SUPPLY_STATUS                  0x0014
          // see ZCL_SE_METERING_SUPPLY_STATUS
#define ATTRID_SE_METERING_CURR_INLET_ENERGY_CARR_SUMM    0x0015
#define ATTRID_SE_METERING_CURR_OUTLET_ENERGY_CARR_SUMM   0x0016
#define ATTRID_SE_METERING_INLET_TEMP                     0x0017
#define ATTRID_SE_METERING_OUTLET_TEMP                    0x0018
#define ATTRID_SE_METERING_CTRL_TEMP                      0x0019
#define ATTRID_SE_METERING_CURR_INLET_ENERGY_CARR_DMD     0x001A
#define ATTRID_SE_METERING_CURR_OUTLET_ENERGY_CARR_DMD    0x001B
#define ATTRID_SE_METERING_PREV_BLOCK_PERIOD_CONSUMP_DLVD 0x001C
#define ATTRID_SE_METERING_CURR_BLOCK_PERIOD_CONSUMP_RCVD 0x001D
#define ATTRID_SE_METERING_CURR_BLOCK_RCVD                0x001E
          // see ZCL_SE_METERING_BLOCK_ENUM
#define ATTRID_SE_METERING_DFT_SUMM_RCVD                  0x001F
#define ATTRID_SE_METERING_ACTIVE_REG_TIER_DLVD           0x0020
          // see ZCL_SE_PRICE_REG_TIER
#define ATTRID_SE_METERING_ACTIVE_REG_TIER_RCVD           0x0021
#define ATTRID_SE_METERING_LAST_BLOCK_SWITCH_TIME         0x0022

//==== TOU Information Attribute Set ====
#define ATTRID_SE_METERING_CURR_TIER1_SUMM_DLVD  0x0100
#define ATTRID_SE_METERING_CURR_TIER1_SUMM_RCVD  0x0101
#define ATTRID_SE_METERING_CURR_TIER2_SUMM_DLVD  0x0102
#define ATTRID_SE_METERING_CURR_TIER2_SUMM_RCVD  0x0103
#define ATTRID_SE_METERING_CURR_TIER3_SUMM_DLVD  0x0104
#define ATTRID_SE_METERING_CURR_TIER3_SUMM_RCVD  0x0105
#define ATTRID_SE_METERING_CURR_TIER4_SUMM_DLVD  0x0106
#define ATTRID_SE_METERING_CURR_TIER4_SUMM_RCVD  0x0107
#define ATTRID_SE_METERING_CURR_TIER5_SUMM_DLVD  0x0108
#define ATTRID_SE_METERING_CURR_TIER5_SUMM_RCVD  0x0109
#define ATTRID_SE_METERING_CURR_TIER6_SUMM_DLVD  0x010A
#define ATTRID_SE_METERING_CURR_TIER6_SUMM_RCVD  0x010B
#define ATTRID_SE_METERING_CURR_TIER7_SUMM_DLVD  0x010C
#define ATTRID_SE_METERING_CURR_TIER7_SUMM_RCVD  0x010D
#define ATTRID_SE_METERING_CURR_TIER8_SUMM_DLVD  0x010E
#define ATTRID_SE_METERING_CURR_TIER8_SUMM_RCVD  0x010F
#define ATTRID_SE_METERING_CURR_TIER9_SUMM_DLVD  0x0110
#define ATTRID_SE_METERING_CURR_TIER9_SUMM_RCVD  0x0111
#define ATTRID_SE_METERING_CURR_TIER10_SUMM_DLVD 0x0112
#define ATTRID_SE_METERING_CURR_TIER10_SUMM_RCVD 0x0113
#define ATTRID_SE_METERING_CURR_TIER11_SUMM_DLVD 0x0114
#define ATTRID_SE_METERING_CURR_TIER11_SUMM_RCVD 0x0115
#define ATTRID_SE_METERING_CURR_TIER12_SUMM_DLVD 0x0116
#define ATTRID_SE_METERING_CURR_TIER12_SUMM_RCVD 0x0117
#define ATTRID_SE_METERING_CURR_TIER13_SUMM_DLVD 0x0118
#define ATTRID_SE_METERING_CURR_TIER13_SUMM_RCVD 0x0119
#define ATTRID_SE_METERING_CURR_TIER14_SUMM_DLVD 0x011A
#define ATTRID_SE_METERING_CURR_TIER14_SUMM_RCVD 0x011B
#define ATTRID_SE_METERING_CURR_TIER15_SUMM_DLVD 0x011C
#define ATTRID_SE_METERING_CURR_TIER15_SUMM_RCVD 0x011D
#define ATTRID_SE_METERING_CURR_TIER16_SUMM_DLVD 0x011E
#define ATTRID_SE_METERING_CURR_TIER16_SUMM_RCVD 0x011F
#define ATTRID_SE_METERING_CURR_TIER17_SUMM_DLVD 0x0120
#define ATTRID_SE_METERING_CURR_TIER17_SUMM_RCVD 0x0121
#define ATTRID_SE_METERING_CURR_TIER18_SUMM_DLVD 0x0122
#define ATTRID_SE_METERING_CURR_TIER18_SUMM_RCVD 0x0123
#define ATTRID_SE_METERING_CURR_TIER19_SUMM_DLVD 0x0124
#define ATTRID_SE_METERING_CURR_TIER19_SUMM_RCVD 0x0125
#define ATTRID_SE_METERING_CURR_TIER20_SUMM_DLVD 0x0126
#define ATTRID_SE_METERING_CURR_TIER20_SUMM_RCVD 0x0127
#define ATTRID_SE_METERING_CURR_TIER21_SUMM_DLVD 0x0128
#define ATTRID_SE_METERING_CURR_TIER21_SUMM_RCVD 0x0129
#define ATTRID_SE_METERING_CURR_TIER22_SUMM_DLVD 0x012A
#define ATTRID_SE_METERING_CURR_TIER22_SUMM_RCVD 0x012B
#define ATTRID_SE_METERING_CURR_TIER23_SUMM_DLVD 0x012C
#define ATTRID_SE_METERING_CURR_TIER23_SUMM_RCVD 0x012D
#define ATTRID_SE_METERING_CURR_TIER24_SUMM_DLVD 0x012E
#define ATTRID_SE_METERING_CURR_TIER24_SUMM_RCVD 0x012F
#define ATTRID_SE_METERING_CURR_TIER25_SUMM_DLVD 0x0130
#define ATTRID_SE_METERING_CURR_TIER25_SUMM_RCVD 0x0131
#define ATTRID_SE_METERING_CURR_TIER26_SUMM_DLVD 0x0132
#define ATTRID_SE_METERING_CURR_TIER26_SUMM_RCVD 0x0133
#define ATTRID_SE_METERING_CURR_TIER27_SUMM_DLVD 0x0134
#define ATTRID_SE_METERING_CURR_TIER27_SUMM_RCVD 0x0135
#define ATTRID_SE_METERING_CURR_TIER28_SUMM_DLVD 0x0136
#define ATTRID_SE_METERING_CURR_TIER28_SUMM_RCVD 0x0137
#define ATTRID_SE_METERING_CURR_TIER29_SUMM_DLVD 0x0138
#define ATTRID_SE_METERING_CURR_TIER29_SUMM_RCVD 0x0139
#define ATTRID_SE_METERING_CURR_TIER30_SUMM_DLVD 0x013A
#define ATTRID_SE_METERING_CURR_TIER30_SUMM_RCVD 0x013B
#define ATTRID_SE_METERING_CURR_TIER31_SUMM_DLVD 0x013C
#define ATTRID_SE_METERING_CURR_TIER31_SUMM_RCVD 0x013D
#define ATTRID_SE_METERING_CURR_TIER32_SUMM_DLVD 0x013E
#define ATTRID_SE_METERING_CURR_TIER32_SUMM_RCVD 0x013F
#define ATTRID_SE_METERING_CURR_TIER33_SUMM_DLVD 0x0140
#define ATTRID_SE_METERING_CURR_TIER33_SUMM_RCVD 0x0141
#define ATTRID_SE_METERING_CURR_TIER34_SUMM_DLVD 0x0142
#define ATTRID_SE_METERING_CURR_TIER34_SUMM_RCVD 0x0143
#define ATTRID_SE_METERING_CURR_TIER35_SUMM_DLVD 0x0144
#define ATTRID_SE_METERING_CURR_TIER35_SUMM_RCVD 0x0145
#define ATTRID_SE_METERING_CURR_TIER36_SUMM_DLVD 0x0146
#define ATTRID_SE_METERING_CURR_TIER36_SUMM_RCVD 0x0147
#define ATTRID_SE_METERING_CURR_TIER37_SUMM_DLVD 0x0148
#define ATTRID_SE_METERING_CURR_TIER37_SUMM_RCVD 0x0149
#define ATTRID_SE_METERING_CURR_TIER38_SUMM_DLVD 0x014A
#define ATTRID_SE_METERING_CURR_TIER38_SUMM_RCVD 0x014B
#define ATTRID_SE_METERING_CURR_TIER39_SUMM_DLVD 0x014C
#define ATTRID_SE_METERING_CURR_TIER39_SUMM_RCVD 0x014D
#define ATTRID_SE_METERING_CURR_TIER40_SUMM_DLVD 0x014E
#define ATTRID_SE_METERING_CURR_TIER40_SUMM_RCVD 0x014F
#define ATTRID_SE_METERING_CURR_TIER41_SUMM_DLVD 0x0150
#define ATTRID_SE_METERING_CURR_TIER41_SUMM_RCVD 0x0151
#define ATTRID_SE_METERING_CURR_TIER42_SUMM_DLVD 0x0152
#define ATTRID_SE_METERING_CURR_TIER42_SUMM_RCVD 0x0153
#define ATTRID_SE_METERING_CURR_TIER43_SUMM_DLVD 0x0154
#define ATTRID_SE_METERING_CURR_TIER43_SUMM_RCVD 0x0155
#define ATTRID_SE_METERING_CURR_TIER44_SUMM_DLVD 0x0156
#define ATTRID_SE_METERING_CURR_TIER44_SUMM_RCVD 0x0157
#define ATTRID_SE_METERING_CURR_TIER45_SUMM_DLVD 0x0158
#define ATTRID_SE_METERING_CURR_TIER45_SUMM_RCVD 0x0159
#define ATTRID_SE_METERING_CURR_TIER46_SUMM_DLVD 0x015A
#define ATTRID_SE_METERING_CURR_TIER46_SUMM_RCVD 0x015B
#define ATTRID_SE_METERING_CURR_TIER47_SUMM_DLVD 0x015C
#define ATTRID_SE_METERING_CURR_TIER47_SUMM_RCVD 0x015D
#define ATTRID_SE_METERING_CURR_TIER48_SUMM_DLVD 0x015E
#define ATTRID_SE_METERING_CURR_TIER48_SUMM_RCVD 0x015F
#define ATTRID_SE_METERING_CPP1_SUMM_DLVD        0x01FC
#define ATTRID_SE_METERING_CPP2_SUMM_DLVD        0x01FE

//==== Meter Status Attribute Set ====
#define ATTRID_SE_METERING_STATUS                      0x0200
          // see ZCL_SE_METERING_STATUS_BITS
#define ATTRID_SE_METERING_REMAINING_BATT_LIFE         0x0201
#define ATTRID_SE_METERING_HRS_IN_OPERATION            0x0202
#define ATTRID_SE_METERING_HRS_IN_FAULT                0x0203
#define ATTRID_SE_METERING_EXT_STATUS                  0x0204
          // see ZCL_SE_METERING_EXT_STATUS_BITS
#define ATTRID_SE_METERING_REMAINING_BATT_LIFE_IN_DAYS 0x0205
#define ATTRID_SE_METERING_CURR_METER_ID               0x0206
#define ATTRID_SE_METERING_AMBIENT_CONSUMP_IND         0x0207
          // see ZCL_SE_METERING_AMBIENT_LEVEL

//==== Formatting Attribute Set ====
#define ATTRID_SE_METERING_UOM                    0x0300
#define ATTRID_SE_METERING_MULT                   0x0301
#define ATTRID_SE_METERING_DIV                    0x0302
#define ATTRID_SE_METERING_SUMM_FMTG              0x0303
#define ATTRID_SE_METERING_DMD_FMTG               0x0304
#define ATTRID_SE_METERING_HIST_CONSUMP_FMTG      0x0305
#define ATTRID_SE_METERING_DEVICE_TYPE            0x0306 // see ZCL_SE_METERING_DEVICE_TYPE
#define ATTRID_SE_METERING_SITE_ID                0x0307
#define ATTRID_SE_METERING_METER_SER_NUM          0x0308
#define ATTRID_SE_METERING_ENERGY_CARR_UOM        0x0309
#define ATTRID_SE_METERING_ENERGY_CARR_SUMM_FMTG  0x030A
#define ATTRID_SE_METERING_ENERGY_CARR_DMD_FMTG   0x030B
#define ATTRID_SE_METERING_TEMP_UOM               0x030C
#define ATTRID_SE_METERING_TEMP_FMTG              0x030D
#define ATTRID_SE_METERING_MODULE_SER_NUM         0x030E
#define ATTRID_SE_METERING_OPER_TARIFF_LABEL_DLVD 0x030F
#define ATTRID_SE_METERING_OPER_TARIFF_LABEL_RCVD 0x0310
#define ATTRID_SE_METERING_CUSTOMER_ID_NUMBER     0x0311
#define ATTRID_SE_METERING_ALT_UOM                0x0312
#define ATTRID_SE_METERING_ALT_DMD_FMTG           0x0313
#define ATTRID_SE_METERING_ALT_CONSUMP_FMTG       0x0314

//==== Historical Consumption Attribute Set ====
#define ATTRID_SE_METERING_INST_DMD                       0x0400
#define ATTRID_SE_METERING_CURR_DAY_CONSUMP_DLVD          0x0401
#define ATTRID_SE_METERING_CURR_DAY_CONSUMP_RCVD          0x0402
#define ATTRID_SE_METERING_PREV_DAY_CONSUMP_DLVD          0x0403
#define ATTRID_SE_METERING_PREV_DAY_CONSUMP_RCVD          0x0404
#define ATTRID_SE_METERING_CPPI_START_TIME_DLVD           0x0405
#define ATTRID_SE_METERING_CPPI_START_TIME_RCVD           0x0406
#define ATTRID_SE_METERING_CPPI_VALUE_DLVD                0x0407
#define ATTRID_SE_METERING_CPPI_VALUE_RCVD                0x0408
#define ATTRID_SE_METERING_CURR_DAY_MAX_PRESSURE          0x0409
#define ATTRID_SE_METERING_CURR_DAY_MIN_PRESSURE          0x040A
#define ATTRID_SE_METERING_PREV_DAY_MAX_PRESSURE          0x040B
#define ATTRID_SE_METERING_PREV_DAY_MIN_PRESSURE          0x040C
#define ATTRID_SE_METERING_CURR_DAY_MAX_DMD               0x040D
#define ATTRID_SE_METERING_PREV_DAY_MAX_DMD               0x040E
#define ATTRID_SE_METERING_CURR_MONTH_MAX_DMD             0x040F
#define ATTRID_SE_METERING_CURR_YEAR_MAX_DMD              0x0410
#define ATTRID_SE_METERING_CURR_DAY_MAX_ENERGY_CARR_DMD   0x0411
#define ATTRID_SE_METERING_PREV_DAY_MAX_ENERGY_CARR_DMD   0x0412
#define ATTRID_SE_METERING_CURR_MONTH_MAX_ENERGY_CARR_DMD 0x0413
#define ATTRID_SE_METERING_CURR_MONTH_MIN_ENERGY_CARR_DMD 0x0414
#define ATTRID_SE_METERING_CURR_YEAR_MAX_ENERGY_CARR_DMD  0x0415
#define ATTRID_SE_METERING_CURR_YEAR_MIN_ENERGY_CARR_DMD  0x0416
#define ATTRID_SE_METERING_PREV_DAY2_CONSUMP_DLVD         0x0420
#define ATTRID_SE_METERING_PREV_DAY2_CONSUMP_RCVD         0x0421
#define ATTRID_SE_METERING_PREV_DAY3_CONSUMP_DLVD         0x0422
#define ATTRID_SE_METERING_PREV_DAY3_CONSUMP_RCVD         0x0423
#define ATTRID_SE_METERING_PREV_DAY4_CONSUMP_DLVD         0x0424
#define ATTRID_SE_METERING_PREV_DAY4_CONSUMP_RCVD         0x0425
#define ATTRID_SE_METERING_PREV_DAY5_CONSUMP_DLVD         0x0426
#define ATTRID_SE_METERING_PREV_DAY5_CONSUMP_RCVD         0x0427
#define ATTRID_SE_METERING_PREV_DAY6_CONSUMP_DLVD         0x0428
#define ATTRID_SE_METERING_PREV_DAY6_CONSUMP_RCVD         0x0429
#define ATTRID_SE_METERING_PREV_DAY7_CONSUMP_DLVD         0x042A
#define ATTRID_SE_METERING_PREV_DAY7_CONSUMP_RCVD         0x042B
#define ATTRID_SE_METERING_PREV_DAY8_CONSUMP_DLVD         0x042C
#define ATTRID_SE_METERING_PREV_DAY8_CONSUMP_RCVD         0x042D
#define ATTRID_SE_METERING_CURR_WEEK_CONSUMP_DLVD         0x0430
#define ATTRID_SE_METERING_CURR_WEEK_CONSUMP_RCVD         0x0431
#define ATTRID_SE_METERING_PREV_WEEK_CONSUMP_DLVD         0x0432
#define ATTRID_SE_METERING_PREV_WEEK_CONSUMP_RCVD         0x0433
#define ATTRID_SE_METERING_PREV_WEEK2_CONSUMP_DLVD        0x0434
#define ATTRID_SE_METERING_PREV_WEEK2_CONSUMP_RCVD        0x0435
#define ATTRID_SE_METERING_PREV_WEEK3_CONSUMP_DLVD        0x0436
#define ATTRID_SE_METERING_PREV_WEEK3_CONSUMP_RCVD        0x0437
#define ATTRID_SE_METERING_PREV_WEEK4_CONSUMP_DLVD        0x0438
#define ATTRID_SE_METERING_PREV_WEEK4_CONSUMP_RCVD        0x0439
#define ATTRID_SE_METERING_PREV_WEEK5_CONSUMP_DLVD        0x043A
#define ATTRID_SE_METERING_PREV_WEEK5_CONSUMP_RCVD        0x043B
#define ATTRID_SE_METERING_CURR_MONTH_CONSUMP_DLVD        0x0440
#define ATTRID_SE_METERING_CURR_MONTH_CONSUMP_RCVD        0x0441
#define ATTRID_SE_METERING_PREV_MONTH_CONSUMP_DLVD        0x0442
#define ATTRID_SE_METERING_PREV_MONTH_CONSUMP_RCVD        0x0443
#define ATTRID_SE_METERING_PREV_MONTH_2_CONSUMP_DLVD      0x0444
#define ATTRID_SE_METERING_PREV_MONTH_2_CONSUMP_RCVD      0x0445
#define ATTRID_SE_METERING_PREV_MONTH_3_CONSUMP_DLVD      0x0446
#define ATTRID_SE_METERING_PREV_MONTH_3_CONSUMP_RCVD      0x0447
#define ATTRID_SE_METERING_PREV_MONTH_4_CONSUMP_DLVD      0x0448
#define ATTRID_SE_METERING_PREV_MONTH_4_CONSUMP_RCVD      0x0449
#define ATTRID_SE_METERING_PREV_MONTH_5_CONSUMP_DLVD      0x044A
#define ATTRID_SE_METERING_PREV_MONTH_5_CONSUMP_RCVD      0x044B
#define ATTRID_SE_METERING_PREV_MONTH_6_CONSUMP_DLVD      0x044C
#define ATTRID_SE_METERING_PREV_MONTH_6_CONSUMP_RCVD      0x044D
#define ATTRID_SE_METERING_PREV_MONTH_7_CONSUMP_DLVD      0x044E
#define ATTRID_SE_METERING_PREV_MONTH_7_CONSUMP_RCVD      0x044F
#define ATTRID_SE_METERING_PREV_MONTH_8_CONSUMP_DLVD      0x0450
#define ATTRID_SE_METERING_PREV_MONTH_8_CONSUMP_RCVD      0x0451
#define ATTRID_SE_METERING_PREV_MONTH_9_CONSUMP_DLVD      0x0452
#define ATTRID_SE_METERING_PREV_MONTH_9_CONSUMP_RCVD      0x0453
#define ATTRID_SE_METERING_PREV_MONTH_10_CONSUMP_DLVD     0x0454
#define ATTRID_SE_METERING_PREV_MONTH_10_CONSUMP_RCVD     0x0455
#define ATTRID_SE_METERING_PREV_MONTH_11_CONSUMP_DLVD     0x0456
#define ATTRID_SE_METERING_PREV_MONTH_11_CONSUMP_RCVD     0x0457
#define ATTRID_SE_METERING_PREV_MONTH_12_CONSUMP_DLVD     0x0458
#define ATTRID_SE_METERING_PREV_MONTH_12_CONSUMP_RCVD     0x0459
#define ATTRID_SE_METERING_PREV_MONTH_13_CONSUMP_DLVD     0x045A
#define ATTRID_SE_METERING_PREV_MONTH_13_CONSUMP_RCVD     0x045B
#define ATTRID_SE_METERING_HIST_FREEZE_TIME               0x045C

//==== Load Profile Configuration Attribute Set ====
#define ATTRID_SE_METERING_MAX_NUM_OF_PERIODS_DLVD 0x0500

//==== Supply Limit Attribute Set ====
#define ATTRID_SE_METERING_CURR_DMD_DLVD             0x0600
#define ATTRID_SE_METERING_DMD_LIMIT                 0x0601
#define ATTRID_SE_METERING_DMD_INTEGRATION_PERIOD    0x0602
#define ATTRID_SE_METERING_NUM_OF_DMD_SUBINTERVALS   0x0603
#define ATTRID_SE_METERING_DMD_LIMIT_ARM_DURATION    0x0604
#define ATTRID_SE_METERING_LOAD_LIMIT_SUPPLY_STATE   0x0605
          // see ZCL_SE_METERING_SET_SUPPLY_STATUS
#define ATTRID_SE_METERING_LOAD_LIMIT_COUNTER        0x0606
#define ATTRID_SE_METERING_SUPPLY_TAMPER_STATE       0x0607
          // see ZCL_SE_METERING_SET_SUPPLY_STATUS
#define ATTRID_SE_METERING_SUPPLY_DEPLETION_STATE    0x0608
          // see ZCL_SE_METERING_SET_SUPPLY_STATUS
#define ATTRID_SE_METERING_SUPPLY_UNCTRLD_FLOW_STATE 0x0609
          // see ZCL_SE_METERING_SET_SUPPLY_STATUS

//==== Block Information (Delivered) Attribute Set ====
#define ATTRID_SE_METERING_CURR_NO_TIER_BLOCK1_SUMM_DLVD  0x0700
#define ATTRID_SE_METERING_CURR_NO_TIER_BLOCK2_SUMM_DLVD  0x0701
#define ATTRID_SE_METERING_CURR_NO_TIER_BLOCK3_SUMM_DLVD  0x0702
#define ATTRID_SE_METERING_CURR_NO_TIER_BLOCK4_SUMM_DLVD  0x0703
#define ATTRID_SE_METERING_CURR_NO_TIER_BLOCK5_SUMM_DLVD  0x0704
#define ATTRID_SE_METERING_CURR_NO_TIER_BLOCK6_SUMM_DLVD  0x0705
#define ATTRID_SE_METERING_CURR_NO_TIER_BLOCK7_SUMM_DLVD  0x0706
#define ATTRID_SE_METERING_CURR_NO_TIER_BLOCK8_SUMM_DLVD  0x0707
#define ATTRID_SE_METERING_CURR_NO_TIER_BLOCK9_SUMM_DLVD  0x0708
#define ATTRID_SE_METERING_CURR_NO_TIER_BLOCK10_SUMM_DLVD 0x0709
#define ATTRID_SE_METERING_CURR_NO_TIER_BLOCK11_SUMM_DLVD 0x070A
#define ATTRID_SE_METERING_CURR_NO_TIER_BLOCK12_SUMM_DLVD 0x070B
#define ATTRID_SE_METERING_CURR_NO_TIER_BLOCK13_SUMM_DLVD 0x070C
#define ATTRID_SE_METERING_CURR_NO_TIER_BLOCK14_SUMM_DLVD 0x070D
#define ATTRID_SE_METERING_CURR_NO_TIER_BLOCK15_SUMM_DLVD 0x070E
#define ATTRID_SE_METERING_CURR_NO_TIER_BLOCK16_SUMM_DLVD 0x070F
// Tier 1
#define ATTRID_SE_METERING_CURR_TIER1_BLOCK1_SUMM_DLVD    0x0710
#define ATTRID_SE_METERING_CURR_TIER1_BLOCK2_SUMM_DLVD    0x0711
#define ATTRID_SE_METERING_CURR_TIER1_BLOCK3_SUMM_DLVD    0x0712
#define ATTRID_SE_METERING_CURR_TIER1_BLOCK4_SUMM_DLVD    0x0713
#define ATTRID_SE_METERING_CURR_TIER1_BLOCK5_SUMM_DLVD    0x0714
#define ATTRID_SE_METERING_CURR_TIER1_BLOCK6_SUMM_DLVD    0x0715
#define ATTRID_SE_METERING_CURR_TIER1_BLOCK7_SUMM_DLVD    0x0716
#define ATTRID_SE_METERING_CURR_TIER1_BLOCK8_SUMM_DLVD    0x0717
#define ATTRID_SE_METERING_CURR_TIER1_BLOCK9_SUMM_DLVD    0x0718
#define ATTRID_SE_METERING_CURR_TIER1_BLOCK10_SUMM_DLVD   0x0719
#define ATTRID_SE_METERING_CURR_TIER1_BLOCK11_SUMM_DLVD   0x071A
#define ATTRID_SE_METERING_CURR_TIER1_BLOCK12_SUMM_DLVD   0x071B
#define ATTRID_SE_METERING_CURR_TIER1_BLOCK13_SUMM_DLVD   0x071C
#define ATTRID_SE_METERING_CURR_TIER1_BLOCK14_SUMM_DLVD   0x071D
#define ATTRID_SE_METERING_CURR_TIER1_BLOCK15_SUMM_DLVD   0x071E
#define ATTRID_SE_METERING_CURR_TIER1_BLOCK16_SUMM_DLVD   0x071F
// Tier 2
#define ATTRID_SE_METERING_CURR_TIER2_BLOCK1_SUMM_DLVD    0x0720
#define ATTRID_SE_METERING_CURR_TIER2_BLOCK2_SUMM_DLVD    0x0721
#define ATTRID_SE_METERING_CURR_TIER2_BLOCK3_SUMM_DLVD    0x0722
#define ATTRID_SE_METERING_CURR_TIER2_BLOCK4_SUMM_DLVD    0x0723
#define ATTRID_SE_METERING_CURR_TIER2_BLOCK5_SUMM_DLVD    0x0724
#define ATTRID_SE_METERING_CURR_TIER2_BLOCK6_SUMM_DLVD    0x0725
#define ATTRID_SE_METERING_CURR_TIER2_BLOCK7_SUMM_DLVD    0x0726
#define ATTRID_SE_METERING_CURR_TIER2_BLOCK8_SUMM_DLVD    0x0727
#define ATTRID_SE_METERING_CURR_TIER2_BLOCK9_SUMM_DLVD    0x0728
#define ATTRID_SE_METERING_CURR_TIER2_BLOCK10_SUMM_DLVD   0x0729
#define ATTRID_SE_METERING_CURR_TIER2_BLOCK11_SUMM_DLVD   0x072A
#define ATTRID_SE_METERING_CURR_TIER2_BLOCK12_SUMM_DLVD   0x072B
#define ATTRID_SE_METERING_CURR_TIER2_BLOCK13_SUMM_DLVD   0x072C
#define ATTRID_SE_METERING_CURR_TIER2_BLOCK14_SUMM_DLVD   0x072D
#define ATTRID_SE_METERING_CURR_TIER2_BLOCK15_SUMM_DLVD   0x072E
#define ATTRID_SE_METERING_CURR_TIER2_BLOCK16_SUMM_DLVD   0x072F
// Tier 3
#define ATTRID_SE_METERING_CURR_TIER3_BLOCK1_SUMM_DLVD    0x0730
#define ATTRID_SE_METERING_CURR_TIER3_BLOCK2_SUMM_DLVD    0x0731
#define ATTRID_SE_METERING_CURR_TIER3_BLOCK3_SUMM_DLVD    0x0732
#define ATTRID_SE_METERING_CURR_TIER3_BLOCK4_SUMM_DLVD    0x0733
#define ATTRID_SE_METERING_CURR_TIER3_BLOCK5_SUMM_DLVD    0x0734
#define ATTRID_SE_METERING_CURR_TIER3_BLOCK6_SUMM_DLVD    0x0735
#define ATTRID_SE_METERING_CURR_TIER3_BLOCK7_SUMM_DLVD    0x0736
#define ATTRID_SE_METERING_CURR_TIER3_BLOCK8_SUMM_DLVD    0x0737
#define ATTRID_SE_METERING_CURR_TIER3_BLOCK9_SUMM_DLVD    0x0738
#define ATTRID_SE_METERING_CURR_TIER3_BLOCK10_SUMM_DLVD   0x0739
#define ATTRID_SE_METERING_CURR_TIER3_BLOCK11_SUMM_DLVD   0x073A
#define ATTRID_SE_METERING_CURR_TIER3_BLOCK12_SUMM_DLVD   0x073B
#define ATTRID_SE_METERING_CURR_TIER3_BLOCK13_SUMM_DLVD   0x073C
#define ATTRID_SE_METERING_CURR_TIER3_BLOCK14_SUMM_DLVD   0x073D
#define ATTRID_SE_METERING_CURR_TIER3_BLOCK15_SUMM_DLVD   0x073E
#define ATTRID_SE_METERING_CURR_TIER3_BLOCK16_SUMM_DLVD   0x073F
// Tier 4
#define ATTRID_SE_METERING_CURR_TIER4_BLOCK1_SUMM_DLVD    0x0740
#define ATTRID_SE_METERING_CURR_TIER4_BLOCK2_SUMM_DLVD    0x0741
#define ATTRID_SE_METERING_CURR_TIER4_BLOCK3_SUMM_DLVD    0x0742
#define ATTRID_SE_METERING_CURR_TIER4_BLOCK4_SUMM_DLVD    0x0743
#define ATTRID_SE_METERING_CURR_TIER4_BLOCK5_SUMM_DLVD    0x0744
#define ATTRID_SE_METERING_CURR_TIER4_BLOCK6_SUMM_DLVD    0x0745
#define ATTRID_SE_METERING_CURR_TIER4_BLOCK7_SUMM_DLVD    0x0746
#define ATTRID_SE_METERING_CURR_TIER4_BLOCK8_SUMM_DLVD    0x0747
#define ATTRID_SE_METERING_CURR_TIER4_BLOCK9_SUMM_DLVD    0x0748
#define ATTRID_SE_METERING_CURR_TIER4_BLOCK10_SUMM_DLVD   0x0749
#define ATTRID_SE_METERING_CURR_TIER4_BLOCK11_SUMM_DLVD   0x074A
#define ATTRID_SE_METERING_CURR_TIER4_BLOCK12_SUMM_DLVD   0x074B
#define ATTRID_SE_METERING_CURR_TIER4_BLOCK13_SUMM_DLVD   0x074C
#define ATTRID_SE_METERING_CURR_TIER4_BLOCK14_SUMM_DLVD   0x074D
#define ATTRID_SE_METERING_CURR_TIER4_BLOCK15_SUMM_DLVD   0x074E
#define ATTRID_SE_METERING_CURR_TIER4_BLOCK16_SUMM_DLVD   0x074F
// Tier 5
#define ATTRID_SE_METERING_CURR_TIER5_BLOCK1_SUMM_DLVD    0x0750
#define ATTRID_SE_METERING_CURR_TIER5_BLOCK2_SUMM_DLVD    0x0751
#define ATTRID_SE_METERING_CURR_TIER5_BLOCK3_SUMM_DLVD    0x0752
#define ATTRID_SE_METERING_CURR_TIER5_BLOCK4_SUMM_DLVD    0x0753
#define ATTRID_SE_METERING_CURR_TIER5_BLOCK5_SUMM_DLVD    0x0754
#define ATTRID_SE_METERING_CURR_TIER5_BLOCK6_SUMM_DLVD    0x0755
#define ATTRID_SE_METERING_CURR_TIER5_BLOCK7_SUMM_DLVD    0x0756
#define ATTRID_SE_METERING_CURR_TIER5_BLOCK8_SUMM_DLVD    0x0757
#define ATTRID_SE_METERING_CURR_TIER5_BLOCK9_SUMM_DLVD    0x0758
#define ATTRID_SE_METERING_CURR_TIER5_BLOCK10_SUMM_DLVD   0x0759
#define ATTRID_SE_METERING_CURR_TIER5_BLOCK11_SUMM_DLVD   0x075A
#define ATTRID_SE_METERING_CURR_TIER5_BLOCK12_SUMM_DLVD   0x075B
#define ATTRID_SE_METERING_CURR_TIER5_BLOCK13_SUMM_DLVD   0x075C
#define ATTRID_SE_METERING_CURR_TIER5_BLOCK14_SUMM_DLVD   0x075D
#define ATTRID_SE_METERING_CURR_TIER5_BLOCK15_SUMM_DLVD   0x075E
#define ATTRID_SE_METERING_CURR_TIER5_BLOCK16_SUMM_DLVD   0x075F
// Tier 6
#define ATTRID_SE_METERING_CURR_TIER6_BLOCK1_SUMM_DLVD    0x0760
#define ATTRID_SE_METERING_CURR_TIER6_BLOCK2_SUMM_DLVD    0x0761
#define ATTRID_SE_METERING_CURR_TIER6_BLOCK3_SUMM_DLVD    0x0762
#define ATTRID_SE_METERING_CURR_TIER6_BLOCK4_SUMM_DLVD    0x0763
#define ATTRID_SE_METERING_CURR_TIER6_BLOCK5_SUMM_DLVD    0x0764
#define ATTRID_SE_METERING_CURR_TIER6_BLOCK6_SUMM_DLVD    0x0765
#define ATTRID_SE_METERING_CURR_TIER6_BLOCK7_SUMM_DLVD    0x0766
#define ATTRID_SE_METERING_CURR_TIER6_BLOCK8_SUMM_DLVD    0x0767
#define ATTRID_SE_METERING_CURR_TIER6_BLOCK9_SUMM_DLVD    0x0768
#define ATTRID_SE_METERING_CURR_TIER6_BLOCK10_SUMM_DLVD   0x0769
#define ATTRID_SE_METERING_CURR_TIER6_BLOCK11_SUMM_DLVD   0x076A
#define ATTRID_SE_METERING_CURR_TIER6_BLOCK12_SUMM_DLVD   0x076B
#define ATTRID_SE_METERING_CURR_TIER6_BLOCK13_SUMM_DLVD   0x076C
#define ATTRID_SE_METERING_CURR_TIER6_BLOCK14_SUMM_DLVD   0x076D
#define ATTRID_SE_METERING_CURR_TIER6_BLOCK15_SUMM_DLVD   0x076E
#define ATTRID_SE_METERING_CURR_TIER6_BLOCK16_SUMM_DLVD   0x076F
// Tier 7
#define ATTRID_SE_METERING_CURR_TIER7_BLOCK1_SUMM_DLVD    0x0770
#define ATTRID_SE_METERING_CURR_TIER7_BLOCK2_SUMM_DLVD    0x0771
#define ATTRID_SE_METERING_CURR_TIER7_BLOCK3_SUMM_DLVD    0x0772
#define ATTRID_SE_METERING_CURR_TIER7_BLOCK4_SUMM_DLVD    0x0773
#define ATTRID_SE_METERING_CURR_TIER7_BLOCK5_SUMM_DLVD    0x0774
#define ATTRID_SE_METERING_CURR_TIER7_BLOCK6_SUMM_DLVD    0x0775
#define ATTRID_SE_METERING_CURR_TIER7_BLOCK7_SUMM_DLVD    0x0776
#define ATTRID_SE_METERING_CURR_TIER7_BLOCK8_SUMM_DLVD    0x0777
#define ATTRID_SE_METERING_CURR_TIER7_BLOCK9_SUMM_DLVD    0x0778
#define ATTRID_SE_METERING_CURR_TIER7_BLOCK10_SUMM_DLVD   0x0779
#define ATTRID_SE_METERING_CURR_TIER7_BLOCK11_SUMM_DLVD   0x077A
#define ATTRID_SE_METERING_CURR_TIER7_BLOCK12_SUMM_DLVD   0x077B
#define ATTRID_SE_METERING_CURR_TIER7_BLOCK13_SUMM_DLVD   0x077C
#define ATTRID_SE_METERING_CURR_TIER7_BLOCK14_SUMM_DLVD   0x077D
#define ATTRID_SE_METERING_CURR_TIER7_BLOCK15_SUMM_DLVD   0x077E
#define ATTRID_SE_METERING_CURR_TIER7_BLOCK16_SUMM_DLVD   0x077F
// Tier 8
#define ATTRID_SE_METERING_CURR_TIER8_BLOCK1_SUMM_DLVD    0x0780
#define ATTRID_SE_METERING_CURR_TIER8_BLOCK2_SUMM_DLVD    0x0781
#define ATTRID_SE_METERING_CURR_TIER8_BLOCK3_SUMM_DLVD    0x0782
#define ATTRID_SE_METERING_CURR_TIER8_BLOCK4_SUMM_DLVD    0x0783
#define ATTRID_SE_METERING_CURR_TIER8_BLOCK5_SUMM_DLVD    0x0784
#define ATTRID_SE_METERING_CURR_TIER8_BLOCK6_SUMM_DLVD    0x0785
#define ATTRID_SE_METERING_CURR_TIER8_BLOCK7_SUMM_DLVD    0x0786
#define ATTRID_SE_METERING_CURR_TIER8_BLOCK8_SUMM_DLVD    0x0787
#define ATTRID_SE_METERING_CURR_TIER8_BLOCK9_SUMM_DLVD    0x0788
#define ATTRID_SE_METERING_CURR_TIER8_BLOCK10_SUMM_DLVD   0x0789
#define ATTRID_SE_METERING_CURR_TIER8_BLOCK11_SUMM_DLVD   0x078A
#define ATTRID_SE_METERING_CURR_TIER8_BLOCK12_SUMM_DLVD   0x078B
#define ATTRID_SE_METERING_CURR_TIER8_BLOCK13_SUMM_DLVD   0x078C
#define ATTRID_SE_METERING_CURR_TIER8_BLOCK14_SUMM_DLVD   0x078D
#define ATTRID_SE_METERING_CURR_TIER8_BLOCK15_SUMM_DLVD   0x078E
#define ATTRID_SE_METERING_CURR_TIER8_BLOCK16_SUMM_DLVD   0x078F
// Tier 9
#define ATTRID_SE_METERING_CURR_TIER9_BLOCK1_SUMM_DLVD    0x0790
#define ATTRID_SE_METERING_CURR_TIER9_BLOCK2_SUMM_DLVD    0x0791
#define ATTRID_SE_METERING_CURR_TIER9_BLOCK3_SUMM_DLVD    0x0792
#define ATTRID_SE_METERING_CURR_TIER9_BLOCK4_SUMM_DLVD    0x0793
#define ATTRID_SE_METERING_CURR_TIER9_BLOCK5_SUMM_DLVD    0x0794
#define ATTRID_SE_METERING_CURR_TIER9_BLOCK6_SUMM_DLVD    0x0795
#define ATTRID_SE_METERING_CURR_TIER9_BLOCK7_SUMM_DLVD    0x0796
#define ATTRID_SE_METERING_CURR_TIER9_BLOCK8_SUMM_DLVD    0x0797
#define ATTRID_SE_METERING_CURR_TIER9_BLOCK9_SUMM_DLVD    0x0798
#define ATTRID_SE_METERING_CURR_TIER9_BLOCK10_SUMM_DLVD   0x0799
#define ATTRID_SE_METERING_CURR_TIER9_BLOCK11_SUMM_DLVD   0x079A
#define ATTRID_SE_METERING_CURR_TIER9_BLOCK12_SUMM_DLVD   0x079B
#define ATTRID_SE_METERING_CURR_TIER9_BLOCK13_SUMM_DLVD   0x079C
#define ATTRID_SE_METERING_CURR_TIER9_BLOCK14_SUMM_DLVD   0x079D
#define ATTRID_SE_METERING_CURR_TIER9_BLOCK15_SUMM_DLVD   0x079E
#define ATTRID_SE_METERING_CURR_TIER9_BLOCK16_SUMM_DLVD   0x079F
// Tier 10
#define ATTRID_SE_METERING_CURR_TIER10_BLOCK1_SUMM_DLVD   0x07A0
#define ATTRID_SE_METERING_CURR_TIER10_BLOCK2_SUMM_DLVD   0x07A1
#define ATTRID_SE_METERING_CURR_TIER10_BLOCK3_SUMM_DLVD   0x07A2
#define ATTRID_SE_METERING_CURR_TIER10_BLOCK4_SUMM_DLVD   0x07A3
#define ATTRID_SE_METERING_CURR_TIER10_BLOCK5_SUMM_DLVD   0x07A4
#define ATTRID_SE_METERING_CURR_TIER10_BLOCK6_SUMM_DLVD   0x07A5
#define ATTRID_SE_METERING_CURR_TIER10_BLOCK7_SUMM_DLVD   0x07A6
#define ATTRID_SE_METERING_CURR_TIER10_BLOCK8_SUMM_DLVD   0x07A7
#define ATTRID_SE_METERING_CURR_TIER10_BLOCK9_SUMM_DLVD   0x07A8
#define ATTRID_SE_METERING_CURR_TIER10_BLOCK10_SUMM_DLVD  0x07A9
#define ATTRID_SE_METERING_CURR_TIER10_BLOCK11_SUMM_DLVD  0x07AA
#define ATTRID_SE_METERING_CURR_TIER10_BLOCK12_SUMM_DLVD  0x07AB
#define ATTRID_SE_METERING_CURR_TIER10_BLOCK13_SUMM_DLVD  0x07AC
#define ATTRID_SE_METERING_CURR_TIER10_BLOCK14_SUMM_DLVD  0x07AD
#define ATTRID_SE_METERING_CURR_TIER10_BLOCK15_SUMM_DLVD  0x07AE
#define ATTRID_SE_METERING_CURR_TIER10_BLOCK16_SUMM_DLVD  0x07AF
// Tier 11
#define ATTRID_SE_METERING_CURR_TIER11_BLOCK1_SUMM_DLVD   0x07B0
#define ATTRID_SE_METERING_CURR_TIER11_BLOCK2_SUMM_DLVD   0x07B1
#define ATTRID_SE_METERING_CURR_TIER11_BLOCK3_SUMM_DLVD   0x07B2
#define ATTRID_SE_METERING_CURR_TIER11_BLOCK4_SUMM_DLVD   0x07B3
#define ATTRID_SE_METERING_CURR_TIER11_BLOCK5_SUMM_DLVD   0x07B4
#define ATTRID_SE_METERING_CURR_TIER11_BLOCK6_SUMM_DLVD   0x07B5
#define ATTRID_SE_METERING_CURR_TIER11_BLOCK7_SUMM_DLVD   0x07B6
#define ATTRID_SE_METERING_CURR_TIER11_BLOCK8_SUMM_DLVD   0x07B7
#define ATTRID_SE_METERING_CURR_TIER11_BLOCK9_SUMM_DLVD   0x07B8
#define ATTRID_SE_METERING_CURR_TIER11_BLOCK10_SUMM_DLVD  0x07B9
#define ATTRID_SE_METERING_CURR_TIER11_BLOCK11_SUMM_DLVD  0x07BA
#define ATTRID_SE_METERING_CURR_TIER11_BLOCK12_SUMM_DLVD  0x07BB
#define ATTRID_SE_METERING_CURR_TIER11_BLOCK13_SUMM_DLVD  0x07BC
#define ATTRID_SE_METERING_CURR_TIER11_BLOCK14_SUMM_DLVD  0x07BD
#define ATTRID_SE_METERING_CURR_TIER11_BLOCK15_SUMM_DLVD  0x07BE
#define ATTRID_SE_METERING_CURR_TIER11_BLOCK16_SUMM_DLVD  0x07BF
// Tier 12
#define ATTRID_SE_METERING_CURR_TIER12_BLOCK1_SUMM_DLVD   0x07C0
#define ATTRID_SE_METERING_CURR_TIER12_BLOCK2_SUMM_DLVD   0x07C1
#define ATTRID_SE_METERING_CURR_TIER12_BLOCK3_SUMM_DLVD   0x07C2
#define ATTRID_SE_METERING_CURR_TIER12_BLOCK4_SUMM_DLVD   0x07C3
#define ATTRID_SE_METERING_CURR_TIER12_BLOCK5_SUMM_DLVD   0x07C4
#define ATTRID_SE_METERING_CURR_TIER12_BLOCK6_SUMM_DLVD   0x07C5
#define ATTRID_SE_METERING_CURR_TIER12_BLOCK7_SUMM_DLVD   0x07C6
#define ATTRID_SE_METERING_CURR_TIER12_BLOCK8_SUMM_DLVD   0x07C7
#define ATTRID_SE_METERING_CURR_TIER12_BLOCK9_SUMM_DLVD   0x07C8
#define ATTRID_SE_METERING_CURR_TIER12_BLOCK10_SUMM_DLVD  0x07C9
#define ATTRID_SE_METERING_CURR_TIER12_BLOCK11_SUMM_DLVD  0x07CA
#define ATTRID_SE_METERING_CURR_TIER12_BLOCK12_SUMM_DLVD  0x07CB
#define ATTRID_SE_METERING_CURR_TIER12_BLOCK13_SUMM_DLVD  0x07CC
#define ATTRID_SE_METERING_CURR_TIER12_BLOCK14_SUMM_DLVD  0x07CD
#define ATTRID_SE_METERING_CURR_TIER12_BLOCK15_SUMM_DLVD  0x07CE
#define ATTRID_SE_METERING_CURR_TIER12_BLOCK16_SUMM_DLVD  0x07CF
// Tier 13
#define ATTRID_SE_METERING_CURR_TIER13_BLOCK1_SUMM_DLVD   0x07D0
#define ATTRID_SE_METERING_CURR_TIER13_BLOCK2_SUMM_DLVD   0x07D1
#define ATTRID_SE_METERING_CURR_TIER13_BLOCK3_SUMM_DLVD   0x07D2
#define ATTRID_SE_METERING_CURR_TIER13_BLOCK4_SUMM_DLVD   0x07D3
#define ATTRID_SE_METERING_CURR_TIER13_BLOCK5_SUMM_DLVD   0x07D4
#define ATTRID_SE_METERING_CURR_TIER13_BLOCK6_SUMM_DLVD   0x07D5
#define ATTRID_SE_METERING_CURR_TIER13_BLOCK7_SUMM_DLVD   0x07D6
#define ATTRID_SE_METERING_CURR_TIER13_BLOCK8_SUMM_DLVD   0x07D7
#define ATTRID_SE_METERING_CURR_TIER13_BLOCK9_SUMM_DLVD   0x07D8
#define ATTRID_SE_METERING_CURR_TIER13_BLOCK10_SUMM_DLVD  0x07D9
#define ATTRID_SE_METERING_CURR_TIER13_BLOCK11_SUMM_DLVD  0x07DA
#define ATTRID_SE_METERING_CURR_TIER13_BLOCK12_SUMM_DLVD  0x07DB
#define ATTRID_SE_METERING_CURR_TIER13_BLOCK13_SUMM_DLVD  0x07DC
#define ATTRID_SE_METERING_CURR_TIER13_BLOCK14_SUMM_DLVD  0x07DD
#define ATTRID_SE_METERING_CURR_TIER13_BLOCK15_SUMM_DLVD  0x07DE
#define ATTRID_SE_METERING_CURR_TIER13_BLOCK16_SUMM_DLVD  0x07DF
// Tier 14
#define ATTRID_SE_METERING_CURR_TIER14_BLOCK1_SUMM_DLVD   0x07E0
#define ATTRID_SE_METERING_CURR_TIER14_BLOCK2_SUMM_DLVD   0x07E1
#define ATTRID_SE_METERING_CURR_TIER14_BLOCK3_SUMM_DLVD   0x07E2
#define ATTRID_SE_METERING_CURR_TIER14_BLOCK4_SUMM_DLVD   0x07E3
#define ATTRID_SE_METERING_CURR_TIER14_BLOCK5_SUMM_DLVD   0x07E4
#define ATTRID_SE_METERING_CURR_TIER14_BLOCK6_SUMM_DLVD   0x07E5
#define ATTRID_SE_METERING_CURR_TIER14_BLOCK7_SUMM_DLVD   0x07E6
#define ATTRID_SE_METERING_CURR_TIER14_BLOCK8_SUMM_DLVD   0x07E7
#define ATTRID_SE_METERING_CURR_TIER14_BLOCK9_SUMM_DLVD   0x07E8
#define ATTRID_SE_METERING_CURR_TIER14_BLOCK10_SUMM_DLVD  0x07E9
#define ATTRID_SE_METERING_CURR_TIER14_BLOCK11_SUMM_DLVD  0x07EA
#define ATTRID_SE_METERING_CURR_TIER14_BLOCK12_SUMM_DLVD  0x07EB
#define ATTRID_SE_METERING_CURR_TIER14_BLOCK13_SUMM_DLVD  0x07EC
#define ATTRID_SE_METERING_CURR_TIER14_BLOCK14_SUMM_DLVD  0x07ED
#define ATTRID_SE_METERING_CURR_TIER14_BLOCK15_SUMM_DLVD  0x07EE
#define ATTRID_SE_METERING_CURR_TIER14_BLOCK16_SUMM_DLVD  0x07EF
// Tier 15
#define ATTRID_SE_METERING_CURR_TIER15_BLOCK1_SUMM_DLVD   0x07F0
#define ATTRID_SE_METERING_CURR_TIER15_BLOCK2_SUMM_DLVD   0x07F1
#define ATTRID_SE_METERING_CURR_TIER15_BLOCK3_SUMM_DLVD   0x07F2
#define ATTRID_SE_METERING_CURR_TIER15_BLOCK4_SUMM_DLVD   0x07F3
#define ATTRID_SE_METERING_CURR_TIER15_BLOCK5_SUMM_DLVD   0x07F4
#define ATTRID_SE_METERING_CURR_TIER15_BLOCK6_SUMM_DLVD   0x07F5
#define ATTRID_SE_METERING_CURR_TIER15_BLOCK7_SUMM_DLVD   0x07F6
#define ATTRID_SE_METERING_CURR_TIER15_BLOCK8_SUMM_DLVD   0x07F7
#define ATTRID_SE_METERING_CURR_TIER15_BLOCK9_SUMM_DLVD   0x07F8
#define ATTRID_SE_METERING_CURR_TIER15_BLOCK10_SUMM_DLVD  0x07F9
#define ATTRID_SE_METERING_CURR_TIER15_BLOCK11_SUMM_DLVD  0x07FA
#define ATTRID_SE_METERING_CURR_TIER15_BLOCK12_SUMM_DLVD  0x07FB
#define ATTRID_SE_METERING_CURR_TIER15_BLOCK13_SUMM_DLVD  0x07FC
#define ATTRID_SE_METERING_CURR_TIER15_BLOCK14_SUMM_DLVD  0x07FD
#define ATTRID_SE_METERING_CURR_TIER15_BLOCK15_SUMM_DLVD  0x07FE
#define ATTRID_SE_METERING_CURR_TIER15_BLOCK16_SUMM_DLVD  0x07FF

//==== Alarms Attribute Set ====
#define ATTRID_SE_METERING_GENERIC_ALARM_MASK       0x0800
#define ATTRID_SE_METERING_ELEC_ALARM_MASK          0x0801
#define ATTRID_SE_METERING_FLOW_PRESSURE_ALARM_MASK 0x0802
#define ATTRID_SE_METERING_WATER_ALARM_MASK         0x0803
#define ATTRID_SE_METERING_HEAT_COOLING_ALARM_MASK  0x0804
#define ATTRID_SE_METERING_GAS_ALARM_MASK           0x0805
#define ATTRID_SE_METERING_EXT_GENERIC_ALARM_MASK   0x0806
#define ATTRID_SE_METERING_MANU_ALARM_MASK          0x0807

//==== Block Information (Received) Attribute Set ====
#define ATTRID_SE_METERING_CURR_NO_TIER_BLOCK1_SUMM_RCVD  0x0900
#define ATTRID_SE_METERING_CURR_NO_TIER_BLOCK2_SUMM_RCVD  0x0901
#define ATTRID_SE_METERING_CURR_NO_TIER_BLOCK3_SUMM_RCVD  0x0902
#define ATTRID_SE_METERING_CURR_NO_TIER_BLOCK4_SUMM_RCVD  0x0903
#define ATTRID_SE_METERING_CURR_NO_TIER_BLOCK5_SUMM_RCVD  0x0904
#define ATTRID_SE_METERING_CURR_NO_TIER_BLOCK6_SUMM_RCVD  0x0905
#define ATTRID_SE_METERING_CURR_NO_TIER_BLOCK7_SUMM_RCVD  0x0906
#define ATTRID_SE_METERING_CURR_NO_TIER_BLOCK8_SUMM_RCVD  0x0907
#define ATTRID_SE_METERING_CURR_NO_TIER_BLOCK9_SUMM_RCVD  0x0908
#define ATTRID_SE_METERING_CURR_NO_TIER_BLOCK10_SUMM_RCVD 0x0909
#define ATTRID_SE_METERING_CURR_NO_TIER_BLOCK11_SUMM_RCVD 0x090A
#define ATTRID_SE_METERING_CURR_NO_TIER_BLOCK12_SUMM_RCVD 0x090B
#define ATTRID_SE_METERING_CURR_NO_TIER_BLOCK13_SUMM_RCVD 0x090C
#define ATTRID_SE_METERING_CURR_NO_TIER_BLOCK14_SUMM_RCVD 0x090D
#define ATTRID_SE_METERING_CURR_NO_TIER_BLOCK15_SUMM_RCVD 0x090E
#define ATTRID_SE_METERING_CURR_NO_TIER_BLOCK16_SUMM_RCVD 0x090F
// Tier 1
#define ATTRID_SE_METERING_CURR_TIER1_BLOCK1_SUMM_RCVD    0x0910
#define ATTRID_SE_METERING_CURR_TIER1_BLOCK2_SUMM_RCVD    0x0911
#define ATTRID_SE_METERING_CURR_TIER1_BLOCK3_SUMM_RCVD    0x0912
#define ATTRID_SE_METERING_CURR_TIER1_BLOCK4_SUMM_RCVD    0x0913
#define ATTRID_SE_METERING_CURR_TIER1_BLOCK5_SUMM_RCVD    0x0914
#define ATTRID_SE_METERING_CURR_TIER1_BLOCK6_SUMM_RCVD    0x0915
#define ATTRID_SE_METERING_CURR_TIER1_BLOCK7_SUMM_RCVD    0x0916
#define ATTRID_SE_METERING_CURR_TIER1_BLOCK8_SUMM_RCVD    0x0917
#define ATTRID_SE_METERING_CURR_TIER1_BLOCK9_SUMM_RCVD    0x0918
#define ATTRID_SE_METERING_CURR_TIER1_BLOCK10_SUMM_RCVD   0x0919
#define ATTRID_SE_METERING_CURR_TIER1_BLOCK11_SUMM_RCVD   0x091A
#define ATTRID_SE_METERING_CURR_TIER1_BLOCK12_SUMM_RCVD   0x091B
#define ATTRID_SE_METERING_CURR_TIER1_BLOCK13_SUMM_RCVD   0x091C
#define ATTRID_SE_METERING_CURR_TIER1_BLOCK14_SUMM_RCVD   0x091D
#define ATTRID_SE_METERING_CURR_TIER1_BLOCK15_SUMM_RCVD   0x091E
#define ATTRID_SE_METERING_CURR_TIER1_BLOCK16_SUMM_RCVD   0x091F
// Tier 2
#define ATTRID_SE_METERING_CURR_TIER2_BLOCK1_SUMM_RCVD    0x0920
#define ATTRID_SE_METERING_CURR_TIER2_BLOCK2_SUMM_RCVD    0x0921
#define ATTRID_SE_METERING_CURR_TIER2_BLOCK3_SUMM_RCVD    0x0922
#define ATTRID_SE_METERING_CURR_TIER2_BLOCK4_SUMM_RCVD    0x0923
#define ATTRID_SE_METERING_CURR_TIER2_BLOCK5_SUMM_RCVD    0x0924
#define ATTRID_SE_METERING_CURR_TIER2_BLOCK6_SUMM_RCVD    0x0925
#define ATTRID_SE_METERING_CURR_TIER2_BLOCK7_SUMM_RCVD    0x0926
#define ATTRID_SE_METERING_CURR_TIER2_BLOCK8_SUMM_RCVD    0x0927
#define ATTRID_SE_METERING_CURR_TIER2_BLOCK9_SUMM_RCVD    0x0928
#define ATTRID_SE_METERING_CURR_TIER2_BLOCK10_SUMM_RCVD   0x0929
#define ATTRID_SE_METERING_CURR_TIER2_BLOCK11_SUMM_RCVD   0x092A
#define ATTRID_SE_METERING_CURR_TIER2_BLOCK12_SUMM_RCVD   0x092B
#define ATTRID_SE_METERING_CURR_TIER2_BLOCK13_SUMM_RCVD   0x092C
#define ATTRID_SE_METERING_CURR_TIER2_BLOCK14_SUMM_RCVD   0x092D
#define ATTRID_SE_METERING_CURR_TIER2_BLOCK15_SUMM_RCVD   0x092E
#define ATTRID_SE_METERING_CURR_TIER2_BLOCK16_SUMM_RCVD   0x092F
// Tier 3
#define ATTRID_SE_METERING_CURR_TIER3_BLOCK1_SUMM_RCVD    0x0930
#define ATTRID_SE_METERING_CURR_TIER3_BLOCK2_SUMM_RCVD    0x0931
#define ATTRID_SE_METERING_CURR_TIER3_BLOCK3_SUMM_RCVD    0x0932
#define ATTRID_SE_METERING_CURR_TIER3_BLOCK4_SUMM_RCVD    0x0933
#define ATTRID_SE_METERING_CURR_TIER3_BLOCK5_SUMM_RCVD    0x0934
#define ATTRID_SE_METERING_CURR_TIER3_BLOCK6_SUMM_RCVD    0x0935
#define ATTRID_SE_METERING_CURR_TIER3_BLOCK7_SUMM_RCVD    0x0936
#define ATTRID_SE_METERING_CURR_TIER3_BLOCK8_SUMM_RCVD    0x0937
#define ATTRID_SE_METERING_CURR_TIER3_BLOCK9_SUMM_RCVD    0x0938
#define ATTRID_SE_METERING_CURR_TIER3_BLOCK10_SUMM_RCVD   0x0939
#define ATTRID_SE_METERING_CURR_TIER3_BLOCK11_SUMM_RCVD   0x093A
#define ATTRID_SE_METERING_CURR_TIER3_BLOCK12_SUMM_RCVD   0x093B
#define ATTRID_SE_METERING_CURR_TIER3_BLOCK13_SUMM_RCVD   0x093C
#define ATTRID_SE_METERING_CURR_TIER3_BLOCK14_SUMM_RCVD   0x093D
#define ATTRID_SE_METERING_CURR_TIER3_BLOCK15_SUMM_RCVD   0x093E
#define ATTRID_SE_METERING_CURR_TIER3_BLOCK16_SUMM_RCVD   0x093F
// Tier 4
#define ATTRID_SE_METERING_CURR_TIER4_BLOCK1_SUMM_RCVD    0x0940
#define ATTRID_SE_METERING_CURR_TIER4_BLOCK2_SUMM_RCVD    0x0941
#define ATTRID_SE_METERING_CURR_TIER4_BLOCK3_SUMM_RCVD    0x0942
#define ATTRID_SE_METERING_CURR_TIER4_BLOCK4_SUMM_RCVD    0x0943
#define ATTRID_SE_METERING_CURR_TIER4_BLOCK5_SUMM_RCVD    0x0944
#define ATTRID_SE_METERING_CURR_TIER4_BLOCK6_SUMM_RCVD    0x0945
#define ATTRID_SE_METERING_CURR_TIER4_BLOCK7_SUMM_RCVD    0x0946
#define ATTRID_SE_METERING_CURR_TIER4_BLOCK8_SUMM_RCVD    0x0947
#define ATTRID_SE_METERING_CURR_TIER4_BLOCK9_SUMM_RCVD    0x0948
#define ATTRID_SE_METERING_CURR_TIER4_BLOCK10_SUMM_RCVD   0x0949
#define ATTRID_SE_METERING_CURR_TIER4_BLOCK11_SUMM_RCVD   0x094A
#define ATTRID_SE_METERING_CURR_TIER4_BLOCK12_SUMM_RCVD   0x094B
#define ATTRID_SE_METERING_CURR_TIER4_BLOCK13_SUMM_RCVD   0x094C
#define ATTRID_SE_METERING_CURR_TIER4_BLOCK14_SUMM_RCVD   0x094D
#define ATTRID_SE_METERING_CURR_TIER4_BLOCK15_SUMM_RCVD   0x094E
#define ATTRID_SE_METERING_CURR_TIER4_BLOCK16_SUMM_RCVD   0x094F
// Tier 5
#define ATTRID_SE_METERING_CURR_TIER5_BLOCK1_SUMM_RCVD    0x0950
#define ATTRID_SE_METERING_CURR_TIER5_BLOCK2_SUMM_RCVD    0x0951
#define ATTRID_SE_METERING_CURR_TIER5_BLOCK3_SUMM_RCVD    0x0952
#define ATTRID_SE_METERING_CURR_TIER5_BLOCK4_SUMM_RCVD    0x0953
#define ATTRID_SE_METERING_CURR_TIER5_BLOCK5_SUMM_RCVD    0x0954
#define ATTRID_SE_METERING_CURR_TIER5_BLOCK6_SUMM_RCVD    0x0955
#define ATTRID_SE_METERING_CURR_TIER5_BLOCK7_SUMM_RCVD    0x0956
#define ATTRID_SE_METERING_CURR_TIER5_BLOCK8_SUMM_RCVD    0x0957
#define ATTRID_SE_METERING_CURR_TIER5_BLOCK9_SUMM_RCVD    0x0958
#define ATTRID_SE_METERING_CURR_TIER5_BLOCK10_SUMM_RCVD   0x0959
#define ATTRID_SE_METERING_CURR_TIER5_BLOCK11_SUMM_RCVD   0x095A
#define ATTRID_SE_METERING_CURR_TIER5_BLOCK12_SUMM_RCVD   0x095B
#define ATTRID_SE_METERING_CURR_TIER5_BLOCK13_SUMM_RCVD   0x095C
#define ATTRID_SE_METERING_CURR_TIER5_BLOCK14_SUMM_RCVD   0x095D
#define ATTRID_SE_METERING_CURR_TIER5_BLOCK15_SUMM_RCVD   0x095E
#define ATTRID_SE_METERING_CURR_TIER5_BLOCK16_SUMM_RCVD   0x095F
// Tier 6
#define ATTRID_SE_METERING_CURR_TIER6_BLOCK1_SUMM_RCVD    0x0960
#define ATTRID_SE_METERING_CURR_TIER6_BLOCK2_SUMM_RCVD    0x0961
#define ATTRID_SE_METERING_CURR_TIER6_BLOCK3_SUMM_RCVD    0x0962
#define ATTRID_SE_METERING_CURR_TIER6_BLOCK4_SUMM_RCVD    0x0963
#define ATTRID_SE_METERING_CURR_TIER6_BLOCK5_SUMM_RCVD    0x0964
#define ATTRID_SE_METERING_CURR_TIER6_BLOCK6_SUMM_RCVD    0x0965
#define ATTRID_SE_METERING_CURR_TIER6_BLOCK7_SUMM_RCVD    0x0966
#define ATTRID_SE_METERING_CURR_TIER6_BLOCK8_SUMM_RCVD    0x0967
#define ATTRID_SE_METERING_CURR_TIER6_BLOCK9_SUMM_RCVD    0x0968
#define ATTRID_SE_METERING_CURR_TIER6_BLOCK10_SUMM_RCVD   0x0969
#define ATTRID_SE_METERING_CURR_TIER6_BLOCK11_SUMM_RCVD   0x096A
#define ATTRID_SE_METERING_CURR_TIER6_BLOCK12_SUMM_RCVD   0x096B
#define ATTRID_SE_METERING_CURR_TIER6_BLOCK13_SUMM_RCVD   0x096C
#define ATTRID_SE_METERING_CURR_TIER6_BLOCK14_SUMM_RCVD   0x096D
#define ATTRID_SE_METERING_CURR_TIER6_BLOCK15_SUMM_RCVD   0x096E
#define ATTRID_SE_METERING_CURR_TIER6_BLOCK16_SUMM_RCVD   0x096F
// Tier 7
#define ATTRID_SE_METERING_CURR_TIER7_BLOCK1_SUMM_RCVD    0x0970
#define ATTRID_SE_METERING_CURR_TIER7_BLOCK2_SUMM_RCVD    0x0971
#define ATTRID_SE_METERING_CURR_TIER7_BLOCK3_SUMM_RCVD    0x0972
#define ATTRID_SE_METERING_CURR_TIER7_BLOCK4_SUMM_RCVD    0x0973
#define ATTRID_SE_METERING_CURR_TIER7_BLOCK5_SUMM_RCVD    0x0974
#define ATTRID_SE_METERING_CURR_TIER7_BLOCK6_SUMM_RCVD    0x0975
#define ATTRID_SE_METERING_CURR_TIER7_BLOCK7_SUMM_RCVD    0x0976
#define ATTRID_SE_METERING_CURR_TIER7_BLOCK8_SUMM_RCVD    0x0977
#define ATTRID_SE_METERING_CURR_TIER7_BLOCK9_SUMM_RCVD    0x0978
#define ATTRID_SE_METERING_CURR_TIER7_BLOCK10_SUMM_RCVD   0x0979
#define ATTRID_SE_METERING_CURR_TIER7_BLOCK11_SUMM_RCVD   0x097A
#define ATTRID_SE_METERING_CURR_TIER7_BLOCK12_SUMM_RCVD   0x097B
#define ATTRID_SE_METERING_CURR_TIER7_BLOCK13_SUMM_RCVD   0x097C
#define ATTRID_SE_METERING_CURR_TIER7_BLOCK14_SUMM_RCVD   0x097D
#define ATTRID_SE_METERING_CURR_TIER7_BLOCK15_SUMM_RCVD   0x097E
#define ATTRID_SE_METERING_CURR_TIER7_BLOCK16_SUMM_RCVD   0x097F
// Tier 8
#define ATTRID_SE_METERING_CURR_TIER8_BLOCK1_SUMM_RCVD    0x0980
#define ATTRID_SE_METERING_CURR_TIER8_BLOCK2_SUMM_RCVD    0x0981
#define ATTRID_SE_METERING_CURR_TIER8_BLOCK3_SUMM_RCVD    0x0982
#define ATTRID_SE_METERING_CURR_TIER8_BLOCK4_SUMM_RCVD    0x0983
#define ATTRID_SE_METERING_CURR_TIER8_BLOCK5_SUMM_RCVD    0x0984
#define ATTRID_SE_METERING_CURR_TIER8_BLOCK6_SUMM_RCVD    0x0985
#define ATTRID_SE_METERING_CURR_TIER8_BLOCK7_SUMM_RCVD    0x0986
#define ATTRID_SE_METERING_CURR_TIER8_BLOCK8_SUMM_RCVD    0x0987
#define ATTRID_SE_METERING_CURR_TIER8_BLOCK9_SUMM_RCVD    0x0988
#define ATTRID_SE_METERING_CURR_TIER8_BLOCK10_SUMM_RCVD   0x0989
#define ATTRID_SE_METERING_CURR_TIER8_BLOCK11_SUMM_RCVD   0x098A
#define ATTRID_SE_METERING_CURR_TIER8_BLOCK12_SUMM_RCVD   0x098B
#define ATTRID_SE_METERING_CURR_TIER8_BLOCK13_SUMM_RCVD   0x098C
#define ATTRID_SE_METERING_CURR_TIER8_BLOCK14_SUMM_RCVD   0x098D
#define ATTRID_SE_METERING_CURR_TIER8_BLOCK15_SUMM_RCVD   0x098E
#define ATTRID_SE_METERING_CURR_TIER8_BLOCK16_SUMM_RCVD   0x098F
// Tier 9
#define ATTRID_SE_METERING_CURR_TIER9_BLOCK1_SUMM_RCVD    0x0990
#define ATTRID_SE_METERING_CURR_TIER9_BLOCK2_SUMM_RCVD    0x0991
#define ATTRID_SE_METERING_CURR_TIER9_BLOCK3_SUMM_RCVD    0x0992
#define ATTRID_SE_METERING_CURR_TIER9_BLOCK4_SUMM_RCVD    0x0993
#define ATTRID_SE_METERING_CURR_TIER9_BLOCK5_SUMM_RCVD    0x0994
#define ATTRID_SE_METERING_CURR_TIER9_BLOCK6_SUMM_RCVD    0x0995
#define ATTRID_SE_METERING_CURR_TIER9_BLOCK7_SUMM_RCVD    0x0996
#define ATTRID_SE_METERING_CURR_TIER9_BLOCK8_SUMM_RCVD    0x0997
#define ATTRID_SE_METERING_CURR_TIER9_BLOCK9_SUMM_RCVD    0x0998
#define ATTRID_SE_METERING_CURR_TIER9_BLOCK10_SUMM_RCVD   0x0999
#define ATTRID_SE_METERING_CURR_TIER9_BLOCK11_SUMM_RCVD   0x099A
#define ATTRID_SE_METERING_CURR_TIER9_BLOCK12_SUMM_RCVD   0x099B
#define ATTRID_SE_METERING_CURR_TIER9_BLOCK13_SUMM_RCVD   0x099C
#define ATTRID_SE_METERING_CURR_TIER9_BLOCK14_SUMM_RCVD   0x099D
#define ATTRID_SE_METERING_CURR_TIER9_BLOCK15_SUMM_RCVD   0x099E
#define ATTRID_SE_METERING_CURR_TIER9_BLOCK16_SUMM_RCVD   0x099F
// Tier 10
#define ATTRID_SE_METERING_CURR_TIER10_BLOCK1_SUMM_RCVD   0x09A0
#define ATTRID_SE_METERING_CURR_TIER10_BLOCK2_SUMM_RCVD   0x09A1
#define ATTRID_SE_METERING_CURR_TIER10_BLOCK3_SUMM_RCVD   0x09A2
#define ATTRID_SE_METERING_CURR_TIER10_BLOCK4_SUMM_RCVD   0x09A3
#define ATTRID_SE_METERING_CURR_TIER10_BLOCK5_SUMM_RCVD   0x09A4
#define ATTRID_SE_METERING_CURR_TIER10_BLOCK6_SUMM_RCVD   0x09A5
#define ATTRID_SE_METERING_CURR_TIER10_BLOCK7_SUMM_RCVD   0x09A6
#define ATTRID_SE_METERING_CURR_TIER10_BLOCK8_SUMM_RCVD   0x09A7
#define ATTRID_SE_METERING_CURR_TIER10_BLOCK9_SUMM_RCVD   0x09A8
#define ATTRID_SE_METERING_CURR_TIER10_BLOCK10_SUMM_RCVD  0x09A9
#define ATTRID_SE_METERING_CURR_TIER10_BLOCK11_SUMM_RCVD  0x09AA
#define ATTRID_SE_METERING_CURR_TIER10_BLOCK12_SUMM_RCVD  0x09AB
#define ATTRID_SE_METERING_CURR_TIER10_BLOCK13_SUMM_RCVD  0x09AC
#define ATTRID_SE_METERING_CURR_TIER10_BLOCK14_SUMM_RCVD  0x09AD
#define ATTRID_SE_METERING_CURR_TIER10_BLOCK15_SUMM_RCVD  0x09AE
#define ATTRID_SE_METERING_CURR_TIER10_BLOCK16_SUMM_RCVD  0x09AF
// Tier 11
#define ATTRID_SE_METERING_CURR_TIER11_BLOCK1_SUMM_RCVD   0x09B0
#define ATTRID_SE_METERING_CURR_TIER11_BLOCK2_SUMM_RCVD   0x09B1
#define ATTRID_SE_METERING_CURR_TIER11_BLOCK3_SUMM_RCVD   0x09B2
#define ATTRID_SE_METERING_CURR_TIER11_BLOCK4_SUMM_RCVD   0x09B3
#define ATTRID_SE_METERING_CURR_TIER11_BLOCK5_SUMM_RCVD   0x09B4
#define ATTRID_SE_METERING_CURR_TIER11_BLOCK6_SUMM_RCVD   0x09B5
#define ATTRID_SE_METERING_CURR_TIER11_BLOCK7_SUMM_RCVD   0x09B6
#define ATTRID_SE_METERING_CURR_TIER11_BLOCK8_SUMM_RCVD   0x09B7
#define ATTRID_SE_METERING_CURR_TIER11_BLOCK9_SUMM_RCVD   0x09B8
#define ATTRID_SE_METERING_CURR_TIER11_BLOCK10_SUMM_RCVD  0x09B9
#define ATTRID_SE_METERING_CURR_TIER11_BLOCK11_SUMM_RCVD  0x09BA
#define ATTRID_SE_METERING_CURR_TIER11_BLOCK12_SUMM_RCVD  0x09BB
#define ATTRID_SE_METERING_CURR_TIER11_BLOCK13_SUMM_RCVD  0x09BC
#define ATTRID_SE_METERING_CURR_TIER11_BLOCK14_SUMM_RCVD  0x09BD
#define ATTRID_SE_METERING_CURR_TIER11_BLOCK15_SUMM_RCVD  0x09BE
#define ATTRID_SE_METERING_CURR_TIER11_BLOCK16_SUMM_RCVD  0x09BF
// Tier 12
#define ATTRID_SE_METERING_CURR_TIER12_BLOCK1_SUMM_RCVD   0x09C0
#define ATTRID_SE_METERING_CURR_TIER12_BLOCK2_SUMM_RCVD   0x09C1
#define ATTRID_SE_METERING_CURR_TIER12_BLOCK3_SUMM_RCVD   0x09C2
#define ATTRID_SE_METERING_CURR_TIER12_BLOCK4_SUMM_RCVD   0x09C3
#define ATTRID_SE_METERING_CURR_TIER12_BLOCK5_SUMM_RCVD   0x09C4
#define ATTRID_SE_METERING_CURR_TIER12_BLOCK6_SUMM_RCVD   0x09C5
#define ATTRID_SE_METERING_CURR_TIER12_BLOCK7_SUMM_RCVD   0x09C6
#define ATTRID_SE_METERING_CURR_TIER12_BLOCK8_SUMM_RCVD   0x09C7
#define ATTRID_SE_METERING_CURR_TIER12_BLOCK9_SUMM_RCVD   0x09C8
#define ATTRID_SE_METERING_CURR_TIER12_BLOCK10_SUMM_RCVD  0x09C9
#define ATTRID_SE_METERING_CURR_TIER12_BLOCK11_SUMM_RCVD  0x09CA
#define ATTRID_SE_METERING_CURR_TIER12_BLOCK12_SUMM_RCVD  0x09CB
#define ATTRID_SE_METERING_CURR_TIER12_BLOCK13_SUMM_RCVD  0x09CC
#define ATTRID_SE_METERING_CURR_TIER12_BLOCK14_SUMM_RCVD  0x09CD
#define ATTRID_SE_METERING_CURR_TIER12_BLOCK15_SUMM_RCVD  0x09CE
#define ATTRID_SE_METERING_CURR_TIER12_BLOCK16_SUMM_RCVD  0x09CF
// Tier 13
#define ATTRID_SE_METERING_CURR_TIER13_BLOCK1_SUMM_RCVD   0x09D0
#define ATTRID_SE_METERING_CURR_TIER13_BLOCK2_SUMM_RCVD   0x09D1
#define ATTRID_SE_METERING_CURR_TIER13_BLOCK3_SUMM_RCVD   0x09D2
#define ATTRID_SE_METERING_CURR_TIER13_BLOCK4_SUMM_RCVD   0x09D3
#define ATTRID_SE_METERING_CURR_TIER13_BLOCK5_SUMM_RCVD   0x09D4
#define ATTRID_SE_METERING_CURR_TIER13_BLOCK6_SUMM_RCVD   0x09D5
#define ATTRID_SE_METERING_CURR_TIER13_BLOCK7_SUMM_RCVD   0x09D6
#define ATTRID_SE_METERING_CURR_TIER13_BLOCK8_SUMM_RCVD   0x09D7
#define ATTRID_SE_METERING_CURR_TIER13_BLOCK9_SUMM_RCVD   0x09D8
#define ATTRID_SE_METERING_CURR_TIER13_BLOCK10_SUMM_RCVD  0x09D9
#define ATTRID_SE_METERING_CURR_TIER13_BLOCK11_SUMM_RCVD  0x09DA
#define ATTRID_SE_METERING_CURR_TIER13_BLOCK12_SUMM_RCVD  0x09DB
#define ATTRID_SE_METERING_CURR_TIER13_BLOCK13_SUMM_RCVD  0x09DC
#define ATTRID_SE_METERING_CURR_TIER13_BLOCK14_SUMM_RCVD  0x09DD
#define ATTRID_SE_METERING_CURR_TIER13_BLOCK15_SUMM_RCVD  0x09DE
#define ATTRID_SE_METERING_CURR_TIER13_BLOCK16_SUMM_RCVD  0x09DF
// Tier 14
#define ATTRID_SE_METERING_CURR_TIER14_BLOCK1_SUMM_RCVD   0x09E0
#define ATTRID_SE_METERING_CURR_TIER14_BLOCK2_SUMM_RCVD   0x09E1
#define ATTRID_SE_METERING_CURR_TIER14_BLOCK3_SUMM_RCVD   0x09E2
#define ATTRID_SE_METERING_CURR_TIER14_BLOCK4_SUMM_RCVD   0x09E3
#define ATTRID_SE_METERING_CURR_TIER14_BLOCK5_SUMM_RCVD   0x09E4
#define ATTRID_SE_METERING_CURR_TIER14_BLOCK6_SUMM_RCVD   0x09E5
#define ATTRID_SE_METERING_CURR_TIER14_BLOCK7_SUMM_RCVD   0x09E6
#define ATTRID_SE_METERING_CURR_TIER14_BLOCK8_SUMM_RCVD   0x09E7
#define ATTRID_SE_METERING_CURR_TIER14_BLOCK9_SUMM_RCVD   0x09E8
#define ATTRID_SE_METERING_CURR_TIER14_BLOCK10_SUMM_RCVD  0x09E9
#define ATTRID_SE_METERING_CURR_TIER14_BLOCK11_SUMM_RCVD  0x09EA
#define ATTRID_SE_METERING_CURR_TIER14_BLOCK12_SUMM_RCVD  0x09EB
#define ATTRID_SE_METERING_CURR_TIER14_BLOCK13_SUMM_RCVD  0x09EC
#define ATTRID_SE_METERING_CURR_TIER14_BLOCK14_SUMM_RCVD  0x09ED
#define ATTRID_SE_METERING_CURR_TIER14_BLOCK15_SUMM_RCVD  0x09EE
#define ATTRID_SE_METERING_CURR_TIER14_BLOCK16_SUMM_RCVD  0x09EF
// Tier 15
#define ATTRID_SE_METERING_CURR_TIER15_BLOCK1_SUMM_RCVD   0x09F0
#define ATTRID_SE_METERING_CURR_TIER15_BLOCK2_SUMM_RCVD   0x09F1
#define ATTRID_SE_METERING_CURR_TIER15_BLOCK3_SUMM_RCVD   0x09F2
#define ATTRID_SE_METERING_CURR_TIER15_BLOCK4_SUMM_RCVD   0x09F3
#define ATTRID_SE_METERING_CURR_TIER15_BLOCK5_SUMM_RCVD   0x09F4
#define ATTRID_SE_METERING_CURR_TIER15_BLOCK6_SUMM_RCVD   0x09F5
#define ATTRID_SE_METERING_CURR_TIER15_BLOCK7_SUMM_RCVD   0x09F6
#define ATTRID_SE_METERING_CURR_TIER15_BLOCK8_SUMM_RCVD   0x09F7
#define ATTRID_SE_METERING_CURR_TIER15_BLOCK9_SUMM_RCVD   0x09F8
#define ATTRID_SE_METERING_CURR_TIER15_BLOCK10_SUMM_RCVD  0x09F9
#define ATTRID_SE_METERING_CURR_TIER15_BLOCK11_SUMM_RCVD  0x09FA
#define ATTRID_SE_METERING_CURR_TIER15_BLOCK12_SUMM_RCVD  0x09FB
#define ATTRID_SE_METERING_CURR_TIER15_BLOCK13_SUMM_RCVD  0x09FC
#define ATTRID_SE_METERING_CURR_TIER15_BLOCK14_SUMM_RCVD  0x09FD
#define ATTRID_SE_METERING_CURR_TIER15_BLOCK15_SUMM_RCVD  0x09FE
#define ATTRID_SE_METERING_CURR_TIER15_BLOCK16_SUMM_RCVD  0x09FF

//==== Meter Billing Attribute Set ====
#define ATTRID_SE_METERING_BILL_TO_DATE_DLVD            0x0A00
#define ATTRID_SE_METERING_BILL_TO_DATE_TIME_STAMP_DLVD 0x0A01
#define ATTRID_SE_METERING_PROJ_BILL_DLVD               0x0A02
#define ATTRID_SE_METERING_PROJ_BILL_TIME_STAMP_DLVD    0x0A03
#define ATTRID_SE_METERING_BILL_DLVD_TRAILING_DIGIT     0x0A04
#define ATTRID_SE_METERING_BILL_TO_DATE_RCVD            0x0A10
#define ATTRID_SE_METERING_BILL_TO_DATE_TIME_STAMP_RCVD 0x0A11
#define ATTRID_SE_METERING_PROJ_BILL_RCVD               0x0A12
#define ATTRID_SE_METERING_PROJ_BILL_TIME_STAMP_RCVD    0x0A13
#define ATTRID_SE_METERING_BILL_RCVD_TRAILING_DIGIT     0x0A14

//==== Supply Control Attribute Set ====
#define ATTRID_SE_METERING_PROP_CHANGE_SUPPLY_IMPL_TIME 0x0B00
#define ATTRID_SE_METERING_PROP_CHANGE_SUPPLY_STATUS    0x0B01
          // see ZCL_SE_METERING_SUPPLY_STATUS
#define ATTRID_SE_METERING_UNCTRLD_FLOW_THRESHOLD       0x0B10
#define ATTRID_SE_METERING_UNCTRLD_FLOW_THRESHOLD_UOM   0x0B11
#define ATTRID_SE_METERING_UNCTRLD_FLOW_MULT            0x0B12
#define ATTRID_SE_METERING_UNCTRLD_FLOW_DIV             0x0B13
#define ATTRID_SE_METERING_FLOW_STABILISATION_PERIOD    0x0B14
#define ATTRID_SE_METERING_FLOW_MEASUREMENT_PERIOD      0x0B15

//==== Alternative Historical Consumption Attribute Set ====
#define ATTRID_SE_METERING_ALT_INST_DMD                  0x0C00
#define ATTRID_SE_METERING_CURR_DAY_ALT_CONSUMP_DLVD     0x0C01
#define ATTRID_SE_METERING_CURR_DAY_ALT_CONSUMP_RCVD     0x0C02
#define ATTRID_SE_METERING_PREV_DAY_ALT_CONSUMP_DLVD     0x0C03
#define ATTRID_SE_METERING_PREV_DAY_ALT_CONSUMP_RCVD     0x0C04
#define ATTRID_SE_METERING_CURR_ALT_PPI_START_TIME_DLVD  0x0C05
#define ATTRID_SE_METERING_CURR_ALT_PPI_START_TIME_RCVD  0x0C06
#define ATTRID_SE_METERING_CURR_ALT_PPI_VALUE_DLVD       0x0C07
#define ATTRID_SE_METERING_CURR_ALT_PPI_VALUE_RCVD       0x0C08
#define ATTRID_SE_METERING_CURR_DAY_ALT_MAX_PRESSURE     0x0C09
#define ATTRID_SE_METERING_CURR_DAY_ALT_MIN_PRESSURE     0x0C0A
#define ATTRID_SE_METERING_PREV_DAY_ALT_MAX_PRESSURE     0x0C0B
#define ATTRID_SE_METERING_PREV_DAY_ALT_MIN_PRESSURE     0x0C0C
#define ATTRID_SE_METERING_CURR_DAY_ALT_MAX_DEMAND       0x0C0D
#define ATTRID_SE_METERING_PREV_DAY_ALT_MAX_DEMAND       0x0C0E
#define ATTRID_SE_METERING_CURR_MONTH_ALT_MAX_DEMAND     0x0C0F
#define ATTRID_SE_METERING_CURR_YEAR_ALT_MAX_DEMAND      0x0C10

#define ATTRID_SE_METERING_PREV_DAY2_ALT_CONSUMP_DLVD    0x0C20
#define ATTRID_SE_METERING_PREV_DAY2_ALT_CONSUMP_RCVD    0x0C21
#define ATTRID_SE_METERING_PREV_DAY3_ALT_CONSUMP_DLVD    0x0C22
#define ATTRID_SE_METERING_PREV_DAY3_ALT_CONSUMP_RCVD    0x0C23
#define ATTRID_SE_METERING_PREV_DAY4_ALT_CONSUMP_DLVD    0x0C24
#define ATTRID_SE_METERING_PREV_DAY4_ALT_CONSUMP_RCVD    0x0C25
#define ATTRID_SE_METERING_PREV_DAY5_ALT_CONSUMP_DLVD    0x0C26
#define ATTRID_SE_METERING_PREV_DAY5_ALT_CONSUMP_RCVD    0x0C27
#define ATTRID_SE_METERING_PREV_DAY6_ALT_CONSUMP_DLVD    0x0C28
#define ATTRID_SE_METERING_PREV_DAY6_ALT_CONSUMP_RCVD    0x0C29
#define ATTRID_SE_METERING_PREV_DAY7_ALT_CONSUMP_DLVD    0x0C2A
#define ATTRID_SE_METERING_PREV_DAY7_ALT_CONSUMP_RCVD    0x0C2B
#define ATTRID_SE_METERING_PREV_DAY8_ALT_CONSUMP_DLVD    0x0C2C
#define ATTRID_SE_METERING_PREV_DAY9_ALT_CONSUMP_RCVD    0x0C2D

#define ATTRID_SE_METERING_CURR_WEEK_ALT_CONSUMP_DLVD    0x0C30
#define ATTRID_SE_METERING_CURR_WEEK_ALT_CONSUMP_RCVD    0x0C31
#define ATTRID_SE_METERING_PREV_WEEK_ALT_CONSUMP_DLVD    0x0C32
#define ATTRID_SE_METERING_PREV_WEEK_ALT_CONSUMP_RCVD    0x0C33
#define ATTRID_SE_METERING_PREV_WEEK2_ALT_CONSUMP_DLVD   0x0C34
#define ATTRID_SE_METERING_PREV_WEEK2_ALT_CONSUMP_RCVD   0x0C35
#define ATTRID_SE_METERING_PREV_WEEK3_ALT_CONSUMP_DLVD   0x0C36
#define ATTRID_SE_METERING_PREV_WEEK3_ALT_CONSUMP_RCVD   0x0C37
#define ATTRID_SE_METERING_PREV_WEEK4_ALT_CONSUMP_DLVD   0x0C38
#define ATTRID_SE_METERING_PREV_WEEK4_ALT_CONSUMP_RCVD   0x0C39
#define ATTRID_SE_METERING_PREV_WEEK5_ALT_CONSUMP_DLVD   0x0C3A
#define ATTRID_SE_METERING_PREV_WEEK5_ALT_CONSUMP_RCVD   0x0C3B

#define ATTRID_SE_METERING_CURR_MONTH_ALT_CONSUMP_DLVD   0x0C40
#define ATTRID_SE_METERING_CURR_MONTH_ALT_CONSUMP_RCVD   0x0C41
#define ATTRID_SE_METERING_PREV_MONTH_ALT_CONSUMP_DLVD   0x0C42
#define ATTRID_SE_METERING_PREV_MONTH_ALT_CONSUMP_RCVD   0x0C43
#define ATTRID_SE_METERING_PREV_MONTH2_ALT_CONSUMP_DLVD  0x0C44
#define ATTRID_SE_METERING_PREV_MONTH2_ALT_CONSUMP_RCVD  0x0C45
#define ATTRID_SE_METERING_PREV_MONTH3_ALT_CONSUMP_DLVD  0x0C46
#define ATTRID_SE_METERING_PREV_MONTH3_ALT_CONSUMP_RCVD  0x0C47
#define ATTRID_SE_METERING_PREV_MONTH4_ALT_CONSUMP_DLVD  0x0C48
#define ATTRID_SE_METERING_PREV_MONTH4_ALT_CONSUMP_RCVD  0x0C49
#define ATTRID_SE_METERING_PREV_MONTH5_ALT_CONSUMP_DLVD  0x0C4A
#define ATTRID_SE_METERING_PREV_MONTH5_ALT_CONSUMP_RCVD  0x0C4B
#define ATTRID_SE_METERING_PREV_MONTH6_ALT_CONSUMP_DLVD  0x0C4C
#define ATTRID_SE_METERING_PREV_MONTH6_ALT_CONSUMP_RCVD  0x0C4D
#define ATTRID_SE_METERING_PREV_MONTH7_ALT_CONSUMP_DLVD  0x0C4E
#define ATTRID_SE_METERING_PREV_MONTH7_ALT_CONSUMP_RCVD  0x0C4F
#define ATTRID_SE_METERING_PREV_MONTH8_ALT_CONSUMP_DLVD  0x0C50
#define ATTRID_SE_METERING_PREV_MONTH8_ALT_CONSUMP_RCVD  0x0C51
#define ATTRID_SE_METERING_PREV_MONTH9_ALT_CONSUMP_DLVD  0x0C52
#define ATTRID_SE_METERING_PREV_MONTH9_ALT_CONSUMP_RCVD  0x0C53
#define ATTRID_SE_METERING_PREV_MONTH10_ALT_CONSUMP_DLVD 0x0C54
#define ATTRID_SE_METERING_PREV_MONTH10_ALT_CONSUMP_RCVD 0x0C55
#define ATTRID_SE_METERING_PREV_MONTH11_ALT_CONSUMP_DLVD 0x0C56
#define ATTRID_SE_METERING_PREV_MONTH11_ALT_CONSUMP_RCVD 0x0C57
#define ATTRID_SE_METERING_PREV_MONTH12_ALT_CONSUMP_DLVD 0x0C58
#define ATTRID_SE_METERING_PREV_MONTH12_ALT_CONSUMP_RCVD 0x0C59
#define ATTRID_SE_METERING_PREV_MONTH13_ALT_CONSUMP_DLVD 0x0C5A
#define ATTRID_SE_METERING_PREV_MONTH13_ALT_CONSUMP_RCVD 0x0C5B

//==== Notification Attribute Set ====
#define ATTRID_SE_METERING_FUNC_NOTIF_FLAGS 0x0000
#define ATTRID_SE_METERING_NOTIF_FLAGS2     0x0001
#define ATTRID_SE_METERING_NOTIF_FLAGS3     0x0002
#define ATTRID_SE_METERING_NOTIF_FLAGS4     0x0003
#define ATTRID_SE_METERING_NOTIF_FLAGS5     0x0004
#define ATTRID_SE_METERING_NOTIF_FLAGS6     0x0005
#define ATTRID_SE_METERING_NOTIF_FLAGS7     0x0006
#define ATTRID_SE_METERING_NOTIF_FLAGS8     0x0007

//=================================================================================================
// Price Attributes(ZCL_CLUSTER_ID_SE_PRICE)
//=================================================================================================
//==== Tier Label (Delivered) Attribute Set ====
#define ATTRID_SE_PRICE_TIER1_LABEL  0x0000
#define ATTRID_SE_PRICE_TIER2_LABEL  0x0001
#define ATTRID_SE_PRICE_TIER3_LABEL  0x0002
#define ATTRID_SE_PRICE_TIER4_LABEL  0x0003
#define ATTRID_SE_PRICE_TIER5_LABEL  0x0004
#define ATTRID_SE_PRICE_TIER6_LABEL  0x0005
#define ATTRID_SE_PRICE_TIER7_LABEL  0x0006
#define ATTRID_SE_PRICE_TIER8_LABEL  0x0007
#define ATTRID_SE_PRICE_TIER9_LABEL  0x0008
#define ATTRID_SE_PRICE_TIER10_LABEL 0x0009
#define ATTRID_SE_PRICE_TIER11_LABEL 0x000A
#define ATTRID_SE_PRICE_TIER12_LABEL 0x000B
#define ATTRID_SE_PRICE_TIER13_LABEL 0x000C
#define ATTRID_SE_PRICE_TIER14_LABEL 0x000D
#define ATTRID_SE_PRICE_TIER15_LABEL 0x000E
#define ATTRID_SE_PRICE_TIER16_LABEL 0x000F
#define ATTRID_SE_PRICE_TIER17_LABEL 0x0010
#define ATTRID_SE_PRICE_TIER18_LABEL 0x0011
#define ATTRID_SE_PRICE_TIER19_LABEL 0x0012
#define ATTRID_SE_PRICE_TIER20_LABEL 0x0013
#define ATTRID_SE_PRICE_TIER21_LABEL 0x0014
#define ATTRID_SE_PRICE_TIER22_LABEL 0x0015
#define ATTRID_SE_PRICE_TIER23_LABEL 0x0016
#define ATTRID_SE_PRICE_TIER24_LABEL 0x0017
#define ATTRID_SE_PRICE_TIER25_LABEL 0x0018
#define ATTRID_SE_PRICE_TIER26_LABEL 0x0019
#define ATTRID_SE_PRICE_TIER27_LABEL 0x001A
#define ATTRID_SE_PRICE_TIER28_LABEL 0x001B
#define ATTRID_SE_PRICE_TIER29_LABEL 0x001C
#define ATTRID_SE_PRICE_TIER30_LABEL 0x001D
#define ATTRID_SE_PRICE_TIER31_LABEL 0x001E
#define ATTRID_SE_PRICE_TIER32_LABEL 0x001F
#define ATTRID_SE_PRICE_TIER33_LABEL 0x0020
#define ATTRID_SE_PRICE_TIER34_LABEL 0x0021
#define ATTRID_SE_PRICE_TIER35_LABEL 0x0022
#define ATTRID_SE_PRICE_TIER36_LABEL 0x0023
#define ATTRID_SE_PRICE_TIER37_LABEL 0x0024
#define ATTRID_SE_PRICE_TIER38_LABEL 0x0025
#define ATTRID_SE_PRICE_TIER39_LABEL 0x0026
#define ATTRID_SE_PRICE_TIER40_LABEL 0x0027
#define ATTRID_SE_PRICE_TIER41_LABEL 0x0028
#define ATTRID_SE_PRICE_TIER42_LABEL 0x0029
#define ATTRID_SE_PRICE_TIER43_LABEL 0x002A
#define ATTRID_SE_PRICE_TIER44_LABEL 0x002B
#define ATTRID_SE_PRICE_TIER45_LABEL 0x002C
#define ATTRID_SE_PRICE_TIER46_LABEL 0x002D
#define ATTRID_SE_PRICE_TIER47_LABEL 0x002E
#define ATTRID_SE_PRICE_TIER48_LABEL 0x002F

//==== Block Threshold (Delivered) Attribute Set ====
#define ATTRID_SE_PRICE_BLOCK1_THRESHOLD           0x0100
#define ATTRID_SE_PRICE_BLOCK2_THRESHOLD           0x0101
#define ATTRID_SE_PRICE_BLOCK3_THRESHOLD           0x0102
#define ATTRID_SE_PRICE_BLOCK4_THRESHOLD           0x0103
#define ATTRID_SE_PRICE_BLOCK5_THRESHOLD           0x0104
#define ATTRID_SE_PRICE_BLOCK6_THRESHOLD           0x0105
#define ATTRID_SE_PRICE_BLOCK7_THRESHOLD           0x0106
#define ATTRID_SE_PRICE_BLOCK8_THRESHOLD           0x0107
#define ATTRID_SE_PRICE_BLOCK9_THRESHOLD           0x0108
#define ATTRID_SE_PRICE_BLOCK10_THRESHOLD          0x0109
#define ATTRID_SE_PRICE_BLOCK11_THRESHOLD          0x010A
#define ATTRID_SE_PRICE_BLOCK12_THRESHOLD          0x010B
#define ATTRID_SE_PRICE_BLOCK13_THRESHOLD          0x010C
#define ATTRID_SE_PRICE_BLOCK14_THRESHOLD          0x010D
#define ATTRID_SE_PRICE_BLOCK15_THRESHOLD          0x010E
#define ATTRID_SE_PRICE_BLOCK_THRESHOLD_CNT        0x010F
// Tier 1
#define ATTRID_SE_PRICE_TIER1_BLOCK1_THRESHOLD     0x0110
#define ATTRID_SE_PRICE_TIER1_BLOCK2_THRESHOLD     0x0111
#define ATTRID_SE_PRICE_TIER1_BLOCK3_THRESHOLD     0x0112
#define ATTRID_SE_PRICE_TIER1_BLOCK4_THRESHOLD     0x0113
#define ATTRID_SE_PRICE_TIER1_BLOCK5_THRESHOLD     0x0114
#define ATTRID_SE_PRICE_TIER1_BLOCK6_THRESHOLD     0x0115
#define ATTRID_SE_PRICE_TIER1_BLOCK7_THRESHOLD     0x0116
#define ATTRID_SE_PRICE_TIER1_BLOCK8_THRESHOLD     0x0117
#define ATTRID_SE_PRICE_TIER1_BLOCK9_THRESHOLD     0x0118
#define ATTRID_SE_PRICE_TIER1_BLOCK10_THRESHOLD    0x0119
#define ATTRID_SE_PRICE_TIER1_BLOCK11_THRESHOLD    0x011A
#define ATTRID_SE_PRICE_TIER1_BLOCK12_THRESHOLD    0x011B
#define ATTRID_SE_PRICE_TIER1_BLOCK13_THRESHOLD    0x011C
#define ATTRID_SE_PRICE_TIER1_BLOCK14_THRESHOLD    0x011D
#define ATTRID_SE_PRICE_TIER1_BLOCK15_THRESHOLD    0x011E
#define ATTRID_SE_PRICE_TIER1_BLOCK_THRESHOLD_CNT  0x011F
// Tier 2
#define ATTRID_SE_PRICE_TIER2_BLOCK1_THRESHOLD     0x0120
#define ATTRID_SE_PRICE_TIER2_BLOCK2_THRESHOLD     0x0121
#define ATTRID_SE_PRICE_TIER2_BLOCK3_THRESHOLD     0x0122
#define ATTRID_SE_PRICE_TIER2_BLOCK4_THRESHOLD     0x0123
#define ATTRID_SE_PRICE_TIER2_BLOCK5_THRESHOLD     0x0124
#define ATTRID_SE_PRICE_TIER2_BLOCK6_THRESHOLD     0x0125
#define ATTRID_SE_PRICE_TIER2_BLOCK7_THRESHOLD     0x0126
#define ATTRID_SE_PRICE_TIER2_BLOCK8_THRESHOLD     0x0127
#define ATTRID_SE_PRICE_TIER2_BLOCK9_THRESHOLD     0x0128
#define ATTRID_SE_PRICE_TIER2_BLOCK10_THRESHOLD    0x0129
#define ATTRID_SE_PRICE_TIER2_BLOCK11_THRESHOLD    0x012A
#define ATTRID_SE_PRICE_TIER2_BLOCK12_THRESHOLD    0x012B
#define ATTRID_SE_PRICE_TIER2_BLOCK13_THRESHOLD    0x012C
#define ATTRID_SE_PRICE_TIER2_BLOCK14_THRESHOLD    0x012D
#define ATTRID_SE_PRICE_TIER2_BLOCK15_THRESHOLD    0x012E
#define ATTRID_SE_PRICE_TIER2_BLOCK_THRESHOLD_CNT  0x012F
// Tier 3
#define ATTRID_SE_PRICE_TIER3_BLOCK1_THRESHOLD     0x0120
#define ATTRID_SE_PRICE_TIER3_BLOCK2_THRESHOLD     0x0121
#define ATTRID_SE_PRICE_TIER3_BLOCK3_THRESHOLD     0x0122
#define ATTRID_SE_PRICE_TIER3_BLOCK4_THRESHOLD     0x0123
#define ATTRID_SE_PRICE_TIER3_BLOCK5_THRESHOLD     0x0124
#define ATTRID_SE_PRICE_TIER3_BLOCK6_THRESHOLD     0x0125
#define ATTRID_SE_PRICE_TIER3_BLOCK7_THRESHOLD     0x0126
#define ATTRID_SE_PRICE_TIER3_BLOCK8_THRESHOLD     0x0127
#define ATTRID_SE_PRICE_TIER3_BLOCK9_THRESHOLD     0x0128
#define ATTRID_SE_PRICE_TIER3_BLOCK10_THRESHOLD    0x0129
#define ATTRID_SE_PRICE_TIER3_BLOCK11_THRESHOLD    0x012A
#define ATTRID_SE_PRICE_TIER3_BLOCK12_THRESHOLD    0x012B
#define ATTRID_SE_PRICE_TIER3_BLOCK13_THRESHOLD    0x012C
#define ATTRID_SE_PRICE_TIER3_BLOCK14_THRESHOLD    0x012D
#define ATTRID_SE_PRICE_TIER3_BLOCK15_THRESHOLD    0x012E
#define ATTRID_SE_PRICE_TIER3_BLOCK_THRESHOLD_CNT  0x013F
// Tier 4
#define ATTRID_SE_PRICE_TIER4_BLOCK1_THRESHOLD     0x0130
#define ATTRID_SE_PRICE_TIER4_BLOCK2_THRESHOLD     0x0131
#define ATTRID_SE_PRICE_TIER4_BLOCK3_THRESHOLD     0x0132
#define ATTRID_SE_PRICE_TIER4_BLOCK4_THRESHOLD     0x0133
#define ATTRID_SE_PRICE_TIER4_BLOCK5_THRESHOLD     0x0134
#define ATTRID_SE_PRICE_TIER4_BLOCK6_THRESHOLD     0x0135
#define ATTRID_SE_PRICE_TIER4_BLOCK7_THRESHOLD     0x0136
#define ATTRID_SE_PRICE_TIER4_BLOCK8_THRESHOLD     0x0137
#define ATTRID_SE_PRICE_TIER4_BLOCK9_THRESHOLD     0x0138
#define ATTRID_SE_PRICE_TIER4_BLOCK10_THRESHOLD    0x0139
#define ATTRID_SE_PRICE_TIER4_BLOCK11_THRESHOLD    0x013A
#define ATTRID_SE_PRICE_TIER4_BLOCK12_THRESHOLD    0x013B
#define ATTRID_SE_PRICE_TIER4_BLOCK13_THRESHOLD    0x013C
#define ATTRID_SE_PRICE_TIER4_BLOCK14_THRESHOLD    0x013D
#define ATTRID_SE_PRICE_TIER4_BLOCK15_THRESHOLD    0x013E
#define ATTRID_SE_PRICE_TIER4_BLOCK_THRESHOLD_CNT  0x014F
// Tier 5
#define ATTRID_SE_PRICE_TIER5_BLOCK1_THRESHOLD     0x0140
#define ATTRID_SE_PRICE_TIER5_BLOCK2_THRESHOLD     0x0141
#define ATTRID_SE_PRICE_TIER5_BLOCK3_THRESHOLD     0x0142
#define ATTRID_SE_PRICE_TIER5_BLOCK4_THRESHOLD     0x0143
#define ATTRID_SE_PRICE_TIER5_BLOCK5_THRESHOLD     0x0144
#define ATTRID_SE_PRICE_TIER5_BLOCK6_THRESHOLD     0x0145
#define ATTRID_SE_PRICE_TIER5_BLOCK7_THRESHOLD     0x0146
#define ATTRID_SE_PRICE_TIER5_BLOCK8_THRESHOLD     0x0147
#define ATTRID_SE_PRICE_TIER5_BLOCK9_THRESHOLD     0x0148
#define ATTRID_SE_PRICE_TIER5_BLOCK10_THRESHOLD    0x0149
#define ATTRID_SE_PRICE_TIER5_BLOCK11_THRESHOLD    0x014A
#define ATTRID_SE_PRICE_TIER5_BLOCK12_THRESHOLD    0x014B
#define ATTRID_SE_PRICE_TIER5_BLOCK13_THRESHOLD    0x014C
#define ATTRID_SE_PRICE_TIER5_BLOCK14_THRESHOLD    0x014D
#define ATTRID_SE_PRICE_TIER5_BLOCK15_THRESHOLD    0x014E
#define ATTRID_SE_PRICE_TIER5_BLOCK_THRESHOLD_CNT  0x015F
// Tier 6
#define ATTRID_SE_PRICE_TIER6_BLOCK1_THRESHOLD     0x0150
#define ATTRID_SE_PRICE_TIER6_BLOCK2_THRESHOLD     0x0151
#define ATTRID_SE_PRICE_TIER6_BLOCK3_THRESHOLD     0x0152
#define ATTRID_SE_PRICE_TIER6_BLOCK4_THRESHOLD     0x0153
#define ATTRID_SE_PRICE_TIER6_BLOCK5_THRESHOLD     0x0154
#define ATTRID_SE_PRICE_TIER6_BLOCK6_THRESHOLD     0x0155
#define ATTRID_SE_PRICE_TIER6_BLOCK7_THRESHOLD     0x0156
#define ATTRID_SE_PRICE_TIER6_BLOCK8_THRESHOLD     0x0157
#define ATTRID_SE_PRICE_TIER6_BLOCK9_THRESHOLD     0x0158
#define ATTRID_SE_PRICE_TIER6_BLOCK10_THRESHOLD    0x0159
#define ATTRID_SE_PRICE_TIER6_BLOCK11_THRESHOLD    0x015A
#define ATTRID_SE_PRICE_TIER6_BLOCK12_THRESHOLD    0x015B
#define ATTRID_SE_PRICE_TIER6_BLOCK13_THRESHOLD    0x015C
#define ATTRID_SE_PRICE_TIER6_BLOCK14_THRESHOLD    0x015D
#define ATTRID_SE_PRICE_TIER6_BLOCK15_THRESHOLD    0x015E
#define ATTRID_SE_PRICE_TIER6_BLOCK_THRESHOLD_CNT  0x016F
// Tier 7
#define ATTRID_SE_PRICE_TIER7_BLOCK1_THRESHOLD     0x0160
#define ATTRID_SE_PRICE_TIER7_BLOCK2_THRESHOLD     0x0161
#define ATTRID_SE_PRICE_TIER7_BLOCK3_THRESHOLD     0x0162
#define ATTRID_SE_PRICE_TIER7_BLOCK4_THRESHOLD     0x0163
#define ATTRID_SE_PRICE_TIER7_BLOCK5_THRESHOLD     0x0164
#define ATTRID_SE_PRICE_TIER7_BLOCK6_THRESHOLD     0x0165
#define ATTRID_SE_PRICE_TIER7_BLOCK7_THRESHOLD     0x0166
#define ATTRID_SE_PRICE_TIER7_BLOCK8_THRESHOLD     0x0167
#define ATTRID_SE_PRICE_TIER7_BLOCK9_THRESHOLD     0x0168
#define ATTRID_SE_PRICE_TIER7_BLOCK10_THRESHOLD    0x0169
#define ATTRID_SE_PRICE_TIER7_BLOCK11_THRESHOLD    0x016A
#define ATTRID_SE_PRICE_TIER7_BLOCK12_THRESHOLD    0x016B
#define ATTRID_SE_PRICE_TIER7_BLOCK13_THRESHOLD    0x016C
#define ATTRID_SE_PRICE_TIER7_BLOCK14_THRESHOLD    0x016D
#define ATTRID_SE_PRICE_TIER7_BLOCK15_THRESHOLD    0x016E
#define ATTRID_SE_PRICE_TIER7_BLOCK_THRESHOLD_CNT  0x017F
// Tier 8
#define ATTRID_SE_PRICE_TIER8_BLOCK1_THRESHOLD     0x0170
#define ATTRID_SE_PRICE_TIER8_BLOCK2_THRESHOLD     0x0171
#define ATTRID_SE_PRICE_TIER8_BLOCK3_THRESHOLD     0x0172
#define ATTRID_SE_PRICE_TIER8_BLOCK4_THRESHOLD     0x0173
#define ATTRID_SE_PRICE_TIER8_BLOCK5_THRESHOLD     0x0174
#define ATTRID_SE_PRICE_TIER8_BLOCK6_THRESHOLD     0x0175
#define ATTRID_SE_PRICE_TIER8_BLOCK7_THRESHOLD     0x0176
#define ATTRID_SE_PRICE_TIER8_BLOCK8_THRESHOLD     0x0177
#define ATTRID_SE_PRICE_TIER8_BLOCK9_THRESHOLD     0x0178
#define ATTRID_SE_PRICE_TIER8_BLOCK10_THRESHOLD    0x0179
#define ATTRID_SE_PRICE_TIER8_BLOCK11_THRESHOLD    0x017A
#define ATTRID_SE_PRICE_TIER8_BLOCK12_THRESHOLD    0x017B
#define ATTRID_SE_PRICE_TIER8_BLOCK13_THRESHOLD    0x017C
#define ATTRID_SE_PRICE_TIER8_BLOCK14_THRESHOLD    0x017D
#define ATTRID_SE_PRICE_TIER8_BLOCK15_THRESHOLD    0x017E
#define ATTRID_SE_PRICE_TIER8_BLOCK_THRESHOLD_CNT  0x018F
// Tier 9
#define ATTRID_SE_PRICE_TIER9_BLOCK1_THRESHOLD     0x0180
#define ATTRID_SE_PRICE_TIER9_BLOCK2_THRESHOLD     0x0181
#define ATTRID_SE_PRICE_TIER9_BLOCK3_THRESHOLD     0x0182
#define ATTRID_SE_PRICE_TIER9_BLOCK4_THRESHOLD     0x0183
#define ATTRID_SE_PRICE_TIER9_BLOCK5_THRESHOLD     0x0184
#define ATTRID_SE_PRICE_TIER9_BLOCK6_THRESHOLD     0x0185
#define ATTRID_SE_PRICE_TIER9_BLOCK7_THRESHOLD     0x0186
#define ATTRID_SE_PRICE_TIER9_BLOCK8_THRESHOLD     0x0187
#define ATTRID_SE_PRICE_TIER9_BLOCK9_THRESHOLD     0x0188
#define ATTRID_SE_PRICE_TIER9_BLOCK10_THRESHOLD    0x0189
#define ATTRID_SE_PRICE_TIER9_BLOCK11_THRESHOLD    0x018A
#define ATTRID_SE_PRICE_TIER9_BLOCK12_THRESHOLD    0x018B
#define ATTRID_SE_PRICE_TIER9_BLOCK13_THRESHOLD    0x018C
#define ATTRID_SE_PRICE_TIER9_BLOCK14_THRESHOLD    0x018D
#define ATTRID_SE_PRICE_TIER9_BLOCK15_THRESHOLD    0x018E
#define ATTRID_SE_PRICE_TIER9_BLOCK_THRESHOLD_CNT  0x019F
// Tier 10
#define ATTRID_SE_PRICE_TIER10_BLOCK1_THRESHOLD    0x0190
#define ATTRID_SE_PRICE_TIER10_BLOCK2_THRESHOLD    0x0191
#define ATTRID_SE_PRICE_TIER10_BLOCK3_THRESHOLD    0x0192
#define ATTRID_SE_PRICE_TIER10_BLOCK4_THRESHOLD    0x0193
#define ATTRID_SE_PRICE_TIER10_BLOCK5_THRESHOLD    0x0194
#define ATTRID_SE_PRICE_TIER10_BLOCK6_THRESHOLD    0x0195
#define ATTRID_SE_PRICE_TIER10_BLOCK7_THRESHOLD    0x0196
#define ATTRID_SE_PRICE_TIER10_BLOCK8_THRESHOLD    0x0197
#define ATTRID_SE_PRICE_TIER10_BLOCK9_THRESHOLD    0x0198
#define ATTRID_SE_PRICE_TIER10_BLOCK10_THRESHOLD   0x0199
#define ATTRID_SE_PRICE_TIER10_BLOCK11_THRESHOLD   0x019A
#define ATTRID_SE_PRICE_TIER10_BLOCK12_THRESHOLD   0x019B
#define ATTRID_SE_PRICE_TIER10_BLOCK13_THRESHOLD   0x019C
#define ATTRID_SE_PRICE_TIER10_BLOCK14_THRESHOLD   0x019D
#define ATTRID_SE_PRICE_TIER10_BLOCK15_THRESHOLD   0x019E
#define ATTRID_SE_PRICE_TIER10_BLOCK_THRESHOLD_CNT 0x01AF
// Tier 11
#define ATTRID_SE_PRICE_TIER11_BLOCK1_THRESHOLD    0x01A0
#define ATTRID_SE_PRICE_TIER11_BLOCK2_THRESHOLD    0x01A1
#define ATTRID_SE_PRICE_TIER11_BLOCK3_THRESHOLD    0x01A2
#define ATTRID_SE_PRICE_TIER11_BLOCK4_THRESHOLD    0x01A3
#define ATTRID_SE_PRICE_TIER11_BLOCK5_THRESHOLD    0x01A4
#define ATTRID_SE_PRICE_TIER11_BLOCK6_THRESHOLD    0x01A5
#define ATTRID_SE_PRICE_TIER11_BLOCK7_THRESHOLD    0x01A6
#define ATTRID_SE_PRICE_TIER11_BLOCK8_THRESHOLD    0x01A7
#define ATTRID_SE_PRICE_TIER11_BLOCK9_THRESHOLD    0x01A8
#define ATTRID_SE_PRICE_TIER11_BLOCK10_THRESHOLD   0x01A9
#define ATTRID_SE_PRICE_TIER11_BLOCK11_THRESHOLD   0x01AA
#define ATTRID_SE_PRICE_TIER11_BLOCK12_THRESHOLD   0x01AB
#define ATTRID_SE_PRICE_TIER11_BLOCK13_THRESHOLD   0x01AC
#define ATTRID_SE_PRICE_TIER11_BLOCK14_THRESHOLD   0x01AD
#define ATTRID_SE_PRICE_TIER11_BLOCK15_THRESHOLD   0x01AE
#define ATTRID_SE_PRICE_TIER11_BLOCK_THRESHOLD_CNT 0x01BF
// Tier 12
#define ATTRID_SE_PRICE_TIER12_BLOCK1_THRESHOLD    0x01B0
#define ATTRID_SE_PRICE_TIER12_BLOCK2_THRESHOLD    0x01B1
#define ATTRID_SE_PRICE_TIER12_BLOCK3_THRESHOLD    0x01B2
#define ATTRID_SE_PRICE_TIER12_BLOCK4_THRESHOLD    0x01B3
#define ATTRID_SE_PRICE_TIER12_BLOCK5_THRESHOLD    0x01B4
#define ATTRID_SE_PRICE_TIER12_BLOCK6_THRESHOLD    0x01B5
#define ATTRID_SE_PRICE_TIER12_BLOCK7_THRESHOLD    0x01B6
#define ATTRID_SE_PRICE_TIER12_BLOCK8_THRESHOLD    0x01B7
#define ATTRID_SE_PRICE_TIER12_BLOCK9_THRESHOLD    0x01B8
#define ATTRID_SE_PRICE_TIER12_BLOCK10_THRESHOLD   0x01B9
#define ATTRID_SE_PRICE_TIER12_BLOCK11_THRESHOLD   0x01BA
#define ATTRID_SE_PRICE_TIER12_BLOCK12_THRESHOLD   0x01BB
#define ATTRID_SE_PRICE_TIER12_BLOCK13_THRESHOLD   0x01BC
#define ATTRID_SE_PRICE_TIER12_BLOCK14_THRESHOLD   0x01BD
#define ATTRID_SE_PRICE_TIER12_BLOCK15_THRESHOLD   0x01BE
#define ATTRID_SE_PRICE_TIER12_BLOCK_THRESHOLD_CNT 0x01CF
// Tier 13
#define ATTRID_SE_PRICE_TIER13_BLOCK1_THRESHOLD    0x01C0
#define ATTRID_SE_PRICE_TIER13_BLOCK2_THRESHOLD    0x01C1
#define ATTRID_SE_PRICE_TIER13_BLOCK3_THRESHOLD    0x01C2
#define ATTRID_SE_PRICE_TIER13_BLOCK4_THRESHOLD    0x01C3
#define ATTRID_SE_PRICE_TIER13_BLOCK5_THRESHOLD    0x01C4
#define ATTRID_SE_PRICE_TIER13_BLOCK6_THRESHOLD    0x01C5
#define ATTRID_SE_PRICE_TIER13_BLOCK7_THRESHOLD    0x01C6
#define ATTRID_SE_PRICE_TIER13_BLOCK8_THRESHOLD    0x01C7
#define ATTRID_SE_PRICE_TIER13_BLOCK9_THRESHOLD    0x01C8
#define ATTRID_SE_PRICE_TIER13_BLOCK10_THRESHOLD   0x01C9
#define ATTRID_SE_PRICE_TIER13_BLOCK11_THRESHOLD   0x01CA
#define ATTRID_SE_PRICE_TIER13_BLOCK12_THRESHOLD   0x01CB
#define ATTRID_SE_PRICE_TIER13_BLOCK13_THRESHOLD   0x01CC
#define ATTRID_SE_PRICE_TIER13_BLOCK14_THRESHOLD   0x01CD
#define ATTRID_SE_PRICE_TIER13_BLOCK15_THRESHOLD   0x01CE
#define ATTRID_SE_PRICE_TIER13_BLOCK_THRESHOLD_CNT 0x01DF
// Tier 14
#define ATTRID_SE_PRICE_TIER14_BLOCK1_THRESHOLD    0x01E0
#define ATTRID_SE_PRICE_TIER14_BLOCK2_THRESHOLD    0x01E1
#define ATTRID_SE_PRICE_TIER14_BLOCK3_THRESHOLD    0x01E2
#define ATTRID_SE_PRICE_TIER14_BLOCK4_THRESHOLD    0x01E3
#define ATTRID_SE_PRICE_TIER14_BLOCK5_THRESHOLD    0x01E4
#define ATTRID_SE_PRICE_TIER14_BLOCK6_THRESHOLD    0x01E5
#define ATTRID_SE_PRICE_TIER14_BLOCK7_THRESHOLD    0x01E6
#define ATTRID_SE_PRICE_TIER14_BLOCK8_THRESHOLD    0x01E7
#define ATTRID_SE_PRICE_TIER14_BLOCK9_THRESHOLD    0x01E8
#define ATTRID_SE_PRICE_TIER14_BLOCK10_THRESHOLD   0x01E9
#define ATTRID_SE_PRICE_TIER14_BLOCK11_THRESHOLD   0x01EA
#define ATTRID_SE_PRICE_TIER14_BLOCK12_THRESHOLD   0x01EB
#define ATTRID_SE_PRICE_TIER14_BLOCK13_THRESHOLD   0x01EC
#define ATTRID_SE_PRICE_TIER14_BLOCK14_THRESHOLD   0x01ED
#define ATTRID_SE_PRICE_TIER14_BLOCK15_THRESHOLD   0x01EE
#define ATTRID_SE_PRICE_TIER14_BLOCK_THRESHOLD_CNT 0x01EF
// Tier 15
#define ATTRID_SE_PRICE_TIER15_BLOCK1_THRESHOLD    0x01F0
#define ATTRID_SE_PRICE_TIER15_BLOCK2_THRESHOLD    0x01F1
#define ATTRID_SE_PRICE_TIER15_BLOCK3_THRESHOLD    0x01F2
#define ATTRID_SE_PRICE_TIER15_BLOCK4_THRESHOLD    0x01F3
#define ATTRID_SE_PRICE_TIER15_BLOCK5_THRESHOLD    0x01F4
#define ATTRID_SE_PRICE_TIER15_BLOCK6_THRESHOLD    0x01F5
#define ATTRID_SE_PRICE_TIER15_BLOCK7_THRESHOLD    0x01F6
#define ATTRID_SE_PRICE_TIER15_BLOCK8_THRESHOLD    0x01F7
#define ATTRID_SE_PRICE_TIER15_BLOCK9_THRESHOLD    0x01F8
#define ATTRID_SE_PRICE_TIER15_BLOCK10_THRESHOLD   0x01F9
#define ATTRID_SE_PRICE_TIER15_BLOCK11_THRESHOLD   0x01FA
#define ATTRID_SE_PRICE_TIER15_BLOCK12_THRESHOLD   0x01FB
#define ATTRID_SE_PRICE_TIER15_BLOCK13_THRESHOLD   0x01FC
#define ATTRID_SE_PRICE_TIER15_BLOCK14_THRESHOLD   0x01FD
#define ATTRID_SE_PRICE_TIER15_BLOCK15_THRESHOLD   0x01FE
#define ATTRID_SE_PRICE_TIER15_BLOCK_THRESHOLD_CNT 0x01FF

//==== Block Period (Delivered) Attribute Set ====
#define ATTRID_SE_PRICE_START_BLOCK_PERIOD          0x0200
#define ATTRID_SE_PRICE_BLOCK_PERIOD_DURATION       0x0201
#define ATTRID_SE_PRICE_THRESHOLD_MULT              0x0202
#define ATTRID_SE_PRICE_THRESHOLD_DIV               0x0203
#define ATTRID_SE_PRICE_BLOCK_PERIOD_DURATION_TYPE  0x0204

//==== Commodity Attribute Set ====
#define ATTRID_SE_PRICE_COMMODITY_TYPE                   0x0300
#define ATTRID_SE_PRICE_STANDING_CHARGE                  0x0301
#define ATTRID_SE_PRICE_CONVERSION_FACTOR                0x0302
#define ATTRID_SE_PRICE_CONVERSION_FACTOR_TRAILING_DIGIT 0x0303
#define ATTRID_SE_PRICE_CALORIFIC_VALUE                  0x0304
#define ATTRID_SE_PRICE_CALORIFIC_VALUE_UNIT             0x0305
#define ATTRID_SE_PRICE_CALORIFIC_VALUE_TRAILING_DIGIT   0x0306

//==== Block Price Information (Delivered) Attribute Set ====
#define ATTRID_SE_PRICE_NO_TIER_BLOCK1  0x0400
#define ATTRID_SE_PRICE_NO_TIER_BLOCK2  0x0401
#define ATTRID_SE_PRICE_NO_TIER_BLOCK3  0x0402
#define ATTRID_SE_PRICE_NO_TIER_BLOCK4  0x0403
#define ATTRID_SE_PRICE_NO_TIER_BLOCK5  0x0404
#define ATTRID_SE_PRICE_NO_TIER_BLOCK6  0x0405
#define ATTRID_SE_PRICE_NO_TIER_BLOCK7  0x0406
#define ATTRID_SE_PRICE_NO_TIER_BLOCK8  0x0407
#define ATTRID_SE_PRICE_NO_TIER_BLOCK9  0x0408
#define ATTRID_SE_PRICE_NO_TIER_BLOCK10 0x0409
#define ATTRID_SE_PRICE_NO_TIER_BLOCK11 0x040A
#define ATTRID_SE_PRICE_NO_TIER_BLOCK12 0x040B
#define ATTRID_SE_PRICE_NO_TIER_BLOCK13 0x040C
#define ATTRID_SE_PRICE_NO_TIER_BLOCK14 0x040D
#define ATTRID_SE_PRICE_NO_TIER_BLOCK15 0x040E
#define ATTRID_SE_PRICE_NO_TIER_BLOCK16 0x040F
// Tier 1
#define ATTRID_SE_PRICE_TIER1_BLOCK1    0x0410
#define ATTRID_SE_PRICE_TIER1_BLOCK2    0x0411
#define ATTRID_SE_PRICE_TIER1_BLOCK3    0x0412
#define ATTRID_SE_PRICE_TIER1_BLOCK4    0x0413
#define ATTRID_SE_PRICE_TIER1_BLOCK5    0x0414
#define ATTRID_SE_PRICE_TIER1_BLOCK6    0x0415
#define ATTRID_SE_PRICE_TIER1_BLOCK7    0x0416
#define ATTRID_SE_PRICE_TIER1_BLOCK8    0x0417
#define ATTRID_SE_PRICE_TIER1_BLOCK9    0x0418
#define ATTRID_SE_PRICE_TIER1_BLOCK10   0x0419
#define ATTRID_SE_PRICE_TIER1_BLOCK11   0x041A
#define ATTRID_SE_PRICE_TIER1_BLOCK12   0x041B
#define ATTRID_SE_PRICE_TIER1_BLOCK13   0x041C
#define ATTRID_SE_PRICE_TIER1_BLOCK14   0x041D
#define ATTRID_SE_PRICE_TIER1_BLOCK15   0x041E
#define ATTRID_SE_PRICE_TIER1_BLOCK16   0x041F
// Tier 2
#define ATTRID_SE_PRICE_TIER2_BLOCK1    0x0420
#define ATTRID_SE_PRICE_TIER2_BLOCK2    0x0421
#define ATTRID_SE_PRICE_TIER2_BLOCK3    0x0422
#define ATTRID_SE_PRICE_TIER2_BLOCK4    0x0423
#define ATTRID_SE_PRICE_TIER2_BLOCK5    0x0424
#define ATTRID_SE_PRICE_TIER2_BLOCK6    0x0425
#define ATTRID_SE_PRICE_TIER2_BLOCK7    0x0426
#define ATTRID_SE_PRICE_TIER2_BLOCK8    0x0427
#define ATTRID_SE_PRICE_TIER2_BLOCK9    0x0428
#define ATTRID_SE_PRICE_TIER2_BLOCK10   0x0429
#define ATTRID_SE_PRICE_TIER2_BLOCK11   0x042A
#define ATTRID_SE_PRICE_TIER2_BLOCK12   0x042B
#define ATTRID_SE_PRICE_TIER2_BLOCK13   0x042C
#define ATTRID_SE_PRICE_TIER2_BLOCK14   0x042D
#define ATTRID_SE_PRICE_TIER2_BLOCK15   0x042E
#define ATTRID_SE_PRICE_TIER2_BLOCK16   0x042F
// Tier 3
#define ATTRID_SE_PRICE_TIER3_BLOCK1    0x0430
#define ATTRID_SE_PRICE_TIER3_BLOCK2    0x0431
#define ATTRID_SE_PRICE_TIER3_BLOCK3    0x0432
#define ATTRID_SE_PRICE_TIER3_BLOCK4    0x0433
#define ATTRID_SE_PRICE_TIER3_BLOCK5    0x0434
#define ATTRID_SE_PRICE_TIER3_BLOCK6    0x0435
#define ATTRID_SE_PRICE_TIER3_BLOCK7    0x0436
#define ATTRID_SE_PRICE_TIER3_BLOCK8    0x0437
#define ATTRID_SE_PRICE_TIER3_BLOCK9    0x0438
#define ATTRID_SE_PRICE_TIER3_BLOCK10   0x0439
#define ATTRID_SE_PRICE_TIER3_BLOCK11   0x043A
#define ATTRID_SE_PRICE_TIER3_BLOCK12   0x043B
#define ATTRID_SE_PRICE_TIER3_BLOCK13   0x043C
#define ATTRID_SE_PRICE_TIER3_BLOCK14   0x043D
#define ATTRID_SE_PRICE_TIER3_BLOCK15   0x043E
#define ATTRID_SE_PRICE_TIER3_BLOCK16   0x043F
// Tier 4
#define ATTRID_SE_PRICE_TIER4_BLOCK1    0x0440
#define ATTRID_SE_PRICE_TIER4_BLOCK2    0x0441
#define ATTRID_SE_PRICE_TIER4_BLOCK3    0x0442
#define ATTRID_SE_PRICE_TIER4_BLOCK4    0x0443
#define ATTRID_SE_PRICE_TIER4_BLOCK5    0x0444
#define ATTRID_SE_PRICE_TIER4_BLOCK6    0x0445
#define ATTRID_SE_PRICE_TIER4_BLOCK7    0x0446
#define ATTRID_SE_PRICE_TIER4_BLOCK8    0x0447
#define ATTRID_SE_PRICE_TIER4_BLOCK9    0x0448
#define ATTRID_SE_PRICE_TIER4_BLOCK10   0x0449
#define ATTRID_SE_PRICE_TIER4_BLOCK11   0x044A
#define ATTRID_SE_PRICE_TIER4_BLOCK12   0x044B
#define ATTRID_SE_PRICE_TIER4_BLOCK13   0x044C
#define ATTRID_SE_PRICE_TIER4_BLOCK14   0x044D
#define ATTRID_SE_PRICE_TIER4_BLOCK15   0x044E
#define ATTRID_SE_PRICE_TIER4_BLOCK16   0x044F
// Tier 5
#define ATTRID_SE_PRICE_TIER5_BLOCK1    0x0450
#define ATTRID_SE_PRICE_TIER5_BLOCK2    0x0451
#define ATTRID_SE_PRICE_TIER5_BLOCK3    0x0452
#define ATTRID_SE_PRICE_TIER5_BLOCK4    0x0453
#define ATTRID_SE_PRICE_TIER5_BLOCK5    0x0454
#define ATTRID_SE_PRICE_TIER5_BLOCK6    0x0455
#define ATTRID_SE_PRICE_TIER5_BLOCK7    0x0456
#define ATTRID_SE_PRICE_TIER5_BLOCK8    0x0457
#define ATTRID_SE_PRICE_TIER5_BLOCK9    0x0458
#define ATTRID_SE_PRICE_TIER5_BLOCK10   0x0459
#define ATTRID_SE_PRICE_TIER5_BLOCK11   0x045A
#define ATTRID_SE_PRICE_TIER5_BLOCK12   0x045B
#define ATTRID_SE_PRICE_TIER5_BLOCK13   0x045C
#define ATTRID_SE_PRICE_TIER5_BLOCK14   0x045D
#define ATTRID_SE_PRICE_TIER5_BLOCK15   0x045E
#define ATTRID_SE_PRICE_TIER5_BLOCK16   0x045F
// Tier 6
#define ATTRID_SE_PRICE_TIER6_BLOCK1    0x0460
#define ATTRID_SE_PRICE_TIER6_BLOCK2    0x0461
#define ATTRID_SE_PRICE_TIER6_BLOCK3    0x0462
#define ATTRID_SE_PRICE_TIER6_BLOCK4    0x0463
#define ATTRID_SE_PRICE_TIER6_BLOCK5    0x0464
#define ATTRID_SE_PRICE_TIER6_BLOCK6    0x0465
#define ATTRID_SE_PRICE_TIER6_BLOCK7    0x0466
#define ATTRID_SE_PRICE_TIER6_BLOCK8    0x0467
#define ATTRID_SE_PRICE_TIER6_BLOCK9    0x0468
#define ATTRID_SE_PRICE_TIER6_BLOCK10   0x0469
#define ATTRID_SE_PRICE_TIER6_BLOCK11   0x046A
#define ATTRID_SE_PRICE_TIER6_BLOCK12   0x046B
#define ATTRID_SE_PRICE_TIER6_BLOCK13   0x046C
#define ATTRID_SE_PRICE_TIER6_BLOCK14   0x046D
#define ATTRID_SE_PRICE_TIER6_BLOCK15   0x046E
#define ATTRID_SE_PRICE_TIER6_BLOCK16   0x046F
// Tier 7
#define ATTRID_SE_PRICE_TIER7_BLOCK1    0x0470
#define ATTRID_SE_PRICE_TIER7_BLOCK2    0x0471
#define ATTRID_SE_PRICE_TIER7_BLOCK3    0x0472
#define ATTRID_SE_PRICE_TIER7_BLOCK4    0x0473
#define ATTRID_SE_PRICE_TIER7_BLOCK5    0x0474
#define ATTRID_SE_PRICE_TIER7_BLOCK6    0x0475
#define ATTRID_SE_PRICE_TIER7_BLOCK7    0x0476
#define ATTRID_SE_PRICE_TIER7_BLOCK8    0x0477
#define ATTRID_SE_PRICE_TIER7_BLOCK9    0x0478
#define ATTRID_SE_PRICE_TIER7_BLOCK10   0x0479
#define ATTRID_SE_PRICE_TIER7_BLOCK11   0x047A
#define ATTRID_SE_PRICE_TIER7_BLOCK12   0x047B
#define ATTRID_SE_PRICE_TIER7_BLOCK13   0x047C
#define ATTRID_SE_PRICE_TIER7_BLOCK14   0x047D
#define ATTRID_SE_PRICE_TIER7_BLOCK15   0x047E
#define ATTRID_SE_PRICE_TIER7_BLOCK16   0x047F
// Tier 8
#define ATTRID_SE_PRICE_TIER8_BLOCK1    0x0480
#define ATTRID_SE_PRICE_TIER8_BLOCK2    0x0481
#define ATTRID_SE_PRICE_TIER8_BLOCK3    0x0482
#define ATTRID_SE_PRICE_TIER8_BLOCK4    0x0483
#define ATTRID_SE_PRICE_TIER8_BLOCK5    0x0484
#define ATTRID_SE_PRICE_TIER8_BLOCK6    0x0485
#define ATTRID_SE_PRICE_TIER8_BLOCK7    0x0486
#define ATTRID_SE_PRICE_TIER8_BLOCK8    0x0487
#define ATTRID_SE_PRICE_TIER8_BLOCK9    0x0488
#define ATTRID_SE_PRICE_TIER8_BLOCK10   0x0489
#define ATTRID_SE_PRICE_TIER8_BLOCK11   0x048A
#define ATTRID_SE_PRICE_TIER8_BLOCK12   0x048B
#define ATTRID_SE_PRICE_TIER8_BLOCK13   0x048C
#define ATTRID_SE_PRICE_TIER8_BLOCK14   0x048D
#define ATTRID_SE_PRICE_TIER8_BLOCK15   0x048E
#define ATTRID_SE_PRICE_TIER8_BLOCK16   0x048F
// Tier 9
#define ATTRID_SE_PRICE_TIER9_BLOCK1    0x0490
#define ATTRID_SE_PRICE_TIER9_BLOCK2    0x0491
#define ATTRID_SE_PRICE_TIER9_BLOCK3    0x0492
#define ATTRID_SE_PRICE_TIER9_BLOCK4    0x0493
#define ATTRID_SE_PRICE_TIER9_BLOCK5    0x0494
#define ATTRID_SE_PRICE_TIER9_BLOCK6    0x0495
#define ATTRID_SE_PRICE_TIER9_BLOCK7    0x0496
#define ATTRID_SE_PRICE_TIER9_BLOCK8    0x0497
#define ATTRID_SE_PRICE_TIER9_BLOCK9    0x0498
#define ATTRID_SE_PRICE_TIER9_BLOCK10   0x0499
#define ATTRID_SE_PRICE_TIER9_BLOCK11   0x049A
#define ATTRID_SE_PRICE_TIER9_BLOCK12   0x049B
#define ATTRID_SE_PRICE_TIER9_BLOCK13   0x049C
#define ATTRID_SE_PRICE_TIER9_BLOCK14   0x049D
#define ATTRID_SE_PRICE_TIER9_BLOCK15   0x049E
#define ATTRID_SE_PRICE_TIER9_BLOCK16   0x049F
// Tier 10
#define ATTRID_SE_PRICE_TIER10_BLOCK1   0x04A0
#define ATTRID_SE_PRICE_TIER10_BLOCK2   0x04A1
#define ATTRID_SE_PRICE_TIER10_BLOCK3   0x04A2
#define ATTRID_SE_PRICE_TIER10_BLOCK4   0x04A3
#define ATTRID_SE_PRICE_TIER10_BLOCK5   0x04A4
#define ATTRID_SE_PRICE_TIER10_BLOCK6   0x04A5
#define ATTRID_SE_PRICE_TIER10_BLOCK7   0x04A6
#define ATTRID_SE_PRICE_TIER10_BLOCK8   0x04A7
#define ATTRID_SE_PRICE_TIER10_BLOCK9   0x04A8
#define ATTRID_SE_PRICE_TIER10_BLOCK10  0x04A9
#define ATTRID_SE_PRICE_TIER10_BLOCK11  0x04AA
#define ATTRID_SE_PRICE_TIER10_BLOCK12  0x04AB
#define ATTRID_SE_PRICE_TIER10_BLOCK13  0x04AC
#define ATTRID_SE_PRICE_TIER10_BLOCK14  0x04AD
#define ATTRID_SE_PRICE_TIER10_BLOCK15  0x04AE
#define ATTRID_SE_PRICE_TIER10_BLOCK16  0x04AF
// Tier 11
#define ATTRID_SE_PRICE_TIER11_BLOCK1   0x04B0
#define ATTRID_SE_PRICE_TIER11_BLOCK2   0x04B1
#define ATTRID_SE_PRICE_TIER11_BLOCK3   0x04B2
#define ATTRID_SE_PRICE_TIER11_BLOCK4   0x04B3
#define ATTRID_SE_PRICE_TIER11_BLOCK5   0x04B4
#define ATTRID_SE_PRICE_TIER11_BLOCK6   0x04B5
#define ATTRID_SE_PRICE_TIER11_BLOCK7   0x04B6
#define ATTRID_SE_PRICE_TIER11_BLOCK8   0x04B7
#define ATTRID_SE_PRICE_TIER11_BLOCK9   0x04B8
#define ATTRID_SE_PRICE_TIER11_BLOCK10  0x04B9
#define ATTRID_SE_PRICE_TIER11_BLOCK11  0x04BA
#define ATTRID_SE_PRICE_TIER11_BLOCK12  0x04BB
#define ATTRID_SE_PRICE_TIER11_BLOCK13  0x04BC
#define ATTRID_SE_PRICE_TIER11_BLOCK14  0x04BD
#define ATTRID_SE_PRICE_TIER11_BLOCK15  0x04BE
#define ATTRID_SE_PRICE_TIER11_BLOCK16  0x04BF
// Tier 12
#define ATTRID_SE_PRICE_TIER12_BLOCK1   0x04C0
#define ATTRID_SE_PRICE_TIER12_BLOCK2   0x04C1
#define ATTRID_SE_PRICE_TIER12_BLOCK3   0x04C2
#define ATTRID_SE_PRICE_TIER12_BLOCK4   0x04C3
#define ATTRID_SE_PRICE_TIER12_BLOCK5   0x04C4
#define ATTRID_SE_PRICE_TIER12_BLOCK6   0x04C5
#define ATTRID_SE_PRICE_TIER12_BLOCK7   0x04C6
#define ATTRID_SE_PRICE_TIER12_BLOCK8   0x04C7
#define ATTRID_SE_PRICE_TIER12_BLOCK9   0x04C8
#define ATTRID_SE_PRICE_TIER12_BLOCK10  0x04C9
#define ATTRID_SE_PRICE_TIER12_BLOCK11  0x04CA
#define ATTRID_SE_PRICE_TIER12_BLOCK12  0x04CB
#define ATTRID_SE_PRICE_TIER12_BLOCK13  0x04CC
#define ATTRID_SE_PRICE_TIER12_BLOCK14  0x04CD
#define ATTRID_SE_PRICE_TIER12_BLOCK15  0x04CE
#define ATTRID_SE_PRICE_TIER12_BLOCK16  0x04CF
// Tier 13
#define ATTRID_SE_PRICE_TIER13_BLOCK1   0x04D0
#define ATTRID_SE_PRICE_TIER13_BLOCK2   0x04D1
#define ATTRID_SE_PRICE_TIER13_BLOCK3   0x04D2
#define ATTRID_SE_PRICE_TIER13_BLOCK4   0x04D3
#define ATTRID_SE_PRICE_TIER13_BLOCK5   0x04D4
#define ATTRID_SE_PRICE_TIER13_BLOCK6   0x04D5
#define ATTRID_SE_PRICE_TIER13_BLOCK7   0x04D6
#define ATTRID_SE_PRICE_TIER13_BLOCK8   0x04D7
#define ATTRID_SE_PRICE_TIER13_BLOCK9   0x04D8
#define ATTRID_SE_PRICE_TIER13_BLOCK10  0x04D9
#define ATTRID_SE_PRICE_TIER13_BLOCK11  0x04DA
#define ATTRID_SE_PRICE_TIER13_BLOCK12  0x04DB
#define ATTRID_SE_PRICE_TIER13_BLOCK13  0x04DC
#define ATTRID_SE_PRICE_TIER13_BLOCK14  0x04DD
#define ATTRID_SE_PRICE_TIER13_BLOCK15  0x04DE
#define ATTRID_SE_PRICE_TIER13_BLOCK16  0x04DF
// Tier 14
#define ATTRID_SE_PRICE_TIER14_BLOCK1   0x04E0
#define ATTRID_SE_PRICE_TIER14_BLOCK2   0x04E1
#define ATTRID_SE_PRICE_TIER14_BLOCK3   0x04E2
#define ATTRID_SE_PRICE_TIER14_BLOCK4   0x04E3
#define ATTRID_SE_PRICE_TIER14_BLOCK5   0x04E4
#define ATTRID_SE_PRICE_TIER14_BLOCK6   0x04E5
#define ATTRID_SE_PRICE_TIER14_BLOCK7   0x04E6
#define ATTRID_SE_PRICE_TIER14_BLOCK8   0x04E7
#define ATTRID_SE_PRICE_TIER14_BLOCK9   0x04E8
#define ATTRID_SE_PRICE_TIER14_BLOCK10  0x04E9
#define ATTRID_SE_PRICE_TIER14_BLOCK11  0x04EA
#define ATTRID_SE_PRICE_TIER14_BLOCK12  0x04EB
#define ATTRID_SE_PRICE_TIER14_BLOCK13  0x04EC
#define ATTRID_SE_PRICE_TIER14_BLOCK14  0x04ED
#define ATTRID_SE_PRICE_TIER14_BLOCK15  0x04EE
#define ATTRID_SE_PRICE_TIER14_BLOCK16  0x04EF
// Tier 15
#define ATTRID_SE_PRICE_TIER15_BLOCK1   0x04F0
#define ATTRID_SE_PRICE_TIER15_BLOCK2   0x04F1
#define ATTRID_SE_PRICE_TIER15_BLOCK3   0x04F2
#define ATTRID_SE_PRICE_TIER15_BLOCK4   0x04F3
#define ATTRID_SE_PRICE_TIER15_BLOCK5   0x04F4
#define ATTRID_SE_PRICE_TIER15_BLOCK6   0x04F5
#define ATTRID_SE_PRICE_TIER15_BLOCK7   0x04F6
#define ATTRID_SE_PRICE_TIER15_BLOCK8   0x04F7
#define ATTRID_SE_PRICE_TIER15_BLOCK9   0x04F8
#define ATTRID_SE_PRICE_TIER15_BLOCK10  0x04F9
#define ATTRID_SE_PRICE_TIER15_BLOCK11  0x04FA
#define ATTRID_SE_PRICE_TIER15_BLOCK12  0x04FB
#define ATTRID_SE_PRICE_TIER15_BLOCK13  0x04FC
#define ATTRID_SE_PRICE_TIER15_BLOCK14  0x04FD
#define ATTRID_SE_PRICE_TIER15_BLOCK15  0x04FE
#define ATTRID_SE_PRICE_TIER15_BLOCK16  0x04FF

//==== Extended Price Information (Delivered) Attribute Set ====
#define ATTRID_SE_PRICE_TIER16 0x050F
#define ATTRID_SE_PRICE_TIER17 0x0510
#define ATTRID_SE_PRICE_TIER18 0x0511
#define ATTRID_SE_PRICE_TIER19 0x0512
#define ATTRID_SE_PRICE_TIER20 0x0513
#define ATTRID_SE_PRICE_TIER21 0x0514
#define ATTRID_SE_PRICE_TIER22 0x0515
#define ATTRID_SE_PRICE_TIER23 0x0516
#define ATTRID_SE_PRICE_TIER24 0x0517
#define ATTRID_SE_PRICE_TIER25 0x0518
#define ATTRID_SE_PRICE_TIER26 0x0519
#define ATTRID_SE_PRICE_TIER27 0x051A
#define ATTRID_SE_PRICE_TIER28 0x051B
#define ATTRID_SE_PRICE_TIER29 0x051C
#define ATTRID_SE_PRICE_TIER30 0x051D
#define ATTRID_SE_PRICE_TIER31 0x051E
#define ATTRID_SE_PRICE_TIER32 0x051F
#define ATTRID_SE_PRICE_TIER33 0x0520
#define ATTRID_SE_PRICE_TIER34 0x0521
#define ATTRID_SE_PRICE_TIER35 0x0522
#define ATTRID_SE_PRICE_TIER36 0x0523
#define ATTRID_SE_PRICE_TIER37 0x0524
#define ATTRID_SE_PRICE_TIER38 0x0525
#define ATTRID_SE_PRICE_TIER39 0x0526
#define ATTRID_SE_PRICE_TIER40 0x0527
#define ATTRID_SE_PRICE_TIER41 0x0528
#define ATTRID_SE_PRICE_TIER42 0x0529
#define ATTRID_SE_PRICE_TIER43 0x052A
#define ATTRID_SE_PRICE_TIER44 0x052B
#define ATTRID_SE_PRICE_TIER45 0x052C
#define ATTRID_SE_PRICE_TIER46 0x052D
#define ATTRID_SE_PRICE_TIER47 0x052E
#define ATTRID_SE_PRICE_TIER48 0x052F
#define ATTRID_SE_PRICE_CPP1   0x05FE
#define ATTRID_SE_PRICE_CPP2   0x05FF

//==== Tariff Information Set (Delivered) Attribute Set ====
#define ATTRID_SE_PRICE_TARIFF_LABEL                0x0610
#define ATTRID_SE_PRICE_NUM_PRICE_TIERS_IN_USE      0x0611
#define ATTRID_SE_PRICE_NUM_BLOCK_THRESHOLDS_IN_USE 0x0612
#define ATTRID_SE_PRICE_TIER_BLOCK_MODE             0x0613
#define ATTRID_SE_PRICE_UOM                         0x0615
#define ATTRID_SE_PRICE_CURRENCY                    0x0616
#define ATTRID_SE_PRICE_PRICE_TRAILING_DIGIT        0x0617
#define ATTRID_SE_PRICE_TARIFF_RESOLUTION_PERIOD    0x0619
#define ATTRID_SE_PRICE_CO2                         0x0620
#define ATTRID_SE_PRICE_CO2_UNIT                    0x0621
#define ATTRID_SE_PRICE_CO2_TRAILING_DIGIT          0x0622

//==== Billing Information Set (Delivered) Attribute Set ====
#define ATTRID_SE_PRICE_CURR_BILL_PERIOD_START             0x0700
#define ATTRID_SE_PRICE_CURR_BILL_PERIOD_DURATION          0x0701
#define ATTRID_SE_PRICE_LAST_BILL_PERIOD_START             0x0702
#define ATTRID_SE_PRICE_LAST_BILL_PERIOD_DURATION          0x0703
#define ATTRID_SE_PRICE_LAST_BILL_PERIOD_CONSOLIDATED_BILL 0x0704

//==== Credit Payment Attribute Set ====
#define ATTRID_SE_PRICE_CREDIT_PAYMENT_DUE_DATE     0x0800
#define ATTRID_SE_PRICE_CREDIT_PAYMENT_STATUS       0x0801
#define ATTRID_SE_PRICE_CREDIT_PAYMENT_OVERDUE_AMNT 0x0802
#define ATTRID_SE_PRICE_PAYMENT_DISCOUNT            0x080A
#define ATTRID_SE_PRICE_PAYMENT_DISCOUNT_PERIOD     0x080B
#define ATTRID_SE_PRICE_CREDIT_PAYMENT1             0x0810
#define ATTRID_SE_PRICE_CREDIT_PAYMENT1_DATE        0x0811
#define ATTRID_SE_PRICE_CREDIT_PAYMENT1_REF         0x0812
#define ATTRID_SE_PRICE_CREDIT_PAYMENT2             0x0820
#define ATTRID_SE_PRICE_CREDIT_PAYMENT2_DATE        0x0821
#define ATTRID_SE_PRICE_CREDIT_PAYMENT2_REF         0x0822
#define ATTRID_SE_PRICE_CREDIT_PAYMENT3             0x0830
#define ATTRID_SE_PRICE_CREDIT_PAYMENT3_DATE        0x0831
#define ATTRID_SE_PRICE_CREDIT_PAYMENT3_REF         0x0832
#define ATTRID_SE_PRICE_CREDIT_PAYMENT4             0x0840
#define ATTRID_SE_PRICE_CREDIT_PAYMENT4_DATE        0x0841
#define ATTRID_SE_PRICE_CREDIT_PAYMENT4_REF         0x0842
#define ATTRID_SE_PRICE_CREDIT_PAYMENT5             0x0850
#define ATTRID_SE_PRICE_CREDIT_PAYMENT5_DATE        0x0851
#define ATTRID_SE_PRICE_CREDIT_PAYMENT5_REF         0x0852

//==== Received Tier Label Attribute Set ====
#define ATTRID_SE_PRICE_RCVD_TIER1_LABEL  0x8000
#define ATTRID_SE_PRICE_RCVD_TIER2_LABEL  0x8001
#define ATTRID_SE_PRICE_RCVD_TIER3_LABEL  0x8002
#define ATTRID_SE_PRICE_RCVD_TIER4_LABEL  0x8003
#define ATTRID_SE_PRICE_RCVD_TIER5_LABEL  0x8004
#define ATTRID_SE_PRICE_RCVD_TIER6_LABEL  0x8005
#define ATTRID_SE_PRICE_RCVD_TIER7_LABEL  0x8006
#define ATTRID_SE_PRICE_RCVD_TIER8_LABEL  0x8007
#define ATTRID_SE_PRICE_RCVD_TIER9_LABEL  0x8008
#define ATTRID_SE_PRICE_RCVD_TIER10_LABEL 0x8009
#define ATTRID_SE_PRICE_RCVD_TIER11_LABEL 0x800A
#define ATTRID_SE_PRICE_RCVD_TIER12_LABEL 0x800B
#define ATTRID_SE_PRICE_RCVD_TIER13_LABEL 0x800C
#define ATTRID_SE_PRICE_RCVD_TIER14_LABEL 0x800D
#define ATTRID_SE_PRICE_RCVD_TIER15_LABEL 0x800E
#define ATTRID_SE_PRICE_RCVD_TIER16_LABEL 0x800F
#define ATTRID_SE_PRICE_RCVD_TIER17_LABEL 0x8010
#define ATTRID_SE_PRICE_RCVD_TIER18_LABEL 0x8011
#define ATTRID_SE_PRICE_RCVD_TIER19_LABEL 0x8012
#define ATTRID_SE_PRICE_RCVD_TIER20_LABEL 0x8013
#define ATTRID_SE_PRICE_RCVD_TIER21_LABEL 0x8014
#define ATTRID_SE_PRICE_RCVD_TIER22_LABEL 0x8015
#define ATTRID_SE_PRICE_RCVD_TIER23_LABEL 0x8016
#define ATTRID_SE_PRICE_RCVD_TIER24_LABEL 0x8017
#define ATTRID_SE_PRICE_RCVD_TIER25_LABEL 0x8018
#define ATTRID_SE_PRICE_RCVD_TIER26_LABEL 0x8019
#define ATTRID_SE_PRICE_RCVD_TIER27_LABEL 0x801A
#define ATTRID_SE_PRICE_RCVD_TIER28_LABEL 0x801B
#define ATTRID_SE_PRICE_RCVD_TIER29_LABEL 0x801C
#define ATTRID_SE_PRICE_RCVD_TIER30_LABEL 0x801D
#define ATTRID_SE_PRICE_RCVD_TIER31_LABEL 0x801E
#define ATTRID_SE_PRICE_RCVD_TIER32_LABEL 0x801F
#define ATTRID_SE_PRICE_RCVD_TIER33_LABEL 0x8020
#define ATTRID_SE_PRICE_RCVD_TIER34_LABEL 0x8021
#define ATTRID_SE_PRICE_RCVD_TIER35_LABEL 0x8022
#define ATTRID_SE_PRICE_RCVD_TIER36_LABEL 0x8023
#define ATTRID_SE_PRICE_RCVD_TIER37_LABEL 0x8024
#define ATTRID_SE_PRICE_RCVD_TIER38_LABEL 0x8025
#define ATTRID_SE_PRICE_RCVD_TIER39_LABEL 0x8026
#define ATTRID_SE_PRICE_RCVD_TIER40_LABEL 0x8027
#define ATTRID_SE_PRICE_RCVD_TIER41_LABEL 0x8028
#define ATTRID_SE_PRICE_RCVD_TIER42_LABEL 0x8029
#define ATTRID_SE_PRICE_RCVD_TIER43_LABEL 0x802A
#define ATTRID_SE_PRICE_RCVD_TIER44_LABEL 0x802B
#define ATTRID_SE_PRICE_RCVD_TIER45_LABEL 0x802C
#define ATTRID_SE_PRICE_RCVD_TIER46_LABEL 0x802D
#define ATTRID_SE_PRICE_RCVD_TIER47_LABEL 0x802E
#define ATTRID_SE_PRICE_RCVD_TIER48_LABEL 0x802F

//==== Received Block Threshold Attribute Set ====
#define ATTRID_SE_PRICE_RCVD_BLOCK1_THRESHOLD  0x8100
#define ATTRID_SE_PRICE_RCVD_BLOCK2_THRESHOLD  0x8101
#define ATTRID_SE_PRICE_RCVD_BLOCK3_THRESHOLD  0x8102
#define ATTRID_SE_PRICE_RCVD_BLOCK4_THRESHOLD  0x8103
#define ATTRID_SE_PRICE_RCVD_BLOCK5_THRESHOLD  0x8104
#define ATTRID_SE_PRICE_RCVD_BLOCK6_THRESHOLD  0x8105
#define ATTRID_SE_PRICE_RCVD_BLOCK7_THRESHOLD  0x8106
#define ATTRID_SE_PRICE_RCVD_BLOCK8_THRESHOLD  0x8107
#define ATTRID_SE_PRICE_RCVD_BLOCK9_THRESHOLD  0x8108
#define ATTRID_SE_PRICE_RCVD_BLOCK10_THRESHOLD 0x8109
#define ATTRID_SE_PRICE_RCVD_BLOCK11_THRESHOLD 0x810A
#define ATTRID_SE_PRICE_RCVD_BLOCK12_THRESHOLD 0x810B
#define ATTRID_SE_PRICE_RCVD_BLOCK13_THRESHOLD 0x810C
#define ATTRID_SE_PRICE_RCVD_BLOCK14_THRESHOLD 0x810D
#define ATTRID_SE_PRICE_RCVD_BLOCK15_THRESHOLD 0x810E

//==== Received Block Period Attribute Set ====
#define ATTRID_SE_PRICE_RCVD_START_BLOCK_PERIOD    0x8200
#define ATTRID_SE_PRICE_RCVD_BLOCK_PERIOD_DURATION 0x8201
#define ATTRID_SE_PRICE_RCVD_THRESHOLD_MULT        0x8202
#define ATTRID_SE_PRICE_RCVD_THRESHOLD_DIV         0x8203

//==== Received Block Price Information Attribute Set ====
#define ATTRID_SE_PRICE_RX_NO_TIER_BLOCK1  0x8400
#define ATTRID_SE_PRICE_RX_NO_TIER_BLOCK2  0x8401
#define ATTRID_SE_PRICE_RX_NO_TIER_BLOCK3  0x8402
#define ATTRID_SE_PRICE_RX_NO_TIER_BLOCK4  0x8403
#define ATTRID_SE_PRICE_RX_NO_TIER_BLOCK5  0x8404
#define ATTRID_SE_PRICE_RX_NO_TIER_BLOCK6  0x8405
#define ATTRID_SE_PRICE_RX_NO_TIER_BLOCK7  0x8406
#define ATTRID_SE_PRICE_RX_NO_TIER_BLOCK8  0x8407
#define ATTRID_SE_PRICE_RX_NO_TIER_BLOCK9  0x8408
#define ATTRID_SE_PRICE_RX_NO_TIER_BLOCK10 0x8409
#define ATTRID_SE_PRICE_RX_NO_TIER_BLOCK11 0x840A
#define ATTRID_SE_PRICE_RX_NO_TIER_BLOCK12 0x840B
#define ATTRID_SE_PRICE_RX_NO_TIER_BLOCK13 0x840C
#define ATTRID_SE_PRICE_RX_NO_TIER_BLOCK14 0x840D
#define ATTRID_SE_PRICE_RX_NO_TIER_BLOCK15 0x840E
#define ATTRID_SE_PRICE_RX_NO_TIER_BLOCK16 0x840F
// Tier 1
#define ATTRID_SE_PRICE_RX_TIER1_BLOCK1    0x8410
#define ATTRID_SE_PRICE_RX_TIER1_BLOCK2    0x8411
#define ATTRID_SE_PRICE_RX_TIER1_BLOCK3    0x8412
#define ATTRID_SE_PRICE_RX_TIER1_BLOCK4    0x8413
#define ATTRID_SE_PRICE_RX_TIER1_BLOCK5    0x8414
#define ATTRID_SE_PRICE_RX_TIER1_BLOCK6    0x8415
#define ATTRID_SE_PRICE_RX_TIER1_BLOCK7    0x8416
#define ATTRID_SE_PRICE_RX_TIER1_BLOCK8    0x8417
#define ATTRID_SE_PRICE_RX_TIER1_BLOCK9    0x8418
#define ATTRID_SE_PRICE_RX_TIER1_BLOCK10   0x8419
#define ATTRID_SE_PRICE_RX_TIER1_BLOCK11   0x841A
#define ATTRID_SE_PRICE_RX_TIER1_BLOCK12   0x841B
#define ATTRID_SE_PRICE_RX_TIER1_BLOCK13   0x841C
#define ATTRID_SE_PRICE_RX_TIER1_BLOCK14   0x841D
#define ATTRID_SE_PRICE_RX_TIER1_BLOCK15   0x841E
#define ATTRID_SE_PRICE_RX_TIER1_BLOCK16   0x841F
// Tier 2
#define ATTRID_SE_PRICE_RX_TIER2_BLOCK1    0x8420
#define ATTRID_SE_PRICE_RX_TIER2_BLOCK2    0x8421
#define ATTRID_SE_PRICE_RX_TIER2_BLOCK3    0x8422
#define ATTRID_SE_PRICE_RX_TIER2_BLOCK4    0x8423
#define ATTRID_SE_PRICE_RX_TIER2_BLOCK5    0x8424
#define ATTRID_SE_PRICE_RX_TIER2_BLOCK6    0x8425
#define ATTRID_SE_PRICE_RX_TIER2_BLOCK7    0x8426
#define ATTRID_SE_PRICE_RX_TIER2_BLOCK8    0x8427
#define ATTRID_SE_PRICE_RX_TIER2_BLOCK9    0x8428
#define ATTRID_SE_PRICE_RX_TIER2_BLOCK10   0x8429
#define ATTRID_SE_PRICE_RX_TIER2_BLOCK11   0x842A
#define ATTRID_SE_PRICE_RX_TIER2_BLOCK12   0x842B
#define ATTRID_SE_PRICE_RX_TIER2_BLOCK13   0x842C
#define ATTRID_SE_PRICE_RX_TIER2_BLOCK14   0x842D
#define ATTRID_SE_PRICE_RX_TIER2_BLOCK15   0x842E
#define ATTRID_SE_PRICE_RX_TIER2_BLOCK16   0x842F
// Tier 3
#define ATTRID_SE_PRICE_RX_TIER3_BLOCK1    0x8430
#define ATTRID_SE_PRICE_RX_TIER3_BLOCK2    0x8431
#define ATTRID_SE_PRICE_RX_TIER3_BLOCK3    0x8432
#define ATTRID_SE_PRICE_RX_TIER3_BLOCK4    0x8433
#define ATTRID_SE_PRICE_RX_TIER3_BLOCK5    0x8434
#define ATTRID_SE_PRICE_RX_TIER3_BLOCK6    0x8435
#define ATTRID_SE_PRICE_RX_TIER3_BLOCK7    0x8436
#define ATTRID_SE_PRICE_RX_TIER3_BLOCK8    0x8437
#define ATTRID_SE_PRICE_RX_TIER3_BLOCK9    0x8438
#define ATTRID_SE_PRICE_RX_TIER3_BLOCK10   0x8439
#define ATTRID_SE_PRICE_RX_TIER3_BLOCK11   0x843A
#define ATTRID_SE_PRICE_RX_TIER3_BLOCK12   0x843B
#define ATTRID_SE_PRICE_RX_TIER3_BLOCK13   0x843C
#define ATTRID_SE_PRICE_RX_TIER3_BLOCK14   0x843D
#define ATTRID_SE_PRICE_RX_TIER3_BLOCK15   0x843E
#define ATTRID_SE_PRICE_RX_TIER3_BLOCK16   0x843F
// Tier 4
#define ATTRID_SE_PRICE_RX_TIER4_BLOCK1    0x8440
#define ATTRID_SE_PRICE_RX_TIER4_BLOCK2    0x8441
#define ATTRID_SE_PRICE_RX_TIER4_BLOCK3    0x8442
#define ATTRID_SE_PRICE_RX_TIER4_BLOCK4    0x8443
#define ATTRID_SE_PRICE_RX_TIER4_BLOCK5    0x8444
#define ATTRID_SE_PRICE_RX_TIER4_BLOCK6    0x8445
#define ATTRID_SE_PRICE_RX_TIER4_BLOCK7    0x8446
#define ATTRID_SE_PRICE_RX_TIER4_BLOCK8    0x8447
#define ATTRID_SE_PRICE_RX_TIER4_BLOCK9    0x8448
#define ATTRID_SE_PRICE_RX_TIER4_BLOCK10   0x8449
#define ATTRID_SE_PRICE_RX_TIER4_BLOCK11   0x844A
#define ATTRID_SE_PRICE_RX_TIER4_BLOCK12   0x844B
#define ATTRID_SE_PRICE_RX_TIER4_BLOCK13   0x844C
#define ATTRID_SE_PRICE_RX_TIER4_BLOCK14   0x844D
#define ATTRID_SE_PRICE_RX_TIER4_BLOCK15   0x844E
#define ATTRID_SE_PRICE_RX_TIER4_BLOCK16   0x844F
// Tier 5
#define ATTRID_SE_PRICE_RX_TIER5_BLOCK1    0x8450
#define ATTRID_SE_PRICE_RX_TIER5_BLOCK2    0x8451
#define ATTRID_SE_PRICE_RX_TIER5_BLOCK3    0x8452
#define ATTRID_SE_PRICE_RX_TIER5_BLOCK4    0x8453
#define ATTRID_SE_PRICE_RX_TIER5_BLOCK5    0x8454
#define ATTRID_SE_PRICE_RX_TIER5_BLOCK6    0x8455
#define ATTRID_SE_PRICE_RX_TIER5_BLOCK7    0x8456
#define ATTRID_SE_PRICE_RX_TIER5_BLOCK8    0x8457
#define ATTRID_SE_PRICE_RX_TIER5_BLOCK9    0x8458
#define ATTRID_SE_PRICE_RX_TIER5_BLOCK10   0x8459
#define ATTRID_SE_PRICE_RX_TIER5_BLOCK11   0x845A
#define ATTRID_SE_PRICE_RX_TIER5_BLOCK12   0x845B
#define ATTRID_SE_PRICE_RX_TIER5_BLOCK13   0x845C
#define ATTRID_SE_PRICE_RX_TIER5_BLOCK14   0x845D
#define ATTRID_SE_PRICE_RX_TIER5_BLOCK15   0x845E
#define ATTRID_SE_PRICE_RX_TIER5_BLOCK16   0x845F
// Tier 6
#define ATTRID_SE_PRICE_RX_TIER6_BLOCK1    0x8460
#define ATTRID_SE_PRICE_RX_TIER6_BLOCK2    0x8461
#define ATTRID_SE_PRICE_RX_TIER6_BLOCK3    0x8462
#define ATTRID_SE_PRICE_RX_TIER6_BLOCK4    0x8463
#define ATTRID_SE_PRICE_RX_TIER6_BLOCK5    0x8464
#define ATTRID_SE_PRICE_RX_TIER6_BLOCK6    0x8465
#define ATTRID_SE_PRICE_RX_TIER6_BLOCK7    0x8466
#define ATTRID_SE_PRICE_RX_TIER6_BLOCK8    0x8467
#define ATTRID_SE_PRICE_RX_TIER6_BLOCK9    0x8468
#define ATTRID_SE_PRICE_RX_TIER6_BLOCK10   0x8469
#define ATTRID_SE_PRICE_RX_TIER6_BLOCK11   0x846A
#define ATTRID_SE_PRICE_RX_TIER6_BLOCK12   0x846B
#define ATTRID_SE_PRICE_RX_TIER6_BLOCK13   0x846C
#define ATTRID_SE_PRICE_RX_TIER6_BLOCK14   0x846D
#define ATTRID_SE_PRICE_RX_TIER6_BLOCK15   0x846E
#define ATTRID_SE_PRICE_RX_TIER6_BLOCK16   0x846F
// Tier 7
#define ATTRID_SE_PRICE_RX_TIER7_BLOCK1    0x8470
#define ATTRID_SE_PRICE_RX_TIER7_BLOCK2    0x8471
#define ATTRID_SE_PRICE_RX_TIER7_BLOCK3    0x8472
#define ATTRID_SE_PRICE_RX_TIER7_BLOCK4    0x8473
#define ATTRID_SE_PRICE_RX_TIER7_BLOCK5    0x8474
#define ATTRID_SE_PRICE_RX_TIER7_BLOCK6    0x8475
#define ATTRID_SE_PRICE_RX_TIER7_BLOCK7    0x8476
#define ATTRID_SE_PRICE_RX_TIER7_BLOCK8    0x8477
#define ATTRID_SE_PRICE_RX_TIER7_BLOCK9    0x8478
#define ATTRID_SE_PRICE_RX_TIER7_BLOCK10   0x8479
#define ATTRID_SE_PRICE_RX_TIER7_BLOCK11   0x847A
#define ATTRID_SE_PRICE_RX_TIER7_BLOCK12   0x847B
#define ATTRID_SE_PRICE_RX_TIER7_BLOCK13   0x847C
#define ATTRID_SE_PRICE_RX_TIER7_BLOCK14   0x847D
#define ATTRID_SE_PRICE_RX_TIER7_BLOCK15   0x847E
#define ATTRID_SE_PRICE_RX_TIER7_BLOCK16   0x847F
// Tier 8
#define ATTRID_SE_PRICE_RX_TIER8_BLOCK1    0x8480
#define ATTRID_SE_PRICE_RX_TIER8_BLOCK2    0x8481
#define ATTRID_SE_PRICE_RX_TIER8_BLOCK3    0x8482
#define ATTRID_SE_PRICE_RX_TIER8_BLOCK4    0x8483
#define ATTRID_SE_PRICE_RX_TIER8_BLOCK5    0x8484
#define ATTRID_SE_PRICE_RX_TIER8_BLOCK6    0x8485
#define ATTRID_SE_PRICE_RX_TIER8_BLOCK7    0x8486
#define ATTRID_SE_PRICE_RX_TIER8_BLOCK8    0x8487
#define ATTRID_SE_PRICE_RX_TIER8_BLOCK9    0x8488
#define ATTRID_SE_PRICE_RX_TIER8_BLOCK10   0x8489
#define ATTRID_SE_PRICE_RX_TIER8_BLOCK11   0x848A
#define ATTRID_SE_PRICE_RX_TIER8_BLOCK12   0x848B
#define ATTRID_SE_PRICE_RX_TIER8_BLOCK13   0x848C
#define ATTRID_SE_PRICE_RX_TIER8_BLOCK14   0x848D
#define ATTRID_SE_PRICE_RX_TIER8_BLOCK15   0x848E
#define ATTRID_SE_PRICE_RX_TIER8_BLOCK16   0x848F
// Tier 9
#define ATTRID_SE_PRICE_RX_TIER9_BLOCK1    0x8490
#define ATTRID_SE_PRICE_RX_TIER9_BLOCK2    0x8491
#define ATTRID_SE_PRICE_RX_TIER9_BLOCK3    0x8492
#define ATTRID_SE_PRICE_RX_TIER9_BLOCK4    0x8493
#define ATTRID_SE_PRICE_RX_TIER9_BLOCK5    0x8494
#define ATTRID_SE_PRICE_RX_TIER9_BLOCK6    0x8495
#define ATTRID_SE_PRICE_RX_TIER9_BLOCK7    0x8496
#define ATTRID_SE_PRICE_RX_TIER9_BLOCK8    0x8497
#define ATTRID_SE_PRICE_RX_TIER9_BLOCK9    0x8498
#define ATTRID_SE_PRICE_RX_TIER9_BLOCK10   0x8499
#define ATTRID_SE_PRICE_RX_TIER9_BLOCK11   0x849A
#define ATTRID_SE_PRICE_RX_TIER9_BLOCK12   0x849B
#define ATTRID_SE_PRICE_RX_TIER9_BLOCK13   0x849C
#define ATTRID_SE_PRICE_RX_TIER9_BLOCK14   0x849D
#define ATTRID_SE_PRICE_RX_TIER9_BLOCK15   0x849E
#define ATTRID_SE_PRICE_RX_TIER9_BLOCK16   0x849F
// Tier 10
#define ATTRID_SE_PRICE_RX_TIER10_BLOCK1   0x84A0
#define ATTRID_SE_PRICE_RX_TIER10_BLOCK2   0x84A1
#define ATTRID_SE_PRICE_RX_TIER10_BLOCK3   0x84A2
#define ATTRID_SE_PRICE_RX_TIER10_BLOCK4   0x84A3
#define ATTRID_SE_PRICE_RX_TIER10_BLOCK5   0x84A4
#define ATTRID_SE_PRICE_RX_TIER10_BLOCK6   0x84A5
#define ATTRID_SE_PRICE_RX_TIER10_BLOCK7   0x84A6
#define ATTRID_SE_PRICE_RX_TIER10_BLOCK8   0x84A7
#define ATTRID_SE_PRICE_RX_TIER10_BLOCK9   0x84A8
#define ATTRID_SE_PRICE_RX_TIER10_BLOCK10  0x84A9
#define ATTRID_SE_PRICE_RX_TIER10_BLOCK11  0x84AA
#define ATTRID_SE_PRICE_RX_TIER10_BLOCK12  0x84AB
#define ATTRID_SE_PRICE_RX_TIER10_BLOCK13  0x84AC
#define ATTRID_SE_PRICE_RX_TIER10_BLOCK14  0x84AD
#define ATTRID_SE_PRICE_RX_TIER10_BLOCK15  0x84AE
#define ATTRID_SE_PRICE_RX_TIER10_BLOCK16  0x84AF
// Tier 11
#define ATTRID_SE_PRICE_RX_TIER11_BLOCK1   0x84B0
#define ATTRID_SE_PRICE_RX_TIER11_BLOCK2   0x84B1
#define ATTRID_SE_PRICE_RX_TIER11_BLOCK3   0x84B2
#define ATTRID_SE_PRICE_RX_TIER11_BLOCK4   0x84B3
#define ATTRID_SE_PRICE_RX_TIER11_BLOCK5   0x84B4
#define ATTRID_SE_PRICE_RX_TIER11_BLOCK6   0x84B5
#define ATTRID_SE_PRICE_RX_TIER11_BLOCK7   0x84B6
#define ATTRID_SE_PRICE_RX_TIER11_BLOCK8   0x84B7
#define ATTRID_SE_PRICE_RX_TIER11_BLOCK9   0x84B8
#define ATTRID_SE_PRICE_RX_TIER11_BLOCK10  0x84B9
#define ATTRID_SE_PRICE_RX_TIER11_BLOCK11  0x84BA
#define ATTRID_SE_PRICE_RX_TIER11_BLOCK12  0x84BB
#define ATTRID_SE_PRICE_RX_TIER11_BLOCK13  0x84BC
#define ATTRID_SE_PRICE_RX_TIER11_BLOCK14  0x84BD
#define ATTRID_SE_PRICE_RX_TIER11_BLOCK15  0x84BE
#define ATTRID_SE_PRICE_RX_TIER11_BLOCK16  0x84BF
// Tier 12
#define ATTRID_SE_PRICE_RX_TIER12_BLOCK1   0x84C0
#define ATTRID_SE_PRICE_RX_TIER12_BLOCK2   0x84C1
#define ATTRID_SE_PRICE_RX_TIER12_BLOCK3   0x84C2
#define ATTRID_SE_PRICE_RX_TIER12_BLOCK4   0x84C3
#define ATTRID_SE_PRICE_RX_TIER12_BLOCK5   0x84C4
#define ATTRID_SE_PRICE_RX_TIER12_BLOCK6   0x84C5
#define ATTRID_SE_PRICE_RX_TIER12_BLOCK7   0x84C6
#define ATTRID_SE_PRICE_RX_TIER12_BLOCK8   0x84C7
#define ATTRID_SE_PRICE_RX_TIER12_BLOCK9   0x84C8
#define ATTRID_SE_PRICE_RX_TIER12_BLOCK10  0x84C9
#define ATTRID_SE_PRICE_RX_TIER12_BLOCK11  0x84CA
#define ATTRID_SE_PRICE_RX_TIER12_BLOCK12  0x84CB
#define ATTRID_SE_PRICE_RX_TIER12_BLOCK13  0x84CC
#define ATTRID_SE_PRICE_RX_TIER12_BLOCK14  0x84CD
#define ATTRID_SE_PRICE_RX_TIER12_BLOCK15  0x84CE
#define ATTRID_SE_PRICE_RX_TIER12_BLOCK16  0x84CF
// Tier 13
#define ATTRID_SE_PRICE_RX_TIER13_BLOCK1   0x84D0
#define ATTRID_SE_PRICE_RX_TIER13_BLOCK2   0x84D1
#define ATTRID_SE_PRICE_RX_TIER13_BLOCK3   0x84D2
#define ATTRID_SE_PRICE_RX_TIER13_BLOCK4   0x84D3
#define ATTRID_SE_PRICE_RX_TIER13_BLOCK5   0x84D4
#define ATTRID_SE_PRICE_RX_TIER13_BLOCK6   0x84D5
#define ATTRID_SE_PRICE_RX_TIER13_BLOCK7   0x84D6
#define ATTRID_SE_PRICE_RX_TIER13_BLOCK8   0x84D7
#define ATTRID_SE_PRICE_RX_TIER13_BLOCK9   0x84D8
#define ATTRID_SE_PRICE_RX_TIER13_BLOCK10  0x84D9
#define ATTRID_SE_PRICE_RX_TIER13_BLOCK11  0x84DA
#define ATTRID_SE_PRICE_RX_TIER13_BLOCK12  0x84DB
#define ATTRID_SE_PRICE_RX_TIER13_BLOCK13  0x84DC
#define ATTRID_SE_PRICE_RX_TIER13_BLOCK14  0x84DD
#define ATTRID_SE_PRICE_RX_TIER13_BLOCK15  0x84DE
#define ATTRID_SE_PRICE_RX_TIER13_BLOCK16  0x84DF
// Tier 14
#define ATTRID_SE_PRICE_RX_TIER14_BLOCK1   0x84E0
#define ATTRID_SE_PRICE_RX_TIER14_BLOCK2   0x84E1
#define ATTRID_SE_PRICE_RX_TIER14_BLOCK3   0x84E2
#define ATTRID_SE_PRICE_RX_TIER14_BLOCK4   0x84E3
#define ATTRID_SE_PRICE_RX_TIER14_BLOCK5   0x84E4
#define ATTRID_SE_PRICE_RX_TIER14_BLOCK6   0x84E5
#define ATTRID_SE_PRICE_RX_TIER14_BLOCK7   0x84E6
#define ATTRID_SE_PRICE_RX_TIER14_BLOCK8   0x84E7
#define ATTRID_SE_PRICE_RX_TIER14_BLOCK9   0x84E8
#define ATTRID_SE_PRICE_RX_TIER14_BLOCK10  0x84E9
#define ATTRID_SE_PRICE_RX_TIER14_BLOCK11  0x84EA
#define ATTRID_SE_PRICE_RX_TIER14_BLOCK12  0x84EB
#define ATTRID_SE_PRICE_RX_TIER14_BLOCK13  0x84EC
#define ATTRID_SE_PRICE_RX_TIER14_BLOCK14  0x84ED
#define ATTRID_SE_PRICE_RX_TIER14_BLOCK15  0x84EE
#define ATTRID_SE_PRICE_RX_TIER14_BLOCK16  0x84EF
// Tier 15
#define ATTRID_SE_PRICE_RX_TIER15_BLOCK1   0x84F0
#define ATTRID_SE_PRICE_RX_TIER15_BLOCK2   0x84F1
#define ATTRID_SE_PRICE_RX_TIER15_BLOCK3   0x84F2
#define ATTRID_SE_PRICE_RX_TIER15_BLOCK4   0x84F3
#define ATTRID_SE_PRICE_RX_TIER15_BLOCK5   0x84F4
#define ATTRID_SE_PRICE_RX_TIER15_BLOCK6   0x84F5
#define ATTRID_SE_PRICE_RX_TIER15_BLOCK7   0x84F6
#define ATTRID_SE_PRICE_RX_TIER15_BLOCK8   0x84F7
#define ATTRID_SE_PRICE_RX_TIER15_BLOCK9   0x84F8
#define ATTRID_SE_PRICE_RX_TIER15_BLOCK10  0x84F9
#define ATTRID_SE_PRICE_RX_TIER15_BLOCK11  0x84FA
#define ATTRID_SE_PRICE_RX_TIER15_BLOCK12  0x84FB
#define ATTRID_SE_PRICE_RX_TIER15_BLOCK13  0x84FC
#define ATTRID_SE_PRICE_RX_TIER15_BLOCK14  0x84FD
#define ATTRID_SE_PRICE_RX_TIER15_BLOCK15  0x84FE
#define ATTRID_SE_PRICE_RX_TIER15_BLOCK16  0x84FF

//==== Received Extended Price Information Attribute Set ====
#define ATTRID_SE_PRICE_RCVD_TIER16 0x850F
#define ATTRID_SE_PRICE_RCVD_TIER17 0x8510
#define ATTRID_SE_PRICE_RCVD_TIER18 0x8511
#define ATTRID_SE_PRICE_RCVD_TIER19 0x8512
#define ATTRID_SE_PRICE_RCVD_TIER20 0x8513
#define ATTRID_SE_PRICE_RCVD_TIER21 0x8514
#define ATTRID_SE_PRICE_RCVD_TIER22 0x8515
#define ATTRID_SE_PRICE_RCVD_TIER23 0x8516
#define ATTRID_SE_PRICE_RCVD_TIER24 0x8517
#define ATTRID_SE_PRICE_RCVD_TIER25 0x8518
#define ATTRID_SE_PRICE_RCVD_TIER26 0x8519
#define ATTRID_SE_PRICE_RCVD_TIER27 0x851A
#define ATTRID_SE_PRICE_RCVD_TIER28 0x851B
#define ATTRID_SE_PRICE_RCVD_TIER29 0x851C
#define ATTRID_SE_PRICE_RCVD_TIER30 0x851D
#define ATTRID_SE_PRICE_RCVD_TIER31 0x851E
#define ATTRID_SE_PRICE_RCVD_TIER32 0x851F
#define ATTRID_SE_PRICE_RCVD_TIER33 0x8520
#define ATTRID_SE_PRICE_RCVD_TIER34 0x8521
#define ATTRID_SE_PRICE_RCVD_TIER35 0x8522
#define ATTRID_SE_PRICE_RCVD_TIER36 0x8523
#define ATTRID_SE_PRICE_RCVD_TIER37 0x8524
#define ATTRID_SE_PRICE_RCVD_TIER38 0x8525
#define ATTRID_SE_PRICE_RCVD_TIER39 0x8526
#define ATTRID_SE_PRICE_RCVD_TIER40 0x8527
#define ATTRID_SE_PRICE_RCVD_TIER41 0x8528
#define ATTRID_SE_PRICE_RCVD_TIER42 0x8529
#define ATTRID_SE_PRICE_RCVD_TIER43 0x852A
#define ATTRID_SE_PRICE_RCVD_TIER44 0x852B
#define ATTRID_SE_PRICE_RCVD_TIER45 0x852C
#define ATTRID_SE_PRICE_RCVD_TIER46 0x852D
#define ATTRID_SE_PRICE_RCVD_TIER47 0x852E
#define ATTRID_SE_PRICE_RCVD_TIER48 0x852F

//==== Received Tariff Information Attribute Set ====
#define ATTRID_SE_PRICE_RCVD_TARIFF_LABEL                0x8610
#define ATTRID_SE_PRICE_RCVD_NUM_PRICE_TIERS_IN_USE      0x8611
#define ATTRID_SE_PRICE_RCVD_NUM_BLOCK_THRESHOLDS_IN_USE 0x8612
#define ATTRID_SE_PRICE_RCVD_TIER_BLOCK_MODE             0x8613
#define ATTRID_SE_PRICE_RCVD_TARIFF_RESOLUTION_PERIOD    0x8615
#define ATTRID_SE_PRICE_RCVD_CO2                         0x8625
#define ATTRID_SE_PRICE_RCVD_CO2_UNIT                    0x8626
#define ATTRID_SE_PRICE_RCVD_CO2_TRAILING_DIGIT          0x8627

//==== Received Billing Information Attribute Set ====
#define ATTRID_SE_PRICE_RCVD_CURR_BILL_PERIOD_START             0x8700
#define ATTRID_SE_PRICE_RCVD_CURR_BILL_PERIOD_DURATION          0x8701
#define ATTRID_SE_PRICE_RCVD_LAST_BILL_PERIOD_START             0x8702
#define ATTRID_SE_PRICE_RCVD_LAST_BILL_PERIOD_DURATION          0x8703
#define ATTRID_SE_PRICE_RCVD_LAST_BILL_PERIOD_CONSOLIDATED_BILL 0x8704

//==== Price Client Cluster Attribute Set ====
#define ATTRID_SE_PRICE_PRICE_INCREASE_RAND_MINUTES 0x0000
#define ATTRID_SE_PRICE_PRICE_DECREASE_RAND_MINUTES 0x0001
#define ATTRID_SE_PRICE_COMMODITY                   0x0002

//=================================================================================================
// Messaging Attributes(ZCL_CLUSTER_ID_SE_MESSAGING)
//=================================================================================================
// No Attributes

//=================================================================================================
// Tunneling Attributes(ZCL_CLUSTER_ID_SE_TUNNELING)
//=================================================================================================
// Server Attributes Set
#define ATTRID_SE_TUNNELING_CLOSE_TUNNEL_TIMEOUT  0x0000

//=================================================================================================
// Prepayment Attributes(ZCL_CLUSTER_ID_SE_PREPAYMENT)
//=================================================================================================
//==== Prepayment Information Attribute Set ====
#define ATTRID_SE_PREPAYMENT_PAYMENT_CTRL_CFG             0x0000
#define ATTRID_SE_PREPAYMENT_CREDIT_REMAINING             0x0001
#define ATTRID_SE_PREPAYMENT_EMRGNCY_CREDIT_REMAINING     0x0002
#define ATTRID_SE_PREPAYMENT_CREDIT_STATUS                0x0003
#define ATTRID_SE_PREPAYMENT_CREDIT_REMAINING_TIME_STAMP  0x0004
#define ATTRID_SE_PREPAYMENT_ACCUM_DEBT                   0x0005
#define ATTRID_SE_PREPAYMENT_OVERALL_DEBT_CAP             0x0006
#define ATTRID_SE_PREPAYMENT_EMRGNCY_CREDIT_LIMIT         0x0010
#define ATTRID_SE_PREPAYMENT_EMRGNCY_CREDIT_THRESHOLD     0x0011
#define ATTRID_SE_PREPAYMENT_TOTAL_CREDIT_ADDED           0x0020
#define ATTRID_SE_PREPAYMENT_MAX_CREDIT_LIMIT             0x0021
#define ATTRID_SE_PREPAYMENT_MAX_CREDIT_PER_TOP_UP        0x0022
#define ATTRID_SE_PREPAYMENT_FRNDLY_CREDIT_WARN           0x0030
#define ATTRID_SE_PREPAYMENT_LOW_CREDIT_WARN              0x0031
#define ATTRID_SE_PREPAYMENT_IHD_LOW_CREDIT_WARN          0x0032
#define ATTRID_SE_PREPAYMENT_INTERRUPT_SUSPEND_TIME       0x0033
#define ATTRID_SE_PREPAYMENT_REMAINING_FRNDLY_CREDIT_TIME 0x0034
#define ATTRID_SE_PREPAYMENT_NEXT_FRNDLY_CREDIT_PERIOD    0x0035
#define ATTRID_SE_PREPAYMENT_CUTOFF_VALUE                 0x0040
#define ATTRID_SE_PREPAYMENT_TOKEN_CARR_ID                0x0080

//==== Top-up Attribute Set ====
#define ATTRID_SE_PREPAYMENT_TOP_UP1_DATE_TIME   0x0100
#define ATTRID_SE_PREPAYMENT_TOP_UP1_AMNT        0x0101
#define ATTRID_SE_PREPAYMENT_TOP_UP1_ORIG_DEVICE 0x0102
#define ATTRID_SE_PREPAYMENT_TOP_UP1_CODE        0x0103
#define ATTRID_SE_PREPAYMENT_TOP_UP2_DATE_TIME   0x0110
#define ATTRID_SE_PREPAYMENT_TOP_UP2_AMNT        0x0111
#define ATTRID_SE_PREPAYMENT_TOP_UP2_ORIG_DEVICE 0x0112
#define ATTRID_SE_PREPAYMENT_TOP_UP2_CODE        0x0113
#define ATTRID_SE_PREPAYMENT_TOP_UP3_DATE_TIME   0x0120
#define ATTRID_SE_PREPAYMENT_TOP_UP3_AMNT        0x0121
#define ATTRID_SE_PREPAYMENT_TOP_UP3_ORIG_DEVICE 0x0122
#define ATTRID_SE_PREPAYMENT_TOP_UP3_CODE        0x0123
#define ATTRID_SE_PREPAYMENT_TOP_UP4_DATE_TIME   0x0130
#define ATTRID_SE_PREPAYMENT_TOP_UP4_AMNT        0x0131
#define ATTRID_SE_PREPAYMENT_TOP_UP4_ORIG_DEVICE 0x0132
#define ATTRID_SE_PREPAYMENT_TOP_UP4_CODE        0x0133
#define ATTRID_SE_PREPAYMENT_TOP_UP5_DATE_TIME   0x0140
#define ATTRID_SE_PREPAYMENT_TOP_UP5_AMNT        0x0141
#define ATTRID_SE_PREPAYMENT_TOP_UP5_ORIG_DEVICE 0x0142
#define ATTRID_SE_PREPAYMENT_TOP_UP5_CODE        0x0143

//==== Debt Attribute Set ====
#define ATTRID_SE_PREPAYMENT_DEBT1_LABEL               0x0210
#define ATTRID_SE_PREPAYMENT_DEBT1_AMNT                0x0211
#define ATTRID_SE_PREPAYMENT_DEBT1_RECOVERY_METHOD     0x0212
#define ATTRID_SE_PREPAYMENT_DEBT1_RECOVERY_START_TIME 0x0213
#define ATTRID_SE_PREPAYMENT_DEBT1_RECOVERY_COLL_TIME  0x0214
#define ATTRID_SE_PREPAYMENT_DEBT1_RECOVERY_FREQ       0x0216
#define ATTRID_SE_PREPAYMENT_DEBT1_RECOVERY_AMNT       0x0217
#define ATTRID_SE_PREPAYMENT_DEBT1_RECOVERY_TOP_UP_PCT 0x0219
#define ATTRID_SE_PREPAYMENT_DEBT2_LABEL               0x0220
#define ATTRID_SE_PREPAYMENT_DEBT2_AMNT                0x0221
#define ATTRID_SE_PREPAYMENT_DEBT2_RECOVERY_METHOD     0x0222
#define ATTRID_SE_PREPAYMENT_DEBT2_RECOVERY_START_TIME 0x0223
#define ATTRID_SE_PREPAYMENT_DEBT2_RECOVERY_COLL_TIME  0x0224
#define ATTRID_SE_PREPAYMENT_DEBT2_RECOVERY_FREQ       0x0226
#define ATTRID_SE_PREPAYMENT_DEBT2_RECOVERY_AMNT       0x0227
#define ATTRID_SE_PREPAYMENT_DEBT2_RECOVERY_TOP_UP_PCT 0x0229
#define ATTRID_SE_PREPAYMENT_DEBT3_LABEL               0x0230
#define ATTRID_SE_PREPAYMENT_DEBT3_AMNT                0x0231
#define ATTRID_SE_PREPAYMENT_DEBT3_RECOVERY_METHOD     0x0232
#define ATTRID_SE_PREPAYMENT_DEBT3_RECOVERY_START_TIME 0x0233
#define ATTRID_SE_PREPAYMENT_DEBT3_RECOVERY_COLL_TIME  0x0234
#define ATTRID_SE_PREPAYMENT_DEBT3_RECOVERY_FREQ       0x0236
#define ATTRID_SE_PREPAYMENT_DEBT3_RECOVERY_AMNT       0x0237
#define ATTRID_SE_PREPAYMENT_DEBT3_RECOVERY_TOP_UP_PCT 0x0239

//==== Alarms Attribute Set ====
#define ATTRID_SE_PREPAYMENT_ALARM_STATUS       0x0400
#define ATTRID_SE_PREPAYMENT_GENERIC_ALARM_MASK 0x0401
#define ATTRID_SE_PREPAYMENT_SWITCH_ALARM_MASK  0x0402
#define ATTRID_SE_PREPAYMENT_EVT_ALARM_MASK     0x0403

//==== Historical Cost Consumption Information Attribute Set ====
#define ATTRID_SE_PREPAYMENT_HIST_COST_CONSUMP_FMTG         0x0500
#define ATTRID_SE_PREPAYMENT_CONSUMP_UOM                    0x0501
#define ATTRID_SE_PREPAYMENT_CURRENCY_SCALING_FACTOR        0x0502
#define ATTRID_SE_PREPAYMENT_CURRENCY                       0x0503
#define ATTRID_SE_PREPAYMENT_CURR_DAY_COST_CONSUMP_DLVD     0x051C
#define ATTRID_SE_PREPAYMENT_CURR_DAY_COST_CONSUMP_RCVD     0x051D
#define ATTRID_SE_PREPAYMENT_PREV_DAY_COST_CONSUMP_DLVD     0x051E
#define ATTRID_SE_PREPAYMENT_PREV_DAY_COST_CONSUMP_RCVD     0x051F
#define ATTRID_SE_PREPAYMENT_PREV_DAY2_COST_CONSUMP_DLVD    0x0520
#define ATTRID_SE_PREPAYMENT_PREV_DAY2_COST_CONSUMP_RCVD    0x0521
#define ATTRID_SE_PREPAYMENT_PREV_DAY3_COST_CONSUMP_DLVD    0x0522
#define ATTRID_SE_PREPAYMENT_PREV_DAY3_COST_CONSUMP_RCVD    0x0523
#define ATTRID_SE_PREPAYMENT_PREV_DAY4_COST_CONSUMP_DLVD    0x0524
#define ATTRID_SE_PREPAYMENT_PREV_DAY4_COST_CONSUMP_RCVD    0x0525
#define ATTRID_SE_PREPAYMENT_PREV_DAY5_COST_CONSUMP_DLVD    0x0526
#define ATTRID_SE_PREPAYMENT_PREV_DAY5_COST_CONSUMP_RCVD    0x0527
#define ATTRID_SE_PREPAYMENT_PREV_DAY6_COST_CONSUMP_DLVD    0x0528
#define ATTRID_SE_PREPAYMENT_PREV_DAY6_COST_CONSUMP_RCVD    0x0529
#define ATTRID_SE_PREPAYMENT_PREV_DAY7_COST_CONSUMP_DLVD    0x052A
#define ATTRID_SE_PREPAYMENT_PREV_DAY7_COST_CONSUMP_RCVD    0x052B
#define ATTRID_SE_PREPAYMENT_PREV_DAY8_COST_CONSUMP_DLVD    0x052C
#define ATTRID_SE_PREPAYMENT_PREV_DAY8_COST_CONSUMP_RCVD    0x052D
#define ATTRID_SE_PREPAYMENT_CURR_WEEK_COST_CONSUMP_DLVD    0x0530
#define ATTRID_SE_PREPAYMENT_CURR_WEEK_COST_CONSUMP_RCVD    0x0531
#define ATTRID_SE_PREPAYMENT_PREV_WEEK_COST_CONSUMP_DLVD    0x0532
#define ATTRID_SE_PREPAYMENT_PREV_WEEK_COST_CONSUMP_RCVD    0x0533
#define ATTRID_SE_PREPAYMENT_PREV_WEEK2_COST_CONSUMP_DLVD   0x0534
#define ATTRID_SE_PREPAYMENT_PREV_WEEK2_COST_CONSUMP_RCVD   0x0535
#define ATTRID_SE_PREPAYMENT_PREV_WEEK3_COST_CONSUMP_DLVD   0x0536
#define ATTRID_SE_PREPAYMENT_PREV_WEEK3_COST_CONSUMP_RCVD   0x0537
#define ATTRID_SE_PREPAYMENT_PREV_WEEK4_COST_CONSUMP_DLVD   0x0538
#define ATTRID_SE_PREPAYMENT_PREV_WEEK4_COST_CONSUMP_RCVD   0x0539
#define ATTRID_SE_PREPAYMENT_PREV_WEEK5_COST_CONSUMP_DLVD   0x053A
#define ATTRID_SE_PREPAYMENT_PREV_WEEK5_COST_CONSUMP_RCVD   0x053B
#define ATTRID_SE_PREPAYMENT_CURR_MONTH_COST_CONSUMP_DLVD   0x0540
#define ATTRID_SE_PREPAYMENT_CURR_MONTH_COST_CONSUMP_RCVD   0x0541
#define ATTRID_SE_PREPAYMENT_PREV_MONTH_COST_CONSUMP_DLVD   0x0542
#define ATTRID_SE_PREPAYMENT_PREV_MONTH_COST_CONSUMP_RCVD   0x0543
#define ATTRID_SE_PREPAYMENT_PREV_MONTH2_COST_CONSUMP_DLVD  0x0544
#define ATTRID_SE_PREPAYMENT_PREV_MONTH2_COST_CONSUMP_RCVD  0x0545
#define ATTRID_SE_PREPAYMENT_PREV_MONTH3_COST_CONSUMP_DLVD  0x0546
#define ATTRID_SE_PREPAYMENT_PREV_MONTH3_COST_CONSUMP_RCVD  0x0547
#define ATTRID_SE_PREPAYMENT_PREV_MONTH4_COST_CONSUMP_DLVD  0x0548
#define ATTRID_SE_PREPAYMENT_PREV_MONTH4_COST_CONSUMP_RCVD  0x0549
#define ATTRID_SE_PREPAYMENT_PREV_MONTH5_COST_CONSUMP_DLVD  0x054A
#define ATTRID_SE_PREPAYMENT_PREV_MONTH5_COST_CONSUMP_RCVD  0x054B
#define ATTRID_SE_PREPAYMENT_PREV_MONTH6_COST_CONSUMP_DLVD  0x054C
#define ATTRID_SE_PREPAYMENT_PREV_MONTH6_COST_CONSUMP_RCVD  0x054D
#define ATTRID_SE_PREPAYMENT_PREV_MONTH7_COST_CONSUMP_DLVD  0x054E
#define ATTRID_SE_PREPAYMENT_PREV_MONTH7_COST_CONSUMP_RCVD  0x054F
#define ATTRID_SE_PREPAYMENT_PREV_MONTH8_COST_CONSUMP_DLVD  0x0550
#define ATTRID_SE_PREPAYMENT_PREV_MONTH8_COST_CONSUMP_RCVD  0x0551
#define ATTRID_SE_PREPAYMENT_PREV_MONTH9_COST_CONSUMP_DLVD  0x0552
#define ATTRID_SE_PREPAYMENT_PREV_MONTH9_COST_CONSUMP_RCVD  0x0553
#define ATTRID_SE_PREPAYMENT_PREV_MONTH10_COST_CONSUMP_DLVD 0x0554
#define ATTRID_SE_PREPAYMENT_PREV_MONTH10_COST_CONSUMP_RCVD 0x0555
#define ATTRID_SE_PREPAYMENT_PREV_MONTH11_COST_CONSUMP_DLVD 0x0556
#define ATTRID_SE_PREPAYMENT_PREV_MONTH11_COST_CONSUMP_RCVD 0x0557
#define ATTRID_SE_PREPAYMENT_PREV_MONTH12_COST_CONSUMP_DLVD 0x0558
#define ATTRID_SE_PREPAYMENT_PREV_MONTH12_COST_CONSUMP_RCVD 0x0559
#define ATTRID_SE_PREPAYMENT_PREV_MONTH13_COST_CONSUMP_DLVD 0x055A
#define ATTRID_SE_PREPAYMENT_PREV_MONTH13_COST_CONSUMP_RCVD 0x055B
#define ATTRID_SE_PREPAYMENT_HIST_FREEZE_TIME               0x055C

//=================================================================================================
// Calendar Attributes(ZCL_CLUSTER_ID_SE_CALENDAR)
//=================================================================================================
//==== Auxiliary Switch Label Attribute Set ====
#define ATTRID_SE_CALENDAR_AUX_SWITCH1_LABEL 0x0000
#define ATTRID_SE_CALENDAR_AUX_SWITCH2_LABEL 0x0001
#define ATTRID_SE_CALENDAR_AUX_SWITCH3_LABEL 0x0002
#define ATTRID_SE_CALENDAR_AUX_SWITCH4_LABEL 0x0003
#define ATTRID_SE_CALENDAR_AUX_SWITCH5_LABEL 0x0004
#define ATTRID_SE_CALENDAR_AUX_SWITCH6_LABEL 0x0005
#define ATTRID_SE_CALENDAR_AUX_SWITCH7_LABEL 0x0006
#define ATTRID_SE_CALENDAR_AUX_SWITCH8_LABEL 0x0007

//=================================================================================================
// DeviceMgmt Attributes(ZCL_CLUSTER_ID_SE_DEVICE_MGMT)
//=================================================================================================
//==== Supplier Control Attribute Set ====
#define ATTRID_SE_DEVICE_MGMT_PROVIDER_ID                         0x0100
#define ATTRID_SE_DEVICE_MGMT_PROVIDER_NAME                       0x0101
#define ATTRID_SE_DEVICE_MGMT_PROVIDER_CONTACT_DETAILS            0x0102
#define ATTRID_SE_DEVICE_MGMT_PROP_PROVIDER_ID                    0x0110
#define ATTRID_SE_DEVICE_MGMT_PROP_PROVIDER_NAME                  0x0111
#define ATTRID_SE_DEVICE_MGMT_PROP_PROVIDER_CHANGE_DATE_TIME      0x0112
#define ATTRID_SE_DEVICE_MGMT_PROP_PROVIDER_CHANGE_CTRL           0x0113
#define ATTRID_SE_DEVICE_MGMT_PROP_PROVIDER_CONTACT_DETAILS       0x0114
#define ATTRID_SE_DEVICE_MGMT_RCVD_PROVIDER_ID                    0x0120
#define ATTRID_SE_DEVICE_MGMT_RCVD_PROVIDER_NAME                  0x0121
#define ATTRID_SE_DEVICE_MGMT_RCVD_PROVIDER_CONTACT_DETAILS       0x0122
#define ATTRID_SE_DEVICE_MGMT_RCVD_PROP_PROVIDER_ID               0x0130
#define ATTRID_SE_DEVICE_MGMT_RCVD_PROP_PROVIDER_NAME             0x0131
#define ATTRID_SE_DEVICE_MGMT_RCVD_PROP_PROVIDER_CHANGE_DATE_TIME 0x0132
#define ATTRID_SE_DEVICE_MGMT_RCVD_PROP_PROVIDER_CHANGE_CTRL      0x0133
#define ATTRID_SE_DEVICE_MGMT_RCVD_PROP_PROVIDER_CONTACT_DETAILS  0x0134

//==== Tenancy Control Attribute Set ====
#define ATTRID_SE_DEVICE_MGMT_CHANGE_OF_TENANCY_UPDATE_DATE_TIME 0x0200
#define ATTRID_SE_DEVICE_MGMT_PROP_TENANCY_CHANGE_CTRL           0x0201

//==== Backhaul Control Attribute Set ====
#define ATTRID_SE_DEVICE_MGMT_WAN_STATUS 0x0300

//==== HAN Control Attribute Set ====
#define ATTRID_SE_DEVICE_MGMT_LOW_MED_THRESHOLD  0x0400
#define ATTRID_SE_DEVICE_MGMT_MED_HIGH_THRESHOLD 0x0401

//==== Supplier Attribute Set ====
#define ATTRID_SE_DEVICE_MGMT_SUPP_PROVIDER_ID      0x0000
#define ATTRID_SE_DEVICE_MGMT_SUPP_RCVD_PROVIDER_ID 0x0010

// ZCL_SE_DEVICE_MGMT_EVT_CFG_ATTRS (0x0100 - 0x08FF)
// see Price Event Configuration Attribute Set
// see Metering Event Configuration Attribute Set
// see Messaging Event Configuration Attribute Set
// see Prepay Event Configuration Attribute Set
// see Calendar Event Configuration Attribute set
// see Device Management Event Confguration Attribute
// see Tunnel Event Configuration Attribute Set
// see OTA Event Configuration Attribute Set

//==== Price Event Configuration Attribute Set ====
#define ATTRID_SE_DEVICE_MGMT_TOU_TARIFF_ACTIVATION                 0x0100
#define ATTRID_SE_DEVICE_MGMT_BLOCK_TARIFF_ACTIVATED                0x0101
#define ATTRID_SE_DEVICE_MGMT_BLOCK_TOU_TARIFF_ACTIVATED            0x0102
#define ATTRID_SE_DEVICE_MGMT_SINGLE_TARIFF_RATE_ACTIVATED          0x0103
#define ATTRID_SE_DEVICE_MGMT_ASYNCH_BILL_OCCURRED                  0x0104
#define ATTRID_SE_DEVICE_MGMT_SYNCH_BILL_OCCURRED                   0x0105
#define ATTRID_SE_DEVICE_MGMT_TARIFF_NOT_SUPP                       0x0106
#define ATTRID_SE_DEVICE_MGMT_PRICE_CLUSTER_NOT_FOUND               0x0107
#define ATTRID_SE_DEVICE_MGMT_CURRENCY_CHANGE_PASSIVE_ACTIVATED     0x0108
#define ATTRID_SE_DEVICE_MGMT_CURRENCY_CHANGE_PASSIVE_UPDATED       0x0109
#define ATTRID_SE_DEVICE_MGMT_PRICE_MATRIX_PASSIVE_ACTIVATED        0x010A
#define ATTRID_SE_DEVICE_MGMT_PRICE_MATRIX_PASSIVE_UPDATED          0x010B
#define ATTRID_SE_DEVICE_MGMT_TARIFF_CHANGE_PASSIVE_ACTIVATED       0x010C
#define ATTRID_SE_DEVICE_MGMT_TARIFF_CHANGE_PASSIVE_UPDATED         0x010D
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_PRICE_RCVD                    0x01B0
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_PRICE_ACTIONED                0x01B1
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_PRICE_CANCELLED               0x01B2
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_PRICE_REJECTED                0x01B3
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_TARIFF_INFO_RCVD              0x01B4
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_TARIFF_INFO_ACTIONED          0x01B5
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_TARIFF_INFO_CANCELLED         0x01B6
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_TARIFF_INFO_REJECTED          0x01B7
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_PRICE_MATRIX_RCVD             0x01B8
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_PRICE_MATRIX_ACTIONED         0x01B9
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_PRICE_MATRIX_CANCELLED        0x01BA
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_PRICE_MATRIX_REJECTED         0x01BB
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_BLOCK_THRESHOLDS_RCVD         0x01BC
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_BLOCK_THRESHOLDS_ACTIONED     0x01BD
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_BLOCK_THRESHOLDS_CANCELLED    0x01BE
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_BLOCK_THRESHOLDS_REJECTED     0x01BF
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_CALORIFIC_VALUE_RCVD          0x01C0
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_CALORIFIC_VALUE_ACTIONED      0x01C1
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_CALORIFIC_VALUE_CANCELLED     0x01C2
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_CALORIFIC_VALUE_REJECTED      0x01C3
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_CONVERSION_FACTOR_RCVD        0x01C4
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_CONVERSION_FACTOR_ACTIONED    0x01C5
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_CONVERSION_FACTOR_CANCELLED   0x01C6
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_CONVERSION_FACTOR_REJECTED    0x01C7
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_CO2_VALUE_RCVD                0x01C8
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_CO2_VALUE_ACTIONED            0x01C9
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_CO2_VALUE_CANCELLED           0x01CA
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_CO2_VALUE_REJECTED            0x01CB
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_CPP_EVT_RCVD                  0x01CC
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_CPP_EVT_ACTIONED              0x01CD
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_CPP_EVT_CANCELLED             0x01CE
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_CPP_EVT_REJECTED              0x01CF
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_TIER_LABELS_RCVD              0x01D0
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_TIER_LABELS_ACTIONED          0x01D1
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_TIER_LABELS_CANCELLED         0x01D2
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_TIER_LABELS_REJECTED          0x01D3
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_BILL_PERIOD_RCVD              0x01D4
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_BILL_PERIOD_ACTIONED          0x01D5
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_BILL_PERIOD_CANCELLED         0x01D6
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_BILL_PERIOD_REJECTED          0x01D7
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_CONSOLIDATED_BILL_RCVD        0x01D8
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_CONSOLIDATED_BILL_ACTIONED    0x01D9
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_CONSOLIDATED_BILL_CANCELLED   0x01DA
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_CONSOLIDATED_BILL_REJECTED    0x01DB
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_BLOCK_PERIOD_RCVD             0x01DC
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_BLOCK_PERIOD_ACTIONED         0x01DD
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_BLOCK_PERIOD_CANCELLED        0x01DE
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_BLOCK_PERIOD_REJECTED         0x01DF
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_CREDIT_PAYMENT_INFO_RCVD      0x01E0
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_CREDIT_PAYMENT_INFO_ACTIONED  0x01E1
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_CREDIT_PAYMENT_INFO_CANCELLED 0x01E2
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_CREDIT_PAYMENT_INFO_REJECTED  0x01E3
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_CURRENCY_CONVERSION_RCVD      0x01E4
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_CURRENCY_CONVERSION_ACTIONED  0x01E5
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_CURRENCY_CONVERSION_CANCELLED 0x01E6
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_CURRENCY_CONVERSION_REJECTED  0x01E7
#define ATTRID_SE_DEVICE_MGMT_PRICE_CLUSTER_GROUP_ID                0x01FF

//==== Metering Event Configuration Attribute Set ====
#define ATTRID_SE_DEVICE_MGMT_CHK_METER                                0x0200
#define ATTRID_SE_DEVICE_MGMT_LOW_BATT                                 0x0201
#define ATTRID_SE_DEVICE_MGMT_TAMPER_DETECT                            0x0202
#define ATTRID_SE_DEVICE_MGMT_SUPPLY_STATUS                            0x0203
#define ATTRID_SE_DEVICE_MGMT_SUPPLY_QUALITY                           0x0204
#define ATTRID_SE_DEVICE_MGMT_LEAK_DETECT                              0x0205
#define ATTRID_SE_DEVICE_MGMT_SVC_DISCONNECT                           0x0206
#define ATTRID_SE_DEVICE_MGMT_FLOW                                     0x0207
#define ATTRID_SE_DEVICE_MGMT_METER_COVER_REMOVED                      0x0208
#define ATTRID_SE_DEVICE_MGMT_METER_COVER_CLOSED                       0x0209
#define ATTRID_SE_DEVICE_MGMT_STRONG_MAG_FLD                           0x020A
#define ATTRID_SE_DEVICE_MGMT_NO_STRONG_MAG_FLD                        0x020B
#define ATTRID_SE_DEVICE_MGMT_BATT_FAIL                                0x020C
#define ATTRID_SE_DEVICE_MGMT_PROG_MEM_ERR                             0x020D
#define ATTRID_SE_DEVICE_MGMT_RAM_ERR                                  0x020E
#define ATTRID_SE_DEVICE_MGMT_NV_MEM_ERR                               0x020F
#define ATTRID_SE_DEVICE_MGMT_LOW_VOLTAGE_L1                           0x0210
#define ATTRID_SE_DEVICE_MGMT_HIGH_VOLTAGE_L1                          0x0211
#define ATTRID_SE_DEVICE_MGMT_LOW_VOLTAGE_L2                           0x0212
#define ATTRID_SE_DEVICE_MGMT_HIGH_VOLTAGE_L2                          0x0213
#define ATTRID_SE_DEVICE_MGMT_LOW_VOLTAGE_L3                           0x0214
#define ATTRID_SE_DEVICE_MGMT_HIGH_VOLTAGE_L3                          0x0215
#define ATTRID_SE_DEVICE_MGMT_OVER_CURR_L1                             0x0216
#define ATTRID_SE_DEVICE_MGMT_OVER_CURR_L2                             0x0217
#define ATTRID_SE_DEVICE_MGMT_OVER_CURR_L3                             0x0218
#define ATTRID_SE_DEVICE_MGMT_FREQ_LOW_L1                              0x0219
#define ATTRID_SE_DEVICE_MGMT_FREQ_HIGH_L1                             0x021A
#define ATTRID_SE_DEVICE_MGMT_FREQ_LOW_L2                              0x021B
#define ATTRID_SE_DEVICE_MGMT_FREQ_HIGH_L2                             0x021C
#define ATTRID_SE_DEVICE_MGMT_FREQ_LOW_L3                              0x021D
#define ATTRID_SE_DEVICE_MGMT_FREQ_HIGH_L3                             0x021E
#define ATTRID_SE_DEVICE_MGMT_GRND_FAULT                               0x021F
#define ATTRID_SE_DEVICE_MGMT_ELEC_TAMPER_DETECT                       0x0220
#define ATTRID_SE_DEVICE_MGMT_INCORRECT_POLARITY                       0x0221
#define ATTRID_SE_DEVICE_MGMT_CURR_NO_VOLTAGE                          0x0222
#define ATTRID_SE_DEVICE_MGMT_UNDER_VOLTAGE                            0x0223
#define ATTRID_SE_DEVICE_MGMT_OVER_VOLTAGE                             0x0224
#define ATTRID_SE_DEVICE_MGMT_NORM_VOLTAGE                             0x0225
#define ATTRID_SE_DEVICE_MGMT_PF_BELOW_THRESHOLD                       0x0226
#define ATTRID_SE_DEVICE_MGMT_PF_ABOVE_THRESHOLD                       0x0227
#define ATTRID_SE_DEVICE_MGMT_TERMINAL_COVER_REMOVED                   0x0228
#define ATTRID_SE_DEVICE_MGMT_TERMINAL_COVER_CLOSED                    0x0229
#define ATTRID_SE_DEVICE_MGMT_BURST_DETECT                             0x0230
#define ATTRID_SE_DEVICE_MGMT_PRESSURE_LOW                             0x0231
#define ATTRID_SE_DEVICE_MGMT_PRESSURE_HIGH                            0x0232
#define ATTRID_SE_DEVICE_MGMT_FLOW_SENSOR_COMM_ERR                     0x0233
#define ATTRID_SE_DEVICE_MGMT_FLOW_SENSOR_MEASUREMENT_FAULT            0x0234
#define ATTRID_SE_DEVICE_MGMT_FLOW_SENSOR_REVERSE_FLOW                 0x0235
#define ATTRID_SE_DEVICE_MGMT_FLOW_SENSOR_AIR_DETECT                   0x0236
#define ATTRID_SE_DEVICE_MGMT_PIPE_EMPTY                               0x0237
#define ATTRID_SE_DEVICE_MGMT_INLET_TEMP_SENSOR_FAULT                  0x0250
#define ATTRID_SE_DEVICE_MGMT_OUTLET_TEMP_SENSOR_FAULT                 0x0251
#define ATTRID_SE_DEVICE_MGMT_REVERSE_FLOW                             0x0260
#define ATTRID_SE_DEVICE_MGMT_TILT_TAMPER                              0x0261
#define ATTRID_SE_DEVICE_MGMT_BATT_COVER_REMOVED                       0x0262
#define ATTRID_SE_DEVICE_MGMT_BATT_COVER_CLOSED                        0x0263
#define ATTRID_SE_DEVICE_MGMT_EXCESS_FLOW                              0x0264
#define ATTRID_SE_DEVICE_MGMT_TILT_TAMPER_ENDED                        0x0265
#define ATTRID_SE_DEVICE_MGMT_MEASUREMENT_SYS_ERR                      0x0270
#define ATTRID_SE_DEVICE_MGMT_WATCHDOG_ERR                             0x0271
#define ATTRID_SE_DEVICE_MGMT_SUPPLY_DISCONNECT_FAIL                   0x0272
#define ATTRID_SE_DEVICE_MGMT_SUPPLY_CONNECT_FAIL                      0x0273
#define ATTRID_SE_DEVICE_MGMT_MEASUREMENT_SW_CHANGED                   0x0274
#define ATTRID_SE_DEVICE_MGMT_DST_ENABLED                              0x0275
#define ATTRID_SE_DEVICE_MGMT_DST_DISABLED                             0x0276
#define ATTRID_SE_DEVICE_MGMT_CLK_ADJ_BACK                             0x0277
#define ATTRID_SE_DEVICE_MGMT_CLK_ADJ_FWD                              0x0278
#define ATTRID_SE_DEVICE_MGMT_CLK_INVALID                              0x0279
#define ATTRID_SE_DEVICE_MGMT_COMM_ERR_HAN                             0x027A
#define ATTRID_SE_DEVICE_MGMT_COMM_OK_HAN                              0x027B
#define ATTRID_SE_DEVICE_MGMT_METER_FRAUD_ATTEMPT                      0x027C
#define ATTRID_SE_DEVICE_MGMT_PWR_LOSS                                 0x027D
#define ATTRID_SE_DEVICE_MGMT_UNUSUAL_HAN_TRAFFIC                      0x027E
#define ATTRID_SE_DEVICE_MGMT_UNEXPECTED_CLK_CHANGE                    0x027F
#define ATTRID_SE_DEVICE_MGMT_COMMS_UNAUTH_COMPONENT                   0x0280
#define ATTRID_SE_DEVICE_MGMT_METERING_ERR_REG_CLEAR                   0x0281
#define ATTRID_SE_DEVICE_MGMT_METERING_ALARM_REG_CLEAR                 0x0282
#define ATTRID_SE_DEVICE_MGMT_UNEXPECTED_HW_RESET                      0x0283
#define ATTRID_SE_DEVICE_MGMT_UNEXPECTED_PROG_EXECUTION                0x0284
#define ATTRID_SE_DEVICE_MGMT_LIMIT_THRESHOLD_EXCDED                   0x0285
#define ATTRID_SE_DEVICE_MGMT_LIMIT_THRESHOLD_OK                       0x0286
#define ATTRID_SE_DEVICE_MGMT_LIMIT_THRESHOLD_CHANGED                  0x0287
#define ATTRID_SE_DEVICE_MGMT_MAX_DMD_EXCDED                           0x0288
#define ATTRID_SE_DEVICE_MGMT_PROFILE_CLEARED                          0x0289
#define ATTRID_SE_DEVICE_MGMT_LOAD_PROFILE_CLEARED                     0x028A
#define ATTRID_SE_DEVICE_MGMT_BATT_WARN                                0x028B
#define ATTRID_SE_DEVICE_MGMT_WRONG_SIGNATURE                          0x028C
#define ATTRID_SE_DEVICE_MGMT_NO_SIGNATURE                             0x028D
#define ATTRID_SE_DEVICE_MGMT_SIGNATURE_NOT_VALID                      0x028E
#define ATTRID_SE_DEVICE_MGMT_UNAUTH_ACTION_HAN                        0x028F
#define ATTRID_SE_DEVICE_MGMT_FAST_POLL_START                          0x0290
#define ATTRID_SE_DEVICE_MGMT_FAST_POLL_END                            0x0291
#define ATTRID_SE_DEVICE_MGMT_METER_REPORTING_INTERVAL_CHANGED         0x0292
#define ATTRID_SE_DEVICE_MGMT_DISCONNECT_LOAD_LIMIT                    0x0293
#define ATTRID_SE_DEVICE_MGMT_METER_SUPPLY_STATUS_REG_CHANGED          0x0294
#define ATTRID_SE_DEVICE_MGMT_METER_ALARM_STATUS_REG_CHANGED           0x0295
#define ATTRID_SE_DEVICE_MGMT_EXT_METER_ALARM_STATUS_REG_CHANGED       0x0296
#define ATTRID_SE_DEVICE_MGMT_DATA_ACCESS_LOCAL_PORT                   0x0297
#define ATTRID_SE_DEVICE_MGMT_CFG_MIRR_SUCCESS                         0x0298
#define ATTRID_SE_DEVICE_MGMT_CFG_MIRR_FAIL                            0x0299
#define ATTRID_SE_DEVICE_MGMT_CFG_NOTIF_FLAG_SCHEME_SUCCESS            0x029A
#define ATTRID_SE_DEVICE_MGMT_CFG_NOTIF_FLAG_SCHEME_FAIL               0x029B
#define ATTRID_SE_DEVICE_MGMT_CFG_NOTIF_FLAGS_SUCCESS                  0x029C
#define ATTRID_SE_DEVICE_MGMT_CFG_NOTIF_FLAGS_FAIL                     0x029D
#define ATTRID_SE_DEVICE_MGMT_STAY_AWAKE_REQ_HAN                       0x029E
#define ATTRID_SE_DEVICE_MGMT_STAY_AWAKE_REQ_WAN                       0x029F
#define ATTRID_SE_DEVICE_MGMT_MANU_SPECIFIC_A                          0x02B0
#define ATTRID_SE_DEVICE_MGMT_MANU_SPECIFIC_B                          0x02B1
#define ATTRID_SE_DEVICE_MGMT_MANU_SPECIFIC_C                          0x02B2
#define ATTRID_SE_DEVICE_MGMT_MANU_SPECIFIC_D                          0x02B3
#define ATTRID_SE_DEVICE_MGMT_MANU_SPECIFIC_E                          0x02B4
#define ATTRID_SE_DEVICE_MGMT_MANU_SPECIFIC_F                          0x02B5
#define ATTRID_SE_DEVICE_MGMT_MANU_SPECIFIC_G                          0x02B6
#define ATTRID_SE_DEVICE_MGMT_MANU_SPECIFIC_H                          0x02B7
#define ATTRID_SE_DEVICE_MGMT_MANU_SPECIFIC_I                          0x02B8
#define ATTRID_SE_DEVICE_MGMT_GET_PROFILE_CMD_RCVD                     0x02C0
#define ATTRID_SE_DEVICE_MGMT_GET_PROFILE_CMD_ACTIONED                 0x02C1
#define ATTRID_SE_DEVICE_MGMT_GET_PROFILE_CMD_CANCELLED                0x02C2
#define ATTRID_SE_DEVICE_MGMT_GET_PROFILE_CMD_REJECTED                 0x02C3
#define ATTRID_SE_DEVICE_MGMT_REQ_MIRR_RSP_CMD_RCVD                    0x02C4
#define ATTRID_SE_DEVICE_MGMT_REQ_MIRR_RSP_CMD_ACTIONED                0x02C5
#define ATTRID_SE_DEVICE_MGMT_REQ_MIRR_RSP_CMD_CANCELLED               0x02C6
#define ATTRID_SE_DEVICE_MGMT_REQ_MIRR_RSP_CMD_REJECTED                0x02C7
#define ATTRID_SE_DEVICE_MGMT_MIRR_REMOVED_CMD_RCVD                    0x02C8
#define ATTRID_SE_DEVICE_MGMT_MIRR_REMOVED_CMD_ACTIONED                0x02C9
#define ATTRID_SE_DEVICE_MGMT_MIRR_REMOVED_CMD_CANCELLED               0x02CA
#define ATTRID_SE_DEVICE_MGMT_MIRR_REMOVED_CMD_REJECTED                0x02CB
#define ATTRID_SE_DEVICE_MGMT_GET_SNAPSHOT_CMD_RCVD                    0x02CC
#define ATTRID_SE_DEVICE_MGMT_GET_SNAPSHOT_CMD_ACTIONED                0x02CD
#define ATTRID_SE_DEVICE_MGMT_GET_SNAPSHOT_CMD_CANCELLED               0x02CE
#define ATTRID_SE_DEVICE_MGMT_GET_SNAPSHOT_CMD_REJECTED                0x02CF
#define ATTRID_SE_DEVICE_MGMT_TAKE_SNAPSHOT_CMD_RCVD                   0x02D0
#define ATTRID_SE_DEVICE_MGMT_TAKE_SNAPSHOT_CMD_ACTIONED               0x02D1
#define ATTRID_SE_DEVICE_MGMT_TAKE_SNAPSHOT_CMD_CANCELLED              0x02D2
#define ATTRID_SE_DEVICE_MGMT_TAKE_SNAPSHOT_CMD_REJECTED               0x02D3
#define ATTRID_SE_DEVICE_MGMT_MIRR_REPORT_ATTR_RSP_CMD_RCVD            0x02D4
#define ATTRID_SE_DEVICE_MGMT_MIRR_REPORT_ATTR_RSP_CMD_ACTIONED        0x02D5
#define ATTRID_SE_DEVICE_MGMT_MIRR_REPORT_ATTR_RSP_CMD_CANCELLED       0x02D6
#define ATTRID_SE_DEVICE_MGMT_MIRR_REPORT_ATTR_RSP_CMD_REJECTED        0x02D7
#define ATTRID_SE_DEVICE_MGMT_SCHEDULE_SNAPSHOT_CMD_RCVD               0x02D8
#define ATTRID_SE_DEVICE_MGMT_SCHEDULE_SNAPSHOT_CMD_ACTIONED           0x02D9
#define ATTRID_SE_DEVICE_MGMT_SCHEDULE_SNAPSHOT_CMD_CANCELLED          0x02DA
#define ATTRID_SE_DEVICE_MGMT_SCHEDULE_SNAPSHOT_CMD_REJECTED           0x02DB
#define ATTRID_SE_DEVICE_MGMT_START_SAMPLING_CMD_RCVD                  0x02DC
#define ATTRID_SE_DEVICE_MGMT_START_SAMPLING_CMD_ACTIONED              0x02DD
#define ATTRID_SE_DEVICE_MGMT_START_SAMPLING_CMD_CANCELLED             0x02DE
#define ATTRID_SE_DEVICE_MGMT_START_SAMPLING_CMD_REJECTED              0x02DF
#define ATTRID_SE_DEVICE_MGMT_GET_SAMPLED_DATA_CMD_RCVD                0x02E0
#define ATTRID_SE_DEVICE_MGMT_GET_SAMPLED_DATA_CMD_ACTIONED            0x02E1
#define ATTRID_SE_DEVICE_MGMT_GET_SAMPLED_DATA_CMD_CANCELLED           0x02E2
#define ATTRID_SE_DEVICE_MGMT_GET_SAMPLED_DATA_CMD_REJECTED            0x02E3
#define ATTRID_SE_DEVICE_MGMT_SUPPLY_ON                                0x02E4
#define ATTRID_SE_DEVICE_MGMT_SUPPLY_ARMED                             0x02E5
#define ATTRID_SE_DEVICE_MGMT_SUPPLY_OFF                               0x02E6
#define ATTRID_SE_DEVICE_MGMT_DISCONNECT_TAMPER_DETECTED               0x02E7
#define ATTRID_SE_DEVICE_MGMT_MANUAL_DISCONNECT                        0x02E8
#define ATTRID_SE_DEVICE_MGMT_MANUAL_CONNECT                           0x02E9
#define ATTRID_SE_DEVICE_MGMT_RMT_DISCONNECT                           0x02EA
#define ATTRID_SE_DEVICE_MGMT_RMT_CONNECT                              0x02EB
#define ATTRID_SE_DEVICE_MGMT_LOCAL_DISCONNECT                         0x02EC
#define ATTRID_SE_DEVICE_MGMT_LOCAL_CONNECT                            0x02ED
#define ATTRID_SE_DEVICE_MGMT_CHANGE_SUPPLY_RCVD                       0x02EE
#define ATTRID_SE_DEVICE_MGMT_CHANGE_SUPPLY_ACTIONED                   0x02EF
#define ATTRID_SE_DEVICE_MGMT_CHANGE_SUPPLY_CANCELLED                  0x02F0
#define ATTRID_SE_DEVICE_MGMT_CHANGE_SUPPLY_REJECTED                   0x02F1
#define ATTRID_SE_DEVICE_MGMT_LOCAL_CHANGE_SUPPLY_RCVD                 0x02F2
#define ATTRID_SE_DEVICE_MGMT_LOCAL_CHANGE_SUPPLY_ACTIONED             0x02F3
#define ATTRID_SE_DEVICE_MGMT_LOCAL_CHANGE_SUPPLY_CANCELLED            0x02F4
#define ATTRID_SE_DEVICE_MGMT_LOCAL_CHANGE_SUPPLY_REJECTED             0x02F5
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_UNCTRLD_FLOW_THRESHOLD_RCVD      0x02F6
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_UNCTRLD_FLOW_THRESHOLD_ACTIONED  0x02F7
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_UNCTRLD_FLOW_THRESHOLD_CANCELLED 0x02F8
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_UNCTRLD_FLOW_THRESHOLD_REJECTED  0x02F9
#define ATTRID_SE_DEVICE_MGMT_METERING_CLUSTER_GROUP_ID                0x02FF

//==== Messaging Event Configuration Attribute Set ====
#define ATTRID_SE_DEVICE_MGMT_MSG_CFM_SENT               0x0300
#define ATTRID_SE_DEVICE_MGMT_DISPLAY_MSG_RCVD           0x03C0
#define ATTRID_SE_DEVICE_MGMT_DISPLAY_MSG_ACTIONED       0x03C1
#define ATTRID_SE_DEVICE_MGMT_DISPLAY_MSG_CANCELLED      0x03C2
#define ATTRID_SE_DEVICE_MGMT_DISPLAY_MSG_REJECTED       0x03C3
#define ATTRID_SE_DEVICE_MGMT_CANCEL_MSG_RCVD            0x03C4
#define ATTRID_SE_DEVICE_MGMT_CANCEL_MSG_ACTIONED        0x03C5
#define ATTRID_SE_DEVICE_MGMT_CANCEL_MSG_CANCELLED       0x03C6
#define ATTRID_SE_DEVICE_MGMT_CANCEL_MSG_REJECTED        0x03C7
#define ATTRID_SE_DEVICE_MGMT_MESSAGING_CLUSTER_GROUP_ID 0x03FF

//==== Prepay Event Configuration Attribute Set ====
#define ATTRID_SE_DEVICE_MGMT_LOW_CREDIT                          0x0400
#define ATTRID_SE_DEVICE_MGMT_NO_CREDIT                           0x0401
#define ATTRID_SE_DEVICE_MGMT_CREDIT_EXHAUSTED                    0x0402
#define ATTRID_SE_DEVICE_MGMT_EMRGNCY_CREDIT_ENABLED              0x0403
#define ATTRID_SE_DEVICE_MGMT_EMRGNCY_CREDIT_EXHAUSTED            0x0404
#define ATTRID_SE_DEVICE_MGMT_IHD_LOW_CREDIT_WARN                 0x0405
#define ATTRID_SE_DEVICE_MGMT_PHYSICAL_ATTACK_ON_METER            0x0420
#define ATTRID_SE_DEVICE_MGMT_ELECTRONIC_ATTACK_ON_METER          0x0421
#define ATTRID_SE_DEVICE_MGMT_DISCOUNT_APPLIED                    0x0422
#define ATTRID_SE_DEVICE_MGMT_CREDIT_ADJ                          0x0423
#define ATTRID_SE_DEVICE_MGMT_CREDIT_ADJ_FAIL                     0x0424
#define ATTRID_SE_DEVICE_MGMT_DEBT_ADJ                            0x0425
#define ATTRID_SE_DEVICE_MGMT_DEBT_ADJ_FAIL                       0x0426
#define ATTRID_SE_DEVICE_MGMT_MODE_CHANGE                         0x0427
#define ATTRID_SE_DEVICE_MGMT_TOP_UP_CODE_ERR                     0x0428
#define ATTRID_SE_DEVICE_MGMT_TOP_UP_USED                         0x0429
#define ATTRID_SE_DEVICE_MGMT_TOP_UP_CODE_INVALID                 0x042A
#define ATTRID_SE_DEVICE_MGMT_TOP_UP_ACCEPTED_RMT                 0x042B
#define ATTRID_SE_DEVICE_MGMT_TOP_UP_ACCEPTED_MANUAL              0x042C
#define ATTRID_SE_DEVICE_MGMT_FRNDLY_CREDIT_IN_USE                0x042D
#define ATTRID_SE_DEVICE_MGMT_FRNDLY_CREDIT_PERIOD_END_WARN       0x042E
#define ATTRID_SE_DEVICE_MGMT_FRNDLY_CREDIT_PERIOD_END            0x042F
#define ATTRID_SE_DEVICE_MGMT_PREPAY_ERR_REG_CLEAR                0x0430
#define ATTRID_SE_DEVICE_MGMT_PREPAY_ALARM_REG_CLEAR              0x0431
#define ATTRID_SE_DEVICE_MGMT_PREPAY_CLUSTER_NOT_FOUND            0x0432
#define ATTRID_SE_DEVICE_MGMT_TOP_UP_VALUE_LRG                    0x0433
#define ATTRID_SE_DEVICE_MGMT_MODE_CREDIT_2_PREPAY                0x0441
#define ATTRID_SE_DEVICE_MGMT_MODE_PREPAY_2_CREDIT                0x0442
#define ATTRID_SE_DEVICE_MGMT_MODE_DEFAULT                        0x0443
#define ATTRID_SE_DEVICE_MGMT_SEL_AVAIL_EMRGNCY_CREDIT_RCVD       0x04C0
#define ATTRID_SE_DEVICE_MGMT_SEL_AVAIL_EMRGNCY_CREDIT_ACTIONED   0x04C1
#define ATTRID_SE_DEVICE_MGMT_SEL_AVAIL_EMRGNCY_CREDIT_CANCELLED  0x04C2
#define ATTRID_SE_DEVICE_MGMT_SEL_AVAIL_EMRGNCY_CREDIT_REJECTED   0x04C3
#define ATTRID_SE_DEVICE_MGMT_CHANGE_DEBT_RCVD                    0x04C4
#define ATTRID_SE_DEVICE_MGMT_CHANGE_DEBT_ACTIONED                0x04C5
#define ATTRID_SE_DEVICE_MGMT_CHANGE_DEBT_CANCELLED               0x04C6
#define ATTRID_SE_DEVICE_MGMT_CHANGE_DEBT_REJECTED                0x04C7
#define ATTRID_SE_DEVICE_MGMT_EMRGNCY_CREDIT_SETUP_RCVD           0x04C8
#define ATTRID_SE_DEVICE_MGMT_EMRGNCY_CREDIT_SETUP_ACTIONED       0x04C9
#define ATTRID_SE_DEVICE_MGMT_EMRGNCY_CREDIT_SETUP_CANCELLED      0x04CA
#define ATTRID_SE_DEVICE_MGMT_EMRGNCY_CREDIT_SETUP_REJECTED       0x04CB
#define ATTRID_SE_DEVICE_MGMT_CONSUMER_TOP_UP_RCVD                0x04CC
#define ATTRID_SE_DEVICE_MGMT_CONSUMER_TOP_UP_ACTIONED            0x04CD
#define ATTRID_SE_DEVICE_MGMT_CONSUMER_TOP_UP_CANCELLED           0x04CE
#define ATTRID_SE_DEVICE_MGMT_CONSUMER_TOP_UP_REJECTED            0x04CF
#define ATTRID_SE_DEVICE_MGMT_CREDIT_ADJ_RCVD                     0x04D0
#define ATTRID_SE_DEVICE_MGMT_CREDIT_ADJ_ACTIONED                 0x04D1
#define ATTRID_SE_DEVICE_MGMT_CREDIT_ADJ_CANCELLED                0x04D2
#define ATTRID_SE_DEVICE_MGMT_CREDIT_ADJ_REJECTED                 0x04D3
#define ATTRID_SE_DEVICE_MGMT_CHANGE_PAYMENT_MODE_RCVD            0x04D4
#define ATTRID_SE_DEVICE_MGMT_CHANGE_PAYMENT_MODE_ACTIONED        0x04D5
#define ATTRID_SE_DEVICE_MGMT_CHANGE_PAYMENT_MODE_CANCELLED       0x04D6
#define ATTRID_SE_DEVICE_MGMT_CHANGE_PAYMENT_MODE_REJECTED        0x04D7
#define ATTRID_SE_DEVICE_MGMT_GET_PREPAY_SNAPSHOT_RCVD            0x04D8
#define ATTRID_SE_DEVICE_MGMT_GET_PREPAY_SNAPSHOT_ACTIONED        0x04D9
#define ATTRID_SE_DEVICE_MGMT_GET_PREPAY_SNAPSHOT_CANCELLED       0x04DA
#define ATTRID_SE_DEVICE_MGMT_GET_PREPAY_SNAPSHOT_REJECTED        0x04DB
#define ATTRID_SE_DEVICE_MGMT_GET_TOP_UP_LOG_RCVD                 0x04DC
#define ATTRID_SE_DEVICE_MGMT_GET_TOP_UP_LOG_ACTIONED             0x04DD
#define ATTRID_SE_DEVICE_MGMT_GET_TOP_UP_LOG_CANCELLED            0x04DE
#define ATTRID_SE_DEVICE_MGMT_GET_TOP_UP_LOG_REJECTED             0x04DF
#define ATTRID_SE_DEVICE_MGMT_SET_LOW_CREDIT_WARN_LEVEL_RCVD      0x04E0
#define ATTRID_SE_DEVICE_MGMT_SET_LOW_CREDIT_WARN_LEVEL_ACTIONED  0x04E1
#define ATTRID_SE_DEVICE_MGMT_SET_LOW_CREDIT_WARN_LEVEL_CANCELLED 0x04E2
#define ATTRID_SE_DEVICE_MGMT_SET_LOW_CREDIT_WARN_LEVEL_REJECTED  0x04E3
#define ATTRID_SE_DEVICE_MGMT_GET_DEBT_REPAY_LOG_RCVD             0x04E4
#define ATTRID_SE_DEVICE_MGMT_GET_DEBT_REPAY_LOG_ACTIONED         0x04E5
#define ATTRID_SE_DEVICE_MGMT_GET_DEBT_REPAY_LOG_CANCELLED        0x04E6
#define ATTRID_SE_DEVICE_MGMT_GET_DEBT_REPAY_LOG_REJECTED         0x04E7
#define ATTRID_SE_DEVICE_MGMT_SET_MAX_CREDIT_LIMIT_RCVD           0x04E8
#define ATTRID_SE_DEVICE_MGMT_SET_MAX_CREDIT_LIMIT_ACTIONED       0x04E9
#define ATTRID_SE_DEVICE_MGMT_SET_MAX_CREDIT_LIMIT_CANCELLED      0x04EA
#define ATTRID_SE_DEVICE_MGMT_SET_MAX_CREDIT_LIMIT_REJECTED       0x04EB
#define ATTRID_SE_DEVICE_MGMT_SET_OVERALL_DEBT_CAP_RCVD           0x04EC
#define ATTRID_SE_DEVICE_MGMT_SET_OVERALL_DEBT_CAP_ACTIONED       0x04ED
#define ATTRID_SE_DEVICE_MGMT_SET_OVERALL_DEBT_CAP_CANCELLED      0x04EE
#define ATTRID_SE_DEVICE_MGMT_SET_OVERALL_DEBT_CAP_REJECTED       0x04EF
#define ATTRID_SE_DEVICE_MGMT_PREPAYMENT_CLUSTER_GROUP_ID         0x04FF

//==== Calendar Event Configuration Attribute set ====
#define ATTRID_SE_DEVICE_MGMT_CALENDAR_CLUSTER_NOT_FOUND        0x0500
#define ATTRID_SE_DEVICE_MGMT_CALENDAR_CHANGE_PASSIVE_ACTIVATED 0x0501
#define ATTRID_SE_DEVICE_MGMT_CALENDAR_CHANGE_PASSIVE_UPDATED   0x0502
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_CALENDAR_RCVD             0x05C0
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_CALENDAR_ACTIONED         0x05C1
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_CALENDAR_CANCELLED        0x05C2
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_CALENDAR_REJECTED         0x05C3
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_DAY_PROFILE_RCVD          0x05C4
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_DAY_PROFILE_ACTIONED      0x05C5
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_DAY_PROFILE_CANCELLED     0x05C6
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_DAY_PROFILE_REJECTED      0x05C7
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_WEEK_PROFILE_RCVD         0x05C8
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_WEEK_PROFILE_ACTIONED     0x05C9
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_WEEK_PROFILE_CANCELLED    0x05CA
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_WEEK_PROFILE_REJECTED     0x05CB
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_SEASONS_RCVD              0x05CC
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_SEASONS_ACTIONED          0x05CD
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_SEASONS_CANCELLED         0x05CE
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_SEASONS_REJECTED          0x05CF
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_SPECIAL_DAYS_RCVD         0x05D0
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_SPECIAL_DAYS_ACTIONED     0x05D1
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_SPECIAL_DAYS_CANCELLED    0x05D2
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_SPECIAL_DAYS_REJECTED     0x05D3
#define ATTRID_SE_DEVICE_MGMT_CALENDAR_CLUSTER_GROUP_ID         0x05FF

//==== Device Management Event Confguration Attribute Set ====
#define ATTRID_SE_DEVICE_MGMT_PW1_CHANGE                     0x0600
#define ATTRID_SE_DEVICE_MGMT_PW2_CHANGE                     0x0601
#define ATTRID_SE_DEVICE_MGMT_PW3_CHANGE                     0x0602
#define ATTRID_SE_DEVICE_MGMT_PW4_CHANGE                     0x0603
#define ATTRID_SE_DEVICE_MGMT_EVT_LOG_CLEARED                0x0604
#define ATTRID_SE_DEVICE_MGMT_ZB_APS_TIMEOUT                 0x0610
#define ATTRID_SE_DEVICE_MGMT_ZB_IEEE_TX_FAIL_OVER_THRESHOLD 0x0611
#define ATTRID_SE_DEVICE_MGMT_ZB_IEEE_FRM_CHK_SEQ_THRESHOLD  0x0612
#define ATTRID_SE_DEVICE_MGMT_ERR_CERT                       0x0613
#define ATTRID_SE_DEVICE_MGMT_ERR_SIGNATURE                  0x0614
#define ATTRID_SE_DEVICE_MGMT_ERR_PROG_STORAGE               0x0615
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_COT_RCVD               0x06C0
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_COT_ACTIONED           0x06C1
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_COT_CANCELLED          0x06C2
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_COT_REJECTED           0x06C3
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_COS_RCVD               0x06C4
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_COS_ACTIONED           0x06C5
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_COS_CANCELLED          0x06C6
#define ATTRID_SE_DEVICE_MGMT_PUBLISH_COS_REJECTED           0x06C7
#define ATTRID_SE_DEVICE_MGMT_CHANGE_PW_RCVD                 0x06C8
#define ATTRID_SE_DEVICE_MGMT_CHANGE_PW_ACTIONED             0x06C9
#define ATTRID_SE_DEVICE_MGMT_CHANGE_PW_CANCELLED            0x06CA
#define ATTRID_SE_DEVICE_MGMT_CHANGE_PW_REJECTED             0x06CB
#define ATTRID_SE_DEVICE_MGMT_SET_EVT_CFG_RCVD               0x06CC
#define ATTRID_SE_DEVICE_MGMT_SET_EVT_CFG_ACTIONED           0x06CD
#define ATTRID_SE_DEVICE_MGMT_SET_EVT_CFG_CANCELLED          0x06CE
#define ATTRID_SE_DEVICE_MGMT_SET_EVT_CFG_REJECTED           0x06CF
#define ATTRID_SE_DEVICE_MGMT_UPDATE_SITE_ID_RCVD            0x06D0
#define ATTRID_SE_DEVICE_MGMT_UPDATE_SITE_ID_ACTIONED        0x06D1
#define ATTRID_SE_DEVICE_MGMT_UPDATE_SITE_ID_CANCELLED       0x06D2
#define ATTRID_SE_DEVICE_MGMT_UPDATE_SITE_ID_REJECTED        0x06D3
#define ATTRID_SE_DEVICE_MGMT_UPDATE_CIN_RCVD                0x06D4
#define ATTRID_SE_DEVICE_MGMT_UPDATE_CIN_ACTIONED            0x06D5
#define ATTRID_SE_DEVICE_MGMT_UPDATE_CIN_CANCELLED           0x06D6
#define ATTRID_SE_DEVICE_MGMT_UPDATE_CIN_REJECTED            0x06D7
#define ATTRID_SE_DEVICE_MGMT_CLUSTER_GROUP_ID               0x06FF

//==== Tunnel Event Configuration Attribute Set ====
#define ATTRID_SE_DEVICE_MGMT_TUNNELING_CLUSTER_NOT_FOUND             0x0700
#define ATTRID_SE_DEVICE_MGMT_UNSUPP_PROTOCOL                         0x0701
#define ATTRID_SE_DEVICE_MGMT_INCORRECT_PROTOCOL                      0x0702
#define ATTRID_SE_DEVICE_MGMT_REQ_TUNNEL_CMD_RCVD                     0x07C0
#define ATTRID_SE_DEVICE_MGMT_REQ_TUNNEL_CMD_REJECTED                 0x07C1
#define ATTRID_SE_DEVICE_MGMT_REQ_TUNNEL_CMD_GENERATED                0x07C2
#define ATTRID_SE_DEVICE_MGMT_CLOSE_TUNNEL_CMD_RCVD                   0x07C3
#define ATTRID_SE_DEVICE_MGMT_CLOSE_TUNNEL_CMD_REJECTED               0x07C4
#define ATTRID_SE_DEVICE_MGMT_CLOSE_TUNNEL_CMD_GENERATED              0x07C5
#define ATTRID_SE_DEVICE_MGMT_TRANSFER_DATA_CMD_RCVD                  0x07C6
#define ATTRID_SE_DEVICE_MGMT_TRANSFER_DATA_CMD_REJECTED              0x07C7
#define ATTRID_SE_DEVICE_MGMT_TRANSFER_DATA_CMD_GENERATED             0x07C8
#define ATTRID_SE_DEVICE_MGMT_TRANSFER_DATA_ERR_CMD_RCVD              0x07C9
#define ATTRID_SE_DEVICE_MGMT_TRANSFER_DATA_ERR_CMD_REJECTED          0x07CA
#define ATTRID_SE_DEVICE_MGMT_TRANSFER_DATA_ERR_CMD_GENERATED         0x07CB
#define ATTRID_SE_DEVICE_MGMT_ACK_TRANSFER_DATA_CMD_RCVD              0x07CC
#define ATTRID_SE_DEVICE_MGMT_ACK_TRANSFER_DATA_CMD_REJECTED          0x07CD
#define ATTRID_SE_DEVICE_MGMT_ACK_TRANSFER_DATA_CMD_GENERATED         0x07CE
#define ATTRID_SE_DEVICE_MGMT_READY_DATA_CMD_RCVD                     0x07CF
#define ATTRID_SE_DEVICE_MGMT_READY_DATA_CMD_REJECTED                 0x07D0
#define ATTRID_SE_DEVICE_MGMT_READY_DATA_CMD_GENERATED                0x07D1
#define ATTRID_SE_DEVICE_MGMT_GET_SUPP_TUNNEL_PROTOCOLS_CMD_RCVD      0x07D2
#define ATTRID_SE_DEVICE_MGMT_GET_SUPP_TUNNEL_PROTOCOLS_CMD_REJECTED  0x07D3
#define ATTRID_SE_DEVICE_MGMT_GET_SUPP_TUNNEL_PROTOCOLS_CMD_GENERATED 0x07D4
#define ATTRID_SE_DEVICE_MGMT_TUNNEL_CLUSTER_GROUP_ID                 0x07FF

//==== OTA Event Configuration Attribute Set ====
#define ATTRID_SE_DEVICE_MGMT_FW_READY_FOR_ACTIVATION           0x0800
#define ATTRID_SE_DEVICE_MGMT_FW_ACTIVATED                      0x0801
#define ATTRID_SE_DEVICE_MGMT_FW_ACTIVATION_FAIL                0x0802
#define ATTRID_SE_DEVICE_MGMT_PATCH_READY_FOR_ACTIVATION        0x0803
#define ATTRID_SE_DEVICE_MGMT_PATCH_ACTIVATED                   0x0804
#define ATTRID_SE_DEVICE_MGMT_PATCH_FAIL                        0x0805
#define ATTRID_SE_DEVICE_MGMT_IMG_NOTIFY_CMD_RCVD               0x08C0
#define ATTRID_SE_DEVICE_MGMT_IMG_NOTIFY_CMD_REJECTED           0x08C1
#define ATTRID_SE_DEVICE_MGMT_QUERY_NEXT_IMG_REQ_GENERATED      0x08C2
#define ATTRID_SE_DEVICE_MGMT_QUERY_NEXT_IMG_RSP_RCVD           0x08C3
#define ATTRID_SE_DEVICE_MGMT_QUERY_NEXT_IMG_RSP_REJECTED       0x08C4
#define ATTRID_SE_DEVICE_MGMT_IMG_BLOCK_REQ_GENERATED           0x08C5
#define ATTRID_SE_DEVICE_MGMT_IMG_PG_REQ_GENERATED              0x08C6
#define ATTRID_SE_DEVICE_MGMT_IMG_BLOCK_RSP_RCVD                0x08C7
#define ATTRID_SE_DEVICE_MGMT_IMG_BLOCK_RSP_REJECTED            0x08C8
#define ATTRID_SE_DEVICE_MGMT_UPGRADE_END_REQ_GENERATED         0x08C9
#define ATTRID_SE_DEVICE_MGMT_UPGRADE_END_RSP_RCVD              0x08CA
#define ATTRID_SE_DEVICE_MGMT_UPGRADE_END_RSP_REJECTED          0x08CB
#define ATTRID_SE_DEVICE_MGMT_QUERY_SPECIFIC_FILE_REQ_GENERATED 0x08CC
#define ATTRID_SE_DEVICE_MGMT_QUERY_SPECIFIC_FILE_RSP_RCVD      0x08CD
#define ATTRID_SE_DEVICE_MGMT_QUERY_SPECIFIC_FILE_RSP_REJECTED  0x08CE
#define ATTRID_SE_DEVICE_MGMT_OTA_CLUSTER_GROUP_ID              0x08FF

//=================================================================================================
// Events Attributes(ZCL_CLUSTER_ID_SE_EVENTS)
//=================================================================================================
// No Attributes

//=================================================================================================
// EnergyMgmt Attributes(ZCL_CLUSTER_ID_SE_ENERGY_MGMT)
//=================================================================================================
// Server Cluster Attributes Set
#define ATTRID_SE_ENERGY_MGMT_LOAD_CTRL_STATE   0x0000 // see ZCL_SE_ENERGY_MGMT_STATE
#define ATTRID_SE_ENERGY_MGMT_CURR_EVT_ID       0x0001 // see ZCL_SE_DRLC_EVT_CTRL
#define ATTRID_SE_ENERGY_MGMT_CURR_EVT_STATUS   0x0002
#define ATTRID_SE_ENERGY_MGMT_CONFORMANCE_LEVEL 0x0003
#define ATTRID_SE_ENERGY_MGMT_MIN_OFF_TIME      0x0004
#define ATTRID_SE_ENERGY_MGMT_MIN_ON_TIME       0x0005
#define ATTRID_SE_ENERGY_MGMT_MIN_CYCLE_PERIOD  0x0006

//=================================================================================================
// MDUPairing Attributes(ZCL_CLUSTER_ID_SE_MDU_PAIRING)
//=================================================================================================
// No Attributes

//=================================================================================================
// DRLC Constants(ZCL_CLUSTER_ID_SE_DRLC)
//=================================================================================================
// ZCL_SE_DRLC_EVT_CTRL
#define ZCL_SE_DRLC_EVT_CTRL_RAND_START_TIME 0x01
#define ZCL_SE_DRLC_EVT_CTRL_RAND_DURATION   0x02
#define ZCL_SE_DRLC_EVT_CTRL_EXT_BITS        0x04
#define ZCL_SE_DRLC_EVT_CTRL_ACTIVE          0x08
#define ZCL_SE_DRLC_EVT_CTRL_PARTICIPATING   0x10
#define ZCL_SE_DRLC_EVT_CTRL_REDUCING_LOAD   0x20
#define ZCL_SE_DRLC_EVT_CTRL_ON_AT_END       0x40

// ZCL_SE_DRLC_DEV_CLASS
#define ZCL_SE_DRLC_DEV_CLASS_HVAC_COMPRESSOR     0x0001
#define ZCL_SE_DRLC_DEV_CLASS_STRIP_HEATERS       0x0002
#define ZCL_SE_DRLC_DEV_CLASS_WATER_HEATER        0x0004
#define ZCL_SE_DRLC_DEV_CLASS_POOL_PUMP           0x0008
#define ZCL_SE_DRLC_DEV_CLASS_SMART_APPLIANCES    0x0010
#define ZCL_SE_DRLC_DEV_CLASS_IRRIGATION_PUMP     0x0020
#define ZCL_SE_DRLC_DEV_CLASS_MANAGED_CI_LOADS    0x0040
#define ZCL_SE_DRLC_DEV_CLASS_SIMPLE_MISC_LOADS   0x0080
#define ZCL_SE_DRLC_DEV_CLASS_EXTERIOR_LIGHTING   0x0100
#define ZCL_SE_DRLC_DEV_CLASS_INTERIOR_LIGHTING   0x0200
#define ZCL_SE_DRLC_DEV_CLASS_ELEC_VEHICLE        0x0400
#define ZCL_SE_DRLC_DEV_CLASS_GENERATION_SYSTEMS  0x0800

// ZCL_SE_DRLC_EVT_STATUS
#define ZCL_SE_DRLC_EVT_STATUS_RCVD                 0x01
#define ZCL_SE_DRLC_EVT_STATUS_STARTED              0x02
#define ZCL_SE_DRLC_EVT_STATUS_COMPLETED            0x03
#define ZCL_SE_DRLC_EVT_STATUS_OPT_OUT              0x04
#define ZCL_SE_DRLC_EVT_STATUS_OPT_IN               0x05
#define ZCL_SE_DRLC_EVT_STATUS_CANCELLED            0x06
#define ZCL_SE_DRLC_EVT_STATUS_SUPERSEDED           0x07
#define ZCL_SE_DRLC_EVT_STATUS_PARTIAL_OPT_OUT      0x08
#define ZCL_SE_DRLC_EVT_STATUS_PARTIAL_OPT_IN       0x09
#define ZCL_SE_DRLC_EVT_STATUS_COMPLETED_NO_USER    0x0A
#define ZCL_SE_DRLC_EVT_STATUS_INVALID_OPT_OUT      0xF6
#define ZCL_SE_DRLC_EVT_STATUS_NOT_FOUND            0xF7
#define ZCL_SE_DRLC_EVT_STATUS_INVALID_CANCEL       0xF8
#define ZCL_SE_DRLC_EVT_STATUS_INVALID_CANCEL_TIME  0xF9
#define ZCL_SE_DRLC_EVT_STATUS_EXPIRED              0xFB
#define ZCL_SE_DRLC_EVT_STATUS_INVALID_CANCEL_EVT   0xFD
#define ZCL_SE_DRLC_EVT_STATUS_REJECTED             0xFE

// ZCL_SE_DRLC_SIGNATURE_TYPE
#define ZCL_SE_DRLC_SIGNATURE_TYPE_NONE  0x00
#define ZCL_SE_DRLC_SIGNATURE_TYPE_ECDSA 0x01

// ZCL_SE_DRLC_REPORT_EVT_STATUS_SIG_LEN
#define ZCL_SE_DRLC_REPORT_EVT_STATUS_SIG_LEN 42

// Miscellaneous
#define ZCL_SE_DRLC_FIELD_UINT8_NOT_USED    0xFF
#define ZCL_SE_DRLC_TEMP_SET_POINT_NOT_USED 0x8000
#define ZCL_SE_DRLC_TEMP_SET_POINT_MAX      0x7FFF
#define ZCL_SE_DRLC_DURATION_MAX            1440
#define ZCL_SE_DRLC_CRITICALITY_LEVEL_MAX   0x0F

//=================================================================================================
// Metering Constants(ZCL_CLUSTER_ID_SE_METERING)
//=================================================================================================
// ZCL_SE_METERING_BLOCK_ENUM
#define ZCL_SE_METERING_NO_BLOCK_IN_USE 0x00
#define ZCL_SE_METERING_BLOCK1          0x01
#define ZCL_SE_METERING_BLOCK2          0x02
#define ZCL_SE_METERING_BLOCK3          0x03
#define ZCL_SE_METERING_BLOCK4          0x04
#define ZCL_SE_METERING_BLOCK5          0x05
#define ZCL_SE_METERING_BLOCK6          0x06
#define ZCL_SE_METERING_BLOCK7          0x07
#define ZCL_SE_METERING_BLOCK8          0x08
#define ZCL_SE_METERING_BLOCK9          0x09
#define ZCL_SE_METERING_BLOCK10         0x0A
#define ZCL_SE_METERING_BLOCK11         0x0B
#define ZCL_SE_METERING_BLOCK12         0x0C
#define ZCL_SE_METERING_BLOCK13         0x0D
#define ZCL_SE_METERING_BLOCK14         0x0E
#define ZCL_SE_METERING_BLOCK15         0x0F
#define ZCL_SE_METERING_BLOCK16         0x10

// ZCL_SE_METERING_PROFILE_STATUS
#define ZCL_SE_METERING_PROFILE_SUCCESS                 0x00
#define ZCL_SE_METERING_PROFILE_UNDEF_INTERVAL_CHAN     0x01
#define ZCL_SE_METERING_PROFILE_INTERVAL_CHAN_NOT_SUPP  0x02
#define ZCL_SE_METERING_PROFILE_INVALID_END_TIME        0x03
#define ZCL_SE_METERING_PROFILE_MORE_PERIODS            0x04
#define ZCL_SE_METERING_PROFILE_NO_INTERVALS            0x05

// ZCL_SE_METERING_PROFILE_INTERVAL
#define ZCL_SE_METERING_PROFILE_INTERVAL_DAILY       0x00
#define ZCL_SE_METERING_PROFILE_INTERVAL_60_MINUTES  0x01
#define ZCL_SE_METERING_PROFILE_INTERVAL_30_MINUTES  0x02
#define ZCL_SE_METERING_PROFILE_INTERVAL_15_MINUTES  0x03
#define ZCL_SE_METERING_PROFILE_INTERVAL_10_MINUTES  0x04
#define ZCL_SE_METERING_PROFILE_INTERVAL_7_5_MINUTES 0x05
#define ZCL_SE_METERING_PROFILE_INTERVAL_5_MINUTES   0x06
#define ZCL_SE_METERING_PROFILE_INTERVAL_2_5_MINUTES 0x07

// ZCL_SE_METERING_SUPPLY_STATUS
#define ZCL_SE_METERING_SUPPLY_OFF       0x00
#define ZCL_SE_METERING_SUPPLY_OFF_ARMED 0x01
#define ZCL_SE_METERING_SUPPLY_ON        0x02

// ZCL_SE_METERING_STATUS_BITS
// general
#define ZCL_SE_METERING_STATUS_CHK_METER      0x01
#define ZCL_SE_METERING_STATUS_LOW_BATT       0x02
#define ZCL_SE_METERING_STATUS_TAMPER_DETECT  0x04
#define ZCL_SE_METERING_STATUS_PWR_FAIL       0x08
#define ZCL_SE_METERING_STATUS_LEAK_DETECT    0x20
#define ZCL_SE_METERING_STATUS_SVC_DISCONNECT 0x40
// electric
#define ZCL_SE_METERING_STATUS_PWR_QUALITY    0x10
// gas
#define ZCL_SE_METERING_STATUS_LOW_PRESSURE   0x10
#define ZCL_SE_METERING_STATUS_REVERSE_FLOW   0x80
// water
#define ZCL_SE_METERING_STATUS_PIPE_EMPTY     0x08
// heating and cooling
#define ZCL_SE_METERING_STATUS_BURST_DETECT   0x10
#define ZCL_SE_METERING_STATUS_FLOW_SENSOR    0x08

// ZCL_SE_METERING_EXT_STATUS_BITS
// general
#define ZCL_SE_METERING_EXT_STATUS_METER_COVER_REMOVED     0x0000000000000001
#define ZCL_SE_METERING_EXT_STATUS_STRONG_MAG_FLD_DETECTED 0x0000000000000002
#define ZCL_SE_METERING_EXT_STATUS_BATT_FAIL               0x0000000000000004
#define ZCL_SE_METERING_EXT_STATUS_PROG_MEM_ERR            0x0000000000000008
#define ZCL_SE_METERING_EXT_STATUS_RAM_ERR                 0x0000000000000010
#define ZCL_SE_METERING_EXT_STATUS_NV_MEM_ERR              0x0000000000000020
#define ZCL_SE_METERING_EXT_STATUS_MEASUREMENT_SYS_ERR     0x0000000000000040
#define ZCL_SE_METERING_EXT_STATUS_WATCHDOG_ERR            0x0000000000000080
#define ZCL_SE_METERING_EXT_STATUS_SUPPLY_DISCONNECT_FAIL  0x0000000000000100
#define ZCL_SE_METERING_EXT_STATUS_SUPPLY_CONNECT_FAIL     0x0000000000000200
#define ZCL_SE_METERING_EXT_STATUS_MEASUREMENT_SW_CHANGED  0x0000000000000400
#define ZCL_SE_METERING_EXT_STATUS_CLK_INVALID             0x0000000000000800
#define ZCL_SE_METERING_EXT_STATUS_TEMP_EXCDED             0x0000000000001000
#define ZCL_SE_METERING_EXT_STATUS_MOISTURE_DETECTED       0x0000000000002000
// electric
#define ZCL_SE_METERING_EXT_STATUS_TERMINAL_COVER_REMOVED  0x0000001000000000
#define ZCL_SE_METERING_EXT_STATUS_INCORRECT_POLARITY      0x0000002000000000
#define ZCL_SE_METERING_EXT_STATUS_CURR_WITH_NO_VOLTAGE    0x0000004000000000
#define ZCL_SE_METERING_EXT_STATUS_LIMIT_THRESHOLD_EXCDED  0x0000008000000000
#define ZCL_SE_METERING_EXT_STATUS_UNDER_VOLTAGE           0x0000010000000000
#define ZCL_SE_METERING_EXT_STATUS_OVER_VOLTAGE            0x0000020000000000
// gas
#define ZCL_SE_METERING_EXT_STATUS_BATT_COVER_REMOVED      0x0000001000000000
#define ZCL_SE_METERING_EXT_STATUS_TILT_TAMPER             0x0000002000000000
#define ZCL_SE_METERING_EXT_STATUS_EXCESS_FLOW             0x0000004000000000

// ZCL_SE_METERING_AMBIENT_LEVEL
#define ZCL_SE_METERING_LOW_ENERGY_USAGE  0x00
#define ZCL_SE_METERING_MED_ENERGY_USAGE  0x01
#define ZCL_SE_METERING_HIGH_ENERGY_USAGE 0x02

// ZCL_SE_METERING_DEVICE_TYPE
#define ZCL_SE_METERING_ELEC_METERING                             0
#define ZCL_SE_METERING_GAS_METERING                              1
#define ZCL_SE_METERING_WATER_METERING                            2
#define ZCL_SE_METERING_THERMAL_METERING                          3
#define ZCL_SE_METERING_PRESSURE_METERING                         4
#define ZCL_SE_METERING_HEAT_METERING                             5
#define ZCL_SE_METERING_COOLING_METERING                          6
#define ZCL_SE_METERING_EUMD                                      7
#define ZCL_SE_METERING_PV_GENERAL_METERING                       8
#define ZCL_SE_METERING_WIND_TURBINE_GENERAL_METERING             9
#define ZCL_SE_METERING_WATER_TURBINE_GENERAL_METERING            10
#define ZCL_SE_METERING_MICRO_GENERAL_METERING                    11
#define ZCL_SE_METERING_SOLAR_HOT_WATER_GENERAL_METERING          12
#define ZCL_SE_METERING_ELEC_METERING_ELEM_P1                     13
#define ZCL_SE_METERING_ELEC_METERING_ELEM_P2                     14
#define ZCL_SE_METERING_ELEC_METERING_ELEM_P3                     15
#define ZCL_SE_METERING_MIRR_ELEC_METERING                        127
#define ZCL_SE_METERING_MIRR_GAS_METERING                         128
#define ZCL_SE_METERING_MIRR_WATER_METERING                       129
#define ZCL_SE_METERING_MIRR_THERMAL_METERING                     130
#define ZCL_SE_METERING_MIRR_PRESSURE_METERING                    131
#define ZCL_SE_METERING_MIRR_HEAT_METERING                        132
#define ZCL_SE_METERING_MIRR_COOLING_METERING                     133
#define ZCL_SE_METERING_MIRR_EUMD                                 134
#define ZCL_SE_METERING_MIRR_PV_GENERAL_METERING                  135
#define ZCL_SE_METERING_MIRR_WIND_TURBINE_GENERAL_METERING        136
#define ZCL_SE_METERING_MIRR_WATER_TURBINE_GENERAL_METERING       137
#define ZCL_SE_METERING_MIRR_MICRO_GENERAL_METERING               138
#define ZCL_SE_METERING_MIRR_SOLAR_HOT_WATER_GENERAL_METERING     139
#define ZCL_SE_METERING_MIRR_ELEC_METERING_ELEM_P1                140
#define ZCL_SE_METERING_MIRR_ELEC_METERING_ELEM_P2                141
#define ZCL_SE_METERING_MIRR_ELEC_METERING_ELEM_P3                142

// ZCL_SE_METERING_SET_SUPPLY_STATUS
#define ZCL_SE_METERING_SET_SUPPLY_OFF              0x00
#define ZCL_SE_METERING_SET_SUPPLY_OFF_ARMED        0x01
#define ZCL_SE_METERING_SET_SUPPLY_ON               0x02
#define ZCL_SE_METERING_SET_SUPPLY_UNCHANGED        0x03

// ZCL_SE_PRICE_REG_TIER
#define ZCL_SE_PRICE_REG_NO_TIER_RELATED            0x00
#define ZCL_SE_PRICE_REG_CURR_TIER1_SUMM_DLVD       0x01
#define ZCL_SE_PRICE_REG_CURR_TIER2_SUMM_DLVD       0x02
#define ZCL_SE_PRICE_REG_CURR_TIER3_SUMM_DLVD       0x03
#define ZCL_SE_PRICE_REG_CURR_TIER4_SUMM_DLVD       0x04
#define ZCL_SE_PRICE_REG_CURR_TIER5_SUMM_DLVD       0x05
#define ZCL_SE_PRICE_REG_CURR_TIER6_SUMM_DLVD       0x06
#define ZCL_SE_PRICE_REG_CURR_TIER7_SUMM_DLVD       0x07
#define ZCL_SE_PRICE_REG_CURR_TIER8_SUMM_DLVD       0x08
#define ZCL_SE_PRICE_REG_CURR_TIER9_SUMM_DLVD       0x09
#define ZCL_SE_PRICE_REG_CURR_TIER10_SUMM_DLVD      0x0A
#define ZCL_SE_PRICE_REG_CURR_TIER11_SUMM_DLVD      0x0B
#define ZCL_SE_PRICE_REG_CURR_TIER12_SUMM_DLVD      0x0C
#define ZCL_SE_PRICE_REG_CURR_TIER13_SUMM_DLVD      0x0D
#define ZCL_SE_PRICE_REG_CURR_TIER14_SUMM_DLVD      0x0E
#define ZCL_SE_PRICE_REG_EXT_REG_TIER               0x0F

// ZCL_SE_METERING_SP_TYPE (SP - SNAPSHOT PAYLOAD)
#define ZCL_SE_METERING_SP_TOU_SET_DLVD                         0
#define ZCL_SE_METERING_SP_TOU_SET_RCVD                         1
#define ZCL_SE_METERING_SP_BLOCK_TIER_SET_DLVD                  2
#define ZCL_SE_METERING_SP_BLOCK_TIER_SET_RCVD                  3
#define ZCL_SE_METERING_SP_TOU_SET_DLVD_NO_BILL                 4
#define ZCL_SE_METERING_SP_TOU_SET_RCVD_NO_BILL                 5
#define ZCL_SE_METERING_SP_BLOCK_TIER_SET_DLVD_NO_BILL          6
#define ZCL_SE_METERING_SP_BLOCK_TIER_SET_RCVD_NO_BILL          7
#define ZCL_SE_METERING_SP_DATA_UNAVAIL                         128

//=================================================================================================
// Price Constants(ZCL_CLUSTER_ID_SE_PRICE)
//=================================================================================================
#define SE_PROFILE_PRICEACK_REQUIRED_MASK       0x01

// Miscellaneous
#define ZCL_SE_PRICE_FIELD_UINT8_NOT_USED       0xFF
#define ZCL_SE_PRICE_FIELD_UINT32_NOT_USED      0xFFFFFFFF
#define ZCL_SE_PRICE_AVG_LOAD_ADJ_PCT_NOT_USED  0x80
#define ZCL_SE_PRICE_BLOCK_THRESHOLD_LEN        6

//=================================================================================================
// Messaging Constants(ZCL_CLUSTER_ID_SE_MESSAGING)
//=================================================================================================

//=================================================================================================
// Tunneling Constants(ZCL_CLUSTER_ID_SE_TUNNELING)
//=================================================================================================
// ZCL_SE_TUNNELING_TUNNEL_STATUS
#define ZCL_SE_TUNNELING_TUNNEL_STATUS_SUCCESS             0
#define ZCL_SE_TUNNELING_TUNNEL_STATUS_BUSY                1
#define ZCL_SE_TUNNELING_TUNNEL_STATUS_MAX_IDS             2
#define ZCL_SE_TUNNELING_TUNNEL_STATUS_PROTO_NOT_SUPP      3
#define ZCL_SE_TUNNELING_TUNNEL_STATUS_FLOW_CTRL_NOT_SUPP  4

// ZCL_SE_TUNNELING_TRANSFER_STATUS
#define ZCL_SE_TUNNELING_TRANSFER_STATUS_NO_TUNNEL      0
#define ZCL_SE_TUNNELING_TRANSFER_STATUS_WRONG_DEVICE   1
#define ZCL_SE_TUNNELING_TRANSFER_STATUS_DATA_OVERFLOW  2

// ZCL_SE_TUNNELING_PROTO
#define ZCL_SE_TUNNELING_PROTO_IEC_62056     0
#define ZCL_SE_TUNNELING_PROTO_IEC_61107     1
#define ZCL_SE_TUNNELING_PROTO_ANSI_C12      2
#define ZCL_SE_TUNNELING_PROTO_M_BUS         3
#define ZCL_SE_TUNNELING_PROTO_SML           4
#define ZCL_SE_TUNNELING_PROTO_CLIMATE_TALK  5
#define ZCL_SE_TUNNELING_PROTO_GB_HRGP       6

//=================================================================================================
// Prepayment Constants(ZCL_CLUSTER_ID_SE_PREPAYMENT)
//=================================================================================================
// ZCL_SE_PREPAYMENT_SNAPSHOT_PAYLOAD_TYPE
#define ZCL_SE_PREPAYMENT_SNAPSHOT_DEBT_CREDIT_STATUS 0

//=================================================================================================
// Calendar Constants(ZCL_CLUSTER_ID_SE_CALENDAR)
//=================================================================================================
// ZCL_SE_CALENDAR_TYPE
#define ZCL_SE_CALENDAR_TYPE_DLVD            0x00
#define ZCL_SE_CALENDAR_TYPE_RCVD            0x01
#define ZCL_SE_CALENDAR_TYPE_DLVD_AND_RCVD   0x02
#define ZCL_SE_CALENDAR_TYPE_FRNDLY_CREDIT   0x03
#define ZCL_SE_CALENDAR_TYPE_AUX_LOAD_START  0X04

//=================================================================================================
// DeviceMgmt Constants(ZCL_CLUSTER_ID_SE_DEVICE_MGMT)
//=================================================================================================
// ZCL_SE_DEVICE_MGMT_EVT_CFG_VALUE
#define ZCL_SE_DEVICE_MGMT_EVT_LOG_NONE         0x00
#define ZCL_SE_DEVICE_MGMT_EVT_LOG_TAMPER       0x01
#define ZCL_SE_DEVICE_MGMT_EVT_LOG_FAULT        0x02
#define ZCL_SE_DEVICE_MGMT_EVT_LOG_GENERAL      0x03
#define ZCL_SE_DEVICE_MGMT_EVT_LOG_SECURITY     0x04
#define ZCL_SE_DEVICE_MGMT_EVT_LOG_NWK          0x05
#define ZCL_SE_DEVICE_MGMT_EVT_PUSH_TO_WAN      0x06
#define ZCL_SE_DEVICE_MGMT_EVT_PUSH_TO_HAN      0x08
#define ZCL_SE_DEVICE_MGMT_RAISE_ALARM_ZIGBEE   0x10
#define ZCL_SE_DEVICE_MGMT_RAISE_ALARM_PHYSICAL 0x20

// ZCL_SE_DEVICE_MGMT_EVT_CFG_CTRL
#define ZCL_SE_DEVICE_MGMT_EVT_CFG_BY_LIST      0x00
#define ZCL_SE_DEVICE_MGMT_EVT_CFG_BY_EVT_GROUP 0x01
#define ZCL_SE_DEVICE_MGMT_EVT_CFG_BY_LOG_TYPE  0x02
#define ZCL_SE_DEVICE_MGMT_EVT_CFG_BY_MATCH     0x03

//=================================================================================================
// Events Constants(ZCL_CLUSTER_ID_SE_EVENTS)
//=================================================================================================
// ZCL_SE_EVENTS_LOG_ID
#define ZCL_SE_EVENTS_LOG_ID_ALL_LOGS         0x00
#define ZCL_SE_EVENTS_LOG_ID_TAMPER_LOGS      0x01
#define ZCL_SE_EVENTS_LOG_ID_FAULT_LOG        0x02
#define ZCL_SE_EVENTS_LOG_ID_GENERAL_EVT_LOG  0x03
#define ZCL_SE_EVENTS_LOG_ID_SEC_EVT_LOG      0x04
#define ZCL_SE_EVENTS_LOG_ID_NWK_EVT_LOG      0x05

// ZCL_SE_EVENTS_GET_EVT_CTRL
#define ZCL_SE_EVENTS_GET_EVT_CTRL_MINIMAL  0x00
#define ZCL_SE_EVENTS_GET_EVT_CTRL_FULL     0x01

// ZCL_SE_EVENTS_PUBLISH_EVT_CTRL
#define ZCL_SE_EVENTS_PUBLISH_EVT_CTRL_REPORT_HAN  0x01
#define ZCL_SE_EVENTS_PUBLISH_EVT_CTRL_REPORT_WAN  0x02

// ZCL_SE_EVENTS_LOGGED_EVT_CTRL
#define ZCL_SE_EVENTS_LOGGED_EVT_CTRL_BDRY_BIT 0x01

// ZCL_SE_EVENTS_CLEAR
#define ZCL_SE_EVENTS_CLEAR_ALL_LOGS_BIT          0x01
#define ZCL_SE_EVENTS_CLEAR_TAMPER_LOGS_BIT       0x02
#define ZCL_SE_EVENTS_CLEAR_FAULT_LOGS_BIT        0x04
#define ZCL_SE_EVENTS_CLEAR_GENERAL_LOGS_BIT      0x08
#define ZCL_SE_EVENTS_CLEAR_SEC_LOGS_BIT          0x10
#define ZCL_SE_EVENTS_CLEAR_NWK_LOGS_BIT          0x20

//=================================================================================================
// EnergyMgmt Constants(ZCL_CLUSTER_ID_SE_ENERGY_MGMT)
//=================================================================================================
// ZCL_SE_ENERGY_MGMT_STATE
#define ZCL_SE_ENERGY_MGMT_STATE_DEVICE_OFF             0x01
#define ZCL_SE_ENERGY_MGMT_STATE_EVT_IN_PROGRESS        0x02
#define ZCL_SE_ENERGY_MGMT_STATE_PWR_STABILIZING        0x04
#define ZCL_SE_ENERGY_MGMT_STATE_OTHER_LOAD_REDUCTION   0x08
#define ZCL_SE_ENERGY_MGMT_STATE_CURR_FLOW              0x10
#define ZCL_SE_ENERGY_MGMT_STATE_LOAD_CALL              0x20

// ZCL_SE_ENERGY_MGMT_ACTION
#define ZCL_SE_ENERGY_MGMT_ACTION_OPT_OUT               0x01
#define ZCL_SE_ENERGY_MGMT_ACTION_OPT_INTO              0x02
#define ZCL_SE_ENERGY_MGMT_ACTION_DISABLE_DUTY_CYCLING  0x04
#define ZCL_SE_ENERGY_MGMT_ACTION_ENABLE_DUTY_CYCLING   0x08


/**************************************************************************************************
 * TYPEDEFS
 */

//=================================================================================================
// DRLC Command Fields(ZCL_CLUSTER_ID_SE_DRLC)
//=================================================================================================
typedef struct
{
  uint32_t issuerEvtID;
  uint16_t deviceClass; // see ZCL_SE_DRLC_DEV_CLASS
  uint8_t utilityEnrollmentGroup;
  uint32_t startTime;
  uint16_t duration;
  uint8_t criticalityLevel;
  uint8_t coolingTempOffset;
  uint8_t heatingTempOffset;
  int16_t coolingTempSetPt;
  int16_t heatingTempSetPt;
  int8_t avgLoadAdjPct;
  uint8_t dutyCycle;
  uint8_t evtCtrl; // see ZCL_SE_DRLC_EVT_CTRL
} zclSE_DRLC_LoadCtrlEvt_t;

typedef struct
{
  uint32_t issuerEvtID;
  uint16_t deviceClass; // see ZCL_SE_DRLC_DEV_CLASS
  uint8_t utilityEnrollmentGroup;
  uint8_t cancelCtrl;
  uint32_t effectiveTime;
} zclSE_DRLC_CancelLoadCtrlEvt_t;

typedef struct
{
  uint8_t cancelCtrl;
} zclSE_DRLC_CancelAllLoadCtrlEvts_t;

typedef struct
{
  uint32_t issuerEvtID;
  uint8_t evtStatus; // see ZCL_SE_DRLC_EVT_STATUS
  uint32_t evtStatusTime;
  uint8_t critLevelApplied;
  uint16_t coolingTempSetPtApplied;
  uint16_t heatingTempSetPtApplied;
  int8_t avgLoadAdjPctApplied;
  uint8_t dutyCycleApplied;
  uint8_t evtCtrl; // see ZCL_SE_DRLC_EVT_CTRL
  uint8_t signatureType; // see ZCL_SE_DRLC_SIGNATURE_TYPE
  UTF8String_t signature; // see ZCL_SE_DRLC_REPORT_EVT_STATUS_SIG_LEN
} zclSE_DRLC_ReportEvtStatus_t;

typedef struct
{
  uint32_t startTime;
  uint8_t numOfEvents;
} zclSE_DRLC_GetScheduledEvts_t;

//=================================================================================================
// DRLC Callbacks(ZCL_CLUSTER_ID_SE_DRLC)
//=================================================================================================
// Callback COMMAND_SE_DRLC_LOAD_CTRL_EVT
typedef void (*zclSE_DRLC_LoadCtrlEvtCB_t)( zclIncoming_t *pInMsg,
                                            zclSE_DRLC_LoadCtrlEvt_t *pCmd );

// Callback COMMAND_SE_DRLC_CANCEL_LOAD_CTRL_EVT
typedef void (*zclSE_DRLC_CancelLoadCtrlEvtCB_t)( zclIncoming_t *pInMsg,
                                                  zclSE_DRLC_CancelLoadCtrlEvt_t *pCmd );

// Callback COMMAND_SEDRLC_CANCEL_ALL_LOAD_CTRL_EVTS
typedef void (*zclSE_DRLC_CancelAllLoadCtrlEvtsCB_t)(
                 zclIncoming_t *pInMsg,
                 zclSE_DRLC_CancelAllLoadCtrlEvts_t *pCmd );

// Callback COMMAND_SE_DRLC_REPORT_EVT_STATUS
typedef void (*zclSE_DRLC_ReportEvtStatusCB_t)( zclIncoming_t *pInMsg,
                                                zclSE_DRLC_ReportEvtStatus_t *pCmd );

// Callback COMMAND_SE_DRLC_GET_SCHEDULED_EVTS
//  @return ZCL_STATUS_SUCCESS or
//          ZCL_STATUS_NOT_FOUND
typedef ZStatus_t (*zclSE_DRLC_GetScheduledEvtsCB_t)(
                      zclIncoming_t *pInMsg,
                      zclSE_DRLC_GetScheduledEvts_t *pCmd );

// Server-to-Client Callbacks
typedef struct
{
  // COMMAND_SE_DRLC_LOAD_CTRL_EVT
  zclSE_DRLC_LoadCtrlEvtCB_t            pfnLoadCtrlEvt;
  // COMMAND_SE_DRLC_CANCEL_LOAD_CTRL_EVT
  zclSE_DRLC_CancelLoadCtrlEvtCB_t      pfnCancelLoadCtrlEvt;
  // COMMAND_SE_DRLC_CANCEL_ALL_LOAD_CTRL_EVTS
  zclSE_DRLC_CancelAllLoadCtrlEvtsCB_t  pfnCancelAllLoadCtrlEvts;
} zclSE_DRLC_ClientCBs_t;

// Client-to-Server Callbacks
typedef struct
{
  // COMMAND_SE_DRLC_REPORT_EVT_STATUS
  zclSE_DRLC_ReportEvtStatusCB_t   pfnReportEvtStatus;
  // COMMAND_SE_DRLC_GET_SCHEDULED_EVTS
  zclSE_DRLC_GetScheduledEvtsCB_t  pfnGetScheduledEvts;
} zclSE_DRLC_ServerCBs_t;

//=================================================================================================
// Metering Command Fields(ZCL_CLUSTER_ID_SE_METERING)
//=================================================================================================
typedef struct
{
  uint32_t endTime;
  uint8_t status; // see ZCL_SE_METERING_PROFILE_STATUS
  uint8_t profileIntervalPeriod;
  uint8_t numOfPeriodDlvd; // see ZCL_SE_METERING_PROFILE_INTERVAL
  uint32_t *pIntervals;
} zclSE_MeteringGetProfileRsp_t;

typedef struct
{
  uint8_t appliedUpdatePeriod;
  uint32_t endTime;
} zclSE_MeteringReqFastPollModeRsp_t;

typedef struct
{
  uint8_t scheduleID;
  uint8_t scheduleCfm;
} zclSE_MeteringScheduleRspEntry_t;

typedef struct
{
  uint32_t issuerEvtID;
  uint8_t numOfEntries;
  zclSE_MeteringScheduleRspEntry_t* pEntries;
} zclSE_MeteringScheduleSnapshotRsp_t;

typedef struct
{
  uint32_t snapshotID;
  uint8_t snapshotCfm;
} zclSE_MeteringTakeSnapshotRsp_t;

typedef struct
{
  uint8_t currSumm[6];
  uint32_t billToDate;
  uint32_t billToDateTimeStamp;
  uint32_t projBill;
  uint32_t projBillTimeStamp;
  uint8_t billTrailingDigit; // use low nibble - not shifted
  uint8_t numOfTiersInUse;
  uint8_t *pTierSumm; // serialized unsigned 48 bit integers LSB first
} zclSE_MeteringTOU_Set_t;

typedef struct
{
  uint8_t currSumm[6];
  uint8_t numOfTiersInUse;
  uint8_t *pTierSumm; // serialized unsigned 48 bit integers LSB first
} zclSE_MeteringTOU_NoBillInfo_t;

typedef struct
{
  uint8_t currSumm[6];
  uint32_t billToDate;
  uint32_t billToDateTimeStamp;
  uint32_t projBill;
  uint32_t projBillTimeStamp;
  uint8_t billTrailingDigit; // use low nibble - not shifted
  uint8_t numOfTiersInUse;
  uint8_t *pTierSumm; // serialized unsigned 48 bit integers LSB first
  uint8_t tierBlockNumOfTiers; // use low nibble - not shifted
  uint8_t tierBlockNumOfBlocks;
  uint8_t *pTierBlockSumm; // serialized unsigned 48 bit integers LSB first
} zclSE_MeteringBlockTierSet_t;

typedef struct
{
  uint8_t currSumm[6];
  uint8_t numOfTiersInUse;
  uint8_t *pTierSumm; // serialized unsigned 48 bit integers LSB first
  uint8_t tierBlockNumOfTiers; // use low nibble - not shifted
  uint8_t tierBlockNumOfBlocks;
  uint8_t *pTierBlockSumm; // serialized unsigned 48 bit integers LSB first
} zclSE_MeteringBlockTierSetNoBillInfo_t;

typedef union
{
  // ZCL_SE_METERING_SP_TOU_SET_DLVD
  // ZCL_SE_METERING_SP_TOU_SET_RCVD
  zclSE_MeteringTOU_Set_t *pTOU;

  // ZCL_SE_METERING_SP_TOU_SET_DLVD_NO_BILL
  // ZCL_SE_METERING_SP_TOU_SET_RCVD_NO_BILL
  zclSE_MeteringTOU_NoBillInfo_t *pTOU_NoBill;

  // ZCL_SE_METERING_SP_BLOCK_TIER_SET_DLVD
  // ZCL_SE_METERING_SP_BLOCK_TIER_SET_RCVD
  zclSE_MeteringBlockTierSet_t *pBlockTier;

  // ZCL_SE_METERING_SP_BLOCK_TIER_SET_DLVD_NO_BILL
  // ZCL_SE_METERING_SP_BLOCK_TIER_SET_RCVD_NO_BILL
  zclSE_MeteringBlockTierSetNoBillInfo_t *pBlockTierNoBill;
} zclSE_MeteringSnapshotPayload_t;

typedef struct
{
  uint32_t snapshotID;
  uint32_t time;
  uint8_t totalFound;
  uint8_t cmdIdx;
  uint8_t cmdTotal;
  uint32_t cause;
  uint8_t payloadType; // see ZCL_SE_METERING_SP_TYPE

  // Union discriminator "payloadType"
  // May be empty if fragmented -- see raw payload fields below
  zclSE_MeteringSnapshotPayload_t payload;

  // Raw payloads are used to send and receive fragmented commands -- see below
  uint16_t rawPayloadLen;
  uint8_t *pRawPayload;

  // Depending on the length of the entire command, the command may be
  // fragmented.  If the command is fragmented the "payload" field will be
  // empty and the raw payload fields will be set.  When receiving fragmented
  // commands the user is responsible to concatenate all the fragments into one
  // complete "pRawPayload" field.  Once the entire "pRawPayload" has been built
  // from all the fragments, the user can then call "zclSE_MeteringSP_Parse" to
  // parse the "pRawPayload" and build a valid "payload" field.  A
  // simple example is provided below.  Note that the function
  // "zclSE_MeteringSP_Parse" should be called from within the context of a
  // COMMAND_SE_METERING_PUBLISH_SNAPSHOT callback function -- see example
  // below.
  //
  //  EXAMPLE CALLBACK HANDLER:
  //  ==========================================================================
  /*
      // Local vars to build raw concatenated payload from multipe fragments
      static uint8_t app_rawPayloadLen = 0;
      static uint8_t *app_rawPayload = NULL;

      // Callback for COMMAND_SE_METERING_PUBLISH_SNAPSHOT
      uint8_t app_MeteringPublishSnapshotCB(
              zclIncoming_t *pInMsg,
              zclSE_MeteringPublishSnapshot_t *pCmd )
      {
        uint8_t result = ZCL_STATUS_SUCCESS;
        uint8_t completeCmdReady = FALSE;

        if ( pCmd->cmdTotal > 1 )
        {
          // Simple example of concatenating command fragments
          app_rawPayload = realloc( app_rawPayload,
                                    app_rawPayloadLen + pCmd->rawPayloadLen);
          if (app_rawPayload == NULL )
          {
            return ZCL_STATUS_SOFTWARE_FAILURE;
          }

          OsalPort_memcpy( &app_rawPayload[app_rawPayloadLen],
                  pCmd->pRawPayload,
                  pCmd->rawPayloadLen );

          app_rawPayloadLen += pCmd->rawPayloadLen;

          // Is this the last fragment
          if ( ( pCmd->cmdIdx + 1 ) == pCmd->cmdTotal )
          {
             // Set the full raw payload fields
             pCmd->pRawPayload = app_rawPayload;
             pCmd->rawPayloadLen = app_rawPayloadLen;

            // Parse the full command payload
            result = zclSE_MeteringSP_Parse( pCmd );

            if ( result == ZCL_STATUS_SUCCESS )
            {
              // Current command is ready for final processing
              completeCmdReady = TRUE;
            }
            else
            {
              // Reset variables
              free(app_rawPayload);
              app_rawPayload = NULL;
              app_rawPayloadLen = 0;
            }
          }
        }
        else
        {
          // No fragmentation -- just use current command for final processing
          completeCmdReady = TRUE;
        }

        // Is command ready to process, ie the "payload" is valid
        if ( completeCmdReady )
        {
          // User specific command processing
          app_ProcessPublishSnapshot( pCmd );

          // Free variables after using "pCmd->payload" -- it may
          // reference parts of the "app_rawPayload"
          free(app_rawPayload);
          app_rawPayload = NULL;
          app_rawPayloadLen = 0;
        }

        return result;
      }
    ==========================================================================
  */
  // If needed, the user can also send a fragmented command by calling
  // "zclSE_MeteringSendPublishSnapshot" multiple times, setting "cmdIdx",
  // "cmdTotal", and the raw payload fields accordingly.
} zclSE_MeteringPublishSnapshot_t;

typedef struct
{
  uint16_t sampleID;
  uint32_t startTime;
  uint8_t type;
  uint16_t reqInterval;
  uint16_t numOfSamples;
  uint32_t *pSamples;
} zclSE_MeteringGetSampledDataRsp_t;

typedef struct
{
  uint32_t issuerEvtID;
  uint32_t reportingInterval;
  uint8_t mirrorNotifReporting;
  uint8_t notifScheme;
} zclSE_MeteringCfgMirror_t;

typedef struct
{
  uint32_t issuerEvtID;
  uint8_t notifScheme;
  uint32_t notifFlagOrder;
} zclSE_MeteringCfgNotifScheme_t;

typedef struct
{
  uint32_t issuerEvtID;
  uint8_t notifScheme;
  uint16_t notifFlagAttrID;
  uint16_t clusterID;
  uint16_t manuCode;
  uint8_t numOfCmds;
  uint8_t *pCmdIDs;
} zclSE_MeteringCfgNotifFlag_t;

typedef struct
{
  uint8_t notifScheme;
  uint16_t notifFlagAttrID;
  uint32_t notifFlags;
} zclSE_MeteringGetNotifMsg_t;

typedef struct
{
  uint32_t providerID;
  uint32_t issuerEvtID;
  uint32_t implTime;
  uint8_t supplyStatus; // see ZCL_SE_METERING_SUPPLY_STATUS
} zclSE_MeteringSupplyStatusRsp_t;

typedef struct
{
  uint16_t sampleID;
} zclSE_MeteringStartSamplingRsp_t;

typedef struct
{
  uint8_t intervalChan;
  uint32_t endTime;
  uint8_t numOfPeriods;
} zclSE_MeteringGetProfile_t;

typedef struct
{
  uint16_t epID;
} zclSE_MeteringReqMirrorRsp_t;

typedef struct
{
  uint16_t epID;
} zclSE_MeteringMirrorRemoved_t;

typedef struct
{
  uint8_t updatePeriod;
  uint8_t duration;
} zclSE_MeteringReqFastPollMode_t;

typedef struct
{
  uint8_t scheduleID;
  uint32_t startTime;
  uint32_t schedule;
  uint8_t payloadType; // see ZCL_SE_METERING_SP_TYPE
  uint32_t cause;
} zclSE_MeteringSnapshotSchedule_t;

typedef struct
{
  uint32_t issuerEvtID;
  uint8_t cmdIdx;
  uint8_t cmdTotal;
  uint8_t numOfSchedules;

  // May be empty if fragmented -- see raw payload fields below
  zclSE_MeteringSnapshotSchedule_t *pSchedules;

  // Raw payloads are used to send and receive fragmented commands -- see below
  uint16_t rawPayloadLen;
  uint8_t *pRawPayload;

  // Depending on the length of the entire command, the command may be
  // fragmented.  If the command is fragmented the "pSchedules" field will be
  // NULL and the raw payload fields will be set.  When receiving fragmented
  // commands the user is responsible to concatenate all the fragments into one
  // complete "pRawPayload" field.  Once the entire "pRawPayload" has been built
  // from all the fragments, the user can then call
  // "zclSE_MeteringSnapshotScheduleParse" to parse the "pRawPayload" and build
  // a valid "pSchedules" field.  A simple example is provided below.  Note that
  // the function "zclSE_MeteringSnapshotScheduleParse" should be called from
  // within the context of a COMMAND_SE_METERING_SCHEDULE_SNAPSHOT callback
  // function -- see example below.
  //
  //  EXAMPLE CALLBACK HANDLER:
  //  ==========================================================================
  /*
      // Local vars to build raw concatenated payload from multipe fragments
      static uint8_t app_rawPayloadLen = 0;
      static uint8_t *app_rawPayload = NULL;

      // Callback for COMMAND_SE_METERING_SCHEDULE_SNAPSHOT
      uint8_t app_MeteringScheduleSnapshotCB(
              zclIncoming_t *pInMsg,
              zclSE_MeteringScheduleSnapshot_t *pCmd )
      {
        uint8_t result = ZCL_STATUS_SUCCESS;
        uint8_t parseResult;
        uint8_t completeCmdReady = FALSE;

        if ( pCmd->cmdTotal > 1 )
        {
          // Simple example of concatenating command fragments
          app_rawPayload = realloc( app_rawPayload,
                                    app_rawPayloadLen + pCmd->rawPayloadLen);
          if (app_rawPayload == NULL )
          {
            return ZCL_STATUS_SOFTWARE_FAILURE;
          }

          OsalPort_memcpy( &app_rawPayload[app_rawPayloadLen],
                  pCmd->pRawPayload,
                  pCmd->rawPayloadLen );

          app_rawPayloadLen += pCmd->rawPayloadLen;

          // Is this the last fragment
          if ( ( pCmd->cmdIdx + 1 ) == pCmd->cmdTotal )
          {
             // Set the full raw payload fields
             pCmd->pRawPayload = app_rawPayload;
             pCmd->rawPayloadLen = app_rawPayloadLen;

            // Parse the full command payload
            result = zclSE_MeteringSnapshotScheduleParse( pCmd );

            if ( result == ZCL_STATUS_SUCCESS )
            {
              // Current command is ready for final processing
              completeCmdReady = TRUE;
            }
            else
            {
              // Reset variables
              free(app_rawPayload);
              app_rawPayload = NULL;
              app_rawPayloadLen = 0;
            }
          }
        }
        else
        {
          // No fragmentation -- just use current command for final processing
          completeCmdReady = TRUE;
        }

        // Is command ready to process, ie the "pSchedules" field is valid
        if ( completeCmdReady )
        {
          // User specific command processing
          app_ProcessMeteringScheduleSnapshot( pCmd );

          // Free variables after using "pCmd->pSchedules" -- it may
          // reference parts of the "app_rawPayload"
          free(app_rawPayload);
          app_rawPayload = NULL;
          app_rawPayloadLen = 0;

          result = ZCL_STATUS_CMD_HAS_RSP;
        }

        return result;
      }
    ==========================================================================
  */
  // If needed, the user can also send a fragmented command by calling
  // "zclSE_MeteringSendScheduleSnapshot" multiple times, setting "cmdIdx",
  // "cmdTotal", and the raw payload fields accordingly.
} zclSE_MeteringScheduleSnapshot_t;

typedef struct
{
  uint32_t cause;
} zclSE_MeteringTakeSnapshot_t;

typedef struct
{
  uint32_t earliestStartTime;
  uint32_t latestEndTime;
  uint8_t offset;
  uint32_t cause;
} zclSE_MeteringGetSnapshot_t;

typedef struct
{
  uint32_t issuerEvtID;
  uint32_t startTime;
  uint8_t type;
  uint16_t reqInterval;
  uint16_t maxNumOfSamples;
} zclSE_MeteringStartSampling_t;

typedef struct
{
  uint16_t sampleID;
  uint32_t earliestTime;
  uint8_t type;
  uint16_t numOfSamples;
} zclSE_MeteringGetSampledData_t;

typedef struct
{
  uint8_t notifScheme;
  uint8_t numOfNotifFlags;
  uint32_t *pNotifFlags;
} zclSE_MeteringMirrorReportAttrRsp_t;

typedef struct
{
  uint32_t providerID;
  uint32_t issuerEvtID;
} zclSE_MeteringResetLoadLimitCntr_t;

typedef struct
{
  uint32_t providerID;
  uint32_t issuerEvtID;
  uint32_t reqTime;
  uint32_t implTime;
  uint8_t propSupplyStatus; // see ZCL_SE_METERING_SUPPLY_STATUS
  uint8_t supplyCtrlBits;
} zclSE_MeteringChangeSupply_t;

typedef struct
{
  uint8_t propSupplyStatus; // see ZCL_SE_METERING_SUPPLY_STATUS
} zclSE_MeteringLocalChangeSupply_t;

typedef struct
{
  uint32_t issuerEvtID;
  uint8_t tamperState; // see ZCL_SE_METERING_SET_SUPPLY_STATUS
  uint8_t depletionState; // see ZCL_SE_METERING_SET_SUPPLY_STATUS
  uint8_t unctrldFlowState; // see ZCL_SE_METERING_SET_SUPPLY_STATUS
  uint8_t loadLimitState; // see ZCL_SE_METERING_SET_SUPPLY_STATUS
} zclSE_MeteringSetSupplyStatus_t;

typedef struct
{
  uint32_t providerID;
  uint32_t issuerEvtID;
  uint16_t unctrldFlowState;
  uint8_t uom;
  uint16_t multi;
  uint16_t div;
  uint8_t stabilisationPeriod;
  uint16_t measurementPeriod;
} zclSE_MeteringSetUnctrldFlowThreshold_t;

//=================================================================================================
// Metering Callbacks(ZCL_CLUSTER_ID_SE_METERING)
//=================================================================================================
// Callback COMMAND_SE_METERING_GET_PROFILE_RSP
typedef void (*zclSE_MeteringGetProfileRspCB_t)( zclIncoming_t *pInMsg,
                                                 zclSE_MeteringGetProfileRsp_t *pCmd );

// Callback COMMAND_SE_METERING_REQ_MIRROR
typedef void (*zclSE_MeteringReqMirrorCB_t)( zclIncoming_t *pInMsg );

// Callback COMMAND_SE_METERING_REMOVE_MIRROR
typedef void (*zclSE_MeteringRemoveMirrorCB_t)( zclIncoming_t *pInMsg );

// Callback COMMAND_SE_METERING_REQ_FAST_POLL_MODE_RSP
typedef void (*zclSE_MeteringReqFastPollModeRspCB_t)(
                 zclIncoming_t *pInMsg,
                 zclSE_MeteringReqFastPollModeRsp_t *pCmd );

// Callback COMMAND_SE_METERING_SCHEDULE_SNAPSHOT_RSP
typedef void (*zclSE_MeteringScheduleSnapshotRspCB_t)(
                 zclIncoming_t *pInMsg,
                 zclSE_MeteringScheduleSnapshotRsp_t *pCmd );

// Callback COMMAND_SE_METERING_TAKE_SNAPSHOT_RSP
typedef void (*zclSE_MeteringTakeSnapshotRspCB_t)( zclIncoming_t *pInMsg,
                                                   zclSE_MeteringTakeSnapshotRsp_t *pCmd );

// Callback COMMAND_SE_METERING_PUBLISH_SNAPSHOT
//  @return ZCL_STATUS_SUCCESS or
//          ZCL_STATUS_MALFORMED_COMMAND
//          ZCL_STATUS_SOFTWARE_FAILURE
typedef ZStatus_t (*zclSE_MeteringPublishSnapshotCB_t)(
                      zclIncoming_t *pInMsg,
                      zclSE_MeteringPublishSnapshot_t *pCmd );

// Callback COMMAND_SE_METERING_GET_SAMPLED_DATA_RSP
typedef void (*zclSE_MeteringGetSampledDataRspCB_t)(
                 zclIncoming_t *pInMsg,
                 zclSE_MeteringGetSampledDataRsp_t *pCmd );

// Callback COMMAND_SE_METERING_CFG_MIRROR
//  @return ZCL_STATUS_SUCCESS or
//          ZCL_STATUS_INVALID_FIELD
typedef ZStatus_t (*zclSE_MeteringCfgMirrorCB_t)( zclIncoming_t *pInMsg,
                                                  zclSE_MeteringCfgMirror_t *pCmd );

// Callback COMMAND_SE_METERING_CFG_NOTIF_SCHEME
typedef void (*zclSE_MeteringCfgNotifSchemeCB_t)( zclIncoming_t *pInMsg,
                                                  zclSE_MeteringCfgNotifScheme_t *pCmd );

// Callback COMMAND_SE_METERING_CFG_NOTIF_FLAG
typedef void (*zclSE_MeteringCfgNotifFlagCB_t)( zclIncoming_t *pInMsg,
                                                zclSE_MeteringCfgNotifFlag_t *pCmd );

// Callback COMMAND_SE_METERING_GET_NOTIF_MSG
typedef void (*zclSE_MeteringGetNotifMsgCB_t)( zclIncoming_t *pInMsg,
                                               zclSE_MeteringGetNotifMsg_t *pCmd );

// Callback COMMAND_SE_METERING_SUPPLY_STATUS_RSP
typedef void (*zclSE_MeteringSupplyStatusRspCB_t)( zclIncoming_t *pInMsg,
                                                   zclSE_MeteringSupplyStatusRsp_t *pCmd );

// Callback COMMAND_SE_METERING_START_SAMPLING_RSP
typedef void (*zclSE_MeteringStartSamplingRspCB_t)( zclIncoming_t *pInMsg,
                                                    zclSE_MeteringStartSamplingRsp_t *pCmd );

// Callback COMMAND_SE_METERING_GET_PROFILE
typedef void (*zclSE_MeteringGetProfileCB_t)( zclIncoming_t *pInMsg,
                                              zclSE_MeteringGetProfile_t *pCmd );

// Callback COMMAND_SE_METERING_REQ_MIRROR_RSP
typedef void (*zclSE_MeteringReqMirrorRspCB_t)( zclIncoming_t *pInMsg,
                                                zclSE_MeteringReqMirrorRsp_t *pCmd );

// Callback COMMAND_SE_METERING_MIRROR_REMOVED
typedef void (*zclSE_MeteringMirrorRemovedCB_t)( zclIncoming_t *pInMsg,
                                                 zclSE_MeteringMirrorRemoved_t *pCmd );

// Callback COMMAND_SE_METERING_REQ_FAST_POLL_MODE
typedef void (*zclSE_MeteringReqFastPollModeCB_t)( zclIncoming_t *pInMsg,
                                                   zclSE_MeteringReqFastPollMode_t *pCmd );

// Callback COMMAND_SE_METERING_SCHEDULE_SNAPSHOT
//  @return ZCL_STATUS_CMD_HAS_RSP or
//          ZCL_STATUS_MALFORMED_COMMAND
//          ZCL_STATUS_SOFTWARE_FAILURE
typedef ZStatus_t (*zclSE_MeteringScheduleSnapshotCB_t)(
                      zclIncoming_t *pInMsg,
                      zclSE_MeteringScheduleSnapshot_t *pCmd );

// Callback COMMAND_SE_METERING_TAKE_SNAPSHOT
typedef void (*zclSE_MeteringTakeSnapshotCB_t)( zclIncoming_t *pInMsg,
                                                zclSE_MeteringTakeSnapshot_t *pCmd );

// Callback COMMAND_SE_METERING_GET_SNAPSHOT
//  @return ZCL_STATUS_CMD_HAS_RSP or
//          ZCL_STATUS_NOT_FOUND
typedef ZStatus_t (*zclSE_MeteringGetSnapshotCB_t)( zclIncoming_t *pInMsg,
                                                    zclSE_MeteringGetSnapshot_t *pCmd );

// Callback COMMAND_SE_METERING_START_SAMPLING
typedef void (*zclSE_MeteringStartSamplingCB_t)( zclIncoming_t *pInMsg,
                                                 zclSE_MeteringStartSampling_t *pCmd );

// Callback COMMAND_SE_METERING_GET_SAMPLED_DATA
//  @return ZCL_STATUS_CMD_HAS_RSP or
//          ZCL_STATUS_NOT_FOUND
typedef ZStatus_t (*zclSE_MeteringGetSampledDataCB_t)(
                      zclIncoming_t *pInMsg,
                      zclSE_MeteringGetSampledData_t *pCmd );

// Callback COMMAND_SE_METERING_MIRROR_REPORT_ATTR_RSP
typedef void (*zclSE_MeteringMirrorReportAttrRspCB_t)(
                 zclIncoming_t *pInMsg,
                 zclSE_MeteringMirrorReportAttrRsp_t *pCmd );

// Callback COMMAND_SE_METERING_RESET_LOAD_LIMIT_CNTR
typedef void (*zclSE_MeteringResetLoadLimitCntrCB_t)(
                 zclIncoming_t *pInMsg,
                 zclSE_MeteringResetLoadLimitCntr_t *pCmd );

// Callback COMMAND_SE_METERING_CHANGE_SUPPLY
//  @return ZCL_STATUS_CMD_HAS_RSP or
//          ZCL_STATUS_SUCCESS
//          ZCL_STATUS_NOT_AUTHORIZED
//          ZCL_STATUS_INVALID_VALUE
typedef ZStatus_t (*zclSE_MeteringChangeSupplyCB_t)(
                      zclIncoming_t *pInMsg,
                      zclSE_MeteringChangeSupply_t *pCmd );

// Callback COMMAND_SE_METERING_LOCAL_CHANGE_SUPPLY
//  @return ZCL_STATUS_SUCCESS or
//          ZCL_STATUS_NOT_AUTHORIZED
typedef ZStatus_t (*zclSE_MeteringLocalChangeSupplyCB_t)(
                      zclIncoming_t *pInMsg,
                      zclSE_MeteringLocalChangeSupply_t *pCmd );

// Callback COMMAND_SE_METERING_SET_SUPPLY_STATUS
typedef void (*zclSE_MeteringSetSupplyStatusCB_t)( zclIncoming_t *pInMsg,
                                                   zclSE_MeteringSetSupplyStatus_t *pCmd );

// Callback COMMAND_SE_METERING_SET_UNCTRLD_FLOW_THRESHOLD
typedef void (*zclSE_MeteringSetUnctrldFlowThresholdCB_t)(
                 zclIncoming_t *pInMsg,
                 zclSE_MeteringSetUnctrldFlowThreshold_t *pCmd );

// Server-to-Client Callbacks
typedef struct
{
  // COMMAND_SE_METERING_GET_PROFILE_RSP
  zclSE_MeteringGetProfileRspCB_t        pfnGetProfileRsp;
  // COMMAND_SE_METERING_REQ_MIRROR
  zclSE_MeteringReqMirrorCB_t            pfnReqMirror;
  // COMMAND_SE_METERING_REMOVE_MIRROR
  zclSE_MeteringRemoveMirrorCB_t         pfnRemoveMirror;
  // COMMAND_SE_METERING_REQ_FAST_POLL_MODE_RSP
  zclSE_MeteringReqFastPollModeRspCB_t   pfnReqFastPollModeRsp;
  // COMMAND_SE_METERING_SCHEDULE_SNAPSHOT_RSP
  zclSE_MeteringScheduleSnapshotRspCB_t  pfnScheduleSnapshotRsp;
  // COMMAND_SE_METERING_TAKE_SNAPSHOT_RSP
  zclSE_MeteringTakeSnapshotRspCB_t      pfnTakeSnapshotRsp;
  // COMMAND_SE_METERING_PUBLISH_SNAPSHOT
  zclSE_MeteringPublishSnapshotCB_t      pfnPublishSnapshot;
  // COMMAND_SE_METERING_GET_SAMPLED_DATA_RSP
  zclSE_MeteringGetSampledDataRspCB_t    pfnGetSampledDataRsp;
  // COMMAND_SE_METERING_CFG_MIRROR
  zclSE_MeteringCfgMirrorCB_t            pfnCfgMirror;
  // COMMAND_SE_METERING_CFG_NOTIF_SCHEME
  zclSE_MeteringCfgNotifSchemeCB_t       pfnCfgNotifScheme;
  // COMMAND_SE_METERING_CFG_NOTIF_FLAG
  zclSE_MeteringCfgNotifFlagCB_t         pfnCfgNotifFlag;
  // COMMAND_SE_METERING_GET_NOTIF_MSG
  zclSE_MeteringGetNotifMsgCB_t          pfnGetNotifMsg;
  // COMMAND_SE_METERING_SUPPLY_STATUS_RSP
  zclSE_MeteringSupplyStatusRspCB_t      pfnSupplyStatusRsp;
  // COMMAND_SE_METERING_START_SAMPLING_RSP
  zclSE_MeteringStartSamplingRspCB_t     pfnStartSamplingRsp;
} zclSE_MeteringClientCBs_t;

// Client-to-Server Callbacks
typedef struct
{
  // COMMAND_SE_METERING_GET_PROFILE
  zclSE_MeteringGetProfileCB_t               pfnGetProfile;
  // COMMAND_SE_METERING_REQ_MIRROR_RSP
  zclSE_MeteringReqMirrorRspCB_t             pfnReqMirrorRsp;
  // COMMAND_SE_METERING_MIRROR_REMOVED
  zclSE_MeteringMirrorRemovedCB_t            pfnMirrorRemoved;
  // COMMAND_SE_METERING_REQ_FAST_POLL_MODE
  zclSE_MeteringReqFastPollModeCB_t          pfnReqFastPollMode;
  // COMMAND_SE_METERING_SCHEDULE_SNAPSHOT
  zclSE_MeteringScheduleSnapshotCB_t         pfnScheduleSnapshot;
  // COMMAND_SE_METERING_TAKE_SNAPSHOT
  zclSE_MeteringTakeSnapshotCB_t             pfnTakeSnapshot;
  // COMMAND_SE_METERING_GET_SNAPSHOT
  zclSE_MeteringGetSnapshotCB_t              pfnGetSnapshot;
  // COMMAND_SE_METERING_START_SAMPLING
  zclSE_MeteringStartSamplingCB_t            pfnStartSampling;
  // COMMAND_SE_METERING_GET_SAMPLED_DATA
  zclSE_MeteringGetSampledDataCB_t           pfnGetSampledData;
  // COMMAND_SE_METERING_MIRROR_REPORT_ATTR_RSP
  zclSE_MeteringMirrorReportAttrRspCB_t      pfnMirrorReportAttrRsp;
  // COMMAND_SE_METERING_RESET_LOAD_LIMIT_CNTR
  zclSE_MeteringResetLoadLimitCntrCB_t       pfnResetLoadLimitCntr;
  // COMMAND_SE_METERING_CHANGE_SUPPLY
  zclSE_MeteringChangeSupplyCB_t             pfnChangeSupply;
  // COMMAND_SE_METERING_LOCAL_CHANGE_SUPPLY
  zclSE_MeteringLocalChangeSupplyCB_t        pfnLocalChangeSupply;
  // COMMAND_SE_METERING_SET_SUPPLY_STATUS
  zclSE_MeteringSetSupplyStatusCB_t          pfnSetSupplyStatus;
  // COMMAND_SE_METERING_SET_UNCTRLD_FLOW_THRESHOLD
  zclSE_MeteringSetUnctrldFlowThresholdCB_t  pfnSetUnctrldFlowThreshold;
} zclSE_MeteringServerCBs_t;

//=================================================================================================
// Price Command Fields(ZCL_CLUSTER_ID_SE_PRICE)
//=================================================================================================
typedef struct
{
  uint32_t providerID;
  UTF8String_t rateLabel;
  uint32_t issuerEvtID;
  uint32_t currTime;
  uint8_t uom;
  uint16_t currency;
  uint8_t priceTrailingDigit; // use low nibble - not shifted
  uint8_t priceTier;
  uint8_t numOfPriceTiers; // use low nibble - not shifted
  uint8_t regTier; // see ZCL_SE_PRICE_REG_TIER
  uint32_t startTime;
  uint16_t duration;
  uint32_t price;
  uint8_t priceRatio;
  uint32_t generationPrice;
  uint8_t generationPriceRatio;
  uint32_t altCostDlvd;
  uint8_t altCostUnit;
  uint8_t altCostTrailingDigit;
  uint8_t numOfBlockThresholds;
  uint8_t priceCtrl;
  uint8_t numOfGenerationTiers;
  uint8_t generationTier;
  uint8_t extNumOfPriceTiers;
  uint8_t extPriceTier;
  uint8_t extRegTier;
} zclSE_PricePublishPrice_t;

typedef struct
{
  uint32_t providerID;
  uint32_t issuerEvtID;
  uint32_t blockPeriodStartTime;
  uint32_t blockPeriodDuration;
  uint8_t blockPeriodCtrl;
  uint8_t blockPeriodDurationCtrl; // use low nibble - not shifted
  uint8_t blockPeriodDurationTimeBase;
  uint8_t tariffType;
  uint8_t tariffResolutionPeriod;
} zclSE_PricePublishBlockPeriod_t;

typedef struct
{
  uint32_t issuerEvtID;
  uint32_t startTime;
  uint32_t conversionFactor;
  uint8_t conversionFactorTrailingDigit;
} zclSE_PricePublishConversionFactor_t;

typedef struct
{
  uint32_t issuerEvtID;
  uint32_t startTime;
  uint32_t calorificValue;
  uint8_t calorificValueUnit;
  uint8_t calorificValueTrailingDigit;
} zclSE_PricePublishCalorificValue_t;

typedef struct
{
  uint32_t providerID;
  uint32_t issuerEvtID;
  uint32_t issuerTariffID;
  uint32_t startTime;
  uint8_t chargingScheme; // use low nibble - not shifted
  uint8_t tariffType;
  UTF8String_t tariffLabel;
  uint8_t priceTiersInUse;
  uint8_t blockThresholdsInUse;
  uint8_t uom;
  uint16_t currency;
  uint8_t priceTrailingDigit;
  uint32_t standingCharge;
  uint8_t tierBlockMode;
  uint32_t blockThresholdMult;
  uint32_t blockThresholdDiv;
} zclSE_PricePublishTariffInfo_t;

typedef struct
{
  uint8_t blockID; // not used for TOU based
  uint8_t tier; // use low bits - not shifted
  uint32_t price;
} zclSE_PriceMatrixSubFld_t;

typedef struct
{
  uint32_t providerID;
  uint32_t issuerEvtID;
  uint32_t startTime;
  uint32_t issuerTariffID;
  uint8_t cmdIdx;
  uint8_t cmdTotal;
  uint8_t subFldCtrl;

  uint8_t numOfSubFlds;

  // May be empty if fragmented -- see raw payload fields below
  zclSE_PriceMatrixSubFld_t *pSubFlds;

  // Raw payloads are used to send and receive fragmented commands -- see below
  uint16_t rawPayloadLen;
  uint8_t *pRawPayload;

  // Depending on the length of the entire command, the command may be
  // fragmented.  If the command is fragmented the "pSubFlds" field will be
  // empty and the raw payload fields will be set.  When receiving fragmented
  // commands the user is responsible to concatenate all the fragments into one
  // complete "pRawPayload" field.  Once the entire "pRawPayload" has been built
  // from all the fragments, the user can then call
  // "zclSE_PriceMatrixSubFldParse" to parse the "pRawPayload" and build
  // a valid "pSubFlds" field.  A simple example is provided below.  Note that
  // the function "zclSE_PriceMatrixSubFldParse" should be called from
  // within the context of a COMMAND_SE_PRICE_PUBLISH_PRICE_MATRIX callback
  // function -- see example below.
  //
  //  EXAMPLE CALLBACK HANDLER:
  //  ==========================================================================
  /*
      // Local vars to build raw concatenated payload from multipe fragments
      static uint8_t app_rawPayloadLen = 0;
      static uint8_t *app_rawPayload = NULL;

      // Callback for COMMAND_SE_PRICE_PUBLISH_PRICE_MATRIX
      uint8_t app_PricePublishPriceMatrixCB(
              zclIncoming_t *pInMsg,
              zclSE_PricePublishPriceMatrix_t *pCmd )
      {
        uint8_t result = ZCL_STATUS_SUCCESS;
        uint8_t parseResult;
        uint8_t completeCmdReady = FALSE;

        if ( pCmd->cmdTotal > 1 )
        {
          // Simple example of concatenating command fragments
          app_rawPayload = realloc( app_rawPayload,
                                    app_rawPayloadLen + pCmd->rawPayloadLen);
          if (app_rawPayload == NULL )
          {
            return ZCL_STATUS_SOFTWARE_FAILURE;
          }

          OsalPort_memcpy( &app_rawPayload[app_rawPayloadLen],
                  pCmd->pRawPayload,
                  pCmd->rawPayloadLen );

          app_rawPayloadLen += pCmd->rawPayloadLen;

          // Is this the last fragment
          if ( ( pCmd->cmdIdx + 1 ) == pCmd->cmdTotal )
          {
             // Set the full raw payload fields
             pCmd->pRawPayload = app_rawPayload;
             pCmd->rawPayloadLen = app_rawPayloadLen;

            // Parse the full command payload
            result = zclSE_PriceMatrixSubFldParse( pCmd );

            if ( result == ZCL_STATUS_SUCCESS )
            {
              // Current command is ready for final processing
              completeCmdReady = TRUE;
            }
            else
            {
              // Reset variables
              free(app_rawPayload);
              app_rawPayload = NULL;
              app_rawPayloadLen = 0;
            }
          }
        }
        else
        {
          // No fragmentation -- just use current command for final processing
          completeCmdReady = TRUE;
        }

        // Is command ready to process, ie the "pSubFlds" field is valid
        if ( completeCmdReady )
        {
          // User specific command processing
          app_ProcessPricePublishPriceMatrix( pCmd );

          // Free variables after using "pCmd->pSubFlds" -- it may
          // reference parts of the "app_rawPayload"
          free(app_rawPayload);
          app_rawPayload = NULL;
          app_rawPayloadLen = 0;

          result = ZCL_STATUS_SUCCESS;
        }

        return result;
      }
    ==========================================================================
  */
  // If needed, the user can also send a fragmented command by calling
  // "zclSE_PriceSendPublishPriceMatrix" multiple times, setting "cmdIdx",
  // "cmdTotal", and the raw payload fields accordingly.
} zclSE_PricePublishPriceMatrix_t;

typedef struct
{
  uint8_t tier; // use low bits - not shifted
  uint8_t numOfBlockThresholds;
  uint8_t (*pBlockThresholds)[ZCL_SE_PRICE_BLOCK_THRESHOLD_LEN];
} zclSE_PriceBlockThresholdSubFld_t;

typedef struct
{
  uint32_t providerID;
  uint32_t issuerEvtID;
  uint32_t startTime;
  uint32_t issuerTariffID;
  uint8_t cmdIdx;
  uint8_t cmdTotal;
  uint8_t subFldCtrl;

  uint8_t numOfSubFlds;

  // May be empty if fragmented -- see raw payload fields below
  zclSE_PriceBlockThresholdSubFld_t *pSubFlds;

  // Raw payloads are used to send and receive fragmented commands -- see below
  uint16_t rawPayloadLen;
  uint8_t *pRawPayload;

  // Depending on the length of the entire command, the command may be
  // fragmented.  If the command is fragmented the "pSubFlds" field will be
  // empty and the raw payload fields will be set.  When receiving fragmented
  // commands the user is responsible to concatenate all the fragments into one
  // complete "pRawPayload" field.  Once the entire "pRawPayload" has been built
  // from all the fragments, the user can then call
  // "zclSE_PriceBlockThresholdSubFldParse" to parse the "pRawPayload" and build
  // a valid "pSubFlds" field.  A simple example is provided below.  Note that
  // the function "zclSE_PriceBlockThresholdSubFldParse" should be called from
  // within the context of a COMMAND_SE_PRICE_PUBLISH_BLOCK_THRESHOLD callback
  // function -- see example below.
  //
  //  EXAMPLE CALLBACK HANDLER:
  //  ==========================================================================
  /*
      // Local vars to build raw concatenated payload from multipe fragments
      static uint8_t app_rawPayloadLen = 0;
      static uint8_t *app_rawPayload = NULL;

      // Callback for COMMAND_SE_PRICE_PUBLISH_BLOCK_THRESHOLD
      uint8_t app_PricePublishBlockThresholdCB(
              zclIncoming_t *pInMsg,
              zclSE_PricePublishBlockThreshold_t *pCmd )
      {
        uint8_t result = ZCL_STATUS_SUCCESS;
        uint8_t parseResult;
        uint8_t completeCmdReady = FALSE;

        if ( pCmd->cmdTotal > 1 )
        {
          // Simple example of concatenating command fragments
          app_rawPayload = realloc( app_rawPayload,
                                    app_rawPayloadLen + pCmd->rawPayloadLen);
          if (app_rawPayload == NULL )
          {
            return ZCL_STATUS_SOFTWARE_FAILURE;
          }

          OsalPort_memcpy( &app_rawPayload[app_rawPayloadLen],
                  pCmd->pRawPayload,
                  pCmd->rawPayloadLen );

          app_rawPayloadLen += pCmd->rawPayloadLen;

          // Is this the last fragment
          if ( ( pCmd->cmdIdx + 1 ) == pCmd->cmdTotal )
          {
             // Set the full raw payload fields
             pCmd->pRawPayload = app_rawPayload;
             pCmd->rawPayloadLen = app_rawPayloadLen;

            // Parse the full command payload
            result = zclSE_PriceBlockThresholdSubFldParse( pCmd );

            if ( result == ZCL_STATUS_SUCCESS )
            {
              // Current command is ready for final processing
              completeCmdReady = TRUE;
            }
            else
            {
              // Reset variables
              free(app_rawPayload);
              app_rawPayload = NULL;
              app_rawPayloadLen = 0;
            }
          }
        }
        else
        {
          // No fragmentation -- just use current command for final processing
          completeCmdReady = TRUE;
        }

        // Is command ready to process, ie the "pSubFlds" field is valid
        if ( completeCmdReady )
        {
          // User specific command processing
          app_ProcessPricePublishBlockThreshold( pCmd );

          // Free variables after using "pCmd->pSubFlds" -- it may
          // reference parts of the "app_rawPayload"
          free(app_rawPayload);
          app_rawPayload = NULL;
          app_rawPayloadLen = 0;

          result = ZCL_STATUS_SUCCESS;
        }

        return result;
      }
    ==========================================================================
  */
  // If needed, the user can also send a fragmented command by calling
  // "zclSE_PriceSendPublishBlockThreshold" multiple times, setting "cmdIdx",
  // "cmdTotal", and the raw payload fields accordingly.
} zclSE_PricePublishBlockThreshold_t;

typedef struct
{
  uint32_t providerID;
  uint32_t issuerEvtID;
  uint32_t startTime;
  uint8_t tariffType;
  uint32_t co2Value;
  uint8_t co2ValueUnit;
  uint8_t co2ValueTrailingDigit;
} zclSE_PricePublishCO2Value_t;

typedef struct
{
  uint8_t tierID;
  UTF8String_t tierLabel;
} zclSE_PriceTierLabel_t;

typedef struct
{
  uint32_t providerID;
  uint32_t issuerEvtID;
  uint32_t issuerTariffID;
  uint8_t cmdIdx;
  uint8_t cmdTotal;
  uint8_t numOfTierLabels;

  // May be empty if fragmented -- see raw payload fields below
  zclSE_PriceTierLabel_t *pTierLabels;

  // Raw payloads are used to send and receive fragmented commands -- see below
  uint16_t rawPayloadLen;
  uint8_t *pRawPayload;

  // Depending on the length of the entire command, the command may be
  // fragmented.  If the command is fragmented the "pTierLabels" field will be
  // empty and the raw payload fields will be set.  When receiving fragmented
  // commands the user is responsible to concatenate all the fragments into one
  // complete "pRawPayload" field.  Once the entire "pRawPayload" has been built
  // from all the fragments, the user can then call
  // "zclSE_PriceTierLabelParse" to parse the "pRawPayload" and build
  // a valid "pTierLabels" field.  A simple example is provided below.  Note
  // that the function "zclSE_PriceTierLabelParse" should be called from
  // within the context of a COMMAND_SE_PRICE_PUBLISH_TIER_LABELS callback
  // function -- see example below.
  //
  //  EXAMPLE CALLBACK HANDLER:
  //  ==========================================================================
  /*
      // Local vars to build raw concatenated payload from multipe fragments
      static uint8_t app_rawPayloadLen = 0;
      static uint8_t *app_rawPayload = NULL;

      // Callback for COMMAND_SE_PRICE_PUBLISH_TIER_LABELS
      uint8_t app_PricePublishTierLabelsCB(
              zclIncoming_t *pInMsg,
              zclSE_PricePublishTierLabels_t *pCmd )
      {
        uint8_t result = ZCL_STATUS_SUCCESS;
        uint8_t parseResult;
        uint8_t completeCmdReady = FALSE;

        if ( pCmd->cmdTotal > 1 )
        {
          // Simple example of concatenating command fragments
          app_rawPayload = realloc( app_rawPayload,
                                    app_rawPayloadLen + pCmd->rawPayloadLen);
          if (app_rawPayload == NULL )
          {
            return ZCL_STATUS_SOFTWARE_FAILURE;
          }

          OsalPort_memcpy( &app_rawPayload[app_rawPayloadLen],
                  pCmd->pRawPayload,
                  pCmd->rawPayloadLen );

          app_rawPayloadLen += pCmd->rawPayloadLen;

          // Is this the last fragment
          if ( ( pCmd->cmdIdx + 1 ) == pCmd->cmdTotal )
          {
             // Set the full raw payload fields
             pCmd->pRawPayload = app_rawPayload;
             pCmd->rawPayloadLen = app_rawPayloadLen;

            // Parse the full command payload
            result = zclSE_PriceTierLabelParse( pCmd );

            if ( result == ZCL_STATUS_SUCCESS )
            {
              // Current command is ready for final processing
              completeCmdReady = TRUE;
            }
            else
            {
              // Reset variables
              free(app_rawPayload);
              app_rawPayload = NULL;
              app_rawPayloadLen = 0;
            }
          }
        }
        else
        {
          // No fragmentation -- just use current command for final processing
          completeCmdReady = TRUE;
        }

        // Is command ready to process, ie the "pTierLabels" field is valid
        if ( completeCmdReady )
        {
          // User specific command processing
          app_ProcessPricePublishTierLabels( pCmd );

          // Free variables after using "pCmd->pTierLabels" -- it may
          // reference parts of the "app_rawPayload"
          free(app_rawPayload);
          app_rawPayload = NULL;
          app_rawPayloadLen = 0;

          result = ZCL_STATUS_SUCCESS;
        }

        return result;
      }
    ==========================================================================
  */
  // If needed, the user can also send a fragmented command by calling
  // "zclSE_PriceSendPublishTierLabels" multiple times, setting "cmdIdx",
  // "cmdTotal", and the raw payload fields accordingly.
} zclSE_PricePublishTierLabels_t;

typedef struct
{
  uint32_t providerID;
  uint32_t issuerEvtID;
  uint32_t billPeriodStartTime;
  uint32_t billPeriodDuration;
  uint8_t billPeriodDurationTimeCtrl; // use low nibble - not shifted
  uint8_t billPeriodDurationTimeBase;
  uint8_t tariffType;
} zclSE_PricePublishBillPeriod_t;

typedef struct
{
  uint32_t providerID;
  uint32_t issuerEvtID;
  uint32_t billPeriodStartTime;
  uint32_t billPeriodDuration;
  uint8_t billPeriodDurationTimeCtrl; // use low nibble - not shifted
  uint8_t billPeriodDurationTimeBase;
  uint8_t tariffType;
  uint32_t consolidatedBill;
  uint16_t currency;
  uint8_t billTrailingDigit;
} zclSE_PricePublishConsolidatedBill_t;

typedef struct
{
  uint32_t providerID;
  uint32_t issuerEvtID;
  uint32_t startTime;
  uint16_t duration;
  uint8_t tariffType;
  uint8_t cppPriceTier;
  uint8_t cppAuth;
} zclSE_PricePublishCPPEvt_t;

typedef struct
{
  uint32_t providerID;
  uint32_t issuerEvtID;
  uint32_t creditPaymentDueDate;
  uint32_t creditPaymentOverdueAmnt;
  uint8_t creditPaymentStatus;
  uint32_t creditPayment;
  uint32_t creditPaymentDate;
  UTF8String_t creditPaymentRef;
} zclSE_PricePublishCreditPayment_t;

typedef struct
{
  uint32_t providerID;
  uint32_t issuerEvtID;
  uint32_t startTime;
  uint16_t oldCurrency;
  uint16_t newCurrency;
  uint32_t conversionFactor;
  uint8_t conversionFactorTrailingDigit;
  uint32_t currencyChangeCtrlFlag;
} zclSE_PricePublishCurrencyConversion_t;

typedef struct
{
  uint32_t providerID;
  uint32_t issuerTariffID;
  uint8_t tariffType;
} zclSE_PriceCancelTariff_t;

typedef struct
{
  uint8_t options;
} zclSE_PriceGetCurrPrice_t;

typedef struct
{
  uint32_t startTime;
  uint8_t numOfEvts;
} zclSE_PriceGetScheduledPrice_t;

typedef struct
{
  uint32_t providerID;
  uint32_t issuerEvtID;
  uint32_t priceAckTime;
  uint8_t ctrl;
} zclSE_PricePriceAck_t;

typedef struct
{
  uint32_t startTime;
  uint8_t numOfEvts;
  uint8_t tariffType;
} zclSE_PriceGetBlockPeriod_t;

typedef struct
{
  uint32_t earliestStartTime;
  uint32_t minIssuerEvtID;
  uint8_t numOfCmds;
} zclSE_PriceGetConversionFactor_t;

typedef struct
{
  uint32_t earliestStartTime;
  uint32_t minIssuerEvtID;
  uint8_t numOfCmds;
} zclSE_PriceGetCalorificValue_t;

typedef struct
{
  uint32_t earliestStartTime;
  uint32_t minIssuerEvtID;
  uint8_t numOfCmds;
  uint8_t tariffType;
} zclSE_PriceGetTariffInfo_t;

typedef struct
{
  uint32_t issuerTariffID;
} zclSE_PriceGetPriceMatrix_t;

typedef struct
{
  uint32_t issuerTariffID;
} zclSE_PriceGetBlockThresholds_t;

typedef struct
{
  uint32_t earliestStartTime;
  uint32_t minIssuerEvtID;
  uint8_t numOfCmds;
  uint8_t tariffType;
} zclSE_PriceGetCO2Value_t;

typedef struct
{
  uint32_t issuerTariffID;
} zclSE_PriceGetTierLabels_t;

typedef struct
{
  uint32_t earliestStartTime;
  uint32_t minIssuerEvtID;
  uint8_t numOfCmds;
  uint8_t tariffType;
} zclSE_PriceGetBillPeriod_t;

typedef struct
{
  uint32_t earliestStartTime;
  uint32_t minIssuerEvtID;
  uint8_t numOfCmds;
  uint8_t tariffType;
} zclSE_PriceGetConsolidatedBill_t;

typedef struct
{
  uint32_t issuerEvtID;
  uint8_t cppAuth;
} zclSE_PriceCPPEvtRsp_t;

typedef struct
{
  uint32_t latestEndTime;
  uint8_t numOfRecords;
} zclSE_PriceGetCreditPayment_t;

//=================================================================================================
// Price Callbacks(ZCL_CLUSTER_ID_SE_PRICE)
//=================================================================================================
// Callback COMMAND_SE_PRICE_PUBLISH_PRICE
typedef void (*zclSE_PricePublishPriceCB_t)( zclIncoming_t *pInMsg,
                                             zclSE_PricePublishPrice_t *pCmd );

// Callback COMMAND_SE_PRICE_PUBLISH_BLOCK_PERIOD
typedef void (*zclSE_PricePublishBlockPeriodCB_t)( zclIncoming_t *pInMsg,
                                                   zclSE_PricePublishBlockPeriod_t *pCmd );

// Callback COMMAND_SE_PRICE_PUBLISH_CONVERSION_FACTOR
typedef void (*zclSE_PricePublishConversionFactorCB_t)(
                 zclIncoming_t *pInMsg,
                 zclSE_PricePublishConversionFactor_t *pCmd );

// Callback COMMAND_SE_PRICE_PUBLISH_CALORIFIC_VALUE
typedef void (*zclSE_PricePublishCalorificValueCB_t)(
                 zclIncoming_t *pInMsg,
                 zclSE_PricePublishCalorificValue_t *pCmd );

// Callback COMMAND_SE_PRICE_PUBLISH_TARIFF_INFO
//  @return ZCL_STATUS_SUCCESS or
//          ZCL_STATUS_INSUFFICIENT_SPACE
typedef ZStatus_t (*zclSE_PricePublishTariffInfoCB_t)(
                      zclIncoming_t *pInMsg,
                      zclSE_PricePublishTariffInfo_t *pCmd );

// Callback COMMAND_SE_PRICE_PUBLISH_PRICE_MATRIX
//  @return ZCL_STATUS_SUCCESS or
//          ZCL_STATUS_MALFORMED_COMMAND
//          ZCL_STATUS_SOFTWARE_FAILURE
typedef ZStatus_t (*zclSE_PricePublishPriceMatrixCB_t)(
                      zclIncoming_t *pInMsg,
                      zclSE_PricePublishPriceMatrix_t *pCmd );

// Callback COMMAND_SE_PRICE_PUBLISH_BLOCK_THRESHOLD
//  @return ZCL_STATUS_SUCCESS or
//          ZCL_STATUS_MALFORMED_COMMAND
//          ZCL_STATUS_SOFTWARE_FAILURE
typedef ZStatus_t (*zclSE_PricePublishBlockThresholdCB_t)(
                      zclIncoming_t *pInMsg,
                      zclSE_PricePublishBlockThreshold_t *pCmd );

// Callback COMMAND_SE_PRICE_PUBLISH_CO2_VALUE
typedef void (*zclSE_PricePublishCO2ValueCB_t)( zclIncoming_t *pInMsg,
                                                zclSE_PricePublishCO2Value_t *pCmd );

// Callback COMMAND_SE_PRICE_PUBLISH_TIER_LABELS
//  @return ZCL_STATUS_SUCCESS or
//          ZCL_STATUS_MALFORMED_COMMAND
//          ZCL_STATUS_SOFTWARE_FAILURE
typedef ZStatus_t (*zclSE_PricePublishTierLabelsCB_t)(
                      zclIncoming_t *pInMsg,
                      zclSE_PricePublishTierLabels_t *pCmd );

// Callback COMMAND_SE_PRICE_PUBLISH_BILL_PERIOD
typedef void (*zclSE_PricePublishBillPeriodCB_t)( zclIncoming_t *pInMsg,
                                                  zclSE_PricePublishBillPeriod_t *pCmd );

// Callback COMMAND_SE_PRICE_PUBLISH_CONSOLIDATED_BILL
typedef void (*zclSE_PricePublishConsolidatedBillCB_t)(
                 zclIncoming_t *pInMsg,
                 zclSE_PricePublishConsolidatedBill_t *pCmd );

// Callback COMMAND_SE_PRICE_PUBLISH_CPP_EVT
typedef void (*zclSE_PricePublishCPPEvtCB_t)( zclIncoming_t *pInMsg,
                                              zclSE_PricePublishCPPEvt_t *pCmd );

// Callback COMMAND_SE_PRICE_PUBLISH_CREDIT_PAYMENT
typedef void (*zclSE_PricePublishCreditPaymentCB_t)(
                 zclIncoming_t *pInMsg,
                 zclSE_PricePublishCreditPayment_t *pCmd );

// Callback COMMAND_SE_PRICE_PUBLISH_CURRENCY_CONVERSION
typedef void (*zclSE_PricePublishCurrencyConversionCB_t)(
                 zclIncoming_t *pInMsg,
                 zclSE_PricePublishCurrencyConversion_t *pCmd );

// Callback COMMAND_SE_PRICE_CANCEL_TARIFF
typedef void (*zclSE_PriceCancelTariffCB_t)( zclIncoming_t *pInMsg,
                                             zclSE_PriceCancelTariff_t *pCmd );

// Callback COMMAND_SE_PRICE_GET_CURR_PRICE
//  @return ZCL_STATUS_CMD_HAS_RSP or
//          ZCL_STATUS_NOT_FOUND
typedef ZStatus_t (*zclSE_PriceGetCurrPriceCB_t)( zclIncoming_t *pInMsg,
                                                  zclSE_PriceGetCurrPrice_t *pCmd );

// Callback COMMAND_SE_PRICE_GET_SCHEDULED_PRICE
//  @return ZCL_STATUS_CMD_HAS_RSP or
//          ZCL_STATUS_NOT_FOUND
typedef ZStatus_t (*zclSE_PriceGetScheduledPriceCB_t)(
                      zclIncoming_t *pInMsg,
                      zclSE_PriceGetScheduledPrice_t *pCmd );

// Callback COMMAND_SE_PRICE_PRICE_ACK
typedef void (*zclSE_PricePriceAckCB_t)( zclIncoming_t *pInMsg,
                                         zclSE_PricePriceAck_t *pCmd );

// Callback COMMAND_SE_PRICE_GET_BLOCK_PERIOD
//  @return ZCL_STATUS_CMD_HAS_RSP or
//          ZCL_STATUS_NOT_FOUND
typedef ZStatus_t (*zclSE_PriceGetBlockPeriodCB_t)( zclIncoming_t *pInMsg,
                                                    zclSE_PriceGetBlockPeriod_t *pCmd );

// Callback COMMAND_SE_PRICE_GET_CONVERSION_FACTOR
//  @return ZCL_STATUS_CMD_HAS_RSP or
//          ZCL_STATUS_NOT_FOUND
typedef ZStatus_t (*zclSE_PriceGetConversionFactorCB_t)( zclIncoming_t *pInMsg,
                                                         zclSE_PriceGetConversionFactor_t *pCmd );

// Callback COMMAND_SE_PRICE_GET_CALORIFIC_VALUE
//  @return ZCL_STATUS_CMD_HAS_RSP or
//          ZCL_STATUS_NOT_FOUND
typedef ZStatus_t (*zclSE_PriceGetCalorificValueCB_t)(
                      zclIncoming_t *pInMsg,
                      zclSE_PriceGetCalorificValue_t *pCmd );

// Callback COMMAND_SE_PRICE_GET_TARIFF_INFO
//  @return ZCL_STATUS_CMD_HAS_RSP or
//          ZCL_STATUS_NOT_FOUND
typedef ZStatus_t (*zclSE_PriceGetTariffInfoCB_t)( zclIncoming_t *pInMsg,
                                                   zclSE_PriceGetTariffInfo_t *pCmd );

// Callback COMMAND_SE_PRICE_GET_PRICE_MATRIX
//  @return ZCL_STATUS_CMD_HAS_RSP or
//          ZCL_STATUS_NOT_FOUND
typedef ZStatus_t (*zclSE_PriceGetPriceMatrixCB_t)( zclIncoming_t *pInMsg,
                                                    zclSE_PriceGetPriceMatrix_t *pCmd );

// Callback COMMAND_SE_PRICE_GET_BLOCK_THRESHOLDS
//  @return ZCL_STATUS_CMD_HAS_RSP or
//          ZCL_STATUS_NOT_FOUND
typedef ZStatus_t (*zclSE_PriceGetBlockThresholdsCB_t)(
                      zclIncoming_t *pInMsg,
                      zclSE_PriceGetBlockThresholds_t *pCmd );

// Callback COMMAND_SE_PRICE_GET_CO2_VALUE
//  @return ZCL_STATUS_CMD_HAS_RSP or
//          ZCL_STATUS_NOT_FOUND
typedef ZStatus_t (*zclSE_PriceGetCO2ValueCB_t)( zclIncoming_t *pInMsg,
                                                 zclSE_PriceGetCO2Value_t *pCmd );

// Callback COMMAND_SE_PRICE_GET_TIER_LABELS
//  @return ZCL_STATUS_CMD_HAS_RSP or
//          ZCL_STATUS_NOT_FOUND
typedef ZStatus_t (*zclSE_PriceGetTierLabelsCB_t)( zclIncoming_t *pInMsg,
                                                   zclSE_PriceGetTierLabels_t *pCmd );

// Callback COMMAND_SE_PRICE_GET_BILL_PERIOD
//  @return ZCL_STATUS_CMD_HAS_RSP or
//          ZCL_STATUS_NOT_FOUND
typedef ZStatus_t (*zclSE_PriceGetBillPeriodCB_t)( zclIncoming_t *pInMsg,
                                                   zclSE_PriceGetBillPeriod_t *pCmd );

// Callback COMMAND_SE_PRICE_GET_CONSOLIDATED_BILL
//  @return ZCL_STATUS_CMD_HAS_RSP or
//          ZCL_STATUS_NOT_FOUND
typedef ZStatus_t (*zclSE_PriceGetConsolidatedBillCB_t)(
                      zclIncoming_t *pInMsg,
                      zclSE_PriceGetConsolidatedBill_t *pCmd );

// Callback COMMAND_SE_PRICE_CPP_EVT_RSP
typedef void (*zclSE_PriceCPPEvtRspCB_t)( zclIncoming_t *pInMsg,
                                          zclSE_PriceCPPEvtRsp_t *pCmd );

// Callback COMMAND_SE_PRICE_GET_CREDIT_PAYMENT
//  @return ZCL_STATUS_CMD_HAS_RSP or
//          ZCL_STATUS_NOT_FOUND
typedef ZStatus_t (*zclSE_PriceGetCreditPaymentCB_t)(
                      zclIncoming_t *pInMsg,
                      zclSE_PriceGetCreditPayment_t *pCmd );

// Callback COMMAND_SE_PRICE_GET_CURRENCY_CONVERSION
//  @return ZCL_STATUS_CMD_HAS_RSP or
//          ZCL_STATUS_NOT_FOUND
typedef ZStatus_t (*zclSE_PriceGetCurrencyConversionCB_t)(
                      zclIncoming_t *pInMsg );

// Callback COMMAND_SE_PRICE_GET_TARIFF_CANCELLATION
//  @return ZCL_STATUS_CMD_HAS_RSP or
//          ZCL_STATUS_NOT_FOUND
typedef ZStatus_t (*zclSE_PriceGetTariffCancellationCB_t)(
                      zclIncoming_t *pInMsg );

typedef struct
{
  // COMMAND_SE_PRICE_PUBLISH_PRICE
  zclSE_PricePublishPriceCB_t               pfnPublishPrice;
  // COMMAND_SE_PRICE_PUBLISH_BLOCK_PERIOD
  zclSE_PricePublishBlockPeriodCB_t         pfnPublishBlockPeriod;
  // COMMAND_SE_PRICE_PUBLISH_CONVERSION_FACTOR
  zclSE_PricePublishConversionFactorCB_t    pfnPublishConversionFactor;
  // COMMAND_SE_PRICE_PUBLISH_CALORIFIC_VALUE
  zclSE_PricePublishCalorificValueCB_t      pfnPublishCalorificValue;
  // COMMAND_SE_PRICE_PUBLISH_TARIFF_INFO
  zclSE_PricePublishTariffInfoCB_t          pfnPublishTariffInfo;
  // COMMAND_SE_PRICE_PUBLISH_PRICE_MATRIX
  zclSE_PricePublishPriceMatrixCB_t         pfnPublishPriceMatrix;
  // COMMAND_SE_PRICE_PUBLISH_BLOCK_THRESHOLD
  zclSE_PricePublishBlockThresholdCB_t      pfnPublishBlockThreshold;
  // COMMAND_SE_PRICE_PUBLISH_CO2_VALUE
  zclSE_PricePublishCO2ValueCB_t            pfnPublishCO2Value;
  // COMMAND_SE_PRICE_PUBLISH_TIER_LABELS
  zclSE_PricePublishTierLabelsCB_t          pfnPublishTierLabels;
  // COMMAND_SE_PRICE_PUBLISH_BILL_PERIOD
  zclSE_PricePublishBillPeriodCB_t          pfnPublishBillPeriod;
  // COMMAND_SE_PRICE_PUBLISH_CONSOLIDATED_BILL
  zclSE_PricePublishConsolidatedBillCB_t    pfnPublishConsolidatedBill;
  // COMMAND_SE_PRICE_PUBLISH_CPP_EVT
  zclSE_PricePublishCPPEvtCB_t              pfnPublishCPPEvt;
  // COMMAND_SE_PRICE_PUBLISH_CREDIT_PAYMENT
  zclSE_PricePublishCreditPaymentCB_t       pfnPublishCreditPayment;
  // COMMAND_SE_PRICE_PUBLISH_CURRENCY_CONVERSION
  zclSE_PricePublishCurrencyConversionCB_t  pfnPublishCurrencyConversion;
  // COMMAND_SE_PRICE_CANCEL_TARIFF
  zclSE_PriceCancelTariffCB_t               pfnCancelTariff;
} zclSE_PriceClientCBs_t;

// Client-to-Server Callbacks
typedef struct
{
  // COMMAND_SE_PRICE_GET_CURR_PRICE
  zclSE_PriceGetCurrPriceCB_t           pfnGetCurrPrice;
  // COMMAND_SE_PRICE_GET_SCHEDULED_PRICE
  zclSE_PriceGetScheduledPriceCB_t      pfnGetScheduledPrice;
  // COMMAND_SE_PRICE_PRICE_ACK
  zclSE_PricePriceAckCB_t               pfnPriceAck;
  // COMMAND_SE_PRICE_GET_BLOCK_PERIOD
  zclSE_PriceGetBlockPeriodCB_t         pfnGetBlockPeriod;
  // COMMAND_SE_PRICE_GET_CONVERSION_FACTOR
  zclSE_PriceGetConversionFactorCB_t    pfnGetConversionFactor;
  // COMMAND_SE_PRICE_GET_CALORIFIC_VALUE
  zclSE_PriceGetCalorificValueCB_t      pfnGetCalorificValue;
  // COMMAND_SE_PRICE_GET_TARIFF_INFO
  zclSE_PriceGetTariffInfoCB_t          pfnGetTariffInfo;
  // COMMAND_SE_PRICE_GET_PRICE_MATRIX
  zclSE_PriceGetPriceMatrixCB_t         pfnGetPriceMatrix;
  // COMMAND_SE_PRICE_GET_BLOCK_THRESHOLDS
  zclSE_PriceGetBlockThresholdsCB_t     pfnGetBlockThresholds;
  // COMMAND_SE_PRICE_GET_CO2_VALUE
  zclSE_PriceGetCO2ValueCB_t            pfnGetCO2Value;
  // COMMAND_SE_PRICE_GET_TIER_LABELS
  zclSE_PriceGetTierLabelsCB_t          pfnGetTierLabels;
  // COMMAND_SE_PRICE_GET_BILL_PERIOD
  zclSE_PriceGetBillPeriodCB_t          pfnGetBillPeriod;
  // COMMAND_SE_PRICE_GET_CONSOLIDATED_BILL
  zclSE_PriceGetConsolidatedBillCB_t    pfnGetConsolidatedBill;
  // COMMAND_SE_PRICE_CPP_EVT_RSP
  zclSE_PriceCPPEvtRspCB_t              pfnCPPEvtRsp;
  // COMMAND_SE_PRICE_GET_CREDIT_PAYMENT
  zclSE_PriceGetCreditPaymentCB_t       pfnGetCreditPayment;
  // COMMAND_SE_PRICE_GET_CURRENCY_CONVERSION
  zclSE_PriceGetCurrencyConversionCB_t  pfnGetCurrencyConversion;
  // COMMAND_SE_PRICE_GET_TARIFF_CANCELLATION
  zclSE_PriceGetTariffCancellationCB_t  pfnGetTariffCancellation;
} zclSE_PriceServerCBs_t;

//=================================================================================================
// Messaging Command Fields(ZCL_CLUSTER_ID_SE_MESSAGING)
//=================================================================================================
typedef struct
{
  uint8_t transmission;
  uint8_t importanceLevel;
  uint8_t enhancedCfmRequired;
  uint8_t msgCfmRequired;
} zclSE_MessagingMsgCtrl_t;

typedef struct
{
  uint8_t msgConfirmed;
} zclSE_MessagingExtMsgCtrl_t;

typedef struct
{
  uint32_t msgID;
  zclSE_MessagingMsgCtrl_t msgCtrl;
  uint32_t startTime;
  uint16_t duration;
  UTF8String_t msg;
  zclSE_MessagingExtMsgCtrl_t extMsgCtrl;
} zclSE_MessagingDisplayMsg_t;

typedef struct
{
  uint32_t msgID;
  uint8_t msgCtrl;
} zclSE_MessagingCancelMsg_t;

typedef struct
{
  uint32_t implTime;
} zclSE_MessagingCancelAllMsgs_t;

typedef struct
{
  uint32_t msgID;
  uint32_t cfmTime;
  uint8_t msgCfmCtrl;
  UTF8String_t msgCfmRsp;
} zclSE_MessagingMsgCfm_t;

typedef struct
{
  uint32_t earliestImplTime;
} zclSE_MessagingGetMsgCancellation_t;

//=================================================================================================
// Messaging Callbacks(ZCL_CLUSTER_ID_SE_MESSAGING)
//=================================================================================================
// Callback COMMAND_SE_MESSAGING_DISPLAY_MSG
typedef void (*zclSE_MessagingDisplayMsgCB_t)( zclIncoming_t *pInMsg,
                                               zclSE_MessagingDisplayMsg_t *pCmd );

// Callback COMMAND_SE_MESSAGING_CANCEL_MSG
typedef void (*zclSE_MessagingCancelMsgCB_t)( zclIncoming_t *pInMsg,
                                              zclSE_MessagingCancelMsg_t *pCmd );

// Callback COMMAND_SE_MESSAGING_DISPLAY_PROTECTED_MSG
typedef void (*zclSE_MessagingDisplayProtectedMsgCB_t)(
                 zclIncoming_t *pInMsg,
                 zclSE_MessagingDisplayMsg_t *pCmd );

// Callback COMMAND_SE_MESSAGING_CANCEL_ALL_MSGS
typedef void (*zclSE_MessagingCancelAllMsgsCB_t)( zclIncoming_t *pInMsg,
                                                  zclSE_MessagingCancelAllMsgs_t *pCmd );

// Callback COMMAND_SE_MESSAGING_GET_LAST_MSG
//  @return ZCL_STATUS_CMD_HAS_RSP or
//          ZCL_STATUS_NOT_FOUND
typedef ZStatus_t (*zclSE_MessagingGetLastMsgCB_t)( zclIncoming_t *pInMsg );

// Callback COMMAND_SE_MESSAGING_MSG_CFM
typedef void (*zclSE_MessagingMsgCfmCB_t)( zclIncoming_t *pInMsg,
                                           zclSE_MessagingMsgCfm_t *pCmd );

// Callback COMMAND_SE_MESSAGING_GET_MSG_CANCELLATION
//  @return ZCL_STATUS_CMD_HAS_RSP or
//          ZCL_STATUS_NOT_FOUND
typedef ZStatus_t (*zclSE_MessagingGetMsgCancellationCB_t)(
                      zclIncoming_t *pInMsg,
                      zclSE_MessagingGetMsgCancellation_t *pCmd );

// Server-to-Client Callbacks
typedef struct
{
  // COMMAND_SE_MESSAGING_DISPLAY_MSG
  zclSE_MessagingDisplayMsgCB_t           pfnDisplayMsg;
  // COMMAND_SE_MESSAGING_CANCEL_MSG
  zclSE_MessagingCancelMsgCB_t            pfnCancelMsg;
  // COMMAND_SE_MESSAGING_DISPLAY_PROTECTED_MSG
  zclSE_MessagingDisplayProtectedMsgCB_t  pfnDisplayProtectedMsg;
  // COMMAND_SE_MESSAGING_CANCEL_ALL_MSGS
  zclSE_MessagingCancelAllMsgsCB_t        pfnCancelAllMsgs;
} zclSE_MessagingClientCBs_t;

// Client-to-Server Callbacks
typedef struct
{
  // COMMAND_SE_MESSAGING_GET_LAST_MSG
  zclSE_MessagingGetLastMsgCB_t          pfnGetLastMsg;
  // COMMAND_SE_MESSAGING_MSG_CFM
  zclSE_MessagingMsgCfmCB_t              pfnMsgCfm;
  // COMMAND_SE_MESSAGING_GET_MSG_CANCELLATION
  zclSE_MessagingGetMsgCancellationCB_t  pfnGetMsgCancellation;
} zclSE_MessagingServerCBs_t;

//=================================================================================================
// Tunneling Command Fields(ZCL_CLUSTER_ID_SE_TUNNELING)
//=================================================================================================
typedef struct
{
  uint16_t tunnelID;
  uint8_t status; // see ZCL_SE_TUNNELING_TUNNEL_STATUS
  uint16_t maxTransferSize;
} zclSE_TunnelingReqTunnelRsp_t;

typedef struct
{
  uint16_t tunnelID;
  uint16_t dataLen;
  uint8_t *pData;
} zclSE_TunnelingTransferData_t;

typedef struct
{
  uint16_t tunnelID;
  uint8_t status; // see ZCL_SE_TUNNELING_TRANSFER_STATUS
} zclSE_TunnelingTransferDataErr_t;

typedef struct
{
  uint16_t tunnelID;
  uint16_t numOfBytesLeft;
} zclSE_TunnelingAckTransferData_t;

typedef struct
{
  uint16_t tunnelID;
  uint16_t numOfOctetsLeft;
} zclSE_TunnelingReadyData_t;

typedef struct
{
  uint16_t manuCode;
  uint8_t protoID; // see ZCL_SE_TUNNELING_PROTO
} zclSE_TunnelingProtocol_t;

typedef struct
{
  uint8_t protoListComplete;
  uint8_t protoListCount;
  zclSE_TunnelingProtocol_t *protoList;
} zclSE_TunnelingSuppTunnelProtocolsRsp_t;

typedef struct
{
  uint16_t tunnelID;
} zclSE_TunnelingTunnelClosureNotif_t;

typedef struct
{
  uint8_t protoID;
  uint16_t manuCode;
  uint8_t flowCtrlSupp;
  uint16_t maxTransferSize;
} zclSE_TunnelingReqTunnel_t;

typedef struct
{
  uint16_t tunnelID;
} zclSE_TunnelingCloseTunnel_t;

typedef struct
{
  uint8_t offset;
} zclSE_TunnelingGetSuppTunnelProtocols_t;

//=================================================================================================
// Tunneling Callbacks(ZCL_CLUSTER_ID_SE_TUNNELING)
//=================================================================================================
// Callback COMMAND_SE_TUNNELING_REQ_TUNNEL_RSP
typedef void (*zclSE_TunnelingReqTunnelRspCB_t)( zclIncoming_t *pInMsg,
                                                 zclSE_TunnelingReqTunnelRsp_t *pCmd );

// Callback COMMAND_SE_TUNNELING_SERVER_TRANSFER_DATA
// Callback COMMAND_SE_TUNNELING_CLIENT_TRANSFER_DATA
typedef void (*zclSE_TunnelingTransferDataCB_t)( zclIncoming_t *pInMsg,
                                                 zclSE_TunnelingTransferData_t *pCmd );

// Callback COMMAND_SE_TUNNELING_SERVER_TRANSFER_DATA_ERR
// Callback COMMAND_SE_TUNNELING_CLIENT_TRANSFER_DATA_ERR
typedef void (*zclSE_TunnelingTransferDataErrCB_t)( zclIncoming_t *pInMsg,
                                                    zclSE_TunnelingTransferDataErr_t *pCmd );

// Callback COMMAND_SE_TUNNELING_SERVER_ACK_TRANSFER_DATA
// Callback COMMAND_SE_TUNNELING_CLIENT_ACK_TRANSFER_DATA
typedef void (*zclSE_TunnelingAckTransferDataCB_t)(
                 zclIncoming_t *pInMsg,
                 zclSE_TunnelingAckTransferData_t *pCmd );

// Callback COMMAND_SE_TUNNELING_SERVER_READY_DATA
// Callback COMMAND_SE_TUNNELING_CLIENT_READY_DATA
typedef void (*zclSE_TunnelingReadyDataCB_t)( zclIncoming_t *pInMsg,
                                              zclSE_TunnelingReadyData_t *pCmd );

// Callback COMMAND_SE_TUNNELING_SUPP_TUNNEL_PROTOCOLS_RSP
typedef void (*zclSE_TunnelingSuppTunnelProtocolsRspCB_t)(
                 zclIncoming_t *pInMsg,
                 zclSE_TunnelingSuppTunnelProtocolsRsp_t *pCmd );

// Callback COMMAND_SE_TUNNELING_TUNNEL_CLOSURE_NOTIF
typedef void (*zclSE_TunnelingTunnelClosureNotifCB_t)(
                 zclIncoming_t *pInMsg,
                 zclSE_TunnelingTunnelClosureNotif_t *pCmd );

// Callback COMMAND_SE_TUNNELING_REQ_TUNNEL
typedef void (*zclSE_TunnelingReqTunnelCB_t)( zclIncoming_t *pInMsg,
                                              zclSE_TunnelingReqTunnel_t *pCmd );

// Callback COMMAND_SE_TUNNELING_CLOSE_TUNNEL
//  @return ZCL_STATUS_SUCCESS or
//          ZCL_STATUS_NOT_FOUND
typedef ZStatus_t (*zclSE_TunnelingCloseTunnelCB_t)(
                      zclIncoming_t *pInMsg,
                      zclSE_TunnelingCloseTunnel_t *pCmd );

// Callback COMMAND_SE_TUNNELING_GET_SUPP_TUNNEL_PROTOCOLS
typedef void (*zclSE_TunnelingGetSuppTunnelProtocolsCB_t)(
                 zclIncoming_t *pInMsg,
                 zclSE_TunnelingGetSuppTunnelProtocols_t *pCmd );

// Server-to-Client Callbacks
typedef struct
{
  // COMMAND_SE_TUNNELING_REQ_TUNNEL_RSP
  zclSE_TunnelingReqTunnelRspCB_t            pfnReqTunnelRsp;
  // COMMAND_SE_TUNNELING_SERVER_TRANSFER_DATA
  zclSE_TunnelingTransferDataCB_t            pfnServerTransferData;
  // COMMAND_SE_TUNNELING_SERVER_TRANSFER_DATA_ERR
  zclSE_TunnelingTransferDataErrCB_t         pfnServerTransferDataErr;
  // COMMAND_SE_TUNNELING_SERVER_ACK_TRANSFER_DATA
  zclSE_TunnelingAckTransferDataCB_t         pfnServerAckTransferData;
  // COMMAND_SE_TUNNELING_SERVER_READY_DATA
  zclSE_TunnelingReadyDataCB_t               pfnServerReadyData;
  // COMMAND_SE_TUNNELING_SUPP_TUNNEL_PROTOCOLS_RSP
  zclSE_TunnelingSuppTunnelProtocolsRspCB_t  pfnSuppTunnelProtocolsRsp;
  // COMMAND_SE_TUNNELING_TUNNEL_CLOSURE_NOTIF
  zclSE_TunnelingTunnelClosureNotifCB_t      pfnTunnelClosureNotif;
} zclSE_TunnelingClientCBs_t;

// Client-to-Server Callbacks
typedef struct
{
  // COMMAND_SE_TUNNELING_REQ_TUNNEL
  zclSE_TunnelingReqTunnelCB_t               pfnReqTunnel;
  // COMMAND_SE_TUNNELING_CLOSE_TUNNEL
  zclSE_TunnelingCloseTunnelCB_t             pfnCloseTunnel;
  // COMMAND_SE_TUNNELING_CLIENT_TRANSFER_DATA
  zclSE_TunnelingTransferDataCB_t            pfnClientTransferData;
  // COMMAND_SE_TUNNELING_CLIENT_TRANSFER_DATA_ERR
  zclSE_TunnelingTransferDataErrCB_t         pfnClientTransferDataErr;
  // COMMAND_SE_TUNNELING_CLIENT_ACK_TRANSFER_DATA
  zclSE_TunnelingAckTransferDataCB_t         pfnClientAckTransferData;
  // COMMAND_SE_TUNNELING_CLIENT_READY_DATA
  zclSE_TunnelingReadyDataCB_t               pfnClientReadyData;
  // COMMAND_SE_TUNNELING_GET_SUPP_TUNNEL_PROTOCOLS
  zclSE_TunnelingGetSuppTunnelProtocolsCB_t  pfnGetSuppTunnelProtocols;
} zclSE_TunnelingServerCBs_t;

//=================================================================================================
// Prepayment Command Fields(ZCL_CLUSTER_ID_SE_PREPAYMENT)
//=================================================================================================
typedef struct
{
  int32_t accumDebt;
  uint32_t type1DebtRemaining;
  uint32_t type2DebtRemaining;
  uint32_t type3DebtRemaining;
  int32_t emrgncyCreditRemaining;
  int32_t creditRemaining;
} zclSE_PrepaymentDebtCreditStatus_t;

typedef struct
{
  zclSE_PrepaymentDebtCreditStatus_t *pStatus;
} zclSE_PrepaymentSnapshotPayload_t;

typedef struct
{
  uint32_t snapshotID;
  uint32_t time;
  uint8_t totalFound;
  uint8_t cmdIdx;
  uint8_t cmdTotal;
  uint32_t cause;
  uint8_t type; // see ZCL_SE_PREPAYMENT_SNAPSHOT_PAYLOAD_TYPE

  // Union discriminator "type"
  // May be empty if fragmented -- see raw payload fields below
  zclSE_PrepaymentSnapshotPayload_t payload;

  // Raw payloads are used to send and receive fragmented commands -- see below
  uint16_t rawPayloadLen;
  uint8_t *pRawPayload;

  // Depending on the length of the entire command, the command may be
  // fragmented.  If the command is fragmented the "payload" field will be
  // empty and the raw payload fields will be set.  When receiving fragmented
  // commands the user is responsible to concatenate all the fragments into one
  // complete "pRawPayload" field.  Once the entire "pRawPayload" has been built
  // from all the fragments, the user can then call
  // "zclSE_PrepaymentSnapshotPayloadParse" to parse the "pRawPayload" and build
  // a valid "payload" field.  A simple example is provided below.  Note that
  // the function "zclSE_PrepaymentSnapshotPayloadParse" should be called from
  // within the context of a COMMAND_SE_PREPAYMENT_PUBLISH_PREPAY_SNAPSHOT
  // callback function -- see example below.
  //
  //  EXAMPLE CALLBACK HANDLER:
  //  ==========================================================================
  /*
      // Local vars to build raw concatenated payload from multipe fragments
      static uint8_t app_rawPayloadLen = 0;
      static uint8_t *app_rawPayload = NULL;

      // Callback for COMMAND_SE_PREPAYMENT_PUBLISH_PREPAY_SNAPSHOT
      uint8_t app_PrepaymentPublishPrepaySnapshotCB(
              zclIncoming_t *pInMsg,
              zclSE_PrepaymentPublishPrepaySnapshot_t *pCmd )
      {
        uint8_t result = ZCL_STATUS_SUCCESS;
        uint8_t parseResult;
        uint8_t completeCmdReady = FALSE;

        if ( pCmd->cmdTotal > 1 )
        {
          // Simple example of concatenating command fragments
          app_rawPayload = realloc( app_rawPayload,
                                    app_rawPayloadLen + pCmd->rawPayloadLen);
          if (app_rawPayload == NULL )
          {
            return ZCL_STATUS_SOFTWARE_FAILURE;
          }

          OsalPort_memcpy( &app_rawPayload[app_rawPayloadLen],
                  pCmd->pRawPayload,
                  pCmd->rawPayloadLen );

          app_rawPayloadLen += pCmd->rawPayloadLen;

          // Is this the last fragment
          if ( ( pCmd->cmdIdx + 1 ) == pCmd->cmdTotal )
          {
             // Set the full raw payload fields
             pCmd->pRawPayload = app_rawPayload;
             pCmd->rawPayloadLen = app_rawPayloadLen;

            // Parse the full command payload
            result = zclSE_PrepaymentSnapshotPayloadParse( pCmd );

            if ( result == ZCL_STATUS_SUCCESS )
            {
              // Current command is ready for final processing
              completeCmdReady = TRUE;
            }
            else
            {
              // Reset variables
              free(app_rawPayload);
              app_rawPayload = NULL;
              app_rawPayloadLen = 0;
            }
          }
        }
        else
        {
          // No fragmentation -- just use current command for final processing
          completeCmdReady = TRUE;
        }

        // Is command ready to process, ie the "payload" field is valid
        if ( completeCmdReady )
        {
          // User specific command processing
          app_ProcessPrepaymentPublishPrepaySnapshot( pCmd );

          // Free variables after using "pCmd->payload" -- it may
          // reference parts of the "app_rawPayload"
          free(app_rawPayload);
          app_rawPayload = NULL;
          app_rawPayloadLen = 0;

          result = ZCL_STATUS_SUCCESS;
        }

        return result;
      }
    ==========================================================================
  */
  // If needed, the user can also send a fragmented command by calling
  // "zclSE_PrepaymentSendPublishPrepaySnapshot" multiple times, setting "cmdIdx",
  // "cmdTotal", and the raw payload fields accordingly.
 } zclSE_PrepaymentPublishPrepaySnapshot_t;

typedef struct
{
  uint8_t frndlyCredit;
  uint32_t frndlyCreditCalendarID;
  uint32_t emrgncyCreditLimit;
  uint32_t emrgncyCreditThreshold;
} zclSE_PrepaymentChangePaymentModeRsp_t;

typedef struct
{
  uint8_t resultType;
  int32_t topupValue;
  uint8_t srcOfTopUp;
  int32_t creditRemaining;
} zclSE_PrepaymentConsumerTopUpRsp_t;

typedef struct
{
  UTF8String_t code;
  int32_t amnt;
  uint32_t time;
} zclSE_PrepaymentTopUp_t;

typedef struct
{
  uint8_t cmdIdx;
  uint8_t cmdTotal;
  uint8_t numOfTopUps;

  // May be empty if fragmented -- see raw payload fields below
  zclSE_PrepaymentTopUp_t *pTopUps;

  // Raw payloads are used to send and receive fragmented commands -- see below
  uint16_t rawPayloadLen;
  uint8_t *pRawPayload;

  // Depending on the length of the entire command, the command may be
  // fragmented.  If the command is fragmented the "pTopUps" field will be
  // empty and the raw payload fields will be set.  When receiving fragmented
  // commands the user is responsible to concatenate all the fragments into one
  // complete "pRawPayload" field.  Once the entire "pRawPayload" has been built
  // from all the fragments, the user can then call
  // "zclSE_PrepaymentTopUpParse" to parse the "pRawPayload" and build
  // a valid "pTopUps" field.  A simple example is provided below.  Note that
  // the function "zclSE_PrepaymentTopUpParse" should be called from
  // within the context of a COMMAND_SE_PREPAYMENT_PUBLISH_TOP_UP_LOG callback
  // function -- see example below.
  //
  //  EXAMPLE CALLBACK HANDLER:
  //  ==========================================================================
  /*
      // Local vars to build raw concatenated payload from multipe fragments
      static uint8_t app_rawPayloadLen = 0;
      static uint8_t *app_rawPayload = NULL;

      // Callback for COMMAND_SE_PREPAYMENT_PUBLISH_TOP_UP_LOG
      uint8_t app_PrepaymentPublishTopUpLogCB(
              zclIncoming_t *pInMsg,
              zclSE_PrepaymentPublishTopUpLog_t *pCmd )
      {
        uint8_t result = ZCL_STATUS_SUCCESS;
        uint8_t parseResult;
        uint8_t completeCmdReady = FALSE;

        if ( pCmd->cmdTotal > 1 )
        {
          // Simple example of concatenating command fragments
          app_rawPayload = realloc( app_rawPayload,
                                    app_rawPayloadLen + pCmd->rawPayloadLen);
          if (app_rawPayload == NULL )
          {
            return ZCL_STATUS_SOFTWARE_FAILURE;
          }

          OsalPort_memcpy( &app_rawPayload[app_rawPayloadLen],
                  pCmd->pRawPayload,
                  pCmd->rawPayloadLen );

          app_rawPayloadLen += pCmd->rawPayloadLen;

          // Is this the last fragment
          if ( ( pCmd->cmdIdx + 1 ) == pCmd->cmdTotal )
          {
             // Set the full raw payload fields
             pCmd->pRawPayload = app_rawPayload;
             pCmd->rawPayloadLen = app_rawPayloadLen;

            // Parse the full command payload
            result = zclSE_PrepaymentTopUpParse( pCmd );

            if ( result == ZCL_STATUS_SUCCESS )
            {
              // Current command is ready for final processing
              completeCmdReady = TRUE;
            }
            else
            {
              // Reset variables
              free(app_rawPayload);
              app_rawPayload = NULL;
              app_rawPayloadLen = 0;
            }
          }
        }
        else
        {
          // No fragmentation -- just use current command for final processing
          completeCmdReady = TRUE;
        }

        // Is command ready to process, ie the "pTopUps" field is valid
        if ( completeCmdReady )
        {
          // User specific command processing
          app_ProcessPrepaymentPublishTopUpLog( pCmd );

          // Free variables after using "pCmd->pTopUps" -- it may
          // reference parts of the "app_rawPayload"
          free(app_rawPayload);
          app_rawPayload = NULL;
          app_rawPayloadLen = 0;

          result = ZCL_STATUS_SUCCESS;
        }

        return result;
      }
    ==========================================================================
  */
  // If needed, the user can also send a fragmented command by calling
  // "zclSE_PrepaymentSendPublishTopUpLog" multiple times, setting "cmdIdx",
  // "cmdTotal", and the raw payload fields accordingly.
} zclSE_PrepaymentPublishTopUpLog_t;

typedef struct
{
  uint32_t collTime;
  uint32_t amntColl;
  uint8_t debtType;
  uint32_t outstandingDebt;
} zclSE_PrepaymentDebtRec_t;

typedef struct
{
  uint8_t cmdIdx;
  uint8_t cmdTotal;
  uint8_t numOfRecs;

  // May be empty if fragmented -- see raw payload fields below
  zclSE_PrepaymentDebtRec_t *pRecs;

  // Raw payloads are used to send and receive fragmented commands -- see below
  uint16_t rawPayloadLen;
  uint8_t *pRawPayload;

  // Depending on the length of the entire command, the command may be
  // fragmented.  If the command is fragmented the "pRecs" field will be
  // empty and the raw payload fields will be set.  When receiving fragmented
  // commands the user is responsible to concatenate all the fragments into one
  // complete "pRawPayload" field.  Once the entire "pRawPayload" has been built
  // from all the fragments, the user can then call
  // "zclSE_PrepaymentDebtRecParse" to parse the "pRawPayload" and build
  // a valid "pRecs" field.  A simple example is provided below.  Note that
  // the function "zclSE_PrepaymentDebtRecParse" should be called from
  // within the context of a COMMAND_SE_PREPAYMENT_PUBLISH_DEBT_LOG callback
  // function -- see example below.
  //
  //  EXAMPLE CALLBACK HANDLER:
  //  ==========================================================================
  /*
      // Local vars to build raw concatenated payload from multipe fragments
      static uint8_t app_rawPayloadLen = 0;
      static uint8_t *app_rawPayload = NULL;

      // Callback for COMMAND_SE_PREPAYMENT_PUBLISH_DEBT_LOG
      uint8_t app_PrepaymentPublishDebtLogCB(
              zclIncoming_t *pInMsg,
              zclSE_PrepaymentPublishDebtLog_t *pCmd )
      {
        uint8_t result = ZCL_STATUS_SUCCESS;
        uint8_t parseResult;
        uint8_t completeCmdReady = FALSE;

        if ( pCmd->cmdTotal > 1 )
        {
          // Simple example of concatenating command fragments
          app_rawPayload = realloc( app_rawPayload,
                                    app_rawPayloadLen + pCmd->rawPayloadLen);
          if (app_rawPayload == NULL )
          {
            return ZCL_STATUS_SOFTWARE_FAILURE;
          }

          OsalPort_memcpy( &app_rawPayload[app_rawPayloadLen],
                  pCmd->pRawPayload,
                  pCmd->rawPayloadLen );

          app_rawPayloadLen += pCmd->rawPayloadLen;

          // Is this the last fragment
          if ( ( pCmd->cmdIdx + 1 ) == pCmd->cmdTotal )
          {
             // Set the full raw payload fields
             pCmd->pRawPayload = app_rawPayload;
             pCmd->rawPayloadLen = app_rawPayloadLen;

            // Parse the full command payload
            result = zclSE_PrepaymentDebtRecParse( pCmd );

            if ( result == ZCL_STATUS_SUCCESS )
            {
              // Current command is ready for final processing
              completeCmdReady = TRUE;
            }
            else
            {
              // Reset variables
              free(app_rawPayload);
              app_rawPayload = NULL;
              app_rawPayloadLen = 0;
            }
          }
        }
        else
        {
          // No fragmentation -- just use current command for final processing
          completeCmdReady = TRUE;
        }

        // Is command ready to process, ie the "pRecs" field is valid
        if ( completeCmdReady )
        {
          // User specific command processing
          app_ProcessPrepaymentPublishDebtLog( pCmd );

          // Free variables after using "pCmd->pRecs" -- it may
          // reference parts of the "app_rawPayload"
          free(app_rawPayload);
          app_rawPayload = NULL;
          app_rawPayloadLen = 0;

          result = ZCL_STATUS_SUCCESS;
        }

        return result;
      }
    ==========================================================================
  */
  // If needed, the user can also send a fragmented command by calling
  // "zclSE_PrepaymentSendPublishDebtLog" multiple times, setting "cmdIdx",
  // "cmdTotal", and the raw payload fields accordingly.
} zclSE_PrepaymentPublishDebtLog_t;

typedef struct
{
  uint32_t cmdIssueDateTime;
  uint8_t origDevice;
} zclSE_PrepaymentSelAvailEmrgncyCredit_t;

typedef struct
{
  uint32_t issuerEvtID;
  UTF8String_t debtLabel;
  int32_t debtAmnt;
  uint8_t debtRecoveryMethod;
  uint8_t debtAmntType;
  uint32_t debtRecoveryStartTime;
  uint16_t debtRecoveryCollTime;
  uint8_t debtRecoveryFreq;
  int32_t debtRecoveryAmnt;
  uint16_t debtRecoveryBalPct;
} zclSE_PrepaymentChangeDebt_t;

typedef struct
{
  uint32_t issuerEvtID;
  uint32_t startTime;
  uint32_t emrgncyCreditLimit;
  uint32_t emrgncyCreditThreshold;
} zclSE_PrepaymentEmrgncyCreditSetup_t;

typedef struct
{
  uint8_t origDevice;
  UTF8String_t topUpCode;
} zclSE_PrepaymentConsumerTopUp_t;

typedef struct
{
  uint32_t issuerEvtID;
  uint32_t startTime;
  uint8_t creditAdjType;
  int32_t creditAdjValue;
} zclSE_PrepaymentCreditAdj_t;

typedef struct
{
  uint32_t providerID;
  uint32_t issuerEvtID;
  uint32_t implDateTime;
  uint16_t propPaymentCtrlCfg;
  int32_t cutOffValue;
} zclSE_PrepaymentChangePaymentMode_t;

typedef struct
{
  uint32_t earliestStartTime;
  uint32_t latestEndTime;
  uint8_t offset;
  uint32_t cause;
} zclSE_PrepaymentGetPrepaySnapshot_t;

typedef struct
{
  uint32_t latestEndTime;
  uint8_t numOfRecords;
} zclSE_PrepaymentGetTopUpLog_t;

typedef struct
{
  uint32_t level;
} zclSE_PrepaymentSetLowCreditWarnLevel_t;

typedef struct
{
  uint32_t latestEndTime;
  uint8_t numOfDebts;
  uint8_t debtType;
} zclSE_PrepaymentGetDebtRepayLog_t;

typedef struct
{
  uint32_t providerID;
  uint32_t issuerEvtID;
  uint32_t implDateTime;
  uint32_t maxCreditLevel;
  uint32_t maxCreditPerTopUp;
} zclSE_PrepaymentSetMaxCreditLimit_t;

typedef struct
{
  uint32_t providerID;
  uint32_t issuerEvtID;
  uint32_t implDateTime;
  int32_t  overallDebtCap;
} zclSE_PrepaymentSetOverallDebtCap_t;

//=================================================================================================
// Prepayment Callbacks(ZCL_CLUSTER_ID_SE_PREPAYMENT)
//=================================================================================================
// Callback COMMAND_SE_PREPAYMENT_PUBLISH_PREPAY_SNAPSHOT
//  @return ZCL_STATUS_SUCCESS or
//          ZCL_STATUS_MALFORMED_COMMAND
//          ZCL_STATUS_SOFTWARE_FAILURE
typedef ZStatus_t (*zclSE_PrepaymentPublishPrepaySnapshotCB_t)(
                      zclIncoming_t *pInMsg,
                      zclSE_PrepaymentPublishPrepaySnapshot_t *pCmd );

// Callback COMMAND_SE_PREPAYMENT_CHANGE_PAYMENT_MODE_RSP
typedef void (*zclSE_PrepaymentChangePaymentModeRspCB_t)(
                 zclIncoming_t *pInMsg,
                 zclSE_PrepaymentChangePaymentModeRsp_t *pCmd );

// Callback COMMAND_SE_PREPAYMENT_CONSUMER_TOP_UP_RSP
typedef void (*zclSE_PrepaymentConsumerTopUpRspCB_t)(
                 zclIncoming_t *pInMsg,
                 zclSE_PrepaymentConsumerTopUpRsp_t *pCmd );

// Callback COMMAND_SE_PREPAYMENT_PUBLISH_TOP_UP_LOG
//  @return ZCL_STATUS_SUCCESS or
//          ZCL_STATUS_MALFORMED_COMMAND
//          ZCL_STATUS_SOFTWARE_FAILURE
typedef ZStatus_t (*zclSE_PrepaymentPublishTopUpLogCB_t)(
                      zclIncoming_t *pInMsg,
                      zclSE_PrepaymentPublishTopUpLog_t *pCmd );

// Callback COMMAND_SE_PREPAYMENT_PUBLISH_DEBT_LOG
//  @return ZCL_STATUS_SUCCESS or
//          ZCL_STATUS_MALFORMED_COMMAND
//          ZCL_STATUS_SOFTWARE_FAILURE
typedef ZStatus_t (*zclSE_PrepaymentPublishDebtLogCB_t)(
                      zclIncoming_t *pInMsg,
                      zclSE_PrepaymentPublishDebtLog_t *pCmd );

// Callback COMMAND_SE_PREPAYMENT_SEL_AVAIL_EMRGNCY_CREDIT
//  @return ZCL_STATUS_SUCCESS or
//          ZCL_STATUS_NOTIFICATION_PENDING
//          ZCL_STATUS_INSUFFICIENT_SPACE
//          ZCL_STATUS_TIMEOUT
typedef ZStatus_t (*zclSE_PrepaymentSelAvailEmrgncyCreditCB_t)(
                      zclIncoming_t *pInMsg,
                      zclSE_PrepaymentSelAvailEmrgncyCredit_t *pCmd );

// Callback COMMAND_SE_PREPAYMENT_CHANGE_DEBT
typedef void (*zclSE_PrepaymentChangeDebtCB_t)( zclIncoming_t *pInMsg,
                                                zclSE_PrepaymentChangeDebt_t *pCmd );

// Callback COMMAND_SE_PREPAYMENT_EMRGNCY_CREDIT_SETUP
typedef void (*zclSE_PrepaymentEmrgncyCreditSetupCB_t)(
                 zclIncoming_t *pInMsg,
                 zclSE_PrepaymentEmrgncyCreditSetup_t *pCmd );

// Callback COMMAND_SE_PREPAYMENT_CONSUMER_TOP_UP
//  @return ZCL_STATUS_CMD_HAS_RSP or
//          ZCL_STATUS_NOTIFICATION_PENDING
//          ZCL_STATUS_INSUFFICIENT_SPACE
//          ZCL_STATUS_TIMEOUT
typedef ZStatus_t (*zclSE_PrepaymentConsumerTopUpCB_t)(
                      zclIncoming_t *pInMsg,
                      zclSE_PrepaymentConsumerTopUp_t *pCmd );

// Callback COMMAND_SE_PREPAYMENT_CREDIT_ADJ
typedef void (*zclSE_PrepaymentCreditAdjCB_t)(
                 zclIncoming_t *pInMsg,
                 zclSE_PrepaymentCreditAdj_t *pCmd );

// Callback COMMAND_SE_PREPAYMENT_CHANGE_PAYMENT_MODE
typedef void (*zclSE_PrepaymentChangePaymentModeCB_t)(
                 zclIncoming_t *pInMsg,
                 zclSE_PrepaymentChangePaymentMode_t *pCmd );

// Callback COMMAND_SE_PREPAYMENT_GET_PREPAY_SNAPSHOT
//  @return ZCL_STATUS_CMD_HAS_RSP or
//          ZCL_STATUS_NOT_FOUND
typedef ZStatus_t (*zclSE_PrepaymentGetPrepaySnapshotCB_t)(
                      zclIncoming_t *pInMsg,
                      zclSE_PrepaymentGetPrepaySnapshot_t *pCmd );

// Callback COMMAND_SE_PREPAYMENT_GET_TOP_UP_LOG
//  @return ZCL_STATUS_CMD_HAS_RSP or
//          ZCL_STATUS_NOT_FOUND
typedef ZStatus_t (*zclSE_PrepaymentGetTopUpLogCB_t)(
                      zclIncoming_t *pInMsg,
                      zclSE_PrepaymentGetTopUpLog_t *pCmd );

// Callback COMMAND_SE_PREPAYMENT_SET_LOW_CREDIT_WARN_LEVEL
typedef void (*zclSE_PrepaymentSetLowCreditWarnLevelCB_t)(
                 zclIncoming_t *pInMsg,
                 zclSE_PrepaymentSetLowCreditWarnLevel_t *pCmd );

// Callback COMMAND_SE_PREPAYMENT_GET_DEBT_REPAY_LOG
//  @return ZCL_STATUS_CMD_HAS_RSP or
//          ZCL_STATUS_NOT_FOUND
typedef ZStatus_t (*zclSE_PrepaymentGetDebtRepayLogCB_t)(
                      zclIncoming_t *pInMsg,
                      zclSE_PrepaymentGetDebtRepayLog_t *pCmd );

// Callback COMMAND_SE_PREPAYMENT_SET_MAX_CREDIT_LIMIT
typedef void (*zclSE_PrepaymentSetMaxCreditLimitCB_t)(
                 zclIncoming_t *pInMsg,
                 zclSE_PrepaymentSetMaxCreditLimit_t *pCmd );

// Callback COMMAND_SE_PREPAYMENT_SET_OVERALL_DEBT_CAP
typedef void (*zclSE_PrepaymentSetOverallDebtCapCB_t)(
                 zclIncoming_t *pInMsg,
                 zclSE_PrepaymentSetOverallDebtCap_t *pCmd );

// Server-to-Client Callbacks
typedef struct
{
  // COMMAND_SE_PREPAYMENT_PUBLISH_PREPAY_SNAPSHOT
  zclSE_PrepaymentPublishPrepaySnapshotCB_t  pfnPublishPrepaySnapshot;
  // COMMAND_SE_PREPAYMENT_CHANGE_PAYMENT_MODE_RSP
  zclSE_PrepaymentChangePaymentModeRspCB_t   pfnChangePaymentModeRsp;
  // COMMAND_SE_PREPAYMENT_CONSUMER_TOP_UP_RSP
  zclSE_PrepaymentConsumerTopUpRspCB_t       pfnConsumerTopUpRsp;
  // COMMAND_SE_PREPAYMENT_PUBLISH_TOP_UP_LOG
  zclSE_PrepaymentPublishTopUpLogCB_t        pfnPublishTopUpLog;
  // COMMAND_SE_PREPAYMENT_PUBLISH_DEBT_LOG
  zclSE_PrepaymentPublishDebtLogCB_t         pfnPublishDebtLog;
} zclSE_PrepaymentClientCBs_t;

// Client-to-Server Callbacks
typedef struct
{
  // COMMAND_SE_PREPAYMENT_SEL_AVAIL_EMRGNCY_CREDIT
  zclSE_PrepaymentSelAvailEmrgncyCreditCB_t  pfnSelAvailEmrgncyCredit;
  // COMMAND_SE_PREPAYMENT_CHANGE_DEBT
  zclSE_PrepaymentChangeDebtCB_t             pfnChangeDebt;
  // COMMAND_SE_PREPAYMENT_EMRGNCY_CREDIT_SETUP
  zclSE_PrepaymentEmrgncyCreditSetupCB_t     pfnEmrgncyCreditSetup;
  // COMMAND_SE_PREPAYMENT_CONSUMER_TOP_UP
  zclSE_PrepaymentConsumerTopUpCB_t          pfnConsumerTopUp;
  // COMMAND_SE_PREPAYMENT_CREDIT_ADJ
  zclSE_PrepaymentCreditAdjCB_t              pfnCreditAdj;
  // COMMAND_SE_PREPAYMENT_CHANGE_PAYMENT_MODE
  zclSE_PrepaymentChangePaymentModeCB_t      pfnChangePaymentMode;
  // COMMAND_SE_PREPAYMENT_GET_PREPAY_SNAPSHOT
  zclSE_PrepaymentGetPrepaySnapshotCB_t      pfnGetPrepaySnapshot;
  // COMMAND_SE_PREPAYMENT_GET_TOP_UP_LOG
  zclSE_PrepaymentGetTopUpLogCB_t            pfnGetTopUpLog;
  // COMMAND_SE_PREPAYMENT_SET_LOW_CREDIT_WARN_LEVEL
  zclSE_PrepaymentSetLowCreditWarnLevelCB_t  pfnSetLowCreditWarnLevel;
  // COMMAND_SE_PREPAYMENT_GET_DEBT_REPAY_LOG
  zclSE_PrepaymentGetDebtRepayLogCB_t        pfnGetDebtRepayLog;
  // COMMAND_SE_PREPAYMENT_SET_MAX_CREDIT_LIMIT
  zclSE_PrepaymentSetMaxCreditLimitCB_t      pfnSetMaxCreditLimit;
  // COMMAND_SE_PREPAYMENT_SET_OVERALL_DEBT_CAP
  zclSE_PrepaymentSetOverallDebtCapCB_t      pfnSetOverallDebtCap;
} zclSE_PrepaymentServerCBs_t;

//=================================================================================================
// Calendar Command Fields(ZCL_CLUSTER_ID_SE_CALENDAR)
//=================================================================================================
typedef struct
{
  uint32_t providerID;
  uint32_t issuerEvtID;
  uint32_t issuerCalendarID;
  uint32_t startTime;
  uint8_t calendarType; // see ZCL_SE_CALENDAR_TYPE
  uint8_t calendarTimeRef;
  UTF8String_t calendarName;
  uint8_t numOfSeasons;
  uint8_t numOfWeekProfiles;
  uint8_t numOfDayProfiles;
} zclSE_CalendarPublishCalendar_t;

typedef struct
{
  uint16_t startTime;
  uint8_t priceTier;
} zclSE_CalendarRateStartTimes_t;

typedef struct
{
  uint16_t startTime;
  uint8_t frndlyCreditEnable;
} zclSE_CalendarFrndlyCreditStartTimes_t;

typedef struct
{
  uint16_t startTime;
  uint8_t auxLoadSwitchState;
} zclSE_CalendarAuxLoadStartTimes_t;

typedef union
{
  // ZCL_SE_CALENDAR_TYPE_DLVD
  // ZCL_SE_CALENDAR_TYPE_RCVD
  // ZCL_SE_CALENDAR_TYPE_DLVD_AND_RCVD
  zclSE_CalendarRateStartTimes_t *pRate;

  // ZCL_SE_CALENDAR_TYPE_FRNDLY_CREDIT
  zclSE_CalendarFrndlyCreditStartTimes_t *pCredit;

  // ZCL_SE_CALENDAR_TYPE_AUX_LOAD_START
  zclSE_CalendarAuxLoadStartTimes_t *pLoad;

} zclSE_CalendarDayEntry_t;

typedef struct
{
  uint32_t profileID;
  uint32_t issuerEvtID;
  uint32_t issuerCalendarID;
  uint8_t dayID;
  uint8_t numOfEntries;
  uint8_t cmdIdx;
  uint8_t cmdTotal;
  uint8_t calendarType; // see ZCL_SE_CALENDAR_TYPE

  // Union discriminator "calendarType"
  // May be empty if fragmented -- see raw payload fields below
  zclSE_CalendarDayEntry_t entries;

  // Raw payloads are used to send and receive fragmented commands -- see below
  uint16_t rawPayloadLen;
  uint8_t *pRawPayload;

  // Depending on the length of the entire command, the command may be
  // fragmented.  If the command is fragmented the "entries" field will be
  // empty and the raw payload fields will be set.  When receiving fragmented
  // commands the user is responsible to concatenate all the fragments into one
  // complete "pRawPayload" field.  Once the entire "pRawPayload" has been built
  // from all the fragments, the user can then call
  // "zclSE_CalendarDayEntryParse" to parse the "pRawPayload" and build
  // a valid "entries" field.  A simple example is provided below.  Note that
  // the function "zclSE_CalendarDayEntryParse" should be called from
  // within the context of a COMMAND_SE_CALENDAR_PUBLISH_DAY_PROFILE callback
  // function -- see example below.
  //
  //  EXAMPLE CALLBACK HANDLER:
  //  ==========================================================================
  /*
      // Local vars to build raw concatenated payload from multipe fragments
      static uint8_t app_rawPayloadLen = 0;
      static uint8_t *app_rawPayload = NULL;

      // Callback for COMMAND_SE_CALENDAR_PUBLISH_DAY_PROFILE
      uint8_t app_CalendarPublishDayProfileCB(
              zclIncoming_t *pInMsg,
              zclSE_CalendarPublishDayProfile_t *pCmd )
      {
        uint8_t result = ZCL_STATUS_SUCCESS;
        uint8_t parseResult;
        uint8_t completeCmdReady = FALSE;

        if ( pCmd->cmdTotal > 1 )
        {
          // Simple example of concatenating command fragments
          app_rawPayload = realloc( app_rawPayload,
                                    app_rawPayloadLen + pCmd->rawPayloadLen);
          if (app_rawPayload == NULL )
          {
            return ZCL_STATUS_SOFTWARE_FAILURE;
          }

          OsalPort_memcpy( &app_rawPayload[app_rawPayloadLen],
                  pCmd->pRawPayload,
                  pCmd->rawPayloadLen );

          app_rawPayloadLen += pCmd->rawPayloadLen;

          // Is this the last fragment
          if ( ( pCmd->cmdIdx + 1 ) == pCmd->cmdTotal )
          {
             // Set the full raw payload fields
             pCmd->pRawPayload = app_rawPayload;
             pCmd->rawPayloadLen = app_rawPayloadLen;

            // Parse the full command payload
            result = zclSE_CalendarDayEntryParse( pCmd );

            if ( result == ZCL_STATUS_SUCCESS )
            {
              // Current command is ready for final processing
              completeCmdReady = TRUE;
            }
            else
            {
              // Reset variables
              free(app_rawPayload);
              app_rawPayload = NULL;
              app_rawPayloadLen = 0;
            }
          }
        }
        else
        {
          // No fragmentation -- just use current command for final processing
          completeCmdReady = TRUE;
        }

        // Is command ready to process, ie the "entries" field is valid
        if ( completeCmdReady )
        {
          // User specific command processing
          app_ProcessCalendarPublishDayProfile( pCmd );

          // Free variables after using "pCmd->entries" -- it may
          // reference parts of the "app_rawPayload"
          free(app_rawPayload);
          app_rawPayload = NULL;
          app_rawPayloadLen = 0;

          result = ZCL_STATUS_SUCCESS;
        }

        return result;
      }
    ==========================================================================
  */
  // If needed, the user can also send a fragmented command by calling
  // "zclSE_CalendarSendPublishDayProfile" multiple times, setting "cmdIdx",
  // "cmdTotal", and the raw payload fields accordingly.
} zclSE_CalendarPublishDayProfile_t;

typedef struct
{
  uint32_t providerID;
  uint32_t issuerEvtID;
  uint32_t issuerCalendarID;
  uint8_t weekID;
  uint8_t dayIDRefMonday;
  uint8_t dayIDRefTuestday;
  uint8_t dayIDRefWednesday;
  uint8_t dayIDRefThursday;
  uint8_t dayIDRefFriday;
  uint8_t dayIDRefSaturday;
  uint8_t dayIDRefSunday;
} zclSE_CalendarPublishWeekProfile_t;

typedef struct
{
  uint32_t seasonStartDate;
  uint8_t weekIDRef;
} zclSE_CalendarSeasonEntry_t;

typedef struct
{
  uint32_t providerID;
  uint32_t issuerEvtID;
  uint32_t issuerCalendarID;
  uint8_t cmdIdx;
  uint8_t cmdTotal;

  uint8_t numSeasonEntries;

  // May be empty if fragmented -- see raw payload fields below
  zclSE_CalendarSeasonEntry_t *pSeasonEntries;

  // Raw payloads are used to send and receive fragmented commands -- see below
  uint16_t rawPayloadLen;
  uint8_t *pRawPayload;

  // Depending on the length of the entire command, the command may be
  // fragmented.  If the command is fragmented the "pSeasonEntries" field will
  // be empty and the raw payload fields will be set.  When receiving fragmented
  // commands the user is responsible to concatenate all the fragments into one
  // complete "pRawPayload" field.  Once the entire "pRawPayload" has been built
  // from all the fragments, the user can then call
  // "zclSE_CalendarSeasonEntryParse" to parse the "pRawPayload" and build a
  // valid "pSeasonEntries" field.  A simple example is provided below.  Note
  // that the function "zclSE_CalendarSeasonEntryParse" should be called from
  // within the context of a COMMAND_SE_CALENDAR_PUBLISH_SEASONS callback
  // function -- see example below.
  //
  //  EXAMPLE CALLBACK HANDLER:
  //  ==========================================================================
  /*
      // Local vars to build raw concatenated payload from multipe fragments
      static uint8_t app_rawPayloadLen = 0;
      static uint8_t *app_rawPayload = NULL;

      // Callback for COMMAND_SE_CALENDAR_PUBLISH_SEASONS
      uint8_t app_CalendarPublishSeasonsCB(
              zclIncoming_t *pInMsg,
              zclSE_CalendarPublishSeasons_t *pCmd )
      {
        uint8_t result = ZCL_STATUS_SUCCESS;
        uint8_t parseResult;
        uint8_t completeCmdReady = FALSE;

        if ( pCmd->cmdTotal > 1 )
        {
          // Simple example of concatenating command fragments
          app_rawPayload = realloc( app_rawPayload,
                                    app_rawPayloadLen + pCmd->rawPayloadLen);
          if (app_rawPayload == NULL )
          {
            return ZCL_STATUS_SOFTWARE_FAILURE;
          }

          OsalPort_memcpy( &app_rawPayload[app_rawPayloadLen],
                  pCmd->pRawPayload,
                  pCmd->rawPayloadLen );

          app_rawPayloadLen += pCmd->rawPayloadLen;

          // Is this the last fragment
          if ( ( pCmd->cmdIdx + 1 ) == pCmd->cmdTotal )
          {
             // Set the full raw payload fields
             pCmd->pRawPayload = app_rawPayload;
             pCmd->rawPayloadLen = app_rawPayloadLen;

            // Parse the full command payload
            result = zclSE_CalendarSeasonEntryParse( pCmd );

            if ( result == ZCL_STATUS_SUCCESS )
            {
              // Current command is ready for final processing
              completeCmdReady = TRUE;
            }
            else
            {
              // Reset variables
              free(app_rawPayload);
              app_rawPayload = NULL;
              app_rawPayloadLen = 0;
            }
          }
        }
        else
        {
          // No fragmentation -- just use current command for final processing
          completeCmdReady = TRUE;
        }

        // Is command ready to process, ie the "pSeasonEntries" field is valid
        if ( completeCmdReady )
        {
          // User specific command processing
          app_ProcessCalendarPublishSeasons( pCmd );

          // Free variables after using "pCmd->pSeasonEntries" -- it may
          // reference parts of the "app_rawPayload"
          free(app_rawPayload);
          app_rawPayload = NULL;
          app_rawPayloadLen = 0;

          result = ZCL_STATUS_SUCCESS;
        }

        return result;
      }
    ==========================================================================
  */
  // If needed, the user can also send a fragmented command by calling
  // "zclSE_CalendarSendPublishSeasons" multiple times, setting "cmdIdx",
  // "cmdTotal", and the raw payload fields accordingly.
} zclSE_CalendarPublishSeasons_t;

typedef struct
{
  uint32_t specialDayDate;
  uint8_t dayIDRef;
} zclSE_CalendarSpecialDayEntry_t;

typedef struct
{
  uint32_t providerID;
  uint32_t issuerEvtID;
  uint32_t issuerCalendarID;
  uint32_t startTime;
  uint8_t calendarType; // see ZCL_SE_CALENDAR_TYPE
  uint8_t numOfEntries;
  uint8_t cmdIdx;
  uint8_t cmdTotal;

  // May be empty if fragmented -- see raw payload fields below
  zclSE_CalendarSpecialDayEntry_t *pEntries;

  // Raw payloads are used to send and receive fragmented commands -- see below
  uint16_t rawPayloadLen;
  uint8_t *pRawPayload;

  // Depending on the length of the entire command, the command may be
  // fragmented.  If the command is fragmented the "pEntries" field will be
  // empty and the raw payload fields will be set.  When receiving fragmented
  // commands the user is responsible to concatenate all the fragments into one
  // complete "pRawPayload" field.  Once the entire "pRawPayload" has been built
  // from all the fragments, the user can then call
  // "zclSE_CalendarSpecialDayEntryParse" to parse the "pRawPayload" and build
  // a valid "pEntries" field.  A simple example is provided below.  Note that
  // the function "zclSE_CalendarSpecialDayEntryParse" should be called from
  // within the context of a COMMAND_SE_CALENDAR_PUBLISH_SPECIAL_DAYS callback
  // function -- see example below.
  //
  //  EXAMPLE CALLBACK HANDLER:
  //  ==========================================================================
  /*
      // Local vars to build raw concatenated payload from multipe fragments
      static uint8_t app_rawPayloadLen = 0;
      static uint8_t *app_rawPayload = NULL;

      // Callback for COMMAND_SE_CALENDAR_PUBLISH_SPECIAL_DAYS
      uint8_t app_CalendarPublishSpecialDaysCB(
              zclIncoming_t *pInMsg,
              zclSE_CalendarPublishSpecialDays_t *pCmd )
      {
        uint8_t result = ZCL_STATUS_SUCCESS;
        uint8_t parseResult;
        uint8_t completeCmdReady = FALSE;

        if ( pCmd->cmdTotal > 1 )
        {
          // Simple example of concatenating command fragments
          app_rawPayload = realloc( app_rawPayload,
                                    app_rawPayloadLen + pCmd->rawPayloadLen);
          if (app_rawPayload == NULL )
          {
            return ZCL_STATUS_SOFTWARE_FAILURE;
          }

          OsalPort_memcpy( &app_rawPayload[app_rawPayloadLen],
                  pCmd->pRawPayload,
                  pCmd->rawPayloadLen );

          app_rawPayloadLen += pCmd->rawPayloadLen;

          // Is this the last fragment
          if ( ( pCmd->cmdIdx + 1 ) == pCmd->cmdTotal )
          {
             // Set the full raw payload fields
             pCmd->pRawPayload = app_rawPayload;
             pCmd->rawPayloadLen = app_rawPayloadLen;

            // Parse the full command payload
            result = zclSE_CalendarSpecialDayEntryParse( pCmd );

            if ( result == ZCL_STATUS_SUCCESS )
            {
              // Current command is ready for final processing
              completeCmdReady = TRUE;
            }
            else
            {
              // Reset variables
              free(app_rawPayload);
              app_rawPayload = NULL;
              app_rawPayloadLen = 0;
            }
          }
        }
        else
        {
          // No fragmentation -- just use current command for final processing
          completeCmdReady = TRUE;
        }

        // Is command ready to process, ie the "pEntries" field is valid
        if ( completeCmdReady )
        {
          // User specific command processing
          app_ProcessCalendarPublishSpecialDays( pCmd );

          // Free variables after using "pCmd->pEntries" -- it may
          // reference parts of the "app_rawPayload"
          free(app_rawPayload);
          app_rawPayload = NULL;
          app_rawPayloadLen = 0;

          result = ZCL_STATUS_SUCCESS;
        }

        return result;
      }
    ==========================================================================
  */
  // If needed, the user can also send a fragmented command by calling
  // "zclSE_CalendarSendPublishSpecialDays" multiple times, setting "cmdIdx",
  // "cmdTotal", and the raw payload fields accordingly.
} zclSE_CalendarPublishSpecialDays_t;

typedef struct
{
  uint32_t providerID;
  uint32_t issuerCalendarID;
  uint8_t calendarType; // see ZCL_SE_CALENDAR_TYPE
} zclSE_CalendarCancelCalendar_t;

typedef struct
{
  uint32_t earliestStartTime;
  uint32_t minIssuerEvtID;
  uint8_t numOfCalendars;
  uint8_t calendarType; // see ZCL_SE_CALENDAR_TYPE
  uint32_t providerID;
} zclSE_CalendarGetCalendar_t;

typedef struct
{
  uint32_t providerID;
  uint32_t issuerCalendarID;
  uint8_t startDayID;
  uint8_t numOfDays;
} zclSE_CalendarGetDayProfiles_t;

typedef struct
{
  uint32_t providerID;
  uint32_t issuerCalendarID;
  uint8_t startWeekID;
  uint8_t numOfWeeks;
} zclSE_CalendarGetWeekProfiles_t;

typedef struct
{
  uint32_t providerID;
  uint32_t issuerCalendarID;
} zclSE_CalendarGetSeasons_t;

typedef struct
{
  uint32_t startTime;
  uint8_t numOfEvents;
  uint8_t calendarType;
  uint32_t providerID;
  uint32_t issuerCalendarID;
} zclSE_CalendarGetSpecialDays_t;

//=================================================================================================
// Calendar Callbacks(ZCL_CLUSTER_ID_SE_CALENDAR)
//=================================================================================================
// Callback COMMAND_SE_CALENDAR_PUBLISH_CALENDAR
typedef void (*zclSE_CalendarPublishCalendarCB_t)( zclIncoming_t *pInMsg,
                                                   zclSE_CalendarPublishCalendar_t *pCmd );

// Callback COMMAND_SE_CALENDAR_PUBLISH_DAY_PROFILE
//  @return ZCL_STATUS_SUCCESS or
//          ZCL_STATUS_NOT_FOUND
//          ZCL_STATUS_INSUFFICIENT_SPACE
typedef ZStatus_t (*zclSE_CalendarPublishDayProfileCB_t)(
                      zclIncoming_t *pInMsg,
                      zclSE_CalendarPublishDayProfile_t *pCmd );

// Callback COMMAND_SE_CALENDAR_PUBLISH_WEEK_PROFILE
//  @return ZCL_STATUS_SUCCESS or
//          ZCL_STATUS_NOT_FOUND
//          ZCL_STATUS_INSUFFICIENT_SPACE
typedef ZStatus_t (*zclSE_CalendarPublishWeekProfileCB_t)(
                      zclIncoming_t *pInMsg,
                      zclSE_CalendarPublishWeekProfile_t *pCmd );

// Callback COMMAND_SE_CALENDAR_PUBLISH_SEASONS
//  @return ZCL_STATUS_SUCCESS or
//          ZCL_STATUS_NOT_FOUND
//          ZCL_STATUS_INSUFFICIENT_SPACE
typedef ZStatus_t (*zclSE_CalendarPublishSeasonsCB_t)(
                      zclIncoming_t *pInMsg,
                      zclSE_CalendarPublishSeasons_t *pCmd );

// Callback COMMAND_SE_CALENDAR_PUBLISH_SPECIAL_DAYS
//  @return ZCL_STATUS_SUCCESS or
//          ZCL_STATUS_NOT_FOUND
//          ZCL_STATUS_INSUFFICIENT_SPACE
typedef ZStatus_t (*zclSE_CalendarPublishSpecialDaysCB_t)(
                      zclIncoming_t *pInMsg,
                      zclSE_CalendarPublishSpecialDays_t *pCmd );

// Callback COMMAND_SE_CALENDAR_CANCEL_CALENDAR
typedef void (*zclSE_CalendarCancelCalendarCB_t)( zclIncoming_t *pInMsg,
                                                  zclSE_CalendarCancelCalendar_t *pCmd );

// Callback COMMAND_SE_CALENDAR_GET_CALENDAR
typedef void (*zclSE_CalendarGetCalendarCB_t)( zclIncoming_t *pInMsg,
                                               zclSE_CalendarGetCalendar_t *pCmd );

// Callback COMMAND_SE_CALENDAR_GET_DAY_PROFILES
//  @return ZCL_STATUS_CMD_HAS_RSP or
//          ZCL_STATUS_NOT_FOUND
typedef ZStatus_t (*zclSE_CalendarGetDayProfilesCB_t)(
                      zclIncoming_t *pInMsg,
                      zclSE_CalendarGetDayProfiles_t *pCmd );

// Callback COMMAND_SE_CALENDAR_GET_WEEK_PROFILES
//  @return ZCL_STATUS_CMD_HAS_RSP or
//          ZCL_STATUS_NOT_FOUND
typedef ZStatus_t (*zclSE_CalendarGetWeekProfilesCB_t)(
                      zclIncoming_t *pInMsg,
                      zclSE_CalendarGetWeekProfiles_t *pCmd );

// Callback COMMAND_SE_CALENDAR_GET_SEASONS
typedef void (*zclSE_CalendarGetSeasonsCB_t)( zclIncoming_t *pInMsg,
                                              zclSE_CalendarGetSeasons_t *pCmd );

// Callback COMMAND_SE_CALENDAR_GET_SPECIAL_DAYS
typedef void (*zclSE_CalendarGetSpecialDaysCB_t)( zclIncoming_t *pInMsg,
                                                  zclSE_CalendarGetSpecialDays_t *pCmd );

// Callback COMMAND_SE_CALENDAR_GET_CALENDAR_CANCELLATION
//  @return ZCL_STATUS_CMD_HAS_RSP or
//          ZCL_STATUS_NOT_FOUND
typedef ZStatus_t (*zclSE_CalendarGetCalendarCancellationCB_t)( zclIncoming_t *pInMsg );

// Server-to-Client Callbacks
typedef struct
{
  // COMMAND_SE_CALENDAR_PUBLISH_CALENDAR
  zclSE_CalendarPublishCalendarCB_t     pfnPublishCalendar;
  // COMMAND_SE_CALENDAR_PUBLISH_DAY_PROFILE
  zclSE_CalendarPublishDayProfileCB_t   pfnPublishDayProfile;
  // COMMAND_SE_CALENDAR_PUBLISH_WEEK_PROFILE
  zclSE_CalendarPublishWeekProfileCB_t  pfnPublishWeekProfile;
  // COMMAND_SE_CALENDAR_PUBLISH_SEASONS
  zclSE_CalendarPublishSeasonsCB_t      pfnPublishSeasons;
  // COMMAND_SE_CALENDAR_PUBLISH_SPECIAL_DAYS
  zclSE_CalendarPublishSpecialDaysCB_t  pfnPublishSpecialDays;
  // COMMAND_SE_CALENDAR_CANCEL_CALENDAR
  zclSE_CalendarCancelCalendarCB_t      pfnCancelCalendar;
} zclSE_CalendarClientCBs_t;

// Client-to-Server Callbacks
typedef struct
{
  // COMMAND_SE_CALENDAR_GET_CALENDAR
  zclSE_CalendarGetCalendarCB_t              pfnGetCalendar;
  // COMMAND_SE_CALENDAR_GET_DAY_PROFILES
  zclSE_CalendarGetDayProfilesCB_t           pfnGetDayProfiles;
  // COMMAND_SE_CALENDAR_GET_WEEK_PROFILES
  zclSE_CalendarGetWeekProfilesCB_t          pfnGetWeekProfiles;
  // COMMAND_SE_CALENDAR_GET_SEASONS
  zclSE_CalendarGetSeasonsCB_t               pfnGetSeasons;
  // COMMAND_SE_CALENDAR_GET_SPECIAL_DAYS
  zclSE_CalendarGetSpecialDaysCB_t           pfnGetSpecialDays;
  // COMMAND_SE_CALENDAR_GET_CALENDAR_CANCELLATION
  zclSE_CalendarGetCalendarCancellationCB_t  pfnGetCalendarCancellation;
} zclSE_CalendarServerCBs_t;

//=================================================================================================
// DeviceMgmt Command Fields(ZCL_CLUSTER_ID_SE_DEVICE_MGMT)
//=================================================================================================
typedef struct
{
  uint32_t providerID;
  uint32_t issuerEvtID;
  uint8_t tariffType;
  uint32_t implDateTime;
  uint32_t propTenancyChangeCtrl;
} zclSE_DeviceMgmtPublishChangeOfTenancy_t;

typedef struct
{
  uint32_t currProviderID;
  uint32_t issuerEvtID;
  uint8_t tariffType;
  uint32_t propProviderID;
  uint32_t providerChangeImplTime;
  uint32_t providerChangeCtrl;
  UTF8String_t propProviderName;
  UTF8String_t propProviderContactDetails;
} zclSE_DeviceMgmtPublishChangeOfSupplier_t;

typedef struct
{
  uint32_t issuerEvtID;
  uint32_t implDateTime;
  uint16_t duration;
  uint8_t type;
  UTF8String_t pw;
} zclSE_DeviceMgmtReqNewPWRsp_t;

typedef struct
{
  uint32_t issuerEvtID;
  uint32_t siteIDTime;
  uint32_t providerID;
  UTF8String_t siteID;
} zclSE_DeviceMgmtUpdateSiteID_t;

typedef struct
{
  uint8_t numOfEvtIDs;
  uint16_t *pEvtIDs; // see ZCL_SE_DEVICE_MGMT_EVT_CFG_ATTRS
} zclSE_DeviceMgmtEvtCfgList_t;

typedef union
{
  zclSE_DeviceMgmtEvtCfgList_t cfgList;
  uint16_t groupID; // see ZCL_SE_DEVICE_MGMT_EVT_CFG_ATTRS
  uint8_t logID;
  uint8_t match; // see ZCL_SE_DEVICE_MGMT_EVT_CFG_VALUE
} zclSE_DeviceMgmtEvtCfgCtrl_t;

typedef struct
{
  uint32_t issuerEvtID;
  uint32_t startDateTime;
  uint8_t evtCfg; // see ZCL_SE_DEVICE_MGMT_EVT_CFG_VALUE
  uint8_t cfgCtrl; // see ZCL_SE_DEVICE_MGMT_EVT_CFG_CTRL
  zclSE_DeviceMgmtEvtCfgCtrl_t cfgCtrlFld;
} zclSE_DeviceMgmtSetEvtCfg_t;

typedef struct
{
  uint16_t evtID; // see ZCL_SE_DEVICE_MGMT_EVT_CFG_ATTRS
} zclSE_DeviceMgmtGetEvtCfg_t;

typedef struct
{
  uint32_t issuerEvtID;
  uint32_t time;
  uint32_t providerID;
  UTF8String_t customerIDNum;
} zclSE_DeviceMgmtUpdateCIN_t;

typedef struct
{
  uint8_t type;
} zclSE_DeviceMgmtReqNewPW_t;

typedef struct
{
  uint16_t evtID; // see ZCL_SE_DEVICE_MGMT_EVT_CFG_ATTRS
  uint8_t evtCfg; // see ZCL_SE_DEVICE_MGMT_EVT_CFG_VALUE
} zclSE_DeviceMgmtEvt_t;

typedef struct
{
  uint8_t cmdIdx;
  uint8_t cmdTotal;
  uint8_t numOfEvts;

  // May be empty if fragmented -- see raw payload fields below
  zclSE_DeviceMgmtEvt_t *pEvts;

  // Raw payloads are used to send and receive fragmented commands -- see below
  uint16_t rawPayloadLen;
  uint8_t *pRawPayload;

  // Depending on the length of the entire command, the command may be
  // fragmented.  If the command is fragmented the "pEvts" field will be
  // empty and the raw payload fields will be set.  When receiving fragmented
  // commands the user is responsible to concatenate all the fragments into one
  // complete "pRawPayload" field.  Once the entire "pRawPayload" has been built
  // from all the fragments, the user can then call
  // "zclSE_DeviceMgmtEvtParse" to parse the "pRawPayload" and build
  // a valid "pEvts" field.  A simple example is provided below.  Note that
  // the function "zclSE_DeviceMgmtEvtParse" should be called from
  // within the context of a COMMAND_SE_DEVICE_MGMT_REPORT_EVT_CFG callback
  // function -- see example below.
  //
  //  EXAMPLE CALLBACK HANDLER:
  //  ==========================================================================
  /*
      // Local vars to build raw concatenated payload from multipe fragments
      static uint8_t app_rawPayloadLen = 0;
      static uint8_t *app_rawPayload = NULL;

      // Callback for COMMAND_SE_DEVICE_MGMT_REPORT_EVT_CFG
      uint8_t app_DeviceMgmtReportEvtCfgCB(
              zclIncoming_t *pInMsg,
              zclSE_DeviceMgmtReportEvtCfg_t *pCmd )
      {
        uint8_t result = ZCL_STATUS_SUCCESS;
        uint8_t parseResult;
        uint8_t completeCmdReady = FALSE;

        if ( pCmd->cmdTotal > 1 )
        {
          // Simple example of concatenating command fragments
          app_rawPayload = realloc( app_rawPayload,
                                    app_rawPayloadLen + pCmd->rawPayloadLen);
          if (app_rawPayload == NULL )
          {
            return ZCL_STATUS_SOFTWARE_FAILURE;
          }

          OsalPort_memcpy( &app_rawPayload[app_rawPayloadLen],
                  pCmd->pRawPayload,
                  pCmd->rawPayloadLen );

          app_rawPayloadLen += pCmd->rawPayloadLen;

          // Is this the last fragment
          if ( ( pCmd->cmdIdx + 1 ) == pCmd->cmdTotal )
          {
             // Set the full raw payload fields
             pCmd->pRawPayload = app_rawPayload;
             pCmd->rawPayloadLen = app_rawPayloadLen;

            // Parse the full command payload
            result = zclSE_DeviceMgmtEvtParse( pCmd );

            if ( result == ZCL_STATUS_SUCCESS )
            {
              // Current command is ready for final processing
              completeCmdReady = TRUE;
            }
            else
            {
              // Reset variables
              free(app_rawPayload);
              app_rawPayload = NULL;
              app_rawPayloadLen = 0;
            }
          }
        }
        else
        {
          // No fragmentation -- just use current command for final processing
          completeCmdReady = TRUE;
        }

        // Is command ready to process, ie the "pEvts" field is valid
        if ( completeCmdReady )
        {
          // User specific command processing
          app_ProcessDeviceMgmtReportEvtCfg( pCmd );

          // Free variables after using "pCmd->pEvts" -- it may
          // reference parts of the "app_rawPayload"
          free(app_rawPayload);
          app_rawPayload = NULL;
          app_rawPayloadLen = 0;

          result = ZCL_STATUS_SUCCESS;
        }

        return result;
      }
    ==========================================================================
  */
  // If needed, the user can also send a fragmented command by calling
  // "zclSE_DeviceMgmtSendReportEvtCfg" multiple times, setting "cmdIdx",
  // "cmdTotal", and the raw payload fields accordingly.
} zclSE_DeviceMgmtReportEvtCfg_t;

//=================================================================================================
// DeviceMgmt Callbacks(ZCL_CLUSTER_ID_SE_DEVICE_MGMT)
//=================================================================================================
// Callback COMMAND_SE_DEVICE_MGMT_PUBLISH_CHANGE_OF_TENANCY
typedef void (*zclSE_DeviceMgmtPublishChangeOfTenancyCB_t)(
                 zclIncoming_t *pInMsg,
                 zclSE_DeviceMgmtPublishChangeOfTenancy_t *pCmd );

// Callback COMMAND_SE_DEVICE_MGMT_PUBLISH_CHANGE_OF_SUPPLIER
typedef void (*zclSE_DeviceMgmtPublishChangeOfSupplierCB_t)(
                 zclIncoming_t *pInMsg,
                 zclSE_DeviceMgmtPublishChangeOfSupplier_t *pCmd );

// Callback COMMAND_SE_DEVICE_MGMT_REQ_NEW_PW_RSP
typedef void (*zclSE_DeviceMgmtReqNewPWRspCB_t)( zclIncoming_t *pInMsg,
                                                 zclSE_DeviceMgmtReqNewPWRsp_t *pCmd );

// Callback COMMAND_SE_DEVICE_MGMT_UPDATE_SITE_ID
typedef void (*zclSE_DeviceMgmtUpdateSiteID_CB_t)( zclIncoming_t *pInMsg,
                                                   zclSE_DeviceMgmtUpdateSiteID_t *pCmd );

// Callback COMMAND_SE_DEVICE_MGMT_SET_EVT_CFG
typedef void (*zclSE_DeviceMgmtSetEvtCfgCB_t)( zclIncoming_t *pInMsg,
                                               zclSE_DeviceMgmtSetEvtCfg_t *pCmd );

// Callback COMMAND_SE_DEVICE_MGMT_GET_EVT_CFG
//  @return ZCL_STATUS_CMD_HAS_RSP or
//          ZCL_STATUS_NOT_FOUND
typedef ZStatus_t (*zclSE_DeviceMgmtGetEvtCfgCB_t)( zclIncoming_t *pInMsg,
                                                    zclSE_DeviceMgmtGetEvtCfg_t *pCmd );

// Callback COMMAND_SE_DEVICE_MGMT_UPDATE_CIN
//  @return ZCL_STATUS_SUCCESS or
//          ZCL_STATUS_NOT_AUTHORIZED
typedef ZStatus_t (*zclSE_DeviceMgmtUpdateCIN_CB_t)(
                      zclIncoming_t *pInMsg,
                      zclSE_DeviceMgmtUpdateCIN_t *pCmd );

// Callback COMMAND_SE_DEVICE_MGMT_GET_CHANGE_OF_TENANCY
//  @return ZCL_STATUS_CMD_HAS_RSP or
//          ZCL_STATUS_NOT_FOUND
typedef ZStatus_t (*zclSE_DeviceMgmtGetChangeOfTenancyCB_t)(
                      zclIncoming_t *pInMsg );

// Callback COMMAND_SE_DEVICE_MGMT_GET_CHANGE_OF_SUPPLIER
//  @return ZCL_STATUS_CMD_HAS_RSP or
//          ZCL_STATUS_NOT_FOUND
typedef ZStatus_t (*zclSE_DeviceMgmtGetChangeOfSupplierCB_t)(
                      zclIncoming_t *pInMsg );

// Callback COMMAND_SE_DEVICE_MGMT_REQ_NEW_PW
//  @return ZCL_STATUS_CMD_HAS_RSP or
//          ZCL_STATUS_NOT_FOUND
typedef ZStatus_t (*zclSE_DeviceMgmtReqNewPW_CB_t)( zclIncoming_t *pInMsg,
                                                    zclSE_DeviceMgmtReqNewPW_t *pCmd );

// Callback COMMAND_SE_DEVICE_MGMT_GET_SITE_ID
//  @return ZCL_STATUS_CMD_HAS_RSP or
//          ZCL_STATUS_NOT_FOUND
typedef ZStatus_t (*zclSE_DeviceMgmtGetSiteID_CB_t)(
                      zclIncoming_t *pInMsg );

// Callback COMMAND_SE_DEVICE_MGMT_REPORT_EVT_CFG
//  @return ZCL_STATUS_SUCCESS or
//          ZCL_STATUS_MALFORMED_COMMAND
//          ZCL_STATUS_SOFTWARE_FAILURE
typedef ZStatus_t (*zclSE_DeviceMgmtReportEvtCfgCB_t)(
                      zclIncoming_t *pInMsg,
                      zclSE_DeviceMgmtReportEvtCfg_t *pCmd );

// Callback COMMAND_SE_DEVICE_MGMT_GET_CIN
//  @return ZCL_STATUS_CMD_HAS_RSP or
//          ZCL_STATUS_NOT_FOUND
typedef ZStatus_t (*zclSE_DeviceMgmtGetCIN_CB_t)( zclIncoming_t *pInMsg );

// Server-to-Client Callbacks
typedef struct
{
  // COMMAND_SE_DEVICE_MGMT_PUBLISH_CHANGE_OF_TENANCY
  zclSE_DeviceMgmtPublishChangeOfTenancyCB_t   pfnPublishChangeOfTenancy;
  // COMMAND_SE_DEVICE_MGMT_PUBLISH_CHANGE_OF_SUPPLIER
  zclSE_DeviceMgmtPublishChangeOfSupplierCB_t  pfnPublishChangeOfSupplier;
  // COMMAND_SE_DEVICE_MGMT_REQ_NEW_PW_RSP
  zclSE_DeviceMgmtReqNewPWRspCB_t              pfnReqNewPWRsp;
  // COMMAND_SE_DEVICE_MGMT_UPDATE_SITE_ID
  zclSE_DeviceMgmtUpdateSiteID_CB_t            pfnUpdateSiteID_;
  // COMMAND_SE_DEVICE_MGMT_SET_EVT_CFG
  zclSE_DeviceMgmtSetEvtCfgCB_t                pfnSetEvtCfg;
  // COMMAND_SE_DEVICE_MGMT_GET_EVT_CFG
  zclSE_DeviceMgmtGetEvtCfgCB_t                pfnGetEvtCfg;
  // COMMAND_SE_DEVICE_MGMT_UPDATE_CIN
  zclSE_DeviceMgmtUpdateCIN_CB_t               pfnUpdateCIN_;
} zclSE_DeviceMgmtClientCBs_t;

// Client-to-Server Callbacks
typedef struct
{
  // COMMAND_SE_DEVICE_MGMT_GET_CHANGE_OF_TENANCY
  zclSE_DeviceMgmtGetChangeOfTenancyCB_t   pfnGetChangeOfTenancy;
  // COMMAND_SE_DEVICE_MGMT_GET_CHANGE_OF_SUPPLIER
  zclSE_DeviceMgmtGetChangeOfSupplierCB_t  pfnGetChangeOfSupplier;
  // COMMAND_SE_DEVICE_MGMT_REQ_NEW_PW
  zclSE_DeviceMgmtReqNewPW_CB_t            pfnReqNewPW_;
  // COMMAND_SE_DEVICE_MGMT_GET_SITE_ID
  zclSE_DeviceMgmtGetSiteID_CB_t           pfnGetSiteID_;
  // COMMAND_SE_DEVICE_MGMT_REPORT_EVT_CFG
  zclSE_DeviceMgmtReportEvtCfgCB_t         pfnReportEvtCfg;
  // COMMAND_SE_DEVICE_MGMT_GET_CIN
  zclSE_DeviceMgmtGetCIN_CB_t              pfnGetCIN_;
} zclSE_DeviceMgmtServerCBs_t;

//=================================================================================================
// Events Command Fields(ZCL_CLUSTER_ID_SE_EVENTS)
//=================================================================================================
typedef struct
{
  uint8_t logID; // see ZCL_SE_EVENTS_LOG_ID
  uint16_t evtID; // see ZCL_SE_DEVICE_MGMT_EVT_CFG_ATTRS
  uint32_t evtTime;
  uint8_t evtCtrl; // see ZCL_SE_EVENTS_PUBLISH_EVT_CTRL
  UTF8String_t evtData;
} zclSE_EventsPublishEvt_t;

typedef struct
{
  uint8_t logID; // see ZCL_SE_EVENTS_LOG_ID
  uint16_t evtID; // see ZCL_SE_DEVICE_MGMT_EVT_CFG_ATTRS
  uint32_t evtTime;
  UTF8String_t evtData;
} zclSE_EventsLoggedEvt_t;

typedef struct
{
  uint8_t numOfEvts; // use low nibble - not shifted
  uint8_t ctrl; // see ZCL_SE_EVENTS_LOGGED_EVT_CTRL
  zclSE_EventsLoggedEvt_t *pEvts;
} zclSE_EventsEvtLog_t;

typedef struct
{
  uint16_t numOfMatchingEvts;
  uint8_t cmdIdx;
  uint8_t cmdTotal;

  // May be empty if fragmented -- see raw payload fields below
  zclSE_EventsEvtLog_t log;

  // Raw payloads are used to send and receive fragmented commands -- see below
  uint8_t rawPayloadLen;
  uint8_t* pRawPayload;

  // Depending on the length of the entire command, the command may be
  // fragmented.  If the command is fragmented the "log" field will be empty
  // and the raw payload fields will be set.  When receiving fragmented commands
  // the user is responsible to concatenate all the fragments into one complete
  // "pRawPayload" field.  Once the entire "pRawPayload" has been built from all
  // the fragments, the user can then call "zclSE_EventsEvtLogParse" to parse
  // the "pRawPayload" and build a valid "log" field.  A simple example is
  // provided below.  Note that the funtion "zclSE_EventsEvtLogParse" should be
  // called from within the context of a COMMAND_SE_EVENTS_PUBLISH_EVT_LOG
  // callback function -- see example below.
  //
  //  EXAMPLE CALLBACK HANDLER:
  //  ==========================================================================
  /*
      // Local vars to build raw concatenated payload from multipe fragments
      static uint8_t app_rawPayloadLen = 0;
      static uint8_t *app_rawPayload = NULL;

      // Callback for COMMAND_SE_EVENTS_PUBLISH_EVT_LOG
      uint8_t app_EventsPublishEvtLogCB(
              zclIncoming_t *pInMsg,
              zclSE_EventsPublishEvtLog_t *pCmd )
      {
        uint8_t result = ZCL_STATUS_SUCCESS;
        uint8_t completeCmdReady = FALSE;

        if ( pCmd->cmdTotal > 1 )
        {
          // Simple example of concatenating command fragments
          app_rawPayload = realloc( app_rawPayload,
                                    app_rawPayloadLen + pCmd->rawPayloadLen);
          if (app_rawPayload == NULL )
          {
            return ZCL_STATUS_SOFTWARE_FAILURE;
          }

          OsalPort_memcpy( &app_rawPayload[app_rawPayloadLen],
                  pCmd->pRawPayload,
                  pCmd->rawPayloadLen );

          app_rawPayloadLen += pCmd->rawPayloadLen;

          // Is this the last fragment
          if ( ( pCmd->cmdIdx + 1 ) == pCmd->cmdTotal )
          {
             // Set the full raw payload fields
             pCmd->pRawPayload = app_rawPayload;
             pCmd->rawPayloadLen = app_rawPayloadLen;

            // Parse the full command payload
            result = zclSE_EventsEvtLogParse( pCmd );

            if ( result == ZCL_STATUS_SUCCESS )
            {
              // Current command is ready for final processing
              completeCmdReady = TRUE;
            }
            else
            {
              // Reset variables
              free(app_rawPayload);
              app_rawPayload = NULL;
              app_rawPayloadLen = 0;
            }
          }
        }
        else
        {
          // No fragmentation -- just use current command for final processing
          completeCmdReady = TRUE;
        }

        // Is command ready to process, ie the "log" is valid
        if ( completeCmdReady )
        {
          // User specific command processing
          app_ProcessEventsPublishEvtLog( pCmd );

          // Free variables after using "pCmd->log" -- it may
          // reference parts of the "app_rawPayload"
          free(app_rawPayload);
          app_rawPayload = NULL;
          app_rawPayloadLen = 0;
        }

        return result;
      }
    ==========================================================================
  */
  // If needed, the user can also send a fragmented command by calling
  // "zclSE_EventsSendPublishEvtLog" multiple times, setting "cmdIdx",
  // "cmdTotal" and the raw payload fields accordingly.
} zclSE_EventsPublishEvtLog_t;

typedef struct
{
  uint8_t clearStatus; // see ZCL_SE_EVENTS_CLEAR
} zclSE_EventsClearEvtLogRsp_t;

typedef struct
{
  uint8_t evtCtrl; // see ZCL_SE_EVENTS_GET_EVT_CTRL
                 // use low nibble - not shifted
  uint8_t logID; // see ZCL_SE_EVENTS_LOG_ID
  uint16_t evtID;
  uint32_t startTime;
  uint32_t endTime;
  uint8_t numOfEvts;
  uint16_t evtOffset;
} zclSE_EventsGetEvtLog_t;

typedef struct
{
  uint8_t logID; // see ZCL_SE_EVENTS_LOG_ID
} zclSE_EventsClearEvtLog_t;

//=================================================================================================
// Events Callbacks(ZCL_CLUSTER_ID_SE_EVENTS)
//=================================================================================================
// Callback COMMAND_SE_EVENTS_PUBLISH_EVT
typedef void (*zclSE_EventsPublishEvtCB_t)( zclIncoming_t *pInMsg,
                                            zclSE_EventsPublishEvt_t *pCmd );

// Callback COMMAND_SE_EVENTS_PUBLISH_EVT_LOG
//  @return ZCL_STATUS_SUCCESS or
//          ZCL_STATUS_MALFORMED_COMMAND
//          ZCL_STATUS_SOFTWARE_FAILURE
typedef ZStatus_t (*zclSE_EventsPublishEvtLogCB_t)( zclIncoming_t *pInMsg,
                                                    zclSE_EventsPublishEvtLog_t *pCmd );

// Callback COMMAND_SE_EVENTS_CLEAR_EVT_LOG_RSP
typedef void (*zclSE_EventsClearEvtLogRspCB_t)( zclIncoming_t *pInMsg,
                                                zclSE_EventsClearEvtLogRsp_t *pCmd );

// Callback COMMAND_SE_EVENTS_GET_EVT_LOG
//  @return ZCL_STATUS_CMD_HAS_RSP or
//          ZCL_STATUS_NOT_FOUND
typedef ZStatus_t (*zclSE_EventsGetEvtLogCB_t)( zclIncoming_t *pInMsg,
                                                zclSE_EventsGetEvtLog_t *pCmd );

// Callback COMMAND_SE_EVENTS_CLEAR_EVT_LOG
typedef void (*zclSE_EventsClearEvtLogCB_t)( zclIncoming_t *pInMsg,
                                             zclSE_EventsClearEvtLog_t *pCmd );

// Server-to-Client Callbacks
typedef struct
{
  // COMMAND_SE_EVENTS_PUBLISH_EVT
  zclSE_EventsPublishEvtCB_t      pfnPublishEvt;
  // COMMAND_SE_EVENTS_PUBLISH_EVT_LOG
  zclSE_EventsPublishEvtLogCB_t   pfnPublishEvtLog;
  // COMMAND_SE_EVENTS_CLEAR_EVT_LOG_RSP
  zclSE_EventsClearEvtLogRspCB_t  pfnClearEvtLogRsp;
} zclSE_EventsClientCBs_t;

// Client-to-Server Callbacks
typedef struct
{
  // COMMAND_SE_EVENTS_GET_EVT_LOG
  zclSE_EventsGetEvtLogCB_t    pfnGetEvtLog;
  // COMMAND_SE_EVENTS_CLEAR_EVT_LOG
  zclSE_EventsClearEvtLogCB_t  pfnClearEvtLog;
} zclSE_EventsServerCBs_t;

//=================================================================================================
// EnergyMgmt Command Fields(ZCL_CLUSTER_ID_SE_ENERGY_MGMT)
//=================================================================================================
typedef struct
{
  uint32_t issuerEvtID;
  uint8_t evtStatus; // see ZCL_SE_DRLC_EVT_STATUS
  uint32_t evtStatusTime;
  uint8_t critLevelApplied;
  uint16_t coolingTempSetPtApplied;
  uint16_t heatingTempSetPtApplied;
  int8_t avgLoadAdjPctApplied;
  uint8_t dutyCycleApplied;
  uint8_t evtCtrl; // see ZCL_SE_DRLC_EVT_CTRL
} zclSE_EnergyMgmtReportEvtStatus_t;

typedef struct
{
  uint32_t issuerEvtID;
  uint16_t deviceClass; // see ZCL_SE_DRLC_DEV_CLASS
  uint8_t utilityEnrollmentGroup;
  uint8_t actionsRequired; // see ZCL_SE_ENERGY_MGMT_ACTION
} zclSE_EnergyMgmtManageEvt_t;

//=================================================================================================
// EnergyMgmt Callbacks(ZCL_CLUSTER_ID_SE_ENERGY_MGMT)
//=================================================================================================
// Callback COMMAND_SE_ENERGY_MGMT_REPORT_EVT_STATUS
typedef void (*zclSE_EnergyMgmtReportEvtStatusCB_t)
                 ( zclIncoming_t *pInMsg,
                   zclSE_EnergyMgmtReportEvtStatus_t *pCmd );

// Callback COMMAND_SE_ENERGY_MGMT_MANAGE_EVT
typedef void (*zclSE_EnergyMgmtManageEvtCB_t)( zclIncoming_t *pInMsg,
                                               zclSE_EnergyMgmtManageEvt_t *pCmd );

// Server-to-Client Callbacks
typedef struct
{
  // COMMAND_SE_ENERGY_MGMT_REPORT_EVT_STATUS
  zclSE_EnergyMgmtReportEvtStatusCB_t  pfnReportEvtStatus;
} zclSE_EnergyMgmtClientCBs_t;

// Client-to-Server Callbacks
typedef struct
{
  // COMMAND_SE_ENERGY_MGMT_MANAGE_EVT
  zclSE_EnergyMgmtManageEvtCB_t  pfnManageEvt;
} zclSE_EnergyMgmtServerCBs_t;

//=================================================================================================
// MDUPairing Command Fields(ZCL_CLUSTER_ID_SE_MDU_PAIRING)
//=================================================================================================
typedef struct
{
  uint32_t version;
  uint8_t cmdIdx;
  uint8_t cmdTotal;
  uint8_t numOfDevices;

  // May be empty if fragmented -- see raw payload fields below
  uint8_t (*pDevices)[Z_EXTADDR_LEN];

  // Raw payloads are used to send and receive fragmented commands -- see below
  uint8_t rawPayloadLen;
  uint8_t* pRawPayload;

  // Depending on the length of the entire command, the command may be
  // fragmented.  If the command is fragmented the "pDevices" field will be
  // NULL and the raw payload fields will be set.  When receiving fragmented
  // commands the user is responsible to concatenate all the fragments into one
  // complete "pRawPayload" field.  Once the entire "pRawPayload" has been built
  // from all the fragments, the user can then call
  // "zclSE_MDUPairingDevicesParse" to parse the "pRawPayload" and build a valid
  // "pDevices" field.  A simple example is provided below.  Note that the
  // function "zclSE_MDUPairingDevicesParse" should be called from within the
  // context of a COMMAND_SE_MDU_PAIRING_PAIRING_RSP callback function -- see
  // example below.
  //
  //  EXAMPLE CALLBACK HANDLER:
  //  ==========================================================================
  /*
      // Local vars to build raw concatenated payload from multipe fragments
      static uint8_t app_rawPayloadLen = 0;
      static uint8_t *app_rawPayload = NULL;

      // Callback for COMMAND_SE_MDU_PAIRING_PAIRING_RSP
      uint8_t app_MDUPairingPairingRspCB(
              zclIncoming_t *pInMsg,
              zclSE_MDUPairingPairingRsp_t *pCmd )
      {
        uint8_t result = ZCL_STATUS_SUCCESS;
        uint8_t completeCmdReady = FALSE;

        if ( pCmd->cmdTotal > 1 )
        {
          // Simple example of concatenating command fragments
          app_rawPayload = realloc( app_rawPayload,
                                    app_rawPayloadLen + pCmd->rawPayloadLen);
          if (app_rawPayload == NULL )
          {
            return ZCL_STATUS_SOFTWARE_FAILURE;
          }

          OsalPort_memcpy( &app_rawPayload[app_rawPayloadLen],
                  pCmd->pRawPayload,
                  pCmd->rawPayloadLen );

          app_rawPayloadLen += pCmd->rawPayloadLen;

          // Is this the last fragment
          if ( ( pCmd->cmdIdx + 1 ) == pCmd->cmdTotal )
          {
             // Set the full raw payload fields
             pCmd->pRawPayload = app_rawPayload;
             pCmd->rawPayloadLen = app_rawPayloadLen;

            // Parse the full command payload
            result = zclSE_MDUPairingDevicesParse( pCmd );

            if ( result == ZCL_STATUS_SUCCESS )
            {
              // Current command is ready for final processing
              completeCmdReady = TRUE;
            }
            else
            {
              // Reset variables
              free(app_rawPayload);
              app_rawPayload = NULL;
              app_rawPayloadLen = 0;
            }
          }
        }
        else
        {
          // No fragmentation -- just use current command for final processing
          completeCmdReady = TRUE;
        }

        // Is command ready to process, ie the "pDevices" is valid
        if ( completeCmdReady )
        {
          // User specific command processing
          app_ProcessMDUPairingPairingRsp( pCmd );

          // Free variables after using "pCmd->pDevices" -- it may
          // reference parts of the "app_rawPayload"
          free(app_rawPayload);
          app_rawPayload = NULL;
          app_rawPayloadLen = 0;
        }

        return result;
      }
    ==========================================================================
  */
  // If needed, the user can also send a fragmented command by calling
  // "zclSE_MDUPairingSendPairingRsp" multiple times, setting "cmdIdx",
  // "cmdTotal" and the raw payload fields accordingly.
} zclSE_MDUPairingPairingRsp_t;

typedef struct
{
  uint32_t version;
  uint8_t extAddr[Z_EXTADDR_LEN];
} zclSE_MDUPairingPairingReq_t;

//=================================================================================================
// MDUPairing Callbacks(ZCL_CLUSTER_ID_SE_MDU_PAIRING)
//=================================================================================================
// Callback COMMAND_SE_MDU_PAIRING_PAIRING_RSP
//  @return ZCL_STATUS_SUCCESS or
//          ZCL_STATUS_MALFORMED_COMMAND
//          ZCL_STATUS_SOFTWARE_FAILURE
typedef ZStatus_t (*zclSE_MDUPairingPairingRspCB_t)(
                      zclIncoming_t *pInMsg,
                      zclSE_MDUPairingPairingRsp_t *pCmd );

// Callback COMMAND_SE_MDU_PAIRING_PAIRING_REQ
//  @return ZCL_STATUS_CMD_HAS_RSP or
//          ZCL_STATUS_WAIT_FOR_DATA
typedef ZStatus_t (*zclSE_MDUPairingPairingReqCB_t)(
                      zclIncoming_t *pInMsg,
                      zclSE_MDUPairingPairingReq_t *pCmd );

// Server-to-Client Callbacks
typedef struct
{
  // COMMAND_SE_MDU_PAIRING_PAIRING_RSP
  zclSE_MDUPairingPairingRspCB_t  pfnPairingReq;
} zclSE_MDUPairingClientCBs_t;

// Client-to-Server Callbacks
typedef struct
{
  // COMMAND_SE_MDU_PAIRING_PAIRING_REQ
  zclSE_MDUPairingPairingReqCB_t  pfnPairingReq;
} zclSE_MDUPairingServerCBs_t;

//=================================================================================================
// zclSE_RegisterCmdCallbacks table entries
//=================================================================================================
// Enter groups of function pointers for callbacks that the application would like to receive
typedef struct
{
  const zclSE_DRLC_ServerCBs_t       *pDRLC_ServerCBs;
  const zclSE_DRLC_ClientCBs_t       *pDRLC_ClientCBs;
  const zclSE_MeteringServerCBs_t    *pMeteringServerCBs;
  const zclSE_MeteringClientCBs_t    *pMeteringClientCBs;
  const zclSE_PriceServerCBs_t       *pPriceServerCBs;
  const zclSE_PriceClientCBs_t       *pPriceClientCBs;
  const zclSE_MessagingServerCBs_t   *pMessagingServerCBs;
  const zclSE_MessagingClientCBs_t   *pMessagingClientCBs;
  const zclSE_TunnelingServerCBs_t   *pTunnelingServerCBs;
  const zclSE_TunnelingClientCBs_t   *pTunnelingClientCBs;
  const zclSE_PrepaymentServerCBs_t  *pPrepaymentServerCBs;
  const zclSE_PrepaymentClientCBs_t  *pPrepaymentClientCBs;
  const zclSE_EnergyMgmtServerCBs_t  *pEnergyMgmtServerCBs;
  const zclSE_EnergyMgmtClientCBs_t  *pEnergyMgmtClientCBs;
  const zclSE_CalendarServerCBs_t    *pCalendarServerCBs;
  const zclSE_CalendarClientCBs_t    *pCalendarClientCBs;
  const zclSE_DeviceMgmtServerCBs_t  *pDeviceMgmtServerCBs;
  const zclSE_DeviceMgmtClientCBs_t  *pDeviceMgmtClientCBs;
  const zclSE_EventsServerCBs_t      *pEventsServerCBs;
  const zclSE_EventsClientCBs_t      *pEventsClientCBs;
  const zclSE_MDUPairingServerCBs_t  *pMDUPairingServerCBs;
  const zclSE_MDUPairingClientCBs_t  *pMDUPairingClientCBs;
} zclSE_AppCallbacks_t;


/**************************************************************************************************
 * PUBLIC FUNCTIONS
 */

/**************************************************************************************************
 * @fn      zclSE_DRLC_SendLoadCtrlEvt
 *
 * @brief   Send COMMAND_SE_DRLC_LOAD_CTRL_EVT.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_DRLC_SendLoadCtrlEvt( uint8_t srcEP, afAddrType_t *dstAddr,
                                             zclSE_DRLC_LoadCtrlEvt_t *pCmd,
                                             uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_DRLC_SendCancelLoadCtrlEvt
 *
 * @brief   Send COMMAND_SE_DRLC_CANCEL_LOAD_CTRL_EVT.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_DRLC_SendCancelLoadCtrlEvt( uint8_t srcEP, afAddrType_t *dstAddr,
                                                   zclSE_DRLC_CancelLoadCtrlEvt_t *pCmd,
                                                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_DRLC_SendCancelAllLoadCtrlEvts
 *
 * @brief   Send COMMAND_SE_DRLC_CANCEL_ALL_LOAD_CTRL_EVTS.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_DRLC_SendCancelAllLoadCtrlEvts(
                   uint8_t srcEP, afAddrType_t *dstAddr,
                   zclSE_DRLC_CancelAllLoadCtrlEvts_t *pCmd,
                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_DRLC_SendReportEvtStatus
 *
 * @brief   Send COMMAND_SE_DRLC_REPORT_EVT_STATUS.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_DRLC_SendReportEvtStatus( uint8_t srcEP, afAddrType_t *dstAddr,
                                                 zclSE_DRLC_ReportEvtStatus_t *pCmd,
                                                 uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_DRLC_SendGetScheduledEvts
 *
 * @brief   Send COMMAND_SE_DRLC_GET_SCHEDULED_EVTS.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_DRLC_SendGetScheduledEvts( uint8_t srcEP, afAddrType_t *dstAddr,
                                                  zclSE_DRLC_GetScheduledEvts_t *pCmd,
                                                  uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_DRLC_ParseLoadCtrlEvt
 *
 * @brief   Parse COMMAND_SE_DRLC_LOAD_CTRL_EVT.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_DRLC_ParseLoadCtrlEvt( zclIncoming_t *pInMsg,
                                              zclSE_DRLC_LoadCtrlEvt_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_DRLC_ParseCancelLoadCtrlEvt
 *
 * @brief   Parse COMMAND_SE_DRLC_CANCEL_LOAD_CTRL_EVT.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_DRLC_ParseCancelLoadCtrlEvt(
                   zclIncoming_t *pInMsg,
                   zclSE_DRLC_CancelLoadCtrlEvt_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_DRLC_ParseCancelAllLoadCtrlEvts
 *
 * @brief   Parse COMMAND_SE_DRLC_CANCEL_ALL_LOAD_CTRL_EVTS.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_DRLC_ParseCancelAllLoadCtrlEvts(
                   zclIncoming_t *pInMsg,
                   zclSE_DRLC_CancelAllLoadCtrlEvts_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_DRLC_ParseReportEvtStatus
 *
 * @brief   Parse COMMAND_SE_DRLC_REPORT_EVT_STATUS.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_DRLC_ParseReportEvtStatus( zclIncoming_t *pInMsg,
                                                  zclSE_DRLC_ReportEvtStatus_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_DRLC_ParseGetScheduledEvts
 *
 * @brief   Parse COMMAND_SE_DRLC_GET_SCHEDULED_EVTS.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_DRLC_ParseGetScheduledEvts( zclIncoming_t *pInMsg,
                                                   zclSE_DRLC_GetScheduledEvts_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_DRLC_HdlLoadCtrlEvt
 *
 * @brief   Handle COMMAND_SE_DRLC_LOAD_CTRL_EVT.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_DRLC_HdlLoadCtrlEvt( zclIncoming_t *pInMsg,
                                            zclSE_DRLC_LoadCtrlEvtCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_DRLC_HdlCancelLoadCtrlEvt
 *
 * @brief   Handle COMMAND_SE_DRLC_CANCEL_LOAD_CTRL_EVT.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_DRLC_HdlCancelLoadCtrlEvt( zclIncoming_t *pInMsg,
                                                  zclSE_DRLC_CancelLoadCtrlEvtCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_DRLC_HdlCancelAllLoadCtrlEvts
 *
 * @brief   Handle COMMAND_SE_DRLC_CANCEL_ALL_LOAD_CTRL_EVTS.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_DRLC_HdlCancelAllLoadCtrlEvts(
                   zclIncoming_t *pInMsg,
                   zclSE_DRLC_CancelAllLoadCtrlEvtsCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_DRLC_HdlReportEvtStatus
 *
 * @brief   Handle COMMAND_SE_DRLC_REPORT_EVT_STATUS.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_DRLC_HdlReportEvtStatus( zclIncoming_t *pInMsg,
                                                zclSE_DRLC_ReportEvtStatusCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_DRLC_HdlGetScheduledEvts
 *
 * @brief   Handle COMMAND_SE_DRLC_GET_SCHEDULED_EVTS.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_DRLC_HdlGetScheduledEvts( zclIncoming_t *pInMsg,
                                                 zclSE_DRLC_GetScheduledEvtsCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_DRLC_HdlClientCmd
 *
 * @brief   Client command handler for ZCL_CLUSTER_ID_SE_DRLC.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCBs - client callbacks
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_DRLC_HdlClientCmd( zclIncoming_t *pInMsg,
                                          const zclSE_DRLC_ClientCBs_t *pCBs );

/**************************************************************************************************
 * @fn      zclSE_DRLC_HdlServerCmd
 *
 * @brief   Server command handler for ZCL_CLUSTER_ID_SE_DRLC.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCBs - server callbacks
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_DRLC_HdlServerCmd( zclIncoming_t *pInMsg,
                                          const zclSE_DRLC_ServerCBs_t *pCBs );

/**************************************************************************************************
 * @fn      zclSE_MeteringSendGetProfileRsp
 *
 * @brief   Send COMMAND_SE_METERING_GET_PROFILE_RSP.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringSendGetProfileRsp( uint8_t srcEP, afAddrType_t *dstAddr,
                                                  zclSE_MeteringGetProfileRsp_t *pCmd,
                                                  uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_MeteringSendReqMirror
 *
 * @brief   Send COMMAND_SE_METERING_REQ_MIRROR (send with no payload).
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
#define zclSE_MeteringSendReqMirror( srcEP, dstAddr, disableDefaultRsp, seqNum )      \
  zcl_SendCommand( srcEP, dstAddr, ZCL_CLUSTER_ID_SE_METERING,                        \
                   COMMAND_SE_METERING_REQ_MIRROR, TRUE, ZCL_FRAME_SERVER_CLIENT_DIR, \
                   disableDefaultRsp, 0, seqNum, 0, NULL );

/**************************************************************************************************
 * @fn      zclSE_MeteringSendRemoveMirror
 *
 * @brief   Send COMMAND_SE_METERING_REMOVE_MIRROR (send with no payload).
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
#define zclSE_MeteringSendRemoveMirror( srcEP, dstAddr, disableDefaultRsp, seqNum )      \
  zcl_SendCommand( srcEP, dstAddr, ZCL_CLUSTER_ID_SE_METERING,                           \
                   COMMAND_SE_METERING_REMOVE_MIRROR, TRUE, ZCL_FRAME_SERVER_CLIENT_DIR, \
                   disableDefaultRsp, 0, seqNum, 0, NULL );

/**************************************************************************************************
 * @fn      zclSE_MeteringSendReqFastPollModeRsp
 *
 * @brief   Send COMMAND_SE_METERING_REQ_FAST_POLL_MODE_RSP.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringSendReqFastPollModeRsp(
                   uint8_t srcEP, afAddrType_t *dstAddr,
                   zclSE_MeteringReqFastPollModeRsp_t *pCmd,
                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_MeteringSendScheduleSnapshotRsp
 *
 * @brief   Send COMMAND_SE_METERING_SCHEDULE_SNAPSHOT_RSP.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringSendScheduleSnapshotRsp(
                   uint8_t srcEP, afAddrType_t *dstAddr,
                   zclSE_MeteringScheduleSnapshotRsp_t *pCmd,
                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_MeteringSendTakeSnapshotRsp
 *
 * @brief   Send COMMAND_SE_METERING_TAKE_SNAPSHOT_RSP.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringSendTakeSnapshotRsp(
                   uint8_t srcEP, afAddrType_t *dstAddr,
                   zclSE_MeteringTakeSnapshotRsp_t *pCmd,
                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_MeteringSendPublishSnapshot
 *
 * @brief   Send COMMAND_SE_METERING_PUBLISH_SNAPSHOT.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringSendPublishSnapshot(
                   uint8_t srcEP, afAddrType_t *dstAddr,
                   zclSE_MeteringPublishSnapshot_t *pCmd,
                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_MeteringSendGetSampledDataRs
 *
 * @brief   Send COMMAND_SE_METERING_GET_SAMPLED_DATA_RSP.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringSendGetSampledDataRsp(
                   uint8_t srcEP, afAddrType_t *dstAddr,
                   zclSE_MeteringGetSampledDataRsp_t *pCmd,
                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_MeteringSendCfgMirror
 *
 * @brief   Send COMMAND_SE_METERING_CFG_MIRROR.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringSendCfgMirror( uint8_t srcEP, afAddrType_t *dstAddr,
                                              zclSE_MeteringCfgMirror_t *pCmd,
                                              uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_MeteringSendCfgNotifScheme
 *
 * @brief   Send COMMAND_SE_METERING_CFG_NOTIF_SCHEME.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringSendCfgNotifScheme( uint8_t srcEP, afAddrType_t *dstAddr,
                                                   zclSE_MeteringCfgNotifScheme_t *pCmd,
                                                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_MeteringSendCfgNotifFlag
 *
 * @brief   Send COMMAND_SE_METERING_CFG_NOTIF_FLAG.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringSendCfgNotifFlag( uint8_t srcEP, afAddrType_t *dstAddr,
                                                 zclSE_MeteringCfgNotifFlag_t *pCmd,
                                                 uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_MeteringSendGetNotifMsg
 *
 * @brief   Send COMMAND_SE_METERING_GET_NOTIF_MSG.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringSendGetNotifMsg( uint8_t srcEP, afAddrType_t *dstAddr,
                                                zclSE_MeteringGetNotifMsg_t *pCmd,
                                                uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_MeteringSendSupplyStatusRsp
 *
 * @brief   Send COMMAND_SE_METERING_SUPPLY_STATUS_RSP.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringSendSupplyStatusRsp(
                   uint8_t srcEP, afAddrType_t *dstAddr,
                   zclSE_MeteringSupplyStatusRsp_t *pCmd,
                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_MeteringSendStartSamplingRsp
 *
 * @brief   Send COMMAND_SE_METERING_START_SAMPLING_RSP.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringSendStartSamplingRsp(
                   uint8_t srcEP, afAddrType_t *dstAddr,
                   zclSE_MeteringStartSamplingRsp_t *pCmd,
                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_MeteringSendGetProfile
 *
 * @brief   Send COMMAND_SE_METERING_GET_PROFILE.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringSendGetProfile( uint8_t srcEP, afAddrType_t *dstAddr,
                                               zclSE_MeteringGetProfile_t *pCmd,
                                               uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_MeteringSendReqMirrorRsp
 *
 * @brief   Send COMMAND_SE_METERING_REQ_MIRROR_RSP.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringSendReqMirrorRsp( uint8_t srcEP, afAddrType_t *dstAddr,
                                                 zclSE_MeteringReqMirrorRsp_t *pCmd,
                                                 uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_MeteringSendMirrorRemoved
 *
 * @brief   Send COMMAND_SE_METERING_MIRROR_REMOVED.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringSendMirrorRemoved( uint8_t srcEP, afAddrType_t *dstAddr,
                                                  zclSE_MeteringMirrorRemoved_t *pCmd,
                                                  uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_MeteringSendReqFastPollMode
 *
 * @brief   Send COMMAND_SE_METERING_REQ_FAST_POLL_MODE.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringSendReqFastPollMode(
                   uint8_t srcEP, afAddrType_t *dstAddr,
                   zclSE_MeteringReqFastPollMode_t *pCmd,
                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_MeteringSendScheduleSnapshot
 *
 * @brief   Send COMMAND_SE_METERING_SCHEDULE_SNAPSHOT.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringSendScheduleSnapshot(
                   uint8_t srcEP, afAddrType_t *dstAddr,
                   zclSE_MeteringScheduleSnapshot_t *pCmd,
                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_MeteringSendTakeSnapshot
 *
 * @brief   Send COMMAND_SE_METERING_TAKE_SNAPSHOT.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringSendTakeSnapshot( uint8_t srcEP, afAddrType_t *dstAddr,
                                                 zclSE_MeteringTakeSnapshot_t *pCmd,
                                                 uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_MeteringSendGetSnapshot
 *
 * @brief   Send COMMAND_SE_METERING_GET_SNAPSHOT.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringSendGetSnapshot( uint8_t srcEP, afAddrType_t *dstAddr,
                                                zclSE_MeteringGetSnapshot_t *pCmd,
                                                uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_MeteringSendStartSampling
 *
 * @brief   Send COMMAND_SE_METERING_START_SAMPLING.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringSendStartSampling( uint8_t srcEP, afAddrType_t *dstAddr,
                                                  zclSE_MeteringStartSampling_t *pCmd,
                                                  uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_MeteringSendGetSampledData
 *
 * @brief   Send COMMAND_SE_METERING_GET_SAMPLED_DATA.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringSendGetSampledData( uint8_t srcEP, afAddrType_t *dstAddr,
                                                   zclSE_MeteringGetSampledData_t *pCmd,
                                                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_MeteringSendMirrorReportAttrRsp
 *
 * @brief   Send COMMAND_SE_METERING_MIRROR_REPORT_ATTR_RSP.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringSendMirrorReportAttrRsp(
                   uint8_t srcEP, afAddrType_t *dstAddr,
                   zclSE_MeteringMirrorReportAttrRsp_t *pCmd,
                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_MeteringSendResetLoadLimitCntr
 *
 * @brief   Send COMMAND_SE_METERING_RESET_LOAD_LIMIT_CNTR.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringSendResetLoadLimitCntr(
                   uint8_t srcEP, afAddrType_t *dstAddr,
                   zclSE_MeteringResetLoadLimitCntr_t *pCmd,
                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_MeteringSendChangeSupply
 *
 * @brief   Send COMMAND_SE_METERING_CHANGE_SUPPLY.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringSendChangeSupply( uint8_t srcEP, afAddrType_t *dstAddr,
                                                 zclSE_MeteringChangeSupply_t *pCmd,
                                                 uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_MeteringSendLocalChangeSupply
 *
 * @brief   Send COMMAND_SE_METERING_LOCAL_CHANGE_SUPPLY.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringSendLocalChangeSupply(
                   uint8_t srcEP, afAddrType_t *dstAddr,
                   zclSE_MeteringLocalChangeSupply_t *pCmd,
                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_MeteringSendSetSupplyStatus
 *
 * @brief   Send COMMAND_SE_METERING_SET_SUPPLY_STATUS.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringSendSetSupplyStatus(
                   uint8_t srcEP, afAddrType_t *dstAddr,
                   zclSE_MeteringSetSupplyStatus_t *pCmd,
                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_MeteringSendSetUnctrldFlowThreshold
 *
 * @brief   Send COMMAND_SE_METERING_SET_UNCTRLD_FLOW_THRESHOLD.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringSendSetUnctrldFlowThreshold(
                   uint8_t srcEP, afAddrType_t *dstAddr,
                   zclSE_MeteringSetUnctrldFlowThreshold_t *pCmd,
                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_MeteringParseGetProfileRsp
 *
 * @brief   Parse COMMAND_SE_METERING_GET_PROFILE_RSP.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringParseGetProfileRsp( zclIncoming_t *pInMsg,
                                                   zclSE_MeteringGetProfileRsp_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_MeteringParseReqFastPollModeRsp
 *
 * @brief   Parse COMMAND_SE_METERING_REQ_FAST_POLL_MODE_RSP.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringParseReqFastPollModeRsp(
                   zclIncoming_t *pInMsg,
                   zclSE_MeteringReqFastPollModeRsp_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_MeteringParseScheduleSnapshotRsp
 *
 * @brief   Parse COMMAND_SE_METERING_SCHEDULE_SNAPSHOT_RSP.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringParseScheduleSnapshotRsp(
                   zclIncoming_t *pInMsg,
                   zclSE_MeteringScheduleSnapshotRsp_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_MeteringParseTakeSnapshotRsp
 *
 * @brief   Parse COMMAND_SE_METERING_TAKE_SNAPSHOT_RSP.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringParseTakeSnapshotRsp(
                   zclIncoming_t *pInMsg,
                   zclSE_MeteringTakeSnapshotRsp_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_MeteringParsePublishSnapshot
 *
 * @brief   Parse COMMAND_SE_METERING_PUBLISH_SNAPSHOT.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringParsePublishSnapshot(
                   zclIncoming_t *pInMsg,
                   zclSE_MeteringPublishSnapshot_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_MeteringParseGetSampledDataRsp
 *
 * @brief   Parse COMMAND_SE_METERING_GET_SAMPLED_DATA_RSP.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringParseGetSampledDataRsp(
                   zclIncoming_t *pInMsg,
                   zclSE_MeteringGetSampledDataRsp_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_MeteringParseCfgMirror
 *
 * @brief   Parse COMMAND_SE_METERING_CFG_MIRROR.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringParseCfgMirror( zclIncoming_t *pInMsg,
                                               zclSE_MeteringCfgMirror_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_MeteringParseCfgNotifScheme
 *
 * @brief   Parse COMMAND_SE_METERING_CFG_NOTIF_SCHEME.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringParseCfgNotifScheme(
                   zclIncoming_t *pInMsg,
                   zclSE_MeteringCfgNotifScheme_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_MeteringParseCfgNotifFlag
 *
 * @brief   Parse COMMAND_SE_METERING_CFG_NOTIF_FLAG.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringParseCfgNotifFlag( zclIncoming_t *pInMsg,
                                                  zclSE_MeteringCfgNotifFlag_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_MeteringParseGetNotifMsg
 *
 * @brief   Parse COMMAND_SE_METERING_GET_NOTIF_MSG.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringParseGetNotifMsg( zclIncoming_t *pInMsg,
                                                 zclSE_MeteringGetNotifMsg_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_MeteringParseSupplyStatusRsp
 *
 * @brief   Parse COMMAND_SE_METERING_SUPPLY_STATUS_RSP
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringParseSupplyStatusRsp(
                   zclIncoming_t *pInMsg,
                   zclSE_MeteringSupplyStatusRsp_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_MeteringParseStartSamplingRsp
 *
 * @brief   Parse COMMAND_SE_METERING_START_SAMPLING_RSP.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringParseStartSamplingRsp(
                   zclIncoming_t *pInMsg,
                   zclSE_MeteringStartSamplingRsp_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_MeteringParseGetProfile
 *
 * @brief   Parse COMMAND_SE_METERING_GET_PROFILE.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringParseGetProfile( zclIncoming_t *pInMsg,
                                                zclSE_MeteringGetProfile_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_MeteringParseReqMirrorRsp
 *
 * @brief   Parse COMMAND_SE_METERING_REQ_MIRROR_RSP.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringParseReqMirrorRsp( zclIncoming_t *pInMsg,
                                                  zclSE_MeteringReqMirrorRsp_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_MeteringParseMirrorRemoved
 *
 * @brief   Parse COMMAND_SE_METERING_MIRROR_REMOVED.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringParseMirrorRemoved( zclIncoming_t *pInMsg,
                                                   zclSE_MeteringMirrorRemoved_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_MeteringParseReqFastPollMode
 *
 * @brief   Parse COMMAND_SE_METERING_REQ_FAST_POLL_MODE.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringParseReqFastPollMode(
                   zclIncoming_t *pInMsg,
                   zclSE_MeteringReqFastPollMode_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_MeteringParseScheduleSnapshot
 *
 * @brief   Parse COMMAND_SE_METERING_SCHEDULE_SNAPSHOT.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringParseScheduleSnapshot(
                   zclIncoming_t *pInMsg,
                   zclSE_MeteringScheduleSnapshot_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_MeteringParseTakeSnapshot
 *
 * @brief   Parse COMMAND_SE_METERING_TAKE_SNAPSHOT.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringParseTakeSnapshot( zclIncoming_t *pInMsg,
                                                  zclSE_MeteringTakeSnapshot_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_MeteringParseGetSnapshot
 *
 * @brief   Parse COMMAND_SE_METERING_GET_SNAPSHOT.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringParseGetSnapshot( zclIncoming_t *pInMsg,
                                                 zclSE_MeteringGetSnapshot_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_MeteringParseStartSampling
 *
 * @brief   Parse COMMAND_SE_METERING_START_SAMPLING.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringParseStartSampling( zclIncoming_t *pInMsg,
                                                   zclSE_MeteringStartSampling_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_MeteringParseGetSampledData
 *
 * @brief   Parse COMMAND_SE_METERING_GET_SAMPLED_DATA.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringParseGetSampledData(
                   zclIncoming_t *pInMsg,
                   zclSE_MeteringGetSampledData_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_MeteringParseMirrorReportAttrRsp
 *
 * @brief   Parse COMMAND_SE_METERING_MIRROR_REPORT_ATTR_RSP.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringParseMirrorReportAttrRsp(
                   zclIncoming_t *pInMsg,
                   zclSE_MeteringMirrorReportAttrRsp_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_MeteringParseResetLoadLimitCntr
 *
 * @brief   Parse COMMAND_SE_METERING_RESET_LOAD_LIMIT_CNTR.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringParseResetLoadLimitCntr(
                   zclIncoming_t *pInMsg,
                   zclSE_MeteringResetLoadLimitCntr_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_MeteringParseChangeSupply
 *
 * @brief   Parse COMMAND_SE_METERING_CHANGE_SUPPLY.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringParseChangeSupply( zclIncoming_t *pInMsg,
                                                  zclSE_MeteringChangeSupply_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_MeteringParseLocalChangeSupply
 *
 * @brief   Parse COMMAND_SE_METERING_LOCAL_CHANGE_SUPPLY.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringParseLocalChangeSupply(
                   zclIncoming_t *pInMsg,
                   zclSE_MeteringLocalChangeSupply_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_MeteringParseSetSupplyStatus
 *
 * @brief   Parse COMMAND_SE_METERING_SET_SUPPLY_STATUS.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringParseSetSupplyStatus(
                   zclIncoming_t *pInMsg,
                   zclSE_MeteringSetSupplyStatus_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_MeteringParseSetUnctrldFlowThreshold
 *
 * @brief   Parse COMMAND_SE_METERING_SET_UNCTRLD_FLOW_THRESHOLD.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringParseSetUnctrldFlowThreshold(
                   zclIncoming_t *pInMsg,
                   zclSE_MeteringSetUnctrldFlowThreshold_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_MeteringHdlGetProfileRsp
 *
 * @brief   Handle COMMAND_SE_METERING_GET_PROFILE_RSP.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringHdlGetProfileRsp( zclIncoming_t *pInMsg,
                                                 zclSE_MeteringGetProfileRspCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_MeteringHdlReqMirror
 *
 * @brief   Handle COMMAND_SE_METERING_REQ_MIRROR (handle with no payload).
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringHdlReqMirror( zclIncoming_t *pInMsg,
                                             zclSE_MeteringReqMirrorCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_MeteringHdlRemoveMirror
 *
 * @brief   Handle COMMAND_SE_METERING_REMOVE_MIRROR (handle with no payload).
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringHdlRemoveMirror( zclIncoming_t *pInMsg,
                                                zclSE_MeteringRemoveMirrorCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_MeteringHdlReqFastPollModeRsp
 *
 * @brief   Handle COMMAND_SE_METERING_REQ_FAST_POLL_MODE_RSP.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringHdlReqFastPollModeRsp
                   ( zclIncoming_t *pInMsg,
                     zclSE_MeteringReqFastPollModeRspCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_MeteringHdlScheduleSnapshotRsp
 *
 * @brief   Handle COMMAND_SE_METERING_SCHEDULE_SNAPSHOT_RSP.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringHdlScheduleSnapshotRsp
                   ( zclIncoming_t *pInMsg,
                     zclSE_MeteringScheduleSnapshotRspCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_MeteringHdlTakeSnapshotRsp
 *
 * @brief   Handle COMMAND_SE_METERING_TAKE_SNAPSHOT_RSP.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringHdlTakeSnapshotRsp( zclIncoming_t *pInMsg,
                                                   zclSE_MeteringTakeSnapshotRspCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_MeteringHdlPublishSnapshot
 *
 * @brief   Handle COMMAND_SE_METERING_PUBLISH_SNAPSHOT.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringHdlPublishSnapshot( zclIncoming_t *pInMsg,
                                                   zclSE_MeteringPublishSnapshotCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_MeteringHdlGetSampledDataRsp
 *
 * @brief   Handle COMMAND_SE_METERING_GET_SAMPLED_DATA_RSP.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringHdlGetSampledDataRsp
                   ( zclIncoming_t *pInMsg,
                     zclSE_MeteringGetSampledDataRspCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_MeteringHdlCfgMirror
 *
 * @brief   Handle COMMAND_SE_METERING_CFG_MIRROR.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringHdlCfgMirror( zclIncoming_t *pInMsg,
                                             zclSE_MeteringCfgMirrorCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_MeteringHdlCfgNotifScheme
 *
 * @brief   Handle COMMAND_SE_METERING_CFG_NOTIF_SCHEME.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringHdlCfgNotifScheme( zclIncoming_t *pInMsg,
                                                  zclSE_MeteringCfgNotifSchemeCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_MeteringHdlCfgNotifFlag
 *
 * @brief   Handle COMMAND_SE_METERING_CFG_NOTIF_FLAG.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringHdlCfgNotifFlag( zclIncoming_t *pInMsg,
                                                zclSE_MeteringCfgNotifFlagCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_MeteringHdlGetNotifMsg
 *
 * @brief   Handle COMMAND_SE_METERING_GET_NOTIF_MSG.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringHdlGetNotifMsg( zclIncoming_t *pInMsg,
                                               zclSE_MeteringGetNotifMsgCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_MeteringHdlSupplyStatusRsp
 *
 * @brief   Handle COMMAND_SE_METERING_SUPPLY_STATUS_RSP.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringHdlSupplyStatusRsp( zclIncoming_t *pInMsg,
                                                   zclSE_MeteringSupplyStatusRspCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_MeteringHdlStartSamplingRsp
 *
 * @brief   Handle COMMAND_SE_METERING_START_SAMPLING_RSP.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringHdlStartSamplingRsp(
                   zclIncoming_t *pInMsg,
                   zclSE_MeteringStartSamplingRspCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_MeteringHdlGetProfile
 *
 * @brief   Handle COMMAND_SE_METERING_GET_PROFILE.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringHdlGetProfile( zclIncoming_t *pInMsg,
                                              zclSE_MeteringGetProfileCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_MeteringHdlReqMirrorRsp
 *
 * @brief   Handle COMMAND_SE_METERING_REQ_MIRROR_RSP.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringHdlReqMirrorRsp( zclIncoming_t *pInMsg,
                                                zclSE_MeteringReqMirrorRspCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_MeteringHdlMirrorRemoved
 *
 * @brief   Handle COMMAND_SE_METERING_MIRROR_REMOVED.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringHdlMirrorRemoved( zclIncoming_t *pInMsg,
                                                 zclSE_MeteringMirrorRemovedCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_MeteringHdlReqFastPollMode
 *
 * @brief   Handle COMMAND_SE_METERING_REQ_FAST_POLL_MODE.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringHdlReqFastPollMode( zclIncoming_t *pInMsg,
                                                   zclSE_MeteringReqFastPollModeCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_MeteringHdlScheduleSnapshot
 *
 * @brief   Handle COMMAND_SE_METERING_SCHEDULE_SNAPSHOT.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringHdlScheduleSnapshot
                   ( zclIncoming_t *pInMsg,
                     zclSE_MeteringScheduleSnapshotCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_MeteringHdlTakeSnapshot
 *
 * @brief   Handle COMMAND_SE_METERING_TAKE_SNAPSHOT.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringHdlTakeSnapshot( zclIncoming_t *pInMsg,
                                                zclSE_MeteringTakeSnapshotCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_MeteringHdlGetSnapshot
 *
 * @brief   Handle COMMAND_SE_METERING_GET_SNAPSHOT.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringHdlGetSnapshot( zclIncoming_t *pInMsg,
                                               zclSE_MeteringGetSnapshotCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_MeteringHdlStartSampling
 *
 * @brief   Handle COMMAND_SE_METERING_START_SAMPLING.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringHdlStartSampling( zclIncoming_t *pInMsg,
                                                 zclSE_MeteringStartSamplingCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_MeteringHdlGetSampledData
 *
 * @brief   Handle COMMAND_SE_METERING_GET_SAMPLED_DATA.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringHdlGetSampledData( zclIncoming_t *pInMsg,
                                                  zclSE_MeteringGetSampledDataCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_MeteringHdlMirrorReportAttrRsp
 *
 * @brief   Handle COMMAND_SE_METERING_MIRROR_REPORT_ATTR_RSP.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringHdlMirrorReportAttrRsp
                   ( zclIncoming_t *pInMsg,
                     zclSE_MeteringMirrorReportAttrRspCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_MeteringHdlResetLoadLimitCntr
 *
 * @brief   Handle COMMAND_SE_METERING_RESET_LOAD_LIMIT_CNTR.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringHdlResetLoadLimitCntr
                   ( zclIncoming_t *pInMsg,
                     zclSE_MeteringResetLoadLimitCntrCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_MeteringHdlChangeSupply
 *
 * @brief   Handle COMMAND_SE_METERING_CHANGE_SUPPLY.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringHdlChangeSupply( zclIncoming_t *pInMsg,
                                                zclSE_MeteringChangeSupplyCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_MeteringHdlLocalChangeSupply
 *
 * @brief   Handle COMMAND_SE_METERING_LOCAL_CHANGE_SUPPLY.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringHdlLocalChangeSupply(
                   zclIncoming_t *pInMsg,
                   zclSE_MeteringLocalChangeSupplyCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_MeteringHdlSetSupplyStatus
 *
 * @brief   Handle COMMAND_SE_METERING_SET_SUPPLY_STATUS.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringHdlSetSupplyStatus( zclIncoming_t *pInMsg,
                                                   zclSE_MeteringSetSupplyStatusCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_MeteringHdlSetUnctrldFlowThreshold
 *
 * @brief   Handle COMMAND_SE_METERING_SET_UNCTRLD_FLOW_THRESHOLD.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringHdlSetUnctrldFlowThreshold(
                   zclIncoming_t *pInMsg,
                   zclSE_MeteringSetUnctrldFlowThresholdCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_MeteringHdlClientCmd
 *
 * @brief   Client command handler for ZCL_CLUSTER_ID_SE_METERING.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCBs - client callbacks
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringHdlClientCmd( zclIncoming_t *pInMsg,
                                             const zclSE_MeteringClientCBs_t *pCBs );

/**************************************************************************************************
 * @fn      zclSE_MeteringHdlServerCmd
 *
 * @brief   Server command handler for ZCL_CLUSTER_ID_SE_METERING.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCBs - server callbacks
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringHdlServerCmd( zclIncoming_t *pInMsg,
                                             const zclSE_MeteringServerCBs_t *pCBs );

/**************************************************************************************************
 * @fn      zclSE_MeteringSP_Parse
 *
 * @brief   Utility function for parsing a snapshot payload (SP - SNAPSHOT PAYLOAD) -- see
 *          "zclSE_MeteringPublishSnapshot_t".
 *
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringSP_Parse( zclSE_MeteringPublishSnapshot_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_MeteringSnapshotScheduleParse
 *
 * @brief   Utility function for parsing a raw snapshot schedule command -- see
 *          "zclSE_MeteringScheduleSnapshot_t".
 *
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MeteringSnapshotScheduleParse(
                   zclSE_MeteringScheduleSnapshot_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_PriceSendPublishPrice
 *
 * @brief   Send COMMAND_SE_PRICE_PUBLISH_PRICE.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceSendPublishPrice( uint8_t srcEP, afAddrType_t *dstAddr,
                                              zclSE_PricePublishPrice_t *pCmd,
                                              uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_PriceSendPublishBlockPeriod
 *
 * @brief   Send COMMAND_SE_PRICE_PUBLISH_BLOCK_PERIOD.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceSendPublishBlockPeriod(
                   uint8_t srcEP, afAddrType_t *dstAddr,
                   zclSE_PricePublishBlockPeriod_t *pCmd,
                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_PriceSendPublishConversionFactor
 *
 * @brief   Send COMMAND_SE_PRICE_PUBLISH_CONVERSION_FACTOR.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceSendPublishConversionFactor(
                   uint8_t srcEP, afAddrType_t *dstAddr,
                   zclSE_PricePublishConversionFactor_t *pCmd,
                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_PriceSendPublishCalorificValue
 *
 * @brief   Send COMMAND_SE_PRICE_PUBLISH_CALORIFIC_VALUE.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceSendPublishCalorificValue(
                   uint8_t srcEP, afAddrType_t *dstAddr,
                   zclSE_PricePublishCalorificValue_t *pCmd,
                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_PriceSendPublishTariffInfo
 *
 * @brief   Send COMMAND_SE_PRICE_PUBLISH_TARIFF_INFO.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceSendPublishTariffInfo( uint8_t srcEP, afAddrType_t *dstAddr,
                                                   zclSE_PricePublishTariffInfo_t *pCmd,
                                                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_PriceSendPublishPriceMatrix
 *
 * @brief   Send COMMAND_SE_PRICE_PUBLISH_PRICE_MATRIX.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceSendPublishPriceMatrix(
                   uint8_t srcEP, afAddrType_t *dstAddr,
                   zclSE_PricePublishPriceMatrix_t *pCmd,
                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_PriceSendPublishBlockThreshold
 *
 * @brief   Send COMMAND_SE_PRICE_PUBLISH_BLOCK_THRESHOLD.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceSendPublishBlockThreshold(
                   uint8_t srcEP, afAddrType_t *dstAddr,
                   zclSE_PricePublishBlockThreshold_t *pCmd,
                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_PriceSendPublishCO2Value
 *
 * @brief   Send COMMAND_SE_PRICE_PUBLISH_CO2_VALUE.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceSendPublishCO2Value( uint8_t srcEP, afAddrType_t *dstAddr,
                                                 zclSE_PricePublishCO2Value_t *pCmd,
                                                 uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_PriceSendPublishTierLabels
 *
 * @brief   Send COMMAND_SE_PRICE_PUBLISH_TIER_LABELS.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceSendPublishTierLabels( uint8_t srcEP, afAddrType_t *dstAddr,
                                                   zclSE_PricePublishTierLabels_t *pCmd,
                                                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_PriceSendPublishBillPeriod
 *
 * @brief   Send COMMAND_SE_PRICE_PUBLISH_BILL_PERIOD.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceSendPublishBillPeriod( uint8_t srcEP, afAddrType_t *dstAddr,
                                                   zclSE_PricePublishBillPeriod_t *pCmd,
                                                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_PriceSendPublishConsolidatedBill
 *
 * @brief   Send COMMAND_SE_PRICE_PUBLISH_CONSOLIDATED_BILL.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceSendPublishConsolidatedBill(
                   uint8_t srcEP, afAddrType_t *dstAddr,
                   zclSE_PricePublishConsolidatedBill_t *pCmd,
                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_PriceSendPublishCPPEvt
 *
 * @brief   Send COMMAND_SE_PRICE_PUBLISH_CPP_EVT.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceSendPublishCPPEvt( uint8_t srcEP, afAddrType_t *dstAddr,
                                               zclSE_PricePublishCPPEvt_t *pCmd,
                                               uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_PriceSendPublishCreditPayment
 *
 * @brief   Send COMMAND_SE_PRICE_PUBLISH_CREDIT_PAYMENT.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceSendPublishCreditPayment(
                   uint8_t srcEP, afAddrType_t *dstAddr,
                   zclSE_PricePublishCreditPayment_t *pCmd,
                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_PriceSendPublishCurrencyConversion
 *
 * @brief   Send COMMAND_SE_PRICE_PUBLISH_CURRENCY_CONVERSION.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceSendPublishCurrencyConversion(
                   uint8_t srcEP, afAddrType_t *dstAddr,
                   zclSE_PricePublishCurrencyConversion_t *pCmd,
                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_PriceSendCancelTariff
 *
 * @brief   Send COMMAND_SE_PRICE_CANCEL_TARIFF.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceSendCancelTariff( uint8_t srcEP, afAddrType_t *dstAddr,
                                              zclSE_PriceCancelTariff_t *pCmd,
                                              uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_PriceSendGetCurrPrice
 *
 * @brief   Send COMMAND_SE_PRICE_GET_CURR_PRICE.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceSendGetCurrPrice( uint8_t srcEP, afAddrType_t *dstAddr,
                                              zclSE_PriceGetCurrPrice_t *pCmd,
                                              uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_PriceSendGetScheduledPrice
 *
 * @brief   Send COMMAND_SE_PRICE_GET_SCHEDULED_PRICE.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceSendGetScheduledPrice( uint8_t srcEP, afAddrType_t *dstAddr,
                                                   zclSE_PriceGetScheduledPrice_t *pCmd,
                                                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_PriceSendPriceAck
 *
 * @brief   Send COMMAND_SE_PRICE_PRICE_ACK.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceSendPriceAck( uint8_t srcEP, afAddrType_t *dstAddr,
                                          zclSE_PricePriceAck_t *pCmd,
                                          uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_PriceSendGetBlockPeriod
 *
 * @brief   Send COMMAND_SE_PRICE_GET_BLOCK_PERIOD.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceSendGetBlockPeriod( uint8_t srcEP, afAddrType_t *dstAddr,
                                                zclSE_PriceGetBlockPeriod_t *pCmd,
                                                uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_PriceSendGetConversionFactor
 *
 * @brief   Send COMMAND_SE_PRICE_GET_CONVERSION_FACTOR.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceSendGetConversionFactor(
                   uint8_t srcEP, afAddrType_t *dstAddr,
                   zclSE_PriceGetConversionFactor_t *pCmd,
                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_PriceSendGetCalorificValue
 *
 * @brief   Send COMMAND_SE_PRICE_GET_CALORIFIC_VALUE.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceSendGetCalorificValue( uint8_t srcEP, afAddrType_t *dstAddr,
                                                   zclSE_PriceGetCalorificValue_t *pCmd,
                                                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_PriceSendGetTariffInfo
 *
 * @brief   Send COMMAND_SE_PRICE_GET_TARIFF_INFO.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceSendGetTariffInfo( uint8_t srcEP, afAddrType_t *dstAddr,
                                               zclSE_PriceGetTariffInfo_t *pCmd,
                                               uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_PriceSendGetPriceMatrix
 *
 * @brief   Send COMMAND_SE_PRICE_GET_PRICE_MATRIX.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceSendGetPriceMatrix( uint8_t srcEP, afAddrType_t *dstAddr,
                                                zclSE_PriceGetPriceMatrix_t *pCmd,
                                                uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_PriceSendGetBlockThresholds
 *
 * @brief   Send COMMAND_SE_PRICE_GET_BLOCK_THRESHOLDS.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceSendGetBlockThresholds(
                   uint8_t srcEP, afAddrType_t *dstAddr,
                   zclSE_PriceGetBlockThresholds_t *pCmd,
                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_PriceSendGetCO2Value
 *
 * @brief   Send COMMAND_SE_PRICE_GET_CO2_VALUE.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceSendGetCO2Value( uint8_t srcEP, afAddrType_t *dstAddr,
                                             zclSE_PriceGetCO2Value_t *pCmd,
                                             uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_PriceSendGetTierLabels
 *
 * @brief   Send COMMAND_SE_PRICE_GET_TIER_LABELS.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceSendGetTierLabels( uint8_t srcEP, afAddrType_t *dstAddr,
                                               zclSE_PriceGetTierLabels_t *pCmd,
                                               uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_PriceSendGetBillPeriod
 *
 * @brief   Send COMMAND_SE_PRICE_GET_BILL_PERIOD.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceSendGetBillPeriod( uint8_t srcEP, afAddrType_t *dstAddr,
                                               zclSE_PriceGetBillPeriod_t *pCmd,
                                               uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_PriceSendGetConsolidatedBill
 *
 * @brief   Send COMMAND_SE_PRICE_GET_CONSOLIDATED_BILL.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceSendGetConsolidatedBill(
                   uint8_t srcEP, afAddrType_t *dstAddr,
                   zclSE_PriceGetConsolidatedBill_t *pCmd,
                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_PriceSendCPPEvtRsp
 *
 * @brief   Send COMMAND_SE_PRICE_CPP_EVT_RSP.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceSendCPPEvtRsp( uint8_t srcEP, afAddrType_t *dstAddr,
                                           zclSE_PriceCPPEvtRsp_t *pCmd,
                                           uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_PriceSendGetCreditPayment
 *
 * @brief   Send COMMAND_SE_PRICE_GET_CREDIT_PAYMENT.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceSendGetCreditPayment( uint8_t srcEP, afAddrType_t *dstAddr,
                                                  zclSE_PriceGetCreditPayment_t *pCmd,
                                                  uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_PriceSendGetCurrencyConversion
 *
 * @brief   Send COMMAND_SE_PRICE_GET_CURRENCY_CONVERSION (send with no payload).
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
#define zclSE_PriceSendGetCurrencyConversion( srcEP, dstAddr, disableDefaultRsp, seqNum )        \
  zcl_SendCommand( srcEP, dstAddr, ZCL_CLUSTER_ID_SE_PRICE,                                      \
                   COMMAND_SE_PRICE_GET_CURRENCY_CONVERSION, TRUE, ZCL_FRAME_CLIENT_SERVER_DIR,  \
                   disableDefaultRsp, 0, seqNum, 0, NULL );

/**************************************************************************************************
 * @fn      zclSE_PriceSendGetTariffCancellation
 *
 * @brief   Send COMMAND_SE_PRICE_GET_TARIFF_CANCELLATION (send with no payload).
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
#define zclSE_PriceSendGetTariffCancellation( srcEP, dstAddr, disableDefaultRsp, seqNum )       \
  zcl_SendCommand( srcEP, dstAddr, ZCL_CLUSTER_ID_SE_PRICE,                                     \
                   COMMAND_SE_PRICE_GET_TARIFF_CANCELLATION, TRUE, ZCL_FRAME_CLIENT_SERVER_DIR, \
                   disableDefaultRsp, 0, seqNum, 0, NULL );

/**************************************************************************************************
 * @fn      zclSE_PriceParsePublishPrice
 *
 * @brief   Parse COMMAND_SE_PRICE_PUBLISH_PRICE.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceParsePublishPrice( zclIncoming_t *pInMsg,
                                               zclSE_PricePublishPrice_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_PriceParsePublishBlockPeriod
 *
 * @brief   Parse COMMAND_SE_PRICE_PUBLISH_BLOCK_PERIOD.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceParsePublishBlockPeriod(
                   zclIncoming_t *pInMsg,
                   zclSE_PricePublishBlockPeriod_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_PriceParsePublishConversionFactor
 *
 * @brief   Parse COMMAND_SE_PRICE_PUBLISH_CONVERSION_FACTOR.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceParsePublishConversionFactor(
                   zclIncoming_t *pInMsg,
                   zclSE_PricePublishConversionFactor_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_PriceParsePublishCalorificValue
 *
 * @brief   Parse COMMAND_SE_PRICE_PUBLISH_CALORIFIC_VALUE.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceParsePublishCalorificValue(
                   zclIncoming_t *pInMsg,
                   zclSE_PricePublishCalorificValue_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_PriceParsePublishTariffInfo
 *
 * @brief   Parse COMMAND_SE_PRICE_PUBLISH_TARIFF_INFO.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceParsePublishTariffInfo(
                   zclIncoming_t *pInMsg,
                   zclSE_PricePublishTariffInfo_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_PriceParsePublishPriceMatrix
 *
 * @brief   Parse COMMAND_SE_PRICE_PUBLISH_PRICE_MATRIX.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceParsePublishPriceMatrix(
                   zclIncoming_t *pInMsg,
                   zclSE_PricePublishPriceMatrix_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_PriceParsePublishBlockThreshold
 *
 * @brief   Parse COMMAND_SE_PRICE_PUBLISH_BLOCK_THRESHOLD.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceParsePublishBlockThreshold(
                   zclIncoming_t *pInMsg,
                   zclSE_PricePublishBlockThreshold_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_PriceParsePublishCO2Value
 *
 * @brief   Parse COMMAND_SE_PRICE_PUBLISH_CO2_VALUE
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceParsePublishCO2Value( zclIncoming_t *pInMsg,
                                                  zclSE_PricePublishCO2Value_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_PriceParsePublishTierLabels
 *
 * @brief   Parse COMMAND_SE_PRICE_PUBLISH_TIER_LABELS.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceParsePublishTierLabels(
                   zclIncoming_t *pInMsg,
                   zclSE_PricePublishTierLabels_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_PriceParsePublishBillPeriod
 *
 * @brief   Parse COMMAND_SE_PRICE_PUBLISH_BILL_PERIOD.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceParsePublishBillPeriod(
                   zclIncoming_t *pInMsg,
                   zclSE_PricePublishBillPeriod_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_PriceParsePublishConsolidatedBill
 *
 * @brief   Parse COMMAND_SE_PRICE_PUBLISH_CONSOLIDATED_BILL.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceParsePublishConsolidatedBill(
                   zclIncoming_t *pInMsg,
                   zclSE_PricePublishConsolidatedBill_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_PriceParsePublishCPPEvt
 *
 * @brief   Parse COMMAND_SE_PRICE_PUBLISH_CPP_EVT.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceParsePublishCPPEvt( zclIncoming_t *pInMsg,
                                                zclSE_PricePublishCPPEvt_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_PriceParsePublishCreditPayment
 *
 * @brief   Parse COMMAND_SE_PRICE_PUBLISH_CREDIT_PAYMENT.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceParsePublishCreditPayment(
                   zclIncoming_t *pInMsg,
                   zclSE_PricePublishCreditPayment_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_PriceParsePublishCurrencyConversion
 *
 * @brief   Parse COMMAND_SE_PRICE_PUBLISH_CURRENCY_CONVERSION.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceParsePublishCurrencyConversion(
                   zclIncoming_t *pInMsg,
                   zclSE_PricePublishCurrencyConversion_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_PriceParseCancelTariff
 *
 * @brief   Parse COMMAND_SE_PRICE_CANCEL_TARIFF.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceParseCancelTariff( zclIncoming_t *pInMsg,
                                               zclSE_PriceCancelTariff_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_PriceParseGetCurrPrice
 *
 * @brief   Parse COMMAND_SE_PRICE_GET_CURR_PRICE.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceParseGetCurrPrice( zclIncoming_t *pInMsg,
                                               zclSE_PriceGetCurrPrice_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_PriceParseGetScheduledPrice
 *
 * @brief   Parse COMMAND_SE_PRICE_GET_SCHEDULED_PRICE.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceParseGetScheduledPrice(
                   zclIncoming_t *pInMsg,
                   zclSE_PriceGetScheduledPrice_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_PriceParsePriceAck
 *
 * @brief   Parse COMMAND_SE_PRICE_PRICE_ACK.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceParsePriceAck( zclIncoming_t *pInMsg,
                                           zclSE_PricePriceAck_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_PriceParseGetBlockPeriod
 *
 * @brief   Parse COMMAND_SE_PRICE_GET_BLOCK_PERIOD.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceParseGetBlockPeriod( zclIncoming_t *pInMsg,
                                                 zclSE_PriceGetBlockPeriod_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_PriceParseGetConversionFactor
 *
 * @brief   Parse COMMAND_SE_PRICE_GET_CONVERSION_FACTOR.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceParseGetConversionFactor(
                   zclIncoming_t *pInMsg,
                   zclSE_PriceGetConversionFactor_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_PriceParseGetCalorificValue
 *
 * @brief   Parse COMMAND_SE_PRICE_GET_CALORIFIC_VALUE.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceParseGetCalorificValue(
                   zclIncoming_t *pInMsg,
                   zclSE_PriceGetCalorificValue_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_PriceParseGetTariffInfo
 *
 * @brief   Parse COMMAND_SE_PRICE_GET_TARIFF_INFO.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceParseGetTariffInfo( zclIncoming_t *pInMsg,
                                                zclSE_PriceGetTariffInfo_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_PriceParseGetPriceMatrix
 *
 * @brief   Parse COMMAND_SE_PRICE_GET_PRICE_MATRIX.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceParseGetPriceMatrix( zclIncoming_t *pInMsg,
                                                 zclSE_PriceGetPriceMatrix_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_PriceParseGetBlockThresholds
 *
 * @brief   Parse COMMAND_SE_PRICE_GET_BLOCK_THRESHOLDS.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceParseGetBlockThresholds(
                   zclIncoming_t *pInMsg,
                   zclSE_PriceGetBlockThresholds_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_PriceParseGetCO2Value
 *
 * @brief   Parse COMMAND_SE_PRICE_GET_CO2_VALUE.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceParseGetCO2Value( zclIncoming_t *pInMsg,
                                              zclSE_PriceGetCO2Value_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_PriceParseGetTierLabels
 *
 * @brief   Parse COMMAND_SE_PRICE_GET_TIER_LABELS.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceParseGetTierLabels( zclIncoming_t *pInMsg,
                                                zclSE_PriceGetTierLabels_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_PriceParseGetBillPeriod
 *
 * @brief   Parse COMMAND_SE_PRICE_GET_BILL_PERIOD.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceParseGetBillPeriod( zclIncoming_t *pInMsg,
                                                zclSE_PriceGetBillPeriod_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_PriceParseGetConsolidatedBill
 *
 * @brief   Parse COMMAND_SE_PRICE_GET_CONSOLIDATED_BILL.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceParseGetConsolidatedBill(
                   zclIncoming_t *pInMsg,
                   zclSE_PriceGetConsolidatedBill_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_PriceParseCPPEvtRsp
 *
 * @brief   Parse COMMAND_SE_PRICE_CPP_EVT_RSP.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceParseCPPEvtRsp( zclIncoming_t *pInMsg,
                                            zclSE_PriceCPPEvtRsp_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_PriceParseGetCreditPayment
 *
 * @brief   Parse COMMAND_SE_PRICE_GET_CREDIT_PAYMENT.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceParseGetCreditPayment( zclIncoming_t *pInMsg,
                                                   zclSE_PriceGetCreditPayment_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_PriceHdlPublishPrice
 *
 * @brief   Handle COMMAND_SE_PRICE_PUBLISH_PRICE.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceHdlPublishPrice( zclIncoming_t *pInMsg,
                                             zclSE_PricePublishPriceCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_PriceHdlPublishBlockPeriod
 *
 * @brief   Handle COMMAND_SE_PRICE_PUBLISH_BLOCK_PERIOD.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceHdlPublishBlockPeriod( zclIncoming_t *pInMsg,
                                                   zclSE_PricePublishBlockPeriodCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_PriceHdlPublishConversionFactor
 *
 * @brief   Handle COMMAND_SE_PRICE_PUBLISH_CONVERSION_FACTOR.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceHdlPublishConversionFactor(
                   zclIncoming_t *pInMsg,
                   zclSE_PricePublishConversionFactorCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_PriceHdlPublishCalorificValue
 *
 * @brief   Handle COMMAND_SE_PRICE_PUBLISH_CALORIFIC_VALUE.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceHdlPublishCalorificValue(
                   zclIncoming_t *pInMsg,
                   zclSE_PricePublishCalorificValueCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_PriceHdlPublishTariffInfo
 *
 * @brief   Handle COMMAND_SE_PRICE_PUBLISH_TARIFF_INFO.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceHdlPublishTariffInfo( zclIncoming_t *pInMsg,
                                                  zclSE_PricePublishTariffInfoCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_PriceHdlPublishPriceMatrix
 *
 * @brief   Handle COMMAND_SE_PRICE_PUBLISH_PRICE_MATRIX.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceHdlPublishPriceMatrix( zclIncoming_t *pInMsg,
                                                   zclSE_PricePublishPriceMatrixCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_PriceHdlPublishBlockThreshold
 *
 * @brief   Handle COMMAND_SE_PRICE_PUBLISH_BLOCK_THRESHOLD.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceHdlPublishBlockThreshold(
                   zclIncoming_t *pInMsg,
                   zclSE_PricePublishBlockThresholdCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_PriceHdlPublishCO2Value
 *
 * @brief   Handle COMMAND_SE_PRICE_PUBLISH_CO2_VALUE.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceHdlPublishCO2Value( zclIncoming_t *pInMsg,
                                                zclSE_PricePublishCO2ValueCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_PriceHdlPublishTierLabels
 *
 * @brief   Handle COMMAND_SE_PRICE_PUBLISH_TIER_LABELS.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceHdlPublishTierLabels( zclIncoming_t *pInMsg,
                                                  zclSE_PricePublishTierLabelsCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_PriceHdlPublishBillPeriod
 *
 * @brief   Handle COMMAND_SE_PRICE_PUBLISH_BILL_PERIOD.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceHdlPublishBillPeriod(
                   zclIncoming_t *pInMsg,
                   zclSE_PricePublishBillPeriodCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_PriceHdlPublishConsolidatedBill
 *
 * @brief   Handle COMMAND_SE_PRICE_PUBLISH_CONSOLIDATED_BILL.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceHdlPublishConsolidatedBill(
                   zclIncoming_t *pInMsg,
                   zclSE_PricePublishConsolidatedBillCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_PriceHdlPublishCPPEvt
 *
 * @brief   Handle COMMAND_SE_PRICE_PUBLISH_CPP_EVT.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceHdlPublishCPPEvt( zclIncoming_t *pInMsg,
                                              zclSE_PricePublishCPPEvtCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_PriceHdlPublishCreditPayment
 *
 * @brief   Handle COMMAND_SE_PRICE_PUBLISH_CREDIT_PAYMENT.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceHdlPublishCreditPayment(
                   zclIncoming_t *pInMsg,
                   zclSE_PricePublishCreditPaymentCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_PriceHdlPublishCurrencyConversion
 *
 * @brief   Handle COMMAND_SE_PRICE_PUBLISH_CURRENCY_CONVERSION.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceHdlPublishCurrencyConversion(
                   zclIncoming_t *pInMsg,
                   zclSE_PricePublishCurrencyConversionCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_PriceHdlCancelTariff
 *
 * @brief   Handle COMMAND_SE_PRICE_CANCEL_TARIFF.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceHdlCancelTariff( zclIncoming_t *pInMsg,
                                             zclSE_PriceCancelTariffCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_PriceHdlGetCurrPrice
 *
 * @brief   Handle COMMAND_SE_PRICE_GET_CURR_PRICE.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceHdlGetCurrPrice( zclIncoming_t *pInMsg,
                                             zclSE_PriceGetCurrPriceCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_PriceHdlGetScheduledPrice
 *
 * @brief   Handle COMMAND_SE_PRICE_GET_SCHEDULED_PRICE.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceHdlGetScheduledPrice( zclIncoming_t *pInMsg,
                                                  zclSE_PriceGetScheduledPriceCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_PriceHdlPriceAck
 *
 * @brief   Handle COMMAND_SE_PRICE_PRICE_ACK.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceHdlPriceAck( zclIncoming_t *pInMsg,
                                         zclSE_PricePriceAckCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_PriceHdlGetBlockPeriod
 *
 * @brief   Handle COMMAND_SE_PRICE_GET_BLOCK_PERIOD.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceHdlGetBlockPeriod( zclIncoming_t *pInMsg,
                                               zclSE_PriceGetBlockPeriodCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_PriceHdlGetConversionFactor
 *
 * @brief   Handle COMMAND_SE_PRICE_GET_CONVERSION_FACTOR.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceHdlGetConversionFactor(
                   zclIncoming_t *pInMsg,
                   zclSE_PriceGetConversionFactorCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_PriceHdlGetCalorificValue
 *
 * @brief   Handle COMMAND_SE_PRICE_GET_CALORIFIC_VALUE.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceHdlGetCalorificValue( zclIncoming_t *pInMsg,
                                                  zclSE_PriceGetCalorificValueCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_PriceHdlGetTariffInfo
 *
 * @brief   Handle COMMAND_SE_PRICE_GET_TARIFF_INFO.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceHdlGetTariffInfo( zclIncoming_t *pInMsg,
                                              zclSE_PriceGetTariffInfoCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_PriceHdlGetPriceMatrix
 *
 * @brief   Handle COMMAND_SE_PRICE_GET_PRICE_MATRIX.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceHdlGetPriceMatrix( zclIncoming_t *pInMsg,
                                               zclSE_PriceGetPriceMatrixCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_PriceHdlGetBlockThresholds
 *
 * @brief   Handle COMMAND_SE_PRICE_GET_BLOCK_THRESHOLDS.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceHdlGetBlockThresholds( zclIncoming_t *pInMsg,
                                                   zclSE_PriceGetBlockThresholdsCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_PriceHdlGetCO2Value
 *
 * @brief   Handle COMMAND_SE_PRICE_GET_CO2_VALUE.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceHdlGetCO2Value( zclIncoming_t *pInMsg,
                                            zclSE_PriceGetCO2ValueCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_PriceHdlGetTierLabels
 *
 * @brief   Handle COMMAND_SE_PRICE_GET_TIER_LABELS.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceHdlGetTierLabels( zclIncoming_t *pInMsg,
                                              zclSE_PriceGetTierLabelsCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_PriceHdlGetBillPeriod
 *
 * @brief   Handle COMMAND_SE_PRICE_GET_BILL_PERIOD.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceHdlGetBillPeriod( zclIncoming_t *pInMsg,
                                              zclSE_PriceGetBillPeriodCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_PriceHdlGetConsolidatedBill
 *
 * @brief   Handle COMMAND_SE_PRICE_GET_CONSOLIDATED_BILL.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceHdlGetConsolidatedBill(
                   zclIncoming_t *pInMsg,
                   zclSE_PriceGetConsolidatedBillCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_PriceHdlCPPEvtRsp
 *
 * @brief   Handle COMMAND_SE_PRICE_CPP_EVT_RSP.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceHdlCPPEvtRsp( zclIncoming_t *pInMsg,
                                          zclSE_PriceCPPEvtRspCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_PriceHdlGetCreditPayment
 *
 * @brief   Handle COMMAND_SE_PRICE_GET_CREDIT_PAYMENT.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceHdlGetCreditPayment( zclIncoming_t *pInMsg,
                                                 zclSE_PriceGetCreditPaymentCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_PriceHdlGetCurrencyConversion
 *
 * @brief   Handle COMMAND_SE_PRICE_GET_CURRENCY_CONVERSION (handle with no payload).
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceHdlGetCurrencyConversion(
                   zclIncoming_t *pInMsg,
                   zclSE_PriceGetCurrencyConversionCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_PriceHdlGetTariffCancellation
 *
 * @brief   Handle COMMAND_SE_PRICE_GET_TARIFF_CANCELLATION (handle with no payload).
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceHdlGetTariffCancellation(
                   zclIncoming_t *pInMsg,
                   zclSE_PriceGetTariffCancellationCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_PriceHdlClientCmd
 *
 * @brief   Client command handler for ZCL_CLUSTER_ID_SE_PRICE.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCBs - client callbacks
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceHdlClientCmd( zclIncoming_t *pInMsg,
                                          const zclSE_PriceClientCBs_t *pCBs );

/**************************************************************************************************
 * @fn      zclSE_PriceHdlServerCmd
 *
 * @brief   Server command handler for ZCL_CLUSTER_ID_SE_PRICE.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCBs - server callbacks
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceHdlServerCmd( zclIncoming_t *pInMsg,
                                          const zclSE_PriceServerCBs_t *pCBs );

/**************************************************************************************************
 * @fn      zclSE_PriceMatrixSubFldParse
 *
 * @brief   Utility function for parsing "pSubFlds" payload -- see
 *          "zclSE_PricePublishPriceMatrix_t"
 *
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceMatrixSubFldParse( zclSE_PricePublishPriceMatrix_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_PriceBlockThresholdSubFldParse
 *
 * @brief   Utility function for parsing "pSubFlds" payload -- see
 *          "zclSE_PricePublishBlockThreshold_t"
 *
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceBlockThresholdSubFldParse(
                   zclSE_PricePublishBlockThreshold_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_PriceTierLabelParse
 *
 * @brief   Utility function for parsing "pTierLabels" payload -- see
 *          "zclSE_PricePublishTierLabels_t"
 *
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PriceTierLabelParse( zclSE_PricePublishTierLabels_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_MessagingSendDisplayMsg
 *
 * @brief   Send COMMAND_SE_MESSAGING_DISPLAY_MSG.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MessagingSendDisplayMsg( uint8_t srcEP, afAddrType_t *dstAddr,
                                                zclSE_MessagingDisplayMsg_t *pCmd,
                                                uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_MessagingSendCancelMsg
 *
 * @brief   Send COMMAND_SE_MESSAGING_CANCEL_MSG.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MessagingSendCancelMsg( uint8_t srcEP, afAddrType_t *dstAddr,
                                               zclSE_MessagingCancelMsg_t *pCmd,
                                               uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_MessagingSendDisplayProtectedMsg
 *
 * @brief   Send COMMAND_SE_MESSAGING_DISPLAY_PROTECTED_MSG.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MessagingSendDisplayProtectedMsg(
                   uint8_t srcEP, afAddrType_t *dstAddr,
                   zclSE_MessagingDisplayMsg_t *pCmd,
                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_MessagingSendCancelAllMsgs
 *
 * @brief   Send COMMAND_SE_MESSAGING_CANCEL_ALL_MSGS.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MessagingSendCancelAllMsgs( uint8_t srcEP, afAddrType_t *dstAddr,
                                                   zclSE_MessagingCancelAllMsgs_t *pCmd,
                                                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_MessagingSendGetLastMsg
 *
 * @brief   Send COMMAND_SE_MESSAGING_GET_LAST_MSG (send with no payload).
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
#define zclSE_MessagingSendGetLastMsg(srcEP, dstAddr, disableDefaultRsp, seqNum)         \
  zcl_SendCommand( srcEP, dstAddr, ZCL_CLUSTER_ID_SE_MESSAGING,                          \
                   COMMAND_SE_MESSAGING_GET_LAST_MSG, TRUE, ZCL_FRAME_CLIENT_SERVER_DIR, \
                   disableDefaultRsp, 0, seqNum, 0, NULL );

/**************************************************************************************************
 * @fn      zclSE_MessagingSendMsgCfm
 *
 * @brief   Send COMMAND_SE_MESSAGING_MSG_CFM.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MessagingSendMsgCfm( uint8_t srcEP, afAddrType_t *dstAddr,
                                            zclSE_MessagingMsgCfm_t *pCmd,
                                            uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_MessagingSendGetMsgCancellation
 *
 * @brief   Send COMMAND_SE_MESSAGING_GET_MSG_CANCELLATION.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MessagingSendGetMsgCancellation(
                   uint8_t srcEP, afAddrType_t *dstAddr,
                   zclSE_MessagingGetMsgCancellation_t *pCmd,
                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_MessagingParseDisplayMsg
 *
 * @brief   Parse COMMAND_SE_MESSAGING_DISPLAY_MSG.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MessagingParseDisplayMsg( zclIncoming_t *pInMsg,
                                                 zclSE_MessagingDisplayMsg_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_MessagingParseCancelMsg
 *
 * @brief   Parse COMMAND_SE_MESSAGING_CANCEL_MSG.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MessagingParseCancelMsg( zclIncoming_t *pInMsg,
                                                zclSE_MessagingCancelMsg_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_MessagingParseDisplayProtectedMsg
 *
 * @brief   Parse COMMAND_SE_MESSAGING_DISPLAY_PROTECTED_MSG.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
#define zclSE_MessagingParseDisplayProtectedMsg  zclSE_MessagingParseDisplayMsg

/**************************************************************************************************
 * @fn      zclSE_MessagingParseCancelAllMsgs
 *
 * @brief   Parse COMMAND_SE_MESSAGING_CANCEL_ALL_MSGS.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MessagingParseCancelAllMsgs(
                   zclIncoming_t *pInMsg,
                   zclSE_MessagingCancelAllMsgs_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_MessagingParseMsgCfm
 *
 * @brief   Parse COMMAND_SE_MESSAGING_MSG_CFM.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MessagingParseMsgCfm( zclIncoming_t *pInMsg,
                                             zclSE_MessagingMsgCfm_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_MessagingParseGetMsgCancellation
 *
 * @brief   Parse COMMAND_SE_MESSAGING_GET_MSG_CANCELLATION.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MessagingParseGetMsgCancellation(
                   zclIncoming_t *pInMsg,
                   zclSE_MessagingGetMsgCancellation_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_MessagingHdlDisplayMsg
 *
 * @brief   Handle COMMAND_SE_MESSAGING_DISPLAY_MSG.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MessagingHdlDisplayMsg( zclIncoming_t *pInMsg,
                                               zclSE_MessagingDisplayMsgCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_MessagingHdlCancelMsg
 *
 * @brief   Handle COMMAND_SE_MESSAGING_CANCEL_MSG.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MessagingHdlCancelMsg( zclIncoming_t *pInMsg,
                                              zclSE_MessagingCancelMsgCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_MessagingHdlDisplayProtectedMsg
 *
 * @brief   Handle COMMAND_SE_MESSAGING_DISPLAY_PROTECTED_MSG.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MessagingHdlDisplayProtectedMsg(
                   zclIncoming_t *pInMsg,
                   zclSE_MessagingDisplayProtectedMsgCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_MessagingHdlCancelAllMsgs
 *
 * @brief   Handle COMMAND_SE_MESSAGING_CANCEL_ALL_MSGS.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MessagingHdlCancelAllMsgs( zclIncoming_t *pInMsg,
                                                  zclSE_MessagingCancelAllMsgsCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_MessagingHdlGetLastMsg
 *
 * @brief   Handle COMMAND_SE_MESSAGING_GET_LAST_MSG (handle with no payload).
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MessagingHdlGetLastMsg( zclIncoming_t *pInMsg,
                                               zclSE_MessagingGetLastMsgCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_MessagingHdlMsgCfm
 *
 * @brief   Handle COMMAND_SE_MESSAGING_MSG_CFM.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MessagingHdlMsgCfm( zclIncoming_t *pInMsg,
                                           zclSE_MessagingMsgCfmCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_MessagingHdlGetMsgCancellation
 *
 * @brief   Handle COMMAND_SE_MESSAGING_GET_MSG_CANCELLATION.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MessagingHdlGetMsgCancellation(
                   zclIncoming_t *pInMsg,
                   zclSE_MessagingGetMsgCancellationCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_MessagingHdlClientCmd
 *
 * @brief   Client command handler for ZCL_CLUSTER_ID_SE_MESSAGING.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCBs - client callbacks
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MessagingHdlClientCmd( zclIncoming_t *pInMsg,
                                              const zclSE_MessagingClientCBs_t *pCBs );

/**************************************************************************************************
 * @fn      zclSE_MessagingHdlServerCmd
 *
 * @brief   Server command handler for ZCL_CLUSTER_ID_SE_MESSAGING.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCBs - server callbacks
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MessagingHdlServerCmd( zclIncoming_t *pInMsg,
                                              const zclSE_MessagingServerCBs_t *pCBs );

/**************************************************************************************************
 * @fn      zclSE_TunnelingSendReqTunnelRsp
 *
 * @brief   Send COMMAND_SE_TUNNELING_REQ_TUNNEL_RSP.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_TunnelingSendReqTunnelRsp( uint8_t srcEP, afAddrType_t *dstAddr,
                                                  zclSE_TunnelingReqTunnelRsp_t *pCmd,
                                                  uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_TunnelingSendServerTransferData
 *
 * @brief   Send COMMAND_SE_TUNNELING_SERVER_TRANSFER_DATA.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_TunnelingSendServerTransferData(
                   uint8_t srcEP, afAddrType_t *dstAddr,
                   zclSE_TunnelingTransferData_t *pCmd,
                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_TunnelingSendServerTransferDataErr
 *
 * @brief   Send COMMAND_SE_TUNNELING_SERVER_TRANSFER_DATA_ERR.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_TunnelingSendServerTransferDataErr(
                   uint8_t srcEP, afAddrType_t *dstAddr,
                   zclSE_TunnelingTransferDataErr_t *pCmd,
                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_TunnelingSendServerAckTransferData
 *
 * @brief   Send COMMAND_SE_TUNNELING_SERVER_ACK_TRANSFER_DATA.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_TunnelingSendServerAckTransferData(
                   uint8_t srcEP, afAddrType_t *dstAddr,
                   zclSE_TunnelingAckTransferData_t *pCmd,
                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_TunnelingSendServerReadyData
 *
 * @brief   Send COMMAND_SE_TUNNELING_SERVER_READY_DATA.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_TunnelingSendServerReadyData(
                   uint8_t srcEP, afAddrType_t *dstAddr,
                   zclSE_TunnelingReadyData_t *pCmd,
                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_TunnelingSendSuppTunnelProtocolsRsp
 *
 * @brief   Send COMMAND_SE_TUNNELING_SUPP_TUNNEL_PROTOCOLS_RSP.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_TunnelingSendSuppTunnelProtocolsRsp(
                   uint8_t srcEP, afAddrType_t *dstAddr,
                   zclSE_TunnelingSuppTunnelProtocolsRsp_t *pCmd,
                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_TunnelingSendTunnelClosureNotif
 *
 * @brief   Send COMMAND_SE_TUNNELING_TUNNEL_CLOSURE_NOTIF.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_TunnelingSendTunnelClosureNotif(
                   uint8_t srcEP, afAddrType_t *dstAddr,
                   zclSE_TunnelingTunnelClosureNotif_t *pCmd,
                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_TunnelingSendReqTunnel
 *
 * @brief   Send COMMAND_SE_TUNNELING_REQ_TUNNEL.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_TunnelingSendReqTunnel( uint8_t srcEP, afAddrType_t *dstAddr,
                                               zclSE_TunnelingReqTunnel_t *pCmd,
                                               uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_TunnelingSendCloseTunnel
 *
 * @brief   Send COMMAND_SE_TUNNELING_CLOSE_TUNNEL.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_TunnelingSendCloseTunnel( uint8_t srcEP, afAddrType_t *dstAddr,
                                                 zclSE_TunnelingCloseTunnel_t *pCmd,
                                                 uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_TunnelingSendClientTransferData
 *
 * @brief   Send COMMAND_SE_TUNNELING_CLIENT_TRANSFER_DATA.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_TunnelingSendClientTransferData(
                   uint8_t srcEP, afAddrType_t *dstAddr,
                   zclSE_TunnelingTransferData_t *pCmd,
                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_TunnelingSendClientTransferDataErr
 *
 * @brief   Send COMMAND_SE_TUNNELING_CLIENT_TRANSFER_DATA_ERR.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_TunnelingSendClientTransferDataErr(
                   uint8_t srcEP, afAddrType_t *dstAddr,
                   zclSE_TunnelingTransferDataErr_t *pCmd,
                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_TunnelingSendClientAckTransferData
 *
 * @brief   Send COMMAND_SE_TUNNELING_CLIENT_ACK_TRANSFER_DATA.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_TunnelingSendClientAckTransferData(
                   uint8_t srcEP, afAddrType_t *dstAddr,
                   zclSE_TunnelingAckTransferData_t *pCmd,
                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_TunnelingSendClientReadyData
 *
 * @brief   Send COMMAND_SE_TUNNELING_CLIENT_READY_DATA.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_TunnelingSendClientReadyData(
                   uint8_t srcEP, afAddrType_t *dstAddr,
                   zclSE_TunnelingReadyData_t *pCmd,
                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_TunnelingSendGetSuppTunnelProtocols
 *
 * @brief   Send COMMAND_SE_TUNNELING_GET_SUPP_TUNNEL_PROTOCOLS.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_TunnelingSendGetSuppTunnelProtocols(
                   uint8_t srcEP, afAddrType_t *dstAddr,
                   zclSE_TunnelingGetSuppTunnelProtocols_t *pCmd,
                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_TunnelingParseReqTunnelRsp
 *
 * @brief   Parse COMMAND_SE_TUNNELING_REQ_TUNNEL_RSP.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_TunnelingParseReqTunnelRsp( zclIncoming_t *pInMsg,
                                                   zclSE_TunnelingReqTunnelRsp_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_TunnelingParseTransferData
 *
 * @brief   Parse COMMAND_SE_TUNNELING_SERVER_TRANSFER_DATA and
 *                COMMAND_SE_TUNNELING_CLIENT_TRANSFER_DATA.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_TunnelingParseTransferData(
                   zclIncoming_t *pInMsg,
                   zclSE_TunnelingTransferData_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_TunnelingParseTransferDataErr
 *
 * @brief   Parse COMMAND_SE_TUNNELING_SERVER_TRANSFER_DATA_ERR and
 *                COMMAND_SE_TUNNELING_CLIENT_TRANSFER_DATA_ERR.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_TunnelingParseTransferDataErr(
                   zclIncoming_t *pInMsg,
                   zclSE_TunnelingTransferDataErr_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_TunnelingParseAckTransferData
 *
 * @brief   Parse COMMAND_SE_TUNNELING_SERVER_ACK_TRANSFER_DATA and
 *                COMMAND_SE_TUNNELING_CLIENT_ACK_TRANSFER_DATA.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_TunnelingParseAckTransferData(
                   zclIncoming_t *pInMsg,
                   zclSE_TunnelingAckTransferData_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_TunnelingParseReadyData
 *
 * @brief   Parse COMMAND_SE_TUNNELING_SERVER_READY_DATA and
 *                COMMAND_SE_TUNNELING_CLIENT_READY_DATA.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_TunnelingParseReadyData(
                   zclIncoming_t *pInMsg,
                   zclSE_TunnelingReadyData_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_TunnelingParseSuppTunnelProtocolsRsp
 *
 * @brief   Parse COMMAND_SE_TUNNELING_SUPP_TUNNEL_PROTOCOLS_RSP.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_TunnelingParseSuppTunnelProtocolsRsp(
                   zclIncoming_t *pInMsg,
                   zclSE_TunnelingSuppTunnelProtocolsRsp_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_TunnelingParseTunnelClosureNotif
 *
 * @brief   Parse COMMAND_SE_TUNNELING_TUNNEL_CLOSURE_NOTIF.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_TunnelingParseTunnelClosureNotif(
                   zclIncoming_t *pInMsg,
                   zclSE_TunnelingTunnelClosureNotif_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_TunnelingParseReqTunnel
 *
 * @brief   Parse COMMAND_SE_TUNNELING_REQ_TUNNEL.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_TunnelingParseReqTunnel( zclIncoming_t *pInMsg,
                                                zclSE_TunnelingReqTunnel_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_TunnelingParseCloseTunnel
 *
 * @brief   Parse COMMAND_SE_TUNNELING_CLOSE_TUNNEL.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_TunnelingParseCloseTunnel( zclIncoming_t *pInMsg,
                                                  zclSE_TunnelingCloseTunnel_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_TunnelingParseGetSuppTunnelProtocols
 *
 * @brief   Parse COMMAND_SE_TUNNELING_GET_SUPP_TUNNEL_PROTOCOLS.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_TunnelingParseGetSuppTunnelProtocols(
                   zclIncoming_t *pInMsg,
                   zclSE_TunnelingGetSuppTunnelProtocols_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_TunnelingHdlReqTunnelRsp
 *
 * @brief   Handle COMMAND_SE_TUNNELING_REQ_TUNNEL_RSP.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_TunnelingHdlReqTunnelRsp( zclIncoming_t *pInMsg,
                                                 zclSE_TunnelingReqTunnelRspCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_TunnelingHdlTransferData
 *
 * @brief   Handle COMMAND_SE_TUNNELING_SERVER_TRANSFER_DATA and
 *                 COMMAND_SE_TUNNELING_CLIENT_TRANSFER_DATA.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_TunnelingHdlTransferData(
                   zclIncoming_t *pInMsg,
                   zclSE_TunnelingTransferDataCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_TunnelingHdlTransferDataErr
 *
 * @brief   Handle COMMAND_SE_TUNNELING_SERVER_TRANSFER_DATA_ERR and
 *                 COMMAND_SE_TUNNELING_CLIENT_TRANSFER_DATA_ERR.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_TunnelingHdlTransferDataErr(
                   zclIncoming_t *pInMsg,
                   zclSE_TunnelingTransferDataErrCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_TunnelingHdlAckTransferData
 *
 * @brief   Handle COMMAND_SE_TUNNELING_SERVER_ACK_TRANSFER_DATA and
 *                 COMMAND_SE_TUNNELING_CLIENT_ACK_TRANSFER_DATA.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_TunnelingHdlAckTransferData(
                   zclIncoming_t *pInMsg,
                   zclSE_TunnelingAckTransferDataCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_TunnelingHdlReadyData
 *
 * @brief   Handle COMMAND_SE_TUNNELING_SERVER_READY_DATA and
 *                 COMMAND_SE_TUNNELING_CLIENT_READY_DATA.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_TunnelingHdlReadyData(
                   zclIncoming_t *pInMsg,
                   zclSE_TunnelingReadyDataCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_TunnelingHdlSuppTunnelProtocolsRsp
 *
 * @brief   Handle COMMAND_SE_TUNNELING_SUPP_TUNNEL_PROTOCOLS_RSP.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_TunnelingHdlSuppTunnelProtocolsRsp(
                   zclIncoming_t *pInMsg,
                   zclSE_TunnelingSuppTunnelProtocolsRspCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_TunnelingHdlTunnelClosureNotif
 *
 * @brief   Handle COMMAND_SE_TUNNELING_TUNNEL_CLOSURE_NOTIF.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_TunnelingHdlTunnelClosureNotif(
                   zclIncoming_t *pInMsg,
                   zclSE_TunnelingTunnelClosureNotifCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_TunnelingHdlReqTunnel
 *
 * @brief   Handle COMMAND_SE_TUNNELING_REQ_TUNNEL.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_TunnelingHdlReqTunnel( zclIncoming_t *pInMsg,
                                              zclSE_TunnelingReqTunnelCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_TunnelingHdlCloseTunnel
 *
 * @brief   Handle COMMAND_SE_TUNNELING_CLOSE_TUNNEL.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_TunnelingHdlCloseTunnel( zclIncoming_t *pInMsg,
                                                zclSE_TunnelingCloseTunnelCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_TunnelingHdlGetSuppTunnelProtocols
 *
 * @brief   Handle COMMAND_SE_TUNNELING_GET_SUPP_TUNNEL_PROTOCOLS.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_TunnelingHdlGetSuppTunnelProtocols(
                   zclIncoming_t *pInMsg,
                   zclSE_TunnelingGetSuppTunnelProtocolsCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_TunnelingHdlClientCmd
 *
 * @brief   Client command handler for ZCL_CLUSTER_ID_SE_TUNNELING.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCBs - client callbacks
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_TunnelingHdlClientCmd( zclIncoming_t *pInMsg,
                                              const zclSE_TunnelingClientCBs_t *pCBs );

/**************************************************************************************************
 * @fn      zclSE_TunnelingHdlServerCmd
 *
 * @brief   Server command handler for ZCL_CLUSTER_ID_SE_TUNNELING.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCBs - server callbacks
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_TunnelingHdlServerCmd( zclIncoming_t *pInMsg,
                                              const zclSE_TunnelingServerCBs_t *pCBs );

/**************************************************************************************************
 * @fn      zclSE_PrepaymentSendPublishPrepaySnapshot
 *
 * @brief   Send COMMAND_SE_PREPAYMENT_PUBLISH_PREPAY_SNAPSHOT.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PrepaymentSendPublishPrepaySnapshot(
                   uint8_t srcEP, afAddrType_t *dstAddr,
                   zclSE_PrepaymentPublishPrepaySnapshot_t *pCmd,
                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_PrepaymentSendChangePaymentModeRsp
 *
 * @brief   Send COMMAND_SE_PREPAYMENT_CHANGE_PAYMENT_MODE_RSP.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PrepaymentSendChangePaymentModeRsp(
                   uint8_t srcEP, afAddrType_t *dstAddr,
                   zclSE_PrepaymentChangePaymentModeRsp_t *pCmd,
                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_PrepaymentSendConsumerTopUpRsp
 *
 * @brief   Send COMMAND_SE_PREPAYMENT_CONSUMER_TOP_UP_RSP.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PrepaymentSendConsumerTopUpRsp(
                   uint8_t srcEP, afAddrType_t *dstAddr,
                   zclSE_PrepaymentConsumerTopUpRsp_t *pCmd,
                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_PrepaymentSendPublishTopUpLog
 *
 * @brief   Send COMMAND_SE_PREPAYMENT_PUBLISH_TOP_UP_LOG.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PrepaymentSendPublishTopUpLog(
                   uint8_t srcEP, afAddrType_t *dstAddr,
                   zclSE_PrepaymentPublishTopUpLog_t *pCmd,
                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_PrepaymentSendPublishDebtLog
 *
 * @brief   Send COMMAND_SE_PREPAYMENT_PUBLISH_DEBT_LOG.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PrepaymentSendPublishDebtLog(
                   uint8_t srcEP, afAddrType_t *dstAddr,
                   zclSE_PrepaymentPublishDebtLog_t *pCmd,
                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_PrepaymentSendSelAvailEmrgncyCredit
 *
 * @brief   Send COMMAND_SE_PREPAYMENT_SEL_AVAIL_EMRGNCY_CREDIT.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PrepaymentSendSelAvailEmrgncyCredit(
                   uint8_t srcEP, afAddrType_t *dstAddr,
                   zclSE_PrepaymentSelAvailEmrgncyCredit_t *pCmd,
                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_PrepaymentSendChangeDebt
 *
 * @brief   Send COMMAND_SE_PREPAYMENT_CHANGE_DEBT.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PrepaymentSendChangeDebt( uint8_t srcEP, afAddrType_t *dstAddr,
                                                 zclSE_PrepaymentChangeDebt_t *pCmd,
                                                 uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_PrepaymentSendEmrgncyCreditSetup
 *
 * @brief   Send COMMAND_SE_PREPAYMENT_EMRGNCY_CREDIT_SETUP.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PrepaymentSendEmrgncyCreditSetup(
                   uint8_t srcEP, afAddrType_t *dstAddr,
                   zclSE_PrepaymentEmrgncyCreditSetup_t *pCmd,
                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_PrepaymentSendConsumerTopUp
 *
 * @brief   Send COMMAND_SE_PREPAYMENT_CONSUMER_TOP_UP.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PrepaymentSendConsumerTopUp(
                   uint8_t srcEP, afAddrType_t *dstAddr,
                   zclSE_PrepaymentConsumerTopUp_t *pCmd,
                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_PrepaymentSendCreditAdj
 *
 * @brief   Send COMMAND_SE_PREPAYMENT_CREDIT_ADJ.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PrepaymentSendCreditAdj(
                   uint8_t srcEP, afAddrType_t *dstAddr,
                   zclSE_PrepaymentCreditAdj_t *pCmd,
                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_PrepaymentSendChangePaymentMode
 *
 * @brief   Send COMMAND_SE_PREPAYMENT_CHANGE_PAYMENT_MODE.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PrepaymentSendChangePaymentMode(
                   uint8_t srcEP, afAddrType_t *dstAddr,
                   zclSE_PrepaymentChangePaymentMode_t *pCmd,
                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_PrepaymentSendGetPrepaySnapshot
 *
 * @brief   Send COMMAND_SE_PREPAYMENT_GET_PREPAY_SNAPSHOT.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PrepaymentSendGetPrepaySnapshot(
                   uint8_t srcEP, afAddrType_t *dstAddr,
                   zclSE_PrepaymentGetPrepaySnapshot_t *pCmd,
                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_PrepaymentSendGetTopUpLog
 *
 * @brief   Send COMMAND_SE_PREPAYMENT_GET_TOP_UP_LOG.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PrepaymentSendGetTopUpLog( uint8_t srcEP, afAddrType_t *dstAddr,
                                                  zclSE_PrepaymentGetTopUpLog_t *pCmd,
                                                  uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_PrepaymentSendSetLowCreditWarnLevel
 *
 * @brief   Send COMMAND_SE_PREPAYMENT_SET_LOW_CREDIT_WARN_LEVEL.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PrepaymentSendSetLowCreditWarnLevel(
                   uint8_t srcEP, afAddrType_t *dstAddr,
                   zclSE_PrepaymentSetLowCreditWarnLevel_t *pCmd,
                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_PrepaymentSendGetDebtRepayLog
 *
 * @brief   Send COMMAND_SE_PREPAYMENT_GET_DEBT_REPAY_LOG.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PrepaymentSendGetDebtRepayLog(
                   uint8_t srcEP, afAddrType_t *dstAddr,
                   zclSE_PrepaymentGetDebtRepayLog_t *pCmd,
                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_PrepaymentSendSetMaxCreditLimit
 *
 * @brief   Send COMMAND_SE_PREPAYMENT_SET_MAX_CREDIT_LIMIT.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PrepaymentSendSetMaxCreditLimit(
                   uint8_t srcEP, afAddrType_t *dstAddr,
                   zclSE_PrepaymentSetMaxCreditLimit_t *pCmd,
                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_PrepaymentSendSetOverallDebtCap
 *
 * @brief   Send COMMAND_SE_PREPAYMENT_SET_OVERALL_DEBT_CAP.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PrepaymentSendSetOverallDebtCap(
                   uint8_t srcEP, afAddrType_t *dstAddr,
                   zclSE_PrepaymentSetOverallDebtCap_t *pCmd,
                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_PrepaymentParsePublishPrepaySnapshot
 *
 * @brief   Parse COMMAND_SE_PREPAYMENT_PUBLISH_PREPAY_SNAPSHOT.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PrepaymentParsePublishPrepaySnapshot(
                   zclIncoming_t *pInMsg,
                   zclSE_PrepaymentPublishPrepaySnapshot_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_PrepaymentParseChangePaymentModeRsp
 *
 * @brief   Parse COMMAND_SE_PREPAYMENT_CHANGE_PAYMENT_MODE_RSP.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PrepaymentParseChangePaymentModeRsp(
                   zclIncoming_t *pInMsg,
                   zclSE_PrepaymentChangePaymentModeRsp_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_PrepaymentParseConsumerTopUpRsp
 *
 * @brief   Parse COMMAND_SE_PREPAYMENT_CONSUMER_TOP_UP_RSP.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PrepaymentParseConsumerTopUpRsp(
                   zclIncoming_t *pInMsg,
                   zclSE_PrepaymentConsumerTopUpRsp_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_PrepaymentParsePublishTopUpLog
 *
 * @brief   Parse COMMAND_SE_PREPAYMENT_PUBLISH_TOP_UP_LOG.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PrepaymentParsePublishTopUpLog(
                   zclIncoming_t *pInMsg,
                   zclSE_PrepaymentPublishTopUpLog_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_PrepaymentParsePublishDebtLog
 *
 * @brief   Parse COMMAND_SE_PREPAYMENT_PUBLISH_DEBT_LOG.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PrepaymentParsePublishDebtLog(
                   zclIncoming_t *pInMsg,
                   zclSE_PrepaymentPublishDebtLog_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_PrepaymentParseSelAvailEmrgncyCredit
 *
 * @brief   Parse COMMAND_SE_PREPAYMENT_SEL_AVAIL_EMRGNCY_CREDIT.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PrepaymentParseSelAvailEmrgncyCredit(
                   zclIncoming_t *pInMsg,
                   zclSE_PrepaymentSelAvailEmrgncyCredit_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_PrepaymentParseChangeDebt
 *
 * @brief   Parse COMMAND_SE_PREPAYMENT_CHANGE_DEBT.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PrepaymentParseChangeDebt( zclIncoming_t *pInMsg,
                                                  zclSE_PrepaymentChangeDebt_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_PrepaymentParseEmrgncyCreditSetup
 *
 * @brief   Parse COMMAND_SE_PREPAYMENT_EMRGNCY_CREDIT_SETUP.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PrepaymentParseEmrgncyCreditSetup(
                   zclIncoming_t *pInMsg,
                   zclSE_PrepaymentEmrgncyCreditSetup_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_PrepaymentParseConsumerTopUp
 *
 * @brief   Parse COMMAND_SE_PREPAYMENT_CONSUMER_TOP_UP.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PrepaymentParseConsumerTopUp(
                   zclIncoming_t *pInMsg,
                   zclSE_PrepaymentConsumerTopUp_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_PrepaymentParseCreditAdj
 *
 * @brief   Parse COMMAND_SE_PREPAYMENT_CREDIT_ADJ.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PrepaymentParseCreditAdj(
                   zclIncoming_t *pInMsg,
                   zclSE_PrepaymentCreditAdj_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_PrepaymentParseChangePaymentMode
 *
 * @brief   Parse COMMAND_SE_PREPAYMENT_CHANGE_PAYMENT_MODE.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PrepaymentParseChangePaymentMode(
                   zclIncoming_t *pInMsg,
                   zclSE_PrepaymentChangePaymentMode_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_PrepaymentParseGetPrepaySnapshot
 *
 * @brief   Parse COMMAND_SE_PREPAYMENT_GET_PREPAY_SNAPSHOT.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PrepaymentParseGetPrepaySnapshot(
                   zclIncoming_t *pInMsg,
                   zclSE_PrepaymentGetPrepaySnapshot_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_PrepaymentParseGetTopUpLog
 *
 * @brief   Parse COMMAND_SE_PREPAYMENT_GET_TOP_UP_LOG.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PrepaymentParseGetTopUpLog( zclIncoming_t *pInMsg,
                                                   zclSE_PrepaymentGetTopUpLog_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_PrepaymentParseSetLowCreditWarnLevel
 *
 * @brief   Parse COMMAND_SE_PREPAYMENT_SET_LOW_CREDIT_WARN_LEVEL.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PrepaymentParseSetLowCreditWarnLevel(
                   zclIncoming_t *pInMsg,
                   zclSE_PrepaymentSetLowCreditWarnLevel_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_PrepaymentParseGetDebtRepayLog
 *
 * @brief   Parse COMMAND_SE_PREPAYMENT_GET_DEBT_REPAY_LOG.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PrepaymentParseGetDebtRepayLog(
                   zclIncoming_t *pInMsg,
                   zclSE_PrepaymentGetDebtRepayLog_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_PrepaymentParseSetMaxCreditLimit
 *
 * @brief   Parse COMMAND_SE_PREPAYMENT_SET_MAX_CREDIT_LIMIT.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PrepaymentParseSetMaxCreditLimit(
                   zclIncoming_t *pInMsg,
                   zclSE_PrepaymentSetMaxCreditLimit_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_PrepaymentParseSetOverallDebtCap
 *
 * @brief   Parse COMMAND_SE_PREPAYMENT_SET_OVERALL_DEBT_CAP.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PrepaymentParseSetOverallDebtCap(
                   zclIncoming_t *pInMsg,
                   zclSE_PrepaymentSetOverallDebtCap_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_PrepaymentHdlPublishPrepaySnapshot
 *
 * @brief   Handle COMMAND_SE_PREPAYMENT_PUBLISH_PREPAY_SNAPSHOT.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PrepaymentHdlPublishPrepaySnapshot(
                   zclIncoming_t *pInMsg,
                   zclSE_PrepaymentPublishPrepaySnapshotCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_PrepaymentHdlChangePaymentModeRsp
 *
 * @brief   Handle COMMAND_SE_PREPAYMENT_CHANGE_PAYMENT_MODE_RSP.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PrepaymentHdlChangePaymentModeRsp(
                   zclIncoming_t *pInMsg,
                   zclSE_PrepaymentChangePaymentModeRspCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_PrepaymentHdlConsumerTopUpRsp
 *
 * @brief   Handle COMMAND_SE_PREPAYMENT_CONSUMER_TOP_UP_RSP.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PrepaymentHdlConsumerTopUpRsp(
                   zclIncoming_t *pInMsg,
                   zclSE_PrepaymentConsumerTopUpRspCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_PrepaymentHdlPublishTopUpLog
 *
 * @brief   Handle COMMAND_SE_PREPAYMENT_PUBLISH_TOP_UP_LOG.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PrepaymentHdlPublishTopUpLog(
                   zclIncoming_t *pInMsg,
                   zclSE_PrepaymentPublishTopUpLogCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_PrepaymentHdlPublishDebtLog
 *
 * @brief   Handle COMMAND_SE_PREPAYMENT_PUBLISH_DEBT_LOG.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PrepaymentHdlPublishDebtLog(
                   zclIncoming_t *pInMsg,
                   zclSE_PrepaymentPublishDebtLogCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_PrepaymentHdlSelAvailEmrgncyCredit
 *
 * @brief   Handle COMMAND_SE_PREPAYMENT_SEL_AVAIL_EMRGNCY_CREDIT.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PrepaymentHdlSelAvailEmrgncyCredit(
                   zclIncoming_t *pInMsg,
                   zclSE_PrepaymentSelAvailEmrgncyCreditCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_PrepaymentHdlChangeDebt
 *
 * @brief   Handle COMMAND_SE_PREPAYMENT_CHANGE_DEBT.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PrepaymentHdlChangeDebt( zclIncoming_t *pInMsg,
                                                zclSE_PrepaymentChangeDebtCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_PrepaymentHdlEmrgncyCreditSetup
 *
 * @brief   Handle COMMAND_SE_PREPAYMENT_EMRGNCY_CREDIT_SETUP.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PrepaymentHdlEmrgncyCreditSetup(
                   zclIncoming_t *pInMsg,
                   zclSE_PrepaymentEmrgncyCreditSetupCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_PrepaymentHdlConsumerTopUp
 *
 * @brief   Handle COMMAND_SE_PREPAYMENT_CONSUMER_TOP_UP.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PrepaymentHdlConsumerTopUp( zclIncoming_t *pInMsg,
                                                   zclSE_PrepaymentConsumerTopUpCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_PrepaymentHdlCreditAdj
 *
 * @brief   Handle COMMAND_SE_PREPAYMENT_CREDIT_ADJ.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PrepaymentHdlCreditAdj(
                   zclIncoming_t *pInMsg,
                   zclSE_PrepaymentCreditAdjCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_PrepaymentHdlChangePaymentMode
 *
 * @brief   Handle COMMAND_SE_PREPAYMENT_CHANGE_PAYMENT_MODE.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PrepaymentHdlChangePaymentMode(
                   zclIncoming_t *pInMsg,
                   zclSE_PrepaymentChangePaymentModeCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_PrepaymentHdlGetPrepaySnapshot
 *
 * @brief   Handle COMMAND_SE_PREPAYMENT_GET_PREPAY_SNAPSHOT.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PrepaymentHdlGetPrepaySnapshot(
                   zclIncoming_t *pInMsg,
                   zclSE_PrepaymentGetPrepaySnapshotCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_PrepaymentHdlGetTopUpLog
 *
 * @brief   Handle COMMAND_SE_PREPAYMENT_GET_TOP_UP_LOG.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PrepaymentHdlGetTopUpLog( zclIncoming_t *pInMsg,
                                                 zclSE_PrepaymentGetTopUpLogCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_PrepaymentHdlSetLowCreditWarnLevel
 *
 * @brief   Handle COMMAND_SE_PREPAYMENT_SET_LOW_CREDIT_WARN_LEVEL.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PrepaymentHdlSetLowCreditWarnLevel(
                   zclIncoming_t *pInMsg,
                   zclSE_PrepaymentSetLowCreditWarnLevelCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_PrepaymentHdlGetDebtRepayLog
 *
 *  @brief   Handle COMMAND_SE_PREPAYMENT_GET_DEBT_REPAY_LOG.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PrepaymentHdlGetDebtRepayLog(
                   zclIncoming_t *pInMsg,
                   zclSE_PrepaymentGetDebtRepayLogCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_PrepaymentHdlSetMaxCreditLimit
 *
 * @brief   Handle COMMAND_SE_PREPAYMENT_SET_MAX_CREDIT_LIMIT.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PrepaymentHdlSetMaxCreditLimit(
                   zclIncoming_t *pInMsg,
                   zclSE_PrepaymentSetMaxCreditLimitCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_PrepaymentHdlSetOverallDebtCap
 *
 * @brief   Handle COMMAND_SE_PREPAYMENT_SET_OVERALL_DEBT_CAP.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PrepaymentHdlSetOverallDebtCap(
                   zclIncoming_t *pInMsg,
                   zclSE_PrepaymentSetOverallDebtCapCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_PrepaymentHdlClientCmd
 *
 * @brief   Client command handler for ZCL_CLUSTER_ID_SE_PREPAYMENT.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCBs - client callbacks
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PrepaymentHdlClientCmd( zclIncoming_t *pInMsg,
                                               const zclSE_PrepaymentClientCBs_t *pCBs );

/**************************************************************************************************
 * @fn      zclSE_PrepaymentHdlServerCmd
 *
 * @brief   Server command handler for ZCL_CLUSTER_ID_SE_PREPAYMENT.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCBs - server callbacks
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PrepaymentHdlServerCmd( zclIncoming_t *pInMsg,
                                               const zclSE_PrepaymentServerCBs_t *pCBs );

/**************************************************************************************************
 * @fn      zclSE_PrepaymentSnapshotPayloadParse
 *
 * @brief   Utility function for parsing "payload" payload -- see
 *          "zclSE_PrepaymentPublishPrepaySnapshot_t"
 *
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PrepaymentSnapshotPayloadParse(
                   zclSE_PrepaymentPublishPrepaySnapshot_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_PrepaymentTopUpParse
 *
 * @brief   Utility function for parsing "pTopUps" payload -- see
 *          "zclSE_PrepaymentPublishTopUpLog_t"
 *
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PrepaymentTopUpParse( zclSE_PrepaymentPublishTopUpLog_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_PrepaymentDebtRecParse
 *
 * @brief   Utility function for parsing "pRecs" payload -- see "zclSE_PrepaymentPublishDebtLog_t"
 *
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_PrepaymentDebtRecParse( zclSE_PrepaymentPublishDebtLog_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_CalendarSendPublishCalendar
 *
 * @brief   Send COMMAND_SE_CALENDAR_PUBLISH_CALENDAR.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_CalendarSendPublishCalendar(
                   uint8_t srcEP, afAddrType_t *dstAddr,
                   zclSE_CalendarPublishCalendar_t *pCmd,
                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_CalendarSendPublishDayProfile
 *
 * @brief   Send COMMAND_SE_CALENDAR_PUBLISH_DAY_PROFILE.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_CalendarSendPublishDayProfile(
                   uint8_t srcEP, afAddrType_t *dstAddr,
                   zclSE_CalendarPublishDayProfile_t *pCmd,
                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_CalendarSendPublishWeekProfile
 *
 * @brief   Send COMMAND_SE_CALENDAR_PUBLISH_WEEK_PROFILE.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_CalendarSendPublishWeekProfile(
                   uint8_t srcEP, afAddrType_t *dstAddr,
                   zclSE_CalendarPublishWeekProfile_t *pCmd,
                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_CalendarSendPublishSeasons
 *
 * @brief   Send COMMAND_SE_CALENDAR_PUBLISH_SEASONS.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_CalendarSendPublishSeasons( uint8_t srcEP, afAddrType_t *dstAddr,
                                                   zclSE_CalendarPublishSeasons_t *pCmd,
                                                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_CalendarSendPublishSpecialDays
 *
 * @brief   Send COMMAND_SE_CALENDAR_PUBLISH_SPECIAL_DAYS.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_CalendarSendPublishSpecialDays(
                   uint8_t srcEP, afAddrType_t *dstAddr,
                   zclSE_CalendarPublishSpecialDays_t *pCmd,
                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_CalendarSendCancelCalendar
 *
 * @brief   Send COMMAND_SE_CALENDAR_CANCEL_CALENDAR.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_CalendarSendCancelCalendar( uint8_t srcEP, afAddrType_t *dstAddr,
                                                   zclSE_CalendarCancelCalendar_t *pCmd,
                                                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_CalendarSendGetCalendar
 *
 * @brief   Send COMMAND_SE_CALENDAR_GET_CALENDAR.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_CalendarSendGetCalendar( uint8_t srcEP, afAddrType_t *dstAddr,
                                                zclSE_CalendarGetCalendar_t *pCmd,
                                                uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_CalendarSendGetDayProfiles
 *
 * @brief   Send COMMAND_SE_CALENDAR_GET_DAY_PROFILES.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_CalendarSendGetDayProfiles( uint8_t srcEP, afAddrType_t *dstAddr,
                                                   zclSE_CalendarGetDayProfiles_t *pCmd,
                                                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_CalendarSendGetWeekProfiles
 *
 * @brief   Send COMMAND_SE_CALENDAR_GET_WEEK_PROFILES.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_CalendarSendGetWeekProfiles(
                   uint8_t srcEP, afAddrType_t *dstAddr,
                   zclSE_CalendarGetWeekProfiles_t *pCmd,
                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_CalendarSendGetSeasons
 *
 * @brief   Send COMMAND_SE_CALENDAR_GET_SEASONS.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_CalendarSendGetSeasons( uint8_t srcEP, afAddrType_t *dstAddr,
                                               zclSE_CalendarGetSeasons_t *pCmd,
                                               uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_CalendarSendGetSpecialDays
 *
 * @brief   Send COMMAND_SE_CALENDAR_GET_SPECIAL_DAYS.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_CalendarSendGetSpecialDays( uint8_t srcEP, afAddrType_t *dstAddr,
                                                   zclSE_CalendarGetSpecialDays_t *pCmd,
                                                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_CalendarSendGetCalendarCancellation
 *
 * @brief   Send COMMAND_SE_CALENDAR_GET_CALENDAR_CANCELLATION.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
#define zclSE_CalendarSendGetCalendarCancellation( srcEP, dstAddr, disableDefaultRsp, seqNum ) \
  zcl_SendCommand( srcEP, dstAddr, ZCL_CLUSTER_ID_SE_CALENDAR,                                 \
                   COMMAND_SE_CALENDAR_GET_CALENDAR_CANCELLATION, TRUE,                        \
                   ZCL_FRAME_CLIENT_SERVER_DIR,                                                \
                   disableDefaultRsp, 0, seqNum, 0, NULL );

/**************************************************************************************************
 * @fn      zclSE_CalendarParsePublishCalendar
 *
 * @brief   Parse COMMAND_SE_CALENDAR_PUBLISH_CALENDAR.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_CalendarParsePublishCalendar(
                   zclIncoming_t *pInMsg,
                   zclSE_CalendarPublishCalendar_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_CalendarParsePublishDayProfile
 *
 * @brief   Parse COMMAND_SE_CALENDAR_PUBLISH_DAY_PROFILE.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_CalendarParsePublishDayProfile(
                   zclIncoming_t *pInMsg,
                   zclSE_CalendarPublishDayProfile_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_CalendarParsePublishWeekProfile
 *
 * @brief   Parse COMMAND_SE_CALENDAR_PUBLISH_WEEK_PROFILE.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_CalendarParsePublishWeekProfile(
                   zclIncoming_t *pInMsg,
                   zclSE_CalendarPublishWeekProfile_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_CalendarParsePublishSeasons
 *
 * @brief   Parse COMMAND_SE_CALENDAR_PUBLISH_SEASONS.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_CalendarParsePublishSeasons(
                   zclIncoming_t *pInMsg,
                   zclSE_CalendarPublishSeasons_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_CalendarParsePublishSpecialDays
 *
 * @brief   Parse COMMAND_SE_CALENDAR_PUBLISH_SPECIAL_DAYS.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_CalendarParsePublishSpecialDays(
                   zclIncoming_t *pInMsg,
                   zclSE_CalendarPublishSpecialDays_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_CalendarParseCancelCalendar
 *
 * @brief   Parse COMMAND_SE_CALENDAR_CANCEL_CALENDAR.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_CalendarParseCancelCalendar(
                   zclIncoming_t *pInMsg,
                   zclSE_CalendarCancelCalendar_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_CalendarParseGetCalendar
 *
 * @brief   Parse COMMAND_SE_CALENDAR_GET_CALENDAR.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_CalendarParseGetCalendar( zclIncoming_t *pInMsg,
                                                 zclSE_CalendarGetCalendar_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_CalendarParseGetDayProfiles
 *
 * @brief   Parse COMMAND_SE_CALENDAR_GET_DAY_PROFILES.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_CalendarParseGetDayProfiles(
                   zclIncoming_t *pInMsg,
                   zclSE_CalendarGetDayProfiles_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_CalendarParseGetWeekProfiles
 *
 * @brief   Parse COMMAND_SE_CALENDAR_GET_WEEK_PROFILES.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_CalendarParseGetWeekProfiles(
                   zclIncoming_t *pInMsg,
                   zclSE_CalendarGetWeekProfiles_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_CalendarParseGetSeasons
 *
 * @brief   Parse COMMAND_SE_CALENDAR_GET_SEASONS.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_CalendarParseGetSeasons( zclIncoming_t *pInMsg,
                                                zclSE_CalendarGetSeasons_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_CalendarParseGetSpecialDays
 *
 * @brief   Parse COMMAND_SE_CALENDAR_GET_SPECIAL_DAYS.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_CalendarParseGetSpecialDays(
                   zclIncoming_t *pInMsg,
                   zclSE_CalendarGetSpecialDays_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_CalendarHdlPublishCalendar
 *
 * @brief   Handle COMMAND_SE_CALENDAR_PUBLISH_CALENDAR.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_CalendarHdlPublishCalendar( zclIncoming_t *pInMsg,
                                                   zclSE_CalendarPublishCalendarCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_CalendarHdlPublishDayProfile
 *
 * @brief   Handle COMMAND_SE_CALENDAR_PUBLISH_DAY_PROFILE.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_CalendarHdlPublishDayProfile(
                   zclIncoming_t *pInMsg,
                   zclSE_CalendarPublishDayProfileCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_CalendarHdlPublishWeekProfile
 *
 * @brief   Handle COMMAND_SE_CALENDAR_PUBLISH_WEEK_PROFILE.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_CalendarHdlPublishWeekProfile(
                   zclIncoming_t *pInMsg,
                   zclSE_CalendarPublishWeekProfileCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_CalendarHdlPublishSeasons
 *
 * @brief   Handle COMMAND_SE_CALENDAR_PUBLISH_SEASONS.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_CalendarHdlPublishSeasons( zclIncoming_t *pInMsg,
                                                  zclSE_CalendarPublishSeasonsCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_CalendarHdlPublishSpecialDays
 *
 * @brief   Handle COMMAND_SE_CALENDAR_PUBLISH_SPECIAL_DAYS.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_CalendarHdlPublishSpecialDays(
                   zclIncoming_t *pInMsg,
                   zclSE_CalendarPublishSpecialDaysCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_CalendarHdlCancelCalendar
 *
 * @brief   Handle COMMAND_SE_CALENDAR_CANCEL_CALENDAR.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_CalendarHdlCancelCalendar( zclIncoming_t *pInMsg,
                                                  zclSE_CalendarCancelCalendarCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_CalendarHdlGetCalendar
 *
 * @brief   Handle COMMAND_SE_CALENDAR_GET_CALENDAR.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_CalendarHdlGetCalendar( zclIncoming_t *pInMsg,
                                               zclSE_CalendarGetCalendarCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_CalendarHdlGetDayProfiles
 *
 * @brief   Handle COMMAND_SE_CALENDAR_GET_DAY_PROFILES.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_CalendarHdlGetDayProfiles( zclIncoming_t *pInMsg,
                                                  zclSE_CalendarGetDayProfilesCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_CalendarHdlGetWeekProfiles
 *
 * @brief   Handle COMMAND_SE_CALENDAR_GET_WEEK_PROFILES.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_CalendarHdlGetWeekProfiles( zclIncoming_t *pInMsg,
                                                   zclSE_CalendarGetWeekProfilesCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_CalendarHdlGetSeasons
 *
 * @brief   Handle COMMAND_SE_CALENDAR_GET_SEASONS.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_CalendarHdlGetSeasons( zclIncoming_t *pInMsg,
                                              zclSE_CalendarGetSeasonsCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_CalendarHdlGetSpecialDays
 *
 * @brief   Handle COMMAND_SE_CALENDAR_GET_SPECIAL_DAYS.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_CalendarHdlGetSpecialDays( zclIncoming_t *pInMsg,
                                                  zclSE_CalendarGetSpecialDaysCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_CalendarHdlGetCalendarCancellation
 *
 * @brief   Handle COMMAND_SE_CALENDAR_GET_CALENDAR_CANCELLATION.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_CalendarHdlGetCalendarCancellation(
                   zclIncoming_t *pInMsg,
                   zclSE_CalendarGetCalendarCancellationCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_CalendarHdlClientCmd
 *
 * @brief   Client command handler for ZCL_CLUSTER_ID_SE_CALENDAR.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCBs - client callbacks
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_CalendarHdlClientCmd( zclIncoming_t *pInMsg,
                                             const zclSE_CalendarClientCBs_t *pCBs );

/**************************************************************************************************
 * @fn      zclSE_CalendarHdlServerCmd
 *
 * @brief   Server command handler for ZCL_CLUSTER_ID_SE_CALENDAR.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCBs - server callbacks
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_CalendarHdlServerCmd( zclIncoming_t *pInMsg,
                                             const zclSE_CalendarServerCBs_t *pCBs );

/**************************************************************************************************
 * @fn      zclSE_CalendarDayEntryParse
 *
 * @brief   Utility function for parsing "entries" payload -- see
 *          "zclSE_CalendarPublishDayProfile_t"
 *
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_CalendarDayEntryParse( zclSE_CalendarPublishDayProfile_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_CalendarSeasonEntryParse
 *
 * @brief   Utility function for parsing "pSeasonEntries" payload -- see
 *          "zclSE_CalendarPublishSeasons_t"
 *
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_CalendarSeasonEntryParse( zclSE_CalendarPublishSeasons_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_CalendarSpecialDayEntryParse
 *
 * @brief   Utility function for parsing "pEntries" payload -- see
 *          "zclSE_CalendarPublishSpecialDays_t"
 *
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_CalendarSpecialDayEntryParse(
                   zclSE_CalendarPublishSpecialDays_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_DeviceMgmtSendPublishChangeOfTenancy
 *
 * @brief   Send COMMAND_SE_DEVICE_MGMT_PUBLISH_CHANGE_OF_TENANCY.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_DeviceMgmtSendPublishChangeOfTenancy(
                   uint8_t srcEP, afAddrType_t *dstAddr,
                   zclSE_DeviceMgmtPublishChangeOfTenancy_t *pCmd,
                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_DeviceMgmtSendPublishChangeOfSupplier
 *
 * @brief   Send COMMAND_SE_DEVICE_MGMT_PUBLISH_CHANGE_OF_SUPPLIER.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_DeviceMgmtSendPublishChangeOfSupplier(
                   uint8_t srcEP, afAddrType_t *dstAddr,
                   zclSE_DeviceMgmtPublishChangeOfSupplier_t *pCmd,
                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_DeviceMgmtSendReqNewPWRsp
 *
 * @brief   Send COMMAND_SE_DEVICE_MGMT_REQ_NEW_PW_RSP.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_DeviceMgmtSendReqNewPWRsp( uint8_t srcEP, afAddrType_t *dstAddr,
                                                  zclSE_DeviceMgmtReqNewPWRsp_t *pCmd,
                                                  uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_DeviceMgmtSendUpdateSiteID
 *
 * @brief   Send COMMAND_SE_DEVICE_MGMT_UPDATE_SITE_ID.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_DeviceMgmtSendUpdateSiteID( uint8_t srcEP, afAddrType_t *dstAddr,
                                                   zclSE_DeviceMgmtUpdateSiteID_t *pCmd,
                                                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_DeviceMgmtSendSetEvtCfg
 *
 * @brief   Send COMMAND_SE_DEVICE_MGMT_SET_EVT_CFG.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_DeviceMgmtSendSetEvtCfg( uint8_t srcEP, afAddrType_t *dstAddr,
                                                zclSE_DeviceMgmtSetEvtCfg_t *pCmd,
                                                uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_DeviceMgmtSendGetEvtCfg
 *
 * @brief   Send COMMAND_SE_DEVICE_MGMT_GET_EVT_CFG.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_DeviceMgmtSendGetEvtCfg( uint8_t srcEP, afAddrType_t *dstAddr,
                                                zclSE_DeviceMgmtGetEvtCfg_t *pCmd,
                                                uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_DeviceMgmtSendUpdateCIN
 *
 * @brief   Send COMMAND_SE_DEVICE_MGMT_UPDATE_CIN.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_DeviceMgmtSendUpdateCIN( uint8_t srcEP, afAddrType_t *dstAddr,
                                                zclSE_DeviceMgmtUpdateCIN_t *pCmd,
                                                uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_DeviceMgmtSendGetChangeOfTenancy
 *
 * @brief   Send COMMAND_SE_DEVICE_MGMT_GET_CHANGE_OF_TENANCY (send with no payload).
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
#define zclSE_DeviceMgmtSendGetChangeOfTenancy( srcEP, dstAddr, disableDefaultRsp, seqNum ) \
  zcl_SendCommand( srcEP, dstAddr, ZCL_CLUSTER_ID_SE_DEVICE_MGMT,                           \
                   COMMAND_SE_DEVICE_MGMT_GET_CHANGE_OF_TENANCY, TRUE,                      \
                   ZCL_FRAME_CLIENT_SERVER_DIR,                                             \
                   disableDefaultRsp, 0, seqNum, 0, NULL );

/**************************************************************************************************
 * @fn      zclSE_DeviceMgmtSendGetChangeOfSupplier
 *
 * @brief   Send COMMAND_SE_DEVICE_MGMT_GET_CHANGE_OF_SUPPLIER (send with no payload).
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
#define zclSE_DeviceMgmtSendGetChangeOfSupplier( srcEP, dstAddr, disableDefaultRsp, seqNum ) \
  zcl_SendCommand( srcEP, dstAddr, ZCL_CLUSTER_ID_SE_DEVICE_MGMT,                            \
                   COMMAND_SE_DEVICE_MGMT_GET_CHANGE_OF_SUPPLIER, TRUE,                      \
                   ZCL_FRAME_CLIENT_SERVER_DIR,                                              \
                   disableDefaultRsp, 0, seqNum, 0, NULL );

/**************************************************************************************************
 * @fn      zclSE_DeviceMgmtSendReqNewPW
 *
 * @brief   Send COMMAND_SE_DEVICE_MGMT_REQ_NEW_PW.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_DeviceMgmtSendReqNewPW( uint8_t srcEP, afAddrType_t *dstAddr,
                                               zclSE_DeviceMgmtReqNewPW_t *pCmd,
                                               uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_DeviceMgmtSendGetSiteID
 *
 * @brief   Send COMMAND_SE_DEVICE_MGMT_GET_SITE_ID (send with no payload).
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
#define zclSE_DeviceMgmtSendGetSiteID( srcEP, dstAddr, disableDefaultRsp, seqNum ) \
  zcl_SendCommand( srcEP, dstAddr, ZCL_CLUSTER_ID_SE_DEVICE_MGMT,                  \
                   COMMAND_SE_DEVICE_MGMT_GET_SITE_ID, TRUE,                       \
                   ZCL_FRAME_CLIENT_SERVER_DIR,                                    \
                   disableDefaultRsp, 0, seqNum, 0, NULL );

/**************************************************************************************************
 * @fn      zclSE_DeviceMgmtSendReportEvtCfg
 *
 * @brief   Send COMMAND_SE_DEVICE_MGMT_REPORT_EVT_CFG.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_DeviceMgmtSendReportEvtCfg( uint8_t srcEP, afAddrType_t *dstAddr,
                                                   zclSE_DeviceMgmtReportEvtCfg_t *pCmd,
                                                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_DeviceMgmtSendGetCIN
 *
 * @brief   Send COMMAND_SE_DEVICE_MGMT_GET_CIN (send with no payload).
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
#define zclSE_DeviceMgmtSendGetCIN( srcEP, dstAddr, disableDefaultRsp, seqNum ) \
  zcl_SendCommand( srcEP, dstAddr, ZCL_CLUSTER_ID_SE_DEVICE_MGMT,               \
                   COMMAND_SE_DEVICE_MGMT_GET_CIN, TRUE,                        \
                   ZCL_FRAME_CLIENT_SERVER_DIR,                                 \
                   disableDefaultRsp, 0, seqNum, 0, NULL );

/**************************************************************************************************
 * @fn      zclSE_DeviceMgmtParsePublishChangeOfTenancy
 *
 * @brief   Parse COMMAND_SE_DEVICE_MGMT_PUBLISH_CHANGE_OF_TENANCY.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_DeviceMgmtParsePublishChangeOfTenancy(
                   zclIncoming_t *pInMsg,
                   zclSE_DeviceMgmtPublishChangeOfTenancy_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_DeviceMgmtParsePublishChangeOfSupplier
 *
 * @brief   Parse COMMAND_SE_DEVICE_MGMT_PUBLISH_CHANGE_OF_SUPPLIER.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_DeviceMgmtParsePublishChangeOfSupplier(
                   zclIncoming_t *pInMsg,
                   zclSE_DeviceMgmtPublishChangeOfSupplier_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_DeviceMgmtParseReqNewPWRsp
 *
 * @brief   Parse COMMAND_SE_DEVICE_MGMT_REQ_NEW_PW_RSP.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_DeviceMgmtParseReqNewPWRsp( zclIncoming_t *pInMsg,
                                                   zclSE_DeviceMgmtReqNewPWRsp_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_DeviceMgmtParseUpdateSiteID
 *
 * @brief   Parse COMMAND_SE_DEVICE_MGMT_UPDATE_SITE_ID.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_DeviceMgmtParseUpdateSiteID(
                   zclIncoming_t *pInMsg,
                   zclSE_DeviceMgmtUpdateSiteID_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_DeviceMgmtParseSetEvtCfg
 *
 * @brief   Parse COMMAND_SE_DEVICE_MGMT_SET_EVT_CFG.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_DeviceMgmtParseSetEvtCfg( zclIncoming_t *pInMsg,
                                                 zclSE_DeviceMgmtSetEvtCfg_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_DeviceMgmtParseGetEvtCfg
 *
 * @brief   Parse COMMAND_SE_DEVICE_MGMT_GET_EVT_CFG.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_DeviceMgmtParseGetEvtCfg( zclIncoming_t *pInMsg,
                                                 zclSE_DeviceMgmtGetEvtCfg_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_DeviceMgmtParseUpdateCIN
 *
 * @brief   Parse COMMAND_SE_DEVICE_MGMT_UPDATE_CIN.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_DeviceMgmtParseUpdateCIN( zclIncoming_t *pInMsg,
                                                 zclSE_DeviceMgmtUpdateCIN_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_DeviceMgmtParseReqNewPW
 *
 * @brief   Parse COMMAND_SE_DEVICE_MGMT_REQ_NEW_PW.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_DeviceMgmtParseReqNewPW( zclIncoming_t *pInMsg,
                                                zclSE_DeviceMgmtReqNewPW_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_DeviceMgmtParseReportEvtCfg
 *
 * @brief   Parse COMMAND_SE_DEVICE_MGMT_REPORT_EVT_CFG.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_DeviceMgmtParseReportEvtCfg(
                   zclIncoming_t *pInMsg,
                   zclSE_DeviceMgmtReportEvtCfg_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_DeviceMgmtHdlPublishChangeOfTenancy
 *
 * @brief   Handle COMMAND_SE_DEVICE_MGMT_PUBLISH_CHANGE_OF_TENANCY.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_DeviceMgmtHdlPublishChangeOfTenancy(
                   zclIncoming_t *pInMsg,
                   zclSE_DeviceMgmtPublishChangeOfTenancyCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_DeviceMgmtHdlPublishChangeOfSupplier
 *
 * @brief   Handle COMMAND_SE_DEVICE_MGMT_PUBLISH_CHANGE_OF_SUPPLIER.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_DeviceMgmtHdlPublishChangeOfSupplier(
                   zclIncoming_t *pInMsg,
                   zclSE_DeviceMgmtPublishChangeOfSupplierCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_DeviceMgmtHdlReqNewPWRsp
 *
 * @brief   Handle COMMAND_SE_DEVICE_MGMT_REQ_NEW_PW_RSP.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_DeviceMgmtHdlReqNewPWRsp( zclIncoming_t *pInMsg,
                                                 zclSE_DeviceMgmtReqNewPWRspCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_DeviceMgmtHdlUpdateSiteID
 *
 * @brief   Handle COMMAND_SE_DEVICE_MGMT_UPDATE_SITE_ID.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_DeviceMgmtHdlUpdateSiteID( zclIncoming_t *pInMsg,
                                                  zclSE_DeviceMgmtUpdateSiteID_CB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_DeviceMgmtHdlSetEvtCfg
 *
 * @brief   Handle COMMAND_SE_DEVICE_MGMT_SET_EVT_CFG.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_DeviceMgmtHdlSetEvtCfg( zclIncoming_t *pInMsg,
                                               zclSE_DeviceMgmtSetEvtCfgCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_DeviceMgmtHdlGetEvtCfg
 *
 * @brief   Handle COMMAND_SE_DEVICE_MGMT_GET_EVT_CFG.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_DeviceMgmtHdlGetEvtCfg( zclIncoming_t *pInMsg,
                                               zclSE_DeviceMgmtGetEvtCfgCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_DeviceMgmtHdlUpdateCIN
 *
 * @brief   Handle COMMAND_SE_DEVICE_MGMT_UPDATE_CIN.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_DeviceMgmtHdlUpdateCIN( zclIncoming_t *pInMsg,
                                               zclSE_DeviceMgmtUpdateCIN_CB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_DeviceMgmtHdlGetChangeOfTenancy
 *
 * @brief   Handle COMMAND_SE_DEVICE_MGMT_GET_CHANGE_OF_TENANCY (handle with no payload).
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_DeviceMgmtHdlGetChangeOfTenancy(
                   zclIncoming_t *pInMsg,
                   zclSE_DeviceMgmtGetChangeOfTenancyCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_DeviceMgmtHdlGetChangeOfSupplier
 *
 * @brief   Handle COMMAND_SE_DEVICE_MGMT_GET_CHANGE_OF_SUPPLIER (handle with no payload).
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_DeviceMgmtHdlGetChangeOfSupplier(
                   zclIncoming_t *pInMsg,
                   zclSE_DeviceMgmtGetChangeOfSupplierCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_DeviceMgmtHdlReqNewPW
 *
 * @brief   Handle COMMAND_SE_DEVICE_MGMT_REQ_NEW_PW.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_DeviceMgmtHdlReqNewPW( zclIncoming_t *pInMsg,
                                              zclSE_DeviceMgmtReqNewPW_CB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_DeviceMgmtHdlGetSiteID
 *
 * @brief   Handle COMMAND_SE_DEVICE_MGMT_GET_SITE_ID (handle with no payload).
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_DeviceMgmtHdlGetSiteID( zclIncoming_t *pInMsg,
                                               zclSE_DeviceMgmtGetSiteID_CB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_DeviceMgmtHdlReportEvtCfg
 *
 * @brief   Handle COMMAND_SE_DEVICE_MGMT_REPORT_EVT_CFG.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_DeviceMgmtHdlReportEvtCfg( zclIncoming_t *pInMsg,
                                                  zclSE_DeviceMgmtReportEvtCfgCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_DeviceMgmtHdlGetCIN
 *
 * @brief   Handle COMMAND_SE_DEVICE_MGMT_GET_CIN (handle with no payload).
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_DeviceMgmtHdlGetCIN( zclIncoming_t *pInMsg,
                                            zclSE_DeviceMgmtGetCIN_CB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_DeviceMgmtHdlClientCmd
 *
 * @brief   Client command handler for ZCL_CLUSTER_ID_SE_DEVICE_MGMT.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCBs - client callbacks
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_DeviceMgmtHdlClientCmd( zclIncoming_t *pInMsg,
                                               const zclSE_DeviceMgmtClientCBs_t *pCBs );

/**************************************************************************************************
 * @fn      zclSE_DeviceMgmtHdlServerCmd
 *
 * @brief   Server command handler for ZCL_CLUSTER_ID_SE_DEVICE_MGMT.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCBs - server callbacks
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_DeviceMgmtHdlServerCmd( zclIncoming_t *pInMsg,
                                               const zclSE_DeviceMgmtServerCBs_t *pCBs );

/**************************************************************************************************
 * @fn      zclSE_DeviceMgmtEvtParse
 *
 * @brief   Utility function for parsing "pEvts" payload -- see "zclSE_DeviceMgmtReportEvtCfg_t"
 *
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_DeviceMgmtEvtParse( zclSE_DeviceMgmtReportEvtCfg_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_EventsSendPublishEvt
 *
 * @brief   Send COMMAND_SE_EVENTS_PUBLISH_EVT.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_EventsSendPublishEvt( uint8_t srcEP, afAddrType_t *dstAddr,
                                             zclSE_EventsPublishEvt_t *pCmd,
                                             uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_EventsSendPublishEvtLog
 *
 * @brief   Send COMMAND_SE_EVENTS_PUBLISH_EVT_LOG.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_EventsSendPublishEvtLog( uint8_t srcEP, afAddrType_t *dstAddr,
                                                zclSE_EventsPublishEvtLog_t *pCmd,
                                                uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_EventsSendClearEvtLogRsp
 *
 * @brief   Send COMMAND_SE_EVENTS_CLEAR_EVT_LOG_RSP.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_EventsSendClearEvtLogRsp( uint8_t srcEP, afAddrType_t *dstAddr,
                                                 zclSE_EventsClearEvtLogRsp_t *pCmd,
                                                 uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_EventsSendGetEvtLog
 *
 * @brief   Send COMMAND_SE_EVENTS_GET_EVT_LOG.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_EventsSendGetEvtLog( uint8_t srcEP, afAddrType_t *dstAddr,
                                            zclSE_EventsGetEvtLog_t *pCmd,
                                            uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_EventsSendClearEvtLog
 *
 * @brief   Send COMMAND_SE_EVENTS_CLEAR_EVT_LOG.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_EventsSendClearEvtLog( uint8_t srcEP, afAddrType_t *dstAddr,
                                              zclSE_EventsClearEvtLog_t *pCmd,
                                              uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_EventsParsePublishEvt
 *
 * @brief   Parse COMMAND_SE_EVENTS_PUBLISH_EVT.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_EventsParsePublishEvt( zclIncoming_t *pInMsg,
                                              zclSE_EventsPublishEvt_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_EventsParsePublishEvtLog
 *
 * @brief   Parse COMMAND_SE_EVENTS_PUBLISH_EVT_LOG.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_EventsParsePublishEvtLog( zclIncoming_t *pInMsg,
                                                 zclSE_EventsPublishEvtLog_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_EventsParseClearEvtLogRsp
 *
 * @brief   Parse COMMAND_SE_EVENTS_CLEAR_EVT_LOG_RSP.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_EventsParseClearEvtLogRsp( zclIncoming_t *pInMsg,
                                                  zclSE_EventsClearEvtLogRsp_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_EventsParseGetEvtLog
 *
 * @brief   Parse COMMAND_SE_EVENTS_GET_EVT_LOG.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_EventsParseGetEvtLog( zclIncoming_t *pInMsg,
                                             zclSE_EventsGetEvtLog_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_EventsParseClearEvtLog
 *
 * @brief   Parse COMMAND_SE_EVENTS_CLEAR_EVT_LOG.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_EventsParseClearEvtLog( zclIncoming_t *pInMsg,
                                               zclSE_EventsClearEvtLog_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_EventsHdlPublishEvt
 *
 * @brief   Handle COMMAND_SE_EVENTS_PUBLISH_EVT.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_EventsHdlPublishEvt( zclIncoming_t *pInMsg,
                                            zclSE_EventsPublishEvtCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_EventsHdlPublishEvtLog
 *
 * @brief   Handle COMMAND_SE_EVENTS_PUBLISH_EVT_LOG.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_EventsHdlPublishEvtLog( zclIncoming_t *pInMsg,
                                               zclSE_EventsPublishEvtLogCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_EventsHdlClearEvtLogRsp
 *
 * @brief   Handle COMMAND_SE_EVENTS_CLEAR_EVT_LOG_RSP.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_EventsHdlClearEvtLogRsp( zclIncoming_t *pInMsg,
                                                zclSE_EventsClearEvtLogRspCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_EventsHdlGetEvtLog
 *
 * @brief   Handle COMMAND_SE_EVENTS_GET_EVT_LOG.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_EventsHdlGetEvtLog( zclIncoming_t *pInMsg,
                                           zclSE_EventsGetEvtLogCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_EventsHdlClearEvtLog
 *
 * @brief   Handle COMMAND_SE_EVENTS_CLEAR_EVT_LOG.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_EventsHdlClearEvtLog( zclIncoming_t *pInMsg,
                                             zclSE_EventsClearEvtLogCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_EventsHdlClientCmd
 *
 * @brief   Client command handler for ZCL_CLUSTER_ID_SE_EVENTS.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCBs - client callbacks
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_EventsHdlClientCmd( zclIncoming_t *pInMsg,
                                           const zclSE_EventsClientCBs_t *pCBs );

/**************************************************************************************************
 * @fn      zclSE_EventsHdlServerCmd
 *
 * @brief   Server command handler for ZCL_CLUSTER_ID_SE_EVENTS.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCBs - server callbacks
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_EventsHdlServerCmd( zclIncoming_t *pInMsg,
                                           const zclSE_EventsServerCBs_t *pCBs );

/**************************************************************************************************
 * @fn      zclSE_EventsEvtLogParse
 *
 * @brief   Utility function for parsing an event log in the COMMAND_SE_EVENTS_PUBLISH_EVT_LOG
 *          payload.
 *
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_EventsEvtLogParse( zclSE_EventsPublishEvtLog_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_EnergyMgmtSendReportEvtStatus
 *
 * @brief   Send COMMAND_SE_ENERGY_MGMT_REPORT_EVT_STATUS.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_EnergyMgmtSendReportEvtStatus(
                   uint8_t srcEP, afAddrType_t *dstAddr,
                   zclSE_EnergyMgmtReportEvtStatus_t *pCmd,
                   uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_EnergyMgmtSendManageEvt
 *
 * @brief   Send COMMAND_SE_ENERGY_MGMT_MANAGE_EVT.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_EnergyMgmtSendManageEvt( uint8_t srcEP, afAddrType_t *dstAddr,
                                                zclSE_EnergyMgmtManageEvt_t *pCmd,
                                                uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_EnergyMgmtParseReportEvtStatus
 *
 * @brief   Parse COMMAND_SE_ENERGY_MGMT_REPORT_EVT_STATUS.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_EnergyMgmtParseReportEvtStatus(
                   zclIncoming_t *pInMsg,
                   zclSE_EnergyMgmtReportEvtStatus_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_EnergyMgmtParseManageEvt
 *
 * @brief   Parse COMMAND_SE_ENERGY_MGMT_MANAGE_EVT.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_EnergyMgmtParseManageEvt( zclIncoming_t *pInMsg,
                                                 zclSE_EnergyMgmtManageEvt_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_EnergyMgmtHdlReportEvtStatus
 *
 * @brief   Handle COMMAND_SE_ENERGY_MGMT_REPORT_EVT_STATUS.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_EnergyMgmtHdlReportEvtStatus(
                   zclIncoming_t *pInMsg,
                   zclSE_EnergyMgmtReportEvtStatusCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_EnergyMgmtHdlManageEvt
 *
 * @brief   Handle COMMAND_SE_ENERGY_MGMT_MANAGE_EVT.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_EnergyMgmtHdlManageEvt( zclIncoming_t *pInMsg,
                                               zclSE_EnergyMgmtManageEvtCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_EnergyMgmtHdlClientCmd
 *
 * @brief   Client command handler for ZCL_CLUSTER_ID_SE_ENERGY_MGMT.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCBs - client callbacks
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_EnergyMgmtHdlClientCmd( zclIncoming_t *pInMsg,
                                               const zclSE_EnergyMgmtClientCBs_t *pCBs );

/**************************************************************************************************
 * @fn      zclSE_EnergyMgmtHdlServerCmd
 *
 * @brief   Server command handler for ZCL_CLUSTER_ID_SE_ENERGY_MGMT.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCBs - server callbacks
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_EnergyMgmtHdlServerCmd( zclIncoming_t *pInMsg,
                                               const zclSE_EnergyMgmtServerCBs_t *pCBs );

/**************************************************************************************************
 * @fn      zclSE_MDUPairingSendPairingRsp
 *
 * @brief   Send COMMAND_SE_MDU_PAIRING_PAIRING_RSP.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MDUPairingSendPairingRsp( uint8_t srcEP, afAddrType_t *dstAddr,
                                                 zclSE_MDUPairingPairingRsp_t *pCmd,
                                                 uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_MDUPairingSendPairingReq
 *
 * @brief   Send COMMAND_SE_MDU_PAIRING_PAIRING_REQ.
 *
 * @param   srcEP - sending application's endpoint
 * @param   dstAddr - destination address
 * @param   pCmd - command payload
 * @param   disableDefaultRsp - disable default response
 * @param   seqNum - sequence number
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MDUPairingSendPairingReq( uint8_t srcEP, afAddrType_t *dstAddr,
                                                 zclSE_MDUPairingPairingReq_t *pCmd,
                                                 uint8_t disableDefaultRsp, uint8_t seqNum );

/**************************************************************************************************
 * @fn      zclSE_MDUPairingParsePairingRsp
 *
 * @brief   Parse COMMAND_SE_MDU_PAIRING_PAIRING_RSP.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MDUPairingParsePairingRsp( zclIncoming_t *pInMsg,
                                                  zclSE_MDUPairingPairingRsp_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_MDUPairingParsePairingReq
 *
 * @brief   Parse COMMAND_SE_MDU_PAIRING_PAIRING_REQ.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MDUPairingParsePairingReq( zclIncoming_t *pInMsg,
                                                  zclSE_MDUPairingPairingReq_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_MDUPairingHdlPairingRsp
 *
 * @brief   Handle COMMAND_SE_MDU_PAIRING_PAIRING_RSP.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MDUPairingHdlPairingRsp( zclIncoming_t *pInMsg,
                                                zclSE_MDUPairingPairingRspCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_MDUPairingHdlPairingReq
 *
 * @brief   Handle COMMAND_SE_MDU_PAIRING_PAIRING_REQ.
 *
 * @param   pInMsg - incoming message to process
 * @param   pfnCB - command callback
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MDUPairingHdlPairingReq( zclIncoming_t *pInMsg,
                                                zclSE_MDUPairingPairingReqCB_t pfnCB );

/**************************************************************************************************
 * @fn      zclSE_MDUPairingHdlClientCmd
 *
 * @brief   Client command handler for ZCL_CLUSTER_ID_SE_MDU_PAIRING.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCBs - client callbacks
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MDUPairingHdlClientCmd( zclIncoming_t *pInMsg,
                                               const zclSE_MDUPairingClientCBs_t *pCBs );

/**************************************************************************************************
 * @fn      zclSE_MDUPairingHdlServerCmd
 *
 * @brief   Server command handler for ZCL_CLUSTER_ID_SE_MDU_PAIRING.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCBs - server callbacks
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MDUPairingHdlServerCmd( zclIncoming_t *pInMsg,
                                               const zclSE_MDUPairingServerCBs_t *pCBs );

/**************************************************************************************************
 * @fn      zclSE_MDUPairingDevicesParse
 *
 * @brief   Utility function for parsing "pDevices" payload -- see "zclSE_MDUPairingPairingRsp_t"
 *
 * @param   pCmd - command payload
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_MDUPairingDevicesParse( zclSE_MDUPairingPairingRsp_t *pCmd );

/**************************************************************************************************
 * @fn      zclSE_HdlSpecificCmd
 *
 * @brief   Standard ZCL SE specific command handler.  This function is safe to call within the
 *          context of zclSE_HdlSpecificCmdHook.
 *
 * @param   pInMsg - incoming message to process
 * @param   pCBs - callbacks
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_HdlSpecificCmd( zclIncoming_t *pInMsg, zclSE_AppCallbacks_t *pCBs );

/**************************************************************************************************
 * @fn      zclSE_HdlAppSpecificCmd
 *
 * @brief   Handles ZCL SE specific commands, first looking up the endpoint callbacks and then
 *          calling zclSE_HdlSpecificCmd.  Application callbacks are registered via
 *          zclSE_RegisterCmdCallbacks.  This function is safe to call within the context of
 *          zclSE_HdlSpecificCmdHook.
 *
 * @param   pInMsg - incoming message to process
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_HdlAppSpecificCmd( zclIncoming_t *pInMsg );

/**************************************************************************************************
 * @fn      zclSE_HdlSpecificCmdHook
 *
 * @brief   Hook to override standard ZCL SE specific command handling, see zclSE_RegisterPlugin.
 *          Implement zclSE_HdlSpecificCmdHook and define ZCL_SE_HDL_SPECIFIC_CMD_HOOK.  Within the
 *          context of zclSE_HdlSpecificCmdHook, any of the zclSE_*Hdl* functions can be called
 *          safely.
 *
 * @param   pInMsg - incoming message to process
 *
 * @return  ZStatus_t
 */
extern ZStatus_t zclSE_HdlSpecificCmdHook( zclIncoming_t *pInMsg );

/**************************************************************************************************
 * @fn      zclSE_RegisterPlugin
 *
 * @brief   Register the SE plugin with ZCL.  If the application calls zclSE_RegisterCmdCallbacks,
 *          zclSE_RegisterPlugin will be called internally.  But if the application uses
 *          the ZCL_SE_HDL_SPECIFIC_CMD_HOOK, the application must call zclSE_RegisterPlugin during
 *          application initialization.
 *
 * @param   void
 *
 * @return  void
 */
extern void zclSE_RegisterPlugin( void );

/**************************************************************************************************
 * @fn      zclSE_RegisterCmdCallbacks
 *
 * @brief   Register application command callbacks.
 *
 * @param   appEP - application endpoint
 * @param   pCBs - callbacks
 *
 * @return  ZStatus_t - (ZMemError if not able to allocate)
 */
extern ZStatus_t zclSE_RegisterCmdCallbacks( uint8_t appEP, zclSE_AppCallbacks_t *pCBs );

/**************************************************************************************************
 * @fn      zclSE_RegisterUnsupportCallback
 *
 * @brief   Register an callback for unsupport endpoint
 *
 * @param   callback - pointer to the callback record.
 *
 * @return  NONE
 */
extern void zclSE_RegisterUnsupportCallback( ZStatus_t (*callback)(zclIncoming_t*pInMsg) );

/**************************************************************************************************
**************************************************************************************************/

#ifdef __cplusplus
}
#endif

#endif /* ZCL_SE_H */
