/*
 * Copyright (c) 2016-2020, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*
 *  ======== timerled.c ========
 */

#include <ti/devices/DeviceFamily.h>
#include DeviceFamily_constructPath(inc/hw_gpt.h)
#include DeviceFamily_constructPath(driverlib/timer.h)

#include <stddef.h>

/* Driver Header files */
#include <ti/drivers/GPIO.h>
#include <ti/drivers/Timer.h>

/* Board Header file */
#include "ti_drivers_config.h"

/* Callback used for toggling the LED. */
void timerCallback(Timer_Handle myHandle, int_fast16_t status);
void timer1Callback(Timer_Handle myHandle, int_fast16_t status);

volatile uint8_t timer_0_flag = 0;
uint32_t timer_0_count = 0;

volatile uint8_t timer_1_flag = 0;
uint32_t timer_1_count = 0;
int32_t timer1_status = 0;
int32_t timer0_status = 0;

Timer_Handle timer0,timer1;
Timer_Params params,params1;

/*
 *  ======== mainThread ========
 */
void *mainThread(void *arg0)
{
    uint32_t i =0;

    /* Call driver init functions */
    GPIO_init();
    Timer_init();

    /* Configure the LED pin */
    GPIO_setConfig(CONFIG_GPIO_LED_0, GPIO_CFG_OUT_STD | GPIO_CFG_OUT_LOW);
    //GPIO_setConfig(CONFIG_GPIO_LED_1, GPIO_CFG_OUT_STD | GPIO_CFG_OUT_LOW);

    /* Turn off user LED */
    GPIO_write(CONFIG_GPIO_LED_0, CONFIG_GPIO_LED_OFF);
    //GPIO_write(CONFIG_GPIO_LED_1, CONFIG_GPIO_LED_OFF);


    /*
     * Setting up the timer in continuous callback mode that calls the callback
     * function every 1,000,000 microseconds, or 1 second.
     */
    Timer_Params_init(&params);
    params.period        = 10000;
    params.periodUnits   = Timer_PERIOD_US;
    params.timerMode     = Timer_ONESHOT_CALLBACK; //Timer_CONTINUOUS_CALLBACK;
    params.timerCallback = timerCallback;

    Timer_Params_init(&params1);
    params1.period        = 65000;
    params1.periodUnits   = Timer_PERIOD_US;
    params1.timerMode     = Timer_CONTINUOUS_CALLBACK;
    params1.timerCallback = timer1Callback;

    timer0 = Timer_open(CONFIG_TIMER_0, &params);


    if (timer0 == NULL)
    {
        /* Failed to initialized timer */
        while (1) {}
    }

    timer1 = Timer_open(CONFIG_TIMER_1, &params1);

    if (timer1 == NULL)
    {
        /* Failed to initialized timer */
        while (1) {}
    }


    if (Timer_start(timer1) == Timer_STATUS_ERROR)
    {
        /* Failed to start timer */
        while (1) {}
    }

    if (Timer_start(timer0) == Timer_STATUS_ERROR)
    {
        /* Failed to start timer */
        while (1) {}
    }


#if 0
    Timer_stop(timer1);
    timer_1_count = 0;
    timer_1_flag = 0;
    Timer_setPeriod(timer1,Timer_PERIOD_US,3000);
    if (Timer_start(timer1) == Timer_STATUS_ERROR)
    {
        /* Failed to start timer */
        while (1) {}
    }


    while(1)
    {

        if(timer_0_flag == 1)
        {
            Timer_stop(timer0);
            Timer_stop(timer1);
            while(1);
        }
    }
#endif


#if 1
            while(timer_0_flag == 0)
            {

            }

            Timer_stop(timer1);
            Timer_setPeriod(timer1,Timer_PERIOD_US,3000);
            HWREG(0x40011050) = 0xFFFFFFFF;
            HWREG(0x40011054) = 0xFFFFFFFF;
            timer1_status = Timer_start(timer1);
            if (timer1_status == Timer_STATUS_ERROR) {
                //Timer_start() failed
                //Display_printf("timer1 start error!\r\n");
                while (1);
            }

#if 1
        if(timer_1_flag ==1)
        {
            timer_1_flag = 0;
            //Timer_stop(timer_1_handle);
            //while(1);
        }
#endif

#endif

    while (1);

    return (NULL);
}

/*
 * This callback is called every 1,000,000 microseconds, or 1 second. Because
 * the LED is toggled each time this function is called, the LED will blink at
 * a rate of once every 2 seconds.
 */
void timerCallback(Timer_Handle myHandle, int_fast16_t status)
{
    timer_0_flag = 1;
    timer_0_count++;
    GPIO_toggle(CONFIG_GPIO_LED_0);

}

void timer1Callback(Timer_Handle myHandle, int_fast16_t status)
{
    timer_1_flag = 1;
    timer_1_count++;
    //GPIO_toggle(CONFIG_GPIO_LED_1);
}
