/*
 * Copyright (c) 2018, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

/*
 *                           ti_zstack_config.h
 *
 *  DO NOT EDIT - This file was generated by the SysConfig tool.
 *
 *  Macros used to define a TI Z-Stack ZigBee device. New user defined
 *  options may be added to this file, as necessary.
 *
 */

#ifndef TI_ZSTACK_CONFIG_H
#define TI_ZSTACK_CONFIG_H

/* Default (primary) and secondary channel masks. Secondary mask is used when the
 * default channels fail.
 * Channels are defined in the following:
 *        11 - 26 : 2.4 GHz     0x07FFF800
 */
#ifndef DEFAULT_CHANLIST
#define DEFAULT_CHANLIST              0x00000800
#endif

#ifndef SECONDARY_CHANLIST
#define SECONDARY_CHANLIST            0x00000000
#endif

/* Define the default PAN ID.
 *
 * Setting this to a value other than 0xFFFF causes
 * ZDO_COORD to use this value as its PAN ID and
 * Routers and end devices to join PAN with this ID
 */
#ifndef ZDAPP_CONFIG_PAN_ID
#define ZDAPP_CONFIG_PAN_ID           0xFFFF
#endif

/* Specifiy whether to set the EPID to the Extended Address, or to use the
 * custom Extended Pan ID (EPID) defined by ZDAPP_CONFIG_EPID
 */
#ifndef SET_EPID_AS_EXT_ADDR
#define SET_EPID_AS_EXT_ADDR          TRUE
#endif

/* Define the default Extended Pan ID (EPID)
 * ZDAPP_CONFIG_EPID is only used if SET_EPID_AS_EXT_ADDR is FALSE. Otherwise,
 * the EPID is set to the Extended Address.
 */
#ifndef ZDAPP_CONFIG_EPID
#define ZDAPP_CONFIG_EPID             {0x01,0x23,0x45,0x67,0x89,0xAB,0xCD,0xEF}
#endif

/* in seconds; set to 255 to turn off route expiry */
#ifndef ROUTE_EXPIRY_TIME
#define ROUTE_EXPIRY_TIME             30
#endif

/*  Default indirect message holding timeout value:
 *  1-65535 (0 -> 65536) X CNT_RTG_TIMER X RTG_TIMER_INTERVAL
 */
#ifndef NWK_INDIRECT_MSG_TIMEOUT
#define NWK_INDIRECT_MSG_TIMEOUT      7
#endif

/* The number of simultaneous route discoveries in network */
#ifndef MAX_RREQ_ENTRIES
#define MAX_RREQ_ENTRIES              8
#endif

/* The maximum number of MAC frame transmission attempts allowed */
#ifndef ZMAC_MAX_FRAME_RETRIES
#define ZMAC_MAX_FRAME_RETRIES          3
#endif

/* Max number of times attempts looking for the next hop address of a message */
#ifndef NWK_MAX_DATA_RETRIES
#define NWK_MAX_DATA_RETRIES          2
#endif

/* The maximum number of times APS frames are retried after not receiving an APS ACK */
#ifndef APSC_MAX_FRAME_RETRIES
#define APSC_MAX_FRAME_RETRIES        3
#endif

/* This number is used by polled devices, since the spec'd formula
 * doesn't work for sleeping end devices.  For non-polled devices,
 * a formula is used. Value is in 2 milliseconds periods
 */
#ifndef APSC_ACK_WAIT_DURATION_POLLED
#define APSC_ACK_WAIT_DURATION_POLLED 3000
#endif

/* The maximum number of groups in the groups table */
#ifndef APS_MAX_GROUPS
#define APS_MAX_GROUPS                16
#endif

/* Number of entries in the regular routing table plus additional
 * entries for route repair
 */
#ifndef MAX_RTG_ENTRIES
#define MAX_RTG_ENTRIES               40
#endif

/* Maximum number of entries in the Binding table. */
#ifndef NWK_MAX_BINDING_ENTRIES
#define NWK_MAX_BINDING_ENTRIES       4
#endif

/* Default security key. */
#ifndef DEFAULT_KEY
#define DEFAULT_KEY                   {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00}
#endif

/* ZigBee Alliance Pre-configured Distributed Link Key (for Distributed networks) */
#ifndef DISTRIBUTED_GLOBAL_LINK_KEY
#define DISTRIBUTED_GLOBAL_LINK_KEY   {0xD0,0xD1,0xD2,0xD3,0xD4,0xD5,0xD6,0xD7,0xD8,0xD9,0xDA,0xDB,0xDC,0xDD,0xDE,0xDF}
#endif

/* ZigBee Alliance Pre-configured TC Link Key - 'ZigBeeAlliance09' (for Centralized networks) */
#ifndef DEFAULT_TC_LINK_KEY
#define DEFAULT_TC_LINK_KEY           {0x5a,0x69,0x67,0x42,0x65,0x65,0x41,0x6c,0x6c,0x69,0x61,0x6e,0x63,0x65,0x30,0x39}
#endif

/* The number of milliseconds to wait between data request polls to the coordinator. */
#ifndef TXPOWER
#define TXPOWER                     0
#endif

/****************************************
 * The following are for End Devices only
 ***************************************/

/* Determine whether the radio on an End Device is always on */
#ifndef RFD_RX_ALWAYS_ON_CAPABLE
#define RFD_RX_ALWAYS_ON_CAPABLE            TRUE
#endif

#ifndef RFD_RX_ALWAYS_ON
#define RFD_RX_ALWAYS_ON                    FALSE
#endif

/* The minimum poll rate. */
#ifndef MINIMUM_APP_POLL_RATE
#define MINIMUM_APP_POLL_RATE                     100
#endif

/* The number of milliseconds to wait between data request polls to the coordinator. */
#ifndef POLL_RATE
#define POLL_RATE                     3000
#endif

/* This is used after receiving a data indication to poll immediately
 * for queued messages...in milliseconds.
 */
#ifndef QUEUED_POLL_RATE
#define QUEUED_POLL_RATE              100
#endif

/* This is used after receiving a data confirmation to poll immediately
 * for response messages...in milliseconds
 */
#ifndef RESPONSE_POLL_RATE
#define RESPONSE_POLL_RATE            100
#endif

/* This is used as an alternate response poll rate only for rejoin request.
 * This rate is determined by the response time of the parent that the device
 * is trying to join.
 */
#ifndef REJOIN_POLL_RATE
#define REJOIN_POLL_RATE              440
#endif

/* Maximum number of devices in the Assoc/Device list. */
#ifndef NWK_MAX_DEVICE_LIST
#define NWK_MAX_DEVICE_LIST           20
#endif

/* Total Number of APS keys that a TC can manage. This is equal to the number of devices a ZC can allow to join the network */
#ifndef ZDSECMGR_TC_DEVICE_MAX
#define ZDSECMGR_TC_DEVICE_MAX        40
#endif

/* Value used by end device when sending End Device Timeout Request */
/* This is an index into table timeoutValue[] defined in nwk_globals.c */
#ifndef END_DEV_TIMEOUT_VALUE
#define END_DEV_TIMEOUT_VALUE        8
#endif





#endif /* TI_ZSTACK_CONFIG_H */
