			.thumb

			.text
			.align  2
cnt			.field 0x2000012c,32	; delay counter
led			.field 0x20000130,32	; led state (0 => off, 1 => on)
p1in		.field 0x40004c00,32	; port 1 input
p1out		.field 0x40004c02,32	; port 1 output
p1dir		.field 0x40004c04,32	; port 1 direction
p1ren		.field 0x40004c06,32	; port 1 resistor enable
p1ds		.field 0x40004c08,32	; port 1 drive strength
p1sel0		.field 0x40004c0a,32	; port 1 select 0
p1sel1		.field 0x40004c0c,32	; port 1 select 1

			.global main
			.thumbfunc main

main:		.asmfunc
	bl		port1_init				; initialize port 1
	bl		led_on					; turn on led

loop								; main loop
	bl		delay_sr				; delay ~1ms
	bl		port1_input				; read the switch
	cmp		r0, #0x00				; r0 == 0x00?
    beq		sw_pressed				; if so, switch pressed
    bl		led_on					; turn on led
	b		loop

sw_pressed
    bl		toggle_led				; toggle led
    b		loop

	.endasmfunc

delay_sr:	.asmfunc
	ldr		r1, cnt					; point r1 to cnt
	mov		r0,#30000				; ~10 ms
wait
	subs	r0,r0,#0x01
	str		r0, [r1]				; store r0 => cnt
	bne		wait

	bx		lr
	.endasmfunc

;------------port1_init------------
; initialize gpio port 1 for negative logic switches on p1.1 and
; p1.4 as the launchpad is wired.  weak internal pull-up
; resistors are enabled.
; input: none
; output: none
; modifies: r0, r1
port1_init: .asmfunc
    ldr		r1, p1sel0
    mov		r0, #0x00				; configure p1.x as gpio
    strb	r0, [r1]
    ldr		r1, p1sel1
    mov		r0, #0x00
    strb	r0, [r1]
    ldr		r1, p1dir				; p1.x input (0) except make p1.0 output(1)
    mov		r0, #0x01
    strb	r0, [r1]
    ldr		r1, p1ren				; enable pull resistors on p1.4
    mov		r0, #0x10
    strb	r0, [r1]
    ldr		r1, p1out				; p1.4 pull-up
    mov		r0, #0x10
    strb	r0, [r1]
    bx		lr
    .endasmfunc

;------------toggle_led------------
; turen led1
; input: none
; output: none
; modifies: r0, r1
toggle_led: .asmfunc
	push    {r5-r7,lr}				; push work registers and lr
	ldr		r1, led
	ldrb	r0, [r1]
	cmp		r0, #0xfe				; r0 == 0xfe?
    beq		tog						; if so, make 0xff
    mov		r0, #0xfe
    b		skip
tog	mov		r0, #0xff
skip
	strb	r0, [r1]				; store new value ot led var
    bl		port1_output
    pop     {r5-r7,pc}				; pop work registers and pc
    bx		lr
    .endasmfunc

;------------led_on------------
; turen led1
; input: none
; output: none
; modifies: r0, r1
led_on: .asmfunc
	push    {r5-r7,lr}				; push work registers and lr
	mov		r0, #0xff				; r0 = red (red led on)
	bl		port1_output
	pop     {r5-r7,pc}				; pop work registers and pc
	bx		lr
	.endasmfunc

;------------port1_output------------
; set the output state of p1.
; input: r0  new state of p1 (only 8 least significant bits)
; output: none
; modifies: r1
port1_output: .asmfunc
    ldr		r1, p1out
    strb	r0, [r1]				; write to p1.x
    bx		lr
    .endasmfunc

;------------port1_input------------
; read and return the status of the switches.
; input: none
; output: r0  0x00 if switch 2 is pressed
;         r0  0x10 if switch 2 is not pressed
; modifies: r1
port1_input: .asmfunc
    ldr 	r1, p1in
    ldrb	r0, [r1]				; read all 8 bits of port 1
    and 	r0, r0, #0x10			; select the input pin p1.4
    bx   	lr
    .endasmfunc

	.end
