#include <msp430.h>
#include <stdint.h>

#ifndef __GPIO_H
#define __GPIO_H

#define GPIO_NUM_QUADRANTS 2

typedef void 		(*Gpio_getHandlerFunction)	( uint8_t* const );
typedef void		(*Gpio_setHandlerFunction)	( const uint8_t* const );
typedef void		(*Gpio_setPortHandler)		( volatile unsigned char* const, const unsigned char );

extern const Gpio_getHandlerFunction 	Gpio_getEnableTable[];
extern const Gpio_getHandlerFunction 	Gpio_getFeedbackTable[];
extern const Gpio_setHandlerFunction 	Gpio_setEnableTable[];
extern const Gpio_setHandlerFunction 	Gpio_setFeedbackTable[];
extern const Gpio_setPortHandler		Gpio_setPortTable[];

void Gpio_init();

// GPIO get handlers
void 				Gpio_getFeedbackQ1			( uint8_t* const );
void 				Gpio_getFeedbackQ2			( uint8_t* const );
inline void 		Gpio_getEnableQ1			( uint8_t* const );
inline void 		Gpio_getEnableQ2			( uint8_t* const );

// GPIO set handlers
void 				Gpio_setEnableQ1			( const uint8_t* const );
void 				Gpio_setEnableQ2			( const uint8_t* const );
void				Gpio_setFeedbackQ1			( const uint8_t* const );
void				Gpio_setFeedbackQ2			( const uint8_t* const );
void				Gpio_setPortOn				( volatile unsigned char* const, const unsigned char );
void				Gpio_setPortOff				( volatile unsigned char* const, const unsigned char );

#endif // __GPIO_H
