#include <msp430.h>
#include <stdint.h>

#ifndef __I2C_H
#define __I2C_H

#define I2C_NUM_SLAVES 5
#define I2C_SLAVE_BYTES	26

// I2C slave addresses
extern const uint8_t I2C_SLAVE_ADDRESS[];

//> Number of bytes per transfer
extern const uint8_t I2C_TRANSACTION_BYTES[];

extern const uint8_t I2C_BUFFER_OFFSET[];

struct I2c_t {
	uint8_t*	pBuf;		// Buffer for received data
	uint8_t		ix;			// Slave Index
	uint8_t		cb;			// Byte counter
};

void I2c_init( struct I2c_t* const, uint8_t* pBuf );
__interrupt void I2c_irqRx();
//__interrupt void I2c_irqNack();



#endif // __I2C_H
