#include "Power.h"

// Bit 0	Enable
// Bit 1	Sequencer Fault
// Bit 2	SEQ_OFF
// Bit 3	SEQ_ON
const enum PowerState_t PWR_TRANSITION_TABLE[16][PWR_NUM_STATES] =
{
	// PWR_OFF			PWR_T_ON		PWR_ON			PWR_T_OFF		PWR_FAULT		PWR_CRIT_FAULT
    {PWR_FAULT,         PWR_T_OFF,      PWR_FAULT,      PWR_FAULT,      PWR_FAULT,      PWR_CRIT_FAULT  },	// 0000
    {PWR_FAULT,         PWR_T_ON,       PWR_FAULT,      PWR_T_ON,       PWR_FAULT,      PWR_CRIT_FAULT  },	// 0001
    {PWR_FAULT,         PWR_FAULT,      PWR_FAULT,      PWR_FAULT,      PWR_CRIT_FAULT, PWR_CRIT_FAULT  },  // 0010
    {PWR_FAULT,         PWR_FAULT,      PWR_FAULT,      PWR_FAULT,      PWR_CRIT_FAULT, PWR_CRIT_FAULT  },  // 0011
    {PWR_OFF,           PWR_OFF,        PWR_FAULT,      PWR_OFF,        PWR_OFF,        PWR_OFF         },  // 0100
    {PWR_T_ON,          PWR_T_ON,       PWR_FAULT,      PWR_T_ON,       PWR_FAULT,      PWR_CRIT_FAULT  },  // 0101
    {PWR_FAULT,         PWR_FAULT,      PWR_FAULT,      PWR_FAULT,      PWR_CRIT_FAULT, PWR_CRIT_FAULT  },  // 0110
    {PWR_FAULT,         PWR_FAULT,      PWR_FAULT,      PWR_FAULT,      PWR_CRIT_FAULT, PWR_CRIT_FAULT  },  // 0111
    {PWR_CRIT_FAULT,    PWR_T_OFF,      PWR_T_OFF,      PWR_T_OFF,      PWR_FAULT,      PWR_CRIT_FAULT  },  // 1000
    {PWR_CRIT_FAULT,    PWR_ON,         PWR_ON,         PWR_T_ON,       PWR_FAULT,      PWR_CRIT_FAULT  },  // 1001
    {PWR_CRIT_FAULT,    PWR_FAULT,      PWR_FAULT,      PWR_FAULT,      PWR_CRIT_FAULT,	PWR_CRIT_FAULT  },  // 1010
    {PWR_CRIT_FAULT,    PWR_FAULT,      PWR_FAULT,      PWR_FAULT,      PWR_CRIT_FAULT,	PWR_CRIT_FAULT  },  // 1011
    {PWR_CRIT_FAULT,    PWR_CRIT_FAULT, PWR_CRIT_FAULT, PWR_CRIT_FAULT, PWR_CRIT_FAULT, PWR_CRIT_FAULT  },  // 1100
    {PWR_CRIT_FAULT,    PWR_CRIT_FAULT, PWR_CRIT_FAULT, PWR_CRIT_FAULT, PWR_CRIT_FAULT, PWR_CRIT_FAULT  },  // 1101
    {PWR_CRIT_FAULT,    PWR_CRIT_FAULT, PWR_CRIT_FAULT, PWR_CRIT_FAULT, PWR_CRIT_FAULT, PWR_CRIT_FAULT  },  // 1110
    {PWR_CRIT_FAULT,    PWR_CRIT_FAULT, PWR_CRIT_FAULT, PWR_CRIT_FAULT, PWR_CRIT_FAULT, PWR_CRIT_FAULT  }   // 1111
};

const uint8_t PWR_VENABLE_LUT[PWR_NUM_STATES] =
{
    0,  // PWR_OFF,
    1,  // PWR_T_ON,
    1,  // PWR_ON,
    0,  // PWR_T_OFF,
    0,  // PWR_FAULT,
    0   // PWR_CRIT_FAULT
};

void Power_init( struct Power_t* const p, struct Sequencer_t* const pSeq )
{
    p->enable           = 0;
    p->good				= 0;
    p->fault            = 0;
    p->input            = 0;
    p->pSequencer       = pSeq;
    p->state            = PWR_OFF;
    p->prevState        = PWR_OFF;
}

void Power_getFault( struct Power_t* const p )
{
    if ( p->prevState == PWR_OFF && p->state == PWR_T_ON ) {
        p->fault = 0;
    } else {
        p->fault |= p->pSequencer->fault;
    }
}

void Power_getInput( struct Power_t* const p )
{
    Power_getFault( p );
    p->input =  0;
    p->input += p->enable;
    p->input += ( p->pSequencer->fFault != 0 ) << 1;
    p->input += ( p->pSequencer->state == SEQ_OFF ) << 2;
    p->input += ( p->pSequencer->state == SEQ_ON ) << 3;
}

void Power_process( struct Power_t* const p )
{
    Power_getInput( p );
    p->prevState = p->state;
    p->state = PWR_TRANSITION_TABLE[ p->input ][ p->state ];
    p->pSequencer->vEnable = PWR_VENABLE_LUT[ p->state ];
    p->good = p->state == PWR_ON;
}

uint8_t Power_getFeedback( struct Power_t* const p )
{
    return ( p->state == PWR_ON );
}
