#include "Sequencer.h"

#ifndef __POWER_H
#define __POWER_H

enum PowerState_t {
    PWR_OFF,
    PWR_T_ON,
    PWR_ON,
    PWR_T_OFF,
    PWR_FAULT,
    PWR_CRIT_FAULT,
    PWR_NUM_STATES
};

struct Power_t {
    uint8_t                 enable;             // Enable from the FPGA (active high at this point, FPGA is active low, GPIO converts)
    uint8_t					good;				// Power good to FPGA (active high at this point, FGPA is active low, GPIO converts)
    uint8_t                 fault;              // Fault mask
    uint8_t                 input;              // Encoded input
    struct Sequencer_t*     pSequencer;         // Pointer to the sequencer
    enum PowerState_t       state;              // Power state
    enum PowerState_t       prevState;          // Previous state
};

extern const enum PowerState_t  PWR_TRANSITION_TABLE[16][PWR_NUM_STATES];
extern const uint8_t            PWR_VENABLE_LUT[];

void                            Power_init          ( struct Power_t* const, struct Sequencer_t* const );
void                            Power_getFault      ( struct Power_t* const );
void                            Power_getInput      ( struct Power_t* const );
void                            Power_process       ( struct Power_t* const );

uint8_t                         Power_getFeedback   ( struct Power_t* const );

#endif // __POWER_H
