#include "I2c.h"

#ifndef __SPI_H
#define __SPI_H

#define SPI_DEFAULT_BYTE 			0xA5
#define SPI_NUM_MSG_BYTES			32
#define SPI_PS1_OFFSET_BYTES		12

struct Spi_t {
	uint8_t 		ix;
	uint8_t*		pBuf;
};

void Spi_init( struct Spi_t* const, uint8_t* const );
inline void Spi_hwInit();
__interrupt void Spi_isr();
void Spi_getMessage( struct Spi_t* const, struct I2c_t* const );

#endif // __SPI_H
