#include "SysTime.h"

void SysTime_init(struct SysTime_t* const p)
{
	p->seconds = 0;
    p->ms = 0;
}

void SysTime_set(struct SysTime_t* const p, const struct SysTime_t* const pTime)
{
	p->seconds = pTime->seconds;
    p->ms = pTime->ms;
}

void SysTime_inc(struct SysTime_t* const p, const uint16_t ms)
{
    p->ms += ms;
	if ( p->ms > 999 ) {
		p->ms = p->ms % 1000;
        p->seconds++;
	}
}

struct SysTime_t SysTime_diff(const struct SysTime_t* const pNow, const struct SysTime_t* const pOld)
{
    struct SysTime_t diff;
    diff.seconds = pNow->seconds - pOld->seconds;
    diff.ms = pNow->ms - pOld->ms;
    if ( pOld->ms > pNow->ms ) {
        diff.seconds--;
        diff.ms+=1000;
    }
	return diff;
}

uint8_t SysTime_greaterThanOrEqual( const struct SysTime_t* const pLeft, const struct SysTime_t* const pRight )
{
    if ( pLeft->seconds > pRight->seconds ) {
        return 1;
    }
    if ( pLeft->seconds == pRight->seconds && pLeft->ms >= pRight->ms ) {
        return 1;
    }
    return 0;
}
