#include <stdint.h>

#ifndef __SYSTIME_H
#define __SYSTIME_H

#define TIMEOUT_IN_MS					11u

struct SysTime_t {
	uint32_t seconds;
    uint16_t ms;
};

void		        SysTime_init			(struct SysTime_t* const);
void		        SysTime_set				(struct SysTime_t* const, const struct SysTime_t* const);
void		        SysTime_inc				(struct SysTime_t* const, const uint16_t);
struct SysTime_t	SysTime_diff			(const struct SysTime_t* const, const struct SysTime_t* const);
uint8_t	            SysTime_isTimerExpired	(const struct SysTime_t* const, const struct SysTime_t* const, const struct SysTime_t* const);

#endif // __SYSTIME_H
