#include "globals.h"
#include "TimerA.h"

void TimerA_init()
{
#ifdef CLOCK_SPEED_1MHZ
	TACCR0 = 0x03E7;		// 1ms @ 1MHz clock
#endif
#ifdef CLOCK_SPEED_8MHZ
	TACCR0 = 0x1F3F;		// 1ms @ 8MHz clock
#endif
#ifdef CLOCK_SPEED_12MHZ
	TACCR0 = 0x2EDF;		// 1ms @ 12MHz clock
#endif
	TACCTL0 = CCIE;
	TACTL = TASSEL_2 + MC_1 + TACLR;
}

#pragma vector = TIMERA0_VECTOR
__interrupt void TimerA_isr(void)
{
	extern struct SysTime_t sysTime;
	extern uint32_t cTimerAIfg;
	cTimerAIfg++;
	sysTime.ms++;
	if ( sysTime.ms == 999 ) {
		sysTime.seconds++;
		sysTime.ms = 0;
	}
}
