#include "globals.h"
#include "TimerB.h"

#ifdef CLOCK_SPEED_1MHZ
const unsigned int TIMERB_COUNT = 2500;
#endif
#ifdef CLOCK_SPEED_8MHZ
const unsigned int TIMERB_COUNT = 20000;
#endif
#ifdef CLOCK_SPEED_12MHZ
const unsigned int TIMERB_COUNT = 30000;
#endif

void TimerB_init()
{
	TBCTL	|= 	TBCLR;
	TBCCTL0 = 	CCIE;           // TBCCR0 interrupt enabled
	TBCCR0 	= 	TIMERB_COUNT;
	TBCTL 	|= 	TBSSEL_2 +		// SMCLK source
			  	MC_1;			// Up mode
}

#pragma vector = TIMERB0_VECTOR
__interrupt void TimerB_isr(void)
{
	extern struct I2c_t i2c;
	extern uint32_t cTimerBIfg;
	extern uint8_t cI2c;
	cTimerBIfg++;
	cI2c++;
	if ( cI2c == 8 ) {
		i2c.cb = 0;
		cI2c = 0;
		UCB0I2CSA = I2C_SLAVE_ADDRESS[ i2c.ix ];
		UCB0CTL1 |= UCTXSTT;
	}
}
