#include <msp430.h>
#include "Spi.h"
#include "Power.h"
#include "SysTime.h"
#include "TimerA.h"
#include "TimerB.h"
#include "Gpio.h"
#include "globals.h"


struct SysTime_t sysTime;

struct Sequencer_t sequencer[2];

struct Power_t power[2];

struct Spi_t spi;
uint8_t spi_buf[SPI_NUM_MSG_BYTES];

struct I2c_t i2c;
uint8_t i2c_buf[I2C_SLAVE_BYTES];

uint8_t cI2c;							// Counts TimerB calls, 3 per I2C refresh
uint32_t cLoops;
uint32_t cTimerAIfg;
uint32_t cTimerBIfg;
uint32_t cI2cRxIfg;
uint32_t cI2cNackIfg;
uint32_t cSpiRxIfg;
uint32_t cSpiTxIfg;


void Clock_init();


void main()
{
//	uint8_t i = 0;
//	struct SysTime_t tick;
//
	Clock_init();
//	TimerA_init();
	Gpio_init();
//	SysTime_init( &sysTime );
//	for ( i = 0; i < 2; i++ ) {
//		Sequencer_init( sequencer + i );
//		Power_init( power + i, sequencer + i );
//	}
//	I2c_init( &i2c, i2c_buf );
	Spi_init( &spi, spi_buf );
//	TimerB_init();
	__bis_SR_register( GIE );

	while( 1 ) {
//		cLoops++;
//		tick.seconds = sysTime.seconds;
//		tick.ms = sysTime.ms;
//		for ( i = 0; i < 2; i++ ) {
//			Gpio_getEnableTable[i]( &power[i].enable );
//			Gpio_getFeedbackTable[i]( &sequencer[i].feedback );
//			Sequencer_process( sequencer+i, &tick );
//			Power_process( power+i );
//			Gpio_setEnableTable[i]( &sequencer[i].output );
//			Gpio_setFeedbackTable[i]( &power[i].good );
//		}
	}
}

void Clock_init()
{
	WDTCTL = WDTPW | WDTHOLD | WDTNMI;		// Stop the watchdog

#ifdef CLOCK_SPEED_1MHZ
	BCSCTL1 = CALBC1_1MHZ;
	DCOCTL 	= CALDCO_1MHZ;
#endif
#ifdef CLOCK_SPEED_8MHZ
	BCSCTL1 = CALBC1_8MHZ;
	DCOCTL  = CALDCO_8MHZ;
#endif
#ifdef CLOCK_SPEED_12MHZ
	BCSCTL1 = CALBC1_12MHZ;
	DCOCTL  = CALDCO_12MHZ;
#endif
	// 16MHz does not work reliably
}
