
-l msp430g2553.cmd
#include  "msp430g2553.h"
#include  "stdio.h"
#include  "string.h"
#include "stdlib.h"
#include "MSP430_LCD.h"

#define delay_value 500
unsigned char status = 0;

void main(void)
{
 WDTCTL = WDTPW + WDTHOLD;                 // Stop WDT

 // initialize the clock frequency and DCO frequency to 8MHz by setting BCSCTLx registers
 BCSCTL1 = CALBC1_8MHZ;
 DCOCTL = CALDCO_8MHZ; // Set DCO

 //obtain 2MHz clock frequency
 BCSCTL2 |=  DIVM_2  + SELM_0 + DIVS_2;               // SMCLK = MCLK = DCO/4 = 8M/4 = 2MHz

 // Making all the port2 pins as basic I/O functionality
 P2SEL = 0;
 P2SEL2 = 0;

    // define necessary input and output pins
 P2DIR = 0xF0;                            // make all port pins as output P2.7,P2.6,P2.5,P2.4 are LCD pins
 P1DIR |= 0xC7;                           // P1.5 - gas Sensor(input), P1.6 and P1.7 for LCD, P1.0 - LED output, P1.3 - Motor , P1.2 - Buzzer
 P1OUT = 0X00;
 P2OUT = 0x00;
 P1IE |= 0x20;                             // P1.5 interrupt enabled
 P1IES &= ~0x20;                            // P1.5 low to high edge
 P1IFG &= ~0x20;                           // P1.5 IFG cleared


 // LCD first time initialize code
 delayms(1500); // wait for more than 15ms after supply rises to 4.5V
 send_cmd(0x30);
 delayms(4000); // wait more than 4.1ms
 send_cmd(0x30);
 delayms(1000); // wait more than 100us, but delayms(1) will provide 1ms
 send_cmd(0x30);
 delayms(1000);

 send_cmd(0x02); // return to home
 delayms(1000);

 LCD_Init(); // LCD initialization
 delayms(500);


 send_cmd(0x01);
 delayms(delay_value);
 send_cmd(0x80);  // clear display
 delayms(delay_value);
 send_string("Fire Detection System:");
 delayms(60000);
 delayms(60000);
 __enable_interrupt(); // enable the global interrupt


 while(1)
 {

  if(status == 1)
  {
   P1OUT |= BIT2; // enable motor
   P1OUT |= BIT1; // buzzer motor
   send_cmd(0x01);
   delayms(delay_value);
   send_cmd(0x80);
   delayms(delay_value);
   send_string("Fire Detected!");
   delayms(60000);
   delayms(60000);

  }
  if(status == 0)
  {
   P1OUT &= ~BIT2; // enable motor
   P1OUT &= ~BIT1; // buzzer motor
   send_cmd(0x01);
   delayms(delay_value);
   send_cmd(0x80);
   delayms(delay_value);
   send_string("No Fire Detected!");
   delayms(60000);
   delayms(60000);



   //stop the timer
  }


 }// End of while

} // end of main


// Port 1 interrupt service routine
#pragma vector=PORT1_VECTOR
__interrupt void Port_1(void)
{
 P1OUT ^= 0x01;                            // P1.0 = toggle output,  it is just like a bench mark,
 //when P1OUT is 1, then motor will on otherwise it is off

 if(P1OUT & 0x01 == 0x01)
 {
  status = 1;   // Fire detected
  P1IES |= 0X20;  // Change the interrupt edge detection to high to low transition
 }
 else
 {
  status = 0;     // no Fire detected
  P1IES &= ~0X20; // Change the interrupt edge detection to low to high transition
 }

 P1IFG &= ~0x20;                           // P1.5 IFG cleared

}
