/* --COPYRIGHT--,BSD
 * Copyright (c) 2014, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * --/COPYRIGHT--*/

//*****************************************************************************
//
//! Applications.c
//
//! \version 1.00.06.02
//
//*****************************************************************************
#include <captivate.h>           // CapTIvate Touch Software Library
#include "CAPT_UserConfig.h"     // CapTIvate Auto-Generated User Configuration
#include "Applications.h"
#include "CAPT_BSP.h"

unsigned int Key_Value;

void
ButtonEventHandler(tSensor *pButton)
{
    Key_Value = 0;
    if(BTN00_E00.bTouch == 1) Key_Value |= Key1;
    if(BTN00_E01.bTouch == 1) Key_Value |= Key2;
    if(BTN00_E02.bTouch == 1) Key_Value |= Key3;
    if(BTN00_E03.bTouch == 1) Key_Value |= Key4;
    if(BTN00_E04.bTouch == 1) Key_Value |= Key5;
    if(BTN00_E05.bTouch == 1) Key_Value |= Key6;
}

void
Panel_Init()
{
    BTN00.pvCallback = &ButtonEventHandler;

    // Configure USCI_B0 for I2C mode
    UCB0CTLW0 = UCSWRST;                      // Software reset enabled
    UCB0CTLW0 |= UCMODE_3 | UCSYNC;           // I2C mode, sync mode
    UCB0I2COA0 = 0x01 | UCOAEN;               // own address is 0x01 + enable
    UCB0CTLW0 &= ~UCSWRST;                    // clear reset register
    UCB0IE |= UCRXIE0 | UCTXIE0 | UCSTPIE;    // transmit,stop interrupt enable
}


unsigned char TXData;
unsigned char RXData;

#if defined(__TI_COMPILER_VERSION__) || defined(__IAR_SYSTEMS_ICC__)
#pragma vector = USCI_B0_VECTOR
__interrupt void USCIB0_ISR(void)
#elif defined(__GNUC__)
void __attribute__ ((interrupt(USCI_B0_VECTOR))) USCIB0_ISR (void)
#else
#error Compiler not supported!
#endif
{
    switch(__even_in_range(UCB0IV, USCI_I2C_UCBIT9IFG))
    {
    case USCI_NONE: break;                  // Vector 0: No interrupts
    case USCI_I2C_UCALIFG: break;           // Vector 2: ALIFG
    case USCI_I2C_UCNACKIFG: break;         // Vector 4: NACKIFG
    case USCI_I2C_UCSTTIFG: break;          // Vector 6: STTIFG
    case USCI_I2C_UCSTPIFG:                 // Vector 8: STPIFG
        UCB0IFG &= ~UCSTPIFG;               // Clear stop condition int flag
        break;
    case USCI_I2C_UCRXIFG3: break;          // Vector 10: RXIFG3
    case USCI_I2C_UCTXIFG3: break;          // Vector 12: TXIFG3
    case USCI_I2C_UCRXIFG2: break;          // Vector 14: RXIFG2
    case USCI_I2C_UCTXIFG2: break;          // Vector 16: TXIFG2
    case USCI_I2C_UCRXIFG1: break;          // Vector 18: RXIFG1
    case USCI_I2C_UCTXIFG1: break;          // Vector 20: TXIFG1
    case USCI_I2C_UCRXIFG0:                 // Vector 22: RXIFG0
        RXData = UCB0RXBUF;
        if(RXData == 1) LED1_ON;
        else if(RXData == 2) LED2_ON;
        else
        {
            LED1_OFF;
            LED2_OFF;
        }
        break;
    case USCI_I2C_UCTXIFG0:
        UCB0TXBUF = Key_Value;
        break;                              // Vector 24: TXIFG0
    case USCI_I2C_UCBCNTIFG: break;         // Vector 26: BCNTIFG
    case USCI_I2C_UCCLTOIFG: break;         // Vector 28: clock low timeout
    case USCI_I2C_UCBIT9IFG: break;         // Vector 30: 9th bit
    default: break;
    }
}

