/*
 * timermgr.h
 *
 * Note to consumers of this library: Do not run these methods from within an interrupt context!
 *
 *  Created on: Nov 3, 2018
 *      Author: MichaelCress
 */

#ifndef TIMERMGR_H_
#define TIMERMGR_H_

typedef void (*TimerTaskFunc)( void* data );
struct TimerMgr;    //Forward decl

struct TimerMgr* InitTimerMgr();
void FreeTimerMgr( struct TimerMgr** Mgr );
void DoTick( struct TimerMgr* Mgr );
void DoTimer( struct TimerMgr* Mgr );
int InsertTimerTask( struct TimerMgr* Mgr, TimerTaskFunc TaskFuncPtr, void* Data, uint32_t DelayValue );

#endif /* TIMERMGR_H_ */
