#include <msp430.h> 
#include <stdint.h>

// Make sure bss is not empty
volatile unsigned long var_in_bss;

// ============================================================================
// Choose one value
// ============================================================================
// ----------------------------------------------------------------------------
// These break things when at 0x2000 if bss is not empty
// ----------------------------------------------------------------------------
volatile uint16_t myvar = 0x0540;
// volatile uint16_t myvar = 0x0340;
// volatile uint16_t myvar = 0x0040;
// volatile uint16_t myvar = 0x00140;
// volatile uint16_t myvar = 0x0940;
// volatile uint16_t myvar = 0x0F40;
// volatile uint16_t myvar = 0x0640;
// ----------------------------------------------------------------------------

// ----------------------------------------------------------------------------
// These all work fine
// ----------------------------------------------------------------------------
// volatile uint16_t myvar;
// volatile uint16_t myvar = 0x0000;
// volatile uint16_t myvar = 0x0001;
// volatile uint16_t myvar = 0x0100;
// volatile uint16_t myvar = 0x0539;
// volatile uint16_t myvar = 0x0541;
// volatile uint16_t myvar = 0x0041;
// volatile uint16_t myvar = 0x0080;
// volatile uint16_t myvar = 0x0020;
// volatile uint16_t myvar = 0x3640;
// volatile uint16_t myvar = 0x1140;
// ----------------------------------------------------------------------------
// ============================================================================


// Uncomment to fix by pusing myvar to address 0x2002 instead of 0x2000
// #define FIX_WITH_OTHER_VAR

#ifdef FIX_WITH_OTHER_VAR
    volatile uint16_t other_var = 0x0A;
#endif



void trick_compiler(void){
    // Make the compiler think all the globals are used even if they are not
    volatile int i = 0;
    if(i){
#ifdef FIX_WITH_OTHER_VAR
        other_var++;
#endif
        var_in_bss++;
        myvar++;
    }
}


// Blinks the LED for a visual indicator when the program works
int main(void){
	WDTCTL = WDTPW | WDTHOLD;
	PM5CTL0 &= ~LOCKLPM5;
    P1DIR |= BIT0;
    while(1){
        P1OUT ^= BIT0;
        volatile long i = 0;
        for(i = 10000; i > 0; --i);
    }
	return 0;
}
