// Lab6.c
// Runs on either MSP432 or TM4C123
// This version operates with the RTOS built in Lab 3
// Data streamed via Bluetooth to phone
// Starter project to Lab 6.  Take sensor readings, process the data,
// and output the results.  Specifically, this program will
// measure steps using the accelerometer, audio sound amplitude using
// the microphone, temperature using the TMP006, and light using the
// OPT3001.
// Daniel and Jonathan Valvano
// see GPIO.c file for hardware connections 
// September 10, 2016

/* This example accompanies the books
   "Embedded Systems: Real Time Interfacing to ARM Cortex M Microcontrollers",
   ISBN: 978-1463590154, Jonathan Valvano, copyright (c) 2016

   "Embedded Systems: Real-Time Operating Systems for ARM Cortex-M Microcontrollers",
   ISBN: 978-1466468863, Jonathan Valvano, copyright (c) 2016

   "Embedded Systems: Introduction to the MSP432 Microcontroller",
   ISBN: 978-1512185676, Jonathan Valvano, copyright (c) 2016

   "Embedded Systems: Real-Time Interfacing to the MSP432 Microcontroller",
   ISBN: 978-1514676585, Jonathan Valvano, copyright (c) 2016

 Copyright 2016 by Jonathan W. Valvano, valvano@mail.utexas.edu
    You may use, edit, run or distribute this file
    as long as the above copyright notice remains
 THIS SOFTWARE IS PROVIDED "AS IS".  NO WARRANTIES, WHETHER EXPRESS, IMPLIED
 OR STATUTORY, INCLUDING, BUT NOT LIMITED TO, IMPLIED WARRANTIES OF
 MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE APPLY TO THIS SOFTWARE.
 VALVANO SHALL NOT, IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL,
 OR CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
 For more information about my classes, my research, and my books, see
 http://users.ece.utexas.edu/~valvano/
 */

#include <stdint.h>
#include "../inc/BSP.h"
#include "../inc/CortexM.h"
#include "../inc/UART0.h"
#include "../inc/Profile.h"
#include "os.h"
#include "Texas.h"
#include "../inc/AP.h"
#include "AP_Lab6.h"

/* DriverLib Includes */
#include "..\msp432_driverlib_3_21_00_05\driverlib\MSP432P4xx\driverlib.h"


/* Timer_A PWM Configuration Parameter */
Timer_A_PWMConfig pwmConfig1 =
{
        TIMER_A_CLOCKSOURCE_SMCLK,
        TIMER_A_CLOCKSOURCE_DIVIDER_1, //
        32000,	// 32000 - 3200ms tick period ??									
        TIMER_A_CAPTURECOMPARE_REGISTER_1, // this will be configured to Timer A0.1 - Which is P2.4 (refer datasheet 126 table 6-45 and page 128 table 6-46. given as CCR1)
        TIMER_A_OUTPUTMODE_RESET_SET,
        3200
};

Timer_A_PWMConfig pwmConfig2 =
{
        TIMER_A_CLOCKSOURCE_SMCLK,
        TIMER_A_CLOCKSOURCE_DIVIDER_1, //
        10,
        TIMER_A_CAPTURECOMPARE_REGISTER_2, // this will be configured to Timer A0.2 - Which is P2.5 (refer datasheet 126 table 6-45 and page 128 table 6-46. given as CCR2)
        TIMER_A_OUTPUTMODE_RESET_SET,
        1 //10% duty cycle
};

Timer_A_PWMConfig pwmConfig3 =
{
        TIMER_A_CLOCKSOURCE_SMCLK,
        TIMER_A_CLOCKSOURCE_DIVIDER_1, //
        32000,	// 32000 - 3200ms tick period ??
        TIMER_A_CAPTURECOMPARE_REGISTER_3, // 
        TIMER_A_OUTPUTMODE_RESET_SET,
        3200 //10% duty cycle
};



// ********OutValue**********
// Debugging dump of a data value to virtual serial port to PC
// data shown as 1 to 8 hexadecimal characters
// Inputs:  response (number returned by last AP call)
// Outputs: none
void OutValue(char *label,uint32_t value){ 
  UART0_OutString(label);
  UART0_OutUHex(value);
}

int main(void){
		OS_Init();
		UART0_Init();
		OutValue("\n\rPWM Dutycycle =",0);
			
		/* Halting the watchdog */
		 MAP_WDT_A_holdTimer();
	  /* Configuring GPIO2.4 | GPIO2.5 as peripheral output for PWM  and P1.4 | P1.1 for button
     * interrupt */
//    MAP_GPIO_setAsPeripheralModuleFunctionOutputPin(GPIO_PORT_P2, GPIO_PIN4,
//            GPIO_PRIMARY_MODULE_FUNCTION);
						
//		P2SEL0 |= 0x10;
//		P1SEL1 &= ~0x10;                      // configure P2.4 as primary module function				
						
//		/* Configuring Timer_A to have a period of approximately 500ms and
//     * an initial duty cycle of 10% of that (3200 ticks)  */
//    MAP_Timer_A_generatePWM(TIMER_A0_BASE, &pwmConfig1);

  return 0;           
}

//void PORT1_IRQHandler(void)
//{
//    uint32_t status = MAP_GPIO_getEnabledInterruptStatus(GPIO_PORT_P1);
//    MAP_GPIO_clearInterruptFlag(GPIO_PORT_P1, status);

//    if (status & GPIO_PIN4)
//    {
//        if(pwmConfig1.dutyCycle == 28800)
//            pwmConfig1.dutyCycle = 3200;
//        else
//            pwmConfig1.dutyCycle += 3200;
//				
//				OutValue("\n\rPWM Dutycylce =",pwmConfig1.dutyCycle);

//        MAP_Timer_A_generatePWM(TIMER_A0_BASE, &pwmConfig1);
//    }
//}

