;/*****************************************************************************/
; OSasm.s: low-level OS commands, written in assembly                       */
; Runs on LM4F120/TM4C123/MSP432
; Lab 3 starter file
; March 2, 2016



        AREA |.text|, CODE, READONLY, ALIGN=2
        THUMB
        REQUIRE8
        PRESERVE8

        EXTERN  RunPt            ; currently running thread
        EXPORT  StartOS
        EXPORT  SysTick_Handler
        IMPORT  Scheduler


SysTick_Handler                ; 1) Saves R0-R3,R12,LR,PC,PSR
    CPSID   I                  ; 2) Prevent interrupt during switch
   ;YOU IMPLEMENT THIS (same as Lab 2)
	
	PUSH {R4-R11}			   ; 3) 8 registers are already saved. Save the reamining registers
	LDR R0,=RunPt
	LDR R1,[R0]
	STR SP,[R1]
	;LDR R1,[R1,#4]
	;STR R1,[R0] ; Updating the RunPt
	
	PUSH {R0,LR}
	BL Scheduler
	POP {R0,LR}
	LDR R1,[R0]
	LDR SP,[R1]	
	POP {R4-R11}
   
   
    CPSIE   I                  ; 9) tasks run with interrupts enabled
    BX      LR                 ; 10) restore R0-R3,R12,LR,PC,PSR

StartOS
   ;YOU IMPLEMENT THIS (same as Lab 2)
	CPSID   I                  ; 2) Prevent interrupt during switch
	LDR R0,=RunPt
	LDR R1,[R0]
	LDR SP,[R1]
	POP {R4-R11}
	POP {R0-R3}
	POP {R12}
	ADD SP,SP,#4
	POP {LR} ;Save the PC location of the TCB in the LR of CPU as a return address
	ADD SP,SP,#4

    CPSIE   I                  ; Enable interrupts at processor level
    BX      LR                 ; start first thread

    ALIGN
    END
