#include <msp430.h> 
#include "driverlib/MSP430F5xx_6xx/driverlib.h"
#include "userdefine.h"
#define ONE_EXACT_SECOND    16777216
#define EM_SMCLK_FREQ_IN_HZ                 (16777216)
void PORT_DEFINATION(void);
void InitSNMIVector(void);
void f_on(void);
void f_off(void);
void set_clk(uint32_t mclkFreq);
/**
 * main.c
 */
int main(void)
{
    WDTCTL = WDTPW | WDTHOLD;	// stop watchdog timer
    PORT_DEFINATION();
    //P5OUT = 0x00;
    //P4OUT = 0x00;
    //P2OUT = 0x00;
    InitSNMIVector();
    set_clk(EM_SMCLK_FREQ_IN_HZ);
    f_off();__delay_cycles(ONE_EXACT_SECOND);
	while(1)
	{
         f_on();__delay_cycles(ONE_EXACT_SECOND);
         f_off();__delay_cycles(ONE_EXACT_SECOND);
	}
	return 0;
}
void set_clk(uint32_t mclkFreq)
{
    PMM_setVCore(PMM_CORE_LEVEL_3);

    UCS_turnOnLFXT1(UCS_XT1_DRIVE_0, UCS_XCAP_0);

    UCS_initClockSignal(UCS_FLLREF,UCS_XT1CLK_SELECT,UCS_CLOCK_DIVIDER_1);

    UCS_initClockSignal(UCS_ACLK,UCS_XT1CLK_SELECT,UCS_CLOCK_DIVIDER_1);

    UCS_initFLLSettle(mclkFreq/1000,mclkFreq/32768);
}
#pragma vector=SYSNMI_VECTOR
__interrupt void sysNmiISR(void)
{
   // f_off();__delay_cycles(ONE_EXACT_SECOND);
    PMMIFG &= ~SVMHIFG;
    //WDTCTL = WDT_ARST_1000;
}
void InitSNMIVector(void)
{
    PMMCTL0_H = 0xA5;
    SVSMHCTL |= (SVMHE | (SVSMHRRL_3) | SVSHRVL_0 | SVMHFP);
    PMMRIE = SVMHIE;
    PMMCTL0_H = 0x00;
}
void f_on(void)
{
    P5OUT = 0x00;
    P4OUT = 0x00;
    P2OUT = 0x00;
}
void f_off(void)
{
    P5OUT = 0xff;
   P4OUT = 0xff;
   P2OUT = 0xFF;
}

void PORT_DEFINATION(void)
{
    // DIR mean Show the direction
    // 1 For OUTPUT
    // 0 For INPUT
    P7DIR |=SMUX_PIN;  // VOLATGE NETWORK SELCETION
    P7DIR |=PULSE_OUT;
    P5DIR |=CM1;
    P5DIR |=CM2;
    P5DIR |=CM3;
    P5DIR |=CM4;
    P5DIR |=CM5;
    P5DIR |=CM6;
    P5DIR |=CM7;
    P5DIR |=CM8;
    P4DIR |=CM9;
    P4DIR |=CM10;
    P4DIR |=CM11;
    P4DIR |=CM12;
    P4DIR |=CM13;

    // SEG PINS DEFENATION
    P2DIR |=SEG_A;
    P2DIR |=SEG_B;
    P2DIR |=SEG_C;
    P2DIR |=SEG_D;
    P2DIR |=SEG_E;
    P2DIR |=SEG_F;
    P2DIR |=SEG_G;
    P2DIR |=SEG_DP;

    // SWITCH Configuration
    P3DIR &= ~SW4;
    P3DIR &= ~SW5;
}
