/*
 * userdefine.h
 *
 *  Created on: 04-Dec-2021
 *      Author: softwaredept5
 */

#ifndef USERDEFINE_H_
#define USERDEFINE_H_



#define CM1     (1U << 7)   // PORT5
#define CM2     (1U << 6)   // PORT5
#define CM3     (1U << 5)   // PORT5
#define CM4     (1U << 4)   // PORT5
#define CM5     (1U << 3)   // PORT5
#define CM6     (1U << 2)   // PORT5
#define CM7     (1U << 1)   // PORT5
#define CM8     (1U << 0)   // PORT5
#define CM9     (1U << 7)   // PORT4
#define CM10    (1U << 6)   // PORT4
#define CM11    (1U << 5)   // PORT4
#define CM12    (1U << 4)   // PORT4
#define CM13    (1U << 3)   // PORT4 led purpose

#define SEG_A   (1U << 7)   // PORT2
#define SEG_B   (1U << 6)   // PORT2
#define SEG_C   (1U << 5)   // PORT2
#define SEG_D   (1U << 4)   // PORT2
#define SEG_E   (1U << 3)   // PORT2
#define SEG_F   (1U << 2)   // PORT2
#define SEG_G   (1U << 1)   // PORT2
#define SEG_DP  (1U << 0)   // PORT2
#define SMUX_PIN    (1U <<4) // PORT7
#define PULSE_OUT   (1U <<5) // PORT7

//////////////////// LED Configuration //////////////////////
#define KWH_LED         0B01111111
#define KVAH_LED        0B10111111
#define KVARH_LED       0B11011111
#define MODBUS_LED      0B11101111
#define PULSE_LED       0B11111110
///////////////////  INPUT CONFIGURATION  /////////////////
#define SW1     (1U << 2)   // PORT4
#define SW2     (1U << 1)   // PORT4
#define SW3     (1U << 0)   // PORT4
#define SW4     (1U << 7)   // PORT3
#define SW5     (1U << 6)   // PORT3

#define SET_KEY      (P4IN & SW1)
#define RESET_KEY    (P4IN & SW2)
#define SHIFT_KEY    (P4IN & SW3)
#define UP_KEY       (P3IN & SW4)
#define DOWN_KEY     (P3IN & SW5)


///////////////////  MENU PARAMETER   /////////////////////
#define KWH_HIGH        0
#define KWH_LOW         1
#define KW_HIGH_LOW     2
#define KWH_DP          3
#define KW_DP           4
#define CT_SELECTION    5
#define ADDRESS         6
#define BAUDRATE        7
#define PARITY          8
#define STOP_BIT        9
#define DATATYPE        10
#define RDFC            11
#define PULSE_ON_TIME   12
#define MODEL_SEL       13
#define MODBUS_LED_SEL  14
#define MAX             15

#define FOR_RX          0
#define FOR_TX          1

#define PASSWORD        20
#define RESET_PASSWORD  21
#define RESET_KWH       22
#define CAL_PASSWORD    23
#define DEVICE_OFF      24

#define YES             1
#define NO              0

#define NA              1111

////////// CALIBARTION PARAMETER ///////////
#define VOLTAGE_RN  21
#define VOLTAGE_YN  22
#define VOLTAGE_BN  23
#define VOLTAGE_RY  24
#define VOLTAGE_YB  25
#define VOLTAGE_BR  26
#define CURRENT_R   27
#define CURRENT_Y   28
#define CURRENT_B   29
#define ACTIVE_POWER_R  30
#define ACTIVE_POWER_Y  31
#define ACTIVE_POWER_B  32
#define REACTIVE_POWER_R    33
#define REACTIVE_POWER_Y    34
#define REACTIVE_POWER_B    35
#define APPERANT_POWER_R    36
#define APPERANT_POWER_Y    37
#define APPERANT_POWER_B    38
#define GAIN_CAL_OK         39
#define NEW_ACTIVE_POWER_R  40
#define NEW_ACTIVE_POWER_Y  41
#define NEW_ACTIVE_POWER_B  42
#define CAL_OK              43


#endif /* USERDEFINE_H_ */
